---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 116
  claims_with_evidence: 110
  claims_without_evidence: 6
confidence_derived: 0.95
---

# 根拠レポート：Component-EventDispatcher 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：110 / 116、根拠なし：6
- 優先レビュー（高）
  1. **UT-EVD-108**：型宣言からのイベント名自動解決 - getEventFromTypeDeclarationの内部動作の正確な検証が必要
  2. **UT-EVD-110**：メソッド名自動生成ロジック - preg_replace_callbackによる変換ルールの完全性
  3. **UT-EVD-113/114**：hotPath/noPreloadタグ付与 - ContainerBuilder内部動作との整合性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/EventDispatcher/EventDispatcher.php` - メインディスパッチャークラス（dispatch, addListener, removeListener, getListeners, getListenerPriority, hasListeners, addSubscriber, removeSubscriber, callListeners, sortListeners, optimizeListeners）
- E-02: `src/Symfony/Component/EventDispatcher/EventDispatcherInterface.php` - ディスパッチャーインターフェース定義
- E-03: `src/Symfony/Component/EventDispatcher/EventSubscriberInterface.php` - サブスクライバーインターフェース定義（getSubscribedEventsの3形式）
- E-04: `src/Symfony/Component/EventDispatcher/GenericEvent.php` - 汎用イベントクラス（ArrayAccess, IteratorAggregate実装）
- E-05: `src/Symfony/Component/EventDispatcher/ImmutableEventDispatcher.php` - 読み取り専用ディスパッチャー（BadMethodCallException）
- E-06: `src/Symfony/Component/EventDispatcher/Attribute/AsEventListener.php` - PHP Attribute定義（TARGET_CLASS, TARGET_METHOD, IS_REPEATABLE）
- E-07: `src/Symfony/Component/EventDispatcher/Debug/TraceableEventDispatcher.php` - デバッグ用ディスパッチャー（Stopwatch計測, WrappedListener管理, orphanedEvents追跡）
- E-08: `src/Symfony/Component/EventDispatcher/Debug/WrappedListener.php` - ラップリスナー（呼び出し追跡, 伝播停止検知, Stopwatch計測）
- E-09: `src/Symfony/Component/EventDispatcher/DependencyInjection/AddEventAliasesPass.php` - イベントエイリアス登録コンパイラパス
- E-10: `src/Symfony/Component/EventDispatcher/DependencyInjection/RegisterListenersPass.php` - リスナー/サブスクライバー登録コンパイラパス（hotPath, noPreload, エイリアス対応）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-EVD-001) | EventDispatcher::dispatchがリスナーを呼び出しイベントを返却する | E-01 (L45-60) | ○ |
| C-02 (UT-EVD-002) | eventName省略時にイベントクラス名が使用される | E-01 (L47) | ○ |
| C-03 (UT-EVD-003) | リスナー未登録時にイベントがそのまま返却される | E-01 (L49-59) | ○ |
| C-04 (UT-EVD-004) | StoppableEventで伝播が停止される | E-01 (L200-207) | ○ |
| C-05 (UT-EVD-005) | 優先度順にリスナーが呼び出される | E-01 (L213-227) | ○ |
| C-06 (UT-EVD-006) | addListenerでリスナーが登録される | E-01 (L126-130) | ○ |
| C-07 (UT-EVD-007) | 優先度指定でリスナーが登録される | E-01 (L126-130) | ○ |
| C-08 (UT-EVD-008) | 同一イベントに複数リスナー登録可能 | E-01 (L128) | ○ |
| C-09 (UT-EVD-009) | removeListenerでリスナーが削除される | E-01 (L132-158) | ○ |
| C-10 (UT-EVD-010) | 未登録イベントのremoveListenerでエラーなし | E-01 (L134-136) | ○ |
| C-11 (UT-EVD-011) | Closureリスナーの削除 | E-01 (L149) | ○ |
| C-12 (UT-EVD-012) | lazy Closureリスナーの削除 | E-01 (L138-141, L145-148) | ○ |
| C-13 (UT-EVD-013) | 特定イベントのリスナー取得 | E-01 (L62-73) | ○ |
| C-14 (UT-EVD-014) | 全イベントのリスナー取得 | E-01 (L76-83) | ○ |
| C-15 (UT-EVD-015) | 優先度順にソートされたリスナー返却 | E-01 (L213-227) | ○ |
| C-16 (UT-EVD-016) | 未登録イベントで空配列返却 | E-01 (L65-67) | ○ |
| C-17 (UT-EVD-017) | getListenerPriorityで優先度取得 | E-01 (L85-109) | ○ |
| C-18 (UT-EVD-018) | 未登録リスナーでnull返却 | E-01 (L108) | ○ |
| C-19 (UT-EVD-019) | 未登録イベントでnull返却 | E-01 (L87-89) | ○ |
| C-20 (UT-EVD-020) | hasListenersでtrue返却 | E-01 (L111-114) | ○ |
| C-21 (UT-EVD-021) | hasListenersでfalse返却 | E-01 (L114) | ○ |
| C-22 (UT-EVD-022) | eventName=nullで全イベント横断確認 | E-01 (L116-123) | ○ |
| C-23 (UT-EVD-023) | リスナー完全不在でfalse返却 | E-01 (L116-123) | ○ |
| C-24 (UT-EVD-024) | addSubscriber（文字列形式） | E-01 (L160-173), E-03 (L27-48) | ○ |
| C-25 (UT-EVD-025) | addSubscriber（配列形式） | E-01 (L165-166), E-03 (L34) | ○ |
| C-26 (UT-EVD-026) | addSubscriber（複数リスナー形式） | E-01 (L167-170), E-03 (L35-36) | ○ |
| C-27 (UT-EVD-027) | removeSubscriber | E-01 (L175-186) | ○ |
| C-28 (UT-EVD-028) | 複数リスナー形式のサブスクライバー削除 | E-01 (L178-180) | ○ |
| C-29 (UT-EVD-029) | callListenersの引数確認 | E-01 (L198-208) | ○ |
| C-30 (UT-EVD-030) | GenericEvent コンストラクタ（引数あり） | E-04 (L34-38) | ○ |
| C-31 (UT-EVD-031) | GenericEvent コンストラクタ（引数なし） | E-04 (L35-36) | ○ |
| C-32 (UT-EVD-032) | getSubject | E-04 (L43-46) | ○ |
| C-33 (UT-EVD-033) | getArgument（正常） | E-04 (L53-60) | ○ |
| C-34 (UT-EVD-034) | getArgument（異常：存在しないキー） | E-04 (L59) | ○ |
| C-35 (UT-EVD-035) | setArgument | E-04 (L67-72) | ○ |
| C-36 (UT-EVD-036) | setArgument fluent interface | E-04 (L67, L71) | ○ |
| C-37 (UT-EVD-037) | getArguments | E-04 (L77-80) | ○ |
| C-38 (UT-EVD-038) | getArguments（空配列） | E-04 (L77-80) | ○ |
| C-39 (UT-EVD-039) | setArguments | E-04 (L87-92) | ○ |
| C-40 (UT-EVD-040) | setArguments上書き | E-04 (L89) | ○ |
| C-41 (UT-EVD-041) | hasArgument（存在） | E-04 (L97-100) | ○ |
| C-42 (UT-EVD-042) | hasArgument（不在） | E-04 (L99) | ○ |
| C-43 (UT-EVD-043) | offsetGet | E-04 (L109-112) | ○ |
| C-44 (UT-EVD-044) | offsetGet（異常） | E-04 (L111) | ○ |
| C-45 (UT-EVD-045) | offsetSet | E-04 (L119-122) | ○ |
| C-46 (UT-EVD-046) | offsetUnset | E-04 (L129-134) | ○ |
| C-47 (UT-EVD-047) | offsetUnset（存在しないキー） | E-04 (L131) | ○ |
| C-48 (UT-EVD-048) | offsetExists | E-04 (L141-144) | ○ |
| C-49 (UT-EVD-049) | getIterator | E-04 (L151-154) | ○ |
| C-50 (UT-EVD-050) | getIterator（空） | E-04 (L153) | ○ |
| C-51 (UT-EVD-051) | ImmutableEventDispatcher::dispatch委譲 | E-05 (L26-29) | ○ |
| C-52 (UT-EVD-052) | ImmutableEventDispatcher::addListener例外 | E-05 (L31-34) | ○ |
| C-53 (UT-EVD-053) | ImmutableEventDispatcher::addSubscriber例外 | E-05 (L36-39) | ○ |
| C-54 (UT-EVD-054) | ImmutableEventDispatcher::removeListener例外 | E-05 (L41-44) | ○ |
| C-55 (UT-EVD-055) | ImmutableEventDispatcher::removeSubscriber例外 | E-05 (L46-49) | ○ |
| C-56 (UT-EVD-056) | ImmutableEventDispatcher::getListeners委譲 | E-05 (L51-54) | ○ |
| C-57 (UT-EVD-057) | ImmutableEventDispatcher::getListenerPriority委譲 | E-05 (L56-59) | ○ |
| C-58 (UT-EVD-058) | ImmutableEventDispatcher::hasListeners委譲 | E-05 (L61-64) | ○ |
| C-59 (UT-EVD-059) | AsEventListenerデフォルト値 | E-06 (L28-34) | ○ |
| C-60 (UT-EVD-060) | AsEventListener全プロパティ指定 | E-06 (L28-34) | ○ |
| C-61 (UT-EVD-061) | AsEventListenerクラスAttribute適用 | E-06 (L19) | ○ |
| C-62 (UT-EVD-062) | AsEventListenerメソッドAttribute適用 | E-06 (L19) | ○ |
| C-63 (UT-EVD-063) | AsEventListener IS_REPEATABLE | E-06 (L19) | ○ |
| C-64 (UT-EVD-064) | TraceableEventDispatcher Stopwatch計測 | E-07 (L124-131) | ○ |
| C-65 (UT-EVD-065) | TraceableEventDispatcher disabled状態 | E-07 (L107-109) | ○ |
| C-66 (UT-EVD-066) | TraceableEventDispatcher 停止済みイベントのログ | E-07 (L116-118) | ○ |
| C-67 (UT-EVD-067) | TraceableEventDispatcher::addListener委譲 | E-07 (L50-53) | ○ |
| C-68 (UT-EVD-068) | TraceableEventDispatcher::addSubscriber委譲 | E-07 (L55-58) | ○ |
| C-69 (UT-EVD-069) | TraceableEventDispatcher::removeListener wrappedリスナー | E-07 (L60-73) | ○ |
| C-70 (UT-EVD-070) | TraceableEventDispatcher::removeSubscriber委譲 | E-07 (L75-78) | ○ |
| C-71 (UT-EVD-071) | TraceableEventDispatcher::getListeners委譲 | E-07 (L80-83) | ○ |
| C-72 (UT-EVD-072) | TraceableEventDispatcher::getListenerPriority wrappedリスナー | E-07 (L85-98) | ○ |
| C-73 (UT-EVD-073) | TraceableEventDispatcher::hasListeners委譲 | E-07 (L100-103) | ○ |
| C-74 (UT-EVD-074) | getCalledListeners | E-07 (L143-159) | ○ |
| C-75 (UT-EVD-075) | getCalledListeners（callStack=null） | E-07 (L145-147) | ○ |
| C-76 (UT-EVD-076) | getNotCalledListeners | E-07 (L161-201) | ○ |
| C-77 (UT-EVD-077) | getNotCalledListeners（Request指定） | E-07 (L172, L179) | ○ |
| C-78 (UT-EVD-078) | getOrphanedEvents | E-07 (L203-214) | ○ |
| C-79 (UT-EVD-079) | getOrphanedEvents（空） | E-07 (L209-211) | ○ |
| C-80 (UT-EVD-080) | reset | E-07 (L216-221) | ○ |
| C-81 (UT-EVD-081) | __call委譲 | E-07 (L229-232) | ○ |
| C-82 (UT-EVD-082) | WrappedListener 配列形式リスナー | E-08 (L44-47) | ○ |
| C-83 (UT-EVD-083) | WrappedListener Closureリスナー | E-08 (L48-57) | ○ |
| C-84 (UT-EVD-084) | WrappedListener 文字列リスナー | E-08 (L58-59) | ○ |
| C-85 (UT-EVD-085) | WrappedListener name上書き | E-08 (L66-68) | ○ |
| C-86 (UT-EVD-086) | getWrappedListener | E-08 (L73-76) | ○ |
| C-87 (UT-EVD-087) | wasCalled初期状態 | E-08 (L27, L78-81) | ○ |
| C-88 (UT-EVD-088) | wasCalled呼び出し後 | E-08 (L109, L78-81) | ○ |
| C-89 (UT-EVD-089) | stoppedPropagation（false） | E-08 (L28, L83-86) | ○ |
| C-90 (UT-EVD-090) | stoppedPropagation（true） | E-08 (L122-124, L83-86) | ○ |
| C-91 (UT-EVD-091) | getPretty（配列リスナー） | E-08 (L46, L88-91) | ○ |
| C-92 (UT-EVD-092) | getPretty（Closure） | E-08 (L51, L88-91) | ○ |
| C-93 (UT-EVD-093) | getInfo | E-08 (L93-103) | ○ |
| C-94 (UT-EVD-094) | __invoke Stopwatch計測 | E-08 (L105-125) | ○ |
| C-95 (UT-EVD-095) | __invoke 元リスナー呼び出し | E-08 (L115) | ○ |
| C-96 (UT-EVD-096) | __invoke 例外時のStopwatch停止 | E-08 (L116-120) | ○ |
| C-97 (UT-EVD-097) | AddEventAliasesPass コンストラクタ | E-09 (L24-26) | ○ |
| C-98 (UT-EVD-098) | AddEventAliasesPass マージ処理 | E-09 (L29-37) | ○ |
| C-99 (UT-EVD-099) | AddEventAliasesPass 新規設定 | E-09 (L31) | ○ |
| C-100 (UT-EVD-100) | setHotPathEvents | E-10 (L34-39) | ○ |
| C-101 (UT-EVD-101) | setHotPathEvents fluent interface | E-10 (L38) | ○ |
| C-102 (UT-EVD-102) | setNoPreloadEvents | E-10 (L44-49) | ○ |
| C-103 (UT-EVD-103) | process リスナー登録 | E-10 (L65-123) | ○ |
| C-104 (UT-EVD-104) | process サブスクライバー登録 | E-10 (L127-175) | ○ |
| C-105 (UT-EVD-105) | process event_dispatcher未定義ガード | E-10 (L53-55) | ○ |
| C-106 (UT-EVD-106) | process EventSubscriberInterface未実装エラー | E-10 (L136-138) | ○ |
| C-107 (UT-EVD-107) | process クラス未発見エラー | E-10 (L133-135) | ○ |
| C-108 (UT-EVD-108) | 型宣言からのイベント名自動解決 | E-10 (L181-212) | △ |
| C-109 (UT-EVD-109) | 型推定不可時のエラー | E-10 (L190-191, L207-209) | △ |
| C-110 (UT-EVD-110) | メソッド名自動生成 | E-10 (L91-96) | △ |
| C-111 (UT-EVD-111) | __invokeへのフォールバック | E-10 (L97-103) | △ |
| C-112 (UT-EVD-112) | メソッド不在時のエラー | E-10 (L98-99) | ○ |
| C-113 (UT-EVD-113) | hotPathタグ付与 | E-10 (L113-114) | △ |
| C-114 (UT-EVD-114) | noPreloadタグ付与 | E-10 (L115-122) | △ |
| C-115 (UT-EVD-115) | カスタムディスパッチャー指定 | E-10 (L107-109) | ○ |
| C-116 (UT-EVD-116) | イベントエイリアス適用 | E-10 (L57-61, L82) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-EVD-108/109**: `getEventFromTypeDeclaration`はReflectionを使用して型宣言からイベント名を解決するが、ContainerBuilderのgetReflectionClassの動作やReflectionUnionTypeの具体的な挙動は実行環境依存であり、コードからの静的解析では完全に検証できない
  - 候補：実際のContainerBuilderを使用した統合テスト / PHPリフレクションAPIのドキュメント
- **UT-EVD-110/111**: preg_replace_callbackによるメソッド名自動生成の変換パターンは複雑であり、全てのエッジケースをコードだけから推定するのは困難
  - 候補：Symfony公式ドキュメントの命名規約 / 既存テストケース
- **UT-EVD-113/114**: ContainerBuilder::getDefinition()->addTag()の内部動作はDependencyInjectionコンポーネントに依存
  - 候補：Component-DependencyInjectionのソースコード / Symfonyコンパイラパスのドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: EventDispatcher, GenericEvent, ImmutableEventDispatcher, AsEventListener - コードが明確で根拠が十分
- 1: TraceableEventDispatcher, WrappedListener - Stopwatchやログのモック依存があるが、コード自体は明確
- 1: RegisterListenersPass - ContainerBuilderとの統合が必要で、テストケースの前提条件がやや複雑
- 0: AddEventAliasesPass - シンプルなロジックで根拠十分

## 6) レビュアーチェックリスト（最小）
- [ ] EventDispatcherの優先度ソート（krsort）の方向が正しいか確認（高い優先度が先に実行される）
- [ ] StoppableEventInterfaceの伝播停止がdispatch内のcallListenersで正しくチェックされているか確認
- [ ] ImmutableEventDispatcherの全変更メソッドがBadMethodCallExceptionをスローすることを確認
- [ ] GenericEventのArrayAccess/IteratorAggregateインターフェース実装のテストが網羅的か確認
- [ ] RegisterListenersPassのgetEventFromTypeDeclarationのReflectionUnionType対応テストが十分か確認
- [ ] TraceableEventDispatcherのpreProcess/postProcessによるリスナーラップ・アンラップのテストが正しいか確認
- [ ] WrappedListenerの__invokeにおけるfinally句でのStopwatch停止保証テストが適切か確認
