---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 228
  claims_with_evidence: 224
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：Component-ExpressionLanguage 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：224 / 228、根拠なし：4
- 優先レビュー（高）
  1. **UT-EXL-022/023 (enum関数テスト)**：実行時にUnitEnum定義が必要であり、テスト環境構築の詳細が不明
  2. **UT-EXL-173/174 (短絡評価テスト)**：短絡評価の検証方法（右辺の未評価確認）について実装詳細が必要
  3. **UT-EXL-012 (キャッシュテスト)**：キャッシュヒットの検証方法の実装詳細が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/ExpressionLanguage/ExpressionLanguage.php` - メインファサードクラス
- E-02: `src/Symfony/Component/ExpressionLanguage/Expression.php` - 式表現クラス
- E-03: `src/Symfony/Component/ExpressionLanguage/ExpressionFunction.php` - 関数定義クラス
- E-04: `src/Symfony/Component/ExpressionLanguage/ExpressionFunctionProviderInterface.php` - プロバイダインターフェース
- E-05: `src/Symfony/Component/ExpressionLanguage/Lexer.php` - 字句解析器
- E-06: `src/Symfony/Component/ExpressionLanguage/Parser.php` - 構文解析器
- E-07: `src/Symfony/Component/ExpressionLanguage/Compiler.php` - コンパイラ
- E-08: `src/Symfony/Component/ExpressionLanguage/Token.php` - トークン
- E-09: `src/Symfony/Component/ExpressionLanguage/TokenStream.php` - トークンストリーム
- E-10: `src/Symfony/Component/ExpressionLanguage/ParsedExpression.php` - パース済み式
- E-11: `src/Symfony/Component/ExpressionLanguage/SerializedParsedExpression.php` - シリアライズ済みパース式
- E-12: `src/Symfony/Component/ExpressionLanguage/SyntaxError.php` - 構文エラー
- E-13: `src/Symfony/Component/ExpressionLanguage/Node/Node.php` - ASTノード基底クラス
- E-14: `src/Symfony/Component/ExpressionLanguage/Node/ConstantNode.php` - 定数ノード
- E-15: `src/Symfony/Component/ExpressionLanguage/Node/BinaryNode.php` - 二項演算ノード
- E-16: `src/Symfony/Component/ExpressionLanguage/Node/UnaryNode.php` - 単項演算ノード
- E-17: `src/Symfony/Component/ExpressionLanguage/Node/ConditionalNode.php` - 条件ノード
- E-18: `src/Symfony/Component/ExpressionLanguage/Node/NameNode.php` - 変数名ノード
- E-19: `src/Symfony/Component/ExpressionLanguage/Node/FunctionNode.php` - 関数ノード
- E-20: `src/Symfony/Component/ExpressionLanguage/Node/ArrayNode.php` - 配列ノード
- E-21: `src/Symfony/Component/ExpressionLanguage/Node/ArgumentsNode.php` - 引数ノード
- E-22: `src/Symfony/Component/ExpressionLanguage/Node/GetAttrNode.php` - 属性アクセスノード
- E-23: `src/Symfony/Component/ExpressionLanguage/Node/NullCoalesceNode.php` - null合体ノード
- E-24: `src/Symfony/Component/ExpressionLanguage/Node/NullCoalescedNameNode.php` - null合体変数名ノード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExpressionLanguageのコンストラクタはcache=nullでArrayAdapterを使用する | E-01 (L39: `$this->cache = $cache ?? new ArrayAdapter()`) | ○ |
| C-02 | ExpressionLanguageのコンストラクタはプロバイダの関数を登録する | E-01 (L41-43: foreachでregisterProvider呼び出し) | ○ |
| C-03 | compile()は式をPHPコードにコンパイルする | E-01 (L49-52: getCompiler()->compile()->getSource()) | ○ |
| C-04 | evaluate()は式を評価して結果を返す | E-01 (L57-59: parse()->getNodes()->evaluate()) | ○ |
| C-05 | parse()はParsedExpressionを受け取った場合そのまま返す | E-01 (L69-71: instanceof ParsedExpression チェック) | ○ |
| C-06 | parse()はキャッシュを利用する | E-01 (L80-88: cache->getItem, cache->save) | ○ |
| C-07 | lint()はParsedExpressionの場合早期リターンする | E-01 (L103-105: instanceof ParsedExpression チェック) | ○ |
| C-08 | register()はparser設定後にLogicExceptionをスローする | E-01 (L122-124: isset($this->parser) チェック) | ○ |
| C-09 | registerFunctions()はconstant, min, max, enumを登録する | E-01 (L143-159: basicPhpFunctions配列とenum登録) | ○ |
| C-10 | enum関数は非UnitEnumに対してTypeErrorをスローする | E-01 (L150-158: instanceof UnitEnum チェック) | ○ |
| C-11 | Expressionの__toString()は式文字列を返す | E-02 (L29-32: return $this->expression) | ○ |
| C-12 | ExpressionFunction::fromPhp()は存在しない関数でInvalidArgumentExceptionをスローする | E-03 (L77-79: function_exists チェック) | ○ |
| C-13 | ExpressionFunction::fromPhp()は名前空間関数で式関数名未指定時にInvalidArgumentExceptionをスローする | E-03 (L82-84: count($parts) > 1 チェック) | ○ |
| C-14 | Lexerのtokenize()は数値・文字列・演算子・名前・括弧をトークン化する | E-05 (L26-109: 各種正規表現マッチング) | ○ |
| C-15 | Lexerは不正文字でSyntaxErrorをスローする | E-05 (L97: Unexpected character) | ○ |
| C-16 | Lexerは括弧の不整合でSyntaxErrorをスローする | E-05 (L57-63, L103-106: brackets チェック) | ○ |
| C-17 | Lexerは?.と??をPUNCTUATION_TYPEとしてトークン化する | E-05 (L79-86: null-safe/null-coalescing検出) | ○ |
| C-18 | Lexerはコメントをスキップする | E-05 (L72-74: /\*.*?\*/ マッチング) | ○ |
| C-19 | Compilerのreset()はソースを空にして自身を返す | E-07 (L47-51: source='' return $this) | ○ |
| C-20 | Compilerのsubcompile()はメインソースに影響せず結果を返す | E-07 (L65-76: current保存/復元ロジック) | ○ |
| C-21 | Compilerのrepr()は各型を正しくPHP表現する | E-07 (L108-133: 型判定ロジック) | ○ |
| C-22 | Token::test()はtypeとvalueの一致をチェックする | E-08 (L50-53: type===type && value==value) | ○ |
| C-23 | TokenStream::next()は末尾超過でSyntaxErrorをスローする | E-09 (L43-51: !isset チェック) | ○ |
| C-24 | TokenStream::expect()は不一致でSyntaxErrorをスローする | E-09 (L57-64: !test チェック) | ○ |
| C-25 | TokenStream::isEOF()はEOF_TYPEでtrueを返す | E-09 (L69-72: type===EOF_TYPE) | ○ |
| C-26 | ParsedExpression::getNodes()は設定されたNodeを返す | E-10 (L30-33: return $this->nodes) | ○ |
| C-27 | SerializedParsedExpression::getNodes()はunserializeして返す | E-11 (L34-37: unserialize($this->nodes)) | ○ |
| C-28 | SyntaxErrorはlevenshtein距離でDid you mean提案する | E-12 (L24-37: levenshtein計算とguess判定) | ○ |
| C-29 | Parserは単項/二項演算子の優先順位を持つ | E-06 (L41-81: unaryOperators/binaryOperators配列) | ○ |
| C-30 | Parser::parse()はdoParse()を呼び出す | E-06 (L101-104: return $this->doParse()) | ○ |
| C-31 | Parser::doParse()はEOFでない場合SyntaxErrorをスローする | E-06 (L133-135: !isEOF() チェック) | ○ |
| C-32 | Parser::parsePrimaryExpression()はtrue/false/nullリテラルをConstantNodeに変換する | E-06 (L224-234: NAME_TYPEのswitch) | ○ |
| C-33 | Parser::parsePrimaryExpression()は未定義変数でSyntaxErrorをスローする | E-06 (L244-251: !in_array チェック) | ○ |
| C-34 | Parser::parsePrimaryExpression()は未定義関数でSyntaxErrorをスローする | E-06 (L238-240: false===isset チェック) | ○ |
| C-35 | Parser::parsePrimaryExpression()は未定義変数+??でNullCoalescedNameNodeを返す | E-06 (L246-248: test('??') チェック) | ○ |
| C-36 | Parser::parseArrayExpression()は末尾カンマを許容する | E-06 (L296-299: trailing , チェック) | ○ |
| C-37 | Parser::parseHashExpression()は無効なキーでSyntaxErrorをスローする | E-06 (L338-341: else throw) | ○ |
| C-38 | Parser::parsePostfixExpression()は.後のnull-safeアクセスを処理する | E-06 (L358-406: ?. チェックとisNullSafe) | ○ |
| C-39 | Parser::parseConditionalExpression()は??をNullCoalesceNodeに変換する | E-06 (L188-193: test('??') チェック) | ○ |
| C-40 | BinaryNode::evaluate()は各算術/比較/論理/ビット演算子を処理する | E-15 (L102-181: operator別switch) | ○ |
| C-41 | BinaryNode::evaluate()は/で0除算時DivisionByZeroErrorをスローする | E-15 (L166-168: 0==right チェック) | ○ |
| C-42 | BinaryNode::evaluate()は%で0除算時DivisionByZeroErrorをスローする | E-15 (L173-175: 0==right チェック) | ○ |
| C-43 | BinaryNode::evaluate()のmatchesは不正正規表現でSyntaxErrorをスローする | E-15 (L189-197: set_error_handler) | ○ |
| C-44 | BinaryNode::evaluate()のor/andは短絡評価を行う | E-15 (L118-126: left先行評価、右辺は条件付き) | ○ |
| C-45 | UnaryNode::evaluate()は各単項演算子を正しく評価する | E-16 (L49-59: match式) | ○ |
| C-46 | ConditionalNode::evaluate()は条件に応じてexpr2/expr3を返す | E-17 (L43-49: if/else分岐) | ○ |
| C-47 | NameNode::evaluate()はvaluesから変数値を返す | E-18 (L36-39: return $values[$name]) | ○ |
| C-48 | FunctionNode::evaluate()はevaluatorを呼び出す | E-19 (L43-51: functions[$name]['evaluator']呼び出し) | ○ |
| C-49 | GetAttrNode::evaluate()はPROPERTY/METHOD/ARRAY_CALLを処理する | E-22 (L85-151: type別switch) | ○ |
| C-50 | GetAttrNode::evaluate()は非オブジェクトにRuntimeExceptionをスローする | E-22 (L100-101, L124-125: !is_object チェック) | ○ |
| C-51 | GetAttrNode::evaluate()は呼び出し不可メソッドにRuntimeExceptionをスローする | E-22 (L127-129: !is_callable チェック) | ○ |
| C-52 | GetAttrNode::convertToArrayAccess()は型に応じた変換を行う | E-22 (L157-172: null/array/ArrayAccess/else分岐) | ○ |
| C-53 | NullCoalesceNode::evaluate()はexpr1??expr2を評価する | E-23 (L39-45: ?? 演算) | ○ |
| C-54 | NullCoalescedNameNode::evaluate()は常にnullを返す | E-24 (L36-39: return null) | ○ |
| C-55 | enum関数のテスト環境でUnitEnum定義が必要 | **根拠なし** | △ |
| C-56 | 短絡評価の右辺未評価を検証する方法 | **根拠なし** | △ |
| C-57 | キャッシュヒットの検証方法の具体的実装 | **根拠なし** | △ |
| C-58 | Parser::parsePostfixExpression()で非null-safe時のドット後の角括弧はSyntaxErrorになる | E-06 (L363-365: !isNullSafe throw) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-55: enum関数のテストにはUnitEnum実装（PHP 8.1+のenum定義）が必要だが、テスト環境の具体的なenum定義はコード内に含まれない
  - 候補：テスト用のenumクラスの定義 / 既存のPHP標準enumの利用
- C-56: or/andの短絡評価でright側が評価されないことの検証は、副作用を持つモックを使用するなど実装レベルの工夫が必要
  - 候補：副作用追跡のモックノード / evaluateの呼び出し回数カウント
- C-57: キャッシュヒットの確認はCacheItemPoolInterfaceのモックまたはスパイが必要
  - 候補：モックキャッシュの利用 / ArrayAdapterの内部状態確認

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全テストケースのソースコード根拠は確認済み。テスト対象のpublicメソッドは網羅されている。
- 1（中リスク）：enum関数テスト（UT-EXL-022/023）はテスト環境にUnitEnum定義が必要。PHPバージョン依存あり。
- 1（中リスク）：BinaryNodeの演算子テスト（UT-EXL-157～174）は多数の演算子を個別にテストする必要があり、テストケース数が多い。

## 6) レビュアーチェックリスト（最小）
- [ ] 全publicメソッドに対してテストケースが存在するか確認
- [ ] 正常系・異常系・境界値の各観点がバランスよくカバーされているか
- [ ] SyntaxErrorがスローされるべきケースが漏れなく列挙されているか
- [ ] BinaryNodeの全演算子（34種）に対するテストが網羅されているか
- [ ] null-safe演算子（?.）とnull合体演算子（??）の各ノードタイプでのテストが含まれているか
- [ ] GetAttrNodeの3種のアクセスタイプ（PROPERTY/METHOD/ARRAY）ごとの正常系・異常系が含まれているか
- [ ] enum関数テストの実行環境要件（PHP 8.1+、UnitEnum定義）が適切に文書化されているか
