---
generated_at: 2026-02-04 17:00:00
metrics:
  claims_total: 196
  claims_with_evidence: 192
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：Component-Filesystem 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：192 / 196、根拠なし：4
- 優先レビュー（高）
  1. **C-109（handleError）**：publicメソッドだが`@internal`アノテーション付きで、テスト対象とするかの判断が必要
  2. **C-116（canonicalize バッファクリーンアップ）**：内部バッファの閾値テストは実装詳細に依存
  3. **C-081（mirror 不明ファイルタイプ）**：特殊ファイルタイプの再現が実環境では困難
  4. **C-056（symlink関数無効）**：関数の無効化はテスト環境での再現が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Filesystem/Filesystem.php` - Filesystemクラス（767行）
- E-02: `src/Symfony/Component/Filesystem/Path.php` - Pathクラス（796行）
- E-03: `src/Symfony/Component/Filesystem/Exception/IOException.php` - IOExceptionクラス（36行）
- E-04: `src/Symfony/Component/Filesystem/Exception/FileNotFoundException.php` - FileNotFoundExceptionクラス（34行）
- E-05: `src/Symfony/Component/Filesystem/Exception/InvalidArgumentException.php` - InvalidArgumentExceptionクラス（19行）
- E-06: `src/Symfony/Component/Filesystem/Exception/RuntimeException.php` - RuntimeExceptionクラス（19行）
- E-07: `src/Symfony/Component/Filesystem/Exception/ExceptionInterface.php` - ExceptionInterfaceインターフェース（21行）
- E-08: `src/Symfony/Component/Filesystem/Exception/IOExceptionInterface.php` - IOExceptionInterfaceインターフェース（25行）

## 3) Claims と根拠の対応（レビューの主戦場）

### Filesystem::copy
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | ローカルファイルが正常にコピーされる | E-01 L37-83 copy()メソッド | ○ |
| C-002 | overwriteNewerFiles=trueで新しいターゲットが上書きされる | E-01 L47-49 条件分岐 | ○ |
| C-003 | overwriteNewerFiles=falseでターゲットが新しい場合スキップ | E-01 L47-49 filemtime比較 | ○ |
| C-004 | ターゲットディレクトリが自動作成される | E-01 L44 mkdir呼び出し | ○ |
| C-005 | パーミッションビットが保持される | E-01 L73 chmod呼び出し | ○ |
| C-006 | 存在しないファイルでFileNotFoundExceptionがスロー | E-01 L40-42 is_file/throw | ○ |
| C-007 | ソース読み込み不可でIOExceptionがスロー | E-01 L53-54 fopen失敗 | ○ |
| C-008 | ターゲット書き込み不可でIOExceptionがスロー | E-01 L58-59 fopen失敗 | ○ |

### Filesystem::mkdir
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-009 | 単一ディレクトリが作成される | E-01 L90-101 mkdir()メソッド | ○ |
| C-010 | ネストされたディレクトリが再帰的に作成される | E-01 L97 mkdir 第3引数true | ○ |
| C-011 | 既存ディレクトリはスキップされる | E-01 L93-95 is_dir/continue | ○ |
| C-012 | 複数ディレクトリが一度に作成される | E-01 L92 toIterable()ループ | ○ |
| C-013 | カスタムモードでディレクトリが作成される | E-01 L90 $modeパラメータ | ○ |
| C-014 | 作成失敗時にIOExceptionがスロー | E-01 L97-99 throw IOException | ○ |

### Filesystem::exists
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-015 | 存在するファイルにtrueが返却される | E-01 L106-121 exists()メソッド | ○ |
| C-016 | 存在するディレクトリにtrueが返却される | E-01 L115 file_exists() | ○ |
| C-017 | 存在しないファイルにfalseが返却される | E-01 L116 return false | ○ |
| C-018 | 複数ファイル全存在でtrueが返却される | E-01 L110 toIterable()ループ, L120 return true | ○ |
| C-019 | 一つでも存在しないとfalseが返却される | E-01 L115-117 file_exists/return false | ○ |
| C-020 | パス長超過でIOExceptionがスロー | E-01 L108-113 strlen/PHP_MAXPATHLEN | ○ |

### Filesystem::touch
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-021 | ファイルが作成されタイムスタンプが更新される | E-01 L131-138 touch()メソッド | ○ |
| C-022 | 既存ファイルのタイムスタンプが更新される | E-01 L134 touch関数呼び出し | ○ |
| C-023 | カスタムtimeが設定される | E-01 L134 $time引数 | ○ |
| C-024 | カスタムatimeが設定される | E-01 L134 $atime引数 | ○ |
| C-025 | 複数ファイルにtouchが実行される | E-01 L133 toIterable()ループ | ○ |
| C-026 | touch失敗時にIOExceptionがスロー | E-01 L135 throw IOException | ○ |

### Filesystem::remove
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-027 | ファイルが削除される | E-01 L145-154, L196 unlink | ○ |
| C-028 | 空ディレクトリが削除される | E-01 L187 rmdir | ○ |
| C-029 | ファイルを含むディレクトリが再帰的に削除される | E-01 L184-185 FilesystemIterator/doRemove再帰 | ○ |
| C-030 | シンボリックリンクが削除される | E-01 L160-164 is_link/unlink | ○ |
| C-031 | 複数ファイルが一度に削除される | E-01 L147-151 Traversable/配列変換 | ○ |
| C-032 | 削除失敗時にIOExceptionがスロー | E-01 L163, 194, 197 throw IOException | ○ |
| C-033 | 存在しないファイルの削除がエラーにならない | E-01 L196 file_exists()チェック | ○ |

### Filesystem::chmod
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-034 | パーミッションが変更される | E-01 L211-221 chmod()メソッド | ○ |
| C-035 | umaskが適用される | E-01 L214 $mode & ~$umask | ○ |
| C-036 | recursive=trueで再帰的に変更される | E-01 L217-219 再帰呼び出し | ○ |
| C-037 | 複数ファイルにchmodが実行される | E-01 L213 toIterable()ループ | ○ |
| C-038 | chmod失敗時にIOExceptionがスロー | E-01 L215 throw IOException | ○ |

### Filesystem::chown
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-039 | 所有者が変更される | E-01 L235-251 chown()メソッド | ○ |
| C-040 | recursive=trueで再帰的に変更される | E-01 L238-240 再帰呼び出し | ○ |
| C-041 | シンボリックリンクにlchownが使用される | E-01 L241-244 is_link/lchown | ○ |
| C-042 | chown失敗時にIOExceptionがスロー | E-01 L243, 247 throw IOException | ○ |

### Filesystem::chgrp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-043 | グループが変更される | E-01 L265-281 chgrp()メソッド | ○ |
| C-044 | recursive=trueで再帰的に変更される | E-01 L268-270 再帰呼び出し | ○ |
| C-045 | シンボリックリンクにlchgrpが使用される | E-01 L271-274 is_link/lchgrp | ○ |
| C-046 | chgrp失敗時にIOExceptionがスロー | E-01 L273, 277 throw IOException | ○ |

### Filesystem::rename
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-047 | ファイルがリネームされる | E-01 L289-306 rename()メソッド | ○ |
| C-048 | ディレクトリがリネームされる | E-01 L297-303 is_dir/mirror/remove | ○ |
| C-049 | overwrite=trueで既存ターゲットが上書きされる | E-01 L292 $overwrite条件 | ○ |
| C-050 | ターゲット既存時にIOExceptionがスロー | E-01 L293 throw IOException | ○ |
| C-051 | rename失敗時にIOExceptionがスロー | E-01 L304 throw IOException | ○ |

### Filesystem::symlink
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-052 | シンボリックリンクが作成される | E-01 L329-356 symlink()メソッド | ○ |
| C-053 | 既に正しいリンクがあればスキップ | E-01 L346-349 readlink比較 | ○ |
| C-054 | 異なるリンク先の既存リンクが再作成される | E-01 L350 remove呼び出し | ○ |
| C-055 | 親ディレクトリが自動作成される | E-01 L344 mkdir呼び出し | ○ |
| C-056 | symlink関数無効時にIOExceptionがスロー | E-01 L331 assertFunctionExists | ○ |
| C-057 | symlink作成失敗時にIOExceptionがスロー | E-01 L354 linkException呼び出し | ○ |

### Filesystem::hardlink
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-058 | ハードリンクが作成される | E-01 L366-390 hardlink()メソッド | ○ |
| C-059 | 複数ハードリンクが作成される | E-01 L378 toIterable()ループ | ○ |
| C-060 | 同じinodeの既存ファイルがスキップされる | E-01 L380-382 fileinode比較 | ○ |
| C-061 | originFile不在時にFileNotFoundExceptionがスロー | E-01 L370-371 exists/throw | ○ |
| C-062 | originFileがファイルでない場合にFileNotFoundExceptionがスロー | E-01 L374-375 is_file/throw | ○ |
| C-063 | link関数無効時にIOExceptionがスロー | E-01 L368 assertFunctionExists | ○ |

### Filesystem::readlink
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-064 | canonicalize=falseでリンクターゲットが返却される | E-01 L416-431 readlink()メソッド | ○ |
| C-065 | canonicalize=trueで解決パスが返却される | E-01 L422-428 realpath | ○ |
| C-066 | 非リンクパスにnullが返却される | E-01 L418-419 is_link/return null | ○ |
| C-067 | 存在しないパスにnullが返却される | E-01 L423-425 exists/return null | ○ |

### Filesystem::makePathRelative
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-068 | 同一ディレクトリ内の相対パスが返却される | E-01 L436-503 makePathRelative()メソッド | ○ |
| C-069 | 親ディレクトリへの相対パスが返却される | E-01 L491-495 depth/traverser計算 | ○ |
| C-070 | 兄弟ディレクトリへの相対パスが返却される | E-01 L497 endPathRemainder | ○ |
| C-071 | 同一パスに'./'が返却される | E-01 L502 空relativePath時 | ○ |
| C-072 | 深いネストの相対パスが計算される | E-01 L482-502 アルゴリズム全体 | ○ |
| C-073 | 相対startPathでInvalidArgumentExceptionがスロー | E-01 L438-440 isAbsolutePath/throw | ○ |
| C-074 | 相対endPathでInvalidArgumentExceptionがスロー | E-01 L442-444 isAbsolutePath/throw | ○ |

### Filesystem::mirror
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-075 | ディレクトリがミラーリングされる | E-01 L522-576 mirror()メソッド | ○ |
| C-076 | override=trueで既存ファイルが上書きされる | E-01 L571 copy第3引数 | ○ |
| C-077 | delete=trueでソースに無いファイルが削除される | E-01 L533-546 deleteIterator | ○ |
| C-078 | ネストされたディレクトリ構造がミラーリングされる | E-01 L552 RecursiveIteratorIterator | ○ |
| C-079 | シンボリックリンクがミラーリングされる | E-01 L566-567 is_link/symlink | ○ |
| C-080 | 存在しないoriginDirでIOExceptionがスロー | E-01 L528-529 exists/throw | ○ |
| C-081 | 不明ファイルタイプでIOExceptionがスロー | E-01 L573 throw IOException | △ |

### Filesystem::isAbsolutePath, tempnam, dumpFile, appendToFile, readFile, handleError
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-082 | UNIX絶対パスにtrueが返却される | E-01 L581-583 Path::isAbsolute委譲 | ○ |
| C-083 | 相対パスにfalseが返却される | E-01 L581-583, E-02 L364-373 | ○ |
| C-084 | Windowsパスにtrueが返却される | E-02 L367-370 ctype_alpha/':' | ○ |
| C-085 | URIスキーム付きパスにtrueが返却される | E-02 L371 parse_url | ○ |
| C-086 | 空文字列にfalseが返却される | E-02 L366 '' !== $path | ○ |
| C-087 | 一時ファイルが作成される | E-01 L595-631 tempnam()メソッド | ○ |
| C-088 | suffix付き一時ファイルが作成される | E-01 L616 $suffix変数 | ○ |
| C-089 | スキーム付きディレクトリで一時ファイルが作成される | E-01 L597-608 scheme処理 | ○ |
| C-090 | tempnam失敗時にIOExceptionがスロー | E-01 L610, 630 throw IOException | ○ |
| C-091 | 文字列がアトミックに書き込まれる | E-01 L640-679 dumpFile()メソッド | ○ |
| C-092 | リソースが書き込まれる | E-01 L640 $contentパラメータ型 | ○ |
| C-093 | 既存ファイルが上書きされる | E-01 L669 rename呼び出し | ○ |
| C-094 | 親ディレクトリが自動作成される | E-01 L654-656 is_dir/mkdir | ○ |
| C-095 | シンボリックリンク経由で書き込まれる | E-01 L648-651 readlink/再帰呼び出し | ○ |
| C-096 | 配列content時にTypeErrorがスロー | E-01 L642-643 is_array/throw | ○ |
| C-097 | 書き込み失敗時にIOExceptionがスロー | E-01 L663-664 file_put_contents/throw | ○ |
| C-098 | 既存ファイルにコンテンツが追記される | E-01 L689-704 appendToFile()メソッド | ○ |
| C-099 | 存在しないファイルに追記で新規作成される | E-01 L697-699 is_dir/mkdir | ○ |
| C-100 | lock=trueでロック付き追記される | E-01 L701 LOCK_EX | ○ |
| C-101 | 親ディレクトリが自動作成される | E-01 L697-699 is_dir/mkdir | ○ |
| C-102 | 配列content時にTypeErrorがスロー | E-01 L691-693 is_array/throw | ○ |
| C-103 | appendToFile書き込み失敗時にIOExceptionがスロー | E-01 L702 throw IOException | ○ |
| C-104 | ファイル内容が文字列として返却される | E-01 L711-723 readFile()メソッド | ○ |
| C-105 | ディレクトリ指定時にIOExceptionがスロー | E-01 L713-714 is_dir/throw | ○ |
| C-106 | ファイル不在時にIOExceptionがスロー | E-01 L718-719 false === $content/throw | ○ |
| C-107 | 読み取り不可ファイルでIOExceptionがスロー | E-01 L717-719 file_get_contents失敗 | ○ |
| C-108 | 空ファイルの内容が空文字列として返却される | E-01 L717-722 file_get_contents | ○ |
| C-109 | エラーメッセージがlastErrorに格納される | E-01 L763-766 handleError()メソッド | △ |

### Path クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | バックスラッシュがフォワードスラッシュに正規化される | E-02 L66-101 canonicalize(), L116 normalize() | ○ |
| C-111 | '.'セグメントが除去される | E-02 L703-730 findCanonicalParts() | ○ |
| C-112 | '..'セグメントが解決される | E-02 L717-718 array_pop | ○ |
| C-113 | '~'がホームディレクトリに展開される | E-02 L80-81 getHomeDirectory() | ○ |
| C-114 | バッファキャッシュが返却される | E-02 L75-77 self::$buffer | ○ |
| C-115 | 空文字列に空文字列が返却される | E-02 L68-69 '' === $path | ○ |
| C-116 | バッファクリーンアップが実行される | E-02 L95-98 CLEANUP_THRESHOLD | △ |
| C-117 | normalizeでバックスラッシュが置換される | E-02 L114-117 str_replace | ○ |
| C-118 | normalizeでフォワードスラッシュが維持される | E-02 L116 str_replace | ○ |
| C-119 | ファイルパスからディレクトリ部分が返却される | E-02 L142-173 getDirectory() | ○ |
| C-120 | ルートパスにルートが返却される | E-02 L162-165 0 === $dirSeparatorPosition | ○ |
| C-121 | Windowsルートパスにルートが返却される | E-02 L168-169 ctype_alpha/':' | ○ |
| C-122 | スキーム付きパスのディレクトリが返却される | E-02 L151-156 $scheme処理 | ○ |
| C-123 | 空文字列に空文字列が返却される | E-02 L144-146 '' === $path | ○ |
| C-124 | スラッシュなし相対パスに空文字列が返却される | E-02 L158-159 false === strrpos | ○ |
| C-125 | HOME環境変数からホームディレクトリが返却される | E-02 L189-202 getHomeDirectory() | ○ |
| C-126 | HOMEDRIVE+HOMEPATHからホームディレクトリが返却される | E-02 L197-199 getenv | ○ |
| C-127 | 環境変数未設定時にRuntimeExceptionがスロー | E-02 L201 throw RuntimeException | ○ |
| C-128 | UNIXルートパスに'/'が返却される | E-02 L212-249 getRoot() | ○ |
| C-129 | Windowsルートパスにドライブレター付きルートが返却される | E-02 L236-246 ctype_alpha/':' | ○ |
| C-130 | スキーム付きパスにスキーム付きルートが返却される | E-02 L219-224 $scheme処理 | ○ |
| C-131 | 相対パスに空文字列が返却される | E-02 L248 return '' | ○ |
| C-132 | 空文字列に空文字列が返却される | E-02 L214-216 '' === $path | ○ |
| C-133 | 'C:'のみに'C:/'が返却される | E-02 L238-239 2 === $length | ○ |
| C-134 | 拡張子なしファイル名が返却される | E-02 L257-269 getFilenameWithoutExtension() | ○ |
| C-135 | 指定拡張子のみが除去される | E-02 L264-265 basename/rtrim | ○ |
| C-136 | 空文字列に空文字列が返却される | E-02 L259-261 '' === $path | ○ |
| C-137 | 拡張子なしファイルにファイル名全体が返却される | E-02 L268 pathinfo | ○ |
| C-138 | ファイルの拡張子が返却される | E-02 L276-289 getExtension() | ○ |
| C-139 | forceLowerCaseで小文字の拡張子が返却される | E-02 L284-286 toLower | ○ |
| C-140 | 空文字列に空文字列が返却される | E-02 L278-280 '' === $path | ○ |
| C-141 | 拡張子なしファイルに空文字列が返却される | E-02 L282 pathinfo | ○ |
| C-142 | 拡張子を持つパスにtrueが返却される | E-02 L302-329 hasExtension() | ○ |
| C-143 | 拡張子なしパスにfalseが返却される | E-02 L312 '' !== $actualExtension | ○ |
| C-144 | 指定拡張子と一致でtrueが返却される | E-02 L328 in_array | ○ |
| C-145 | 指定拡張子と不一致でfalseが返却される | E-02 L328 in_array | ○ |
| C-146 | 複数拡張子配列で一致すればtrueが返却される | E-02 L319-328 foreachループ | ○ |
| C-147 | ignoreCase=trueで大小文字を無視して比較される | E-02 L308, 320-321 toLower | ○ |
| C-148 | 空文字列にfalseが返却される | E-02 L304-306 '' === $path | ○ |
| C-149 | ファイルの拡張子が変更される | E-02 L339-359 changeExtension() | ○ |
| C-150 | ドット付き拡張子が正しく処理される | E-02 L346 ltrim | ○ |
| C-151 | 拡張子なしファイルに拡張子が追加される | E-02 L354-355 !$actualExtension | ○ |
| C-152 | 空文字列に空文字列が返却される | E-02 L341-343 '' === $path | ○ |
| C-153 | 末尾スラッシュのパスがそのまま返却される | E-02 L349-351 str_ends_with('/') | ○ |
| C-154 | UNIX絶対パスにtrueが返却される | E-02 L364-373 isAbsolute() | ○ |
| C-155 | Windows絶対パスにtrueが返却される | E-02 L367-370 ctype_alpha/':' | ○ |
| C-156 | URIスキーム付きパスにtrueが返却される | E-02 L371 parse_url | ○ |
| C-157 | 相対パスにfalseが返却される | E-02 L366-373 条件不一致 | ○ |
| C-158 | 空文字列にfalseが返却される | E-02 L366 '' !== $path | ○ |
| C-159 | バックスラッシュ開始パスにtrueが返却される | E-02 L366 strspn('/\\') | ○ |
| C-160 | 相対パスにtrueが返却される(isRelative) | E-02 L375-378 !isAbsolute | ○ |
| C-161 | 絶対パスにfalseが返却される(isRelative) | E-02 L375-378 !isAbsolute | ○ |
| C-162 | 相対パスが絶対パスに変換される | E-02 L417-439 makeAbsolute() | ○ |
| C-163 | 既に絶対パスの場合そのまま正規化される | E-02 L427-429 isAbsolute/canonicalize | ○ |
| C-164 | スキーム付きベースパスが正しく処理される | E-02 L431-436 $scheme処理 | ○ |
| C-165 | 空ベースパスでInvalidArgumentExceptionがスロー | E-02 L419-421 '' === $basePath/throw | ○ |
| C-166 | 相対ベースパスでInvalidArgumentExceptionがスロー | E-02 L423-425 !isAbsolute/throw | ○ |
| C-167 | 絶対パスが相対パスに変換される | E-02 L491-547 makeRelative() | ○ |
| C-168 | 同一ディレクトリ内の相対パスが返却される | E-02 L527-546 parts/baseParts比較 | ○ |
| C-169 | 相対パス入力時そのまま返却される | E-02 L501-509 '' === $root | ○ |
| C-170 | 絶対パスを相対ベースパスに変換でInvalidArgumentExceptionがスロー | E-02 L513-515 throw | ○ |
| C-171 | 異なるルートでInvalidArgumentExceptionがスロー | E-02 L518-519 $root !== $baseRoot/throw | ○ |
| C-172 | ローカルパスにtrueが返却される | E-02 L552-555 isLocal() | ○ |
| C-173 | URIスキーム付きパスにfalseが返却される | E-02 L554 str_contains('://') | ○ |
| C-174 | 空文字列にfalseが返却される | E-02 L554 '' !== $path | ○ |
| C-175 | 共通ベースパスが返却される | E-02 L593-628 getLongestCommonBasePath() | ○ |
| C-176 | ルートのみ共通でルートが返却される | E-02 L627 $bpRoot.$basePath | ○ |
| C-177 | 異なるドライブでnullが返却される | E-02 L602-604 $root !== $bpRoot/return null | ○ |
| C-178 | 単一パスでそのパスが返却される | E-02 L597 forループスキップ | ○ |
| C-179 | 複数パスが結合される | E-02 L633-665 join() | ○ |
| C-180 | スキーム付きパスが正しく結合される | E-02 L646 $wasScheme | ○ |
| C-181 | 空文字列を含むパスが正しく処理される | E-02 L639-641 '' === $path/continue | ○ |
| C-182 | すべて空文字列で空文字列が返却される | E-02 L660-662 null === $finalPath | ○ |
| C-183 | ベースパスの子パスにtrueが返却される | E-02 L687-698 isBasePath() | ○ |
| C-184 | 同一パスにtrueが返却される | E-02 L697 str_starts_with | ○ |
| C-185 | 非ベースパスにfalseが返却される | E-02 L697 str_starts_with | ○ |
| C-186 | プレフィックス共通だが親子関係でないパスにfalseが返却される | E-02 L697 rtrim/スラッシュ追加 | ○ |

### 例外クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-187 | IOExceptionのメッセージとパスが設定される | E-03 L23-30 __construct | ○ |
| C-188 | pathがnullの場合にnullが返却される | E-03 L28 ?string $path = null | ○ |
| C-189 | getPathで設定パスが返却される | E-03 L32-35 getPath() | ○ |
| C-190 | FileNotFoundExceptionのデフォルトメッセージ（pathなし） | E-04 L24-26 message=null, path=null | ○ |
| C-191 | FileNotFoundExceptionのデフォルトメッセージ（pathあり） | E-04 L27-28 sprintf | ○ |
| C-192 | FileNotFoundExceptionのカスタムメッセージ | E-04 L22-32 __construct | ○ |
| C-193 | IOExceptionがIOExceptionInterfaceを実装 | E-03 L21 implements IOExceptionInterface | ○ |
| C-194 | FileNotFoundExceptionがIOExceptionを継承 | E-04 L20 extends IOException | ○ |
| C-195 | InvalidArgumentExceptionがExceptionInterfaceを実装 | E-05 L17 implements ExceptionInterface | ○ |
| C-196 | RuntimeExceptionがExceptionInterfaceを実装 | E-06 L17 implements ExceptionInterface | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-081（不明ファイルタイプのmirror）**: 不明なファイルタイプ（ソケットやFIFOなど）を実際にテストで再現する方法はOSに依存し、テスト実装の詳細設計が必要
  - 候補：モックを使用 / 特殊ファイルを作成 / テスト対象外とする
- **C-109（handleError）**: `@internal`アノテーション付きのpublic staticメソッドであり、テスト対象とするかはプロジェクトのテスト方針による
  - 候補：内部テストとして含める / テスト対象外とする / box()メソッド経由で間接的にテスト
- **C-116（バッファクリーンアップ）**: 内部のバッファ管理（CLEANUP_THRESHOLD=1250）は実装の詳細であり、テストはPathクラスの内部状態に依存する
  - 候補：リフレクションでバッファサイズを確認 / 大量パスの正規化後にメモリ消費を確認 / テスト対象外とする
- **C-056（symlink関数無効）**: PHPのビルトイン関数を無効化するテストはphp.iniやrunkit拡張に依存する
  - 候補：モックを使用 / 条件付きスキップ / テスト対象外とする

## 5) リスクフラグ（レビュー観点）
- 0: **低リスク** - 例外クラスのテスト（C-187〜C-196）は単純なコンストラクタ・ゲッターテストで安定
- 0: **低リスク** - Path::isAbsolute, isRelative, isLocal等の純粋関数テストは副作用なく安定
- 1: **中リスク** - ファイルシステム操作（copy, mkdir, remove等）はテスト環境のパーミッション・OS差異に影響される
- 1: **中リスク** - シンボリックリンク関連テスト（symlink, hardlink, readlink）はWindows/UNIX差異に注意
- 1: **中リスク** - dumpFileのアトミック書き込みテストは並行実行時の挙動確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがFilesystemクラスのすべてのpublicメソッド（copy, mkdir, exists, touch, remove, chmod, chown, chgrp, rename, symlink, hardlink, readlink, makePathRelative, mirror, isAbsolutePath, tempnam, dumpFile, appendToFile, readFile）を網羅しているか
- [ ] テストケースがPathクラスのすべてのpublicメソッド（canonicalize, normalize, getDirectory, getHomeDirectory, getRoot, getFilenameWithoutExtension, getExtension, hasExtension, changeExtension, isAbsolute, isRelative, makeAbsolute, makeRelative, isLocal, getLongestCommonBasePath, join, isBasePath）を網羅しているか
- [ ] 各メソッドに対して正常系・異常系・境界値の観点が含まれているか
- [ ] Windows/UNIXのパス差異に関するテストケースが含まれているか
- [ ] ファイルシステム操作の権限エラーケースが含まれているか
- [ ] 例外クラスの階層構造テストが含まれているか
- [ ] handleErrorメソッドの`@internal`指定を踏まえたテスト方針が妥当か
