---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 212
  claims_with_evidence: 208
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：Component-Finder 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：208 / 212、根拠なし：4
- 優先レビュー（高）
  1. **UT-FND-093〜095 (normalizeDir)**: privateメソッドのため間接テストが必要。テスト方法の検証が必要
  2. **UT-FND-206〜207 (VcsIgnoredFilterIterator ネストgitignore)**: 複雑な状態依存テストのため、テスト環境構築方法の確認が必要
  3. **UT-FND-080 (Finder::in glob)**: globパターンの解決はファイルシステム依存のため、テスト環境の準備が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Finder/Comparator/Comparator.php` - Comparatorクラスの定義（コンストラクタ、getTarget、getOperator、test メソッド）
- E-02: `src/Symfony/Component/Finder/Comparator/DateComparator.php` - DateComparatorクラスの定義（コンストラクタでの日付パース、演算子エイリアス変換）
- E-03: `src/Symfony/Component/Finder/Comparator/NumberComparator.php` - NumberComparatorクラスの定義（数値パース、単位倍率変換）
- E-04: `src/Symfony/Component/Finder/Finder.php` - Finderクラスの定義（全publicメソッド、定数、privateメソッド searchInDirectory/normalizeDir）
- E-05: `src/Symfony/Component/Finder/Glob.php` - Globクラスの定義（toRegexメソッド、glob→正規表現変換ロジック）
- E-06: `src/Symfony/Component/Finder/Gitignore.php` - Gitignoreクラスの定義（toRegex、toRegexMatchingNegatedPatterns、buildRegex、lineToRegex）
- E-07: `src/Symfony/Component/Finder/SplFileInfo.php` - SplFileInfoクラスの定義（コンストラクタ、getRelativePath、getRelativePathname、getFilenameWithoutExtension、getContents）
- E-08: `src/Symfony/Component/Finder/Iterator/CustomFilterIterator.php` - CustomFilterIteratorクラスの定義（コンストラクタ、accept）
- E-09: `src/Symfony/Component/Finder/Iterator/DateRangeFilterIterator.php` - DateRangeFilterIteratorクラスの定義（コンストラクタ、accept）
- E-10: `src/Symfony/Component/Finder/Iterator/DepthRangeFilterIterator.php` - DepthRangeFilterIteratorクラスの定義（コンストラクタ、accept）
- E-11: `src/Symfony/Component/Finder/Iterator/ExcludeDirectoryFilterIterator.php` - ExcludeDirectoryFilterIteratorクラスの定義（コンストラクタ、accept、hasChildren、getChildren）
- E-12: `src/Symfony/Component/Finder/Iterator/FileTypeFilterIterator.php` - FileTypeFilterIteratorクラスの定義（定数、accept）
- E-13: `src/Symfony/Component/Finder/Iterator/FilecontentFilterIterator.php` - FilecontentFilterIteratorクラスの定義（accept、toRegex）
- E-14: `src/Symfony/Component/Finder/Iterator/FilenameFilterIterator.php` - FilenameFilterIteratorクラスの定義（accept、toRegex）
- E-15: `src/Symfony/Component/Finder/Iterator/LazyIterator.php` - LazyIteratorクラスの定義（コンストラクタ、getIterator）
- E-16: `src/Symfony/Component/Finder/Iterator/MultiplePcreFilterIterator.php` - MultiplePcreFilterIteratorクラスの定義（コンストラクタ、isAccepted、isRegex）
- E-17: `src/Symfony/Component/Finder/Iterator/PathFilterIterator.php` - PathFilterIteratorクラスの定義（accept、toRegex）
- E-18: `src/Symfony/Component/Finder/Iterator/RecursiveDirectoryIterator.php` - RecursiveDirectoryIteratorクラスの定義（コンストラクタ、current、hasChildren、getChildren、next、rewind）
- E-19: `src/Symfony/Component/Finder/Iterator/SizeRangeFilterIterator.php` - SizeRangeFilterIteratorクラスの定義（コンストラクタ、accept）
- E-20: `src/Symfony/Component/Finder/Iterator/SortableIterator.php` - SortableIteratorクラスの定義（定数、コンストラクタ、getIterator）
- E-21: `src/Symfony/Component/Finder/Iterator/VcsIgnoredFilterIterator.php` - VcsIgnoredFilterIteratorクラスの定義（コンストラクタ、accept、isIgnored、readGitignoreFile、normalizePath、parentDirectories系メソッド）
- E-22: `src/Symfony/Component/Finder/Exception/AccessDeniedException.php` - AccessDeniedExceptionクラスの定義
- E-23: `src/Symfony/Component/Finder/Exception/DirectoryNotFoundException.php` - DirectoryNotFoundExceptionクラスの定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Comparator: 有効演算子でインスタンス生成 | E-01 (L21-30) | ○ |
| C-02 | Comparator: デフォルト演算子== | E-01 (L23) | ○ |
| C-03 | Comparator: 無効演算子でInvalidArgumentException | E-01 (L25-27) | ○ |
| C-04 | Comparator: 全6種有効演算子 | E-01 (L25) | ○ |
| C-05 | Comparator: getTarget() | E-01 (L35-38) | ○ |
| C-06 | Comparator: getOperator() | E-01 (L43-46) | ○ |
| C-07 | Comparator: test()で全6演算子の比較ロジック | E-01 (L51-61) | ○ |
| C-08 | DateComparator: 日付パースとタイムスタンプ変換 | E-02 (L26-48) | ○ |
| C-09 | DateComparator: since/afterが>に変換 | E-02 (L40-42) | ○ |
| C-10 | DateComparator: until/beforeが<に変換 | E-02 (L44-46) | ○ |
| C-11 | DateComparator: 無効日付でInvalidArgumentException | E-02 (L35-37) | ○ |
| C-12 | NumberComparator: 数値パースと単位変換 | E-03 (L42-77) | ○ |
| C-13 | NumberComparator: k/ki/m/mi/g/gi倍率 | E-03 (L54-73) | ○ |
| C-14 | NumberComparator: nullでInvalidArgumentException | E-03 (L44-45) | ○ |
| C-15 | Finder: create()でstaticインスタンス生成 | E-04 (L82-85) | ○ |
| C-16 | Finder: デフォルトIGNORE_VCS_FILES + IGNORE_DOT_FILES | E-04 (L74-77) | ○ |
| C-17 | Finder: directories()でONLY_DIRECTORIES設定 | E-04 (L92-97) | ○ |
| C-18 | Finder: files()でONLY_FILES設定 | E-04 (L104-109) | ○ |
| C-19 | Finder: depth()でNumberComparator追加 | E-04 (L127-134) | ○ |
| C-20 | Finder: date()でDateComparator追加 | E-04 (L155-162) | ○ |
| C-21 | Finder: name()/notName()でパターン追加 | E-04 (L180-201) | ○ |
| C-22 | Finder: contains()/notContains() | E-04 (L218-245) | ○ |
| C-23 | Finder: path()/notPath() | E-04 (L264-293) | ○ |
| C-24 | Finder: size()でNumberComparator追加 | E-04 (L310-317) | ○ |
| C-25 | Finder: exclude()でディレクトリ追加 | E-04 (L332-337) | ○ |
| C-26 | Finder: ignoreDotFiles()でフラグ設定/解除 | E-04 (L348-357) | ○ |
| C-27 | Finder: ignoreVCS()でフラグ設定/解除 | E-04 (L368-377) | ○ |
| C-28 | Finder: ignoreVCSIgnored()でフラグ設定/解除 | E-04 (L386-395) | ○ |
| C-29 | Finder: addVCSPattern()でパターン追加・重複排除 | E-04 (L404-411) | ○ |
| C-30 | Finder: sort系メソッドで各種ソートモード設定 | E-04 (L424-577) | ○ |
| C-31 | Finder: reverseSorting() | E-04 (L534-539) | ○ |
| C-32 | Finder: filter()でフィルタ/pruneフィルタ追加 | E-04 (L592-601) | ○ |
| C-33 | Finder: followLinks()/useUnixPaths()/ignoreUnreadableDirs() | E-04 (L608-639) | ○ |
| C-34 | Finder: in()でディレクトリ追加・glob解決・例外 | E-04 (L650-668) | ○ |
| C-35 | Finder: getIterator()でイテレータ返却・LogicException | E-04 (L679-715) | ○ |
| C-36 | Finder: append()/hasResults()/count() | E-04 (L726-751) | ○ |
| C-37 | Finder: normalizeDir()でパス正規化 | E-04 (L854-867) | ○ |
| C-38 | Finder: normalizeDir() FTPプロトコル対応 | E-04 (L862-863) | ○ |
| C-39 | Glob: toRegex()でglob→正規表現変換 | E-05 (L41-115) | ○ |
| C-40 | Glob: strictLeadingDot/strictWildcardSlash/delimiter制御 | E-05 (L41, L53-56, L79-82) | ○ |
| C-41 | Glob: **/ パターン対応 | E-05 (L47-75) | ○ |
| C-42 | Glob: ブレース展開{a,b}対応 | E-05 (L83-94) | ○ |
| C-43 | Gitignore: toRegex()でgitignore→正規表現変換 | E-06 (L27-29) | ○ |
| C-44 | Gitignore: コメント・否定・ディレクトリ・絶対パス対応 | E-06 (L37-90) | ○ |
| C-45 | Gitignore: toRegexMatchingNegatedPatterns() | E-06 (L32-34) | ○ |
| C-46 | SplFileInfo: 相対パス情報の保持と取得 | E-07 (L26-52) | ○ |
| C-47 | SplFileInfo: getFilenameWithoutExtension() | E-07 (L54-59) | ○ |
| C-48 | SplFileInfo: getContents()と例外 | E-07 (L66-79) | ○ |
| C-49 | CustomFilterIterator: callable検証と複数フィルタ適用 | E-08 (L34-60) | ○ |
| C-50 | DateRangeFilterIterator: 日付比較フィルタ | E-09 (L31-57) | ○ |
| C-51 | DepthRangeFilterIterator: 深度範囲フィルタ | E-10 (L33-47) | ○ |
| C-52 | ExcludeDirectoryFilterIterator: ディレクトリ除外・パターン除外・callable | E-11 (L40-109) | ○ |
| C-53 | FileTypeFilterIterator: ファイル/ディレクトリタイプフィルタ | E-12 (L30-51) | ○ |
| C-54 | FilecontentFilterIterator: コンテンツマッチフィルタ | E-13 (L29-57) | ○ |
| C-55 | FilenameFilterIterator: ファイル名マッチフィルタ | E-14 (L28-44) | ○ |
| C-56 | LazyIterator: 遅延イテレータ | E-15 (L19-32) | ○ |
| C-57 | MultiplePcreFilterIterator: isAccepted()のマッチ/除外ロジック | E-16 (L54-76) | ○ |
| C-58 | MultiplePcreFilterIterator: isRegex()の正規表現判定 | E-16 (L81-101) | ○ |
| C-59 | PathFilterIterator: パスマッチフィルタ | E-17 (L29-55) | ○ |
| C-60 | RecursiveDirectoryIterator: コンストラクタのフラグ制限 | E-18 (L37-49) | ○ |
| C-61 | RecursiveDirectoryIterator: current()でSplFileInfo返却 | E-18 (L54-73) | ○ |
| C-62 | RecursiveDirectoryIterator: hasChildren()/getChildren()のignoreUnreadableDirs | E-18 (L75-113) | ○ |
| C-63 | RecursiveDirectoryIterator: rewind()の初回スキップ | E-18 (L122-133) | ○ |
| C-64 | SizeRangeFilterIterator: サイズ比較フィルタ | E-19 (L31-57) | ○ |
| C-65 | SortableIterator: 全ソートモードの設定 | E-20 (L45-84) | ○ |
| C-66 | SortableIterator: getIterator()でソート・逆順・ソートなし | E-20 (L87-114) | ○ |
| C-67 | VcsIgnoredFilterIterator: .gitルート検出とgitignore適用 | E-21 (L36-97) | ○ |
| C-68 | VcsIgnoredFilterIterator: readGitignoreFile()のキャッシュと例外 | E-21 (L143-163) | ○ |
| C-69 | AccessDeniedException: UnexpectedValueException継承 | E-22 (L17-19) | ○ |
| C-70 | DirectoryNotFoundException: InvalidArgumentException継承 | E-23 (L17-19) | ○ |
| C-71 | VcsIgnoredFilterIterator: ネストした.gitignoreの適用順序 | E-21 (L59-97) | △ |
| C-72 | VcsIgnoredFilterIterator: 無視ディレクトリ内のルール無視 | E-21 (L72-75) | △ |
| C-73 | Finder: normalizeDir() privateメソッドの間接テスト | E-04 (L854-867) | △ |
| C-74 | Finder: searchInDirectory() privateメソッドの網羅性 | E-04 (L753-847) | △ |

## 4) 不足情報（Unknown / Missing）
- C-71, C-72: VcsIgnoredFilterIteratorのネストした.gitignore処理は、ソースコードから論理的に推測したテストケースであり、実際の動作確認にはファイルシステム上のテストフィクスチャが必要
  - 候補：既存のSymfony Finderテストスイートのフィクスチャ / 実環境での動作確認
- C-73: normalizeDir()はprivateメソッドであり、in()メソッド経由での間接テストが必要。テスト観点は正しいが、テスト実装方法の具体性が不足
  - 候補：Reflection APIを使用した直接テスト / in()経由の間接テスト
- C-74: searchInDirectory()は複雑なprivateメソッドであり、getIterator()経由で間接的にテストされるが、全分岐の網羅性が課題
  - 候補：統合テストでの確認 / 各フィルタイテレータの単体テストで補完

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Comparator系クラス、SplFileInfo、例外クラス（単純な構造でテストケースの妥当性が高い）
- 0: 低リスク - MultiplePcreFilterIterator、FileTypeFilterIterator（明確な分岐条件に基づくテスト）
- 1: 中リスク - Finder::normalizeDir()等のprivateメソッド（テスト実装時に間接テストが必要）
- 1: 中リスク - VcsIgnoredFilterIterator（ファイルシステム依存の複雑な処理）
- 0: 低リスク - Glob::toRegex()、Gitignore::toRegex()（入出力が明確なstatic関数）

## 6) レビュアーチェックリスト（最小）
- [ ] 全23ファイルの全publicメソッドがテストケースに含まれているか
- [ ] 正常系・異常系・境界値の3観点が各メソッドに対して網羅されているか
- [ ] privateメソッド（normalizeDir, searchInDirectory）のテスト戦略が妥当か
- [ ] VcsIgnoredFilterIteratorのネストgitignoreテストケースの前提条件が実現可能か
- [ ] テストIDの命名規則（UT-FND-xxx）が一貫しているか
- [ ] 各テストケースの入力値と期待結果がソースコードの実装と整合しているか
