---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 139
  claims_with_evidence: 133
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：Component-HtmlSanitizer 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：133 / 139、根拠なし：6
- 優先レビュー（高）
  1. **UT-HSN-018（DomVisitorキャッシュ確認）**：内部実装のキャッシュ動作は外部から直接検証困難
  2. **UT-HSN-079（サブドメインマッチング）**：matchAllowedHostPartsのロジック推測に基づく
  3. **UT-HSN-084（ホスト名デコード検証）**：decodeUnreservedCharactersの正規表現パターンに基づく推測
  4. **UT-HSN-093/094（デフォルトアクションBlock/Allow）**：DomVisitorの内部動作推測
  5. **UT-HSN-096（childNodes null安全性）**：nullsafe演算子によるが実際のDOM実装依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/HtmlSanitizer/HtmlSanitizer.php` - メインサニタイザークラス（sanitize, sanitizeFor, isValidUtf8, createDomVisitorForContext）
- E-02: `src/Symfony/Component/HtmlSanitizer/HtmlSanitizerConfig.php` - 設定クラス（全publicメソッド、イミュータブル設計、バリデーション）
- E-03: `src/Symfony/Component/HtmlSanitizer/HtmlSanitizerAction.php` - enum定義（Drop, Block, Allow）
- E-04: `src/Symfony/Component/HtmlSanitizer/HtmlSanitizerInterface.php` - インターフェース定義（sanitize, sanitizeFor）
- E-05: `src/Symfony/Component/HtmlSanitizer/Parser/NativeParser.php` - PHP 8.4 Dom API によるHTML解析
- E-06: `src/Symfony/Component/HtmlSanitizer/Parser/ParserInterface.php` - パーサーインターフェース定義
- E-07: `src/Symfony/Component/HtmlSanitizer/Reference/W3CReference.php` - W3C標準データ（CONTEXTS_MAP, HEAD_ELEMENTS, BODY_ELEMENTS, ATTRIBUTES）
- E-08: `src/Symfony/Component/HtmlSanitizer/TextSanitizer/StringSanitizer.php` - 文字列サニタイズ（htmlLower, encodeHtmlEntities, REPLACEMENTS定数）
- E-09: `src/Symfony/Component/HtmlSanitizer/TextSanitizer/UrlSanitizer.php` - URLサニタイズ（sanitize, parse, isHostlessScheme, isAllowedHost, matchAllowedHostParts, decodeUnreservedCharacters）
- E-10: `src/Symfony/Component/HtmlSanitizer/Visitor/DomVisitor.php` - DOM走査・サニタイズ（visit, visitNode, enterNode, visitChildren, setAttributes）
- E-11: `src/Symfony/Component/HtmlSanitizer/Visitor/AttributeSanitizer/UrlAttributeSanitizer.php` - URL属性サニタイザー（getSupportedElements, getSupportedAttributes, sanitizeAttribute）
- E-12: `src/Symfony/Component/HtmlSanitizer/Visitor/AttributeSanitizer/AttributeSanitizerInterface.php` - 属性サニタイザーインターフェース
- E-13: `src/Symfony/Component/HtmlSanitizer/Visitor/Model/Cursor.php` - カーソルモデル（publicプロパティ node）
- E-14: `src/Symfony/Component/HtmlSanitizer/Visitor/Node/Node.php` - ノードクラス（VOID_ELEMENTS, setAttribute, getAttribute, render, renderAttributes）
- E-15: `src/Symfony/Component/HtmlSanitizer/Visitor/Node/BlockedNode.php` - ブロックノード（addChild, getParent, render）
- E-16: `src/Symfony/Component/HtmlSanitizer/Visitor/Node/DocumentNode.php` - ドキュメントノード（addChild, getParent, render）
- E-17: `src/Symfony/Component/HtmlSanitizer/Visitor/Node/TextNode.php` - テキストノード（addChild例外, getParent, render）
- E-18: `src/Symfony/Component/HtmlSanitizer/Visitor/Node/NodeInterface.php` - ノードインターフェース定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-HSN-001: デフォルトのNativeParserでインスタンス生成 | E-01 (L32-37) | ○ |
| C-02 | UT-HSN-002: カスタムParser指定でインスタンス生成 | E-01 (L34) | ○ |
| C-03 | UT-HSN-003: bodyコンテキストでHTMLサニタイズ | E-01 (L39-42) | ○ |
| C-04 | UT-HSN-004: scriptタグ除去 | E-01, E-02 (デフォルトDrop) | ○ |
| C-05 | UT-HSN-005: 空文字列入力 | E-01 (L73) | ○ |
| C-06 | UT-HSN-006: 不正UTF-8で空文字列 | E-01 (L65-67, L81-85) | ○ |
| C-07 | UT-HSN-007: NULLバイト置換 | E-01 (L70) | ○ |
| C-08 | UT-HSN-008: maxInputLength超過で切り詰め | E-01 (L59-61) | ○ |
| C-09 | UT-HSN-009: maxInputLength=-1で無制限 | E-01 (L59) | ○ |
| C-10 | UT-HSN-010: 空白のみ入力 | E-01 (L73) | ○ |
| C-11 | UT-HSN-011: bodyコンテキスト基本動作 | E-01 (L44-78), E-07 | ○ |
| C-12 | UT-HSN-012: headコンテキスト基本動作 | E-01 (L88-112), E-07 | ○ |
| C-13 | UT-HSN-013: textコンテキストでHTMLエンコード | E-01 (L51-53), E-07 (L38-39) | ○ |
| C-14 | UT-HSN-014: titleコンテキストでHTMLエンコード | E-01 (L51-53), E-07 (L39) | ○ |
| C-15 | UT-HSN-015: 不明要素はbodyにフォールバック | E-01 (L47) | ○ |
| C-16 | UT-HSN-016: 大文字小文字区別なし | E-01 (L46), E-08 | ○ |
| C-17 | UT-HSN-017: headコンテキストでbody要素フィルタ | E-01 (L92-97), E-07 | ○ |
| C-18 | UT-HSN-018: DomVisitorキャッシュ | E-01 (L56) | △ |
| C-19 | UT-HSN-019: デフォルト設定初期化 | E-02 (L22, L57, L76, L102) | ○ |
| C-20 | UT-HSN-020: デフォルトアクション変更 | E-02 (L116-122) | ○ |
| C-21 | UT-HSN-021: イミュータブル性 | E-02 (L118: clone $this) | ○ |
| C-22 | UT-HSN-022: 全静的要素許可 | E-02 (L130-143), E-07 | ○ |
| C-23 | UT-HSN-023: 安全な要素のみ許可 | E-02 (L150-174), E-07 | ○ |
| C-24 | UT-HSN-024: 安全な属性のみ許可 | E-02 (L152-157), E-07 | ○ |
| C-25 | UT-HSN-025: 要素許可設定 | E-02 (L282-297) | ○ |
| C-26 | UT-HSN-026: ワイルドカード属性許可 | E-02 (L291), E-07 | ○ |
| C-27 | UT-HSN-027: 特定属性許可 | E-02 (L291-294) | ○ |
| C-28 | UT-HSN-028: blocked→allowed遷移 | E-02 (L287) | ○ |
| C-29 | UT-HSN-029: dropped→allowed遷移 | E-02 (L287) | ○ |
| C-30 | UT-HSN-030: 要素ブロック設定 | E-02 (L305-315) | ○ |
| C-31 | UT-HSN-031: allowed→blocked遷移 | E-02 (L310) | ○ |
| C-32 | UT-HSN-032: 要素ドロップ設定 | E-02 (L327-335) | ○ |
| C-33 | UT-HSN-033: allowed/blocked→dropped遷移 | E-02 (L330) | ○ |
| C-34 | UT-HSN-034: 属性ワイルドカード全許可要素追加 | E-02 (L347-364) | ○ |
| C-35 | UT-HSN-035: 属性特定要素追加 | E-02 (L350-356) | ○ |
| C-36 | UT-HSN-036: 指定外要素から属性除去 | E-02 (L357-359) | ○ |
| C-37 | UT-HSN-037: 属性ワイルドカードドロップ | E-02 (L380-392) | ○ |
| C-38 | UT-HSN-038: 属性個別ドロップ | E-02 (L385-389) | ○ |
| C-39 | UT-HSN-039: 強制属性設定 | E-02 (L399-405) | ○ |
| C-40 | UT-HSN-040: 複数強制属性 | E-02 (L402) | ○ |
| C-41 | UT-HSN-041: リンクスキーム設定 | E-02 (L183-189) | ○ |
| C-42 | UT-HSN-042: 空配列で全スキーム禁止 | E-02 (L186) | ○ |
| C-43 | UT-HSN-043: リンクホスト設定 | E-02 (L199-205) | ○ |
| C-44 | UT-HSN-044: nullで全ホスト許可 | E-02 (L202) | ○ |
| C-45 | UT-HSN-045: 相対リンク許可 | E-02 (L210-216) | ○ |
| C-46 | UT-HSN-046: 相対リンク禁止 | E-02 (L210-216) | ○ |
| C-47 | UT-HSN-047: メディアスキーム設定 | E-02 (L225-231) | ○ |
| C-48 | UT-HSN-048: メディアホスト設定 | E-02 (L241-247) | ○ |
| C-49 | UT-HSN-049: 相対メディアURL許可 | E-02 (L252-258) | ○ |
| C-50 | UT-HSN-050: HTTPS強制設定 | E-02 (L263-269) | ○ |
| C-51 | UT-HSN-051: 最大入力長設定 | E-02 (L436-446) | ○ |
| C-52 | UT-HSN-052: 最大入力長-1 | E-02 (L436-446) | ○ |
| C-53 | UT-HSN-053: -2以下で例外 | E-02 (L438-440) | ○ |
| C-54 | UT-HSN-054: 最大入力長0 | E-02 (L438) | ○ |
| C-55 | UT-HSN-055: カスタム属性サニタイザー追加 | E-02 (L410-416) | ○ |
| C-56 | UT-HSN-056: 属性サニタイザー除去 | E-02 (L421-430) | ○ |
| C-57 | UT-HSN-057: 未登録サニタイザー除去 | E-02 (L424-427) | ○ |
| C-58 | UT-HSN-058: デフォルトUrlAttributeSanitizer | E-02 (L106-108) | ○ |
| C-59 | UT-HSN-059: htmlLower大文字→小文字 | E-08 (L44-47) | ○ |
| C-60 | UT-HSN-060: htmlLower小文字そのまま | E-08 (L46) | ○ |
| C-61 | UT-HSN-061: htmlLower混合ケース | E-08 (L46) | ○ |
| C-62 | UT-HSN-062: htmlLower空文字列 | E-08 (L46) | ○ |
| C-63 | UT-HSN-063: encodeHtmlEntities HTMLエンコード | E-08 (L52-55) | ○ |
| C-64 | UT-HSN-064: encodeHtmlEntities特殊文字置換 | E-08 (L19-27) | ○ |
| C-65 | UT-HSN-065: encodeHtmlEntities全角文字置換 | E-08 (L29-37) | ○ |
| C-66 | UT-HSN-066: encodeHtmlEntities空文字列 | E-08 (L54) | ○ |
| C-67 | UT-HSN-067: encodeHtmlEntities通常テキスト | E-08 (L54) | ○ |
| C-68 | UT-HSN-068: UrlSanitizer有効HTTPS URL | E-09 (L32-73) | ○ |
| C-69 | UT-HSN-069: HTTP→HTTPS強制変換 | E-09 (L68-71) | ○ |
| C-70 | UT-HSN-070: null入力 | E-09 (L34-36) | ○ |
| C-71 | UT-HSN-071: 空文字列入力 | E-09 (L34-36) | ○ |
| C-72 | UT-HSN-072: 許可外スキーム | E-09 (L51-53) | ○ |
| C-73 | UT-HSN-073: 許可外ホスト | E-09 (L63-65) | ○ |
| C-74 | UT-HSN-074: 相対URL許可時 | E-09 (L46-48) | ○ |
| C-75 | UT-HSN-075: 相対URL禁止時 | E-09 (L46-48) | ○ |
| C-76 | UT-HSN-076: mailtoスキーム | E-09 (L56, L113-115) | ○ |
| C-77 | UT-HSN-077: dataスキーム | E-09 (L56, L113-115) | ○ |
| C-78 | UT-HSN-078: telスキーム | E-09 (L56, L113-115) | ○ |
| C-79 | UT-HSN-079: サブドメインマッチング | E-09 (L118-145) | △ |
| C-80 | UT-HSN-080: 空白含むURL | E-09 (L99-101) | ○ |
| C-81 | UT-HSN-081: URLパース基本動作 | E-09 (L90-111) | ○ |
| C-82 | UT-HSN-082: parse空文字列 | E-09 (L92-94) | ○ |
| C-83 | UT-HSN-083: parse不正URL | E-09 (L108-110) | ○ |
| C-84 | UT-HSN-084: ホスト名デコード検証 | E-09 (L103-105, L150-157) | △ |
| C-85 | UT-HSN-085: DomVisitorコンストラクタ | E-10 (L61-76) | ○ |
| C-86 | UT-HSN-086: 許可要素フィルタリング | E-10 (L97-114) | ○ |
| C-87 | UT-HSN-087: Block動作検証 | E-10 (L117-124) | ○ |
| C-88 | UT-HSN-088: Drop動作検証 | E-10 (L112-114) | ○ |
| C-89 | UT-HSN-089: 強制属性付与 | E-10 (L131-133) | ○ |
| C-90 | UT-HSN-090: テキストノードエンコード | E-10 (L145-147), E-17 | ○ |
| C-91 | UT-HSN-091: 属性フィルタリング | E-10 (L160-189) | ○ |
| C-92 | UT-HSN-092: 属性サニタイザー適用 | E-10 (L174-185), E-11 | ○ |
| C-93 | UT-HSN-093: デフォルトアクションBlock | E-10 (L99-101) | △ |
| C-94 | UT-HSN-094: デフォルトアクションAllow | E-10 (L99-101) | △ |
| C-95 | UT-HSN-095: ネスト要素処理 | E-10 (L86-95, L141-155) | ○ |
| C-96 | UT-HSN-096: childNodes null安全性 | E-10 (L144: ?? []) | △ |
| C-97 | UT-HSN-097: getSupportedElements null | E-11 (L22-26) | ○ |
| C-98 | UT-HSN-098: getSupportedAttributes | E-11 (L28-31) | ○ |
| C-99 | UT-HSN-099: a要素リンクサニタイズ | E-11 (L35-43) | ○ |
| C-100 | UT-HSN-100: メディア要素サニタイズ | E-11 (L45-51) | ○ |
| C-101 | UT-HSN-101: a要素javascriptスキーム | E-11 (L35-43), E-09 | ○ |
| C-102 | UT-HSN-102: Nodeコンストラクタ | E-14 (L43-47) | ○ |
| C-103 | UT-HSN-103: Node getParent | E-14 (L49-52) | ○ |
| C-104 | UT-HSN-104: setAttribute基本 | E-14 (L59-65) | ○ |
| C-105 | UT-HSN-105: setAttribute重複防止 | E-14 (L62) | ○ |
| C-106 | UT-HSN-106: setAttribute override | E-14 (L62) | ○ |
| C-107 | UT-HSN-107: getAttribute未設定 | E-14 (L54-57) | ○ |
| C-108 | UT-HSN-108: render通常要素 | E-14 (L72-84) | ○ |
| C-109 | UT-HSN-109: render void要素br | E-14 (L22-38, L74-75) | ○ |
| C-110 | UT-HSN-110: render void要素img | E-14 (L22-38, L74-75) | ○ |
| C-111 | UT-HSN-111: render属性付き要素 | E-14 (L78, L86-119) | ○ |
| C-112 | UT-HSN-112: renderバッククォート対策 | E-14 (L109-111) | ○ |
| C-113 | UT-HSN-113: render null属性除外 | E-14 (L90-93) | ○ |
| C-114 | UT-HSN-114: render空文字列属性 | E-14 (L97) | ○ |
| C-115 | UT-HSN-115: render複数子ノード | E-14 (L79-81) | ○ |
| C-116 | UT-HSN-116: render属性値エンコード | E-14 (L95, L113) | ○ |
| C-117 | UT-HSN-117: BlockedNodeコンストラクタ | E-15 (L21-24) | ○ |
| C-118 | UT-HSN-118: BlockedNode getParent | E-15 (L31-34) | ○ |
| C-119 | UT-HSN-119: BlockedNode addChild | E-15 (L26-29) | ○ |
| C-120 | UT-HSN-120: BlockedNode render子要素のみ | E-15 (L36-44) | ○ |
| C-121 | UT-HSN-121: BlockedNode render空 | E-15 (L36-44) | ○ |
| C-122 | UT-HSN-122: DocumentNode getParent null | E-16 (L26-29) | ○ |
| C-123 | UT-HSN-123: DocumentNode addChild | E-16 (L21-24) | ○ |
| C-124 | UT-HSN-124: DocumentNode render連結 | E-16 (L31-39) | ○ |
| C-125 | UT-HSN-125: DocumentNode render空 | E-16 (L31-39) | ○ |
| C-126 | UT-HSN-126: TextNodeコンストラクタ | E-17 (L21-25) | ○ |
| C-127 | UT-HSN-127: TextNode getParent | E-17 (L32-35) | ○ |
| C-128 | UT-HSN-128: TextNode addChild例外 | E-17 (L27-30) | ○ |
| C-129 | UT-HSN-129: TextNode renderエンコード | E-17 (L37-40) | ○ |
| C-130 | UT-HSN-130: TextNode render空 | E-17 (L37-40) | ○ |
| C-131 | UT-HSN-131: Cursorコンストラクタ | E-13 (L23-25) | ○ |
| C-132 | UT-HSN-132: Cursor nodeプロパティ | E-13 (L23) | ○ |
| C-133 | UT-HSN-133: NativeParser parse基本 | E-05 (L19-25) | ○ |
| C-134 | UT-HSN-134: NativeParser headコンテキスト | E-05 (L19-25) | ○ |
| C-135 | UT-HSN-135: NativeParser 空HTML | E-05 (L24) | ○ |
| C-136 | UT-HSN-136: NativeParser デフォルトcontext | E-05 (L19), E-06 (L28) | ○ |
| C-137 | UT-HSN-137: HtmlSanitizerAction Drop値 | E-03 (L19) | ○ |
| C-138 | UT-HSN-138: HtmlSanitizerAction Block値 | E-03 (L24) | ○ |
| C-139 | UT-HSN-139: HtmlSanitizerAction Allow値 | E-03 (L29) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-HSN-018（DomVisitorキャッシュ確認）**: `$this->domVisitors[$context] ??=` によるキャッシュは内部実装であり、外部から直接検証するにはReflectionが必要。テストケースとしては動作の一貫性で間接的に確認する方針。
  - 候補：Reflectionでprivateプロパティを確認 / 同一入力で結果一貫性を確認 / パフォーマンステストとして検証
- **UT-HSN-079（サブドメインマッチング）**: `matchAllowedHostParts`メソッドはprivateであり、`isAllowedHost`経由での間接テストとなる。ドメイン逆順比較ロジックの詳細な境界条件は実行時の動作確認が必要。
  - 候補：統合テストレベルでのURL許可・拒否の網羅確認
- **UT-HSN-084（ホスト名デコード検証）**: `decodeUnreservedCharacters`の正規表現パターンの挙動は複雑であり、具体的なエンコード済み文字のテストパターンは実装依存。
  - 候補：League\Uri\UriStringの実装仕様を参照 / 具体的なテストベクターを追加
- **UT-HSN-093/094（デフォルトアクション変更時のDomVisitor挙動）**: DomVisitorの`enterNode`内でdefaultAction参照されることはコードから確認できるが、実際のDOM入力を構築しての検証は統合テストレベル。
  - 候補：HtmlSanitizer経由での統合テスト / モックDOMNodeでの単体テスト
- **UT-HSN-096（childNodes null安全性）**: PHPのDOM APIにおいて`childNodes`がnullになるケースは限定的であり、nullsafe演算子`??`による保護はあるが、実際の発生条件は不明。
  - 候補：PHP DOM APIドキュメントの確認 / 特殊なDOMNode構造での検証

## 5) リスクフラグ（レビュー観点）
- **リスク2（高リスク）**: XSS関連のテストケース（UT-HSN-004, 006, 007, 063, 064, 072, 080, 084, 101, 112, 116, 129）- セキュリティに直結するため、テストケースの入力値と期待結果を慎重にレビューすること
- **リスク1（中リスク）**: URL検証関連（UT-HSN-068-084）- URLパースライブラリ（League\Uri）への依存があり、ライブラリバージョンによる挙動差異に注意
- **リスク1（中リスク）**: DOM API依存（UT-HSN-133-136）- PHP 8.4の新しいDom APIに依存しており、バージョン互換性に注意
- **リスク0（低リスク）**: 設定クラスのイミュータブル設計テスト（UT-HSN-019-058）- cloneによるイミュータブル性は明確にコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] セキュリティ関連テストケース（XSS防止）の入力パターンが十分に網羅されているか
- [ ] URL検証のテストケースでjavascript:, data:, vbscript:等の危険なスキームがカバーされているか
- [ ] HtmlSanitizerConfigの全publicメソッドがテスト対象に含まれているか
- [ ] Node.phpのVOID_ELEMENTS定数に含まれる要素のレンダリングテストが含まれているか
- [ ] DomVisitorのAllow/Block/Dropの3アクション全てがテストされているか
- [ ] イミュータブル設計（clone $this）による副作用のないことのテストが含まれているか
- [ ] 全角特殊文字（DB互換性対策）のエンコードテストが含まれているか
- [ ] TextNodeのaddChild例外テストが含まれているか
