---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 217
  claims_with_evidence: 209
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：Component-HttpClient 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：209 / 217、根拠なし：8
- 優先レビュー（高）
  1. **UT-HTC-001〜003 (HttpClient::create)**: ランタイム環境依存のため、テスト実行環境によって動作が変わる可能性
  2. **UT-HTC-096〜100 (NoPrivateNetworkHttpClient IP検証)**: DNS解決やネットワーク環境に依存するテスト
  3. **UT-HTC-116〜119 (CachingHttpClient キャッシュ動作)**: TagAwareCacheInterfaceのモック構成が複雑

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/HttpClient/HttpClient.php` - ファクトリクラス（create, createForBaseUri）
- E-02: `src/Symfony/Component/HttpClient/HttpClientTrait.php` - 共通ロジック（prepareRequest, parseUrl, resolveUrl, normalizeHeaders, normalizeBody, mergeDefaultOptions, jsonEncode等）
- E-03: `src/Symfony/Component/HttpClient/HttpOptions.php` - オプションビルダー（setAuthBasic, setAuthBearer, setQuery, setHeader等25メソッド）
- E-04: `src/Symfony/Component/HttpClient/MockHttpClient.php` - テスト用クライアント（request, stream, setResponseFactory, reset等）
- E-05: `src/Symfony/Component/HttpClient/ScopingHttpClient.php` - スコープ付きクライアント（forBaseUri, request, reset, withOptions）
- E-06: `src/Symfony/Component/HttpClient/RetryableHttpClient.php` - リトライクライアント（request, withOptions, getDelayFromHeader, shiftBaseUri）
- E-07: `src/Symfony/Component/HttpClient/NoPrivateNetworkHttpClient.php` - プライベートネットワークブロック（request, dnsResolve, ipCheck, reset）
- E-08: `src/Symfony/Component/HttpClient/EventSourceHttpClient.php` - SSEクライアント（connect, request）
- E-09: `src/Symfony/Component/HttpClient/TraceableHttpClient.php` - トレースクライアント（request, stream, getTracedRequests, reset）
- E-10: `src/Symfony/Component/HttpClient/ThrottlingHttpClient.php` - スロットリングクライアント（request, reset）
- E-11: `src/Symfony/Component/HttpClient/UriTemplateHttpClient.php` - URIテンプレートクライアント（request, withOptions, createExpanderFromPopularVendors）
- E-12: `src/Symfony/Component/HttpClient/CachingHttpClient.php` - キャッシュクライアント（request, stream, evaluateCacheFreshness, determineMaxAge, isServerResponseCacheable, parseCacheControlHeader等）
- E-13: `src/Symfony/Component/HttpClient/Chunk/DataChunk.php` - データチャンク（getContent, getOffset, isTimeout, isFirst, isLast等）
- E-14: `src/Symfony/Component/HttpClient/Chunk/FirstChunk.php` - 最初のチャンク（isFirst）
- E-15: `src/Symfony/Component/HttpClient/Chunk/LastChunk.php` - 最後のチャンク（isLast）
- E-16: `src/Symfony/Component/HttpClient/Chunk/ErrorChunk.php` - エラーチャンク（isTimeout, isFirst, isLast, getError, didThrow, __serialize等）
- E-17: `src/Symfony/Component/HttpClient/Chunk/ServerSentEvent.php` - SSEイベント（getId, getType, getData, getRetry, getArrayData）
- E-18: `src/Symfony/Component/HttpClient/Retry/GenericRetryStrategy.php` - リトライ戦略（shouldRetry, getDelay, コンストラクタバリデーション）
- E-19: `src/Symfony/Component/HttpClient/Response/MockResponse.php` - モックレスポンス（fromRequest, fromFile, cancel, getRequestOptions等）
- E-20: `src/Symfony/Component/HttpClient/Response/JsonMockResponse.php` - JSONモックレスポンス（__construct, fromFile）
- E-21: `src/Symfony/Component/HttpClient/Response/AsyncContext.php` - 非同期コンテキスト（getStatusCode, getHeaders, createChunk, cancel, setInfo, replaceRequest等）
- E-22: `src/Symfony/Component/HttpClient/Response/ResponseStream.php` - レスポンスストリーム（key, current, next, rewind, valid）
- E-23: `src/Symfony/Component/HttpClient/Messenger/PingWebhookMessage.php` - Webhookメッセージ（__construct, __toString）
- E-24: `src/Symfony/Component/HttpClient/Messenger/PingWebhookMessageHandler.php` - Webhookハンドラ（__invoke）
- E-25: `src/Symfony/Component/HttpClient/DataCollector/HttpClientDataCollector.php` - データコレクタ（registerClient, lateCollect, getRequestCount, getErrorCount等）
- E-26: `src/Symfony/Component/HttpClient/DependencyInjection/HttpClientPass.php` - DIコンパイラパス（process）
- E-27: `src/Symfony/Component/HttpClient/Exception/HttpExceptionTrait.php` - HTTP例外トレイト（__construct, getResponse）
- E-28: `src/Symfony/Component/HttpClient/Caching/Freshness.php` - 鮮度enum（Fresh, MustRevalidate, Stale, StaleButUsable）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HttpClient::createがcurl拡張有効時にCurlHttpClientを返す | E-01 L52-55 | ○ |
| C-02 | HttpClient::createがAmpクラス存在時にAmpHttpClientを返す | E-01 L33-48 | ○ |
| C-03 | HttpClient::createがフォールバックでNativeHttpClientを返す | E-01 L64-67 | ○ |
| C-04 | HttpClient::createForBaseUriがScopingHttpClientを返す | E-01 L72-77 | ○ |
| C-05 | prepareRequestが小文字メソッドを拒否する | E-02 L47-49 | ○ |
| C-06 | prepareRequestが空メソッドを拒否する | E-02 L50-52 | ○ |
| C-07 | prepareRequestがjsonオプションをJSON bodyに変換する | E-02 L83-93 | ○ |
| C-08 | prepareRequestがjsonとbodyの同時指定を拒否する | E-02 L84-85 | ○ |
| C-09 | prepareRequestがauth_basicを処理する | E-02 L133-143 | ○ |
| C-10 | prepareRequestがauth_bearerを処理する | E-02 L146-153 | ○ |
| C-11 | prepareRequestがauth_basicとauth_bearerの同時指定を拒否する | E-02 L155-157 | ○ |
| C-12 | parseUrlがバックスラッシュ含むURLを拒否する | E-02 L645-647 | ○ |
| C-13 | parseUrlがCR/LF/TAB含むURLを拒否する | E-02 L648-649 | ○ |
| C-14 | parseUrlが非対応スキームを拒否する | E-02 L677-679 | ○ |
| C-15 | resolveUrlが相対URLを正しく解決する | E-02 L574-636 | ○ |
| C-16 | normalizeHeadersがCR/LF/NUL含むヘッダーを拒否する | E-02 L322-323 | ○ |
| C-17 | normalizeBodyが配列をURLエンコードに変換する | E-02 L340-371 | ○ |
| C-18 | normalizePeerFingerprintがSHA256を検出する | E-02 L533-537 | ○ |
| C-19 | normalizePeerFingerprintが不正長を拒否する | E-02 L538 | ○ |
| C-20 | GenericRetryStrategy::shouldRetryが503でtrueを返す | E-18 L73 | ○ |
| C-21 | GenericRetryStrategy::shouldRetryが500+GETでtrueを返す | E-18 L76-77 | ○ |
| C-22 | GenericRetryStrategy::shouldRetryが500+POSTでfalseを返す | E-18 L76-77 | ○ |
| C-23 | GenericRetryStrategy::getDelayが指数的に増加する | E-18 L95 | ○ |
| C-24 | MockHttpClient::requestがイテレータ枯渇時に例外を投げる | E-04 L71-72 | ○ |
| C-25 | ServerSentEvent::getArrayDataが空dataで例外を投げる | E-17 L98-99 | ○ |
| C-26 | NoPrivateNetworkHttpClient::ipCheckがプライベートIPをブロックする | E-07 L209-228 | ○ |
| C-27 | CachingHttpClient::evaluateCacheFreshnessがno-cacheをStaleと判定する | E-12 L482-483 | ○ |
| C-28 | CachingHttpClient::isServerResponseCacheableがno-storeでfalseを返す | E-12 L613-615 | ○ |
| C-29 | HttpExceptionTraitがhydra:titleを抽出する | E-27 L57-60 | ○ |
| C-30 | HttpExceptionTraitがRFC7807のtitle/detailを抽出する | E-27 L61-66 | ○ |
| C-31 | HttpClient::createのランタイム環境分岐の全パターン網羅 | E-01 | △ |
| C-32 | NoPrivateNetworkHttpClient DNS解決の全パターン | E-07 L174-207 | △ |
| C-33 | CachingHttpClientの304応答時のキャッシュ更新動作 | E-12 L226-241 | △ |
| C-34 | EventSourceHttpClientの再接続動作の完全なテスト | E-08 L87-105 | △ |
| C-35 | RetryableHttpClient のリトライコールバック内の全分岐 | E-06 L83-163 | △ |
| C-36 | CachingHttpClient Vary ヘッダー変更時のキャッシュ無効化 | E-12 L271-296 | △ |
| C-37 | HttpClientDataCollectorのcurlコマンド生成の全パターン | E-25 L179-253 | △ |
| C-38 | AsyncContext::replaceRequestのmax_duration計算ロジック | E-21 L167-171 | △ |

## 4) 不足情報（Unknown / Missing）
- **ランタイム環境依存テスト（C-31）**: HttpClient::createのcurl拡張、Ampクラスの有無、curlバージョンなどの全組み合わせはモック化が困難
  - 候補：環境別のインテグレーションテスト / PHPUnit process isolation
- **DNS解決テスト（C-32）**: gethostbynamel、dns_get_recordなどのネットワーク関数をモック化する必要
  - 候補：php-mockライブラリ / dns_get_recordのstub
- **キャッシュ統合テスト（C-33, C-36）**: TagAwareCacheInterfaceの詳細な動作シミュレーションが必要
  - 候補：InMemoryTagAwareCache / PSR-6のモック実装
- **SSE再接続テスト（C-34）**: 非同期チャンク処理のタイムアウト・再接続シナリオの完全な再現
  - 候補：MockResponseのイテレータ制御
- **リトライコールバック全分岐（C-35）**: AsyncResponse内のジェネレータコールバックの全分岐テスト
  - 候補：各分岐条件のMockResponse設定
- **curlコマンド生成（C-37）**: debugログのパース結果に依存するため、全パターンの網羅は困難
  - 候補：固定debugログ文字列によるテスト
- **max_duration計算（C-38）**: total_timeとmax_durationの組み合わせ条件
  - 候補：MockResponseのinfo設定によるテスト

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**: HttpClient::createのランタイム判定ロジックは環境依存であり、CIでの全パターン検証が困難
- **リスク1（中）**: NoPrivateNetworkHttpClientのDNS解決はネットワーク依存のため、ユニットテストでの完全な検証が困難
- **リスク0（低）**: CachingHttpClientのRFC 9111準拠は記載の制約事項（Rangeリクエスト非対応等）を考慮済み
- **リスク0（低）**: HttpOptions の各setterメソッドは単純な代入処理のため、テストは信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがpublicメソッド・関数を網羅しているか（特にHttpClientTrait内のprivateメソッドはtrait利用クラス経由で間接テスト可能か）
- [ ] 認証関連テスト（UT-HTC-010〜016）がセキュリティ要件を満たしているか
- [ ] CachingHttpClientのキャッシュ判定テスト（UT-HTC-116〜133）がRFC 9111の主要ケースを網羅しているか
- [ ] GenericRetryStrategyのリトライ判定テスト（UT-HTC-165〜173）が冪等メソッド区別を正しくカバーしているか
- [ ] ServerSentEventのパーステスト（UT-HTC-149〜159）がSSE仕様の主要パターンを網羅しているか
- [ ] NoPrivateNetworkHttpClientのIPブロックテスト（UT-HTC-094〜100）がIPv4/IPv6の両方を考慮しているか
- [ ] 境界値テスト（空配列、null、空文字列等）が重要なメソッドに対して設定されているか
