---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 257
  claims_with_evidence: 249
  claims_without_evidence: 8
confidence_derived: 0.97
---

# 根拠レポート：Component-HttpFoundation 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（Component-HttpFoundation.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：249 / 257、根拠なし：8
- 優先レビュー（高）
  1. **UT-HTF-006, UT-HTF-007, UT-HTF-008（Request::create 異常系）**：BadRequestExceptionがスローされる条件はcreateメソッド内のバリデーションロジック依存であり、実際のURI解析はinitializeメソッド経由のためランタイム検証が必要
  2. **UT-HTF-014（Request::getMethod オーバーライド無視）**：GET/HEAD/CONNECT/TRACEへのオーバーライドが無視される動作は、setAllowedHttpMethodOverrideのデフォルト値依存であり、バージョン間差異の確認が必要
  3. **UT-HTF-045（Request::getFormat サフィックス解決）**：構造化サフィックス（+json等）からのフォーマット解決はgetFormatメソッド内部の分岐ロジックに依存し、全パターンの網羅確認が必要
  4. **UT-HTF-252, UT-HTF-254（UrlHelper）**：RequestStackとRequestContextのフォールバック動作は実行時コンテキスト依存
  5. **UT-HTF-251（ServerEvent iterableデータ）**：iterableなデータの複数行出力パターンはgetIteratorのジェネレータ実装依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/HttpFoundation/Request.php` - HTTPリクエスト抽象クラス（約1,900行）。コンストラクタ、create、duplicate、getMethod、getHost、isSecure、getClientIp/getClientIps、getPort、getUri、getContent、toArray、getPayload、getFormat、getMimeType、getPreferredLanguage、isXmlHttpRequest、isMethodSafe、setTrustedProxies、setTrustedHosts、getSession、getLocale等
- E-02: `src/Symfony/Component/HttpFoundation/Response.php` - HTTPレスポンス抽象クラス（約700行）。コンストラクタ、setStatusCode、setContent、isInformational/isSuccessful/isRedirection/isClientError/isServerError、setCache、setEtag、setNotModified、isNotModified、isCacheable、getMaxAge、prepare、setVary等
- E-03: `src/Symfony/Component/HttpFoundation/ParameterBag.php` - パラメータコンテナ基底クラス。all、get、has、set、remove、getInt、getBoolean、getAlpha、getAlnum、getDigits、getString、getEnum、filter、count等
- E-04: `src/Symfony/Component/HttpFoundation/HeaderBag.php` - HTTPヘッダコンテナ。get、set、has、contains、remove、getDate、addCacheControlDirective、removeCacheControlDirective等
- E-05: `src/Symfony/Component/HttpFoundation/Cookie.php` - Cookie表現クラス。コンストラクタバリデーション（空名前、予約文字）、fromString、isCleared、withSameSite、__toString、expiresTimestamp、setSecureDefault等
- E-06: `src/Symfony/Component/HttpFoundation/InputBag.php` - ユーザー入力コンテナ（final class）。get（スカラー検証）、set（型チェック）、filter（FILTER_REQUIRE_ARRAY）、getEnum（BadRequestException変換）
- E-07: `src/Symfony/Component/HttpFoundation/HeaderUtils.php` - 静的ユーティリティクラス。split、combine、toString、quote、unquote、makeDisposition、parseQuery等
- E-08: `src/Symfony/Component/HttpFoundation/IpUtils.php` - IPユーティリティクラス。checkIp、checkIp4、checkIp6（CIDR対応）、anonymize（バイトマスキング）、isPrivateIp等
- E-09: `src/Symfony/Component/HttpFoundation/JsonResponse.php` - JSONレスポンスクラス。コンストラクタ（jsonフラグ）、setData（エンコード）、setCallback（JSONP）、fromJsonString等
- E-10: `src/Symfony/Component/HttpFoundation/UriSigner.php` - URI署名クラス（HMAC-SHA256）。sign（有効期限対応）、check、verify（型付き例外）等
- E-11: `src/Symfony/Component/HttpFoundation/RedirectResponse.php` - リダイレクトレスポンスクラス。コンストラクタ（リダイレクトステータス検証）、setTargetUrl（空URL拒否）
- E-12: `src/Symfony/Component/HttpFoundation/ServerBag.php` - サーバー変数コンテナ。getHeaders（HTTP_プレフィックス抽出、Basic/Digest/Bearer認証、REDIRECT_HTTP_AUTHORIZATION）
- E-13: `src/Symfony/Component/HttpFoundation/FileBag.php` - アップロードファイルコンテナ。set（array/UploadedFile検証）、convertFileInformation、fixPhpFilesArray、UPLOAD_ERR_NO_FILE処理
- E-14: `src/Symfony/Component/HttpFoundation/ResponseHeaderBag.php` - レスポンスヘッダコンテナ。setCookie、removeCookie、clearCookie、getCookies（FLAT/ARRAY）、computeCacheControlValue
- E-15: `src/Symfony/Component/HttpFoundation/AcceptHeader.php` - Acceptヘッダパーサ。fromString、has、get（ワイルドカードマッチング）、first、filter、specificity-basedソーティング
- E-16: `src/Symfony/Component/HttpFoundation/AcceptHeaderItem.php` - Acceptヘッダ項目。fromString、setAttribute（qは品質設定）、getValue、getQuality
- E-17: `src/Symfony/Component/HttpFoundation/RequestStack.php` - リクエストライフサイクル管理。push、pop、getCurrentRequest、getMainRequest、getParentRequest、getSession
- E-18: `src/Symfony/Component/HttpFoundation/BinaryFileResponse.php` - ファイルダウンロードレスポンス。setFile（auto ETag/LastModified）、prepare（Range対応）、setChunkSize検証、setContent例外
- E-19: `src/Symfony/Component/HttpFoundation/StreamedResponse.php` - ストリームレスポンス。setCallback、setChunks、sendContent（callback必須）、setContent例外
- E-20: `src/Symfony/Component/HttpFoundation/ServerEvent.php` - SSEイベント。getIterator（SSE形式出力：comment、id、retry、event、data）
- E-21: `src/Symfony/Component/HttpFoundation/UrlHelper.php` - URL操作ヘルパー。getAbsoluteUrl、getRelativePath、RequestContextフォールバック
- E-22: `src/Symfony/Component/HttpFoundation/ChainRequestMatcher.php` - チェインリクエストマッチャー。matches（全マッチャー一致判定）

## 3) Claims と根拠の対応（レビューの主戦場）

### Request クラス（UT-HTF-001 〜 UT-HTF-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | デフォルト引数でRequestが生成される | E-01 (L46-55: __construct) | ○ |
| C-002 | 全パラメータ指定でRequestが生成される | E-01 (L46-55: __construct) | ○ |
| C-003 | GETリクエストがcreateで正しく生成される | E-01 (create メソッド) | ○ |
| C-004 | POSTリクエストがcreateで正しく生成される | E-01 (create メソッド) | ○ |
| C-005 | HTTPSリクエストがcreateで正しく生成される | E-01 (create メソッド) | ○ |
| C-006 | 不正なURIでBadRequestExceptionがスローされる | E-01 (create 内バリデーション) | △ |
| C-007 | バックスラッシュを含むURIでBadRequestExceptionがスローされる | E-01 (create 内バリデーション) | △ |
| C-008 | CR/LF/TABを含むURIでBadRequestExceptionがスローされる | E-01 (create 内バリデーション) | △ |
| C-009 | リクエストの複製が正しく行われる | E-01 (duplicate メソッド) | ○ |
| C-010 | null指定のパラメータは元のリクエストから引き継がれる | E-01 (duplicate メソッド) | ○ |
| C-011 | REQUEST_METHODからメソッドが取得される | E-01 (getMethod メソッド) | ○ |
| C-012 | REQUEST_METHOD未設定時にGETがデフォルトで返る | E-01 (getMethod メソッド) | ○ |
| C-013 | X-HTTP-Method-Overrideヘッダでメソッドがオーバーライドされる | E-01 (getMethod メソッド) | ○ |
| C-014 | GET/HEAD/CONNECT/TRACEへのオーバーライドが無視される | E-01 (getMethod / setAllowedHttpMethodOverride) | △ |
| C-015 | 不正な文字を含むメソッドでSuspiciousOperationExceptionがスローされる | E-01 (getMethod メソッド内の正規表現チェック) | ○ |
| C-016 | 許可されたメソッドのみオーバーライド可能 | E-01 (setAllowedHttpMethodOverride メソッド) | ○ |
| C-017 | GET/HEAD/CONNECT/TRACEを許可リストに含めると例外 | E-01 (setAllowedHttpMethodOverride メソッド) | ○ |
| C-018 | HTTP_HOSTヘッダからホスト名が取得される | E-01 (getHost メソッド) | ○ |
| C-019 | ポート番号付きホストからポートが除去される | E-01 (getHost メソッド) | ○ |
| C-020 | 不正なホスト名でSuspiciousOperationExceptionがスローされる | E-01 (getHost メソッド) | ○ |
| C-021 | 信頼済みプロキシ経由でX-Forwarded-Hostが使用される | E-01 (getHost / getTrustedValues) | ○ |
| C-022 | HTTPS=onの場合にisSecureがtrue | E-01 (isSecure メソッド) | ○ |
| C-023 | HTTPS=offの場合にisSecureがfalse | E-01 (isSecure メソッド) | ○ |
| C-024 | 信頼済みプロキシ経由でX-Forwarded-Proto使用 | E-01 (isSecure / getTrustedValues) | ○ |
| C-025 | REMOTE_ADDRからクライアントIPが取得される | E-01 (getClientIp メソッド) | ○ |
| C-026 | X-Forwarded-ForからIPリストが取得される | E-01 (getClientIps メソッド) | ○ |
| C-027 | SERVER_PORTからポートが取得される | E-01 (getPort メソッド) | ○ |
| C-028 | HTTPSの場合にデフォルト443が返る | E-01 (getPort メソッド) | ○ |
| C-029 | 完全なURIが正しく構築される | E-01 (getUri メソッド) | ○ |
| C-030 | 指定パスのURIが構築される | E-01 (getUriForPath メソッド) | ○ |
| C-031 | 相対URIが正しく計算される | E-01 (getRelativeUriForPath メソッド) | ○ |
| C-032 | 同一パスの場合に空文字が返る | E-01 (getRelativeUriForPath メソッド) | ○ |
| C-033 | クエリ文字列がアルファベット順にソートされる | E-01 (normalizeQueryString メソッド) | ○ |
| C-034 | 空文字列の場合に空文字が返る | E-01 (normalizeQueryString メソッド) | ○ |
| C-035 | nullの場合に空文字が返る | E-01 (normalizeQueryString メソッド) | ○ |
| C-036 | 文字列コンテンツが取得される | E-01 (getContent メソッド) | ○ |
| C-037 | リソースとしてコンテンツが取得される | E-01 (getContent メソッド) | ○ |
| C-038 | JSONコンテンツが配列にデコードされる | E-01 (toArray メソッド) | ○ |
| C-039 | 空のコンテンツでJsonExceptionがスローされる | E-01 (toArray メソッド) | ○ |
| C-040 | 不正なJSONでJsonExceptionがスローされる | E-01 (toArray メソッド) | ○ |
| C-041 | 配列以外のJSONでJsonExceptionがスローされる | E-01 (toArray メソッド) | ○ |
| C-042 | POSTパラメータがInputBagクローンで返る | E-01 (getPayload メソッド) | ○ |
| C-043 | JSONコンテンツがInputBagとして返る | E-01 (getPayload メソッド) | ○ |
| C-044 | MIMEタイプからフォーマットが取得される | E-01 (getFormat メソッド) | ○ |
| C-045 | 構造化サフィックスからフォーマットが解決される | E-01 (getFormat メソッド) | △ |
| C-046 | nullのMIMEタイプでnullが返る | E-01 (getFormat メソッド) | ○ |
| C-047 | フォーマットからMIMEタイプが取得される | E-01 (getMimeType メソッド) | ○ |
| C-048 | 不明なフォーマットでnullが返る | E-01 (getMimeType メソッド) | ○ |
| C-049 | Accept-Languageからの優先言語が取得される | E-01 (getPreferredLanguage メソッド) | ○ |
| C-050 | localesが空の場合に最優先の言語が返る | E-01 (getPreferredLanguage メソッド) | ○ |
| C-051 | Accept-Languageヘッダから言語リストが取得される | E-01 (getLanguages メソッド) | ○ |
| C-052 | X-Requested-With: XMLHttpRequestでtrue | E-01 (isXmlHttpRequest メソッド) | ○ |
| C-053 | X-Requested-Withヘッダなしでfalse | E-01 (isXmlHttpRequest メソッド) | ○ |
| C-054 | GETメソッドがセーフと判定される | E-01 (isMethodSafe メソッド) | ○ |
| C-055 | POSTメソッドがセーフでないと判定される | E-01 (isMethodSafe メソッド) | ○ |
| C-056 | GETメソッドがキャッシュ可能と判定される | E-01 (isMethodCacheable メソッド) | ○ |
| C-057 | POSTメソッドがキャッシュ不可と判定される | E-01 (isMethodCacheable メソッド) | ○ |
| C-058 | 信頼済みプロキシが正しく設定される | E-01 (setTrustedProxies メソッド) | ○ |
| C-059 | PRIVATE_SUBNETSが展開される | E-01 (setTrustedProxies メソッド) | ○ |
| C-060 | 信頼済みホストパターンが設定される | E-01 (setTrustedHosts メソッド) | ○ |
| C-061 | 設定済みセッションが取得される | E-01 (getSession メソッド) | ○ |
| C-062 | セッション未設定でSessionNotFoundException | E-01 (getSession メソッド) | ○ |
| C-063 | 設定されたロケールが取得される | E-01 (getLocale メソッド) | ○ |
| C-064 | ロケール未設定時にデフォルトロケールが返る | E-01 (getLocale メソッド) | ○ |

### Response クラス（UT-HTF-065 〜 UT-HTF-097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-065 | デフォルトパラメータでResponseが生成される | E-02 (__construct) | ○ |
| C-066 | 有効なステータスコードが設定される | E-02 (setStatusCode) | ○ |
| C-067 | ステータステキストが自動設定される | E-02 (setStatusCode / $statusTexts) | ○ |
| C-068 | カスタムステータステキストが設定される | E-02 (setStatusCode) | ○ |
| C-069 | 無効なステータスコード（99）で例外 | E-02 (setStatusCode) | ○ |
| C-070 | 600以上のステータスコードで例外 | E-02 (setStatusCode) | ○ |
| C-071 | コンテンツが設定される | E-02 (setContent) | ○ |
| C-072 | nullでコンテンツが空文字にリセット | E-02 (setContent) | ○ |
| C-073 | 1xxステータスでisInformationalがtrue | E-02 (isInformational) | ○ |
| C-074 | 2xxステータスでisSuccessfulがtrue | E-02 (isSuccessful) | ○ |
| C-075 | 3xxステータスでisRedirectionがtrue | E-02 (isRedirection) | ○ |
| C-076 | 4xxステータスでisClientErrorがtrue | E-02 (isClientError) | ○ |
| C-077 | 5xxステータスでisServerErrorがtrue | E-02 (isServerError) | ○ |
| C-078 | 200ステータスでisOkがtrue | E-02 (isOk) | ○ |
| C-079 | 301ステータスでisRedirectがtrue | E-02 (isRedirect) | ○ |
| C-080 | Locationマッチ時にisRedirectがtrue | E-02 (isRedirect) | ○ |
| C-081 | 204ステータスでisEmptyがtrue | E-02 (isEmpty) | ○ |
| C-082 | 304ステータスでisEmptyがtrue | E-02 (isEmpty) | ○ |
| C-083 | キャッシュオプションが正しく設定される | E-02 (setCache) | ○ |
| C-084 | 不正なキャッシュオプションで例外 | E-02 (setCache) | ○ |
| C-085 | ETagが正しく設定される | E-02 (setEtag) | ○ |
| C-086 | 弱いETagが設定される | E-02 (setEtag) | ○ |
| C-087 | nullでETagが削除される | E-02 (setEtag) | ○ |
| C-088 | 304レスポンスに変換される | E-02 (setNotModified) | ○ |
| C-089 | ETagマッチでisNotModifiedがtrue | E-02 (isNotModified) | ○ |
| C-090 | Last-ModifiedマッチでisNotModifiedがtrue | E-02 (isNotModified) | ○ |
| C-091 | public 200 ETag付きがキャッシュ可能 | E-02 (isCacheable) | ○ |
| C-092 | no-storeでキャッシュ不可 | E-02 (isCacheable) | ○ |
| C-093 | s-maxageが最優先で返る | E-02 (getMaxAge) | ○ |
| C-094 | s-maxageがない場合にmax-ageが返る | E-02 (getMaxAge) | ○ |
| C-095 | HEADリクエストでコンテンツが空になる | E-02 (prepare) | ○ |
| C-096 | 204レスポンスでContent-Typeが削除される | E-02 (prepare) | ○ |
| C-097 | Varyヘッダが設定される | E-02 (setVary) | ○ |

### ParameterBag クラス（UT-HTF-098 〜 UT-HTF-121）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-098 | 全パラメータが返される | E-03 (all) | ○ |
| C-099 | キー指定で配列値が返される | E-03 (all) | ○ |
| C-100 | キー指定で値が配列でない場合に例外 | E-03 (all) | ○ |
| C-101 | キーに対応する値が返される | E-03 (get) | ○ |
| C-102 | 存在しないキーでデフォルト値が返る | E-03 (get) | ○ |
| C-103 | 存在するキーでhas()がtrue | E-03 (has) | ○ |
| C-104 | 存在しないキーでhas()がfalse | E-03 (has) | ○ |
| C-105 | 値が正しくセットされる | E-03 (set) | ○ |
| C-106 | パラメータが削除される | E-03 (remove) | ○ |
| C-107 | 整数値が返される | E-03 (getInt) | ○ |
| C-108 | 整数デフォルト値が返る | E-03 (getInt) | ○ |
| C-109 | trueの文字列表現でtrue | E-03 (getBoolean) | ○ |
| C-110 | falseの文字列表現でfalse | E-03 (getBoolean) | ○ |
| C-111 | アルファベット文字のみが返される | E-03 (getAlpha) | ○ |
| C-112 | 英数字のみが返される | E-03 (getAlnum) | ○ |
| C-113 | 数字のみが返される | E-03 (getDigits) | ○ |
| C-114 | 文字列値が返される | E-03 (getString) | ○ |
| C-115 | 非スカラー値でUnexpectedValueException | E-03 (getString) | ○ |
| C-116 | BackedEnumが正しく返される | E-03 (getEnum) | ○ |
| C-117 | 不正なenum値でUnexpectedValueException | E-03 (getEnum) | ○ |
| C-118 | FILTER_VALIDATE_INTでフィルタリングされる | E-03 (filter) | ○ |
| C-119 | フィルタリング失敗でUnexpectedValueException | E-03 (filter) | ○ |
| C-120 | パラメータ数が返される | E-03 (count) | ○ |
| C-121 | 空のBagで0が返る | E-03 (count) | ○ |

### HeaderBag クラス（UT-HTF-122 〜 UT-HTF-133）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | ヘッダ値が取得される | E-04 (get) | ○ |
| C-123 | 大文字小文字を問わずヘッダが取得される | E-04 (get) | ○ |
| C-124 | 存在しないヘッダでデフォルト値が返る | E-04 (get) | ○ |
| C-125 | ヘッダが設定される | E-04 (set) | ○ |
| C-126 | replace=falseで値が追加される | E-04 (set) | ○ |
| C-127 | 存在するヘッダでhas()がtrue | E-04 (has) | ○ |
| C-128 | ヘッダが削除される | E-04 (remove) | ○ |
| C-129 | 指定値を含むヘッダでcontains()がtrue | E-04 (contains) | ○ |
| C-130 | 日付ヘッダがDateTimeImmutableとして返る | E-04 (getDate) | ○ |
| C-131 | 不正な日付ヘッダでRuntimeException | E-04 (getDate) | ○ |
| C-132 | Cache-Controlディレクティブが追加される | E-04 (addCacheControlDirective) | ○ |
| C-133 | Cache-Controlディレクティブが削除される | E-04 (removeCacheControlDirective) | ○ |

### InputBag クラス（UT-HTF-134 〜 UT-HTF-139）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-134 | スカラー値が取得される | E-06 (get) | ○ |
| C-135 | 非スカラー値でBadRequestException | E-06 (get) | ○ |
| C-136 | 非スカラーデフォルト値でInvalidArgumentException | E-06 (get) | ○ |
| C-137 | スカラー値が設定される | E-06 (set) | ○ |
| C-138 | オブジェクト値でInvalidArgumentException | E-06 (set) | ○ |
| C-139 | 配列値でFILTER_REQUIRE_ARRAYなしに例外 | E-06 (filter) | ○ |

### Cookie クラス（UT-HTF-140 〜 UT-HTF-153）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-140 | 有効なCookieが生成される | E-05 (__construct) | ○ |
| C-141 | 空の名前でInvalidArgumentException | E-05 (__construct) | ○ |
| C-142 | raw=trueで予約文字を含む名前で例外 | E-05 (__construct) | ○ |
| C-143 | DateTimeInterface形式の有効期限が処理される | E-05 (__construct / expiresTimestamp) | ○ |
| C-144 | 文字列形式の有効期限が処理される | E-05 (__construct / expiresTimestamp) | ○ |
| C-145 | 不正な有効期限文字列でInvalidArgumentException | E-05 (expiresTimestamp) | ○ |
| C-146 | ヘッダ文字列からCookieが生成される | E-05 (fromString) | ○ |
| C-147 | 過去の有効期限でisClearedがtrue | E-05 (isCleared) | ○ |
| C-148 | expire=0でisClearedがfalse | E-05 (isCleared) | ○ |
| C-149 | SameSite属性が正しく設定される | E-05 (withSameSite) | ○ |
| C-150 | 不正なSameSite値でInvalidArgumentException | E-05 (withSameSite) | ○ |
| C-151 | Cookie文字列が正しく生成される | E-05 (__toString) | ○ |
| C-152 | 空値のCookieがdeleted形式で出力される | E-05 (__toString) | ○ |
| C-153 | secure=nullの場合secureDefaultが使用される | E-05 (isSecure / setSecureDefault) | ○ |

### HeaderUtils クラス（UT-HTF-154 〜 UT-HTF-166）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-154 | カンマ区切りヘッダが分割される | E-07 (split) | ○ |
| C-155 | 空のセパレータでInvalidArgumentException | E-07 (split) | ○ |
| C-156 | 配列がキーバリューペアに変換される | E-07 (combine) | ○ |
| C-157 | 連想配列が文字列に変換される | E-07 (toString) | ○ |
| C-158 | 特殊文字を含む値がクォートされる | E-07 (quote) | ○ |
| C-159 | トークン文字のみの値がそのまま返る | E-07 (quote) | ○ |
| C-160 | クォートされた値がデコードされる | E-07 (unquote) | ○ |
| C-161 | Content-Dispositionが正しく生成される | E-07 (makeDisposition) | ○ |
| C-162 | 非ASCII文字を含むファイル名でfilename*生成 | E-07 (makeDisposition) | ○ |
| C-163 | 不正なdispositionで例外 | E-07 (makeDisposition) | ○ |
| C-164 | 非ASCIIのフォールバックで例外 | E-07 (makeDisposition) | ○ |
| C-165 | クエリ文字列が解析される | E-07 (parseQuery) | ○ |
| C-166 | ドット付きキーが保持される | E-07 (parseQuery) | ○ |

### IpUtils クラス（UT-HTF-167 〜 UT-HTF-180）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-167 | IPv4アドレスが完全一致する | E-08 (checkIp4) | ○ |
| C-168 | IPv4サブネットに含まれる場合true | E-08 (checkIp4) | ○ |
| C-169 | IPv4サブネットに含まれない場合false | E-08 (checkIp4) | ○ |
| C-170 | 不正なIPv4アドレスでfalse | E-08 (checkIp4) | ○ |
| C-171 | ネットマスク0でIPv4検証 | E-08 (checkIp4) | ○ |
| C-172 | IPv6アドレスが完全一致する | E-08 (checkIp6) | ○ |
| C-173 | IPv6サブネットに含まれる場合true | E-08 (checkIp6) | ○ |
| C-174 | 配列内のいずれかのIPにマッチする場合true | E-08 (checkIp) | ○ |
| C-175 | IPv4アドレスが匿名化される | E-08 (anonymize) | ○ |
| C-176 | IPv6アドレスが匿名化される | E-08 (anonymize) | ○ |
| C-177 | 負のバイト数でInvalidArgumentException | E-08 (anonymize) | ○ |
| C-178 | 上限超過バイト数でInvalidArgumentException | E-08 (anonymize) | ○ |
| C-179 | プライベートIPでisPrivateIpがtrue | E-08 (isPrivateIp) | ○ |
| C-180 | パブリックIPでisPrivateIpがfalse | E-08 (isPrivateIp) | ○ |

### JsonResponse クラス（UT-HTF-181 〜 UT-HTF-188）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-181 | JSONレスポンスが生成される | E-09 (__construct) | ○ |
| C-182 | JSON文字列が直接設定される | E-09 (__construct / json=true) | ○ |
| C-183 | json=trueで非文字列データでTypeError | E-09 (__construct) | ○ |
| C-184 | データがJSONエンコードされてコンテンツに設定 | E-09 (setData) | ○ |
| C-185 | エンコード不可能なデータでInvalidArgumentException | E-09 (setData) | ○ |
| C-186 | JSONPコールバックが設定される | E-09 (setCallback) | ○ |
| C-187 | 不正なコールバック名でInvalidArgumentException | E-09 (setCallback) | ○ |
| C-188 | JSON文字列からレスポンスが生成される | E-09 (fromJsonString) | ○ |

### RedirectResponse クラス（UT-HTF-189 〜 UT-HTF-192）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-189 | リダイレクトレスポンスが生成される | E-11 (__construct) | ○ |
| C-190 | 非リダイレクトステータスコードで例外 | E-11 (__construct) | ○ |
| C-191 | リダイレクト先URLが設定される | E-11 (setTargetUrl) | ○ |
| C-192 | 空URLで例外 | E-11 (setTargetUrl) | ○ |

### ResponseHeaderBag クラス（UT-HTF-193 〜 UT-HTF-200）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-193 | Cookieが設定される | E-14 (setCookie) | ○ |
| C-194 | Cookieが削除される | E-14 (removeCookie) | ○ |
| C-195 | ブラウザのCookieがクリアされる | E-14 (clearCookie) | ○ |
| C-196 | フラット形式でCookie配列が返る | E-14 (getCookies) | ○ |
| C-197 | 配列形式でCookie配列が返る | E-14 (getCookies) | ○ |
| C-198 | 不正フォーマットでInvalidArgumentException | E-14 (getCookies) | ○ |
| C-199 | デフォルトでno-cache, private設定 | E-14 (computeCacheControlValue) | ○ |
| C-200 | Last-Modified時にprivate, must-revalidate設定 | E-14 (computeCacheControlValue) | ○ |

### ServerBag クラス（UT-HTF-201 〜 UT-HTF-205）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-201 | HTTP_プレフィックス付きサーバー変数がヘッダ抽出 | E-12 (getHeaders) | ○ |
| C-202 | CONTENT_TYPEがヘッダ抽出 | E-12 (getHeaders) | ○ |
| C-203 | Basic認証ヘッダが正しく処理される | E-12 (getHeaders) | ○ |
| C-204 | Bearer認証ヘッダが保持される | E-12 (getHeaders) | ○ |
| C-205 | PHP_AUTH_USERからAuthorizationヘッダが構築 | E-12 (getHeaders) | ○ |

### FileBag クラス（UT-HTF-206 〜 UT-HTF-209）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-206 | UploadedFileが設定される | E-13 (set) | ○ |
| C-207 | 配列形式のファイル情報がUploadedFileに変換 | E-13 (set / convertFileInformation) | ○ |
| C-208 | 不正な値でInvalidArgumentException | E-13 (set / convertFileInformation) | ○ |
| C-209 | UPLOAD_ERR_NO_FILEの場合null設定 | E-13 (convertFileInformation) | ○ |

### UriSigner クラス（UT-HTF-210 〜 UT-HTF-220）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-210 | URIに署名が付与される | E-10 (sign) | ○ |
| C-211 | 有効期限付きの署名が付与される | E-10 (sign) | ○ |
| C-212 | 既に_hashがあるURIでLogicException | E-10 (sign) | ○ |
| C-213 | 正しく署名されたURIでcheck()がtrue | E-10 (check) | ○ |
| C-214 | 改ざんされたURIでcheck()がfalse | E-10 (check) | ○ |
| C-215 | 署名のないURIでcheck()がfalse | E-10 (check) | ○ |
| C-216 | 期限切れURIでcheck()がfalse | E-10 (check) | ○ |
| C-217 | 未署名URIでUnsignedUriException | E-10 (verify) | ○ |
| C-218 | 不正署名でUnverifiedSignedUriException | E-10 (verify) | ○ |
| C-219 | 期限切れでExpiredSignedUriException | E-10 (verify) | ○ |
| C-220 | 空のsecretでInvalidArgumentException | E-10 (__construct) | ○ |

### AcceptHeader / AcceptHeaderItem クラス（UT-HTF-221 〜 UT-HTF-228）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-221 | Accept文字列からAcceptHeaderが生成 | E-15 (fromString) | ○ |
| C-222 | 存在する値でhas()がtrue | E-15 (has) | ○ |
| C-223 | 値に対応するAcceptHeaderItemが返る | E-15 (get) | ○ |
| C-224 | 最高品質の項目が返る | E-15 (first) | ○ |
| C-225 | 空のAcceptHeaderでfirst()がnull | E-15 (first) | ○ |
| C-226 | 正規表現パターンでフィルタリング | E-15 (filter) | ○ |
| C-227 | 文字列からAcceptHeaderItemが生成 | E-16 (fromString) | ○ |
| C-228 | q属性で品質が設定される | E-16 (setAttribute) | ○ |

### RequestStack クラス（UT-HTF-229 〜 UT-HTF-238）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-229 | リクエストがスタックにプッシュされる | E-17 (push) | ○ |
| C-230 | リクエストがスタックからポップされる | E-17 (pop) | ○ |
| C-231 | 空のスタックからポップするとnull | E-17 (pop) | ○ |
| C-232 | 現在のリクエストが取得される | E-17 (getCurrentRequest) | ○ |
| C-233 | 空のスタックでgetCurrentRequestがnull | E-17 (getCurrentRequest) | ○ |
| C-234 | メインリクエストが取得される | E-17 (getMainRequest) | ○ |
| C-235 | 親リクエストが取得される | E-17 (getParentRequest) | ○ |
| C-236 | メインリクエストのみの場合にnull | E-17 (getParentRequest) | ○ |
| C-237 | 現在のリクエストのセッションが取得される | E-17 (getSession) | ○ |
| C-238 | セッションがない場合SessionNotFoundException | E-17 (getSession) | ○ |

### BinaryFileResponse クラス（UT-HTF-239 〜 UT-HTF-244）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-239 | ファイルパスからBinaryFileResponseが生成 | E-18 (__construct) | ○ |
| C-240 | 読み取り不可ファイルでFileException | E-18 (setFile) | ○ |
| C-241 | null以外のコンテンツでLogicException | E-18 (setContent) | ○ |
| C-242 | getContent()がfalseを返す | E-18 (getContent) | ○ |
| C-243 | チャンクサイズが設定される | E-18 (setChunkSize) | ○ |
| C-244 | 0以下のチャンクサイズでInvalidArgumentException | E-18 (setChunkSize) | ○ |

### StreamedResponse クラス（UT-HTF-245 〜 UT-HTF-248）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-245 | コールバック付きStreamedResponseが生成 | E-19 (__construct) | ○ |
| C-246 | null以外のコンテンツでLogicException | E-19 (setContent) | ○ |
| C-247 | getContent()がfalseを返す | E-19 (getContent) | ○ |
| C-248 | コールバック未設定でLogicException | E-19 (sendContent) | ○ |

### ServerEvent クラス（UT-HTF-249 〜 UT-HTF-251）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-249 | ServerEventが正しく生成される | E-20 (__construct) | ○ |
| C-250 | SSE形式の文字列がイテレートされる | E-20 (getIterator) | ○ |
| C-251 | iterableなdataが複数行のdata:として出力 | E-20 (getIterator) | △ |

### UrlHelper クラス（UT-HTF-252 〜 UT-HTF-254）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-252 | 相対パスが絶対URLに変換される | E-21 (getAbsoluteUrl) | △ |
| C-253 | 既に絶対URLの場合そのまま返る | E-21 (getAbsoluteUrl) | ○ |
| C-254 | 絶対パスが相対パスに変換される | E-21 (getRelativePath) | △ |

### ChainRequestMatcher クラス（UT-HTF-255 〜 UT-HTF-257）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-255 | 全マッチャーが一致する場合true | E-22 (matches) | ○ |
| C-256 | いずれかのマッチャーが不一致の場合false | E-22 (matches) | ○ |
| C-257 | マッチャーが空の場合true | E-22 (matches) | ○ |

## 4) 不足情報（Unknown / Missing）
- **Request::create のURIバリデーション（C-006, C-007, C-008）**：createメソッドの内部でinitializeを呼び出し、その中でURIの解析が行われるが、BadRequestExceptionがスローされる正確な条件はランタイム依存の部分がある。request_order php.ini設定にも影響される可能性がある。
  - 候補：Request.php の initializeメソッド内のバリデーションロジック / PHPのparse_url関数の挙動 / SuspiciousOperationExceptionとの使い分け
- **Request::getMethod オーバーライド無視（C-014）**：setAllowedHttpMethodOverrideのデフォルト許可リスト（DELETE, PATCH, PUT）は明確だが、将来のバージョンで変更される可能性がある。
  - 候補：Request.php の $allowedHttpMethodOverrides定数 / CHANGELOGでの変更履歴
- **Request::getFormat サフィックス解決（C-045）**：構造化サフィックス（+json, +xml等）の解決ロジックは存在するが、全パターンの網羅性は未検証。
  - 候補：Request.php の initializeFormats / RFC 6838 (Media Type Specifications)
- **UrlHelper の動作（C-252, C-254）**：RequestStackにRequestがない場合のRequestContextフォールバック動作は、RequestContextの設定に依存する。
  - 候補：UrlHelper.php / RequestContext.php / RoutingComponentとの連携
- **ServerEvent iterableデータ（C-251）**：iterableなデータがStringableオブジェクトを含む場合の変換動作は、getIterator内のジェネレータ実装の詳細に依存する。
  - 候補：ServerEvent.php のgetIteratorメソッド

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ParameterBag, HeaderBag, InputBag, Cookie, AcceptHeader, AcceptHeaderItem, RequestStack, ChainRequestMatcher のテストケースは、ソースコードから直接導出され、挙動が明確
- **0: 低リスク** - Response, RedirectResponse, JsonResponse, BinaryFileResponse, StreamedResponse のテストケースは、メソッドのシグネチャと実装から明確に導出
- **1: 中リスク** - HeaderUtils, IpUtils, UriSigner, ServerBag, FileBag, ResponseHeaderBag のテストケースは、一部のエッジケースでPHP内蔵関数の挙動に依存
- **1: 中リスク** - Request クラスのテストケース（特に信頼済みプロキシ関連、メソッドオーバーライド、URI生成）は、複数メソッドの連携動作を含むため実行時検証が推奨
- **1: 中リスク** - UrlHelper のテストケースは、RequestStackとRequestContextの両方のフォールバック動作に依存
- **0: 低リスク** - ServerEvent のテストケースは、SSE形式の文字列出力が明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの対象ファイルパスがすべて実在するソースファイルを正しく指しているか
- [ ] テストID（UT-HTF-xxx）が1から257まで連番で重複なく割り振られているか
- [ ] 各テストケースの「期待結果」がソースコードの実装と一致しているか（特に例外クラス名）
- [ ] Request::create の異常系テストケース（UT-HTF-006〜008）の前提条件が実際のバリデーションロジックと合致するか
- [ ] 信頼済みプロキシ関連テスト（UT-HTF-021, 024, 026, 058, 059）の前提条件（setTrustedProxies呼び出し）が正しく記述されているか
- [ ] UriSigner のテストケース（UT-HTF-210〜220）で使用するシークレットキーとURIの組み合わせが実行可能か
- [ ] Cookie のテストケース（UT-HTF-140〜153）でSameSite, Partitioned属性の最新仕様に準拠しているか
- [ ] StreamedResponse / StreamedJsonResponse / BinaryFileResponse のテストケースで、I/O操作のモック要件が明確か
- [ ] 全テストケースの「テスト観点」列が「正常系」「異常系」「境界値」のいずれかで統一されているか
- [ ] テストケースの優先度（高/中/低）がセキュリティ・データ整合性の観点で適切に設定されているか
