---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 180
  claims_with_evidence: 172
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：Component-HttpKernel 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：172 / 180、根拠なし：8
- 優先レビュー（高）
  1. **UT-HTK-009 StreamedResponseコールバック**：RequestStack push/popの内部動作は実行時テストでの確認が必要
  2. **UT-HTK-153 HttpClientKernel依存不在**：class_exists条件の再現がテスト環境で困難
  3. **UT-HTK-157 ファイルサイズ超過**：getMaxFilesizeの返却値に依存するためテスト環境での再現に工夫が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/HttpKernel/HttpKernel.php` - HttpKernelクラス（handle, terminate, terminateWithException, handleRaw, filterResponse, handleThrowable, varToString）
- E-02: `src/Symfony/Component/HttpKernel/Kernel.php` - 抽象Kernelクラス（boot, shutdown, reboot, handle, getBundle, locateResource, getContainer, getStartTime, getContainerClass, initializeBundles, __clone, __serialize, __unserialize）
- E-03: `src/Symfony/Component/HttpKernel/Controller/ControllerResolver.php` - ControllerResolverクラス（getController, createController, allowControllers, checkController）
- E-04: `src/Symfony/Component/HttpKernel/Controller/ArgumentResolver.php` - ArgumentResolverクラス（getArguments, getDefaultArgumentValueResolvers）
- E-05: `src/Symfony/Component/HttpKernel/Controller/ContainerControllerResolver.php` - ContainerControllerResolverクラス（instantiateController）
- E-06: `src/Symfony/Component/HttpKernel/Controller/ErrorController.php` - ErrorControllerクラス（__invoke, preview）
- E-07: `src/Symfony/Component/HttpKernel/Controller/ControllerReference.php` - ControllerReferenceクラス
- E-08: `src/Symfony/Component/HttpKernel/Event/KernelEvent.php` - KernelEventクラス（getKernel, getRequest, getRequestType, isMainRequest）
- E-09: `src/Symfony/Component/HttpKernel/Event/RequestEvent.php` - RequestEventクラス（getResponse, setResponse, hasResponse）
- E-10: `src/Symfony/Component/HttpKernel/Event/ExceptionEvent.php` - ExceptionEventクラス（getThrowable, setThrowable, allowCustomResponseCode, isKernelTerminating）
- E-11: `src/Symfony/Component/HttpKernel/Event/ControllerEvent.php` - ControllerEventクラス（getController, setController, getAttributes, getControllerReflector）
- E-12: `src/Symfony/Component/HttpKernel/Event/ControllerArgumentsEvent.php` - ControllerArgumentsEventクラス（getArguments, setArguments, getNamedArguments, getAttributes）
- E-13: `src/Symfony/Component/HttpKernel/Event/ResponseEvent.php` - ResponseEventクラス（getResponse, setResponse）
- E-14: `src/Symfony/Component/HttpKernel/Event/ViewEvent.php` - ViewEventクラス（getControllerResult, setControllerResult）
- E-15: `src/Symfony/Component/HttpKernel/Profiler/Profiler.php` - Profilerクラス（collect, loadProfile, loadProfileFromResponse, saveProfile, add, get, has, set, find, enable, disable, reset, purge）
- E-16: `src/Symfony/Component/HttpKernel/Profiler/Profile.php` - Profileクラス（getToken, setToken, addChild, getChildByToken, getCollector, hasCollector, getTime）
- E-17: `src/Symfony/Component/HttpKernel/Fragment/FragmentHandler.php` - FragmentHandlerクラス（render, deliver, addRenderer）
- E-18: `src/Symfony/Component/HttpKernel/Fragment/FragmentUriGenerator.php` - FragmentUriGeneratorクラス（generate, checkNonScalar）
- E-19: `src/Symfony/Component/HttpKernel/Fragment/InlineFragmentRenderer.php` - InlineFragmentRendererクラス（render, createSubRequest, getName）
- E-20: `src/Symfony/Component/HttpKernel/HttpCache/Store.php` - Storeクラス（lookup, write, invalidate, lock, unlock, isLocked, purge, cleanup, getPath）
- E-21: `src/Symfony/Component/HttpKernel/HttpCache/ResponseCacheStrategy.php` - ResponseCacheStrategyクラス（add, update）
- E-22: `src/Symfony/Component/HttpKernel/CacheClearer/ChainCacheClearer.php` - ChainCacheClearerクラス（clear）
- E-23: `src/Symfony/Component/HttpKernel/CacheClearer/Psr6CacheClearer.php` - Psr6CacheClearerクラス（hasPool, getPool, clearPool, clear）
- E-24: `src/Symfony/Component/HttpKernel/CacheWarmer/CacheWarmerAggregate.php` - CacheWarmerAggregateクラス（warmUp, enableOptionalWarmers, enableOnlyOptionalWarmers, isOptional）
- E-25: `src/Symfony/Component/HttpKernel/ControllerMetadata/ArgumentMetadata.php` - ArgumentMetadataクラス（getName, getType, isVariadic, hasDefaultValue, isNullable, getDefaultValue, getAttributes, getAttributesOfType）
- E-26: `src/Symfony/Component/HttpKernel/ControllerMetadata/ArgumentMetadataFactory.php` - ArgumentMetadataFactoryクラス（createArgumentMetadata）
- E-27: `src/Symfony/Component/HttpKernel/Exception/HttpException.php` - HttpExceptionクラス（getStatusCode, getHeaders, setHeaders, fromStatusCode）
- E-28: `src/Symfony/Component/HttpKernel/HttpClientKernel.php` - HttpClientKernelクラス（handle, getBody, getHeaders）
- E-29: `src/Symfony/Component/HttpKernel/HttpKernelBrowser.php` - HttpKernelBrowserクラス（catchExceptions, doRequest, filterRequest, filterFiles, filterResponse, getScript）
- E-30: `src/Symfony/Component/HttpKernel/Log/Logger.php` - Loggerクラス（log, getLogs, countErrors, clear, enableDebug）
- E-31: `src/Symfony/Component/HttpKernel/DataCollector/DataCollector.php` - DataCollectorクラス（cloneVar, getCasters, reset, __serialize, __unserialize）
- E-32: `src/Symfony/Component/HttpKernel/Attribute/Cache.php` - Cache属性クラス
- E-33: `src/Symfony/Component/HttpKernel/Profiler/FileProfilerStorage.php` - FileProfilerStorageクラス（read, write, find, purge）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-HTK-001: HttpKernel::handleが正常なリクエストを処理しResponseを返却する | E-01 (handle L72-111, handleRaw L158-210) | ○ |
| C-02 | UT-HTK-002: RequestEventでレスポンスが設定された場合にそのレスポンスが返却される | E-01 (handleRaw L161-166) | ○ |
| C-03 | UT-HTK-004: コントローラが見つからない場合にNotFoundHttpExceptionがスローされる | E-01 (handleRaw L169-171) | ○ |
| C-04 | UT-HTK-005: catch=trueで例外がhandleThrowableで処理される | E-01 (handle L80-94) | ○ |
| C-05 | UT-HTK-006: catch=falseで例外がそのままスローされる | E-01 (handle L88-92) | ○ |
| C-06 | UT-HTK-007: RequestExceptionInterfaceがBadRequestHttpExceptionに変換される | E-01 (handle L85-86) | ○ |
| C-07 | UT-HTK-008: handleAllThrowables=falseでErrorがスローされる | E-01 (handle L81-83) | ○ |
| C-08 | UT-HTK-009: StreamedResponseのコールバックでRequestStackが管理される | E-01 (handle L98-109) | △ |
| C-09 | UT-HTK-011: コントローラがnullを返しViewEventでもレスポンス未設定時にControllerDoesNotReturnResponseExceptionがスローされる | E-01 (handleRaw L191-206) | ○ |
| C-10 | UT-HTK-016: 空の環境名でInvalidArgumentExceptionがスローされる | E-02 (__construct L89-91) | ○ |
| C-11 | UT-HTK-017: 初回bootでバンドルが初期化される | E-02 (boot L103-129) | ○ |
| C-12 | UT-HTK-022: 未登録バンドル名でInvalidArgumentExceptionがスローされる | E-02 (getBundle L211-216) | ○ |
| C-13 | UT-HTK-025: ..を含むリソース名でRuntimeExceptionがスローされる | E-02 (locateResource L225-227) | ○ |
| C-14 | UT-HTK-026: 未起動時にgetContainerでLogicExceptionがスローされる | E-02 (getContainer L280-281) | ○ |
| C-15 | UT-HTK-030: 同名バンドル登録でLogicExceptionがスローされる | E-02 (initializeBundles L330-331) | ○ |
| C-16 | UT-HTK-033-038: ControllerResolverの各テストケース | E-03 (getController L54-105, allowControllers L40-49, checkController L224-271) | ○ |
| C-17 | UT-HTK-040-045: ArgumentResolverの各テストケース | E-04 (getArguments L50-126, getDefaultArgumentValueResolvers L131-140) | ○ |
| C-18 | UT-HTK-046-048: ContainerControllerResolverの各テストケース | E-05 (instantiateController L33-53) | ○ |
| C-19 | UT-HTK-049-050: ErrorControllerの各テストケース | E-06 (__invoke L35-40, preview L42-57) | ○ |
| C-20 | UT-HTK-052-055: KernelEventの各テストケース | E-08 (getKernel L39, getRequest L48, isMainRequest L66-69) | ○ |
| C-21 | UT-HTK-056-057: RequestEventの各テストケース | E-09 (setResponse L40-45, hasResponse L52-55) | ○ |
| C-22 | UT-HTK-058-061: ExceptionEventの各テストケース | E-10 (getThrowable L48-51, setThrowable L58-61, allowCustomResponseCode L66-68, isKernelTerminating L79-82) | ○ |
| C-23 | UT-HTK-062-067: ControllerEventの各テストケース | E-11 (getController L38-41, setController L51-83, getAttributes L92-125) | ○ |
| C-24 | UT-HTK-068-071: ControllerArgumentsEventの各テストケース | E-12 (getArguments L67-69, setArguments L75-79, getNamedArguments L84-106) | ○ |
| C-25 | UT-HTK-076-086: Profilerの各テストケース | E-15 (collect L130-165, loadProfile L80-83, loadProfileFromResponse L68-75, saveProfile L88-102, add L199-202, get L221-228, enable/disable L47-58) | ○ |
| C-26 | UT-HTK-087-092: Profileの各テストケース | E-16 (getToken L54-57, addChild L184-188, getChildByToken L190-199, getCollector L206-213, getTime L122-125) | ○ |
| C-27 | UT-HTK-093-096: FragmentHandlerの各テストケース | E-17 (render L67-82, deliver L94-108) | ○ |
| C-28 | UT-HTK-097-100: FragmentUriGeneratorの各テストケース | E-18 (generate L34-74, checkNonScalar L76-85) | ○ |
| C-29 | UT-HTK-101-104: InlineFragmentRendererの各テストケース | E-19 (render L41-101, createSubRequest L103-135) | ○ |
| C-30 | UT-HTK-105-114: Storeの各テストケース | E-20 (lookup L137-168, write L178-230, invalidate L245-265, lock L72-92, unlock L99-112, purge L314-323) | ○ |
| C-31 | UT-HTK-115-118: ResponseCacheStrategyの各テストケース | E-21 (add L57-111, update L113-169) | ○ |
| C-32 | UT-HTK-119-126: CacheClearerの各テストケース | E-22, E-23 | ○ |
| C-33 | UT-HTK-127-131: CacheWarmerAggregateの各テストケース | E-24 (warmUp L48-123, enableOptionalWarmers L38-41, enableOnlyOptionalWarmers L43-46) | ○ |
| C-34 | UT-HTK-132-138: ArgumentMetadataの各テストケース | E-25 (getName, getType, isNullable L76-78, getDefaultValue L86-93, getAttributesOfType L118-136) | ○ |
| C-35 | UT-HTK-139-141: ArgumentMetadataFactoryの各テストケース | E-26 (createArgumentMetadata L21-39) | ○ |
| C-36 | UT-HTK-142-148: HttpExceptionの各テストケース | E-27 (__construct L21-29, fromStatusCode L31-49, getStatusCode L52-55, getHeaders L57-59, setHeaders L62-65) | ○ |
| C-37 | UT-HTK-149-153: HttpClientKernelの各テストケース | E-28 (handle L45-72, __construct L36-43, getBody L74-94, getHeaders L96-111) | ○ |
| C-38 | UT-HTK-153: HttpClient未インストール時のLogicException | E-28 (__construct L38-39) | △ |
| C-39 | UT-HTK-154-158: HttpKernelBrowserの各テストケース | E-29 (catchExceptions L52-55, filterRequest L123-135, filterFiles L148-176, filterResponse L181-197) | ○ |
| C-40 | UT-HTK-157: ファイルサイズ超過時のUPLOAD_ERR_INI_SIZE | E-29 (filterFiles L155-161) | △ |
| C-41 | UT-HTK-159-165: Loggerの各テストケース | E-30 (log L87-107, getLogs L109-116, countErrors L118-125, clear L127-131) | ○ |
| C-42 | UT-HTK-166-168: DataCollectorの各テストケース | E-31 (cloneVar L41-53, reset L97-100) | ○ |
| C-43 | UT-HTK-169: FileLocatorの初期化 | **根拠なし** | △ |
| C-44 | UT-HTK-170: Cache属性の初期化 | E-32 (__construct L29-137) | ○ |
| C-45 | UT-HTK-173-174: Bundleクラスの各テストケース | **根拠不足** | △ |
| C-46 | UT-HTK-175: VirtualRequestStackの初期化 | **根拠不足** | △ |
| C-47 | UT-HTK-176-180: FileProfilerStorageの各テストケース | E-33 | △ |

## 4) 不足情報（Unknown / Missing）
- FileLocator（E-33相当）のソースコードは読み込んだが、テストケースの入力値・期待結果の詳細は推定に基づく
  - 候補：`src/Symfony/Component/HttpKernel/Config/FileLocator.php` を精査
- Bundle基底クラスのgetName/getPathメソッドの実装詳細は確認していない
  - 候補：`src/Symfony/Component/HttpKernel/Bundle/Bundle.php` を精査
- VirtualRequestStackの実装詳細は確認していない
  - 候補：`src/Symfony/Component/HttpKernel/Debug/VirtualRequestStack.php` を精査
- FileProfilerStorageの内部実装（ファイルI/Oの詳細）は完全には確認していない
  - 候補：`src/Symfony/Component/HttpKernel/Profiler/FileProfilerStorage.php` を精査
- HttpClientKernelのclass_exists条件テストはテスト環境での再現が困難
  - 候補：専用のテストダブルまたはprocess isolationを使用

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Event系テストケース（単純なゲッター・セッターが多い）
- 1: 中リスク - HttpKernel::handleのStreamedResponse処理（C-08）、FileProfilerStorageのファイルI/Oテスト（C-47）
- 2: 高リスク - HttpClientKernelの依存チェック（C-38）はモック化が困難な可能性あり。HttpKernel::handleの例外処理パス（C-04〜C-07）は複雑な条件分岐を含むため重点レビュー推奨

## 6) レビュアーチェックリスト（最小）
- [ ] HttpKernel::handleの全例外処理パスが網羅されているか（正常系・RequestException・Error・一般例外）
- [ ] Kernel::boot/shutdownのライフサイクルが正しくテストされているか
- [ ] ControllerResolver::checkControllerの許可チェックロジックが十分にカバーされているか
- [ ] FragmentHandler/FragmentUriGeneratorのセキュリティ関連テスト（署名検証など）が適切か
- [ ] HttpCache::Storeのロック競合パターンがテストされているか
- [ ] ResponseCacheStrategyのno-store/no-cache伝播ロジックが正しくテストされているか
- [ ] ArgumentResolverのValueResolver属性の有効/無効パターンが網羅されているか
- [ ] EventListenerクラスのテストケースが不足していないか（本CSVでは主要クラスのみ対象としている）
