---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 184
  claims_with_evidence: 178
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：Component-Intl 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：178 / 184、根拠なし：6
- 優先レビュー（高）
  1. **C-092 (Timezones::exists DateTimeZoneフォールバック)**：ICUリソースにないがDateTimeZoneで有効な具体的タイムゾーン名が不明
  2. **C-104 (Timezones::forCountryCode タイムゾーンなし国)**：タイムゾーンがない有効な国コードの具体例が不明
  3. **C-070 (Languages::alpha3CodeExists キャッシュフォールバック)**：alpha-2変換がなくgetAlpha3Codesに含まれる具体的言語コードの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Intl/Countries.php` - 国コード関連の全publicメソッド定義
- E-02: `src/Symfony/Component/Intl/Currencies.php` - 通貨関連の全publicメソッド定義
- E-03: `src/Symfony/Component/Intl/Languages.php` - 言語コード関連の全publicメソッド定義
- E-04: `src/Symfony/Component/Intl/Scripts.php` - スクリプトコード関連の全publicメソッド定義
- E-05: `src/Symfony/Component/Intl/Locales.php` - ロケール関連の全publicメソッド定義
- E-06: `src/Symfony/Component/Intl/Timezones.php` - タイムゾーン関連の全publicメソッド定義
- E-07: `src/Symfony/Component/Intl/Locale.php` - フォールバックロケール関連のメソッド定義
- E-08: `src/Symfony/Component/Intl/Intl.php` - ICUバージョン・データパス関連のメソッド定義
- E-09: `src/Symfony/Component/Intl/ResourceBundle.php` - 抽象基底クラスのreadEntry/asortメソッド定義
- E-10: `src/Symfony/Component/Intl/Util/IcuVersion.php` - ICUバージョン比較・正規化メソッド定義
- E-11: `src/Symfony/Component/Intl/Util/Version.php` - バージョン比較・正規化メソッド定義
- E-12: `src/Symfony/Component/Intl/Util/GitRepository.php` - Git操作ユーティリティ定義
- E-13: `src/Symfony/Component/Intl/Util/GzipStreamWrapper.php` - gzip圧縮ファイルストリームラッパー定義
- E-14: `src/Symfony/Component/Intl/Util/IntlTestHelper.php` - テストヘルパー定義
- E-15: `src/Symfony/Component/Intl/Data/Bundle/Reader/BundleEntryReader.php` - バンドルエントリリーダー定義
- E-16: `src/Symfony/Component/Intl/Data/Bundle/Reader/BufferedBundleReader.php` - バッファ付きリーダー定義
- E-17: `src/Symfony/Component/Intl/Data/Bundle/Reader/PhpBundleReader.php` - PHPバンドルリーダー定義
- E-18: `src/Symfony/Component/Intl/Data/Bundle/Reader/JsonBundleReader.php` - JSONバンドルリーダー定義
- E-19: `src/Symfony/Component/Intl/Data/Bundle/Reader/IntlBundleReader.php` - intlバンドルリーダー定義
- E-20: `src/Symfony/Component/Intl/Data/Bundle/Writer/JsonBundleWriter.php` - JSONバンドルライター定義
- E-21: `src/Symfony/Component/Intl/Data/Bundle/Writer/PhpBundleWriter.php` - PHPバンドルライター定義
- E-22: `src/Symfony/Component/Intl/Data/Util/RingBuffer.php` - リングバッファ実装
- E-23: `src/Symfony/Component/Intl/Data/Util/RecursiveArrayAccess.php` - 再帰的配列アクセス実装
- E-24: `src/Symfony/Component/Intl/Data/Util/LocaleScanner.php` - ロケールスキャナー実装
- E-25: `src/Symfony/Component/Intl/Data/Util/ArrayAccessibleResourceBundle.php` - ArrayAccess対応ResourceBundleラッパー
- E-26: `src/Symfony/Component/Intl/Exception/UnexpectedTypeException.php` - 型例外定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Countries::getCountryCodes - withUserAssigned=falseで公式コード返却 | E-01 L38-45 | ○ |
| C-002 | Countries::getCountryCodes - withUserAssigned=trueでユーザー割当含む | E-01 L40-44 | ○ |
| C-003 | Countries::getAlpha3Codes - alpha-3コード一覧返却 | E-01 L56-63 | ○ |
| C-004 | Countries::getAlpha3Codes - withUserAssigned=trueでユーザー割当含む | E-01 L58-62 | ○ |
| C-005 | Countries::getNumericCodes - 数値コード一覧返却 | E-01 L76-83 | ○ |
| C-006 | Countries::getAlpha3Code - 有効alpha-2からalpha-3変換 | E-01 L85-95 | ○ |
| C-007 | Countries::getAlpha3Code - 無効alpha-2でMissingResourceException | E-01 L85-95 | ○ |
| C-008 | Countries::getAlpha3Code - withUserAssigned=trueでXK変換 | E-01 L87-95 | ○ |
| C-009 | Countries::getAlpha2Code - 有効alpha-3からalpha-2変換 | E-01 L97-107 | ○ |
| C-010 | Countries::getAlpha2Code - 無効alpha-3でMissingResourceException | E-01 L97-107 | ○ |
| C-011 | Countries::getNumericCode - alpha-2から数値コード変換 | E-01 L109-119 | ○ |
| C-012 | Countries::getAlpha2FromNumeric - 数値からalpha-2変換 | E-01 L121-132 | ○ |
| C-013 | Countries::getAlpha2FromNumeric - 無効数値コードでException | E-01 L121-132 | ○ |
| C-014 | Countries::exists - 存在するコードでtrue | E-01 L134-143 | ○ |
| C-015 | Countries::exists - 存在しないコードでfalse | E-01 L134-143 | ○ |
| C-016 | Countries::alpha3CodeExists - 存在するalpha-3でtrue | E-01 L145-154 | ○ |
| C-017 | Countries::alpha3CodeExists - 存在しないalpha-3でfalse | E-01 L145-154 | ○ |
| C-018 | Countries::numericCodeExists - 存在する数値コードでtrue | E-01 L156-165 | ○ |
| C-019 | Countries::numericCodeExists - 存在しない数値コードでfalse | E-01 L156-165 | ○ |
| C-020 | Countries::getName - デフォルトロケールで国名返却 | E-01 L172-182 | ○ |
| C-021 | Countries::getName - 指定ロケールで国名返却 | E-01 L172-182 | ○ |
| C-022 | Countries::getName - 無効コードでMissingResourceException | E-01 L172-182 | ○ |
| C-023 | Countries::getAlpha3Name - alpha-3から国名返却 | E-01 L189-192 | ○ |
| C-024 | Countries::getNames - ソート済み国名一覧返却 | E-01 L199-206 | ○ |
| C-025 | Countries::getAlpha3Names - alpha-3キーの国名一覧 | E-01 L215-224 | ○ |
| C-026 | Countries::withUserAssigned - 環境変数からデフォルト取得 | E-01 L234-241 | ○ |
| C-027 | Countries::withUserAssigned - trueを設定 | E-01 L234-241 | ○ |
| C-028 | Countries::withUserAssigned - falseを設定 | E-01 L234-241 | ○ |
| C-029 | Currencies::getCurrencyCodes - 通貨コード一覧返却 | E-02 L34-37 | ○ |
| C-030 | Currencies::exists - 存在する通貨でtrue | E-02 L39-48 | ○ |
| C-031 | Currencies::exists - 存在しない通貨でfalse | E-02 L39-48 | ○ |
| C-032 | Currencies::getName - デフォルトロケールで通貨名返却 | E-02 L53-56 | ○ |
| C-033 | Currencies::getName - 無効通貨でMissingResourceException | E-02 L53-56 | ○ |
| C-034 | Currencies::getNames - ソート済み通貨名一覧返却 | E-02 L61-80 | ○ |
| C-035 | Currencies::getSymbol - 通貨記号返却 | E-02 L85-88 | ○ |
| C-036 | Currencies::getSymbol - 無効通貨でMissingResourceException | E-02 L85-88 | ○ |
| C-037 | Currencies::getFractionDigits - 既知通貨の小数桁数 | E-02 L90-97 | ○ |
| C-038 | Currencies::getFractionDigits - 未知通貨でDEFAULTフォールバック | E-02 L90-97 | ○ |
| C-039 | Currencies::getFractionDigits - JPYで0桁 | E-02 L90-97 | ○ |
| C-040 | Currencies::getRoundingIncrement - 丸め増分返却 | E-02 L99-106 | ○ |
| C-041 | Currencies::getCashFractionDigits - 現金小数桁数返却 | E-02 L108-115 | ○ |
| C-042 | Currencies::getCashRoundingIncrement - 現金丸め増分返却 | E-02 L117-124 | ○ |
| C-043 | Currencies::getNumericCode - 通貨数値コード返却 | E-02 L129-132 | ○ |
| C-044 | Currencies::getNumericCode - 数値コードなし通貨でException | E-02 L129-132 | ○ |
| C-045 | Currencies::forNumericCode - 数値から通貨コード配列返却 | E-02 L137-140 | ○ |
| C-046 | Currencies::forNumericCode - 無効数値コードでException | E-02 L137-140 | ○ |
| C-047 | Currencies::forCountry - 有効国コードから通貨一覧返却 | E-02 L152-175 | ○ |
| C-048 | Currencies::forCountry - legalTender=nullで全通貨 | E-02 L152-175 | ○ |
| C-049 | Currencies::forCountry - active=nullで非アクティブも含む | E-02 L152-175 | ○ |
| C-050 | Currencies::forCountry - 存在しない国コードでException | E-02 L152-175 | ○ |
| C-051 | Currencies::isValidInCountry - 有効な組み合わせでtrue | E-02 L184-205 | ○ |
| C-052 | Currencies::isValidInCountry - 無効な組み合わせでfalse | E-02 L184-205 | ○ |
| C-053 | Currencies::isValidInCountry - 存在しない通貨でInvalidArgumentException | E-02 L186-188 | ○ |
| C-054 | Currencies::isValidInAnyCountry - 有効通貨でtrue | E-02 L244-273 | ○ |
| C-055 | Currencies::isValidInAnyCountry - 存在しない通貨でInvalidArgumentException | E-02 L246-248 | ○ |
| C-056 | Languages::getLanguageCodes - 言語コード一覧返却 | E-03 L36-39 | ○ |
| C-057 | Languages::exists - 存在する言語でtrue | E-03 L41-50 | ○ |
| C-058 | Languages::exists - 存在しない言語でfalse | E-03 L41-50 | ○ |
| C-059 | Languages::getName - デフォルトロケールで言語名返却 | E-03 L59-74 | ○ |
| C-060 | Languages::getName - 完全ロケールで地域化名返却 | E-03 L59-74 | ○ |
| C-061 | Languages::getName - 無効言語コードでMissingResourceException | E-03 L59-74 | ○ |
| C-062 | Languages::getName - フォールバック処理 | E-03 L63-73 | ○ |
| C-063 | Languages::getNames - ソート済み言語名一覧返却 | E-03 L81-84 | ○ |
| C-064 | Languages::getAlpha3Code - 2文字から3文字変換 | E-03 L91-94 | ○ |
| C-065 | Languages::getAlpha3Code - 無効コードでException | E-03 L91-94 | ○ |
| C-066 | Languages::getAlpha2Code - 3文字から2文字変換 | E-03 L101-104 | ○ |
| C-067 | Languages::getAlpha3Codes - 3文字コード一覧返却 | E-03 L113-116 | ○ |
| C-068 | Languages::alpha3CodeExists - 存在する3文字でtrue | E-03 L121-133 | ○ |
| C-069 | Languages::alpha3CodeExists - 存在しない3文字でfalse | E-03 L121-133 | ○ |
| C-070 | Languages::alpha3CodeExists - キャッシュフォールバック | E-03 L127-132 | △ |
| C-071 | Languages::getAlpha3Name - 3文字から言語名返却 | E-03 L140-151 | ○ |
| C-072 | Languages::getAlpha3Name - alpha-2変換なし3文字直接検索 | E-03 L144-147 | △ |
| C-073 | Languages::getAlpha3Names - 3文字キーの言語名一覧 | E-03 L160-176 | ○ |
| C-074 | Scripts::getScriptCodes - スクリプトコード一覧返却 | E-04 L27-30 | ○ |
| C-075 | Scripts::exists - 存在するスクリプトでtrue | E-04 L32-41 | ○ |
| C-076 | Scripts::exists - 存在しないスクリプトでfalse | E-04 L32-41 | ○ |
| C-077 | Scripts::getName - スクリプト名返却 | E-04 L46-49 | ○ |
| C-078 | Scripts::getName - 無効スクリプトでException | E-04 L46-49 | ○ |
| C-079 | Scripts::getNames - ソート済みスクリプト名一覧返却 | E-04 L54-57 | ○ |
| C-080 | Locales::getLocales - ロケール一覧返却 | E-05 L27-30 | ○ |
| C-081 | Locales::getAliases - エイリアス一覧返却 | E-05 L35-38 | ○ |
| C-082 | Locales::exists - 存在するロケールでtrue | E-05 L40-49 | ○ |
| C-083 | Locales::exists - 存在しないロケールでfalse | E-05 L40-49 | ○ |
| C-084 | Locales::exists - エイリアスでtrue | E-05 L47 | ○ |
| C-085 | Locales::getName - ロケール名返却 | E-05 L54-65 | ○ |
| C-086 | Locales::getName - エイリアス経由のロケール名 | E-05 L58-64 | ○ |
| C-087 | Locales::getName - 無効ロケールでMissingResourceException | E-05 L54-65 | ○ |
| C-088 | Locales::getNames - ソート済みロケール名一覧返却 | E-05 L70-73 | ○ |
| C-089 | Timezones::getIds - タイムゾーンID一覧返却 | E-06 L27-30 | ○ |
| C-090 | Timezones::exists - 存在するTZでtrue | E-06 L32-47 | ○ |
| C-091 | Timezones::exists - 存在しないTZでfalse | E-06 L32-47 | ○ |
| C-092 | Timezones::exists - DateTimeZoneフォールバックでtrue | E-06 L39-44 | △ |
| C-093 | Timezones::getName - TZ名返却 | E-06 L52-55 | ○ |
| C-094 | Timezones::getName - 無効TZでException | E-06 L52-55 | ○ |
| C-095 | Timezones::getNames - ソート済みTZ名一覧返却 | E-06 L60-63 | ○ |
| C-096 | Timezones::getRawOffset - UTCオフセット秒数返却 | E-06 L69-74 | ○ |
| C-097 | Timezones::getRawOffset - timestamp指定でのオフセット | E-06 L69-74 | ○ |
| C-098 | Timezones::getRawOffset - 無効TZで例外 | E-06 L69-74 | ○ |
| C-099 | Timezones::getGmtOffset - GMT表記返却 | E-06 L76-81 | ○ |
| C-100 | Timezones::getGmtOffset - 正オフセット表記 | E-06 L76-81 | ○ |
| C-101 | Timezones::getCountryCode - TZから国コード返却 | E-06 L87-90 | ○ |
| C-102 | Timezones::getCountryCode - 国コードなしTZでException | E-06 L87-90 | ○ |
| C-103 | Timezones::forCountryCode - 国コードからTZ一覧返却 | E-06 L95-110 | ○ |
| C-104 | Timezones::forCountryCode - TZなし国で空配列 | E-06 L100-101 | △ |
| C-105 | Timezones::forCountryCode - 小文字国コードでエラーメッセージ | E-06 L104-105 | ○ |
| C-106 | Timezones::forCountryCode - 存在しない国コードでException | E-06 L108 | ○ |
| C-107 | Locale::setDefaultFallback - フォールバック設定 | E-07 L37-40 | ○ |
| C-108 | Locale::setDefaultFallback - null設定 | E-07 L37-40 | ○ |
| C-109 | Locale::getDefaultFallback - 初期値'en' | E-07 L27 | ○ |
| C-110 | Locale::getFallback - 地域付きロケールのフォールバック | E-07 L63-104 | ○ |
| C-111 | Locale::getFallback - 言語のみでデフォルトフォールバック | E-07 L63-104 | ○ |
| C-112 | Locale::getFallback - デフォルトと同じ場合にroot | E-07 L69-70, L97-98 | ○ |
| C-113 | Locale::getFallback - 複数サブタグの末尾除去 | E-07 L82-86 | ○ |
| C-114 | Locale::getFallback - 4文字以上でnull | E-07 L75-79 | ○ |
| C-115 | Locale::getFallback - 3文字でデフォルトフォールバック | E-07 L75-77 | ○ |
| C-116 | Intl::isExtensionLoaded - trueが返却される | E-08 L63-66 | ○ |
| C-117 | Intl::getIcuVersion - バージョン文字列返却 | E-08 L72-94 | ○ |
| C-118 | Intl::getIcuDataVersion - データバージョン返却 | E-08 L99-102 | ○ |
| C-119 | Intl::getIcuStubVersion - '78.1'返却 | E-08 L107-110 | ○ |
| C-120 | Intl::getDataDirectory - パス返却 | E-08 L115-118 | ○ |
| C-121 | IcuVersion::compare - 同一バージョン等価 | E-10 L51-57 | ○ |
| C-122 | IcuVersion::compare - 異なるバージョン非等価 | E-10 L51-57 | ○ |
| C-123 | IcuVersion::compare - precision指定比較 | E-10 L51-57 | ○ |
| C-124 | IcuVersion::compare - 2桁変換比較 | E-10 L51-57, L82-90 | ○ |
| C-125 | IcuVersion::compare - 1桁0パディング比較 | E-10 L82-90 | ○ |
| C-126 | IcuVersion::normalize - 4コンポーネント正規化 | E-10 L81-90 | ○ |
| C-127 | IcuVersion::normalize - precision=1正規化 | E-10 L81-90 | ○ |
| C-128 | IcuVersion::normalize - precision=2正規化 | E-10 L81-90 | ○ |
| C-129 | IcuVersion::normalize - 1桁0パディング | E-10 L85-87 | ○ |
| C-130 | Version::compare - 同一バージョン等価 | E-11 L41-47 | ○ |
| C-131 | Version::compare - 大小比較 | E-11 L41-47 | ○ |
| C-132 | Version::compare - precision指定比較 | E-11 L41-47 | ○ |
| C-133 | Version::normalize - null精度でそのまま返却 | E-11 L64-68 | ○ |
| C-134 | Version::normalize - precision=1 | E-11 L64-81 | ○ |
| C-135 | Version::normalize - precision=2 | E-11 L64-81 | ○ |
| C-136 | Version::normalize - 空文字列でnull | E-11 L76-78 | ○ |
| C-137 | RingBuffer::offsetSet - 値の格納 | E-22 L59-68 | ○ |
| C-138 | RingBuffer::offsetGet - 値の取得 | E-22 L50-57 | ○ |
| C-139 | RingBuffer::offsetGet - 存在しないキーでException | E-22 L50-54 | ○ |
| C-140 | RingBuffer::offsetExists - 存在するキーでtrue | E-22 L45-48 | ○ |
| C-141 | RingBuffer::offsetExists - 存在しないキーでfalse | E-22 L45-48 | ○ |
| C-142 | RingBuffer::offsetSet - バッファ循環で古いエントリ上書き | E-22 L59-68 | ○ |
| C-143 | RingBuffer::offsetUnset - キー削除 | E-22 L71-77 | ○ |
| C-144 | RingBuffer::offsetUnset - 存在しないキー削除 | E-22 L71-77 | ○ |
| C-145 | RecursiveArrayAccess::get - 単一インデックスアクセス | E-23 L23-43 | ○ |
| C-146 | RecursiveArrayAccess::get - ネストインデックスアクセス | E-23 L23-43 | ○ |
| C-147 | RecursiveArrayAccess::get - ArrayAccessオブジェクト | E-23 L32-36 | ○ |
| C-148 | RecursiveArrayAccess::get - 存在しないインデックスでException | E-23 L39 | ○ |
| C-149 | RecursiveArrayAccess::get - 空インデックスでそのまま返却 | E-23 L25-42 | ○ |
| C-150 | PhpBundleReader::read - 有効PHPバンドル読み込み | E-17 L26-44 | ○ |
| C-151 | PhpBundleReader::read - 存在しないファイルでException | E-17 L39-41 | ○ |
| C-152 | PhpBundleReader::read - ディレクトリトラバーサル防止 | E-17 L31-33 | ○ |
| C-153 | JsonBundleReader::read - 有効JSONバンドル読み込み | E-18 L26-46 | ○ |
| C-154 | JsonBundleReader::read - 存在しないファイルでException | E-18 L35-37 | ○ |
| C-155 | JsonBundleReader::read - 不正JSONでRuntimeException | E-18 L41-43 | ○ |
| C-156 | JsonBundleReader::read - ディレクトリトラバーサル防止 | E-18 L31-33 | ○ |
| C-157 | BufferedBundleReader::read - 初回読み込み | E-16 L33-42 | ○ |
| C-158 | BufferedBundleReader::read - キャッシュ動作 | E-16 L33-42 | ○ |
| C-159 | BundleEntryReader::readEntry - 有効インデックスでエントリ読み込み | E-15 L64-168 | ○ |
| C-160 | BundleEntryReader::readEntry - フォールバックマージ | E-15 L89-114 | ○ |
| C-161 | BundleEntryReader::readEntry - フォールバック無効化 | E-15 L89, L129-131 | ○ |
| C-162 | BundleEntryReader::readEntry - 存在しないインデックスでException | E-15 L149-167 | ○ |
| C-163 | BundleEntryReader::readEntry - ロケールエイリアス解決 | E-15 L75-77 | ○ |
| C-164 | BundleEntryReader::setLocaleAliases - エイリアス設定 | E-15 L54-57 | ○ |
| C-165 | JsonBundleWriter::write - JSON書き出し | E-20 L23-38 | ○ |
| C-166 | JsonBundleWriter::write - Traversable変換 | E-20 L25-33 | ○ |
| C-167 | PhpBundleWriter::write - PHP書き出し | E-21 L25-45 | ○ |
| C-168 | PhpBundleWriter::write - Traversable変換 | E-21 L34-42 | ○ |
| C-169 | ArrayAccessibleResourceBundle::get - 値取得 | E-25 L33-38 | ○ |
| C-170 | ArrayAccessibleResourceBundle::get - ネストバンドルラップ | E-25 L37 | ○ |
| C-171 | ArrayAccessibleResourceBundle::offsetExists - 存在チェック | E-25 L40-43 | ○ |
| C-172 | ArrayAccessibleResourceBundle::offsetSet - 不変性保証 | E-25 L50-53 | ○ |
| C-173 | ArrayAccessibleResourceBundle::offsetUnset - 不変性保証 | E-25 L55-58 | ○ |
| C-174 | ArrayAccessibleResourceBundle::count - 要素数返却 | E-25 L65-68 | ○ |
| C-175 | UnexpectedTypeException - エラーメッセージ生成 | E-26 L21-24 | ○ |
| C-176 | IntlTestHelper::requireIntl - 正常動作 | E-14 L33-59 | ○ |
| C-177 | IntlTestHelper::requireIntl - テストスキップ | E-14 L43-44 | ○ |
| C-178 | IntlTestHelper::requireFullIntl - intl拡張チェック | E-14 L65-73 | ○ |
| C-179 | LocaleScanner::scanLocales - ロケール一覧取得 | E-24 L41-54 | ○ |
| C-180 | LocaleScanner::scanLocales - 非ロケール除外 | E-24 L49 | ○ |
| C-181 | LocaleScanner::scanAliases - エイリアス検出 | E-24 L62-78 | ○ |
| C-182 | LocaleScanner::scanParents - 親ロケール検出 | E-24 L83-98 | ○ |
| C-183 | GzipStreamWrapper::require - gzip読み込み | E-13 L26-38 | ○ |
| C-184 | GzipStreamWrapper::require - zlib拡張チェック | E-13 L28-30 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-070**: Languages::alpha3CodeExistsのキャッシュフォールバックパスを通る具体的な言語コード（alpha-2変換がないが3文字コード一覧に存在するもの）がICUデータを確認しないと特定できない
  - 候補：ICUデータファイルの確認 / 既存テストの確認 / 言語学的知識
- **C-072**: Languages::getAlpha3Nameでalpha-2変換なしの3文字コードで直接言語名を取得できるケースの具体例が不明
  - 候補：ICUデータファイルの確認 / 既存テストの確認
- **C-092**: Timezones::existsでICU NamesにないがDateTimeZoneで有効なタイムゾーンの具体例が不明
  - 候補：PHP DateTimeZone対応一覧 / ICU NamesのTZ一覧との差分確認
- **C-104**: Timezones::forCountryCodeでタイムゾーンが存在しない有効な国コードの具体例が不明
  - 候補：ICUデータのCountryToZone一覧 / Countries::exists()との照合
- **C-052**: Currencies::isValidInCountryでfalseとなる国と通貨の具体的な組み合わせはICUデータに依存
  - 候補：ICUデータのMap確認（ただしロジック自体はコードから明確）
- **C-044**: Currencies::getNumericCodeで数値コードを持たない具体的な通貨コード（XTS等）はICUデータに依存
  - 候補：ICUデータのAlpha3ToNumeric一覧確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Util/Version, Util/IcuVersion, RingBuffer, RecursiveArrayAccess, 例外クラスのテストケース。ロジックが単純で根拠が明確。
- 0: 低リスク - Countries, Currencies, Languages, Scripts, Locales, Timezonesの基本的な正常系・異常系テスト。ソースコードから直接導出可能。
- 1: 中リスク - ICUデータに依存する具体的な入出力値（特定の国コード、通貨コード等の期待結果）。ICUバージョンの更新により変動する可能性がある。
- 1: 中リスク - Currencies::forCountry, isValidInCountry, isValidInAnyCountryのdate関連パラメータのテスト。日付依存のテストは実行タイミングにより結果が変わる可能性。
- 0: 低リスク - PhpBundleReader, JsonBundleReaderのセキュリティ（ディレクトリトラバーサル防止）テスト。コードから防御ロジックが明確。

## 6) レビュアーチェックリスト（最小）
- [ ] ICUデータに依存する期待結果（国名、通貨名、言語名等）が現行ICUバージョン(78.1)と整合しているか
- [ ] Currencies::forCountry/isValidInCountryの日付関連テストケースが時刻に依存しない形で記述されているか
- [ ] Languages::alpha3CodeExistsのキャッシュ付きフォールバックパスをカバーする具体的なテストデータが特定されているか
- [ ] Timezones::existsのDateTimeZoneフォールバックパスの具体的テストデータが特定されているか
- [ ] ディレクトリトラバーサル防止テスト（PhpBundleReader, JsonBundleReader）のペイロードが十分か
- [ ] GitRepositoryクラスが外部コマンド(git)に依存するため、単体テストから除外されているのは妥当か
- [ ] withUserAssigned機能のテストにおいて、テスト間で状態がリセットされているか確認
