---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 170
  claims_with_evidence: 164
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：Component-JsonPath 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：164 / 170、根拠なし：6
- 優先レビュー（高）
  1. **UT-JPT-071 絶対パス参照フィルタ**：フィルタ内での$参照の挙動はコード上確認できるが、実際のJSON入力に対する期待結果は複雑で要確認
  2. **UT-JPT-077 混合ブラケット式**：フィルタとインデックスの混合は複数の条件分岐に依存し、期待結果の正確性は要検証
  3. **UT-JPT-082 normalizeStorage**：stdClassから配列への再帰正規化の詳細な出力形式は要確認
  4. **UT-JPT-114 サロゲートペアデコード**：サロゲートペア処理の完全な検証は実行環境依存
  5. **UT-JPT-147 strict=falseの非厳密比較**：in_arrayの第3引数falseの挙動は確認可能だが、実際のJSON結果型との組み合わせは要確認
  6. **UT-JPT-133 parseCommaSeparatedValues空文字列**：空文字列入力時の戻り値が空配列かは実装の末尾条件に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/JsonPath/JsonPath.php` - JsonPathクラス（イミュータブルなパスビルダー）
- E-02: `src/Symfony/Component/JsonPath/JsonCrawler.php` - JsonCrawlerクラス（RFC 9535準拠のJSONクロール）
- E-03: `src/Symfony/Component/JsonPath/JsonCrawlerInterface.php` - JsonCrawlerInterfaceインタフェース
- E-04: `src/Symfony/Component/JsonPath/JsonPathUtils.php` - ユーティリティ関数群
- E-05: `src/Symfony/Component/JsonPath/Nothing.php` - Nothing enum定義
- E-06: `src/Symfony/Component/JsonPath/Tokenizer/JsonPathTokenizer.php` - トークナイザ
- E-07: `src/Symfony/Component/JsonPath/Tokenizer/JsonPathToken.php` - トークンクラス
- E-08: `src/Symfony/Component/JsonPath/Tokenizer/TokenType.php` - トークン種別enum
- E-09: `src/Symfony/Component/JsonPath/Test/JsonPathAssertionsTrait.php` - PHPUnitアサーションtrait
- E-10: `src/Symfony/Component/JsonPath/Test/JsonPathContains.php` - Containsコンストレイント
- E-11: `src/Symfony/Component/JsonPath/Test/JsonPathNotContains.php` - NotContainsコンストレイント
- E-12: `src/Symfony/Component/JsonPath/Test/JsonPathSame.php` - Sameコンストレイント
- E-13: `src/Symfony/Component/JsonPath/Test/JsonPathNotSame.php` - NotSameコンストレイント
- E-14: `src/Symfony/Component/JsonPath/Test/JsonPathEquals.php` - Equalsコンストレイント
- E-15: `src/Symfony/Component/JsonPath/Test/JsonPathNotEquals.php` - NotEqualsコンストレイント
- E-16: `src/Symfony/Component/JsonPath/Test/JsonPathCount.php` - Countコンストレイント
- E-17: `src/Symfony/Component/JsonPath/Exception/InvalidJsonPathException.php` - 例外クラス
- E-18: `src/Symfony/Component/JsonPath/Exception/InvalidArgumentException.php` - 例外クラス
- E-19: `src/Symfony/Component/JsonPath/Exception/InvalidJsonStringInputException.php` - 例外クラス
- E-20: `src/Symfony/Component/JsonPath/Exception/JsonCrawlerException.php` - 例外クラス
- E-21: `src/Symfony/Component/JsonPath/Exception/ExceptionInterface.php` - 例外インタフェース

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JsonPath::__constructのデフォルト値はpath='$' | E-01 (L24-27) | ○ |
| C-02 | JsonPath::keyはエスケープしてブラケット記法を追加 | E-01 (L29-33, L85-103) | ○ |
| C-03 | JsonPath::escapeKeyは改行/タブ/バックスラッシュ等をエスケープ | E-01 (L85-103) | ○ |
| C-04 | JsonPath::indexは整数インデックスのブラケットを追加 | E-01 (L36-38) | ○ |
| C-05 | JsonPath::deepScanは'..'を追加 | E-01 (L41-43) | ○ |
| C-06 | JsonPath::allは'[*]'を追加 | E-01 (L45-47) | ○ |
| C-07 | JsonPath::first/lastは[0]/[-1]を追加 | E-01 (L49-58) | ○ |
| C-08 | JsonPath::sliceはstart:end:stepのブラケットを追加 | E-01 (L60-71) | ○ |
| C-09 | JsonPath::filterは'[?(expression)]'を追加 | E-01 (L74-77) | ○ |
| C-10 | JsonPath::__toStringはpath文字列を返却 | E-01 (L79-82) | ○ |
| C-11 | JsonPathはイミュータブル（新しいインスタンスを返す） | E-01 (L17, L29-77) | ○ |
| C-12 | JsonCrawler::__constructはstring/resourceのみ受け付ける | E-02 (L57-64) | ○ |
| C-13 | JsonCrawler::findはstring/JsonPathクエリを受け付ける | E-02 (L66-68) | ○ |
| C-14 | JsonCrawlerは不正JSONでInvalidJsonStringInputExceptionをスロー | E-02 (L87-91, L125-129) | ○ |
| C-15 | ワイルドカード(*)は全子要素を返却 | E-02 (L209-210, L226-228) | ○ |
| C-16 | 負のインデックスは末尾からのアクセス | E-02 (L231-244) | ○ |
| C-17 | 先頭ゼロ/-0/整数オーバーフローはエラー | E-02 (L232-234, L248-250) | ○ |
| C-18 | スライスは開始:終了:ステップで動作 | E-02 (L289-362) | ○ |
| C-19 | ステップ0は空配列を返却 | E-02 (L323-324) | ○ |
| C-20 | フィルタ式は?接頭辞で始まる | E-02 (L385-421) | ○ |
| C-21 | 比較演算子==, !=, >, >=, <, <=をサポート | E-02 (L46-53, L579-589) | ○ |
| C-22 | 論理演算子&&, ||をサポート | E-02 (L568-577) | ○ |
| C-23 | 否定演算子!をサポート | E-02 (L564-565) | ○ |
| C-24 | RFC9535関数 length/count/match/search/valueをサポート | E-02 (L33-39, L743-803) | ○ |
| C-25 | length関数はstring/array/stdClassに対応 | E-02 (L786-791) | ○ |
| C-26 | match関数は完全一致正規表現マッチ | E-02 (L793-795) | ○ |
| C-27 | search関数は部分一致正規表現マッチ | E-02 (L797-799) | ○ |
| C-28 | 不正な関数名でエラー | E-02 (L614-617) | ○ |
| C-29 | 非特異クエリは比較で使用不可 | E-02 (L946-973, L1024-1029) | ○ |
| C-30 | evaluateRecursiveは再帰的に全子孫を収集 | E-02 (L806-824) | ○ |
| C-31 | compareEqualityはNothing同士/型別の比較を実行 | E-02 (L836-881) | ○ |
| C-32 | compareOrderingはnull/数値/文字列/ブールの順序比較 | E-02 (L920-944) | ○ |
| C-33 | normalizeStorageはstdClassを配列に変換 | E-02 (L1097-1100) | ○ |
| C-34 | JsonPathTokenizer::tokenizeは$で始まることを検証 | E-06 (L47-54) | ○ |
| C-35 | 空のブラケットはエラー | E-06 (L155-157) | ○ |
| C-36 | 閉じられていないブラケット/文字列/括弧はエラー | E-06 (L242-247, L112-115, L161-163) | ○ |
| C-37 | 3つ以上の連続ドットはエラー | E-06 (L225-228) | ○ |
| C-38 | 末尾ドットはエラー | E-06 (L232-234) | ○ |
| C-39 | プロパティ名のホワイトスペースはエラー | E-06 (L71-74) | ○ |
| C-40 | 再帰下降のみでセレクタなしはエラー | E-06 (L263-265) | ○ |
| C-41 | 制御文字(U+0000-U+001F)はクォート内でエラー | E-06 (L91-96) | ○ |
| C-42 | 不正なUnicodeサロゲートペアはエラー | E-06 (L438-502) | ○ |
| C-43 | 大文字化リテラル(True/False/Null)はエラー | E-06 (L358-359) | ○ |
| C-44 | ベアリテラルはフィルタ式でエラー | E-06 (L401-403) | ○ |
| C-45 | 関数結果のブール比較はエラー | E-06 (L409-412) | ○ |
| C-46 | 関数名と括弧間のホワイトスペースはエラー | E-06 (L196-199) | ○ |
| C-47 | count関数にリテラル引数はエラー | E-06 (L380-382) | ○ |
| C-48 | match/search関数は引数2つ必須 | E-06 (L389-398) | ○ |
| C-49 | JsonPathUtils::unescapeStringはJSON/手動デコードで文字列をアンエスケープ | E-04 (L93-130) | ○ |
| C-50 | Unicode サロゲートペアのデコード | E-04 (L132-162) | ○ |
| C-51 | normalizeWhitespaceはタブ/改行をスペースに変換しトリム | E-04 (L167-176) | ○ |
| C-52 | isJsonNumberはRFC9535準拠の正規表現で検証 | E-04 (L181-184) | ○ |
| C-53 | parseCommaSeparatedValuesはクォート/ブラケット内カンマを無視 | E-04 (L186-230) | ○ |
| C-54 | hasLeadingZeroは先頭ゼロを検出 | E-04 (L232-239) | ○ |
| C-55 | isIntegerOverflowは2^53-1を超える整数を検出 | E-04 (L246-265) | ○ |
| C-56 | JsonPathContains::matchesはin_array(strict)で判定 | E-10 (L35-39) | ○ |
| C-57 | JsonPathNotContains::matchesは!in_array(strict)で判定 | E-11 (L35-39) | ○ |
| C-58 | JsonPathSame::matchesは===で比較 | E-12 (L35-37) | ○ |
| C-59 | JsonPathNotSame::matchesは!==で比較 | E-13 (L35-37) | ○ |
| C-60 | JsonPathEquals::matchesは==で比較 | E-14 (L35-37) | ○ |
| C-61 | JsonPathNotEquals::matchesは!=で比較 | E-15 (L35-37) | ○ |
| C-62 | JsonPathCount::matchesはcount結果と===で比較 | E-16 (L35-37) | ○ |
| C-63 | JsonPathAssertionsTraitは7種のアサーションメソッドを提供 | E-09 (L26-77) | ○ |
| C-64 | InvalidJsonPathExceptionはpositionありなしでメッセージ生成 | E-17 (L19-22) | ○ |
| C-65 | InvalidJsonStringInputExceptionはメッセージフォーマット | E-19 (L21-24) | ○ |
| C-66 | JsonCrawlerExceptionはpath+messageでメッセージ生成 | E-20 (L19-22) | ○ |
| C-67 | 絶対パス参照($)がフィルタ内で動作する | E-02 (L596-601, L702-708) | △ |
| C-68 | 混合ブラケット式の期待結果 | E-02 (L364-382, L1102-1124) | △ |
| C-69 | normalizeStorageの具体的な出力形式 | E-02 (L1097-1100) | △ |
| C-70 | サロゲートペアデコードの期待結果 | E-04 (L140-162) | △ |
| C-71 | strict=falseの非厳密比較の具体的挙動 | E-10 (L38-39) | △ |
| C-72 | parseCommaSeparatedValuesの空文字列入力の戻り値 | E-04 (L225-229) | △ |

## 4) 不足情報（Unknown / Missing）
- C-67: 絶対パス参照フィルタの複雑なJSONデータでの挙動は、実際のテスト実行での検証が必要
  - 候補：既存テストスイート / RFC 9535テストベクタ / 手動テスト実行
- C-68: 混合ブラケット式は複数の条件分岐パスが存在し、全組み合わせの網羅性を確認する必要あり
  - 候補：既存テストスイート / エッジケースの追加テスト
- C-69: normalizeStorageの再帰的なstdClass->array変換の出力形式は、ネストの深さに応じた挙動確認が必要
  - 候補：デバッグ実行 / 既存テスト
- C-70: サロゲートペアの正確なUTF-8変換結果は環境依存の可能性あり
  - 候補：PHP mb_chr関数のドキュメント / Unicode仕様
- C-71: PHPのin_array第3引数falseでの型変換ルールの網羅性
  - 候補：PHP公式ドキュメント / 型比較表
- C-72: parseCommaSeparatedValuesに空文字列が渡された場合、L225の条件分岐で空配列が返るかは末尾条件に依存
  - 候補：コード実行による検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JsonPath/JsonPathToken/Nothing/例外クラスは単純な構造で信頼度が高い
- 0: 低リスク - JsonPathUtils の各staticメソッドは独立性が高く、テストケースの根拠が明確
- 1: 中リスク - JsonCrawler の複合フィルタ式・再帰処理はコードパスが複雑で、テストケースの期待結果に微妙な差異がある可能性
- 1: 中リスク - JsonPathTokenizer のフィルタ式バリデーションは多くの正規表現パターンに依存しており、境界ケースの網羅性に不確実性あり
- 0: 低リスク - Test/Constraint クラスは薄いラッパーで構造が単純

## 6) レビュアーチェックリスト（最小）
- [ ] JsonCrawlerのフィルタ式テスト(UT-JPT-040〜081)の期待結果が正確か、実際のJSON入力で検証
- [ ] JsonPathTokenizerの異常系テスト(UT-JPT-090〜108)で、各例外メッセージの具体的な内容が正しいか確認
- [ ] スライスの境界値テスト(UT-JPT-036〜038, 062-063)で、負のステップ・0ステップの挙動が正しいか確認
- [ ] RFC 9535関数(length/count/match/search/value)のテストケースが仕様に準拠しているか確認
- [ ] JsonPathUtils::isIntegerOverflowの境界値(2^53-1)がRFC 9535 section 2.1の要件と合致しているか確認
- [ ] Test/Constraint クラスのテスト(UT-JPT-145〜165)で、PHPUnit Constraintの動作仕様と整合しているか確認
