---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 173
  claims_with_evidence: 168
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：Component-JsonStreamer 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：168 / 173、根拠なし：5
- 優先レビュー（高）
  1. **UT-JST-004 / UT-JST-014 キャッシュ再利用テスト**：内部キャッシュ配列の再利用動作は実装から推測したもので、外部から直接観測が困難
  2. **UT-JST-089 ReflectionClassキャッシュテスト**：staticキャッシュ変数の動作は内部実装依存
  3. **UT-JST-119 ファイル存在時のスキップ動作**：Filesystem::existsの結果に依存するため、テストではモックが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/JsonStreamer/JsonStreamReader.php` - JsonStreamReader本体（read, create）
- E-02: `src/Symfony/Component/JsonStreamer/JsonStreamWriter.php` - JsonStreamWriter本体（write, create）
- E-03: `src/Symfony/Component/JsonStreamer/StreamReaderInterface.php` - StreamReaderインターフェース定義
- E-04: `src/Symfony/Component/JsonStreamer/StreamWriterInterface.php` - StreamWriterインターフェース定義
- E-05: `src/Symfony/Component/JsonStreamer/StreamerDumper.php` - StreamerDumper（dump, getResourceClassNames）
- E-06: `src/Symfony/Component/JsonStreamer/Attribute/JsonStreamable.php` - JsonStreamable属性
- E-07: `src/Symfony/Component/JsonStreamer/Attribute/StreamedName.php` - StreamedName属性
- E-08: `src/Symfony/Component/JsonStreamer/Attribute/ValueTransformer.php` - ValueTransformer属性
- E-09: `src/Symfony/Component/JsonStreamer/CacheWarmer/StreamerCacheWarmer.php` - StreamerCacheWarmer（warmUp, isOptional）
- E-10: `src/Symfony/Component/JsonStreamer/DependencyInjection/StreamablePass.php` - StreamablePass（process）
- E-11: `src/Symfony/Component/JsonStreamer/Mapping/PropertyMetadata.php` - PropertyMetadata（getName, withName, getType, withType, etc.）
- E-12: `src/Symfony/Component/JsonStreamer/Mapping/PropertyMetadataLoader.php` - PropertyMetadataLoader（load）
- E-13: `src/Symfony/Component/JsonStreamer/Mapping/PropertyMetadataLoaderInterface.php` - PropertyMetadataLoaderInterface
- E-14: `src/Symfony/Component/JsonStreamer/Mapping/GenericTypePropertyMetadataLoader.php` - GenericTypePropertyMetadataLoader（load）
- E-15: `src/Symfony/Component/JsonStreamer/Mapping/Read/AttributePropertyMetadataLoader.php` - Read側AttributePropertyMetadataLoader
- E-16: `src/Symfony/Component/JsonStreamer/Mapping/Read/DateTimeTypePropertyMetadataLoader.php` - Read側DateTimeTypePropertyMetadataLoader
- E-17: `src/Symfony/Component/JsonStreamer/Mapping/Write/AttributePropertyMetadataLoader.php` - Write側AttributePropertyMetadataLoader
- E-18: `src/Symfony/Component/JsonStreamer/Mapping/Write/DateTimeTypePropertyMetadataLoader.php` - Write側DateTimeTypePropertyMetadataLoader
- E-19: `src/Symfony/Component/JsonStreamer/ValueTransformer/DateTimeToStringValueTransformer.php` - DateTimeToStringValueTransformer
- E-20: `src/Symfony/Component/JsonStreamer/ValueTransformer/StringToDateTimeValueTransformer.php` - StringToDateTimeValueTransformer
- E-21: `src/Symfony/Component/JsonStreamer/ValueTransformer/ValueTransformerInterface.php` - ValueTransformerInterface
- E-22: `src/Symfony/Component/JsonStreamer/Read/Decoder.php` - Decoder（decodeString, decodeStream）
- E-23: `src/Symfony/Component/JsonStreamer/Read/Instantiator.php` - Instantiator（instantiate）
- E-24: `src/Symfony/Component/JsonStreamer/Read/LazyInstantiator.php` - LazyInstantiator（instantiate）
- E-25: `src/Symfony/Component/JsonStreamer/Read/Lexer.php` - Lexer（getTokens, validateToken, getChunks）
- E-26: `src/Symfony/Component/JsonStreamer/Read/Splitter.php` - Splitter（splitList, splitDict）
- E-27: `src/Symfony/Component/JsonStreamer/Read/StreamReaderGenerator.php` - StreamReaderGenerator（generate, createDataModel）
- E-28: `src/Symfony/Component/JsonStreamer/Read/PhpGenerator.php` - Read側PhpGenerator（generate, generateProviders）
- E-29: `src/Symfony/Component/JsonStreamer/Write/PhpGenerator.php` - Write側PhpGenerator（generate, generateYields）
- E-30: `src/Symfony/Component/JsonStreamer/Write/StreamWriterGenerator.php` - StreamWriterGenerator（generate, createDataModel）
- E-31: `src/Symfony/Component/JsonStreamer/DataModel/Read/ScalarNode.php` - Read側ScalarNode
- E-32: `src/Symfony/Component/JsonStreamer/DataModel/Read/BackedEnumNode.php` - Read側BackedEnumNode
- E-33: `src/Symfony/Component/JsonStreamer/DataModel/Read/CollectionNode.php` - Read側CollectionNode
- E-34: `src/Symfony/Component/JsonStreamer/DataModel/Read/ObjectNode.php` - Read側ObjectNode
- E-35: `src/Symfony/Component/JsonStreamer/DataModel/Read/CompositeNode.php` - Read側CompositeNode
- E-36: `src/Symfony/Component/JsonStreamer/DataModel/Write/ScalarNode.php` - Write側ScalarNode
- E-37: `src/Symfony/Component/JsonStreamer/DataModel/Write/BackedEnumNode.php` - Write側BackedEnumNode
- E-38: `src/Symfony/Component/JsonStreamer/DataModel/Write/CollectionNode.php` - Write側CollectionNode
- E-39: `src/Symfony/Component/JsonStreamer/DataModel/Write/ObjectNode.php` - Write側ObjectNode
- E-40: `src/Symfony/Component/JsonStreamer/DataModel/Write/CompositeNode.php` - Write側CompositeNode
- E-41: `src/Symfony/Component/JsonStreamer/Exception/InvalidStreamException.php` - InvalidStreamException

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-JST-001: 文字列入力からオブジェクトが正しく読み取れること | E-01 (read メソッド L65-72) | ○ |
| C-02 | UT-JST-002: リソース入力からオブジェクトが正しく読み取れること | E-01 (is_resource判定 L68) | ○ |
| C-03 | UT-JST-003: defaultOptionsがoptionsにマージされること | E-01 ($options += $this->defaultOptions L67) | ○ |
| C-04 | UT-JST-004: キャッシュされたstreamReaderが再利用されること | E-01 ($this->streamReaders[$path] ??= require L71) | △ |
| C-05 | UT-JST-005: リソース入力時にLazyInstantiatorが使用されること | E-01 ($isStream ? $this->lazyInstantiator L71) | ○ |
| C-06 | UT-JST-006: 文字列入力時にInstantiatorが使用されること | E-01 ($isStream ? ... : $this->instantiator L71) | ○ |
| C-07 | UT-JST-007: デフォルト設定でcreateインスタンスが生成されること | E-01 (create L77-115) | ○ |
| C-08 | UT-JST-008: カスタムvalueTransformersが含まれること | E-01 ($valueTransformers += L80-82) | ○ |
| C-09 | UT-JST-009: StringToDateTimeValueTransformerがデフォルトで登録されること | E-01 (L81) | ○ |
| C-10 | UT-JST-010: データがTraversable&Stringableとして書き出されること | E-02 (write L62-96, anonymous class) | ○ |
| C-11 | UT-JST-011: 返却値がStringableとして文字列に変換できること | E-02 (__toString L86-94) | ○ |
| C-12 | UT-JST-012: 返却値がIteratorAggregateとしてチャンクを返すこと | E-02 (getIterator L81-83) | ○ |
| C-13 | UT-JST-013: defaultOptionsがoptionsにマージされること（Write） | E-02 ($options += $this->defaultOptions L64) | ○ |
| C-14 | UT-JST-014: キャッシュされたstreamWriterが再利用されること | E-02 ($this->streamWriters[$path] ??= require L66) | △ |
| C-15 | UT-JST-015: デフォルト設定でWriterのcreateインスタンスが生成されること | E-02 (create L101-139) | ○ |
| C-16 | UT-JST-016: DateTimeToStringValueTransformerがデフォルトで登録されること | E-02 (L105) | ○ |
| C-17 | UT-JST-017: JsonStreamable デフォルト値で生成 | E-06 (L20-24, asObject=true, asList=true) | ○ |
| C-18 | UT-JST-018: asObjectのみfalseに設定 | E-06 (コンストラクタパラメータ) | ○ |
| C-19 | UT-JST-019: asListのみfalseに設定 | E-06 (コンストラクタパラメータ) | ○ |
| C-20 | UT-JST-020-021: StreamedNameコンストラクタとgetName | E-07 (L22-29) | ○ |
| C-21 | UT-JST-022-024: ValueTransformerコンストラクタ（正常系） | E-08 (L33-51) | ○ |
| C-22 | UT-JST-025: ValueTransformer両方nullでLogicException | E-08 (L37-38) | ○ |
| C-23 | UT-JST-026-028: ValueTransformerのゲッター | E-08 (L53-61) | ○ |
| C-24 | UT-JST-029-039: PropertyMetadataの各メソッド | E-11 (全メソッド) | ○ |
| C-25 | UT-JST-040-044: PropertyMetadataLoaderのload | E-12 (L31-53) | ○ |
| C-26 | UT-JST-045-047: GenericTypePropertyMetadataLoaderのload | E-14 (L39-110) | ○ |
| C-27 | UT-JST-048-054: Read側AttributePropertyMetadataLoaderのload | E-15 (L39-124) | ○ |
| C-28 | UT-JST-055-057: Read側DateTimeTypePropertyMetadataLoaderのload | E-16 (L33-53) | ○ |
| C-29 | UT-JST-058-061: Write側AttributePropertyMetadataLoaderのload | E-17 (L39-121) | ○ |
| C-30 | UT-JST-062-064: Write側DateTimeTypePropertyMetadataLoaderのload | E-18 (L33-48) | ○ |
| C-31 | UT-JST-065-068: DateTimeToStringValueTransformerのtransform/getStreamValueType | E-19 (L28-43) | ○ |
| C-32 | UT-JST-069-076: StringToDateTimeValueTransformerのtransform/getStreamValueType | E-20 (L28-78) | ○ |
| C-33 | UT-JST-077-081: DecoderのdecodeString | E-22 (L25-32) | ○ |
| C-34 | UT-JST-082-083: DecoderのdecodeStream | E-22 (L37-40) | ○ |
| C-35 | UT-JST-084-086: Instantiatorのinstantiate | E-23 (L36-49) | ○ |
| C-36 | UT-JST-087-088: LazyInstantiatorのinstantiate（遅延初期化） | E-24 (L43-53) | ○ |
| C-37 | UT-JST-089: LazyInstantiator ReflectionClassキャッシュ | E-24 (self::$cache L46) | △ |
| C-38 | UT-JST-090: LazyInstantiator 存在しないクラスでRuntimeException | E-24 (L47-49) | ○ |
| C-39 | UT-JST-091-102: Lexerのトークン化テスト | E-25 (L52-289) | ○ |
| C-40 | UT-JST-103-110: Splitterのsplit系テスト | E-26 (L38-186) | ○ |
| C-41 | UT-JST-111-113: StreamReaderGeneratorのgenerate | E-27 (L59-153) | ○ |
| C-42 | UT-JST-114-115: StreamWriterGeneratorのgenerate | E-30 (L59-161) | ○ |
| C-43 | UT-JST-116-119: StreamerDumperのdump | E-05 (L44-70) | ○ |
| C-44 | UT-JST-119: ファイル存在時のスキップ動作 | E-05 (L67-69, !$this->fs->exists($path)) | △ |
| C-45 | UT-JST-120-125: StreamerCacheWarmerのwarmUp/isOptional | E-09 (L52-101) | ○ |
| C-46 | UT-JST-126-128: StreamablePassのprocess | E-10 (L24-45) | ○ |
| C-47 | UT-JST-129-145: Read側DataModelノードのゲッター/コンストラクタ | E-31, E-32, E-33, E-34, E-35 | ○ |
| C-48 | UT-JST-146-160: Write側DataModelノードのゲッター/コンストラクタ | E-36, E-37, E-38, E-39, E-40 | ○ |
| C-49 | UT-JST-161-167: Read側PhpGeneratorのgenerate | E-28 (L43-350) | ○ |
| C-50 | UT-JST-168-173: Write側PhpGeneratorのgenerate | E-29 (L46-449) | ○ |
| C-51 | UT-JST-089: ReflectionClassキャッシュの再利用確認 | E-24 (static $cache) | △ |

## 4) 不足情報（Unknown / Missing）
- キャッシュ再利用の検証（UT-JST-004, UT-JST-014）：内部配列 `$streamReaders` / `$streamWriters` の状態を外部から直接確認する手段がないため、実行時の副作用（requireの呼び出し回数等）で間接的に検証する必要がある
  - 候補：Reflection を使用した private プロパティの検査 / require をモック化
- ReflectionClass キャッシュ（UT-JST-089）：static プロパティへのアクセスが必要
  - 候補：Reflection を使用した static プロパティの検査 / 2回呼び出し後の同一インスタンス確認
- ファイル存在時のスキップ（UT-JST-119）：Filesystem の exists をモック化する必要がある
  - 候補：vfsStream を使用したファイルシステムのモック化

## 5) リスクフラグ（レビュー観点）
- 0: DataModel ノードのゲッター/コンストラクタテスト（単純な値の出し入れ）
- 0: Attribute クラスのコンストラクタ/ゲッターテスト
- 0: PropertyMetadata のイミュータブル操作テスト
- 1: ValueTransformer の変換テスト（日時フォーマットのバリエーション）
- 1: Lexer のトークン化テスト（境界条件の網羅性）
- 1: PhpGenerator のコード生成テスト（生成コードの正確性検証方法）
- 2: キャッシュ再利用テスト（内部状態の検証困難性）

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがすべてのpublicメソッドを網羅しているか確認
- [ ] 正常系・異常系・境界値の観点が各メソッドに対して適切にカバーされているか確認
- [ ] ValueTransformer の日時変換テストで、タイムゾーンや閏秒などの特殊ケースが追加で必要か検討
- [ ] Lexer のトークン化テストで、Unicode エスケープシーケンス（\uXXXX）のテストケースが十分か確認
- [ ] PhpGenerator の生成コードテストで、実際にPHPとして実行可能なコードが生成されるか検証方法を検討
- [ ] StreamerCacheWarmer の例外ハンドリングテストで、ログ出力内容の検証が必要か検討
- [ ] Read側とWrite側で対称的にテストが存在するか確認（AttributePropertyMetadataLoader, DateTimeTypePropertyMetadataLoader）
