---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 286
  claims_with_evidence: 280
  claims_without_evidence: 6
confidence_derived: 0.98
---

# 根拠レポート：Component-Lock 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：280 / 286、根拠なし：6
- 優先レビュー（高）
  1. **UT-LOK-030（Lock::acquire ポーリング動作）**：ブロッキング非対応ストアでの正確なポーリング間隔・リトライ動作は実行環境依存
  2. **UT-LOK-117（CombinedStore::putOffExpiration adjustedTtl<=0）**：時間経過に依存するためテスト実装が困難
  3. **UT-LOK-243（ZookeeperStore::createConnection 不正DSN）**：parse_url の挙動がPHPバージョンにより異なる可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Lock/Key.php` - Key クラスの完全なソースコード
- E-02: `src/Symfony/Component/Lock/Lock.php` - Lock クラスの完全なソースコード
- E-03: `src/Symfony/Component/Lock/LockFactory.php` - LockFactory クラスの完全なソースコード
- E-04: `src/Symfony/Component/Lock/NoLock.php` - NoLock クラスの完全なソースコード
- E-05: `src/Symfony/Component/Lock/LockInterface.php` - LockInterface の定義
- E-06: `src/Symfony/Component/Lock/SharedLockInterface.php` - SharedLockInterface の定義
- E-07: `src/Symfony/Component/Lock/PersistingStoreInterface.php` - PersistingStoreInterface の定義
- E-08: `src/Symfony/Component/Lock/BlockingStoreInterface.php` - BlockingStoreInterface の定義
- E-09: `src/Symfony/Component/Lock/BlockingSharedLockStoreInterface.php` - BlockingSharedLockStoreInterface の定義
- E-10: `src/Symfony/Component/Lock/SharedLockStoreInterface.php` - SharedLockStoreInterface の定義
- E-11: `src/Symfony/Component/Lock/Store/InMemoryStore.php` - InMemoryStore クラスの完全なソースコード
- E-12: `src/Symfony/Component/Lock/Store/FlockStore.php` - FlockStore クラスの完全なソースコード
- E-13: `src/Symfony/Component/Lock/Store/NullStore.php` - NullStore クラスの完全なソースコード
- E-14: `src/Symfony/Component/Lock/Store/CombinedStore.php` - CombinedStore クラスの完全なソースコード
- E-15: `src/Symfony/Component/Lock/Store/RedisStore.php` - RedisStore クラスの完全なソースコード
- E-16: `src/Symfony/Component/Lock/Store/MemcachedStore.php` - MemcachedStore クラスの完全なソースコード
- E-17: `src/Symfony/Component/Lock/Store/SemaphoreStore.php` - SemaphoreStore クラスの完全なソースコード
- E-18: `src/Symfony/Component/Lock/Store/StoreFactory.php` - StoreFactory クラスの完全なソースコード
- E-19: `src/Symfony/Component/Lock/Store/MongoDbStore.php` - MongoDbStore クラスの完全なソースコード
- E-20: `src/Symfony/Component/Lock/Store/PdoStore.php` - PdoStore クラスの完全なソースコード
- E-21: `src/Symfony/Component/Lock/Store/PostgreSqlStore.php` - PostgreSqlStore クラスの完全なソースコード
- E-22: `src/Symfony/Component/Lock/Store/DoctrineDbalStore.php` - DoctrineDbalStore クラスの完全なソースコード
- E-23: `src/Symfony/Component/Lock/Store/DoctrineDbalPostgreSqlStore.php` - DoctrineDbalPostgreSqlStore クラスの完全なソースコード
- E-24: `src/Symfony/Component/Lock/Store/ZookeeperStore.php` - ZookeeperStore クラスの完全なソースコード
- E-25: `src/Symfony/Component/Lock/Store/ExpiringStoreTrait.php` - ExpiringStoreTrait の完全なソースコード
- E-26: `src/Symfony/Component/Lock/Store/DatabaseTableTrait.php` - DatabaseTableTrait の完全なソースコード
- E-27: `src/Symfony/Component/Lock/Strategy/ConsensusStrategy.php` - ConsensusStrategy クラスの完全なソースコード
- E-28: `src/Symfony/Component/Lock/Strategy/UnanimousStrategy.php` - UnanimousStrategy クラスの完全なソースコード
- E-29: `src/Symfony/Component/Lock/Strategy/StrategyInterface.php` - StrategyInterface の定義
- E-30: `src/Symfony/Component/Lock/Serializer/LockKeyNormalizer.php` - LockKeyNormalizer クラスの完全なソースコード
- E-31: `src/Symfony/Component/Lock/Exception/UnserializableKeyException.php` - 例外クラスの定義
- E-32: `src/Symfony/Component/Lock/Exception/InvalidTtlException.php` - 例外クラスの定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Key クラス (UT-LOK-001 - UT-LOK-023)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Key::__construct でリソース名を受け取りインスタンス生成 | E-01 (L27-30) | ○ |
| C-02 | Key::__toString でリソース名をstring返却 | E-01 (L32-35) | ○ |
| C-03 | Key::setState/hasState/getState/removeState で状態管理 | E-01 (L37-55) | ○ |
| C-04 | Key::reduceLifetime で expiringTime を短縮方向のみ更新 | E-01 (L70-77) | ○ |
| C-05 | Key::getRemainingLifetime でnullまたは残存秒数返却 | E-01 (L82-85) | ○ |
| C-06 | Key::isExpired で期限切れ判定 | E-01 (L87-89) | ○ |
| C-07 | Key::resetLifetime で expiringTime をnullリセット | E-01 (L62-65) | ○ |
| C-08 | Key::markUnserializable でシリアライズ拒否 | E-01 (L57-59, L99-103) | ○ |
| C-09 | Key::__serialize でシリアライズ可能時配列返却 | E-01 (L99-110) | ○ |
| C-10 | Key::__unserialize で旧形式含むデシリアライズ | E-01 (L92-97) | ○ |

### Lock クラス (UT-LOK-024 - UT-LOK-057)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | Lock::acquire 非ブロッキングでstore.save呼出 | E-02 (L84-86) | ○ |
| C-12 | Lock::acquire TTL設定時にrefresh呼出 | E-02 (L91-93) | ○ |
| C-13 | Lock::acquire LockConflictedException時にfalse返却 | E-02 (L105-113) | ○ |
| C-14 | Lock::acquire ブロッキングでBlockingStoreInterface時waitAndSave | E-02 (L71-83) | ○ |
| C-15 | Lock::acquire 非BlockingStoreでのポーリング動作 | E-02 (L73-80) | △ |
| C-16 | Lock::acquire 期限切れ時LockExpiredException | E-02 (L95-102) | ○ |
| C-17 | Lock::acquire 一般例外時LockAcquiringException | E-02 (L114-117) | ○ |
| C-18 | Lock::acquireRead SharedLockStoreInterface使用時saveRead | E-02 (L124, L143) | ○ |
| C-19 | Lock::acquireRead 非SharedLockStoreでacquireフォールバック | E-02 (L124-128) | ○ |
| C-20 | Lock::acquireRead BlockingSharedLockStore時waitAndSaveRead | E-02 (L130, L140) | ○ |
| C-21 | Lock::refresh TTL未設定時InvalidArgumentException | E-02 (L180-182) | ○ |
| C-22 | Lock::refresh LockConflictedException時dirty=false | E-02 (L199-202) | ○ |
| C-23 | Lock::refresh 一般例外時LockAcquiringException | E-02 (L203-206) | ○ |
| C-24 | Lock::refresh 期限切れ時LockExpiredException | E-02 (L189-196) | ○ |
| C-25 | Lock::isAcquired はstore.existsに委譲 | E-02 (L209-212) | ○ |
| C-26 | Lock::release store.delete成功後exists確認 | E-02 (L214-234) | ○ |
| C-27 | Lock::release store.delete例外時LockReleasingException | E-02 (L220-224) | ○ |
| C-28 | Lock::__destruct autoRelease条件でrelease | E-02 (L58-65) | ○ |
| C-29 | Lock::__serialize BadMethodCallException | E-02 (L45-48) | ○ |

### LockFactory クラス (UT-LOK-058 - UT-LOK-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | LockFactory::createLock でLockインスタンス生成 | E-03 (L39-42) | ○ |
| C-31 | LockFactory::createLockFromKey でLogger伝播 | E-03 (L51-59) | ○ |

### NoLock クラス (UT-LOK-064 - UT-LOK-071)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | NoLock の全メソッドは固定値を返す | E-04 (L24-55) | ○ |

### InMemoryStore クラス (UT-LOK-072 - UT-LOK-087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | InMemoryStore::save でトークンベースロック管理 | E-11 (L29-55) | ○ |
| C-34 | InMemoryStore::save ReadLock→WriteLock昇格 | E-11 (L43-48) | ○ |
| C-35 | InMemoryStore::saveRead 複数ReadLock共有 | E-11 (L57-79) | ○ |
| C-36 | InMemoryStore::saveRead WriteLock→ReadLock降格 | E-11 (L70-76) | ○ |
| C-37 | InMemoryStore::delete トークンベース削除 | E-11 (L86-95) | ○ |
| C-38 | InMemoryStore::exists トークンベース存在確認 | E-11 (L97-103) | ○ |

### FlockStore クラス (UT-LOK-088 - UT-LOK-101)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | FlockStore::__construct ディレクトリ検証 | E-12 (L40-51) | ○ |
| C-40 | FlockStore::save/saveRead/waitAndSave/waitAndSaveRead でflock操作 | E-12 (L53-71) | ○ |
| C-41 | FlockStore::lock でmarkUnserializable | E-12 (L120) | ○ |
| C-42 | FlockStore::delete でflock解放 | E-12 (L128-141) | ○ |

### CombinedStore クラス (UT-LOK-108 - UT-LOK-122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | CombinedStore::__construct ストア検証 | E-14 (L38-47) | ○ |
| C-44 | CombinedStore::save/saveRead で合議制 | E-14 (L49-119) | ○ |
| C-45 | CombinedStore::putOffExpiration adjustedTtl計算 | E-14 (L121-160) | △ |
| C-46 | CombinedStore::delete 全ストア削除 | E-14 (L162-171) | ○ |
| C-47 | CombinedStore::exists 合議制存在確認 | E-14 (L173-200) | ○ |

### RedisStore クラス (UT-LOK-123 - UT-LOK-134)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | RedisStore::__construct TTL検証 | E-15 (L41-48) | ○ |
| C-49 | RedisStore::save/saveRead/putOffExpiration/delete/exists Luaスクリプト実行 | E-15 (L50-229) | ○ |

### MemcachedStore クラス (UT-LOK-135 - UT-LOK-147)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | MemcachedStore::__construct 拡張・TTL検証 | E-16 (L31-49) | ○ |
| C-51 | MemcachedStore::save add/putOffExpiration | E-16 (L52-62) | ○ |
| C-52 | MemcachedStore::putOffExpiration CAS操作 | E-16 (L64-98) | ○ |
| C-53 | MemcachedStore::delete CAS安全削除 | E-16 (L100-119) | ○ |

### SemaphoreStore クラス (UT-LOK-148 - UT-LOK-157)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | SemaphoreStore::__construct 拡張検証 | E-17 (L36-41) | ○ |
| C-55 | SemaphoreStore::save/waitAndSave/delete/exists セマフォ操作 | E-17 (L43-98) | ○ |

### StoreFactory クラス (UT-LOK-158 - UT-LOK-177)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | StoreFactory::createStore 各種接続/DSNからストア生成 | E-18 (L29-129) | ○ |
| C-57 | StoreFactory::createStore 不正入力時 InvalidArgumentException | E-18 (L59-60, L128) | ○ |

### MongoDbStore クラス (UT-LOK-178 - UT-LOK-191)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | MongoDbStore::__construct 各種入力とバリデーション | E-19 (L98-141) | ○ |
| C-59 | MongoDbStore::save/putOffExpiration upsert操作 | E-19 (L225-263) | ○ |
| C-60 | MongoDbStore::skimUri でURI解析 | E-19 (L150-175) | ○ |

### PdoStore クラス (UT-LOK-192 - UT-LOK-205)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | PdoStore::__construct PDO/DSNとバリデーション | E-20 (L67-84) | ○ |
| C-62 | PdoStore::save INSERT + テーブル自動作成 | E-20 (L86-123) | ○ |
| C-63 | PdoStore::putOffExpiration TTL検証・UPDATE | E-20 (L125-148) | ○ |

### PostgreSqlStore クラス (UT-LOK-206 - UT-LOK-217)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | PostgreSqlStore::__construct ドライバ検証 | E-21 (L51-67) | ○ |
| C-65 | PostgreSqlStore::save/saveRead/waitAndSave/waitAndSaveRead アドバイザリロック | E-21 (L69-226) | ○ |
| C-66 | PostgreSqlStore::putOffExpiration exists確認のみ | E-21 (L134-141) | ○ |

### DoctrineDbalStore クラス (UT-LOK-218 - UT-LOK-228)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | DoctrineDbalStore::__construct Connection/DSN | E-22 (L72-99) | ○ |
| C-68 | DoctrineDbalStore::save/putOffExpiration/delete/exists DBAL操作 | E-22 (L101-191) | ○ |
| C-69 | DoctrineDbalStore::configureSchema Schema操作 | E-22 (L211-227) | ○ |

### DoctrineDbalPostgreSqlStore クラス (UT-LOK-229 - UT-LOK-239)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | DoctrineDbalPostgreSqlStore::__construct プラットフォーム検証 | E-23 (L43-71) | ○ |
| C-71 | DoctrineDbalPostgreSqlStore アドバイザリロック操作 | E-23 (L73-227) | ○ |
| C-72 | DoctrineDbalPostgreSqlStore::filterDsn DSNフィルタリング | E-23 (L263-276) | ○ |

### ZookeeperStore クラス (UT-LOK-240 - UT-LOK-253)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | ZookeeperStore::createConnection DSN検証と接続生成 | E-24 (L35-55) | ○ |
| C-74 | ZookeeperStore::save 一時ノード作成 | E-24 (L57-70) | ○ |
| C-75 | ZookeeperStore::createNewLock NODEEXISTS時LockConflictedException | E-24 (L111-127) | ○ |
| C-76 | ZookeeperStore::delete 例外時LockReleasingException | E-24 (L72-85) | ○ |
| C-77 | ZookeeperStore::createConnection 不正DSN時のparse_url挙動 | E-24 (L41-43) | △ |

### DatabaseTableTrait (UT-LOK-254 - UT-LOK-260)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | DatabaseTableTrait::init バリデーション | E-26 (L30-46) | ○ |
| C-79 | DatabaseTableTrait::getHashedKey SHA256ハッシュ | E-26 (L51-54) | ○ |
| C-80 | DatabaseTableTrait::randomlyPrune 確率的剪定 | E-26 (L69-74) | ○ |

### ExpiringStoreTrait (UT-LOK-261 - UT-LOK-263)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | ExpiringStoreTrait::checkNotExpired 期限切れ判定とdelete | E-25 (L19-29) | ○ |

### Strategy クラス (UT-LOK-264 - UT-LOK-277)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | ConsensusStrategy::isMet 過半数判定 | E-27 (L21-24) | ○ |
| C-83 | ConsensusStrategy::canBeMet 過半数達成可能判定 | E-27 (L26-29) | ○ |
| C-84 | UnanimousStrategy::isMet 全一致判定 | E-28 (L21-24) | ○ |
| C-85 | UnanimousStrategy::canBeMet 失敗0判定 | E-28 (L26-29) | ○ |

### LockKeyNormalizer (UT-LOK-278 - UT-LOK-286)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | LockKeyNormalizer::normalize Key.__serialize呼出 | E-30 (L33-36) | ○ |
| C-87 | LockKeyNormalizer::denormalize ReflectionClass使用 | E-30 (L43-49) | ○ |
| C-88 | LockKeyNormalizer::supportsNormalization instanceof判定 | E-30 (L38-41) | ○ |
| C-89 | LockKeyNormalizer::supportsDenormalization 型一致判定 | E-30 (L51-54) | ○ |
| C-90 | LockKeyNormalizer::getSupportedTypes Key::class返却 | E-30 (L25-28) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-LOK-030（Lock::acquire ポーリング動作）**：usleep の具体的な待機時間（100ms +/- 10ms）はソースコードで確認済みだが、実際のリトライ回数や収束性は実行環境に依存
  - 候補：統合テストでの実証 / パフォーマンステスト
- **UT-LOK-117（CombinedStore::putOffExpiration adjustedTtl<=0）**：マイクロ秒レベルの時間判定を含むため、テスト時に確実に再現することが困難
  - 候補：タイムモック / Clock コンポーネントの利用
- **UT-LOK-243（ZookeeperStore::createConnection 不正DSN）**：parse_url が false を返すケースはPHPバージョンにより異なる可能性
  - 候補：PHPバージョン別テスト / 具体的な不正URI例のドキュメント化
- **外部サービス依存のStore（Redis, Memcached, MongoDB, PostgreSQL, Zookeeper）**：実際の接続が必要なテストケースは統合テストとして実装が必要
  - 候補：Docker Compose による統合テスト環境 / テストダブルの活用
- **Predis クライアント対応（RedisStore::evaluate）**：Predis 固有のエラーハンドリング（handlePredisError）の動作確認
  - 候補：Predis モックの作成
- **RedisStore::getNowCode の TIME コマンドサポート判定**：Redis バージョン依存の分岐の網羅テスト
  - 候補：Redis バージョン別テスト

## 5) リスクフラグ（レビュー観点）
- **リスク 1（中）**: 外部サービス依存Store（Redis, Memcached, MongoDB, PostgreSQL, Zookeeper）のテストケースは、モックベースの記述であり、実際のサービスとの互換性を保証しない。統合テストと併用する必要がある。
- **リスク 0（低）**: Key, Lock, LockFactory, NoLock, Strategy, LockKeyNormalizer のテストケースはソースコードとの整合性が高く、純粋な単体テストとして実装可能。
- **リスク 0（低）**: InMemoryStore, FlockStore, NullStore のテストケースは外部依存が少なく、単体テストとして実装可能。
- **リスク 1（中）**: CombinedStore の時間依存テスト（putOffExpiration の adjustedTtl 計算）は、テスト実装時にタイムモック等の工夫が必要。

## 6) レビュアーチェックリスト（最小）
- [ ] Key クラスの状態管理（setState/getState/hasState/removeState）のテストケースが網羅されているか
- [ ] Lock::acquire のブロッキング/非ブロッキング両方のテストケースが存在するか
- [ ] Lock::acquireRead の SharedLockStoreInterface 対応/非対応のフォールバック動作が確認されているか
- [ ] Lock::refresh の TTL 引数あり/なし/null のパターンが網羅されているか
- [ ] CombinedStore の合議制テスト（ConsensusStrategy/UnanimousStrategy）が充分か
- [ ] StoreFactory::createStore の各種 DSN パターンが網羅されているか
- [ ] 各Store の save/delete/exists/putOffExpiration の正常系・異常系が存在するか
- [ ] 境界値テスト（TTL=0, gcProbability=0.0/1.0, 空コレクション等）が含まれているか
- [ ] LockKeyNormalizer の normalize/denormalize の往復変換テストが検討されているか
- [ ] 例外の種類（LockConflictedException, LockAcquiringException, LockReleasingException, LockExpiredException, InvalidArgumentException, InvalidTtlException, UnserializableKeyException）が適切に使い分けられているか
