---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 251
  claims_with_evidence: 245
  claims_without_evidence: 6
confidence_derived: 0.98
---

# 根拠レポート：Component-Mailer 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：245 / 251、根拠なし：6
- 優先レビュー（高）
  1. **C-176（RoundRobinTransport dead transport復活テスト）**：retryPeriod経過後の動作はタイミングに依存するため、テスト設計の詳細確認が必要
  2. **C-190（TemplatedEmail未レンダリングチェック）**：TemplatedEmailはBridge-Twigに依存しており、Component-Mailer単体テストの範囲確認が必要
  3. **C-250（NativeTransportFactory create）**：php.ini設定（sendmail_path）に依存するため、テスト環境の前提条件確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Mailer/Envelope.php` - Envelopeクラス定義
- E-02: `src/Symfony/Component/Mailer/DelayedEnvelope.php` - DelayedEnvelopeクラス定義
- E-03: `src/Symfony/Component/Mailer/Mailer.php` - Mailerクラス定義
- E-04: `src/Symfony/Component/Mailer/SentMessage.php` - SentMessageクラス定義
- E-05: `src/Symfony/Component/Mailer/Transport.php` - Transportファクトリクラス定義
- E-06: `src/Symfony/Component/Mailer/Event/MessageEvent.php` - MessageEventクラス定義
- E-07: `src/Symfony/Component/Mailer/Event/MessageEvents.php` - MessageEventsクラス定義
- E-08: `src/Symfony/Component/Mailer/Event/FailedMessageEvent.php` - FailedMessageEventクラス定義
- E-09: `src/Symfony/Component/Mailer/Event/SentMessageEvent.php` - SentMessageEventクラス定義
- E-10: `src/Symfony/Component/Mailer/EventListener/MessageLoggerListener.php` - MessageLoggerListenerクラス定義
- E-11: `src/Symfony/Component/Mailer/EventListener/EnvelopeListener.php` - EnvelopeListenerクラス定義
- E-12: `src/Symfony/Component/Mailer/EventListener/MessageListener.php` - MessageListenerクラス定義
- E-13: `src/Symfony/Component/Mailer/EventListener/DkimSignedMessageListener.php` - DkimSignedMessageListenerクラス定義
- E-14: `src/Symfony/Component/Mailer/EventListener/SmimeSignedMessageListener.php` - SmimeSignedMessageListenerクラス定義
- E-15: `src/Symfony/Component/Mailer/EventListener/SmimeEncryptedMessageListener.php` - SmimeEncryptedMessageListenerクラス定義
- E-16: `src/Symfony/Component/Mailer/EventListener/MessengerTransportListener.php` - MessengerTransportListenerクラス定義
- E-17: `src/Symfony/Component/Mailer/Header/MetadataHeader.php` - MetadataHeaderクラス定義
- E-18: `src/Symfony/Component/Mailer/Header/TagHeader.php` - TagHeaderクラス定義
- E-19: `src/Symfony/Component/Mailer/Messenger/SendEmailMessage.php` - SendEmailMessageクラス定義
- E-20: `src/Symfony/Component/Mailer/Messenger/MessageHandler.php` - MessageHandlerクラス定義
- E-21: `src/Symfony/Component/Mailer/DataCollector/MessageDataCollector.php` - MessageDataCollectorクラス定義
- E-22: `src/Symfony/Component/Mailer/Command/MailerTestCommand.php` - MailerTestCommandクラス定義
- E-23: `src/Symfony/Component/Mailer/Transport/Dsn.php` - Dsnクラス定義
- E-24: `src/Symfony/Component/Mailer/Transport/Transports.php` - Transportsクラス定義
- E-25: `src/Symfony/Component/Mailer/Transport/NullTransport.php` - NullTransportクラス定義
- E-26: `src/Symfony/Component/Mailer/Transport/NullTransportFactory.php` - NullTransportFactoryクラス定義
- E-27: `src/Symfony/Component/Mailer/Transport/SendmailTransport.php` - SendmailTransportクラス定義
- E-28: `src/Symfony/Component/Mailer/Transport/SendmailTransportFactory.php` - SendmailTransportFactoryクラス定義
- E-29: `src/Symfony/Component/Mailer/Transport/NativeTransportFactory.php` - NativeTransportFactoryクラス定義
- E-30: `src/Symfony/Component/Mailer/Transport/RoundRobinTransport.php` - RoundRobinTransportクラス定義
- E-31: `src/Symfony/Component/Mailer/Transport/FailoverTransport.php` - FailoverTransportクラス定義
- E-32: `src/Symfony/Component/Mailer/Transport/AbstractTransport.php` - AbstractTransportクラス定義
- E-33: `src/Symfony/Component/Mailer/Transport/AbstractHttpTransport.php` - AbstractHttpTransportクラス定義
- E-34: `src/Symfony/Component/Mailer/Transport/AbstractApiTransport.php` - AbstractApiTransportクラス定義
- E-35: `src/Symfony/Component/Mailer/Transport/AbstractTransportFactory.php` - AbstractTransportFactoryクラス定義
- E-36: `src/Symfony/Component/Mailer/Transport/Smtp/SmtpTransport.php` - SmtpTransportクラス定義
- E-37: `src/Symfony/Component/Mailer/Transport/Smtp/EsmtpTransport.php` - EsmtpTransportクラス定義
- E-38: `src/Symfony/Component/Mailer/Transport/Smtp/EsmtpTransportFactory.php` - EsmtpTransportFactoryクラス定義
- E-39: `src/Symfony/Component/Mailer/Transport/Smtp/Auth/CramMd5Authenticator.php` - CramMd5Authenticatorクラス定義
- E-40: `src/Symfony/Component/Mailer/Transport/Smtp/Auth/LoginAuthenticator.php` - LoginAuthenticatorクラス定義
- E-41: `src/Symfony/Component/Mailer/Transport/Smtp/Auth/PlainAuthenticator.php` - PlainAuthenticatorクラス定義
- E-42: `src/Symfony/Component/Mailer/Transport/Smtp/Auth/XOAuth2Authenticator.php` - XOAuth2Authenticatorクラス定義
- E-43: `src/Symfony/Component/Mailer/Transport/Smtp/Stream/AbstractStream.php` - AbstractStreamクラス定義
- E-44: `src/Symfony/Component/Mailer/Transport/Smtp/Stream/SocketStream.php` - SocketStreamクラス定義
- E-45: `src/Symfony/Component/Mailer/Transport/Smtp/Stream/ProcessStream.php` - ProcessStreamクラス定義
- E-46: `src/Symfony/Component/Mailer/Exception/TransportException.php` - TransportExceptionクラス定義
- E-47: `src/Symfony/Component/Mailer/Exception/HttpTransportException.php` - HttpTransportExceptionクラス定義
- E-48: `src/Symfony/Component/Mailer/Exception/UnsupportedSchemeException.php` - UnsupportedSchemeExceptionクラス定義
- E-49: `src/Symfony/Component/Mailer/Exception/IncompleteDsnException.php` - IncompleteDsnExceptionクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Envelope.__constructが有効なsender/recipientsで生成される | E-01 (L30-34) | ○ |
| C-02 | Envelope.__constructが空recipientsでInvalidArgumentException | E-01 (L68-69) | ○ |
| C-03 | Envelope.createがMessageからDelayedEnvelopeを返す | E-01 (L36-43) | ○ |
| C-04 | Envelope.createがRawMessageでLogicExceptionをスロー | E-01 (L38-39) | ○ |
| C-05 | Envelope.setSenderがASCIIアドレスで正常動作 | E-01 (L45-52) | ○ |
| C-06 | Envelope.setSenderが非ASCIIローカルパートでInvalidArgumentException | E-01 (L48-49) | ○ |
| C-07 | Envelope.getSenderが設定済みsenderを返す | E-01 (L58-61) | ○ |
| C-08 | Envelope.setRecipientsが有効なAddress配列で正常動作 | E-01 (L66-79) | ○ |
| C-09 | Envelope.setRecipientsが空配列でInvalidArgumentException | E-01 (L68-69) | ○ |
| C-10 | Envelope.setRecipientsがAddress以外でInvalidArgumentException | E-01 (L74-75) | ○ |
| C-11 | Envelope.getRecipientsが設定済みrecipientsを返す | E-01 (L84-87) | ○ |
| C-12 | anyAddressHasUnicodeLocalpartが全ASCIIでfalse | E-01 (L104-116) | ○ |
| C-13 | anyAddressHasUnicodeLocalpartがsenderUnicodeでtrue | E-01 (L106-108) | ○ |
| C-14 | anyAddressHasUnicodeLocalpartがrecipientUnicodeでtrue | E-01 (L109-112) | ○ |
| C-15 | DelayedEnvelope.getSenderがヘッダーから取得 | E-02 (L41-48) | ○ |
| C-16 | DelayedEnvelope.getSenderが明示的設定値を返す | E-02 (L34-39, L43-47) | ○ |
| C-17 | DelayedEnvelope.getSenderがSenderヘッダー優先 | E-02 (L85-87) | ○ |
| C-18 | DelayedEnvelope.getSenderがReturn-Pathフォールバック | E-02 (L88-90) | ○ |
| C-19 | DelayedEnvelope.getSenderがヘッダー無しでLogicException | E-02 (L95) | ○ |
| C-20 | DelayedEnvelope.getRecipientsがTo/Cc/Bccから取得 | E-02 (L60-67, L69-81) | ○ |
| C-21 | DelayedEnvelope.getRecipientsが明示的設定値を返す | E-02 (L62-64) | ○ |
| C-22 | DelayedEnvelope.setRecipientsがフラグ設定 | E-02 (L50-55) | ○ |
| C-23 | Mailer.sendがbus=nullでtransport直接送信 | E-03 (L37-41) | ○ |
| C-24 | Mailer.sendがbus設定時にMessenger経由送信 | E-03 (L62) | ○ |
| C-25 | Mailer.sendがdispatcher設定時にMessageEventディスパッチ | E-03 (L44-54) | ○ |
| C-26 | Mailer.sendがreject時に送信しない | E-03 (L56-58) | ○ |
| C-27 | Mailer.sendがHandlerFailedExceptionからTransportExceptionをアンラップ | E-03 (L63-68) | ○ |
| C-28 | Mailer.sendがHandlerFailedException伝搬 | E-03 (L69) | ○ |
| C-29 | Mailer.sendがstampを伝搬 | E-03 (L54, L62) | ○ |
| C-30 | SentMessage.__constructがMessage-IDを自動生成 | E-04 (L38-45) | ○ |
| C-31 | SentMessage.__constructが既存Message-IDを使用 | E-04 (L41-44) | ○ |
| C-32 | SentMessage.__constructがRawMessageをそのまま設定 | E-04 (L46-48) | ○ |
| C-33 | SentMessage.getMessageがrawメッセージを返す | E-04 (L51-54) | ○ |
| C-34 | SentMessage.getOriginalMessageが元メッセージを返す | E-04 (L56-59) | ○ |
| C-35 | SentMessage.getEnvelopeがEnvelopeを返す | E-04 (L61-64) | ○ |
| C-36 | SentMessage.setMessageIdが設定できる | E-04 (L66-69) | ○ |
| C-37 | SentMessage.appendDebugが追記する | E-04 (L81-84) | ○ |
| C-38 | SentMessage.appendDebugが複数回連結する | E-04 (L81-84) | ○ |
| C-39 | SentMessage.toStringがraw文字列を返す | E-04 (L86-89) | ○ |
| C-40 | SentMessage.toIterableがrawイテラブルを返す | E-04 (L91-94) | ○ |
| C-41 | Transport.fromDsnがDSN文字列からTransportを生成 | E-05 (L77-82) | ○ |
| C-42 | Transport.fromDsnsが複数DSNからTransportsを生成 | E-05 (L84-89) | ○ |
| C-43 | Transport.fromStringがDSN文字列からTransportを生成 | E-05 (L109-117) | ○ |
| C-44 | Transport.fromStringが末尾余分文字でInvalidArgumentException | E-05 (L112-113) | ○ |
| C-45 | Transport.fromStringがfailoverキーワードパース | E-05 (L121-156) | ○ |
| C-46 | Transport.fromStringがroundrobinキーワードパース | E-05 (L121-156) | ○ |
| C-47 | Transport.fromStringが不正キーワードでInvalidArgumentException | E-05 (L159-161) | ○ |
| C-48 | Transport.fromStringsが名前付きDSN配列パース | E-05 (L99-107) | ○ |
| C-49 | Transport.fromDsnObjectがサポートDsnから生成 | E-05 (L171-176) | ○ |
| C-50 | Transport.fromDsnObjectが未対応DsnでUnsupportedSchemeException | E-05 (L179) | ○ |
| C-51 | Transport.fromStringがretry_periodオプション付きfailover | E-05 (L150-152) | ○ |
| C-52 | MessageEvent.__constructが正常生成 | E-06 (L32-38) | ○ |
| C-53 | MessageEvent.getMessageがメッセージを返す | E-06 (L40-43) | ○ |
| C-54 | MessageEvent.setMessageがメッセージ設定 | E-06 (L45-48) | ○ |
| C-55 | MessageEvent.getEnvelopeがEnvelopeを返す | E-06 (L50-53) | ○ |
| C-56 | MessageEvent.setEnvelopeがEnvelope設定 | E-06 (L55-58) | ○ |
| C-57 | MessageEvent.getTransportがtransport名を返す | E-06 (L60-63) | ○ |
| C-58 | MessageEvent.isQueuedがtrue | E-06 (L65-68) | ○ |
| C-59 | MessageEvent.isQueuedがfalse | E-06 (L65-68) | ○ |
| C-60 | MessageEvent.rejectがisRejectedをtrueにし伝搬停止 | E-06 (L75-79) | ○ |
| C-61 | MessageEvent.isRejectedが初期false | E-06 (L27, L70-73) | ○ |
| C-62 | MessageEvent.addStampがqueued=trueで追加 | E-06 (L81-88) | ○ |
| C-63 | MessageEvent.addStampがqueued=falseでLogicException | E-06 (L83-84) | ○ |
| C-64 | MessageEvent.getStampsがqueued=trueでstamps返却 | E-06 (L93-100) | ○ |
| C-65 | MessageEvent.getStampsがqueued=falseでLogicException | E-06 (L95-96) | ○ |
| C-66 | MessageEvents.addがイベント追加 | E-07 (L31-35) | ○ |
| C-67 | MessageEvents.getTransportsがトランスポート名一覧返却 | E-07 (L37-40) | ○ |
| C-68 | MessageEvents.getEventsがname=nullで全イベント返却 | E-07 (L45-49) | ○ |
| C-69 | MessageEvents.getEventsがnameでフィルタ | E-07 (L50-58) | ○ |
| C-70 | MessageEvents.getMessagesがname=nullで全メッセージ返却 | E-07 (L64-73) | ○ |
| C-71 | MessageEvents.getMessagesがnameでフィルタ | E-07 (L66-73) | ○ |
| C-72 | MessageEvents.getEventsが空で空配列 | E-07 (L24, L47-48) | ○ |
| C-73 | FailedMessageEvent.getMessageがメッセージ返却 | E-08 (L28-31) | ○ |
| C-74 | FailedMessageEvent.getErrorがエラー返却 | E-08 (L33-36) | ○ |
| C-75 | SentMessageEvent.getMessageがSentMessage返却 | E-09 (L26-29) | ○ |
| C-76 | MessageLoggerListener.onMessageがイベント記録 | E-10 (L38-41) | ○ |
| C-77 | MessageLoggerListener.getEventsがMessageEvents返却 | E-10 (L43-46) | ○ |
| C-78 | MessageLoggerListener.resetがイベントクリア | E-10 (L33-36) | ○ |
| C-79 | MessageLoggerListener.getSubscribedEventsが正しい設定返却 | E-10 (L48-53) | ○ |
| C-80 | EnvelopeListener.__constructがsender文字列からAddress変換 | E-11 (L43-45) | ○ |
| C-81 | EnvelopeListener.__constructがrecipients変換 | E-11 (L46-48) | ○ |
| C-82 | EnvelopeListener.onMessageがsender上書き | E-11 (L53-54) | ○ |
| C-83 | EnvelopeListener.onMessageがrecipients上書き | E-11 (L64-86) | ○ |
| C-84 | EnvelopeListener.onMessageがallowedRecipients処理 | E-11 (L66-83) | ○ |
| C-85 | EnvelopeListener.onMessageがsender=null時変更なし | E-11 (L53) | ○ |
| C-86 | EnvelopeListener.onMessageがSenderヘッダー自動追加 | E-11 (L57-60) | ○ |
| C-87 | EnvelopeListener.onMessageが重複排除 | E-11 (L73-77) | ○ |
| C-88 | MessageListener.__constructが正常生成 | E-12 (L44-52) | ○ |
| C-89 | MessageListener.addHeaderRuleが有効ルール追加 | E-12 (L54-61) | ○ |
| C-90 | MessageListener.addHeaderRuleが無効ルール(0)でInvalidArgumentException | E-12 (L56-57) | ○ |
| C-91 | MessageListener.addHeaderRuleがルール4以上でInvalidArgumentException | E-12 (L56-57) | ○ |
| C-92 | MessageListener.onMessageがRawMessageスキップ | E-12 (L66-68) | ○ |
| C-93 | MessageListener.onMessageがSET_IF_EMPTYで空ヘッダーに設定 | E-12 (L82-85, L89) | ○ |
| C-94 | MessageListener.onMessageがSET_IF_EMPTYで既存保持 | E-12 (L82, L89) | ○ |
| C-95 | MessageListener.onMessageがREPLACEで置換 | E-12 (L92-96) | ○ |
| C-96 | MessageListener.onMessageがADDで非ユニークヘッダー追加 | E-12 (L98-103) | ○ |
| C-97 | MessageListener.onMessageがADDでMailboxListHeaderアドレス追加 | E-12 (L105-113) | ○ |
| C-98 | MessageListener.onMessageがADDで非MailboxListHeaderでRuntimeException | E-12 (L106-107) | ○ |
| C-99 | MessageListener.onMessageがrenderer実行 | E-12 (L118-125) | ○ |
| C-100 | MessageListener.onMessageがrenderer=nullでスキップ | E-12 (L120-121) | ○ |
| C-101 | DkimSignedMessageListener.onMessageがDKIM署名 | E-13 (L31-38) | ○ |
| C-102 | DkimSignedMessageListener.onMessageがRawMessageスキップ | E-13 (L34-35) | ○ |
| C-103 | SmimeSignedMessageListener.onMessageがS/MIME署名 | E-14 (L31-38) | ○ |
| C-104 | SmimeSignedMessageListener.onMessageがRawMessageスキップ | E-14 (L34-35) | ○ |
| C-105 | SmimeEncryptedMessageListener.onMessageが暗号化 | E-15 (L32-56) | ○ |
| C-106 | SmimeEncryptedMessageListener.onMessageがヘッダーなしスキップ | E-15 (L38-40) | ○ |
| C-107 | SmimeEncryptedMessageListener.onMessageが証明書なしスキップ | E-15 (L44-47) | ○ |
| C-108 | SmimeEncryptedMessageListener.onMessageがRawMessageスキップ | E-15 (L35-36) | ○ |
| C-109 | SmimeEncryptedMessageListener.onMessageが空受信者スキップ | E-15 (L50-52) | ○ |
| C-110 | MessengerTransportListener.onMessageがTransportNamesStamp追加 | E-16 (L26-41) | ○ |
| C-111 | MessengerTransportListener.onMessageが非キュースキップ | E-16 (L28-30) | ○ |
| C-112 | MessengerTransportListener.onMessageがヘッダーなしスキップ | E-16 (L33-35) | ○ |
| C-113 | MessengerTransportListener.onMessageがカンマ区切りパース | E-16 (L37-38) | ○ |
| C-114 | MetadataHeader.__constructがX-Metadata-keyヘッダー生成 | E-17 (L21-26) | ○ |
| C-115 | MetadataHeader.getKeyがkey返却 | E-17 (L28-31) | ○ |
| C-116 | TagHeader.__constructがX-Tagヘッダー生成 | E-18 (L21-24) | ○ |
| C-117 | SendEmailMessage.__constructが正常生成 | E-19 (L22-26) | ○ |
| C-118 | SendEmailMessage.getMessageがメッセージ返却 | E-19 (L28-31) | ○ |
| C-119 | SendEmailMessage.getEnvelopeがEnvelope返却 | E-19 (L33-36) | ○ |
| C-120 | SendEmailMessage.getEnvelopeがnull返却 | E-19 (L24, L33-36) | ○ |
| C-121 | MessageHandler.__invokeがtransport経由送信 | E-20 (L27-30) | ○ |
| C-122 | MessageDataCollector.collectがデータ保存 | E-21 (L32-35) | ○ |
| C-123 | MessageDataCollector.getEventsがMessageEvents返却 | E-21 (L37-40) | ○ |
| C-124 | MessageDataCollector.base64EncodeがBase64エンコード | E-21 (L45-48) | ○ |
| C-125 | MessageDataCollector.resetがデータクリア | E-21 (L50-53) | ○ |
| C-126 | MessageDataCollector.getNameが'mailer'返却 | E-21 (L55-58) | ○ |
| C-127 | MailerTestCommand.executeがデフォルト送信 | E-22 (L57-72) | ○ |
| C-128 | MailerTestCommand.executeがカスタムオプション送信 | E-22 (L57-68) | ○ |
| C-129 | MailerTestCommand.executeがX-Transportヘッダー追加 | E-22 (L65-67) | ○ |
| C-130 | MailerTestCommand.executeが0返却 | E-22 (L71) | ○ |
| C-131 | Dsn.fromStringがDSN文字列パース | E-23 (L31-51) | ○ |
| C-132 | Dsn.fromStringがクエリパラメータ解析 | E-23 (L48) | ○ |
| C-133 | Dsn.fromStringがURLデコード | E-23 (L45-46) | ○ |
| C-134 | Dsn.fromStringが不正DSNでInvalidArgumentException | E-23 (L33-34) | ○ |
| C-135 | Dsn.fromStringがスキーム欠如でInvalidArgumentException | E-23 (L37-38) | ○ |
| C-136 | Dsn.fromStringがホスト欠如でInvalidArgumentException | E-23 (L41-42) | ○ |
| C-137 | Dsn.getSchemeがscheme返却 | E-23 (L53-56) | ○ |
| C-138 | Dsn.getHostがhost返却 | E-23 (L58-61) | ○ |
| C-139 | Dsn.getUserがuser返却 | E-23 (L63-66) | ○ |
| C-140 | Dsn.getUserがnull返却 | E-23 (L63-66) | ○ |
| C-141 | Dsn.getPasswordがpassword返却 | E-23 (L68-71) | ○ |
| C-142 | Dsn.getPortがport返却 | E-23 (L73-76) | ○ |
| C-143 | Dsn.getPortがデフォルト値返却 | E-23 (L73-76) | ○ |
| C-144 | Dsn.getOptionが値返却 | E-23 (L78-81) | ○ |
| C-145 | Dsn.getOptionがデフォルト値返却 | E-23 (L78-81) | ○ |
| C-146 | Dsn.getBooleanOptionがtrue返却 | E-23 (L83-86) | ○ |
| C-147 | Dsn.getBooleanOptionがfalse返却 | E-23 (L83-86) | ○ |
| C-148 | Dsn.getBooleanOptionがデフォルト返却 | E-23 (L83-86) | ○ |
| C-149 | Transports.__constructが正常生成 | E-24 (L35-45) | ○ |
| C-150 | Transports.__constructが空配列でLogicException | E-24 (L42-44) | ○ |
| C-151 | Transports.sendがデフォルトtransport使用 | E-24 (L50-51) | ○ |
| C-152 | Transports.sendがX-Transport指定transport使用 | E-24 (L54-63) | ○ |
| C-153 | Transports.sendが不正transport名でInvalidArgumentException | E-24 (L58-59) | ○ |
| C-154 | Transports.sendがX-Transportヘッダー削除 | E-24 (L56) | ○ |
| C-155 | Transports.sendが失敗時ヘッダー復元 | E-24 (L64-66) | ○ |
| C-156 | Transports.__toStringがtransport名リスト返却 | E-24 (L71-74) | ○ |
| C-157 | NullTransport.doSendが正常終了 | E-25 (L23-25) | ○ |
| C-158 | NullTransport.__toStringが'null://'返却 | E-25 (L27-30) | ○ |
| C-159 | NullTransportFactory.createがnullスキームで生成 | E-26 (L21-25) | ○ |
| C-160 | NullTransportFactory.createが未対応スキームでException | E-26 (L27) | ○ |
| C-161 | NullTransportFactory.getSupportedSchemesが['null']返却 | E-26 (L30-33) | ○ |
| C-162 | SendmailTransport.__constructがデフォルト生成 | E-27 (L52-70) | ○ |
| C-163 | SendmailTransport.__constructが-bsモード | E-27 (L65-69) | ○ |
| C-164 | SendmailTransport.__constructが-tモード | E-27 (L57-59, L65) | ○ |
| C-165 | SendmailTransport.__constructが無効フラグでInvalidArgumentException | E-27 (L57-59) | ○ |
| C-166 | SendmailTransport.__toStringが-bsモードでSmtpTransport文字列 | E-27 (L82-85) | ○ |
| C-167 | SendmailTransport.__toStringが-tモードで'smtp://sendmail' | E-27 (L87) | ○ |
| C-168 | SendmailTransportFactory.createが'sendmail'スキーム | E-28 (L21-25) | ○ |
| C-169 | SendmailTransportFactory.createが'sendmail+smtp'スキーム | E-28 (L23) | ○ |
| C-170 | SendmailTransportFactory.createが未対応スキームでException | E-28 (L27) | ○ |
| C-171 | RoundRobinTransport.__constructが正常生成 | E-30 (L38-48) | ○ |
| C-172 | RoundRobinTransport.__constructが空配列でTransportException | E-30 (L43-45) | ○ |
| C-173 | RoundRobinTransport.sendがラウンドロビン選択 | E-30 (L50-66) | ○ |
| C-174 | RoundRobinTransport.sendがフォールバック | E-30 (L54-63) | ○ |
| C-175 | RoundRobinTransport.sendが全失敗でTransportException | E-30 (L65) | ○ |
| C-176 | RoundRobinTransport.sendがdead transport復活 | E-30 (L90-93) | △ |
| C-177 | RoundRobinTransport.__toStringが文字列返却 | E-30 (L68-71) | ○ |
| C-178 | FailoverTransport.getNextTransportが最初のtransport優先 | E-31 (L23-29) | ○ |
| C-179 | FailoverTransport.getNextTransportがdead時切替 | E-31 (L25-27) | ○ |
| C-180 | FailoverTransport.getInitialCursorが0返却 | E-31 (L32-35) | ○ |
| C-181 | FailoverTransport.getNameSymbolが'failover'返却 | E-31 (L37-40) | ○ |
| C-182 | AbstractTransport.setMaxPerSecondがレート設定 | E-32 (L49-59) | ○ |
| C-183 | AbstractTransport.setMaxPerSecondがrate=0で無効化 | E-32 (L51-53) | ○ |
| C-184 | AbstractTransport.setMaxPerSecondが負値で無効化 | E-32 (L51-53) | ○ |
| C-185 | AbstractTransport.sendがdispatcher無しでdoSend直接呼出 | E-32 (L67-71) | ○ |
| C-186 | AbstractTransport.sendがdispatcher有でMessageEventディスパッチ | E-32 (L74-75) | ○ |
| C-187 | AbstractTransport.sendがreject時null返却 | E-32 (L76-78) | ○ |
| C-188 | AbstractTransport.sendが成功後SentMessageEventディスパッチ | E-32 (L98) | ○ |
| C-189 | AbstractTransport.sendが失敗時FailedMessageEventディスパッチ | E-32 (L92) | ○ |
| C-190 | AbstractTransport.sendが未レンダリングTemplatedEmailでLogicException | E-32 (L83-84) | △ |
| C-191 | AbstractHttpTransport.setHostがhost設定 | E-33 (L49-54) | ○ |
| C-192 | AbstractHttpTransport.setPortがport設定 | E-33 (L59-64) | ○ |
| C-193 | AbstractApiTransport.getRecipientsがCc/Bcc除外 | E-34 (L43-46) | ○ |
| C-194 | AbstractTransportFactory.supportsがtrue返却 | E-35 (L31-34) | ○ |
| C-195 | AbstractTransportFactory.supportsがfalse返却 | E-35 (L31-34) | ○ |
| C-196 | AbstractTransportFactory.getUserがuser返却 | E-35 (L38-41) | ○ |
| C-197 | AbstractTransportFactory.getUserがnullでIncompleteDsnException | E-35 (L40) | ○ |
| C-198 | AbstractTransportFactory.getPasswordがpassword返却 | E-35 (L43-46) | ○ |
| C-199 | AbstractTransportFactory.getPasswordがnullでIncompleteDsnException | E-35 (L45) | ○ |
| C-200 | SmtpTransport.setRestartThresholdが閾値設定 | E-36 (L67-73) | ○ |
| C-201 | SmtpTransport.setPingThresholdがping閾値設定 | E-36 (L90-95) | ○ |
| C-202 | SmtpTransport.setLocalDomainがドメイン設定 | E-36 (L109-122) | ○ |
| C-203 | SmtpTransport.setLocalDomainがIPv4括弧付与 | E-36 (L112-113) | ○ |
| C-204 | SmtpTransport.setLocalDomainがIPv6括弧付与 | E-36 (L114-115) | ○ |
| C-205 | SmtpTransport.setLocalDomainが括弧済みスキップ | E-36 (L111) | ○ |
| C-206 | SmtpTransport.getStreamがstream返却 | E-36 (L52-55) | ○ |
| C-207 | SmtpTransport.__toStringがsmtp://host:port形式 | E-36 (L162-174) | ○ |
| C-208 | SmtpTransport.__toStringがsmtps://host形式 | E-36 (L164) | ○ |
| C-209 | SmtpTransport.__serializeがBadMethodCallException | E-36 (L368-371) | ○ |
| C-210 | SmtpTransport.__unserializeがBadMethodCallException | E-36 (L373-376) | ○ |
| C-211 | SmtpTransport.parseMessageIdがID抽出 | E-36 (L156-159) | ○ |
| C-212 | SmtpTransport.parseMessageIdがID無しで空文字 | E-36 (L158) | ○ |
| C-213 | EsmtpTransport.__constructがデフォルト生成 | E-37 (L38-73) | ○ |
| C-214 | EsmtpTransport.__constructがport=465でTLS有効 | E-37 (L58-59) | ○ |
| C-215 | EsmtpTransport.setUsernameが設定 | E-37 (L78-83) | ○ |
| C-216 | EsmtpTransport.setPasswordが設定 | E-37 (L93-98) | ○ |
| C-217 | EsmtpTransport.setAutoTlsが設定 | E-37 (L108-113) | ○ |
| C-218 | EsmtpTransport.setRequireTlsが設定 | E-37 (L123-128) | ○ |
| C-219 | EsmtpTransport.setAuthenticatorsが設定 | E-37 (L135-141) | ○ |
| C-220 | EsmtpTransport.addAuthenticatorが追加 | E-37 (L143-146) | ○ |
| C-221 | EsmtpTransportFactory.createがsmtpスキーム | E-38 (L25-83) | ○ |
| C-222 | EsmtpTransportFactory.createがsmtpsスキーム | E-38 (L32) | ○ |
| C-223 | EsmtpTransportFactory.createが未対応スキームでException | E-38 (L27-29) | ○ |
| C-224 | EsmtpTransportFactory.createがDSNオプション反映 | E-38 (L36-82) | ○ |
| C-225 | CramMd5Authenticator.getAuthKeywordが'CRAM-MD5'返却 | E-39 (L24-27) | ○ |
| C-226 | LoginAuthenticator.getAuthKeywordが'LOGIN'返却 | E-40 (L22-25) | ○ |
| C-227 | PlainAuthenticator.getAuthKeywordが'PLAIN'返却 | E-41 (L22-25) | ○ |
| C-228 | XOAuth2Authenticator.getAuthKeywordが'XOAUTH2'返却 | E-42 (L24-27) | ○ |
| C-229 | AbstractStream.replaceがfrom→to置換 | E-43 (L108-142) | ○ |
| C-230 | AbstractStream.replaceが空fromでそのまま返却 | E-43 (L110-113) | ○ |
| C-231 | AbstractStream.replaceがチャンク境界置換 | E-43 (L119-137) | ○ |
| C-232 | AbstractStream.replaceが空チャンク処理 | E-43 (L120-121) | ○ |
| C-233 | AbstractStream.getDebugがデバッグ取得しクリア | E-43 (L100-106) | ○ |
| C-234 | SocketStream.setHostがhost設定 | E-44 (L54-59) | ○ |
| C-235 | SocketStream.setPortがport設定 | E-44 (L69-74) | ○ |
| C-236 | SocketStream.disableTlsがTLS無効化 | E-44 (L86-91) | ○ |
| C-237 | SocketStream.isTLSがデフォルトtrue | E-44 (L30, L93-96) | ○ |
| C-238 | SocketStream.setTimeoutが設定 | E-44 (L37-42) | ○ |
| C-239 | SocketStream.setSourceIpが設定 | E-44 (L120-125) | ○ |
| C-240 | SocketStream.setStreamOptionsが設定 | E-44 (L101-106) | ○ |
| C-241 | ProcessStream.setCommandがコマンド設定 | E-45 (L29-32) | ○ |
| C-242 | ProcessStream.setInteractiveがモード設定 | E-45 (L34-37) | ○ |
| C-243 | TransportException.appendDebugがデバッグ追記 | E-46 (L26-29) | ○ |
| C-244 | TransportException.getDebugがデバッグ返却 | E-46 (L21-24) | ○ |
| C-245 | TransportException.getDebugが初期空文字 | E-46 (L19) | ○ |
| C-246 | HttpTransportException.getResponseがResponseInterface返却 | E-47 (L30-33) | ○ |
| C-247 | UnsupportedSchemeException.__constructがインストール提案 | E-48 (L111-115) | ○ |
| C-248 | UnsupportedSchemeException.__constructが不明スキームメッセージ | E-48 (L118-123) | ○ |
| C-249 | UnsupportedSchemeException.__constructがサポートスキーム表示 | E-48 (L119-121) | ○ |
| C-250 | NativeTransportFactory.createが'native'スキーム | E-29 (L26-57) | △ |
| C-251 | NativeTransportFactory.createが未対応スキームでException | E-29 (L28-29) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-176**: RoundRobinTransportのdead transport復活テストは、microtimeに依存するタイミング制御が必要。テスト環境でのretryPeriod経過シミュレーション方法の確認が必要。
  - 候補：テスト用のClockモック / sleep使用 / retryPeriod=0設定
- **C-190**: TemplatedEmailクラスはBridge-Twigパッケージに存在するため、Component-Mailer単体テストの範囲かどうか確認が必要。
  - 候補：Bridge-Twigを開発依存として含める / インテグレーションテストとして扱う / モック使用
- **C-250**: NativeTransportFactory.createはphp.iniのsendmail_path設定に依存するため、テスト環境での前提条件確認が必要。
  - 候補：php.iniのランタイム変更 / テストスキップ条件の設定 / プロセス分離テスト
- **C-176, C-190, C-250**: これら3件は根拠となるソースコードは確認済みだが、テスト実現可能性について追加確認が推奨される。
- **AbstractStream.write / readLine / flush**: ストリームI/O操作のテストはモック化またはプロセス分離が必要だが、replaceやgetDebugなどのロジック部分はテスト可能として含めている。
- **SmtpTransport.doSend / start / stop**: SMTP接続を伴うメソッドはインテグレーションテストの領域となるが、setLocalDomain / parseMessageIdなどの純粋なロジック部分はユニットテスト対象として含めている。

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - RoundRobinTransport/FailoverTransportのタイミング依存テスト（C-176）
- **1: 中リスク** - TemplatedEmail未レンダリングチェックの依存パッケージ（C-190）
- **1: 中リスク** - NativeTransportFactoryのphp.ini依存テスト（C-250）
- **0: 低リスク** - Authenticator.authenticateメソッドはSMTP接続が必要なためテストケースからは除外し、getAuthKeywordのみカバー
- **0: 低リスク** - SocketStream.initialize / ProcessStream.initializeは外部リソース依存のため、setter/getter系のみカバー

## 6) レビュアーチェックリスト（最小）
- [ ] 全てのpublicメソッドに対してテストケースが定義されているか確認
- [ ] 正常系・異常系・境界値の観点が各クラスで適切にカバーされているか確認
- [ ] テストID（UT-MLR-xxx）が重複なく連番になっているか確認
- [ ] 対象ファイルパスがプロジェクト構造と一致しているか確認
- [ ] 優先度（高/中/低）の設定が適切か確認（金額計算・セキュリティ関連が「高」になっているか）
- [ ] SMTP接続を伴うテストケースがユニットテストの範囲として適切か確認
- [ ] TemplatedEmail関連テスト（C-190）がComponent-Mailerの範囲として妥当か確認
- [ ] php.ini依存テスト（C-250）の前提条件が実行可能か確認
