---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 245
  claims_with_evidence: 238
  claims_without_evidence: 7
confidence_derived: 0.97
---

# 根拠レポート：Component-Messenger 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：238 / 245、根拠なし：7
- 優先レビュー（高）
  1. **Worker.run()の詳細テスト（UT-MSG-045〜046）**：Workerのrun()メソッドは統合的な動作であり、単体テストではモックが必要。実際の動作フローの完全な検証は結合テストが適切な可能性あり
  2. **TraceableMessageBus.getCaller()テスト不在**：privateメソッドのgetCaller()はdebug_backtrace依存であり単体テストでの検証が困難
  3. **DependencyInjection/MessengerPass.phpのテスト不在**：コンパイラーパスは統合テストでカバーする方が適切なため除外

## 2) 参照した情報（Evidence一覧）
> 以下はソースコードファイルからの直接解析に基づく根拠です。

- E-01: `src/Symfony/Component/Messenger/Envelope.php` - Envelopeクラスの全メソッド定義
- E-02: `src/Symfony/Component/Messenger/MessageBus.php` - MessageBusクラスのdispatchロジック
- E-03: `src/Symfony/Component/Messenger/RoutableMessageBus.php` - バスルーティングロジック
- E-04: `src/Symfony/Component/Messenger/TraceableMessageBus.php` - トレース機能
- E-05: `src/Symfony/Component/Messenger/HandleTrait.php` - HandleTraitのhandle()メソッド
- E-06: `src/Symfony/Component/Messenger/WorkerMetadata.php` - ワーカーメタデータ管理
- E-07: `src/Symfony/Component/Messenger/Worker.php` - ワーカーのメッセージ処理ループ
- E-08: `src/Symfony/Component/Messenger/Middleware/HandleMessageMiddleware.php` - ハンドラ実行ミドルウェア
- E-09: `src/Symfony/Component/Messenger/Middleware/SendMessageMiddleware.php` - 送信ミドルウェア
- E-10: `src/Symfony/Component/Messenger/Middleware/StackMiddleware.php` - ミドルウェアスタック管理
- E-11: `src/Symfony/Component/Messenger/Middleware/ActivationMiddleware.php` - 有効化制御ミドルウェア
- E-12: `src/Symfony/Component/Messenger/Middleware/AddBusNameStampMiddleware.php` - バス名スタンプ追加
- E-13: `src/Symfony/Component/Messenger/Middleware/AddDefaultStampsMiddleware.php` - デフォルトスタンプ追加
- E-14: `src/Symfony/Component/Messenger/Middleware/ValidationMiddleware.php` - バリデーションミドルウェア
- E-15: `src/Symfony/Component/Messenger/Middleware/DispatchAfterCurrentBusMiddleware.php` - 遅延ディスパッチ
- E-16: `src/Symfony/Component/Messenger/Middleware/DeduplicateMiddleware.php` - 重複排除ミドルウェア
- E-17: `src/Symfony/Component/Messenger/Middleware/FailedMessageProcessingMiddleware.php` - 失敗メッセージ処理
- E-18: `src/Symfony/Component/Messenger/Middleware/RouterContextMiddleware.php` - ルーターコンテキスト復元
- E-19: `src/Symfony/Component/Messenger/Middleware/TraceableMiddleware.php` - トレーサブルミドルウェア
- E-20: `src/Symfony/Component/Messenger/Handler/HandlerDescriptor.php` - ハンドラ記述子
- E-21: `src/Symfony/Component/Messenger/Handler/HandlersLocator.php` - ハンドラ解決
- E-22: `src/Symfony/Component/Messenger/Handler/Acknowledger.php` - ACK/NACK管理
- E-23: `src/Symfony/Component/Messenger/Handler/RedispatchMessageHandler.php` - 再ディスパッチハンドラ
- E-24: `src/Symfony/Component/Messenger/Retry/MultiplierRetryStrategy.php` - リトライ戦略
- E-25: `src/Symfony/Component/Messenger/Stamp/HandledStamp.php` - ハンドル済みスタンプ
- E-26: `src/Symfony/Component/Messenger/Stamp/RedeliveryStamp.php` - 再配送スタンプ
- E-27: `src/Symfony/Component/Messenger/Stamp/ErrorDetailsStamp.php` - エラー詳細スタンプ
- E-28: `src/Symfony/Component/Messenger/Stamp/DeduplicateStamp.php` - 重複排除スタンプ
- E-29: `src/Symfony/Component/Messenger/Stamp/DelayStamp.php` - 遅延スタンプ
- E-30: `src/Symfony/Component/Messenger/Stamp/SentStamp.php` - 送信済みスタンプ
- E-31: `src/Symfony/Component/Messenger/Stamp/TransportNamesStamp.php` - トランスポート名スタンプ
- E-32: `src/Symfony/Component/Messenger/Stamp/RouterContextStamp.php` - ルーターコンテキストスタンプ
- E-33: `src/Symfony/Component/Messenger/Event/AbstractWorkerMessageEvent.php` - ワーカーイベント基底クラス
- E-34: `src/Symfony/Component/Messenger/Event/WorkerMessageFailedEvent.php` - 失敗イベント
- E-35: `src/Symfony/Component/Messenger/Event/WorkerMessageReceivedEvent.php` - 受信イベント
- E-36: `src/Symfony/Component/Messenger/Event/WorkerRunningEvent.php` - 実行中イベント
- E-37: `src/Symfony/Component/Messenger/EventListener/SendFailedMessageForRetryListener.php` - リトライリスナー
- E-38: `src/Symfony/Component/Messenger/EventListener/SendFailedMessageToFailureTransportListener.php` - 失敗トランスポートリスナー
- E-39: `src/Symfony/Component/Messenger/EventListener/StopWorkerOnMemoryLimitListener.php` - メモリ制限リスナー
- E-40: `src/Symfony/Component/Messenger/EventListener/StopWorkerOnMessageLimitListener.php` - メッセージ数制限リスナー
- E-41: `src/Symfony/Component/Messenger/EventListener/StopWorkerOnTimeLimitListener.php` - 時間制限リスナー
- E-42: `src/Symfony/Component/Messenger/EventListener/StopWorkerOnFailureLimitListener.php` - 失敗数制限リスナー
- E-43: `src/Symfony/Component/Messenger/EventListener/AddErrorDetailsStampListener.php` - エラー詳細スタンプリスナー
- E-44: `src/Symfony/Component/Messenger/EventListener/StopWorkerOnCustomStopExceptionListener.php` - カスタム停止リスナー
- E-45: `src/Symfony/Component/Messenger/EventListener/StopWorkerOnRestartSignalListener.php` - リスタートシグナルリスナー
- E-46: `src/Symfony/Component/Messenger/Transport/Sender/SendersLocator.php` - 送信者解決
- E-47: `src/Symfony/Component/Messenger/Transport/InMemory/InMemoryTransport.php` - インメモリトランスポート
- E-48: `src/Symfony/Component/Messenger/Transport/InMemory/InMemoryTransportFactory.php` - インメモリファクトリ
- E-49: `src/Symfony/Component/Messenger/Transport/Sync/SyncTransport.php` - 同期トランスポート
- E-50: `src/Symfony/Component/Messenger/Transport/Sync/SyncTransportFactory.php` - 同期ファクトリ
- E-51: `src/Symfony/Component/Messenger/Transport/TransportFactory.php` - トランスポートファクトリ
- E-52: `src/Symfony/Component/Messenger/Transport/Receiver/SingleMessageReceiver.php` - 単一メッセージレシーバー
- E-53: `src/Symfony/Component/Messenger/Transport/Serialization/PhpSerializer.php` - PHPシリアライザ
- E-54: `src/Symfony/Component/Messenger/Transport/Serialization/Serializer.php` - Serializerコンポーネント連携
- E-55: `src/Symfony/Component/Messenger/Transport/Serialization/SigningSerializer.php` - 署名シリアライザ
- E-56: `src/Symfony/Component/Messenger/Transport/Serialization/Normalizer/FlattenExceptionNormalizer.php` - FlattenException正規化
- E-57: `src/Symfony/Component/Messenger/DataCollector/MessengerDataCollector.php` - データコレクター
- E-58: `src/Symfony/Component/Messenger/Exception/HandlerFailedException.php` - ハンドラ失敗例外
- E-59: `src/Symfony/Component/Messenger/Exception/ValidationFailedException.php` - バリデーション失敗例外
- E-60: `src/Symfony/Component/Messenger/Exception/DelayedMessageHandlingException.php` - 遅延ハンドリング例外
- E-61: `src/Symfony/Component/Messenger/Message/RedispatchMessage.php` - 再ディスパッチメッセージ
- E-62: `src/Symfony/Component/Messenger/Attribute/AsMessage.php` - AsMessage属性
- E-63: `src/Symfony/Component/Messenger/Attribute/AsMessageHandler.php` - AsMessageHandler属性

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Envelope.__construct: メッセージとスタンプで初期化 | E-01 (L32-39) | ○ |
| C-02 | Envelope.wrap: オブジェクトのラップとEnvelope再利用 | E-01 (L46-51) | ○ |
| C-03 | Envelope.with: イミュータブルなスタンプ追加 | E-01 (L56-65) | ○ |
| C-04 | Envelope.withoutAll: 指定クラスのスタンプ全除去 | E-01 (L70-77) | ○ |
| C-05 | Envelope.withoutStampsOfType: 型指定でのスタンプ除去 | E-01 (L82-93) | ○ |
| C-06 | Envelope.last: 最後のスタンプ取得 | E-01 (L102-105) | ○ |
| C-07 | Envelope.all: スタンプ一覧取得 | E-01 (L116-123) | ○ |
| C-08 | MessageBus.dispatch: ミドルウェアチェーン実行 | E-02 (L54-70) | ○ |
| C-09 | RoutableMessageBus.dispatch: BusNameStampによるルーティング | E-03 (L34-51) | ○ |
| C-10 | RoutableMessageBus: Envelope以外拒否 | E-03 (L36-37) | ○ |
| C-11 | RoutableMessageBus: フォールバックバス動作 | E-03 (L43-48) | ○ |
| C-12 | TraceableMessageBus: メッセージトレース記録 | E-04 (L27-49) | ○ |
| C-13 | TraceableMessageBus: disabled時のスキップ | E-04 (L29-31) | ○ |
| C-14 | HandleTrait.handle: 単一ハンドラ結果返却 | E-05 (L36-57) | ○ |
| C-15 | HandleTrait: messageBus未初期化例外 | E-05 (L38-39) | ○ |
| C-16 | HandleTrait: 0件/複数ハンドラ例外 | E-05 (L46-53) | ○ |
| C-17 | WorkerMetadata: メタデータ管理 | E-06 (L17-45) | ○ |
| C-18 | Worker.stop: 停止フラグ設定 | E-07 (L295-300) | ○ |
| C-19 | Worker.run: QueueReceiverInterface検証 | E-07 (L92-98) | ○ |
| C-20 | HandleMessageMiddleware: ハンドラ実行とHandledStamp追加 | E-08 (L44-125) | ○ |
| C-21 | HandleMessageMiddleware: NoHandlerForMessageException | E-08 (L112-114) | ○ |
| C-22 | HandleMessageMiddleware: HandlerFailedException | E-08 (L120-122) | ○ |
| C-23 | SendMessageMiddleware: 送信とSentStamp追加 | E-09 (L40-83) | ○ |
| C-24 | SendMessageMiddleware: ReceivedStamp時のスキップ | E-09 (L48-52) | ○ |
| C-25 | StackMiddleware: ミドルウェアスタック管理 | E-10 (L19-61) | ○ |
| C-26 | ActivationMiddleware: 有効化/無効化制御 | E-11 (L21-39) | ○ |
| C-27 | AddBusNameStampMiddleware: BusNameStamp追加 | E-12 (L22-37) | ○ |
| C-28 | AddDefaultStampsMiddleware: デフォルトスタンプ追加 | E-13 (L20-35) | ○ |
| C-29 | ValidationMiddleware: バリデーション実行 | E-14 (L22-45) | ○ |
| C-30 | DispatchAfterCurrentBusMiddleware: 遅延ディスパッチ | E-15 (L31-105) | ○ |
| C-31 | DeduplicateMiddleware: ロックによる重複排除 | E-16 (L19-51) | ○ |
| C-32 | FailedMessageProcessingMiddleware: 失敗メッセージ再処理 | E-17 (L21-36) | ○ |
| C-33 | RouterContextMiddleware: コンテキスト復元 | E-18 (L24-85) | ○ |
| C-34 | TraceableMiddleware: Stopwatch計測 | E-19 (L22-41) | ○ |
| C-35 | HandlerDescriptor: ハンドラ情報管理 | E-20 (L19-81) | ○ |
| C-36 | HandlersLocator: 型階層に基づくハンドラ解決 | E-21 (L23-97) | ○ |
| C-37 | HandlersLocator: ワイルドカード解決 | E-21 (L66-70) | ○ |
| C-38 | HandlersLocator: from_transportフィルタ | E-21 (L85-96) | ○ |
| C-39 | Acknowledger: ACK/NACK/二重防止 | E-22 (L19-79) | ○ |
| C-40 | Acknowledger: 未ACKデストラクタ例外 | E-22 (L63-67) | ○ |
| C-41 | RedispatchMessageHandler: 再ディスパッチ | E-23 (L19-32) | ○ |
| C-42 | MultiplierRetryStrategy: コンストラクタバリデーション | E-24 (L42-64) | ○ |
| C-43 | MultiplierRetryStrategy: isRetryable判定 | E-24 (L69-74) | ○ |
| C-44 | MultiplierRetryStrategy: getWaitingTime計算 | E-24 (L79-95) | ○ |
| C-45 | Stamp各クラス: プロパティ取得 | E-25〜E-32 | ○ |
| C-46 | RedeliveryStamp.getRetryCountFromEnvelope: 静的メソッド | E-26 (L31-37) | ○ |
| C-47 | ErrorDetailsStamp.create: ファクトリメソッド | E-27 (L30-42) | ○ |
| C-48 | ErrorDetailsStamp.equals: 等価比較 | E-27 (L64-79) | ○ |
| C-49 | DelayStamp.delayFor/delayUntil: 静的ファクトリ | E-29 (L34-45) | ○ |
| C-50 | Event各クラス: プロパティ管理 | E-33〜E-36 | ○ |
| C-51 | WorkerMessageReceivedEvent.shouldHandle: 処理制御 | E-35 (L21-30) | ○ |
| C-52 | SendFailedMessageForRetryListener: リトライ送信ロジック | E-37 (L47-83) | ○ |
| C-53 | SendFailedMessageForRetryListener: Recoverable/Unrecoverable判定 | E-37 (L117-147) | ○ |
| C-54 | SendFailedMessageToFailureTransportListener: 失敗トランスポート送信 | E-38 (L36-67) | ○ |
| C-55 | StopWorkerOn*Listeners: 各種制限リスナー | E-39〜E-42 | ○ |
| C-56 | AddErrorDetailsStampListener: エラースタンプ追加と重複防止 | E-43 (L20-29) | ○ |
| C-57 | StopWorkerOnCustomStopExceptionListener: カスタム停止 | E-44 (L23-57) | ○ |
| C-58 | StopWorkerOnRestartSignalListener: リスタートシグナル | E-45 (L23-67) | ○ |
| C-59 | SendersLocator: 送信者解決とTransportNamesStamp対応 | E-46 (L26-106) | ○ |
| C-60 | InMemoryTransport: インメモリ送受信管理 | E-47 (L28-162) | ○ |
| C-61 | InMemoryTransportFactory: ファクトリとDSN解析 | E-48 (L25-67) | ○ |
| C-62 | SyncTransport: 同期送信とget/ack/reject禁止 | E-49 (L26-58) | ○ |
| C-63 | SyncTransportFactory: sync://サポート | E-50 (L24-40) | ○ |
| C-64 | TransportFactory: ファクトリ委譲と未サポートDSN例外 | E-51 (L22-110) | ○ |
| C-65 | SingleMessageReceiver: 単一メッセージ配信 | E-52 (L23-53) | ○ |
| C-66 | PhpSerializer: encode/decode | E-53 (L22-123) | ○ |
| C-67 | Serializer: JSON encode/decode | E-54 (L36-230) | ○ |
| C-68 | SigningSerializer: 署名付きencode/decode | E-55 (L20-86) | ○ |
| C-69 | FlattenExceptionNormalizer: normalize/denormalize | E-56 (L25-88) | ○ |
| C-70 | MessengerDataCollector: データ収集 | E-57 (L26-132) | ○ |
| C-71 | HandlerFailedException: 例外メッセージ生成 | E-58 (L16-47) | ○ |
| C-72 | ValidationFailedException: 違反情報保持 | E-59 (L20-43) | ○ |
| C-73 | DelayedMessageHandlingException: 遅延例外集約 | E-60 (L22-46) | ○ |
| C-74 | RedispatchMessage: 再ディスパッチメッセージ | E-61 (L16-34) | ○ |
| C-75 | Worker.run()の詳細動作フロー | E-07 | △ |
| C-76 | Worker.handleMessage()のフル統合動作 | E-07 | △ |
| C-77 | Worker.flush()のバッチ処理フロー | E-07 | △ |
| C-78 | Worker.rateLimit()の詳細動作 | E-07 | △ |
| C-79 | Worker.keepalive()の正常系フルフロー | E-07 | △ |
| C-80 | Commandクラス群のテスト（CLI統合） | **根拠なし** | △ |
| C-81 | DependencyInjection/MessengerPassのテスト | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **Commandクラス群（9ファイル）のテスト**：ConsumeMessagesCommand, DebugCommand, FailedMessagesRemoveCommand, FailedMessagesRetryCommand, FailedMessagesShowCommand, SetupTransportsCommand, StatsCommand, StopWorkersCommand はSymfony Console Commandであり、execute()メソッドの単体テストはConsole Testerを使った統合テスト的なアプローチが一般的。ただし、入力バリデーションやオプション定義のテストは単体テスト対象となりうる。
  - 候補：コマンド定義のテスト / configure()のテスト / 入力パラメータバリデーション
- **DependencyInjection/MessengerPass.php**：コンパイラーパスはContainerBuilderを使った統合テストでカバーされるのが一般的。
  - 候補：process()メソッドのテスト / タグ付きサービス解決のテスト
- **Worker.run()の完全な動作フロー**：Worker.run()はイベントループであり、モックの組み合わせが複雑。privateメソッド（handleMessage, ack, flush, rateLimit）は直接テスト不可であり、run()を通じた統合的テストが必要。
  - 候補：イベントディスパッチの検証 / メッセージ処理フローの検証

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - Envelope, Stamp各クラス, Event各クラス, WorkerMetadata: シンプルなデータクラスであり、テストケースの正確性は高い
- **0: 低リスク** - HandlerDescriptor, HandlersLocator, Acknowledger: ロジックが明確でソースコードから直接根拠を得られる
- **1: 中リスク** - Middleware各クラス: StackInterface/MiddlewareInterfaceのモック設計が必要であり、テストケースの前提条件が適切か要確認
- **1: 中リスク** - EventListener各クラス: イベント駆動の動作であり、イベントオブジェクトのモック設計が適切か要確認
- **1: 中リスク** - Transport/Serialization: encode/decodeの対称性テストや、エラーハンドリングの網羅性を要確認
- **2: 高リスク** - Worker.run(): ループ処理のテストは複雑で、テストケースが実際の動作を正確に反映しているか要検証。Commandクラス群とMessengerPassは対象外としたが、プロジェクト方針によっては追加が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの優先度（高/中/低）がビジネスリスクと一致しているか
- [ ] 正常系/異常系/境界値の観点が各クラスで網羅されているか
- [ ] MultiplierRetryStrategyのgetWaitingTime()でjitter込みのテストが十分か（ランダム性の検証方法）
- [ ] SigningSerializerのセキュリティ関連テスト（署名検証、アルゴリズム不一致）が十分か
- [ ] Worker関連のテストケースが単体テストとして実現可能な粒度であるか（統合テストとの境界）
- [ ] Commandクラス群（9ファイル）を単体テスト対象に含めるべきか判断
- [ ] DependencyInjection/MessengerPassを単体テスト対象に含めるべきか判断
- [ ] HandleMessageMiddlewareのバッチハンドラ対応テスト（UT-MSG-052）の前提条件が現実的か
- [ ] DispatchAfterCurrentBusMiddlewareのキュー処理テスト（UT-MSG-072〜074）の並行動作の検証が十分か
