---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 270
  claims_with_evidence: 262
  claims_without_evidence: 8
confidence_derived: 0.97
---

# 根拠レポート：Component-Mime 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：262 / 270、根拠なし：8
- 優先レビュー（高）
  1. **UT-MIM-239（DkimSigner::sign 正常系）**：DKIM署名の完全な動作確認は秘密鍵の生成が必要で、外部依存がある
  2. **UT-MIM-247（SMimeSigner::sign 正常系）**：S/MIME署名の動作は証明書ファイルが必要で、テスト環境構築が複雑
  3. **UT-MIM-249（SMimeEncrypter::encrypt 正常系）**：S/MIME暗号化も同様に証明書ファイルが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Mime/Address.php` - Addressクラスの実装
- E-02: `src/Symfony/Component/Mime/RawMessage.php` - RawMessageクラスの実装
- E-03: `src/Symfony/Component/Mime/Message.php` - Messageクラスの実装
- E-04: `src/Symfony/Component/Mime/Email.php` - Emailクラスの実装
- E-05: `src/Symfony/Component/Mime/DraftEmail.php` - DraftEmailクラスの実装
- E-06: `src/Symfony/Component/Mime/Header/Headers.php` - Headersコレクションクラスの実装
- E-07: `src/Symfony/Component/Mime/Header/AbstractHeader.php` - 抽象ヘッダークラスの実装
- E-08: `src/Symfony/Component/Mime/Header/DateHeader.php` - DateHeaderの実装
- E-09: `src/Symfony/Component/Mime/Header/IdentificationHeader.php` - IdentificationHeaderの実装
- E-10: `src/Symfony/Component/Mime/Header/MailboxHeader.php` - MailboxHeaderの実装
- E-11: `src/Symfony/Component/Mime/Header/MailboxListHeader.php` - MailboxListHeaderの実装
- E-12: `src/Symfony/Component/Mime/Header/PathHeader.php` - PathHeaderの実装
- E-13: `src/Symfony/Component/Mime/Header/UnstructuredHeader.php` - UnstructuredHeaderの実装
- E-14: `src/Symfony/Component/Mime/Header/ParameterizedHeader.php` - ParameterizedHeaderの実装
- E-15: `src/Symfony/Component/Mime/Part/AbstractPart.php` - 抽象パートクラスの実装
- E-16: `src/Symfony/Component/Mime/Part/TextPart.php` - TextPartの実装
- E-17: `src/Symfony/Component/Mime/Part/DataPart.php` - DataPartの実装
- E-18: `src/Symfony/Component/Mime/Part/File.php` - Fileクラスの実装
- E-19: `src/Symfony/Component/Mime/Part/AbstractMultipartPart.php` - AbstractMultipartPartの実装
- E-20: `src/Symfony/Component/Mime/Part/Multipart/FormDataPart.php` - FormDataPartの実装
- E-21: `src/Symfony/Component/Mime/Part/Multipart/RelatedPart.php` - RelatedPartの実装
- E-22: `src/Symfony/Component/Mime/Part/MessagePart.php` - MessagePartの実装
- E-23: `src/Symfony/Component/Mime/Part/SMimePart.php` - SMimePartの実装
- E-24: `src/Symfony/Component/Mime/MimeTypes.php` - MimeTypesクラスの実装
- E-25: `src/Symfony/Component/Mime/FileinfoMimeTypeGuesser.php` - FileinfoMimeTypeGuesserの実装
- E-26: `src/Symfony/Component/Mime/FileBinaryMimeTypeGuesser.php` - FileBinaryMimeTypeGuesserの実装
- E-27: `src/Symfony/Component/Mime/MessageConverter.php` - MessageConverterの実装
- E-28: `src/Symfony/Component/Mime/Encoder/IdnAddressEncoder.php` - IdnAddressEncoderの実装
- E-29: `src/Symfony/Component/Mime/Encoder/QpEncoder.php` - QpEncoderの実装
- E-30: `src/Symfony/Component/Mime/Crypto/DkimSigner.php` - DkimSignerの実装
- E-31: `src/Symfony/Component/Mime/Crypto/DkimOptions.php` - DkimOptionsの実装
- E-32: `src/Symfony/Component/Mime/Crypto/SMimeSigner.php` - SMimeSignerの実装
- E-33: `src/Symfony/Component/Mime/Crypto/SMimeEncrypter.php` - SMimeEncrypterの実装
- E-34: `src/Symfony/Component/Mime/Crypto/SMime.php` - SMime抽象クラスの実装
- E-35: `src/Symfony/Component/Mime/HtmlToTextConverter/DefaultHtmlToTextConverter.php` - DefaultHtmlToTextConverterの実装
- E-36: `src/Symfony/Component/Mime/DependencyInjection/AddMimeTypeGuesserPass.php` - CompilerPassの実装
- E-37: `src/Symfony/Component/Mime/CharacterStream.php` - CharacterStreamの実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Address::__construct - 有効なメールアドレスで生成可能 | E-01 (L42-56) | ○ |
| C-02 | Address::__construct - 名前なしでデフォルト空文字 | E-01 (L42) | ○ |
| C-03 | Address::__construct - アドレスのtrim処理 | E-01 (L50) | ○ |
| C-04 | Address::__construct - 改行文字除去 | E-01 (L51) | ○ |
| C-05 | Address::__construct - 不正アドレスでRfcComplianceException | E-01 (L53-55) | ○ |
| C-06 | Address::__construct - EmailValidator未存在でLogicException | E-01 (L44-46) | ○ |
| C-07 | Address::create - Addressインスタンスがそのまま返却 | E-01 (L91-93) | ○ |
| C-08 | Address::create - 文字列からAddress生成 | E-01 (L95-97) | ○ |
| C-09 | Address::create - 名前付き文字列パース | E-01 (L99-103) | ○ |
| C-10 | Address::create - パース不能文字列でInvalidArgumentException | E-01 (L99-101) | ○ |
| C-11 | Address::hasUnicodeLocalpart - ASCII判定 | E-01 (L138) | ○ |
| C-12 | RawMessage::toString - 文字列メッセージ返却 | E-02 (L40-41) | ○ |
| C-13 | RawMessage::toString - リソース変換 | E-02 (L44-45) | ○ |
| C-14 | RawMessage::toString - iterable結合 | E-02 (L48-53) | ○ |
| C-15 | RawMessage::toIterable - Generator閉じ後にLogicException | E-02 (L58-59) | ○ |
| C-16 | Message::getPreparedHeaders - From/Senderなし時LogicException | E-03 (L76-81) | ○ |
| C-17 | Message::getPreparedHeaders - Bcc除去 | E-03 (L101) | ○ |
| C-18 | Message::getPreparedHeaders - 複数From時Sender自動設定 | E-03 (L92-94) | ○ |
| C-19 | Message::ensureValidity - To/Cc/Bccなし時LogicException | E-03 (L127-129) | ○ |
| C-20 | Message::ensureValidity - From/Senderなし時LogicException | E-03 (L131-133) | ○ |
| C-21 | Email::from - 引数なし時LogicException | E-04 (L123-125) | ○ |
| C-22 | Email::priority - 上限丸め(>5→5) | E-04 (L243-244) | ○ |
| C-23 | Email::priority - 下限丸め(<1→1) | E-04 (L245-246) | ○ |
| C-24 | Email::getPriority - デフォルト3 | E-04 (L260-261) | ○ |
| C-25 | Email::text - 不正型でTypeError | E-04 (L272-273) | ○ |
| C-26 | Email::ensureValidity - ボディなし時LogicException | E-04 (L403-406) | ○ |
| C-27 | Email::ensureValidity - Draft送信防止 | E-04 (L395-397) | ○ |
| C-28 | Email::getBody - CIDインライン画像のRelatedPart生成 | E-04 (L463-510) | ○ |
| C-29 | Headers::add - ユニークヘッダー重複防止 | E-06 (L172-173) | ○ |
| C-30 | Headers::add - ヘッダークラス検証 | E-06 (L167, L226-244) | ○ |
| C-31 | Headers::getHeaderParameter - 非ParameterizedHeaderでLogicException | E-06 (L293-295) | ○ |
| C-32 | Headers::setHeaderParameter - 不存在ヘッダーでLogicException | E-06 (L305-306) | ○ |
| C-33 | TextPart::__construct - 不正型でTypeError | E-16 (L46-48) | ○ |
| C-34 | TextPart::__construct - 不正エンコーディングでInvalidArgumentException | E-16 (L65-66) | ○ |
| C-35 | TextPart::addEncoder - デフォルトエンコーダ保護 | E-16 (L222-224) | ○ |
| C-36 | DataPart::setContentId - @なしCIDでInvalidArgumentException | E-17 (L65-67) | ○ |
| C-37 | DataPart::getContentId - 自動生成CID | E-17 (L76-77, L124-127) | ○ |
| C-38 | FormDataPart::getParts - 不正値型でInvalidArgumentException | E-20 (L69-71) | ○ |
| C-39 | FormDataPart::getParts - 整数キー配列検証 | E-20 (L52-55) | ○ |
| C-40 | MessageConverter::toEmail - 複雑ボディでRuntimeException | E-27 (L58, L64) | ○ |
| C-41 | DkimSigner::sign - DKIM署名の完全動作 | E-30 (L61-128) | △ |
| C-42 | DkimSigner::sign - 不正アルゴリズム検証 | E-30 (L64-66) | ○ |
| C-43 | SMimeSigner::sign - S/MIME署名動作 | E-32 (L52-64) | △ |
| C-44 | SMimeEncrypter::encrypt - S/MIME暗号化動作 | E-33 (L44-62) | △ |
| C-45 | SMime::normalizeFilePath - 不存在ファイルでRuntimeException | E-34 (L26-28) | ○ |
| C-46 | FileinfoMimeTypeGuesser::guessMimeType - 不存在ファイルでInvalidArgumentException | E-25 (L47-49) | ○ |
| C-47 | FileBinaryMimeTypeGuesser::guessMimeType - 不存在ファイルでInvalidArgumentException | E-26 (L58-59) | ○ |
| C-48 | IdnAddressEncoder::encodeString - IDNエンコード | E-28 (L32-39) | ○ |
| C-49 | DefaultHtmlToTextConverter::convert - head/style除去 | E-35 (L19-21) | ○ |
| C-50 | RelatedPart - CID自動付与 | E-21 (L47-53) | ○ |
| C-51 | DkimSigner::__construct - openssl未ロード時LogicException | E-30 (L46-48) | ○ |
| C-52 | SMimeSigner::__construct - openssl未ロード時LogicException | E-32 (L36-38) | ○ |
| C-53 | SMimeEncrypter::__construct - openssl未ロード時LogicException | E-33 (L32-34) | ○ |
| C-54 | IdentificationHeader::setIds - 不正IDでRfcComplianceException | E-09 (L82-84) | △ |
| C-55 | FileBinaryMimeTypeGuesser::isGuesserSupported - Windows非サポート | E-26 (L45-46) | △ |
| C-56 | MimeTypes::guessMimeType - Guesser未サポート時LogicException | E-24 (L128-130) | ○ |
| C-57 | CharacterStream - UTF-8マルチバイト処理 | E-37 (L167-210) | ○ |
| C-58 | Address::getEncodedName - ダブルクォートエスケープ | E-01 (L86) | ○ |
| C-59 | QpEncoder::encodeString - 行折り返し | E-29 (L115-157) | ○ |
| C-60 | DkimSigner::__construct - 無効秘密鍵でInvalidArgumentException | E-30 (L49) | △ |
| C-61 | AddMimeTypeGuesserPass::process - タグ付きサービス登録 | E-36 (L26-32) | ○ |
| C-62 | MimeTypes - 大文字小文字無視 | E-24 (L84, L93) | ○ |
| C-63 | Email::getBody - キャッシュ機構 | E-04 (L431-433) | △ |
| C-64 | DraftEmail::getPreparedHeaders - From/Date不要の緩和 | E-05 (L33-43) | ○ |
| C-65 | File::getContentType - 不明拡張子フォールバック | E-18 (L39) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-41, C-43, C-44（暗号化/署名の完全動作テスト）**：実際の秘密鍵/証明書ファイルが必要。テスト実行にはフィクスチャとして適切なテスト用鍵/証明書を準備する必要がある。
  - 候補：既存テストのフィクスチャ / テスト用自己署名証明書の生成 / モックの利用
- **C-54（IdentificationHeader不正ID検証）**：RFC準拠チェックはAddress内部のEmailValidatorに委譲されているため、具体的にどの不正IDパターンでRfcComplianceExceptionが発生するかはEmailValidatorの実装依存。
  - 候補：egulias/email-validatorのドキュメント / RFCの仕様確認
- **C-55（Windows環境でのFileBinaryMimeTypeGuesser非サポート）**：実行環境依存のテスト。CIでWindowsランナーを使用する場合のみ検証可能。
  - 候補：CIのマルチOS対応 / DIRECTORY_SEPARATORのモック
- **C-60（無効秘密鍵のInvalidArgumentException）**：openssl_pkey_get_privateの振る舞いに依存。PHP/OpenSSLバージョンによって挙動が異なる可能性がある。
  - 候補：PHP公式ドキュメント / OpenSSLバージョン別の動作確認
- **C-63（Email::getBody のキャッシュ機構）**：cachedBodyプロパティは内部実装の詳細であり、外部からのテストでは直接検証が困難。text/html/attachments変更時のキャッシュクリアが正しく行われることの間接的テストが必要。
  - 候補：text()→getBody()→html()→getBody()の連続呼び出しで異なるbodyが返ることを確認
- **C-65（File::getContentType の不明拡張子フォールバック）**：MimeTypes::MAP定数に含まれない拡張子の特定が必要。テスト時には確実に存在しない拡張子を使用する必要がある。
  - 候補：'.xyz999'等の明らかに存在しない拡張子 / MimeTypes::MAPの確認

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**：暗号化/署名関連のテスト（UT-MIM-236～249）はOpenSSL拡張とテスト用鍵/証明書が必要。テスト環境でのセットアップを要確認。
- **0（低リスク）**：大部分のテストケースはソースコードから直接導出可能であり、入力値・期待結果の根拠が明確。
- **1（中リスク）**：FileBinaryMimeTypeGuesserのテスト（UT-MIM-218～221）はOS依存。Unix系でないCIでは一部テストがスキップされる可能性がある。
- **0（低リスク）**：ヘッダー関連テスト（UT-MIM-089～139）はRFC準拠が根拠。RFC 2822/2047/2231の仕様に基づく。

## 6) レビュアーチェックリスト（最小）
- [ ] 暗号化/署名テスト（UT-MIM-236～249）に必要なテスト用鍵/証明書のフィクスチャが準備されているか確認
- [ ] Email::getBodyのボディ生成テスト（UT-MIM-076～080）でmultipart構造のバリエーションが十分か確認
- [ ] IdentificationHeader::setIds（UT-MIM-122）の不正IDパターンがEmailValidatorの実装と整合しているか確認
- [ ] OS依存テスト（FileBinaryMimeTypeGuesser）がCI環境で適切にスキップ/実行されるか確認
- [ ] FormDataPartのネスト配列展開（UT-MIM-185）が深いネストやエッジケースを十分カバーしているか確認
- [ ] CharacterStreamのマルチバイト処理（UT-MIM-257～265）で壊れたUTF-8シーケンスのテストが必要か検討
- [ ] テストケース数（270件）の網羅性がプロジェクトの品質基準を満たしているか確認
