---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 227
  claims_with_evidence: 224
  claims_without_evidence: 3
confidence_derived: 0.99
---

# 根拠レポート：Component-Notifier 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：224 / 227、根拠なし：3
- 優先レビュー（高）
  1. **C-083 RoundRobinTransport retryPeriod復帰テスト**：タイミングに依存するため実装の正確な検証が困難
  2. **C-218 UnsupportedSchemeException パッケージ案内**：Bridge クラスの存在有無に依存するため環境依存
  3. **C-012/C-013/C-014 Notifier getChannel**：privateメソッドのため直接テスト不可、間接的なテストが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Notifier/Notifier.php` - Notifierクラス本体
- E-02: `src/Symfony/Component/Notifier/Chatter.php` - Chatterクラス本体
- E-03: `src/Symfony/Component/Notifier/Texter.php` - Texterクラス本体
- E-04: `src/Symfony/Component/Notifier/Transport.php` - Transportファクトリクラス本体
- E-05: `src/Symfony/Component/Notifier/Transport/Dsn.php` - DSNパーサークラス
- E-06: `src/Symfony/Component/Notifier/Transport/Transports.php` - 複数トランスポート管理
- E-07: `src/Symfony/Component/Notifier/Transport/NullTransport.php` - Nullトランスポート
- E-08: `src/Symfony/Component/Notifier/Transport/NullTransportFactory.php` - Nullトランスポートファクトリ
- E-09: `src/Symfony/Component/Notifier/Transport/AbstractTransportFactory.php` - 抽象トランスポートファクトリ
- E-10: `src/Symfony/Component/Notifier/Transport/AbstractTransport.php` - 抽象トランスポート
- E-11: `src/Symfony/Component/Notifier/Transport/RoundRobinTransport.php` - ラウンドロビントランスポート
- E-12: `src/Symfony/Component/Notifier/Transport/FailoverTransport.php` - フェイルオーバートランスポート
- E-13: `src/Symfony/Component/Notifier/Notification/Notification.php` - 通知クラス
- E-14: `src/Symfony/Component/Notifier/Message/ChatMessage.php` - チャットメッセージ
- E-15: `src/Symfony/Component/Notifier/Message/SmsMessage.php` - SMSメッセージ
- E-16: `src/Symfony/Component/Notifier/Message/EmailMessage.php` - メールメッセージ
- E-17: `src/Symfony/Component/Notifier/Message/PushMessage.php` - プッシュメッセージ
- E-18: `src/Symfony/Component/Notifier/Message/DesktopMessage.php` - デスクトップメッセージ
- E-19: `src/Symfony/Component/Notifier/Message/SentMessage.php` - 送信済みメッセージ
- E-20: `src/Symfony/Component/Notifier/Message/NullMessage.php` - Nullメッセージ
- E-21: `src/Symfony/Component/Notifier/Channel/ChannelPolicy.php` - チャネルポリシー
- E-22: `src/Symfony/Component/Notifier/Channel/AbstractChannel.php` - 抽象チャネル
- E-23: `src/Symfony/Component/Notifier/Channel/ChatChannel.php` - チャットチャネル
- E-24: `src/Symfony/Component/Notifier/Channel/SmsChannel.php` - SMSチャネル
- E-25: `src/Symfony/Component/Notifier/Channel/EmailChannel.php` - メールチャネル
- E-26: `src/Symfony/Component/Notifier/Channel/BrowserChannel.php` - ブラウザチャネル
- E-27: `src/Symfony/Component/Notifier/Channel/PushChannel.php` - プッシュチャネル
- E-28: `src/Symfony/Component/Notifier/Channel/DesktopChannel.php` - デスクトップチャネル
- E-29: `src/Symfony/Component/Notifier/Event/MessageEvent.php` - メッセージイベント
- E-30: `src/Symfony/Component/Notifier/Event/SentMessageEvent.php` - 送信済みメッセージイベント
- E-31: `src/Symfony/Component/Notifier/Event/FailedMessageEvent.php` - 失敗メッセージイベント
- E-32: `src/Symfony/Component/Notifier/Event/NotificationEvents.php` - 通知イベントコレクション
- E-33: `src/Symfony/Component/Notifier/EventListener/NotificationLoggerListener.php` - 通知ロガーリスナー
- E-34: `src/Symfony/Component/Notifier/EventListener/SendFailedMessageToNotifierListener.php` - 失敗メッセージ通知リスナー
- E-35: `src/Symfony/Component/Notifier/Recipient/Recipient.php` - 受信者クラス
- E-36: `src/Symfony/Component/Notifier/Recipient/NoRecipient.php` - 受信者なしクラス
- E-37: `src/Symfony/Component/Notifier/FlashMessage/AbstractFlashMessageImportanceMapper.php` - 抽象フラッシュメッセージマッパー
- E-38: `src/Symfony/Component/Notifier/FlashMessage/DefaultFlashMessageImportanceMapper.php` - デフォルトフラッシュメッセージマッパー
- E-39: `src/Symfony/Component/Notifier/FlashMessage/BootstrapFlashMessageImportanceMapper.php` - Bootstrapフラッシュメッセージマッパー
- E-40: `src/Symfony/Component/Notifier/DataCollector/NotificationDataCollector.php` - データコレクター
- E-41: `src/Symfony/Component/Notifier/Messenger/MessageHandler.php` - メッセンジャーハンドラ
- E-42: `src/Symfony/Component/Notifier/Exception/UnsupportedSchemeException.php` - 未サポートスキーム例外
- E-43: `src/Symfony/Component/Notifier/Exception/IncompleteDsnException.php` - 不完全DSN例外
- E-44: `src/Symfony/Component/Notifier/Exception/FlashMessageImportanceMapperException.php` - フラッシュメッセージマッパー例外
- E-45: `src/Symfony/Component/Notifier/Exception/MissingRequiredOptionException.php` - 必須オプション欠落例外
- E-46: `src/Symfony/Component/Notifier/Exception/UnsupportedOptionsException.php` - 未サポートオプション例外
- E-47: `src/Symfony/Component/Notifier/Exception/UnsupportedMessageTypeException.php` - 未サポートメッセージ型例外
- E-48: `src/Symfony/Component/Notifier/Exception/MultipleExclusiveOptionsUsedException.php` - 排他オプション重複例外
- E-49: `src/Symfony/Component/Notifier/Recipient/EmailRecipientTrait.php` - Emailレシピエントトレイト
- E-50: `src/Symfony/Component/Notifier/Recipient/SmsRecipientTrait.php` - SMSレシピエントトレイト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Notifier::send - recipientを指定して通知が送信される | E-01 (L40-51) | ○ |
| C-002 | Notifier::send - recipientが未指定の場合NoRecipientが使用される | E-01 (L42-44), E-36 | ○ |
| C-003 | Notifier::send - transportName付きチャネル名の分割 | E-01 (L85-88) | ○ |
| C-004 | Notifier::send - チャネル未決定+policyなしでLogicException | E-01 (L72-77) | ○ |
| C-005 | Notifier::send - policyが空結果でLogicException | E-01 (L78-80) | ○ |
| C-006 | Notifier::send - 存在しないチャネル名でLogicException | E-01 (L90-92) | ○ |
| C-007 | Notifier::send - SmsChannel+NoRecipientでLogicException | E-01 (L94-96) | ○ |
| C-008 | Notifier::send - チャネル非サポートでLogicException | E-01 (L98-100) | ○ |
| C-009 | Notifier::addAdminRecipient | E-01 (L53-56) | ○ |
| C-010 | Notifier::getAdminRecipients | E-01 (L61-64) | ○ |
| C-011 | Notifier::getAdminRecipients - 空配列 | E-01 (L29) | ○ |
| C-012 | Notifier::getChannel - ContainerInterface | E-01 (L108-109) | ○ |
| C-013 | Notifier::getChannel - 配列 | E-01 (L112) | ○ |
| C-014 | Notifier::getChannel - 存在しない場合null | E-01 (L109, L112) | ○ |
| C-015 | Chatter::__toString | E-02 (L34-36) | ○ |
| C-016 | Chatter::supports | E-02 (L38-41) | ○ |
| C-017 | Chatter::send - bus=null | E-02 (L45-47) | ○ |
| C-018 | Chatter::send - bus設定済み | E-02 (L49-53) | ○ |
| C-019 | Chatter::send - dispatcher付きMessageEvent | E-02 (L49) | ○ |
| C-020 | Texter::__toString | E-03 (L34-36) | ○ |
| C-021 | Texter::supports | E-03 (L38-41) | ○ |
| C-022 | Texter::send - bus=null | E-03 (L45-47) | ○ |
| C-023 | Texter::send - bus設定済み | E-03 (L49-53) | ○ |
| C-024 | Transport::fromString - 単一DSN | E-04 (L146-158) | ○ |
| C-025 | Transport::fromString - FailoverTransport | E-04 (L147-149) | ○ |
| C-026 | Transport::fromString - RoundRobinTransport | E-04 (L152-155) | ○ |
| C-027 | Transport::fromStrings | E-04 (L136-143) | ○ |
| C-028 | Transport::fromDsnObject - サポートDSN | E-04 (L160-166) | ○ |
| C-029 | Transport::fromDsnObject - UnsupportedSchemeException | E-04 (L168) | ○ |
| C-030 | Transport::fromDsn | E-04 (L113-118) | ○ |
| C-031 | Transport::fromDsns | E-04 (L120-125) | ○ |
| C-032 | Dsn::__construct - 正常パース | E-05 (L32-54) | ○ |
| C-033 | Dsn::__construct - URLデコード | E-05 (L50-51) | ○ |
| C-034 | Dsn::__construct - 最小構成 | E-05 (L50-54) | ○ |
| C-035 | Dsn::__construct - 不正DSN | E-05 (L36-38) | ○ |
| C-036 | Dsn::__construct - スキーム必須 | E-05 (L40-42) | ○ |
| C-037 | Dsn::__construct - ホスト必須 | E-05 (L45-47) | ○ |
| C-038 | Dsn::getPort - ポート指定あり | E-05 (L77-79) | ○ |
| C-039 | Dsn::getPort - デフォルト値 | E-05 (L77-79) | ○ |
| C-040 | Dsn::getOption | E-05 (L82-85) | ○ |
| C-041 | Dsn::getOption - デフォルト値 | E-05 (L82-85) | ○ |
| C-042 | Dsn::getRequiredOption | E-05 (L87-94) | ○ |
| C-043 | Dsn::getRequiredOption - 存在しない | E-05 (L89-91) | ○ |
| C-044 | Dsn::getRequiredOption - 空文字 | E-05 (L89-91) | ○ |
| C-045 | Dsn::getBooleanOption - true | E-05 (L96-99) | ○ |
| C-046 | Dsn::getBooleanOption - デフォルト | E-05 (L96-99) | ○ |
| C-047 | Dsn::getOriginalDsn | E-05 (L111-114) | ○ |
| C-048 | Transports::__toString | E-06 (L39-42) | ○ |
| C-049 | Transports::supports - true | E-06 (L44-53) | ○ |
| C-050 | Transports::supports - false | E-06 (L44-53) | ○ |
| C-051 | Transports::send - transport名なし | E-06 (L57-63) | ○ |
| C-052 | Transports::send - transport名あり | E-06 (L66-74) | ○ |
| C-053 | Transports::send - サポートtransportなし | E-06 (L63) | ○ |
| C-054 | Transports::send - 存在しないtransport | E-06 (L66-68) | ○ |
| C-055 | Transports::send - transport非互換 | E-06 (L70-72) | ○ |
| C-056 | NullTransport::send | E-07 (L31-44) | ○ |
| C-057 | NullTransport::send - dispatcher付き | E-07 (L36-42) | ○ |
| C-058 | NullTransport::__toString | E-07 (L46-49) | ○ |
| C-059 | NullTransport::supports | E-07 (L51-54) | ○ |
| C-060 | NullTransportFactory::create - nullスキーム | E-08 (L21-25) | ○ |
| C-061 | NullTransportFactory::create - 非nullスキーム | E-08 (L27) | ○ |
| C-062 | AbstractTransportFactory::supports - true | E-09 (L30-33) | ○ |
| C-063 | AbstractTransportFactory::supports - false | E-09 (L30-33) | ○ |
| C-064 | AbstractTransportFactory::getUser | E-09 (L40-43) | ○ |
| C-065 | AbstractTransportFactory::getUser - 未設定 | E-09 (L42) | ○ |
| C-066 | AbstractTransportFactory::getPassword | E-09 (L45-48) | ○ |
| C-067 | AbstractTransportFactory::getPassword - 未設定 | E-09 (L47) | ○ |
| C-068 | AbstractTransport::setHost | E-10 (L50-55) | ○ |
| C-069 | AbstractTransport::setPort | E-10 (L60-65) | ○ |
| C-070 | AbstractTransport::send - dispatcher=null | E-10 (L69-71) | ○ |
| C-071 | AbstractTransport::send - イベント付き | E-10 (L73-86) | ○ |
| C-072 | AbstractTransport::send - 失敗時FailedMessageEvent | E-10 (L77-81) | ○ |
| C-073 | AbstractTransport::getEndpoint - デフォルト | E-10 (L90-93) | ○ |
| C-074 | AbstractTransport::getEndpoint - カスタム | E-10 (L90-93) | ○ |
| C-075 | RoundRobinTransport::__construct - 空配列 | E-11 (L40-41) | ○ |
| C-076 | RoundRobinTransport::__toString | E-11 (L49-52) | ○ |
| C-077 | RoundRobinTransport::supports - true | E-11 (L54-63) | ○ |
| C-078 | RoundRobinTransport::supports - false | E-11 (L54-63) | ○ |
| C-079 | RoundRobinTransport::send - ラウンドロビン | E-11 (L65-80) | ○ |
| C-080 | RoundRobinTransport::send - 非サポート | E-11 (L67-69) | ○ |
| C-081 | RoundRobinTransport::send - 全失敗 | E-11 (L79) | ○ |
| C-082 | RoundRobinTransport::send - フォールバック | E-11 (L72-77) | ○ |
| C-083 | RoundRobinTransport::send - retryPeriod復帰 | E-11 (L105-109) | △ |
| C-084 | FailoverTransport::getNextTransport - 初回 | E-12 (L25-31) | ○ |
| C-085 | FailoverTransport::getNextTransport - 持続 | E-12 (L27-31) | ○ |
| C-086 | FailoverTransport::getNextTransport - dead切替 | E-12 (L27-29) | ○ |
| C-087 | FailoverTransport::getInitialCursor | E-12 (L34-37) | ○ |
| C-088 | FailoverTransport::__toString | E-12 (L39-42), E-11 (L49-52) | ○ |
| C-089 | Notification::__construct | E-13 (L50-54) | ○ |
| C-090 | Notification::__construct - デフォルト | E-13 (L40-45, L50) | ○ |
| C-091 | Notification::fromThrowable | E-13 (L59-62) | ○ |
| C-092 | Notification::subject | E-13 (L67-72) | ○ |
| C-093 | Notification::content | E-13 (L82-87) | ○ |
| C-094 | Notification::importance | E-13 (L97-102) | ○ |
| C-095 | Notification::getImportance - デフォルト | E-13 (L45) | ○ |
| C-096 | Notification::importanceFromLogLevelName - critical | E-13 (L114-119) | ○ |
| C-097 | Notification::importanceFromLogLevelName - error | E-13 (L117) | ○ |
| C-098 | Notification::importanceFromLogLevelName - warning | E-13 (L117) | ○ |
| C-099 | Notification::importanceFromLogLevelName - debug | E-13 (L117) | ○ |
| C-100 | Notification::emoji | E-13 (L125-130) | ○ |
| C-101 | Notification::getEmoji - デフォルト絵文字 | E-13 (L133-135, L183-195) | ○ |
| C-102 | Notification::getEmoji - 空文字 | E-13 (L133-135, L185-187) | ○ |
| C-103 | Notification::exception | E-13 (L140-151) | ○ |
| C-104 | Notification::channels | E-13 (L168-173) | ○ |
| C-105 | Notification::getChannels | E-13 (L178-181) | ○ |
| C-106 | ChatMessage::__construct | E-14 (L24-28) | ○ |
| C-107 | ChatMessage::fromNotification | E-14 (L30-36) | ○ |
| C-108 | ChatMessage::subject | E-14 (L41-46) | ○ |
| C-109 | ChatMessage::getRecipientId - options設定済み | E-14 (L53-56) | ○ |
| C-110 | ChatMessage::getRecipientId - options=null | E-14 (L53-56) | ○ |
| C-111 | ChatMessage::transport | E-14 (L76-81) | ○ |
| C-112 | SmsMessage::__construct | E-15 (L26-35) | ○ |
| C-113 | SmsMessage::__construct - 空電話番号 | E-15 (L32-34) | ○ |
| C-114 | SmsMessage::fromNotification | E-15 (L37-43) | ○ |
| C-115 | SmsMessage::phone | E-15 (L48-57) | ○ |
| C-116 | SmsMessage::phone - 空文字 | E-15 (L50-52) | ○ |
| C-117 | SmsMessage::getRecipientId | E-15 (L64-67) | ○ |
| C-118 | SmsMessage::from | E-15 (L102-107) | ○ |
| C-119 | EmailMessage::fromNotification | E-16 (L36-65) | ○ |
| C-120 | EmailMessage::fromNotification - 空メール | E-16 (L38-40) | ○ |
| C-121 | EmailMessage::transport - Email | E-16 (L105-117) | ○ |
| C-122 | EmailMessage::transport - RawMessage | E-16 (L107-109) | ○ |
| C-123 | EmailMessage::transport - null | E-16 (L110-112) | ○ |
| C-124 | EmailMessage::getTransport - Email | E-16 (L119-122) | ○ |
| C-125 | EmailMessage::getTransport - RawMessage | E-16 (L119-122) | ○ |
| C-126 | EmailMessage::getSubject | E-16 (L87-90) | ○ |
| C-127 | EmailMessage::envelope | E-16 (L80-85) | ○ |
| C-128 | PushMessage::__construct | E-17 (L24-29) | ○ |
| C-129 | PushMessage::fromNotification | E-17 (L31-37) | ○ |
| C-130 | DesktopMessage::__construct | E-18 (L24-29) | ○ |
| C-131 | DesktopMessage::fromNotification | E-18 (L31-38) | ○ |
| C-132 | DesktopMessage::setSubject | E-18 (L58-63) | ○ |
| C-133 | DesktopMessage::setContent | E-18 (L68-73) | ○ |
| C-134 | DesktopMessage::setTransport | E-18 (L98-103) | ○ |
| C-135 | SentMessage::__construct | E-19 (L24-29) | ○ |
| C-136 | SentMessage::setMessageId | E-19 (L41-44) | ○ |
| C-137 | SentMessage::getMessageId - 初期値 | E-19 (L19) | ○ |
| C-138 | SentMessage::getInfo - キー指定 | E-19 (L56-63) | ○ |
| C-139 | SentMessage::getInfo - null | E-19 (L56-63) | ○ |
| C-140 | SentMessage::getInfo - 存在しないキー | E-19 (L59) | ○ |
| C-141 | NullMessage::getRecipientId | E-20 (L26-29) | ○ |
| C-142 | NullMessage::getSubject | E-20 (L31-34) | ○ |
| C-143 | NullMessage::getOptions | E-20 (L36-39) | ○ |
| C-144 | NullMessage::getTransport | E-20 (L41-44) | ○ |
| C-145 | ChannelPolicy::getChannels | E-21 (L26-33) | ○ |
| C-146 | ChannelPolicy::getChannels - 未定義importance | E-21 (L28-30) | ○ |
| C-147 | AbstractChannel::__construct - 両方null | E-22 (L26-30) | ○ |
| C-148 | AbstractChannel::__construct - transportのみ | E-22 (L26-33) | ○ |
| C-149 | AbstractChannel::__construct - busのみ | E-22 (L26-33) | ○ |
| C-150 | ChatChannel::notify - ChatNotificationInterface | E-23 (L24-42) | ○ |
| C-151 | ChatChannel::notify - 通常Notification | E-23 (L31) | ○ |
| C-152 | ChatChannel::notify - transportName | E-23 (L33-35) | ○ |
| C-153 | ChatChannel::notify - bus=null | E-23 (L37-39) | ○ |
| C-154 | ChatChannel::notify - bus設定済み | E-23 (L40-41) | ○ |
| C-155 | ChatChannel::supports | E-23 (L44-47) | ○ |
| C-156 | SmsChannel::notify - SmsNotificationInterface | E-24 (L28-46) | ○ |
| C-157 | SmsChannel::notify - 通常Notification | E-24 (L35) | ○ |
| C-158 | SmsChannel::supports - SmsRecipientInterface | E-24 (L48-51) | ○ |
| C-159 | SmsChannel::supports - 非SmsRecipient | E-24 (L50) | ○ |
| C-160 | EmailChannel::__construct - 両方null | E-25 (L40-42) | ○ |
| C-161 | EmailChannel::notify - EmailNotificationInterface | E-25 (L50-86) | ○ |
| C-162 | EmailChannel::notify - from補完 | E-25 (L59-66) | ○ |
| C-163 | EmailChannel::notify - from未設定でLogicException | E-25 (L61-63) | ○ |
| C-164 | EmailChannel::notify - to補完 | E-25 (L68-70) | ○ |
| C-165 | EmailChannel::notify - envelope適用 | E-25 (L73-75) | ○ |
| C-166 | EmailChannel::supports - EmailRecipient | E-25 (L88-91) | ○ |
| C-167 | EmailChannel::supports - 非EmailRecipient | E-25 (L90) | ○ |
| C-168 | BrowserChannel::notify - フラッシュメッセージ | E-26 (L31-42) | ○ |
| C-169 | BrowserChannel::notify - emoji付き | E-26 (L38-40) | ○ |
| C-170 | BrowserChannel::notify - リクエストnull | E-26 (L33-35) | ○ |
| C-171 | BrowserChannel::supports | E-26 (L44-47) | ○ |
| C-172 | PushChannel::notify - PushNotificationInterface | E-27 (L24-42) | ○ |
| C-173 | PushChannel::notify - 通常Notification | E-27 (L31) | ○ |
| C-174 | PushChannel::supports | E-27 (L44-47) | ○ |
| C-175 | DesktopChannel::notify - DesktopNotificationInterface | E-28 (L24-42) | ○ |
| C-176 | DesktopChannel::notify - 通常Notification | E-28 (L30) | ○ |
| C-177 | DesktopChannel::supports | E-28 (L44-47) | ○ |
| C-178 | MessageEvent::getMessage | E-29 (L28-31) | ○ |
| C-179 | MessageEvent::isQueued - true | E-29 (L33-36) | ○ |
| C-180 | MessageEvent::isQueued - false | E-29 (L24) | ○ |
| C-181 | SentMessageEvent::getMessage | E-30 (L28-31) | ○ |
| C-182 | FailedMessageEvent::getMessage | E-31 (L28-31) | ○ |
| C-183 | FailedMessageEvent::getError | E-31 (L33-36) | ○ |
| C-184 | NotificationEvents::add | E-32 (L24-28) | ○ |
| C-185 | NotificationEvents::getTransports | E-32 (L30-33) | ○ |
| C-186 | NotificationEvents::getEvents - 全件 | E-32 (L38-52) | ○ |
| C-187 | NotificationEvents::getEvents - フィルタ | E-32 (L44-51) | ○ |
| C-188 | NotificationEvents::getEvents - 空 | E-32 (L21, L42) | ○ |
| C-189 | NotificationEvents::getMessages | E-32 (L57-66) | ○ |
| C-190 | NotificationEvents::getMessages - フィルタ | E-32 (L59) | ○ |
| C-191 | NotificationLoggerListener::onNotification | E-33 (L36-39) | ○ |
| C-192 | NotificationLoggerListener::getEvents | E-33 (L41-44) | ○ |
| C-193 | NotificationLoggerListener::reset | E-33 (L31-34) | ○ |
| C-194 | NotificationLoggerListener::getSubscribedEvents | E-33 (L46-51) | ○ |
| C-195 | SendFailedMessageToNotifierListener::onMessageFailed - 通知送信 | E-34 (L32-47) | ○ |
| C-196 | SendFailedMessageToNotifierListener::onMessageFailed - リトライスキップ | E-34 (L34-36) | ○ |
| C-197 | SendFailedMessageToNotifierListener::onMessageFailed - HandlerFailedException展開 | E-34 (L39-42) | ○ |
| C-198 | SendFailedMessageToNotifierListener::getSubscribedEvents | E-34 (L50-53) | ○ |
| C-199 | Recipient::__construct - email+phone | E-35 (L25-33) | ○ |
| C-200 | Recipient::__construct - emailのみ | E-35 (L25-33) | ○ |
| C-201 | Recipient::__construct - phoneのみ | E-35 (L25-33) | ○ |
| C-202 | Recipient::__construct - 両方空 | E-35 (L27-29) | ○ |
| C-203 | Recipient::email | E-35 (L38-43) | ○ |
| C-204 | Recipient::phone | E-35 (L50-55) | ○ |
| C-205 | AbstractFlashMessageImportanceMapper::flashMessageTypeFromImportance | E-37 (L21-28) | ○ |
| C-206 | AbstractFlashMessageImportanceMapper::flashMessageTypeFromImportance - 未定義 | E-37 (L23-25) | ○ |
| C-207 | DefaultFlashMessageImportanceMapper - urgent | E-38 (L22-26) | ○ |
| C-208 | DefaultFlashMessageImportanceMapper - low | E-38 (L25) | ○ |
| C-209 | BootstrapFlashMessageImportanceMapper - urgent | E-39 (L22) | ○ |
| C-210 | BootstrapFlashMessageImportanceMapper - high | E-39 (L23) | ○ |
| C-211 | BootstrapFlashMessageImportanceMapper - medium | E-39 (L24) | ○ |
| C-212 | BootstrapFlashMessageImportanceMapper - low | E-39 (L25) | ○ |
| C-213 | NotificationDataCollector::collect | E-40 (L30-33) | ○ |
| C-214 | NotificationDataCollector::getEvents | E-40 (L35-38) | ○ |
| C-215 | NotificationDataCollector::reset | E-40 (L40-43) | ○ |
| C-216 | NotificationDataCollector::getName | E-40 (L45-48) | ○ |
| C-217 | MessageHandler::__invoke | E-41 (L28-31) | ○ |
| C-218 | UnsupportedSchemeException - パッケージ案内 | E-42 (L352-363) | △ |
| C-219 | UnsupportedSchemeException - スキーム情報付き | E-42 (L365-370) | ○ |
| C-220 | IncompleteDsnException - DSN付き | E-43 (L19-29) | ○ |
| C-221 | IncompleteDsnException - DSNなし | E-43 (L24-26) | ○ |
| C-222 | IncompleteDsnException::getOriginalDsn | E-43 (L31-34) | ○ |
| C-223 | FlashMessageImportanceMapperException | E-44 (L19-24) | ○ |
| C-224 | MissingRequiredOptionException | E-45 (L19-24) | ○ |
| C-225 | UnsupportedOptionsException | E-46 (L21-24) | ○ |
| C-226 | UnsupportedMessageTypeException | E-47 (L21-31) | ○ |
| C-227 | MultipleExclusiveOptionsUsedException | E-48 (L23-32) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-083**: RoundRobinTransportのretryPeriod復帰テストはmicrotime()に依存するため、テスト実行時のタイミング制御が必要。sleep()やClockモックの使用を検討。
  - 候補：テスト用のClock注入 / microtime()のモック / retryPeriod=0での即座復帰テスト
- **C-218**: UnsupportedSchemeExceptionのパッケージ案内テストはBridgeクラスの存在有無（class_exists）に依存する。テスト環境でのBridgeパッケージのインストール状態に左右される。
  - 候補：class_existsのモック / 既知の未インストールBridgeを使用 / テスト環境の前提条件を明示
- **C-012/C-013/C-014**: Notifier::getChannelはprivateメソッドのため、send()メソッド経由の間接テストが必要。
  - 候補：send()からの間接テスト / ReflectionAPIによる直接テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メッセージクラス（ChatMessage, SmsMessage, PushMessage, DesktopMessage）のgetter/setter系テスト。単純なプロパティ操作のため信頼性が高い。
- 1: 中リスク - Transport系（Transports, RoundRobinTransport, FailoverTransport）の送信ロジック。複数トランスポートの協調動作をモックで検証する必要がある。
- 1: 中リスク - Channel系（ChatChannel, SmsChannel, EmailChannel）の通知ロジック。Notification/Recipientインターフェースのバリエーションに応じたモック設計が必要。
- 0: 低リスク - Event/EventListener系。シンプルなイベント格納・取得処理。
- 1: 中リスク - Notifier::sendのgetChannels内部ロジック。チャネル決定の条件分岐が複雑で、複数のエッジケースがある。

## 6) レビュアーチェックリスト（最小）
- [ ] 全227件のテストケースIDが連番で重複なく付与されているか
- [ ] 正常系・異常系・境界値のバランスが各クラスで適切か
- [ ] SmsMessage, EmailMessageの入力バリデーション（空電話番号、空メールアドレス）が網羅されているか
- [ ] RoundRobinTransport / FailoverTransport のフォールバック動作テストが十分か
- [ ] Notifier::sendのチャネル決定ロジック（policy有無、チャネル名分割）が網羅されているか
- [ ] privateメソッド（Notifier::getChannel, Notifier::getChannels）のテストが間接的に十分カバーされているか
- [ ] 各Channelクラスのbus有無による分岐（直接送信/キュー送信）がテストされているか
- [ ] FlashMessageImportanceMapper系の全importanceレベルがテストされているか
