---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 90
  claims_with_evidence: 86
  claims_without_evidence: 4
confidence_derived: 0.96
---

# 根拠レポート：Component-ObjectMapper 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：86 / 90、根拠なし：4
- 優先レビュー（高）
  1. **UT-OBM-082, UT-OBM-083（LazyObject初期化）**：LazyObjectInterfaceおよびuninitializedLazyObjectの挙動は外部依存（VarExporter）のため、実際の動作確認が必要
  2. **UT-OBM-086（LazyGhost生成）**：ReflectionClass::newLazyGhostはPHP 8.4の新機能であり、実行時の振る舞い確認が必要
  3. **UT-OBM-090（WeakMapトラッキング）**：privateフィールドobjectMapの内部状態テストは実装方法の検討が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/ObjectMapper/ObjectMapper.php` - メインクラス（444行）
- E-02: `src/Symfony/Component/ObjectMapper/ObjectMapperInterface.php` - インターフェース定義
- E-03: `src/Symfony/Component/ObjectMapper/Attribute/Map.php` - Map属性クラス
- E-04: `src/Symfony/Component/ObjectMapper/Metadata/Mapping.php` - Mappingメタデータクラス
- E-05: `src/Symfony/Component/ObjectMapper/Metadata/ReflectionObjectMapperMetadataFactory.php` - リフレクションメタデータファクトリ
- E-06: `src/Symfony/Component/ObjectMapper/Metadata/ReverseClassObjectMapperMetadataFactory.php` - リバースマッピングメタデータファクトリ
- E-07: `src/Symfony/Component/ObjectMapper/Metadata/ObjectMapperMetadataFactoryInterface.php` - メタデータファクトリインターフェース
- E-08: `src/Symfony/Component/ObjectMapper/Condition/TargetClass.php` - TargetClass条件クラス
- E-09: `src/Symfony/Component/ObjectMapper/Transform/MapCollection.php` - MapCollectionトランスフォーム
- E-10: `src/Symfony/Component/ObjectMapper/DependencyInjection/ReverseMappingPass.php` - CompilerPass
- E-11: `src/Symfony/Component/ObjectMapper/ConditionCallableInterface.php` - Condition用インターフェース
- E-12: `src/Symfony/Component/ObjectMapper/TransformCallableInterface.php` - Transform用インターフェース
- E-13: `src/Symfony/Component/ObjectMapper/ObjectMapperAwareInterface.php` - ObjectMapperAwareインターフェース
- E-14: `src/Symfony/Component/ObjectMapper/Exception/MappingException.php` - MappingException
- E-15: `src/Symfony/Component/ObjectMapper/Exception/MappingTransformException.php` - MappingTransformException
- E-16: `src/Symfony/Component/ObjectMapper/Exception/NoSuchCallableException.php` - NoSuchCallableException
- E-17: `src/Symfony/Component/ObjectMapper/Exception/NoSuchPropertyException.php` - NoSuchPropertyException
- E-18: `src/Symfony/Component/ObjectMapper/Exception/RuntimeException.php` - RuntimeException
- E-19: `src/Symfony/Component/ObjectMapper/Exception/ExceptionInterface.php` - ExceptionInterface

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-OBM-001: デフォルト引数でインスタンス生成できる | E-01 (L38-45) | ○ |
| C-02 | UT-OBM-002: 全引数を指定してインスタンス生成できる | E-01 (L38-45) | ○ |
| C-03 | UT-OBM-003: Map属性付きソースからターゲットへマッピングできる | E-01 (L47-59, L61-69), E-03 | ○ |
| C-04 | UT-OBM-004: ターゲットにクラス文字列を指定してマッピングできる | E-01 (L66, L72-74, L77) | ○ |
| C-05 | UT-OBM-005: ターゲットに既存オブジェクトを指定してマッピングできる | E-01 (L66, L82) | ○ |
| C-06 | UT-OBM-006: 同名プロパティが自動マッピングされる | E-01 (L166-178) | ○ |
| C-07 | UT-OBM-007: Map(target)で異なるプロパティ名にマッピングできる | E-01 (L144), E-03 (L29) | ○ |
| C-08 | UT-OBM-008: Map(source)でソースプロパティを指定できる | E-01 (L140-141), E-03 (L30) | ○ |
| C-09 | UT-OBM-009: transform callableで値変換が行われる | E-01 (L351-372), E-03 (L32) | ○ |
| C-10 | UT-OBM-010: if条件がtrueの場合にマッピングが実行される | E-01 (L145-156), E-03 (L31) | ○ |
| C-11 | UT-OBM-011: if条件がfalseの場合にマッピングがスキップされる | E-01 (L152-156) | ○ |
| C-12 | UT-OBM-012: if=false(boolean)でスキップされる | E-01 (L145-148) | ○ |
| C-13 | UT-OBM-013: コンストラクタ引数への値注入が行われる | E-01 (L104-120) | ○ |
| C-14 | UT-OBM-014: コンストラクタのデフォルト値が使用される | E-01 (L118) | ○ |
| C-15 | UT-OBM-015: readOnlyプロパティが初期化済みの場合スキップされる | E-01 (L110-112) | ○ |
| C-16 | UT-OBM-016: PropertyAccessorを使用してプロパティが読み書きされる | E-01 (L212-218, L232-234, L245-248) | ○ |
| C-17 | UT-OBM-017: ネストされたオブジェクトが再帰的にマッピングされる | E-01 (L260-298) | ○ |
| C-18 | UT-OBM-018: 循環参照が検出され同一オブジェクトが再利用される | E-01 (L49-51, L101, L276-277) | ○ |
| C-19 | UT-OBM-019: transformCallableLocatorからサービスが取得される | E-01 (L364, L378-398) | ○ |
| C-20 | UT-OBM-020: conditionCallableLocatorからサービスが取得される | E-01 (L152, L337, L378-398) | ○ |
| C-21 | UT-OBM-021: 複数のtransformが順番に適用される | E-01 (L357-361, L363-369) | ○ |
| C-22 | UT-OBM-022: staticプロパティがマッピング対象外になる | E-01 (L132-134) | ○ |
| C-23 | UT-OBM-023: ターゲットにメタデータがある場合にターゲットのメタデータが使用される | E-01 (L84-87) | ○ |
| C-24 | UT-OBM-024: クラスレベルのtransformが適用される | E-01 (L89-95) | ○ |
| C-25 | UT-OBM-025: ObjectMapperAwareInterface実装transformにObjectMapperが注入される | E-01 (L365-367), E-13 | ○ |
| C-26 | UT-OBM-026: ターゲットが見つからない場合にMappingExceptionがスローされる | E-01 (L68-69) | ○ |
| C-27 | UT-OBM-027: 存在しないターゲットクラスでMappingExceptionがスローされる | E-01 (L72-74) | ○ |
| C-28 | UT-OBM-028: クラスレベルtransformが非オブジェクトを返した場合にMappingTransformException | E-01 (L92-94), E-15 | ○ |
| C-29 | UT-OBM-029: transformが異なるクラスを返した場合にMappingException | E-01 (L97-99) | ○ |
| C-30 | UT-OBM-030: 存在しないプロパティでNoSuchPropertyException | E-01 (L253-254), E-17 | ○ |
| C-31 | UT-OBM-031: PropertyAccessor使用時にNoSuchPropertyExceptionが変換される | E-01 (L246-249) | ○ |
| C-32 | UT-OBM-032: 無効なcallableでNoSuchCallableException | E-01 (L398), E-16 | ○ |
| C-33 | UT-OBM-033: callableが期待インターフェースを未実装でNoSuchCallableException | E-01 (L381-383, L391-393) | ○ |
| C-34 | UT-OBM-034: 曖昧マッピングでMappingException | E-01 (L340-343) | ○ |
| C-35 | UT-OBM-035: プロパティ0件のオブジェクトマッピング | E-01 (L131) | ○ |
| C-36 | UT-OBM-036: 未初期化プロパティがスキップされる | E-01 (L172) | ○ |
| C-37 | UT-OBM-037: withObjectMapperでクローンが返却される | E-01 (L437-443) | ○ |
| C-38 | UT-OBM-038: クローンに指定ObjectMapperが設定される | E-01 (L437-443) | ○ |
| C-39 | UT-OBM-039: Map全パラメータ指定でインスタンス生成 | E-03 (L28-34) | ○ |
| C-40 | UT-OBM-040: Mapパラメータなしでインスタンス生成 | E-03 (L28-34) | ○ |
| C-41 | UT-OBM-041: Mapのtargetのみ指定でインスタンス生成 | E-03 (L28-34) | ○ |
| C-42 | UT-OBM-042: Mapのtransformに配列指定 | E-03 (L32) | ○ |
| C-43 | UT-OBM-043: MappingがMapを継承 | E-04, E-03 | ○ |
| C-44 | UT-OBM-044: ReflectionObjectMapperMetadataFactory クラスレベルメタデータ取得 | E-05 (L27-48) | ○ |
| C-45 | UT-OBM-045: ReflectionObjectMapperMetadataFactory プロパティレベルメタデータ取得 | E-05 (L37) | ○ |
| C-46 | UT-OBM-046: 属性なしオブジェクトで空配列返却 | E-05 (L38-44) | ○ |
| C-47 | UT-OBM-047: 複数Map属性の全取得 | E-05 (L37-42), E-03 (L19: IS_REPEATABLE) | ○ |
| C-48 | UT-OBM-048: ReflectionObjectMapperMetadataFactoryのキャッシュ機構 | E-05 (L32-34) | ○ |
| C-49 | UT-OBM-049: 存在しないプロパティでMappingException | E-05 (L45-47) | ○ |
| C-50 | UT-OBM-050: ReverseClassObjectMapperMetadataFactoryのDI | E-06 (L31-35) | ○ |
| C-51 | UT-OBM-051: classMapに存在しないクラスでデリゲート | E-06 (L48-49) | ○ |
| C-52 | UT-OBM-052: classMapに存在するクラスでMappingが追加される | E-06 (L52-55) | ○ |
| C-53 | UT-OBM-053: プロパティ指定時にターゲットのプロパティ属性が取得される | E-06 (L58-68) | ○ |
| C-54 | UT-OBM-054: sourceが未定義の属性はスキップされる | E-06 (L65-66) | ○ |
| C-55 | UT-OBM-055: ReverseClassObjectMapperMetadataFactoryのキャッシュ | E-06 (L42-44) | ○ |
| C-56 | UT-OBM-056: TargetClassコンストラクタ | E-08 (L26-28) | ○ |
| C-57 | UT-OBM-057: TargetClass.__invoke trueケース | E-08 (L30-33) | ○ |
| C-58 | UT-OBM-058: TargetClass.__invoke falseケース | E-08 (L32) | ○ |
| C-59 | UT-OBM-059: TargetClass.__invoke nullターゲット | E-08 (L32) | ○ |
| C-60 | UT-OBM-060: TargetClass.__invoke サブクラス判定 | E-08 (L32: instanceof) | ○ |
| C-61 | UT-OBM-061: MapCollectionデフォルトコンストラクタ | E-09 (L27-31) | ○ |
| C-62 | UT-OBM-062: MapCollection全引数コンストラクタ | E-09 (L27-31) | ○ |
| C-63 | UT-OBM-063: MapCollection.__invoke コレクションマッピング | E-09 (L41-54) | ○ |
| C-64 | UT-OBM-064: MapCollection targetClass指定 | E-09 (L50) | ○ |
| C-65 | UT-OBM-065: MapCollection ObjectMapper自動生成 | E-09 (L47) | ○ |
| C-66 | UT-OBM-066: MapCollection連想配列キー保持 | E-09 (L49-50) | ○ |
| C-67 | UT-OBM-067: MapCollection非イテラブルでMappingException | E-09 (L43-45) | ○ |
| C-68 | UT-OBM-068: MapCollection空イテラブル | E-09 (L48-53) | ○ |
| C-69 | UT-OBM-069: MapCollection 1件イテラブル | E-09 (L48-53) | ○ |
| C-70 | UT-OBM-070: MapCollection.withObjectMapperクローン | E-09 (L33-39) | ○ |
| C-71 | UT-OBM-071: MapCollection.withObjectMapper注入確認 | E-09 (L33-39) | ○ |
| C-72 | UT-OBM-072: ReverseMappingPass classMap設定 | E-10 (L22-40) | ○ |
| C-73 | UT-OBM-073: ReverseMappingPass サービス未定義の早期リターン | E-10 (L24-26) | ○ |
| C-74 | UT-OBM-074: ReverseMappingPass 複数タグ処理 | E-10 (L31-37) | ○ |
| C-75 | UT-OBM-075: ReverseMappingPass 不完全タグスキップ | E-10 (L33) | ○ |
| C-76 | UT-OBM-076: ReverseMappingPass タグなし | E-10 (L31, L39) | ○ |
| C-77 | UT-OBM-077: MappingException例外階層 | E-14, E-18 | ○ |
| C-78 | UT-OBM-078: MappingTransformException例外階層 | E-15, E-18 | ○ |
| C-79 | UT-OBM-079: NoSuchCallableException例外階層 | E-16, E-14 | ○ |
| C-80 | UT-OBM-080: NoSuchPropertyException例外階層 | E-17, E-14 | ○ |
| C-81 | UT-OBM-081: RuntimeExceptionがExceptionInterface実装 | E-18, E-19 | ○ |
| C-82 | UT-OBM-082: LazyObjectInterfaceソースの初期化 | E-01 (L413-414) | △ |
| C-83 | UT-OBM-083: ReflectionClass経由LazyObject初期化 | E-01 (L415-417) | △ |
| C-84 | UT-OBM-084: PropertyAccessor isWritable false時のスキップ | E-01 (L213-215) | ○ |
| C-85 | UT-OBM-085: ターゲットに存在しないプロパティのスキップ | E-01 (L220-221) | ○ |
| C-86 | UT-OBM-086: ネストオブジェクトのLazyGhost生成 | E-01 (L283-294) | △ |
| C-87 | UT-OBM-087: rootCall時のプロパティ設定 | E-01 (L203-209) | ○ |
| C-88 | UT-OBM-088: 文字列サービスIDによるcondition | E-01 (L337, L388-395) | ○ |
| C-89 | UT-OBM-089: 文字列callable呼び出し | E-01 (L323-325) | ○ |
| C-90 | UT-OBM-090: WeakMapトラッキング | E-01 (L36, L53, L101) | △ |

## 4) 不足情報（Unknown / Missing）
- **LazyObjectInterface / LazyGhost関連（C-82, C-83, C-86）**: `symfony/var-exporter` コンポーネントおよびPHP 8.4のReflectionClass::newLazyGhost / isUninitializedLazyObjectの実際の動作は外部依存であり、テスト環境での再現が必要。コード上の存在は確認済みだが、実際のLazyObject生成・初期化の振る舞いは外部コンポーネントに依存する。
  - 候補：`symfony/var-exporter` のテストケース / PHP 8.4公式ドキュメント / LazyObjectInterfaceの実装例
- **WeakMapの内部状態テスト（C-90）**: `objectMap` はprivateフィールドであり、直接的なアサーションが困難。循環参照テスト（C-18）で間接的に検証可能だが、WeakMap自体の状態を直接確認するテスト方法は要検討。
  - 候補：リフレクションによるprivateプロパティアクセス / 循環参照テストでの間接検証

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 例外クラスの階層確認テスト（UT-OBM-077〜081）- 単純な継承確認のみ
- **1（中リスク）**: LazyObject関連テスト（UT-OBM-082, 083, 086）- 外部依存でテスト環境構築が必要
- **1（中リスク）**: WeakMapトラッキングテスト（UT-OBM-090）- privateフィールドのテスト方法の検討が必要
- **0（低リスク）**: ObjectMapper.mapの正常系・異常系テスト - コードから直接読み取れる分岐をカバー

## 6) レビュアーチェックリスト（最小）
- [ ] ObjectMapper.mapの全分岐パス（正常系/異常系/境界値）が網羅されているか
- [ ] #[Map]属性の各パラメータ（target, source, if, transform）に対するテストケースが存在するか
- [ ] 例外クラスごとにスロー条件のテストケースが存在するか
- [ ] ReflectionObjectMapperMetadataFactory / ReverseClassObjectMapperMetadataFactoryのキャッシュ機構がテストされているか
- [ ] MapCollectionのイテラブル入力バリデーションおよび境界値テストが適切か
- [ ] ReverseMappingPass（CompilerPass）の全分岐がテストされているか
- [ ] LazyObject関連テストの実現可能性と外部依存の扱いが検討されているか
- [ ] PropertyAccessor有無の両パターンでのプロパティアクセステストがカバーされているか
