---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 157
  claims_with_evidence: 155
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：Component-OptionsResolver 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：155 / 157、根拠なし：2
- 優先レビュー（高）
  1. **C-103（UT-OPR-103）**：trigger_deprecationの発火確認はランタイム挙動であり、静的コード解析のみでは検証が困難
  2. **C-100（UT-OPR-100）**：プロトタイプ配列解決のテストケースは、ネストオプション内でのsetPrototype呼び出しのコンテキストに依存し、外部からの設定方法に要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/OptionsResolver/OptionsResolver.php` - メインクラス（1366行）、全publicメソッドとprivateメソッドの定義
- E-02: `src/Symfony/Component/OptionsResolver/OptionConfigurator.php` - fluent APIラッパークラス（160行）
- E-03: `src/Symfony/Component/OptionsResolver/Options.php` - インターフェース定義（ArrayAccess, Countable継承）
- E-04: `src/Symfony/Component/OptionsResolver/Debug/OptionsResolverIntrospector.php` - デバッグ用イントロスペクタ（114行）
- E-05: `src/Symfony/Component/OptionsResolver/Exception/ExceptionInterface.php` - 例外マーカーインターフェース
- E-06: `src/Symfony/Component/OptionsResolver/Exception/AccessException.php` - LogicExceptionを継承
- E-07: `src/Symfony/Component/OptionsResolver/Exception/InvalidOptionsException.php` - InvalidArgumentExceptionを継承
- E-08: `src/Symfony/Component/OptionsResolver/Exception/MissingOptionsException.php` - InvalidArgumentExceptionを継承
- E-09: `src/Symfony/Component/OptionsResolver/Exception/UndefinedOptionsException.php` - InvalidArgumentExceptionを継承
- E-10: `src/Symfony/Component/OptionsResolver/Exception/NoSuchOptionException.php` - OutOfBoundsExceptionを継承
- E-11: `src/Symfony/Component/OptionsResolver/Exception/OptionDefinitionException.php` - LogicExceptionを継承
- E-12: `src/Symfony/Component/OptionsResolver/Exception/NoConfigurationException.php` - RuntimeExceptionを継承
- E-13: `src/Symfony/Component/OptionsResolver/Exception/InvalidArgumentException.php` - \InvalidArgumentExceptionを継承

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-OPR-001: setDefaultでスカラー値が設定される | E-01 (L185-237) | ○ |
| C-02 | UT-OPR-002: setDefaultでnull値が設定される | E-01 (L185-237, array_key_exists使用) | ○ |
| C-03 | UT-OPR-003: Optionsタイプヒント付きクロージャが遅延評価される | E-01 (L196-219) | ○ |
| C-04 | UT-OPR-004: 第2引数ありクロージャで前の値が引き継がれる | E-01 (L207-212) | ○ |
| C-05 | UT-OPR-005: 非Optionsタイプヒントのクロージャが通常値として設定される | E-01 (L196-200) | ○ |
| C-06 | UT-OPR-006: ロック中にsetDefaultでAccessException | E-01 (L190-192) | ○ |
| C-07 | UT-OPR-007: setDefaultでdefined配列に登録される | E-01 (L234) | ○ |
| C-08 | UT-OPR-008: setDefaultsで複数値が設定される | E-01 (L244-251) | ○ |
| C-09 | UT-OPR-009: setDefaultsに空配列を渡した場合 | E-01 (L246) | ○ |
| C-10 | UT-OPR-010: hasDefaultが設定済みオプションでtrue | E-01 (L259-262) | ○ |
| C-11 | UT-OPR-011: hasDefaultが未設定オプションでfalse | E-01 (L261) | ○ |
| C-12 | UT-OPR-012: hasDefaultがnull設定済みオプションでtrue | E-01 (L261, array_key_exists使用) | ○ |
| C-13 | UT-OPR-013: setRequiredで文字列指定 | E-01 (L273-285) | ○ |
| C-14 | UT-OPR-014: setRequiredで配列指定 | E-01 (L279) | ○ |
| C-15 | UT-OPR-015: ロック中にsetRequiredでAccessException | E-01 (L275-277) | ○ |
| C-16 | UT-OPR-016: setRequiredでdefined配列にも登録される | E-01 (L280) | ○ |
| C-17 | UT-OPR-017: isRequiredでtrue | E-01 (L292-295) | ○ |
| C-18 | UT-OPR-018: isRequiredでfalse | E-01 (L293) | ○ |
| C-19 | UT-OPR-019: getRequiredOptionsで配列返却 | E-01 (L304-307) | ○ |
| C-20 | UT-OPR-020: getRequiredOptionsで空配列 | E-01 (L306) | ○ |
| C-21 | UT-OPR-021: isMissingでtrue | E-01 (L316-319) | ○ |
| C-22 | UT-OPR-022: isMissingでfalse（デフォルト値あり） | E-01 (L318) | ○ |
| C-23 | UT-OPR-023: isMissingでfalse（非必須） | E-01 (L318) | ○ |
| C-24 | UT-OPR-024: getMissingOptionsで配列返却 | E-01 (L326-329) | ○ |
| C-25 | UT-OPR-025: setDefinedで文字列指定 | E-01 (L344-355) | ○ |
| C-26 | UT-OPR-026: setDefinedで配列指定 | E-01 (L350) | ○ |
| C-27 | UT-OPR-027: ロック中にsetDefinedでAccessException | E-01 (L346-348) | ○ |
| C-28 | UT-OPR-028: isDefinedでtrue | E-01 (L363-366) | ○ |
| C-29 | UT-OPR-029: isDefinedでfalse | E-01 (L365) | ○ |
| C-30 | UT-OPR-030: getDefinedOptionsで配列返却 | E-01 (L375-378) | ○ |
| C-31 | UT-OPR-031: setOptionsでネストオプション定義 | E-01 (L387-402) | ○ |
| C-32 | UT-OPR-032: ロック中にsetOptionsでAccessException | E-01 (L389-391) | ○ |
| C-33 | UT-OPR-033: setOptionsでデフォルト値が空配列 | E-01 (L395) | ○ |
| C-34 | UT-OPR-034: isNestedでtrue | E-01 (L404-407) | ○ |
| C-35 | UT-OPR-035: isNestedでfalse | E-01 (L406) | ○ |
| C-36 | UT-OPR-036: setDeprecatedで文字列メッセージ | E-01 (L432-461) | ○ |
| C-37 | UT-OPR-037: setDeprecatedでクロージャメッセージ | E-01 (L432-461) | ○ |
| C-38 | UT-OPR-038: 未定義オプションでsetDeprecated | E-01 (L438-439) | ○ |
| C-39 | UT-OPR-039: ロック中にsetDeprecatedでAccessException | E-01 (L434-436) | ○ |
| C-40 | UT-OPR-040: 空文字列メッセージで非推奨スキップ | E-01 (L447-449) | ○ |
| C-41 | UT-OPR-041: isDeprecatedでtrue | E-01 (L463-466) | ○ |
| C-42 | UT-OPR-042: isDeprecatedでfalse | E-01 (L465) | ○ |
| C-43 | UT-OPR-043: setNormalizerで設定 | E-01 (L491-507) | ○ |
| C-44 | UT-OPR-044: 未定義オプションでsetNormalizer | E-01 (L497-498) | ○ |
| C-45 | UT-OPR-045: ロック中にsetNormalizerでAccessException | E-01 (L493-495) | ○ |
| C-46 | UT-OPR-046: setNormalizerで上書き | E-01 (L501) | ○ |
| C-47 | UT-OPR-047: addNormalizerで末尾追加 | E-01 (L532-553, L546) | ○ |
| C-48 | UT-OPR-048: addNormalizerで先頭追加 | E-01 (L542-544) | ○ |
| C-49 | UT-OPR-049: 未定義オプションでaddNormalizer | E-01 (L538-539) | ○ |
| C-50 | UT-OPR-050: ロック中にaddNormalizerでAccessException | E-01 (L534-536) | ○ |
| C-51 | UT-OPR-051: setAllowedValuesで配列設定 | E-01 (L575-591) | ○ |
| C-52 | UT-OPR-052: setAllowedValuesで単一値設定 | E-01 (L585) | ○ |
| C-53 | UT-OPR-053: setAllowedValuesでクロージャ設定 | E-01 (L1042-1043) | ○ |
| C-54 | UT-OPR-054: 未定義オプションでsetAllowedValues | E-01 (L581-582) | ○ |
| C-55 | UT-OPR-055: ロック中にsetAllowedValuesでAccessException | E-01 (L577-579) | ○ |
| C-56 | UT-OPR-056: addAllowedValuesで追加 | E-01 (L615-639, L631-632) | ○ |
| C-57 | UT-OPR-057: addAllowedValuesで初回設定 | E-01 (L629-630) | ○ |
| C-58 | UT-OPR-058: 未定義オプションでaddAllowedValues | E-01 (L621-622) | ○ |
| C-59 | UT-OPR-059: ロック中にaddAllowedValuesでAccessException | E-01 (L617-619) | ○ |
| C-60 | UT-OPR-060: setAllowedTypesで設定 | E-01 (L655-671) | ○ |
| C-61 | UT-OPR-061: setAllowedTypesで配列設定 | E-01 (L665) | ○ |
| C-62 | UT-OPR-062: 未定義オプションでsetAllowedTypes | E-01 (L661-662) | ○ |
| C-63 | UT-OPR-063: ロック中にsetAllowedTypesでAccessException | E-01 (L657-659) | ○ |
| C-64 | UT-OPR-064: addAllowedTypesで追加 | E-01 (L689-709, L702) | ○ |
| C-65 | UT-OPR-065: addAllowedTypesで初回設定 | E-01 (L699-700) | ○ |
| C-66 | UT-OPR-066: 未定義オプションでaddAllowedTypes | E-01 (L695-696) | ○ |
| C-67 | UT-OPR-067: ロック中にaddAllowedTypesでAccessException | E-01 (L691-693) | ○ |
| C-68 | UT-OPR-068: defineでOptionConfigurator返却 | E-01 (L714-721) | ○ |
| C-69 | UT-OPR-069: 既定義オプションでdefine時にOptionDefinitionException | E-01 (L716-717) | ○ |
| C-70 | UT-OPR-070: setInfoで情報メッセージ設定 | E-01 (L731-744) | ○ |
| C-71 | UT-OPR-071: 未定義オプションでsetInfo | E-01 (L737-738) | ○ |
| C-72 | UT-OPR-072: ロック中にsetInfoでAccessException | E-01 (L733-735) | ○ |
| C-73 | UT-OPR-073: getInfoで情報取得 | E-01 (L749-756) | ○ |
| C-74 | UT-OPR-074: getInfoで未設定時null | E-01 (L755) | ○ |
| C-75 | UT-OPR-075: 未定義オプションでgetInfo | E-01 (L751-752) | ○ |
| C-76 | UT-OPR-076: setPrototypeでtrue設定 | E-01 (L765-778) | ○ |
| C-77 | UT-OPR-077: ロック中にsetPrototypeでAccessException | E-01 (L767-769) | ○ |
| C-78 | UT-OPR-078: ルート定義でsetPrototype(true)でAccessException | E-01 (L771-773) | ○ |
| C-79 | UT-OPR-079: isPrototypeでtrue | E-01 (L780-783) | ○ |
| C-80 | UT-OPR-080: isPrototypeでfalse | E-01 (L782) | ○ |
| C-81 | UT-OPR-081: removeで削除 | E-01 (L796-808) | ○ |
| C-82 | UT-OPR-082: removeで複数削除 | E-01 (L802) | ○ |
| C-83 | UT-OPR-083: removeで関連設定もクリア | E-01 (L803-804) | ○ |
| C-84 | UT-OPR-084: 未定義オプションのremoveが無視される | E-01 (L802-804) | ○ |
| C-85 | UT-OPR-085: ロック中にremoveでAccessException | E-01 (L798-800) | ○ |
| C-86 | UT-OPR-086: clearで全クリア | E-01 (L817-836) | ○ |
| C-87 | UT-OPR-087: ロック中にclearでAccessException | E-01 (L819-821) | ○ |
| C-88 | UT-OPR-088: resolveでデフォルト値解決 | E-01 (L858-907) | ○ |
| C-89 | UT-OPR-089: resolveでオプション上書き | E-01 (L878-886) | ○ |
| C-90 | UT-OPR-090: resolveで遅延評価 | E-01 (L949-963) | ○ |
| C-91 | UT-OPR-091: resolveでノーマライザ適用 | E-01 (L1110-1130) | ○ |
| C-92 | UT-OPR-092: resolveで未定義オプション拒否 | E-01 (L868-875) | ○ |
| C-93 | UT-OPR-093: resolveで必須オプション欠落 | E-01 (L889-895) | ○ |
| C-94 | UT-OPR-094: resolveで型検証エラー | E-01 (L1012-1034) | ○ |
| C-95 | UT-OPR-095: resolveで値検証エラー | E-01 (L1037-1080) | ○ |
| C-96 | UT-OPR-096: ロック中にresolveでAccessException | E-01 (L860-862) | ○ |
| C-97 | UT-OPR-097: resolveの複数回呼び出し | E-01 (L865, clone使用) | ○ |
| C-98 | UT-OPR-098: ネストオプション解決 | E-01 (L966-1009) | ○ |
| C-99 | UT-OPR-099: ネストオプションの非配列値 | E-01 (L972-973) | ○ |
| C-100 | UT-OPR-100: プロトタイプ配列解決 | E-01 (L991-1001) | △ |
| C-101 | UT-OPR-101: ignoreUndefined有効時 | E-01 (L868, L879-880) | ○ |
| C-102 | UT-OPR-102: 循環依存検出 | E-01 (L951-953) | ○ |
| C-103 | UT-OPR-103: 非推奨オプション警告 | E-01 (L1084-1107) | △ |
| C-104 | UT-OPR-104: 配列要素の型検証（正常） | E-01 (L1161-1172) | ○ |
| C-105 | UT-OPR-105: 配列要素の型検証（異常） | E-01 (L1161-1172, L1028-1030) | ○ |
| C-106 | UT-OPR-106: null型許可 | E-01 (L1174) | ○ |
| C-107 | UT-OPR-107: クラス名による型検証 | E-01 (L1174) | ○ |
| C-108 | UT-OPR-108: ノーマライザチェイン | E-01 (L1123-1125) | ○ |
| C-109 | UT-OPR-109: offsetGetのロック外アクセス防止 | E-01 (L924-926) | ○ |
| C-110 | UT-OPR-110: offsetGetで存在しないオプション | E-01 (L939-941) | ○ |
| C-111 | UT-OPR-111: offsetGetで値未設定オプション | E-01 (L943) | ○ |
| C-112 | UT-OPR-112: offsetExistsでtrue | E-01 (L1224-1231) | ○ |
| C-113 | UT-OPR-113: offsetExistsでfalse | E-01 (L1230) | ○ |
| C-114 | UT-OPR-114: offsetExistsのロック外アクセス防止 | E-01 (L1226-1228) | ○ |
| C-115 | UT-OPR-115: offsetSetで常にAccessException | E-01 (L1238-1241) | ○ |
| C-116 | UT-OPR-116: offsetUnsetで常にAccessException | E-01 (L1248-1251) | ○ |
| C-117 | UT-OPR-117: countでオプション数返却 | E-01 (L1262-1269) | ○ |
| C-118 | UT-OPR-118: countのロック外アクセス防止 | E-01 (L1264-1266) | ○ |
| C-119 | UT-OPR-119: setIgnoreUndefinedでtrue設定 | E-01 (L1276-1281) | ○ |
| C-120 | UT-OPR-120: setIgnoreUndefinedでfalseに戻す | E-01 (L1278) | ○ |
| C-121 | UT-OPR-121: OptionConfiguratorのコンストラクタ | E-02 (L18-23) | ○ |
| C-122 | UT-OPR-122: OptionConfigurator::allowedTypes | E-02 (L32-37) | ○ |
| C-123 | UT-OPR-123: OptionConfigurator::allowedValues | E-02 (L48-53) | ○ |
| C-124 | UT-OPR-124: OptionConfigurator::default | E-02 (L62-67) | ○ |
| C-125 | UT-OPR-125: OptionConfigurator::define | E-02 (L72-75) | ○ |
| C-126 | UT-OPR-126: OptionConfigurator::deprecated | E-02 (L86-91) | ○ |
| C-127 | UT-OPR-127: OptionConfigurator::normalize | E-02 (L100-105) | ○ |
| C-128 | UT-OPR-128: OptionConfigurator::required | E-02 (L114-119) | ○ |
| C-129 | UT-OPR-129: OptionConfigurator::info | E-02 (L128-133) | ○ |
| C-130 | UT-OPR-130: OptionConfigurator::ignoreUndefined | E-02 (L140-145) | ○ |
| C-131 | UT-OPR-131: OptionConfigurator::options | E-02 (L154-159) | ○ |
| C-132 | UT-OPR-132: OptionsResolverIntrospectorのコンストラクタ | E-04 (L27-41) | ○ |
| C-133 | UT-OPR-133: getDefaultで値取得 | E-04 (L46-49) | ○ |
| C-134 | UT-OPR-134: getDefaultで未定義オプション | E-04 (L31-33) | ○ |
| C-135 | UT-OPR-135: getDefaultでNoConfigurationException | E-04 (L35-37) | ○ |
| C-136 | UT-OPR-136: getLazyClosuresで取得 | E-04 (L56-59) | ○ |
| C-137 | UT-OPR-137: getLazyClosuresでNoConfigurationException | E-04 (L58) | ○ |
| C-138 | UT-OPR-138: getAllowedTypesで取得 | E-04 (L66-69) | ○ |
| C-139 | UT-OPR-139: getAllowedTypesでNoConfigurationException | E-04 (L68) | ○ |
| C-140 | UT-OPR-140: getAllowedValuesで取得 | E-04 (L76-79) | ○ |
| C-141 | UT-OPR-141: getAllowedValuesでNoConfigurationException | E-04 (L78) | ○ |
| C-142 | UT-OPR-142: getNormalizerで取得 | E-04 (L84-87) | ○ |
| C-143 | UT-OPR-143: getNormalizersで取得 | E-04 (L92-95) | ○ |
| C-144 | UT-OPR-144: getNormalizersでNoConfigurationException | E-04 (L94) | ○ |
| C-145 | UT-OPR-145: getDeprecationで取得 | E-04 (L100-103) | ○ |
| C-146 | UT-OPR-146: getDeprecationでNoConfigurationException | E-04 (L102) | ○ |
| C-147 | UT-OPR-147: getNestedOptionsで取得 | E-04 (L110-113) | ○ |
| C-148 | UT-OPR-148: getNestedOptionsでNoConfigurationException | E-04 (L112) | ○ |
| C-149 | UT-OPR-149: Optionsインターフェースの継承 | E-03 (L20) | ○ |
| C-150 | UT-OPR-150: AccessException継承 | E-06 (L20) | ○ |
| C-151 | UT-OPR-151: InvalidOptionsException継承 | E-07 (L21) | ○ |
| C-152 | UT-OPR-152: MissingOptionsException継承 | E-08 (L21) | ○ |
| C-153 | UT-OPR-153: UndefinedOptionsException継承 | E-09 (L22) | ○ |
| C-154 | UT-OPR-154: NoSuchOptionException継承 | E-10 (L24) | ○ |
| C-155 | UT-OPR-155: OptionDefinitionException継承 | E-11 (L19) | ○ |
| C-156 | UT-OPR-156: NoConfigurationException継承 | E-12 (L24) | ○ |
| C-157 | UT-OPR-157: InvalidArgumentException継承 | E-13 (L19) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-100（UT-OPR-100）：プロトタイプ配列の解決テストは、ネストオプション内部でsetPrototype(true)を呼び出すコンテキストが必要であり、外部APIからの設定方法について追加の検証が望ましい
  - 候補：既存のSymfonyテストスイート / OptionsResolver公式ドキュメント / Formコンポーネントの使用例
- C-103（UT-OPR-103）：trigger_deprecation関数の呼び出し確認は、モック化やPHPUnit expectDeprecation等のランタイムテスト手法に依存するため、静的コード解析のみでは完全な根拠を提示できない
  - 候補：PHPUnitのexpectDeprecation機能 / trigger_deprecationのモック化

## 5) リスクフラグ（レビュー観点）
- 0: resolve()メソッドの正常系テスト（C-88〜C-91）- 基本機能であり、コードから直接確認可能
- 0: 例外クラスの継承確認（C-150〜C-157）- コードから直接確認可能
- 1: プロトタイプ配列解決（C-100）- 複雑なネスト構造のため、テストケースの入力値・期待結果の正確性を要レビュー
- 1: trigger_deprecation発火確認（C-103）- ランタイム挙動のため、テスト手法の適切性を要レビュー
- 0: OptionConfiguratorのメソッド（C-121〜C-131）- 単純な委譲パターンであり、コードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] OptionsResolverの全publicメソッドに対してテストケースが存在するか確認
- [ ] 各メソッドの正常系・異常系・境界値が網羅されているか確認
- [ ] ロック中（resolve呼び出し中）のアクセス制御テストが全メソッドに対して存在するか確認
- [ ] ネストオプション・プロトタイプ配列のテストケースの入力値と期待結果が正確か確認
- [ ] OptionConfiguratorの各メソッドがOptionsResolverへの委譲を正しくテストしているか確認
- [ ] OptionsResolverIntrospectorの各getterメソッドに正常系・異常系テストがあるか確認
- [ ] 例外クラスの継承関係テストが全例外に対して存在するか確認
