---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 205
  claims_with_evidence: 199
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：Component-Process 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：199 / 205、根拠なし：6
- 優先レビュー（高）
  1. **UT-PRC-082 (setTty TTYモード)**: Unix環境・TTYサポートの前提条件がランタイム依存
  2. **UT-PRC-193 (UnixPipes ttyディスクリプタ)**: TTY/PTYモード関連の実行環境依存
  3. **UT-PRC-199〜205 (WindowsPipes)**: Windows固有の動作であり、実行環境依存の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Process/Process.php` - Processメインクラス（1700行）
- E-02: `src/Symfony/Component/Process/ExecutableFinder.php` - 実行ファイル検索クラス
- E-03: `src/Symfony/Component/Process/PhpExecutableFinder.php` - PHP実行ファイル検索クラス
- E-04: `src/Symfony/Component/Process/PhpProcess.php` - PHPスクリプト実行クラス
- E-05: `src/Symfony/Component/Process/PhpSubprocess.php` - PHPサブプロセスクラス
- E-06: `src/Symfony/Component/Process/InputStream.php` - 入力ストリームクラス
- E-07: `src/Symfony/Component/Process/ProcessUtils.php` - ユーティリティクラス
- E-08: `src/Symfony/Component/Process/Pipes/PipesInterface.php` - パイプインターフェース
- E-09: `src/Symfony/Component/Process/Pipes/AbstractPipes.php` - 抽象パイプクラス
- E-10: `src/Symfony/Component/Process/Pipes/UnixPipes.php` - Unixパイプ実装
- E-11: `src/Symfony/Component/Process/Pipes/WindowsPipes.php` - Windowsパイプ実装
- E-12: `src/Symfony/Component/Process/Messenger/RunProcessMessage.php` - メッセンジャーメッセージ
- E-13: `src/Symfony/Component/Process/Messenger/RunProcessMessageHandler.php` - メッセンジャーハンドラ
- E-14: `src/Symfony/Component/Process/Messenger/RunProcessContext.php` - メッセンジャーコンテキスト
- E-15: `src/Symfony/Component/Process/Exception/ProcessFailedException.php` - プロセス失敗例外
- E-16: `src/Symfony/Component/Process/Exception/ProcessSignaledException.php` - シグナル例外
- E-17: `src/Symfony/Component/Process/Exception/ProcessTimedOutException.php` - タイムアウト例外
- E-18: `src/Symfony/Component/Process/Exception/ProcessStartFailedException.php` - 起動失敗例外
- E-19: `src/Symfony/Component/Process/Exception/RunProcessFailedException.php` - 実行失敗例外

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Process::__constructでコマンド配列・cwd・env・input・timeoutを設定（UT-PRC-001〜008） | E-01 (L151-173) | ○ |
| C-02 | Process::fromShellCommandlineでシェルコマンド文字列からインスタンス生成（UT-PRC-009〜010） | E-01 (L197-203) | ○ |
| C-03 | Process::__serialize/__unserializeでBadMethodCallException（UT-PRC-011〜012） | E-01 (L205-213) | ○ |
| C-04 | Process::__cloneでresetProcessData呼出し（UT-PRC-013） | E-01 (L224-227) | ○ |
| C-05 | Process::runでstart+waitを実行し終了コード返却（UT-PRC-014〜015） | E-01 (L253-258) | ○ |
| C-06 | Process::mustRunで失敗時ProcessFailedException（UT-PRC-016〜017） | E-01 (L281-288) | ○ |
| C-07 | Process::startの実行中チェック・プロセス起動・ステータス更新（UT-PRC-018〜020） | E-01 (L310-407) | ○ |
| C-08 | Process::restartでclone+start（UT-PRC-021〜022） | E-01 (L425-435) | ○ |
| C-09 | Process::waitで終了待ち・未開始チェック（UT-PRC-023〜024） | E-01 (L453-483) | ○ |
| C-10 | Process::waitUntilでコールバック条件待ち（UT-PRC-025〜027） | E-01 (L499-532) | ○ |
| C-11 | Process::getOutput/getErrorOutputの出力取得・例外（UT-PRC-028〜034） | E-01 (L616-760) | ○ |
| C-12 | Process::clearOutput/clearErrorOutputのクリア動作（UT-PRC-035〜036） | E-01 (L712-773) | ○ |
| C-13 | Process::getExitCode/getExitCodeText/isSuccessfulの終了コード関連（UT-PRC-037〜043） | E-01 (L781-814) | ○ |
| C-14 | Process::isRunning/isStarted/isTerminated/getStatusのステータス判定（UT-PRC-044〜052） | E-01 (L880-919) | ○ |
| C-15 | Process::stopのプロセス停止動作（UT-PRC-053〜055） | E-01 (L929-956) | ○ |
| C-16 | Process::signalのシグナル送信（UT-PRC-056〜057） | E-01 (L555-560) | ○ |
| C-17 | Process::getPidのPID取得（UT-PRC-058〜059） | E-01 (L539-542) | ○ |
| C-18 | Process::disableOutput/enableOutput/isOutputDisabledの出力制御（UT-PRC-060〜065） | E-01 (L570-608) | ○ |
| C-19 | Process::setTimeout/getTimeoutのタイムアウト設定（UT-PRC-066〜069, 074） | E-01 (L1027-1031, L1005-1008) | ○ |
| C-20 | Process::setIdleTimeout/getIdleTimeoutのアイドルタイムアウト設定（UT-PRC-070〜073, 075） | E-01 (L1044-1053, L1013-1016) | ○ |
| C-21 | Process::checkTimeoutのタイムアウトチェック（UT-PRC-076〜079） | E-01 (L1196-1212) | ○ |
| C-22 | Process::getStartTimeの開始時刻取得（UT-PRC-080〜081） | E-01 (L1217-1224) | ○ |
| C-23 | Process::setTty/isTtyのTTYモード設定 - 環境依存（UT-PRC-082〜083） | E-01 (L1062-1083) | △ |
| C-24 | Process::setPty/isPtyのPTYモード設定（UT-PRC-084） | E-01 (L1090-1103) | ○ |
| C-25 | Process::getWorkingDirectory/setWorkingDirectoryの作業ディレクトリ（UT-PRC-085〜087） | E-01 (L1108-1129) | ○ |
| C-26 | Process::getEnv/setEnvの環境変数（UT-PRC-088〜089） | E-01 (L1136-1153) | ○ |
| C-27 | Process::getInput/setInputの入力設定（UT-PRC-090〜095） | E-01 (L1160-1185) | ○ |
| C-28 | Process::setOptionsのオプション設定（UT-PRC-096〜098） | E-01 (L1234-1250) | ○ |
| C-29 | Process::setIgnoredSignalsの無視シグナル設定（UT-PRC-099〜100） | E-01 (L1257-1264) | ○ |
| C-30 | Process::getCommandLineのコマンドライン取得（UT-PRC-101） | E-01 (L997-1000) | ○ |
| C-31 | Process::getLastOutputTimeの最終出力時刻（UT-PRC-102〜103） | E-01 (L989-992) | ○ |
| C-32 | Process::hasBeenSignaled/getTermSignalのシグナル関連（UT-PRC-104〜107） | E-01 (L823-847) | ○ |
| C-33 | Process::hasBeenStopped/getStopSignalの停止関連（UT-PRC-108〜111） | E-01 (L856-875) | ○ |
| C-34 | Process::getIteratorのイテレータ機能（UT-PRC-112〜115） | E-01 (L660-705) | ○ |
| C-35 | Process::buildCallbackのコールバック構築（UT-PRC-116〜117） | E-01 (L1321-1335) | ○ |
| C-36 | ExecutableFinder::findの実行ファイル検索（UT-PRC-118〜121） | E-02 (L58-102) | ○ |
| C-37 | ExecutableFinder::setSuffixes/addSuffixのサフィックス設定（UT-PRC-122〜123） | E-02 (L35-49) | ○ |
| C-38 | PhpExecutableFinder::findのPHP検索（UT-PRC-124〜126） | E-03 (L32-82) | ○ |
| C-39 | PhpExecutableFinder::findArgumentsのSAPI引数（UT-PRC-127） | E-03 (L89-97) | ○ |
| C-40 | PhpProcess::__constructのPHPプロセス生成（UT-PRC-128〜129） | E-04 (L37-53) | ○ |
| C-41 | PhpProcess::fromShellCommandlineのLogicException（UT-PRC-130） | E-04 (L55-58) | ○ |
| C-42 | PhpProcess::startのPHP実行ファイルチェック（UT-PRC-131） | E-04 (L64-71) | ○ |
| C-43 | PhpSubprocess::__constructのサブプロセス生成（UT-PRC-132〜133） | E-05 (L56-76) | ○ |
| C-44 | PhpSubprocess::fromShellCommandlineのLogicException（UT-PRC-134） | E-05 (L78-81) | ○ |
| C-45 | PhpSubprocess::startのPHP実行ファイルチェック（UT-PRC-135） | E-05 (L86-93) | ○ |
| C-46 | InputStream::write/close/isClosed/onEmpty/getIteratorの入力ストリーム（UT-PRC-136〜146） | E-06 (L23-91) | ○ |
| C-47 | ProcessUtils::validateInputの入力検証（UT-PRC-147〜156） | E-07 (L40-63) | ○ |
| C-48 | ProcessFailedException::__constructの例外生成（UT-PRC-157〜160） | E-15 (L23-52) | ○ |
| C-49 | ProcessSignaledException::__construct/getProcess/getSignal（UT-PRC-161〜163） | E-16 (L23-37) | ○ |
| C-50 | ProcessTimedOutException::__construct/isGeneralTimeout/isIdleTimeout/getExceededTimeout（UT-PRC-164〜171） | E-17 (L26-59) | ○ |
| C-51 | ProcessStartFailedException::__constructの起動失敗例外（UT-PRC-172〜174） | E-18 (L21-42) | ○ |
| C-52 | RunProcessFailedException::__constructの実行失敗例外（UT-PRC-175〜176） | E-19 (L21-24) | ○ |
| C-53 | RunProcessMessage::__construct/__toString/fromShellCommandline（UT-PRC-177〜180） | E-12 (L17-47) | ○ |
| C-54 | RunProcessMessageHandler::__invokeのハンドラ動作（UT-PRC-181〜183） | E-13 (L23-36) | ○ |
| C-55 | RunProcessContext::__constructのコンテキスト生成（UT-PRC-184〜186） | E-14 (L19-33) | ○ |
| C-56 | AbstractPipes::__construct/closeのパイプ基本動作（UT-PRC-187〜190） | E-09 (L34-51) | ○ |
| C-57 | UnixPipes::getDescriptors/getFiles/haveReadSupport/areOpenの動作（UT-PRC-191〜197） | E-10 (L25-143) | ○ |
| C-58 | UnixPipes TTYモード時のディスクリプタ - 環境依存（UT-PRC-193） | E-10 (L61-67) | △ |
| C-59 | UnixPipes/WindowsPipes::__serializeのシリアライズ禁止（UT-PRC-198, 205） | E-10 (L34-37), E-11 (L90-93) | ○ |
| C-60 | WindowsPipes::getDescriptors/getFiles/haveReadSupport/areOpen/closeの動作 - Windows環境依存（UT-PRC-199〜204） | E-11 (L27-185) | △ |

## 4) 不足情報（Unknown / Missing）
- **TTY/PTYサポート（C-23, C-58）**: setTtyのテストはUnix環境かつTTYサポートが必要。テスト実行環境によっては実行不可の可能性がある
  - 候補：CI環境のTTYサポート確認 / モック利用 / 環境スキップアノテーション
- **Windows固有動作（C-60）**: WindowsPipes関連のテストケースはWindows環境でのみ有効に検証可能
  - 候補：Windows CI環境での検証 / @requires OS条件付きテスト / モック利用
- **sigchild対応（Process内部）**: --enable-sigchild コンパイルオプションに依存する処理があるが、通常環境ではテスト困難
  - 候補：phpinfo出力のモック / 条件付きスキップ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Process基本操作（run, start, wait, getOutput等）のテストケースはソースコードと完全に一致
- 0: 低リスク - Exception系クラスのテストケースはコンストラクタロジックと完全に一致
- 0: 低リスク - ProcessUtils::validateInputのテストケースは全型分岐を網羅
- 1: 中リスク - TTY/PTY関連テストは実行環境に依存するため、テスト実行前に環境チェックが必要
- 1: 中リスク - WindowsPipes関連テストはWindows環境専用のため、クロスプラットフォームCI設定が必要
- 0: 低リスク - Messenger系のテストケースはシンプルなDTO/ハンドラパターンで根拠明確

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースのテストIDが連番で重複なくUT-PRC-001〜UT-PRC-205であること
- [ ] 対象ファイルパスがComponent-Processモジュール内のファイルを正しく指していること
- [ ] 正常系・異常系・境界値の各観点が主要メソッドに対して網羅されていること
- [ ] Process::setTimeout/setIdleTimeoutの境界値テスト（0, null, 負数）が含まれていること
- [ ] 出力無効化（disableOutput）状態でのgetOutput/getErrorOutput例外テストが含まれていること
- [ ] 未開始プロセスに対する各メソッド呼出し時のLogicExceptionテストが含まれていること
- [ ] ProcessUtils::validateInputの全型分岐（string, int, bool, resource, Iterator, Traversable, Process, null, object, array）が網羅されていること
- [ ] Exception系クラスのコンストラクタガード条件（成功プロセスでのProcessFailedException等）がテストされていること
- [ ] TTY/PTY/Windows依存テストに適切な備考・前提条件が記載されていること
