---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 116
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：Component-PropertyAccess 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：116 / 120、根拠なし：4
- 優先レビュー（高）
  1. **UT-PRA-083 (createCache APCu有効時)**: ApcuAdapter::isSupported()の振る舞いに依存し、実行環境に依存するテスト
  2. **UT-PRA-084 (createCache APCu無効時)**: 同上、環境依存テスト
  3. **UT-PRA-069 (adder/remover経由コレクション操作)**: writeCollectionメソッドの内部動作で、モック対象の外部インターフェース挙動の確認が必要
  4. **UT-PRA-072 (DateTime自動変換)**: DateTime/DateTimeImmutable間の変換ロジックの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/PropertyAccess/PropertyPath.php` - PropertyPathクラスのソースコード（__construct, __toString, getLength, getParent, getElements, getElement, isProperty, isIndex, isNullSafe）
- E-02: `src/Symfony/Component/PropertyAccess/PropertyPathBuilder.php` - PropertyPathBuilderクラスのソースコード（append, appendIndex, appendProperty, remove, replace, replaceByIndex, replaceByProperty, getLength, getPropertyPath, __toString）
- E-03: `src/Symfony/Component/PropertyAccess/PropertyAccessor.php` - PropertyAccessorクラスのソースコード（getValue, setValue, isReadable, isWritable, readPropertiesUntil, readIndex, readProperty, writeIndex, writeProperty, writeCollection, getReadInfo, getWriteInfo, isPropertyWritable, getPropertyPath, createCache）
- E-04: `src/Symfony/Component/PropertyAccess/PropertyAccessorBuilder.php` - PropertyAccessorBuilderクラスのソースコード（enable/disable各種メソッド、getter/setter、getPropertyAccessor）
- E-05: `src/Symfony/Component/PropertyAccess/PropertyAccess.php` - PropertyAccessファクトリクラスのソースコード（createPropertyAccessor, createPropertyAccessorBuilder）
- E-06: `src/Symfony/Component/PropertyAccess/PropertyPathIterator.php` - PropertyPathIteratorクラスのソースコード（isIndex, isProperty）
- E-07: `src/Symfony/Component/PropertyAccess/PropertyAccessorInterface.php` - PropertyAccessorInterfaceのインターフェース定義（setValue, getValue, isWritable, isReadable）
- E-08: `src/Symfony/Component/PropertyAccess/PropertyPathInterface.php` - PropertyPathInterfaceのインターフェース定義（__toString, getLength, getParent, getElements, getElement, isProperty, isIndex, isNullSafe）
- E-09: `src/Symfony/Component/PropertyAccess/PropertyPathIteratorInterface.php` - PropertyPathIteratorInterfaceのインターフェース定義（isIndex, isProperty）
- E-10: `src/Symfony/Component/PropertyAccess/Exception/InvalidTypeException.php` - InvalidTypeExceptionクラスのソースコード
- E-11: `src/Symfony/Component/PropertyAccess/Exception/UnexpectedTypeException.php` - UnexpectedTypeExceptionクラスのソースコード
- E-12: `src/Symfony/Component/PropertyAccess/Exception/NoSuchPropertyException.php` - NoSuchPropertyExceptionクラス定義
- E-13: `src/Symfony/Component/PropertyAccess/Exception/NoSuchIndexException.php` - NoSuchIndexExceptionクラス定義
- E-14: `src/Symfony/Component/PropertyAccess/Exception/AccessException.php` - AccessExceptionクラス定義
- E-15: `src/Symfony/Component/PropertyAccess/Exception/UninitializedPropertyException.php` - UninitializedPropertyExceptionクラス定義
- E-16: `src/Symfony/Component/PropertyAccess/Exception/InvalidPropertyPathException.php` - InvalidPropertyPathExceptionクラス定義
- E-17: `src/Symfony/Component/PropertyAccess/Exception/OutOfBoundsException.php` - OutOfBoundsExceptionクラス定義
- E-18: `src/Symfony/Component/PropertyAccess/Exception/RuntimeException.php` - RuntimeExceptionクラス定義
- E-19: `src/Symfony/Component/PropertyAccess/Exception/InvalidArgumentException.php` - InvalidArgumentExceptionクラス定義
- E-20: `src/Symfony/Component/PropertyAccess/Exception/ExceptionInterface.php` - ExceptionInterfaceインターフェース定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-PRA-001: 単一プロパティパスの正常パース | E-01 (PropertyPath::__construct, L71-128) | ○ |
| C-02 | UT-PRA-002: ドット区切りネストパスの正常パース | E-01 (PropertyPath::__construct, L93-121 のパターンマッチ) | ○ |
| C-03 | UT-PRA-003: インデックスアクセスパスのパース | E-01 (PropertyPath::__construct, L99-101 の角括弧マッチ) | ○ |
| C-04 | UT-PRA-004: プロパティとインデックス混合パース | E-01 (PropertyPath::__construct, L93-121) | ○ |
| C-05 | UT-PRA-005: null-safeパースの動作 | E-01 (PropertyPath::__construct, L105-110 のnullSafe処理) | ○ |
| C-06 | UT-PRA-006: コピーコンストラクタの動作 | E-01 (PropertyPath::__construct, L74-81) | ○ |
| C-07 | UT-PRA-007: エスケープされたドットのパース | E-01 (PropertyPath::__construct, L112 preg_replace) | ○ |
| C-08 | UT-PRA-008: エスケープされた角括弧のパース | E-01 (PropertyPath::__construct, L112 preg_replace) | ○ |
| C-09 | UT-PRA-009: 空文字列でInvalidPropertyPathException | E-01 (PropertyPath::__construct, L84-86) | ○ |
| C-10 | UT-PRA-010: 不正構文でInvalidPropertyPathException | E-01 (PropertyPath::__construct, L123-125) | ○ |
| C-11 | UT-PRA-011: __toStringの正常動作 | E-01 (PropertyPath::__toString, L130-133) | ○ |
| C-12 | UT-PRA-012: getLengthの正常動作 | E-01 (PropertyPath::getLength, L135-138) | ○ |
| C-13 | UT-PRA-013: getParentの正常動作 | E-01 (PropertyPath::getParent, L140-155) | ○ |
| C-14 | UT-PRA-014: getParentで長さ1の場合null | E-01 (PropertyPath::getParent, L142-143) | ○ |
| C-15 | UT-PRA-015: getParentでインデックス含むパス | E-01 (PropertyPath::getParent, L149 strrpos) | ○ |
| C-16 | UT-PRA-016: getIteratorの戻り値型 | E-01 (PropertyPath::getIterator, L160-163), E-06 | ○ |
| C-17 | UT-PRA-017: getElementsの正常動作 | E-01 (PropertyPath::getElements, L165-168) | ○ |
| C-18 | UT-PRA-018: getElementの正常動作 | E-01 (PropertyPath::getElement, L170-177) | ○ |
| C-19 | UT-PRA-019: getElementの範囲外でOutOfBoundsException | E-01 (PropertyPath::getElement, L172-173), E-17 | ○ |
| C-20 | UT-PRA-020: isPropertyの正常判定(true) | E-01 (PropertyPath::isProperty, L179-186) | ○ |
| C-21 | UT-PRA-021: isPropertyの正常判定(false) | E-01 (PropertyPath::isProperty, L185) | ○ |
| C-22 | UT-PRA-022: isPropertyの範囲外でOutOfBoundsException | E-01 (PropertyPath::isProperty, L181-183), E-17 | ○ |
| C-23 | UT-PRA-023: isIndexの正常判定(true) | E-01 (PropertyPath::isIndex, L188-195) | ○ |
| C-24 | UT-PRA-024: isIndexの正常判定(false) | E-01 (PropertyPath::isIndex, L194) | ○ |
| C-25 | UT-PRA-025: isIndexの範囲外でOutOfBoundsException | E-01 (PropertyPath::isIndex, L190-192), E-17 | ○ |
| C-26 | UT-PRA-026: isNullSafeの正常判定(true) | E-01 (PropertyPath::isNullSafe, L197-204) | ○ |
| C-27 | UT-PRA-027: isNullSafeの正常判定(false) | E-01 (PropertyPath::isNullSafe, L203) | ○ |
| C-28 | UT-PRA-028: isNullSafeの範囲外でOutOfBoundsException | E-01 (PropertyPath::isNullSafe, L199-201), E-17 | ○ |
| C-29 | UT-PRA-029: PropertyPathBuilderの文字列初期化 | E-02 (PropertyPathBuilder::__construct, L24-29) | ○ |
| C-30 | UT-PRA-030: PropertyPathInterfaceでの初期化 | E-02 (PropertyPathBuilder::__construct, L24-29) | ○ |
| C-31 | UT-PRA-031: null初期化で空ビルダー | E-02 (PropertyPathBuilder::__construct, L26条件分岐) | ○ |
| C-32 | UT-PRA-032: appendの正常動作 | E-02 (PropertyPathBuilder::append, L37-53) | ○ |
| C-33 | UT-PRA-033: appendのサブパス追加 | E-02 (PropertyPathBuilder::append, L43-52) | ○ |
| C-34 | UT-PRA-034: appendIndexの正常動作 | E-02 (PropertyPathBuilder::appendIndex, L58-62) | ○ |
| C-35 | UT-PRA-035: appendPropertyの正常動作 | E-02 (PropertyPathBuilder::appendProperty, L67-71) | ○ |
| C-36 | UT-PRA-036: removeの正常動作 | E-02 (PropertyPathBuilder::remove, L78-85) | ○ |
| C-37 | UT-PRA-037: removeの範囲外でOutOfBoundsException | E-02 (PropertyPathBuilder::remove, L80-81), E-17 | ○ |
| C-38 | UT-PRA-038: replaceの正常動作 | E-02 (PropertyPathBuilder::replace, L95-118) | ○ |
| C-39 | UT-PRA-039: replaceの負オフセット | E-02 (PropertyPathBuilder::replace, L101-102) | ○ |
| C-40 | UT-PRA-040: replaceの範囲外でOutOfBoundsException | E-02 (PropertyPathBuilder::replace, L103-104), E-17 | ○ |
| C-41 | UT-PRA-041: replaceByIndexの正常動作 | E-02 (PropertyPathBuilder::replaceByIndex, L125-136) | ○ |
| C-42 | UT-PRA-042: replaceByIndexの名前変更付き | E-02 (PropertyPathBuilder::replaceByIndex, L131-133) | ○ |
| C-43 | UT-PRA-043: replaceByIndexの範囲外 | E-02 (PropertyPathBuilder::replaceByIndex, L127-129), E-17 | ○ |
| C-44 | UT-PRA-044: replaceByPropertyの正常動作 | E-02 (PropertyPathBuilder::replaceByProperty, L143-154) | ○ |
| C-45 | UT-PRA-045: replaceByPropertyの名前変更付き | E-02 (PropertyPathBuilder::replaceByProperty, L149-151) | ○ |
| C-46 | UT-PRA-046: replaceByPropertyの範囲外 | E-02 (PropertyPathBuilder::replaceByProperty, L145-147), E-17 | ○ |
| C-47 | UT-PRA-047: getLengthの正常動作 | E-02 (PropertyPathBuilder::getLength, L159-162) | ○ |
| C-48 | UT-PRA-048: 空ビルダーでgetLength=0 | E-02 (PropertyPathBuilder::getLength, L161) | ○ |
| C-49 | UT-PRA-049: getPropertyPathの正常動作 | E-02 (PropertyPathBuilder::getPropertyPath, L167-172) | ○ |
| C-50 | UT-PRA-050: 空ビルダーでgetPropertyPath=null | E-02 (PropertyPathBuilder::getPropertyPath, L171) | ○ |
| C-51 | UT-PRA-051: __toStringのプロパティ/インデックス混合 | E-02 (PropertyPathBuilder::__toString, L177-192) | ○ |
| C-52 | UT-PRA-052: PropertyAccessorデフォルトコンストラクタ | E-03 (PropertyAccessor::__construct, L81-93) | ○ |
| C-53 | UT-PRA-053: PropertyAccessorカスタムコンストラクタ | E-03 (PropertyAccessor::__construct, L81-93) | ○ |
| C-54 | UT-PRA-054: getValueでオブジェクトプロパティ読み取り | E-03 (PropertyAccessor::getValue, L95-110), E-03 (readProperty, L383-465) | ○ |
| C-55 | UT-PRA-055: getValueでgetterメソッド経由読み取り | E-03 (readProperty, L399-415) | ○ |
| C-56 | UT-PRA-056: getValueで配列インデックスアクセス | E-03 (getValue, L105-109), E-03 (readIndex, L355-376) | ○ |
| C-57 | UT-PRA-057: getValueでネストアクセス | E-03 (readPropertiesUntil, L278-348) | ○ |
| C-58 | UT-PRA-058: getValueでstdClass読み取り | E-03 (getValue, L101-102) | ○ |
| C-59 | UT-PRA-059: getValueでnull-safeアクセス | E-03 (readPropertiesUntil, L290, L320-324, L342-344) | ○ |
| C-60 | UT-PRA-060: getValueで存在しないプロパティ例外 | E-03 (readProperty, L455-456), E-12 | ○ |
| C-61 | UT-PRA-061: getValueでパス途中のスカラー値 | E-03 (readPropertiesUntil, L327-329), E-11 | ○ |
| C-62 | UT-PRA-062: getValueで存在しないインデックス例外 | E-03 (readPropertiesUntil, L297-307), E-13 | ○ |
| C-63 | UT-PRA-063: getValueで無効インデックス無視 | E-03 (readPropertiesUntil, L293-317) | ○ |
| C-64 | UT-PRA-064: getValueでArrayAccessオブジェクト読み取り | E-03 (readIndex, L363-364) | ○ |
| C-65 | UT-PRA-065: setValueでオブジェクトプロパティ書き込み | E-03 (setValue, L112-188), E-03 (writeProperty, L517-559) | ○ |
| C-66 | UT-PRA-066: setValueでsetterメソッド経由書き込み | E-03 (writeProperty, L531-532) | ○ |
| C-67 | UT-PRA-067: setValueで配列インデックス書き込み | E-03 (writeIndex, L503-510) | ○ |
| C-68 | UT-PRA-068: setValueでネスト書き込み | E-03 (setValue, L136-188) | ○ |
| C-69 | UT-PRA-069: setValueでadder/remover経由コレクション操作 | E-03 (writeProperty, L535-536, writeCollection, L564-595) | △ |
| C-70 | UT-PRA-070: setValueで存在しないプロパティ例外 | E-03 (writeProperty, L540-545), E-12 | ○ |
| C-71 | UT-PRA-071: setValueで型不一致例外 | E-03 (throwInvalidArgumentException, L190-205), E-10 | ○ |
| C-72 | UT-PRA-072: setValueでDateTime自動変換 | E-03 (writeProperty, L547-558) | △ |
| C-73 | UT-PRA-073: setValueでstdClass書き込み | E-03 (writeProperty, L538-539) | ○ |
| C-74 | UT-PRA-074: isReadableでtrue判定 | E-03 (isReadable, L207-229) | ○ |
| C-75 | UT-PRA-075: isReadableでfalse判定 | E-03 (isReadable, L226-228) | ○ |
| C-76 | UT-PRA-076: isReadableで配列インデックス判定 | E-03 (isReadable, L222) | ○ |
| C-77 | UT-PRA-077: isReadableでstdClassドット付きプロパティ | E-03 (isReadable, L219-220) | ○ |
| C-78 | UT-PRA-078: isWritableでtrue判定 | E-03 (isWritable, L231-270) | ○ |
| C-79 | UT-PRA-079: isWritableでfalse判定 | E-03 (isWritable, L257-258), E-03 (isPropertyWritable, L630-648) | ○ |
| C-80 | UT-PRA-080: isWritableで配列インデックス判定 | E-03 (isWritable, L253-255) | ○ |
| C-81 | UT-PRA-081: isWritableでArrayAccessインデックス判定 | E-03 (isWritable, L254) | ○ |
| C-82 | UT-PRA-082: isWritableでstdClassドット付きプロパティ | E-03 (isWritable, L241-245) | ○ |
| C-83 | UT-PRA-083: createCacheでAPCu有効時 | E-03 (createCache, L685-703) | △ |
| C-84 | UT-PRA-084: createCacheでAPCu無効時 | E-03 (createCache, L691-692) | △ |
| C-85 | UT-PRA-085: enableMagicMethodsの動作 | E-04 (enableMagicMethods, L37-42) | ○ |
| C-86 | UT-PRA-086: disableMagicMethodsの動作 | E-04 (disableMagicMethods, L49-54) | ○ |
| C-87 | UT-PRA-087: enableMagicCallの動作 | E-04 (enableMagicCall, L61-66) | ○ |
| C-88 | UT-PRA-088: enableMagicGetの動作 | E-04 (enableMagicGet, L71-76) | ○ |
| C-89 | UT-PRA-089: enableMagicSetの動作 | E-04 (enableMagicSet, L83-88) | ○ |
| C-90 | UT-PRA-090: disableMagicCallの動作 | E-04 (disableMagicCall, L95-100) | ○ |
| C-91 | UT-PRA-091: disableMagicGetの動作 | E-04 (disableMagicGet, L107-112) | ○ |
| C-92 | UT-PRA-092: disableMagicSetの動作 | E-04 (disableMagicSet, L119-124) | ○ |
| C-93 | UT-PRA-093: enableExceptionOnInvalidIndexの動作 | E-04 (enableExceptionOnInvalidIndex, L158-163) | ○ |
| C-94 | UT-PRA-094: disableExceptionOnInvalidIndexの動作 | E-04 (disableExceptionOnInvalidIndex, L172-177) | ○ |
| C-95 | UT-PRA-095: enableExceptionOnInvalidPropertyPathの動作 | E-04 (enableExceptionOnInvalidPropertyPath, L195-200) | ○ |
| C-96 | UT-PRA-096: disableExceptionOnInvalidPropertyPathの動作 | E-04 (disableExceptionOnInvalidPropertyPath, L209-214) | ○ |
| C-97 | UT-PRA-097: setCacheItemPoolの動作 | E-04 (setCacheItemPool, L229-234) | ○ |
| C-98 | UT-PRA-098: setCacheItemPoolでnull設定 | E-04 (setCacheItemPool, L229-234) | ○ |
| C-99 | UT-PRA-099: setReadInfoExtractorの動作 | E-04 (setReadInfoExtractor, L247-252) | ○ |
| C-100 | UT-PRA-100: setWriteInfoExtractorの動作 | E-04 (setWriteInfoExtractor, L262-267) | ○ |
| C-101 | UT-PRA-101: getPropertyAccessorで設定反映 | E-04 (getPropertyAccessor, L277-290) | ○ |
| C-102 | UT-PRA-102: getPropertyAccessorでデフォルトビルド | E-04 (getPropertyAccessor, L277-290) | ○ |
| C-103 | UT-PRA-103: fluentインターフェース確認 | E-04 (enableMagicMethods, L41 return $this) | ○ |
| C-104 | UT-PRA-104: createPropertyAccessorファクトリ | E-05 (createPropertyAccessor, L24-27) | ○ |
| C-105 | UT-PRA-105: createPropertyAccessorBuilderファクトリ | E-05 (createPropertyAccessorBuilder, L29-32) | ○ |
| C-106 | UT-PRA-106: PropertyPathIteratorの初期化 | E-06 (PropertyPathIterator::__construct, L24-28) | ○ |
| C-107 | UT-PRA-107: PropertyPathIterator::isIndexでtrue | E-06 (PropertyPathIterator::isIndex, L30-33) | ○ |
| C-108 | UT-PRA-108: PropertyPathIterator::isIndexでfalse | E-06 (PropertyPathIterator::isIndex, L30-33) | ○ |
| C-109 | UT-PRA-109: PropertyPathIterator::isPropertyでtrue | E-06 (PropertyPathIterator::isProperty, L35-38) | ○ |
| C-110 | UT-PRA-110: PropertyPathIterator::isPropertyでfalse | E-06 (PropertyPathIterator::isProperty, L35-38) | ○ |
| C-111 | UT-PRA-111: InvalidTypeExceptionメッセージ生成 | E-10 (InvalidTypeException::__construct, L21-31) | ○ |
| C-112 | UT-PRA-112: InvalidTypeExceptionでNULL表示正規化 | E-10 (InvalidTypeException::__construct, L28 'NULL'条件) | ○ |
| C-113 | UT-PRA-113: InvalidTypeExceptionのreadonly確認 | E-10 (InvalidTypeException, L22-24 readonly宣言) | ○ |
| C-114 | UT-PRA-114: UnexpectedTypeExceptionメッセージ生成 | E-11 (UnexpectedTypeException::__construct, L27-38) | ○ |
| C-115 | UT-PRA-115: ネスト配列インデックスアクセス | E-03 (readPropertiesUntil + readIndex) | ○ |
| C-116 | UT-PRA-116: 配列へのプロパティアクセス例外 | E-03 (readProperty, L385-387) | ○ |
| C-117 | UT-PRA-117: 配列へのプロパティ書き込み例外 | E-03 (writeProperty, L519-521) | ○ |
| C-118 | UT-PRA-118: PropertyPathInterfaceによるアクセス | E-03 (getValue, L105, getPropertyPath, L653-678) | ○ |
| C-119 | UT-PRA-119: 未初期化プロパティ例外 | E-03 (readProperty, L438-444), E-15 | ○ |
| C-120 | UT-PRA-120: 非配列へのインデックス書き込み判定 | E-03 (isWritable, L254-256) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-PRA-069**: writeCollectionメソッドのadder/removerパターンは、外部のPropertyWriteInfoに依存する複雑なテストケース。モック対象となるオブジェクトの具体的なインターフェース仕様の詳細が根拠として不足。
  - 候補：Symfonyドキュメントのコレクションアクセサパターン / PropertyInfoコンポーネントの仕様書
- **UT-PRA-072**: DateTime/DateTimeImmutable間の自動変換ロジックは実装上の特殊ケース。変換後の再帰呼び出しの挙動について追加の根拠が望ましい。
  - 候補：Symfony公式ドキュメント / PHPマニュアルのDateTime変換仕様
- **UT-PRA-083/084**: APCuアダプタの利用可否判定は実行環境に依存し、テスト環境での再現が困難。
  - 候補：PHP APCu拡張の仕様ドキュメント / Symfony Cacheコンポーネントのドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: PropertyPath / PropertyPathBuilder / PropertyAccessorBuilderのテストケース（低リスク - ソースコードから直接導出可能）
- 1: PropertyAccessorのgetValue/setValue/isReadable/isWritableのテストケース（中リスク - 外部依存あるがソースコードで確認可能）
- 2: createCacheのテストケース（高リスク - 実行環境依存、APCuの有無で動作が異なる）

## 6) レビュアーチェックリスト（最小）
- [ ] PropertyPath::__constructのパース処理に関するテストケース（UT-PRA-001〜010）が全ての分岐パターンを網羅しているか確認
- [ ] PropertyAccessor::getValue/setValueの正常系/異常系テストケースが実際のユースケースを十分カバーしているか確認
- [ ] null-safeアクセス（UT-PRA-005, 059）のテストケースがSymfony 8.1の仕様に合致しているか確認
- [ ] PropertyAccessorBuilder各メソッドのfluentインターフェースが全て検証されているか確認
- [ ] writeCollectionのadder/removerパターン（UT-PRA-069）のテスト前提条件が十分具体的か確認
- [ ] 例外クラスのメッセージフォーマットテスト（UT-PRA-111〜114）が最新のソースコードと一致しているか確認
