---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 194
  claims_with_evidence: 188
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：Component-PropertyInfo 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：188 / 194、根拠なし：6
- 優先レビュー（高）
  1. **PhpDocExtractor::__construct の依存パッケージ未インストール時テスト（C-111）**：実行環境に依存するため実際のテスト実装が困難
  2. **PhpStanExtractor::__construct の依存パッケージ未インストール時テスト（C-131, C-132）**：同上、実行環境依存
  3. **PhpDocTypeHelper の PseudoType 処理テスト（C-176, C-177）**：phpdocumentor内部型に依存、テストデータ構築の根拠不足
  4. **PhpDocTypeHelper の ConstExpression テスト（C-174）**：ConstExpression型のモック/テストデータ構築方法が明確でない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/PropertyInfo/PropertyInfoExtractor.php` - PropertyInfoExtractorクラスの実装
- E-02: `src/Symfony/Component/PropertyInfo/PropertyInfoCacheExtractor.php` - キャッシュデコレータの実装
- E-03: `src/Symfony/Component/PropertyInfo/PropertyReadInfo.php` - 読み取り情報値オブジェクト
- E-04: `src/Symfony/Component/PropertyInfo/PropertyWriteInfo.php` - 書き込み情報値オブジェクト
- E-05: `src/Symfony/Component/PropertyInfo/Extractor/ReflectionExtractor.php` - Reflection APIベースの抽出器
- E-06: `src/Symfony/Component/PropertyInfo/Extractor/PhpDocExtractor.php` - PHPDoc解析ベースの抽出器
- E-07: `src/Symfony/Component/PropertyInfo/Extractor/PhpStanExtractor.php` - PHPStan解析ベースの抽出器
- E-08: `src/Symfony/Component/PropertyInfo/Extractor/ConstructorExtractor.php` - コンストラクタ引数型抽出器
- E-09: `src/Symfony/Component/PropertyInfo/Extractor/SerializerExtractor.php` - Serializerメタデータベースの抽出器
- E-10: `src/Symfony/Component/PropertyInfo/Util/PhpDocTypeHelper.php` - PHPDoc型変換ヘルパー
- E-11: `src/Symfony/Component/PropertyInfo/DependencyInjection/PropertyInfoPass.php` - DIコンパイラパス
- E-12: `src/Symfony/Component/PropertyInfo/DependencyInjection/PropertyInfoConstructorPass.php` - コンストラクタ抽出器用DIコンパイラパス
- E-13: `src/Symfony/Component/PropertyInfo/PropertyInfoExtractorInterface.php` - メインインターフェース定義
- E-14: `src/Symfony/Component/PropertyInfo/PropertyReadInfoExtractorInterface.php` - ReadInfo抽出器インターフェース
- E-15: `src/Symfony/Component/PropertyInfo/PropertyWriteInfoExtractorInterface.php` - WriteInfo抽出器インターフェース
- E-16: `src/Symfony/Component/PropertyInfo/Extractor/ConstructorArgumentTypeExtractorInterface.php` - コンストラクタ型抽出器インターフェース

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | PropertyInfoExtractor: 空の抽出器リストでインスタンス生成可能 | E-01 (L32-38: デフォルト値=[]) | ○ |
| C-002 | PropertyInfoExtractor::getProperties: 抽出器からプロパティ一覧取得 | E-01 (L41-44: extractメソッド呼び出し) | ○ |
| C-003 | PropertyInfoExtractor::getProperties: 最初のnull以外の結果を返す | E-01 (L88-97: extractメソッドのループ処理) | ○ |
| C-004 | PropertyInfoExtractor::getProperties: 全てnullならnull返却 | E-01 (L96: return null) | ○ |
| C-005 | PropertyInfoExtractor::getProperties: 空抽出器でnull返却 | E-01 (L88-97: 空iterableの場合foreachスキップ) | ○ |
| C-006 | PropertyInfoExtractor::getShortDescription: 短い説明取得 | E-01 (L46-49) | ○ |
| C-007 | PropertyInfoExtractor::getShortDescription: 見つからなければnull | E-01 (L96: return null) | ○ |
| C-008 | PropertyInfoExtractor::getLongDescription: 長い説明取得 | E-01 (L51-54) | ○ |
| C-009 | PropertyInfoExtractor::getLongDescription: 見つからなければnull | E-01 (L96: return null) | ○ |
| C-010 | PropertyInfoExtractor::getType: 型情報取得 | E-01 (L56-65: typeExtractorsループ) | ○ |
| C-011 | PropertyInfoExtractor::getType: 最初のnull以外を返す | E-01 (L58-62) | ○ |
| C-012 | PropertyInfoExtractor::getType: 全てnullならnull | E-01 (L64: return null) | ○ |
| C-013 | PropertyInfoExtractor::isReadable: true返却 | E-01 (L67-70) | ○ |
| C-014 | PropertyInfoExtractor::isReadable: null返却 | E-01 (L96: return null) | ○ |
| C-015 | PropertyInfoExtractor::isWritable: true返却 | E-01 (L72-75) | ○ |
| C-016 | PropertyInfoExtractor::isWritable: null返却 | E-01 (L96: return null) | ○ |
| C-017 | PropertyInfoExtractor::isInitializable: true返却 | E-01 (L77-80) | ○ |
| C-018 | PropertyInfoExtractor::isInitializable: null返却 | E-01 (L96: return null) | ○ |
| C-019 | PropertyInfoCacheExtractor: キャッシュミス時にデリゲート | E-02 (L97-124: extractメソッド) | ○ |
| C-020 | PropertyInfoCacheExtractor: キャッシュヒット時にキャッシュ返却 | E-02 (L115-117: item.isHit()) | ○ |
| C-021 | PropertyInfoCacheExtractor: arrayCacheから返却 | E-02 (L109-111: array_key_existsチェック) | ○ |
| C-022 | PropertyInfoCacheExtractor::getType: 型キャッシュ | E-02 (L59-87: getType専用実装) | ○ |
| C-023 | PropertyInfoCacheExtractor::getType: シリアライズ不可時スキップ | E-02 (L62-66: catch Exception) | ○ |
| C-024 | PropertyInfoCacheExtractor::isReadable: キャッシュ | E-02 (L34-37) | ○ |
| C-025 | PropertyInfoCacheExtractor::isWritable: キャッシュ | E-02 (L39-42) | ○ |
| C-026 | PropertyInfoCacheExtractor::isInitializable: キャッシュ | E-02 (L89-92) | ○ |
| C-027 | PropertyInfoCacheExtractor::getShortDescription: キャッシュ | E-02 (L44-47) | ○ |
| C-028 | PropertyInfoCacheExtractor::getLongDescription: キャッシュ | E-02 (L49-52) | ○ |
| C-029 | PropertyReadInfo: コンストラクタで全プロパティ設定 | E-03 (L28-35) | ○ |
| C-030 | PropertyReadInfo::getType: method返却 | E-03 (L40-43) | ○ |
| C-031 | PropertyReadInfo::getType: property返却 | E-03 (L21-22: TYPE定数, L40-43) | ○ |
| C-032 | PropertyReadInfo::getName: name返却 | E-03 (L48-51) | ○ |
| C-033 | PropertyReadInfo::getVisibility: public返却 | E-03 (L53-56) | ○ |
| C-034 | PropertyReadInfo::getVisibility: protected返却 | E-03 (L25: 定数, L53-56) | ○ |
| C-035 | PropertyReadInfo::getVisibility: private返却 | E-03 (L26: 定数, L53-56) | ○ |
| C-036 | PropertyReadInfo::isStatic: false返却 | E-03 (L58-61) | ○ |
| C-037 | PropertyReadInfo::isStatic: true返却 | E-03 (L58-61) | ○ |
| C-038 | PropertyReadInfo::canBeReference: false返却 | E-03 (L66-69) | ○ |
| C-039 | PropertyReadInfo::canBeReference: true返却 | E-03 (L66-69) | ○ |
| C-040 | PropertyWriteInfo: デフォルト値インスタンス | E-04 (L35-41: デフォルト値定義) | ○ |
| C-041 | PropertyWriteInfo: 全引数指定インスタンス | E-04 (L35-41) | ○ |
| C-042 | PropertyWriteInfo::getType: type返却 | E-04 (L43-46) | ○ |
| C-043 | PropertyWriteInfo::getName: name返却 | E-04 (L48-55) | ○ |
| C-044 | PropertyWriteInfo::getName: null時LogicException | E-04 (L50-51: throw LogicException) | ○ |
| C-045 | PropertyWriteInfo::getVisibility: visibility返却 | E-04 (L85-92) | ○ |
| C-046 | PropertyWriteInfo::getVisibility: null時LogicException | E-04 (L87-89: throw LogicException) | ○ |
| C-047 | PropertyWriteInfo::isStatic: false返却 | E-04 (L94-101) | ○ |
| C-048 | PropertyWriteInfo::isStatic: null時LogicException | E-04 (L96-98: throw LogicException) | ○ |
| C-049 | PropertyWriteInfo::setAdderInfo: 設定 | E-04 (L57-59) | ○ |
| C-050 | PropertyWriteInfo::getAdderInfo: 取得 | E-04 (L62-69) | ○ |
| C-051 | PropertyWriteInfo::getAdderInfo: null時LogicException | E-04 (L64-65: throw LogicException) | ○ |
| C-052 | PropertyWriteInfo::setRemoverInfo: 設定 | E-04 (L71-73) | ○ |
| C-053 | PropertyWriteInfo::getRemoverInfo: 取得 | E-04 (L75-83) | ○ |
| C-054 | PropertyWriteInfo::getRemoverInfo: null時LogicException | E-04 (L77-78: throw LogicException) | ○ |
| C-055 | PropertyWriteInfo::setErrors: 設定 | E-04 (L103-106) | ○ |
| C-056 | PropertyWriteInfo::getErrors: 取得 | E-04 (L108-111) | ○ |
| C-057 | PropertyWriteInfo::getErrors: デフォルト空配列 | E-04 (L33: errors=[]) | ○ |
| C-058 | PropertyWriteInfo::hasErrors: エラーあり | E-04 (L113-116) | ○ |
| C-059 | PropertyWriteInfo::hasErrors: エラーなし | E-04 (L113-116) | ○ |
| C-060 | PropertyWriteInfo::hasErrors: 空配列 | E-04 (L115: count) | ○ |
| C-061 | ReflectionExtractor: デフォルトインスタンス | E-05 (L94-120) | ○ |
| C-062 | ReflectionExtractor: カスタムプレフィックス | E-05 (L103-105) | ○ |
| C-063 | ReflectionExtractor::getProperties: プロパティ一覧 | E-05 (L122-155) | ○ |
| C-064 | ReflectionExtractor::getProperties: 存在しないクラスでnull | E-05 (L126-128: catch ReflectionException) | ○ |
| C-065 | ReflectionExtractor::getProperties: 静的メソッド除外 | E-05 (L140-141: isStatic check) | ○ |
| C-066 | ReflectionExtractor::getProperties: 空クラスでnull | E-05 (L154: $properties ? ... : null) | ○ |
| C-067 | ReflectionExtractor::getType: mutatorパラメータ型 | E-05 (L157-172) | ○ |
| C-068 | ReflectionExtractor::getType: accessor戻り値型 | E-05 (L174-180) | ○ |
| C-069 | ReflectionExtractor::getType: コンストラクタ型 | E-05 (L182-189) | ○ |
| C-070 | ReflectionExtractor::getType: プロパティ型宣言 | E-05 (L192-202) | ○ |
| C-071 | ReflectionExtractor::getType: デフォルト値型推測 | E-05 (L204-216) | ○ |
| C-072 | ReflectionExtractor::getType: 配列mutatorでlist型 | E-05 (L165-167) | ○ |
| C-073 | ReflectionExtractor::getType: 型情報なしでnull | E-05 (L196-197, L204-206) | ○ |
| C-074 | ReflectionExtractor::getType: enableConstructorExtractionコンテキスト | E-05 (L182) | ○ |
| C-075 | ReflectionExtractor::getTypeFromConstructor: 正常取得 | E-05 (L218-238) | ○ |
| C-076 | ReflectionExtractor::getTypeFromConstructor: コンストラクタなし | E-05 (L226-227) | ○ |
| C-077 | ReflectionExtractor::getTypeFromConstructor: 存在しないクラス | E-05 (L222-223) | ○ |
| C-078 | ReflectionExtractor::getTypeFromConstructor: パラメータなし | E-05 (L229-230, L240-249) | ○ |
| C-079 | ReflectionExtractor::isReadable: publicプロパティ | E-05 (L251-258) | ○ |
| C-080 | ReflectionExtractor::isReadable: getterメソッド | E-05 (L257: getReadInfo) | ○ |
| C-081 | ReflectionExtractor::isReadable: 読み取り不可 | E-05 (L251-258) | ○ |
| C-082 | ReflectionExtractor::isWritable: publicプロパティ | E-05 (L260-276) | ○ |
| C-083 | ReflectionExtractor::isWritable: setter | E-05 (L267-275) | ○ |
| C-084 | ReflectionExtractor::isWritable: readonly | E-05 (L262: isAllowedProperty with writeAccessRequired) | ○ |
| C-085 | ReflectionExtractor::isInitializable: コンストラクタパラメータ | E-05 (L278-301) | ○ |
| C-086 | ReflectionExtractor::isInitializable: パラメータなし | E-05 (L300: return false) | ○ |
| C-087 | ReflectionExtractor::isInitializable: インスタンス化不可 | E-05 (L286-288) | ○ |
| C-088 | ReflectionExtractor::isInitializable: 存在しないクラス | E-05 (L282-284) | ○ |
| C-089 | ReflectionExtractor::getReadInfo: getterメソッド | E-05 (L303-344, L319-325) | ○ |
| C-090 | ReflectionExtractor::getReadInfo: isXxx | E-05 (L53: accessorPrefixes含む'is') | ○ |
| C-091 | ReflectionExtractor::getReadInfo: hasXxx | E-05 (L53: accessorPrefixes含む'has') | ○ |
| C-092 | ReflectionExtractor::getReadInfo: canXxx | E-05 (L53: accessorPrefixes含む'can') | ○ |
| C-093 | ReflectionExtractor::getReadInfo: publicプロパティ | E-05 (L335-337) | ○ |
| C-094 | ReflectionExtractor::getReadInfo: __getマジック | E-05 (L331-333) | ○ |
| C-095 | ReflectionExtractor::getReadInfo: __callマジック | E-05 (L339-341) | ○ |
| C-096 | ReflectionExtractor::getReadInfo: getter/setterスタイル | E-05 (L327-329) | ○ |
| C-097 | ReflectionExtractor::getReadInfo: null返却 | E-05 (L343: return null) | ○ |
| C-098 | ReflectionExtractor::getReadInfo: 存在しないクラス | E-05 (L307-309) | ○ |
| C-099 | ReflectionExtractor::getWriteInfo: コンストラクタ | E-05 (L367-373) | ○ |
| C-100 | ReflectionExtractor::getWriteInfo: adder/remover | E-05 (L375-385) | ○ |
| C-101 | ReflectionExtractor::getWriteInfo: setter | E-05 (L389-403) | ○ |
| C-102 | ReflectionExtractor::getWriteInfo: publicプロパティ | E-05 (L447-455) | ○ |
| C-103 | ReflectionExtractor::getWriteInfo: __set | E-05 (L457-464) | ○ |
| C-104 | ReflectionExtractor::getWriteInfo: __call | E-05 (L466-473) | ○ |
| C-105 | ReflectionExtractor::getWriteInfo: readonlyエラー | E-05 (L449-454) | ○ |
| C-106 | ReflectionExtractor::getWriteInfo: TYPE_NONE | E-05 (L485-488) | ○ |
| C-107 | ReflectionExtractor::getWriteInfo: 存在しないクラス | E-05 (L349-352) | ○ |
| C-108 | ReflectionExtractor::getWriteInfo: enable_constructor_extraction | E-05 (L358, L367) | ○ |
| C-109 | ReflectionExtractor::getWriteInfo: enable_adder_remover_extraction | E-05 (L359, L376) | ○ |
| C-110 | PhpDocExtractor: デフォルトインスタンス | E-06 (L65-78) | ○ |
| C-111 | PhpDocExtractor: 依存パッケージ未インストール時例外 | E-06 (L67-69) | △ |
| C-112 | PhpDocExtractor::getShortDescription: summary取得 | E-06 (L80-104) | ○ |
| C-113 | PhpDocExtractor::getShortDescription: @varフォールバック | E-06 (L93-101) | ○ |
| C-114 | PhpDocExtractor::getShortDescription: null返却 | E-06 (L82-84) | ○ |
| C-115 | PhpDocExtractor::getLongDescription: description取得 | E-06 (L106-116) | ○ |
| C-116 | PhpDocExtractor::getLongDescription: 空description | E-06 (L115) | ○ |
| C-117 | PhpDocExtractor::getType: @var型抽出 | E-06 (L118-175, L126-128) | ○ |
| C-118 | PhpDocExtractor::getType: @return型抽出 | E-06 (L126-129) | ○ |
| C-119 | PhpDocExtractor::getType: @param型抽出 | E-06 (L126-129) | ○ |
| C-120 | PhpDocExtractor::getType: self解決 | E-06 (L149-150) | ○ |
| C-121 | PhpDocExtractor::getType: static解決 | E-06 (L149-151) | ○ |
| C-122 | PhpDocExtractor::getType: parent解決 | E-06 (L155-160) | ○ |
| C-123 | PhpDocExtractor::getType: 配列mutatorでlist型 | E-06 (L170-174) | ○ |
| C-124 | PhpDocExtractor::getType: PHPDocなしnull | E-06 (L122-124) | ○ |
| C-125 | PhpDocExtractor::getType: InvalidTagスキップ | E-06 (L137-139) | ○ |
| C-126 | PhpDocExtractor::getTypeFromConstructor: 正常取得 | E-06 (L177-194) | ○ |
| C-127 | PhpDocExtractor::getTypeFromConstructor: コンストラクタなし | E-06 (L211-213) | ○ |
| C-128 | PhpDocExtractor::getDocBlock: DocBlock取得 | E-06 (L196-201) | ○ |
| C-129 | PhpDocExtractor::getDocBlock: null返却 | E-06 (L196-201) | ○ |
| C-130 | PhpStanExtractor: デフォルトインスタンス | E-07 (L67-91) | ○ |
| C-131 | PhpStanExtractor: type-resolver未インストール例外 | E-07 (L69-71) | △ |
| C-132 | PhpStanExtractor: phpdoc-parser未インストール例外 | E-07 (L73-75) | △ |
| C-133 | PhpStanExtractor::getType: @var型抽出 | E-07 (L93-137) | ○ |
| C-134 | PhpStanExtractor::getType: @return型抽出 | E-07 (L104-106) | ○ |
| C-135 | PhpStanExtractor::getType: @param型抽出 | E-07 (L104-107) | ○ |
| C-136 | PhpStanExtractor::getType: 配列mutatorでlist型 | E-07 (L132-136) | ○ |
| C-137 | PhpStanExtractor::getType: PHPDocなしnull | E-07 (L98-100) | ○ |
| C-138 | PhpStanExtractor::getType: promotedプロパティフォールバック | E-07 (L317-322) | ○ |
| C-139 | PhpStanExtractor::getType: allowPrivateAccess制御 | E-07 (L437-439) | ○ |
| C-140 | PhpStanExtractor::getTypeFromConstructor: 正常取得 | E-07 (L139-149) | ○ |
| C-141 | PhpStanExtractor::getTypeFromConstructor: フォールバック | E-07 (L143) | ○ |
| C-142 | PhpStanExtractor::getShortDescription: 説明取得 | E-07 (L151-170) | ○ |
| C-143 | PhpStanExtractor::getShortDescription: @varフォールバック | E-07 (L163-167) | ○ |
| C-144 | PhpStanExtractor::getShortDescription: null | E-07 (L155-157) | ○ |
| C-145 | PhpStanExtractor::getLongDescription: 説明取得 | E-07 (L172-181) | ○ |
| C-146 | PhpStanExtractor::getLongDescription: null | E-07 (L175-177) | ○ |
| C-147 | ConstructorExtractor: 空リストインスタンス | E-08 (L27-30) | ○ |
| C-148 | ConstructorExtractor::getType: 優先順位 | E-08 (L32-41) | ○ |
| C-149 | ConstructorExtractor::getType: 全てnull | E-08 (L40: return null) | ○ |
| C-150 | ConstructorExtractor::getType: 空抽出器 | E-08 (L32-41: 空iterableでforeachスキップ) | ○ |
| C-151 | SerializerExtractor: null groups全プロパティ | E-09 (L31-51) | ○ |
| C-152 | SerializerExtractor: グループフィルタ | E-09 (L45) | ○ |
| C-153 | SerializerExtractor: ワイルドカード'*' | E-09 (L45: in_array('*')) | ○ |
| C-154 | SerializerExtractor: context不足でnull | E-09 (L33-35) | ○ |
| C-155 | SerializerExtractor: 不正型でnull | E-09 (L33: !is_array check) | ○ |
| C-156 | SerializerExtractor: メタデータなしでnull | E-09 (L37-39) | ○ |
| C-157 | SerializerExtractor: ignored除外 | E-09 (L45: !isIgnored()) | ○ |
| C-158 | PhpDocTypeHelper: string型変換 | E-10 (L43-104, L164-172) | ○ |
| C-159 | PhpDocTypeHelper: Nullable型変換 | E-10 (L52-55) | ○ |
| C-160 | PhpDocTypeHelper: Null_型 | E-10 (L58-59) | ○ |
| C-161 | PhpDocTypeHelper: Compound型（union） | E-10 (L67-103) | ○ |
| C-162 | PhpDocTypeHelper: Compound+Null=nullable | E-10 (L77-79) | ○ |
| C-163 | PhpDocTypeHelper: Collection型 | E-10 (L117-139) | ○ |
| C-164 | PhpDocTypeHelper: string[]→list | E-10 (L145-147) | ○ |
| C-165 | PhpDocTypeHelper: array<key,value> | E-10 (L155-161) | ○ |
| C-166 | PhpDocTypeHelper: list<T> | E-10 (L149-153) | ○ |
| C-167 | PhpDocTypeHelper: mixed[]→array | E-10 (L113-115) | ○ |
| C-168 | PhpDocTypeHelper: integer→int | E-10 (L165) | ○ |
| C-169 | PhpDocTypeHelper: boolean→bool | E-10 (L166) | ○ |
| C-170 | PhpDocTypeHelper: double→float | E-10 (L168) | ○ |
| C-171 | PhpDocTypeHelper: callback→callable | E-10 (L169) | ○ |
| C-172 | PhpDocTypeHelper: void→null | E-10 (L170) | ○ |
| C-173 | PhpDocTypeHelper: FQCN→object | E-10 (L188-198) | ○ |
| C-174 | PhpDocTypeHelper: ConstExpression→null | E-10 (L45-48) | △ |
| C-175 | PhpDocTypeHelper: 空文字列→null | E-10 (L141-143) | ○ |
| C-176 | PhpDocTypeHelper: PseudoType(Integer)→int | E-10 (L179-181) | △ |
| C-177 | PhpDocTypeHelper: PseudoType(String_)→string | E-10 (L179-181) | △ |
| C-178 | PhpDocTypeHelper: Compound内ConstExpression→null | E-10 (L71-73) | ○ |
| C-179 | PhpDocTypeHelper: 単一有効型のCompound | E-10 (L101) | ○ |
| C-180 | PropertyInfoPass: 全抽出器設定 | E-11 (L28-50) | ○ |
| C-181 | PropertyInfoPass: サービスなしで早期リターン | E-11 (L30-32) | ○ |
| C-182 | PropertyInfoPass: list_extractor→引数0 | E-11 (L36-37) | ○ |
| C-183 | PropertyInfoPass: type_extractor→引数1 | E-11 (L39-40) | ○ |
| C-184 | PropertyInfoPass: description_extractor→引数2 | E-11 (L42-43) | ○ |
| C-185 | PropertyInfoPass: access_extractor→引数3 | E-11 (L45-46) | ○ |
| C-186 | PropertyInfoPass: initializable_extractor→引数4 | E-11 (L48-49) | ○ |
| C-187 | PropertyInfoConstructorPass: constructor_extractor設定 | E-12 (L28-37) | ○ |
| C-188 | PropertyInfoConstructorPass: サービスなしで早期リターン | E-12 (L30-32) | ○ |
| C-189 | ReflectionExtractor::getReadInfo: void返却除外 | E-05 (L322) | ○ |
| C-190 | ReflectionExtractor::getReadInfo: never返却除外 | E-05 (L322) | ○ |
| C-191 | ReflectionExtractor::isInitializable: 親クラスフォールバック | E-05 (L296-298) | ○ |
| C-192 | ReflectionExtractor::getWriteInfo: getter/setterスタイル | E-05 (L426-445) | ○ |
| C-193 | ReflectionExtractor: ALLOW_PRIVATEフラグ | E-05 (L60, L730-742) | ○ |
| C-194 | ReflectionExtractor: ALLOW_PROTECTEDフラグ | E-05 (L61, L730-742) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-111 (PhpDocExtractor依存パッケージ例外)**: class_exists()の条件を満たさない環境をテストで再現する方法が不明確。実運用ではパッケージは常にインストールされている前提。
  - 候補：モック / テスト用の分離環境 / class_existsのオーバーライド
- **C-131, C-132 (PhpStanExtractor依存パッケージ例外)**: 同上、class_exists()の条件分岐テストの実現方法が環境依存。
  - 候補：名前空間を利用したclass_existsモック / 分離テスト
- **C-174 (ConstExpression型)**: phpDocumentor内部のConstExpression型を直接生成するテストデータの構築方法について具体的な根拠がない。
  - 候補：phpDocumentorのテストコード参照 / PHPDocパーサー経由でのテストデータ生成
- **C-176, C-177 (PseudoType処理)**: phpDocumentorのPseudoType具象クラスの生成方法が明確でない。
  - 候補：phpDocumentorのPseudoTypes名前空間のクラスを直接使用

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: PropertyReadInfo, PropertyWriteInfo - 値オブジェクトのため単純なテスト
- **0 (低リスク)**: PropertyInfoExtractor - 委譲パターンのため単純なテスト
- **0 (低リスク)**: PropertyInfoCacheExtractor - キャッシュパターンのため定型テスト
- **1 (中リスク)**: ReflectionExtractor - 複雑な条件分岐とReflection APIへの依存があり、テストクラスの設計が重要
- **1 (中リスク)**: PhpDocExtractor - phpDocumentorライブラリとの統合テストに近い部分がある
- **1 (中リスク)**: PhpStanExtractor - PHPStanパーサーライブラリとの統合テストに近い部分がある
- **1 (中リスク)**: PhpDocTypeHelper - 多数の型変換パターンの網羅性
- **0 (低リスク)**: SerializerExtractor - 比較的シンプルなメタデータ参照
- **0 (低リスク)**: PropertyInfoPass, PropertyInfoConstructorPass - DIコンパイラパスの定型パターン

## 6) レビュアーチェックリスト（最小）
- [ ] ReflectionExtractorのテストケースが全てのアクセサプレフィックス（get, is, has, can）をカバーしているか
- [ ] ReflectionExtractorのgetWriteInfoの全書き込みパス（constructor, adder/remover, setter, property, magic methods）がカバーされているか
- [ ] PropertyWriteInfoのLogicException発生条件が全てのnullableフィールド（name, visibility, static, adderInfo, removerInfo）でテストされているか
- [ ] PhpDocTypeHelperの型マッピングテストが全エイリアス（integer, boolean, double, callback, void）をカバーしているか
- [ ] SerializerExtractorのcontextバリデーション（serializer_groupsの有無、null、配列、不正型）が網羅されているか
- [ ] PropertyInfoCacheExtractorのシリアライズ不可能な引数でのフォールバック動作がテストされているか
- [ ] DIコンパイラパスの全タグ（list, type, description, access, initializable, constructor）の登録テストがあるか
