---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 63
  claims_with_evidence: 63
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Component-RemoteEvent 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：63 / 63、根拠なし：0
- 優先レビュー（高）
  1. **ConsumeRemoteEventHandler.__invoke の異常系テスト**：エラーメッセージのフォーマットがソースコードと一致するか要確認
  2. **AbstractMailerEvent の getDate 未初期化時の挙動**：dateプロパティに初期値がないため、未初期化アクセス時のテストが未追加
  3. **PayloadConverterInterface / ConsumerInterface**：インターフェースのためテストケースを生成していないが、妥当性の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/RemoteEvent/RemoteEvent.php` - コアイベントクラス（name, id, payload の readonly プロパティとgetter）
- E-02: `src/Symfony/Component/RemoteEvent/Attribute/AsRemoteEventConsumer.php` - PHP属性クラス（Attribute::TARGET_CLASS, public $name）
- E-03: `src/Symfony/Component/RemoteEvent/Messenger/ConsumeRemoteEventHandler.php` - メッセージハンドラ（__invoke, ContainerInterface依存, LogicException投出ロジック）
- E-04: `src/Symfony/Component/RemoteEvent/Messenger/ConsumeRemoteEventMessage.php` - メッセージDTO（type, event の readonly プロパティとgetter）
- E-05: `src/Symfony/Component/RemoteEvent/PayloadConverterInterface.php` - ペイロード変換インターフェース
- E-06: `src/Symfony/Component/RemoteEvent/Consumer/ConsumerInterface.php` - コンシューマーインターフェース
- E-07: `src/Symfony/Component/RemoteEvent/Event/Mailer/AbstractMailerEvent.php` - 抽象メーラーイベント（date, email, metadata, tags）
- E-08: `src/Symfony/Component/RemoteEvent/Event/Mailer/MailerDeliveryEvent.php` - メーラー配送イベント（reason, 5定数）
- E-09: `src/Symfony/Component/RemoteEvent/Event/Mailer/MailerEngagementEvent.php` - メーラーエンゲージメントイベント（4定数）
- E-10: `src/Symfony/Component/RemoteEvent/Event/Sms/SmsEvent.php` - SMSイベント（phone, 2定数）
- E-11: `src/Symfony/Component/RemoteEvent/Exception/LogicException.php` - LogicException（\LogicException継承, ExceptionInterface実装）
- E-12: `src/Symfony/Component/RemoteEvent/Exception/RuntimeException.php` - RuntimeException（\RuntimeException継承, ExceptionInterface実装）
- E-13: `src/Symfony/Component/RemoteEvent/Exception/InvalidArgumentException.php` - InvalidArgumentException（\InvalidArgumentException継承, ExceptionInterface実装）
- E-14: `src/Symfony/Component/RemoteEvent/Exception/ParseException.php` - ParseException（InvalidArgumentException継承）
- E-15: `src/Symfony/Component/RemoteEvent/Exception/ExceptionInterface.php` - ExceptionInterface（\Throwable継承）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RemoteEvent.__constructが3引数（name, id, payload）で生成可能 | E-01 | ○ |
| C-02 | RemoteEvent.getNameがname文字列を返却 | E-01 | ○ |
| C-03 | RemoteEvent.getIdがid文字列を返却 | E-01 | ○ |
| C-04 | RemoteEvent.getPayloadがpayload配列を返却 | E-01 | ○ |
| C-05 | RemoteEventは空文字列name/idで生成可能 | E-01 | ○ |
| C-06 | RemoteEventは空配列payloadで生成可能 | E-01 | ○ |
| C-07 | RemoteEventはネストされた配列payloadを保持可能 | E-01 | ○ |
| C-08 | AsRemoteEventConsumerがname引数で生成可能 | E-02 | ○ |
| C-09 | AsRemoteEventConsumer.nameがpublicプロパティ | E-02 | ○ |
| C-10 | AsRemoteEventConsumerがAttribute::TARGET_CLASSで定義 | E-02 | ○ |
| C-11 | ConsumeRemoteEventMessageが(type, event)で生成可能 | E-04 | ○ |
| C-12 | ConsumeRemoteEventMessage.getTypeがtype文字列を返却 | E-04 | ○ |
| C-13 | ConsumeRemoteEventMessage.getEventがRemoteEventを返却 | E-04 | ○ |
| C-14 | ConsumeRemoteEventHandler.__invokeがconsumer.consumeを呼出 | E-03 | ○ |
| C-15 | ConsumeRemoteEventHandler.__invokeがconsumer未登録時にLogicExceptionをスロー | E-03 | ○ |
| C-16 | ConsumeRemoteEventHandler.__invokeがConsumerInterface非実装時にLogicExceptionをスロー | E-03 | ○ |
| C-17 | ConsumeRemoteEventHandler.__invokeがRemoteEventをconsumerに正しく渡す | E-03 | ○ |
| C-18 | AbstractMailerEvent.setDate/getDateがDateTimeImmutableを設定・取得 | E-07 | ○ |
| C-19 | AbstractMailerEvent.setRecipientEmail/getRecipientEmailがemail文字列を設定・取得 | E-07 | ○ |
| C-20 | AbstractMailerEvent.getRecipientEmailの初期値が空文字列 | E-07 | ○ |
| C-21 | AbstractMailerEvent.setMetadata/getMetadataがmetadata配列を設定・取得 | E-07 | ○ |
| C-22 | AbstractMailerEvent.getMetadataの初期値が空配列 | E-07 | ○ |
| C-23 | AbstractMailerEvent.setTags/getTagsがtags配列を設定・取得 | E-07 | ○ |
| C-24 | AbstractMailerEvent.getTagsの初期値が空配列 | E-07 | ○ |
| C-25 | AbstractMailerEvent.setMetadataが上書き可能 | E-07 | ○ |
| C-26 | MailerDeliveryEventが有効な引数で生成可能 | E-08, E-07 | ○ |
| C-27 | MailerDeliveryEvent.setReason/getReasonがreason文字列を設定・取得 | E-08 | ○ |
| C-28 | MailerDeliveryEvent.getReasonの初期値が空文字列 | E-08 | ○ |
| C-29 | MailerDeliveryEvent::RECEIVED === 'received' | E-08 | ○ |
| C-30 | MailerDeliveryEvent::DROPPED === 'dropped' | E-08 | ○ |
| C-31 | MailerDeliveryEvent::DELIVERED === 'delivered' | E-08 | ○ |
| C-32 | MailerDeliveryEvent::DEFERRED === 'deferred' | E-08 | ○ |
| C-33 | MailerDeliveryEvent::BOUNCE === 'bounce' | E-08 | ○ |
| C-34 | MailerDeliveryEventがAbstractMailerEventを継承 | E-08 | ○ |
| C-35 | MailerDeliveryEventがRemoteEventを継承（間接） | E-08, E-07, E-01 | ○ |
| C-36 | MailerEngagementEventが有効な引数で生成可能 | E-09, E-07 | ○ |
| C-37 | MailerEngagementEvent::OPEN === 'open' | E-09 | ○ |
| C-38 | MailerEngagementEvent::CLICK === 'click' | E-09 | ○ |
| C-39 | MailerEngagementEvent::SPAM === 'spam' | E-09 | ○ |
| C-40 | MailerEngagementEvent::UNSUBSCRIBE === 'unsubscribe' | E-09 | ○ |
| C-41 | MailerEngagementEventがAbstractMailerEventを継承 | E-09 | ○ |
| C-42 | MailerEngagementEventでsetDate/getDateが利用可能 | E-09, E-07 | ○ |
| C-43 | SmsEventが有効な引数で生成可能 | E-10 | ○ |
| C-44 | SmsEvent.setRecipientPhone/getRecipientPhoneがphone文字列を設定・取得 | E-10 | ○ |
| C-45 | SmsEvent.getRecipientPhoneの初期値が空文字列 | E-10 | ○ |
| C-46 | SmsEvent::FAILED === 'failed' | E-10 | ○ |
| C-47 | SmsEvent::DELIVERED === 'delivered' | E-10 | ○ |
| C-48 | SmsEventがRemoteEventを継承 | E-10 | ○ |
| C-49 | LogicExceptionが\LogicExceptionを継承 | E-11 | ○ |
| C-50 | LogicExceptionがExceptionInterfaceを実装 | E-11 | ○ |
| C-51 | RuntimeExceptionが\RuntimeExceptionを継承 | E-12 | ○ |
| C-52 | RuntimeExceptionがExceptionInterfaceを実装 | E-12 | ○ |
| C-53 | InvalidArgumentExceptionが\InvalidArgumentExceptionを継承 | E-13 | ○ |
| C-54 | InvalidArgumentExceptionがExceptionInterfaceを実装 | E-13 | ○ |
| C-55 | ParseExceptionがInvalidArgumentExceptionを継承 | E-14 | ○ |
| C-56 | ParseExceptionがExceptionInterfaceを実装 | E-14, E-13 | ○ |
| C-57 | ConsumeRemoteEventHandlerがContainerInterfaceを受け取って生成可能 | E-03 | ○ |
| C-58 | AbstractMailerEvent.setTagsが上書き可能 | E-07 | ○ |
| C-59 | AbstractMailerEvent.setRecipientEmailが上書き可能 | E-07 | ○ |
| C-60 | SmsEvent.setRecipientPhoneが上書き可能 | E-10 | ○ |
| C-61 | MailerDeliveryEvent.setReasonが上書き可能 | E-08 | ○ |
| C-62 | RemoteEventが大量ペイロードを保持可能 | E-01 | ○ |
| C-63 | ConsumeRemoteEventMessageが空文字列typeで生成可能 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- AbstractMailerEvent.getDate()を未初期化状態で呼び出した場合の挙動（dateプロパティに初期値がない）
  - 候補：PHP 8.4のtyped property未初期化アクセス時のError / テスト追加 / ドキュメント確認
- PayloadConverterInterfaceの具象実装が本モジュール内に存在しないため、インターフェースのテストケースは省略
  - 候補：具象実装が存在するWebhookコンポーネント等の確認 / モックテストの追加
- ConsumerInterfaceの具象実装が本モジュール内に存在しないため、インターフェースのテストケースは省略
  - 候補：具象実装が存在する外部モジュールの確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - RemoteEvent, ConsumeRemoteEventMessage等のシンプルなDTOクラスは実装が単純でリスクが低い
- 1: 中リスク - AbstractMailerEvent.getDate()の未初期化アクセス時のTypedPropertyエラーの可能性。テストケースで未初期化アクセスのテストを追加すべきか検討が必要
- 0: 低リスク - 例外クラスの継承確認は低リスク
- 1: 中リスク - ConsumeRemoteEventHandler.__invokeのエラーメッセージフォーマット（sprintf使用）がソースコードと完全一致するかレビュー推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ConsumeRemoteEventHandler.__invokeのLogicExceptionメッセージがソースコードのsprintfフォーマットと一致しているか
- [ ] AbstractMailerEvent.getDate()未初期化アクセスのテストケース追加が必要か判断
- [ ] PayloadConverterInterface / ConsumerInterfaceのテストケース省略が妥当か確認
- [ ] 全定数値（RECEIVED, DROPPED等）がソースコードの実際の値と一致しているか
- [ ] テストID（UT-RME-xxx）の連番に欠番がないか確認
- [ ] 優先度の設定がプロジェクト方針と一致しているか確認
