---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 206
  claims_with_evidence: 198
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：Component-Routing 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：198 / 206、根拠なし：8
- 優先レビュー（高）
  1. **UT-RTG-093 (C-93)**：RequestContext::fromRequest のテスト - HttpFoundation Requestオブジェクトの内部動作への依存
  2. **UT-RTG-142 (C-142)**：Router::setContext のmatcher/generator伝播 - 内部状態の初期化タイミングへの依存
  3. **UT-RTG-191 (C-191)**：YamlFileLoader::load - 実際のファイルI/O・外部依存（Yaml Parser）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Routing/Route.php` - Routeクラスの全メソッド定義
- E-02: `src/Symfony/Component/Routing/RouteCollection.php` - RouteCollectionクラスの全メソッド定義
- E-03: `src/Symfony/Component/Routing/RouteCompiler.php` - RouteCompilerクラスのcompile/compilePattern等
- E-04: `src/Symfony/Component/Routing/CompiledRoute.php` - CompiledRouteクラスの全メソッド定義
- E-05: `src/Symfony/Component/Routing/RequestContext.php` - RequestContextクラスの全メソッド定義
- E-06: `src/Symfony/Component/Routing/Router.php` - Routerクラスの全メソッド定義
- E-07: `src/Symfony/Component/Routing/Alias.php` - Aliasクラスの全メソッド定義
- E-08: `src/Symfony/Component/Routing/Generator/UrlGenerator.php` - UrlGeneratorクラスのgenerate/doGenerate/getRelativePath
- E-09: `src/Symfony/Component/Routing/Generator/CompiledUrlGenerator.php` - CompiledUrlGeneratorクラスのgenerate
- E-10: `src/Symfony/Component/Routing/Matcher/UrlMatcher.php` - UrlMatcherクラスのmatch/matchCollection/mergeDefaults
- E-11: `src/Symfony/Component/Routing/Matcher/TraceableUrlMatcher.php` - TraceableUrlMatcherクラスのgetTraces/matchCollection
- E-12: `src/Symfony/Component/Routing/Matcher/CompiledUrlMatcher.php` - CompiledUrlMatcherクラス
- E-13: `src/Symfony/Component/Routing/Matcher/RedirectableUrlMatcher.php` - RedirectableUrlMatcherクラスのmatch
- E-14: `src/Symfony/Component/Routing/Matcher/Dumper/CompiledUrlMatcherDumper.php` - ダンパークラス
- E-15: `src/Symfony/Component/Routing/Matcher/Dumper/StaticPrefixCollection.php` - プレフィックスツリークラス
- E-16: `src/Symfony/Component/Routing/Generator/Dumper/CompiledUrlGeneratorDumper.php` - ジェネレータダンパークラス
- E-17: `src/Symfony/Component/Routing/Attribute/Route.php` - Route属性クラス
- E-18: `src/Symfony/Component/Routing/Attribute/DeprecatedAlias.php` - DeprecatedAlias属性クラス
- E-19: `src/Symfony/Component/Routing/Requirement/EnumRequirement.php` - EnumRequirementクラス
- E-20: `src/Symfony/Component/Routing/Requirement/Requirement.php` - Requirement定数列挙
- E-21: `src/Symfony/Component/Routing/Exception/MethodNotAllowedException.php` - 例外クラス
- E-22: `src/Symfony/Component/Routing/Exception/MissingMandatoryParametersException.php` - 例外クラス
- E-23: `src/Symfony/Component/Routing/Matcher/ExpressionLanguageProvider.php` - 式言語プロバイダ
- E-24: `src/Symfony/Component/Routing/Loader/YamlFileLoader.php` - YAMLローダー
- E-25: `src/Symfony/Component/Routing/Loader/AttributeClassLoader.php` - 属性クラスローダー
- E-26: `src/Symfony/Component/Routing/Loader/Configurator/RoutingConfigurator.php` - ルーティングコンフィギュレータ
- E-27: `src/Symfony/Component/Routing/DependencyInjection/RoutingResolverPass.php` - DIコンパイラパス
- E-28: `src/Symfony/Component/Routing/Matcher/Dumper/CompiledUrlMatcherTrait.php` - コンパイル済みマッチャートレイト

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Route::__constructでパス・デフォルト・要件が設定される | E-01 (L49-59) | ○ |
| C-02 | Route::setPathで先頭スラッシュが自動付与される | E-01 (L124) | ○ |
| C-03 | Route::setPathでインラインデフォルト値が抽出される | E-01 (L413-440) | ○ |
| C-04 | Route::setPathでインライン要件が抽出される | E-01 (L413-440) | ○ |
| C-05 | Route::setPathで先頭複数スラッシュが正規化される | E-01 (L124) | ○ |
| C-06 | Route::setPath後にcompiledがnullにリセットされる | E-01 (L125) | ○ |
| C-07 | Route::setHostでホストパターンが設定される | E-01 (L138-144) | ○ |
| C-08 | Route::setHostでnull渡しが空文字列に変換される | E-01 (L140) | ○ |
| C-09 | Route::setSchemesでスキームが小文字に正規化される | E-01 (L167) | ○ |
| C-10 | Route::setSchemesで文字列入力が配列に変換される | E-01 (L167) | ○ |
| C-11 | Route::hasSchemeで大文字小文字無視の判定が行われる | E-01 (L178) | ○ |
| C-12 | Route::hasSchemeで未登録スキームがfalseを返す | E-01 (L178) | ○ |
| C-13 | Route::setMethodsでメソッドが大文字に正規化される | E-01 (L202) | ○ |
| C-14 | Route::setOptionsでcompiler_classがデフォルト設定される | E-01 (L218-219) | ○ |
| C-15 | Route::addOptionsでオプションが追加される | E-01 (L228-236) | ○ |
| C-16 | Route::getOptionで存在しないキーはnullを返す | E-01 (L256) | ○ |
| C-17 | Route::hasOptionで存在するオプションがtrue | E-01 (L261) | ○ |
| C-18 | Route::setDefaultsでデフォルト値が設定される | E-01 (L272-277) | ○ |
| C-19 | Route::addDefaultsでローカライズルートの_localeが無視される | E-01 (L284-286) | ○ |
| C-20 | Route::setDefaultでローカライズルートの_locale設定が無視される | E-01 (L311-313) | ○ |
| C-21 | Route::getDefaultで存在しないキーはnullを返す | E-01 (L298) | ○ |
| C-22 | Route::hasDefaultで存在確認 | E-01 (L303) | ○ |
| C-23 | Route::setRequirementsで要件が設定される | E-01 (L329-334) | ○ |
| C-24 | sanitizeRequirementで空要件が例外をスローする | E-01 (L458-459) | ○ |
| C-25 | sanitizeRequirementで先頭'^'が除去される | E-01 (L445-446) | ○ |
| C-26 | sanitizeRequirementで末尾'$'が除去される | E-01 (L452-453) | ○ |
| C-27 | sanitizeRequirementで先頭'\\A'が除去される | E-01 (L447-448) | ○ |
| C-28 | Route::setConditionで条件式が設定される | E-01 (L386-392) | ○ |
| C-29 | Route::setConditionでnullが空文字列に変換される | E-01 (L388) | ○ |
| C-30 | Route::compileでキャッシュが使用される | E-01 (L404-406) | ○ |
| C-31 | Route::__serializeで全プロパティが含まれる | E-01 (L61-74) | ○ |
| C-32 | Route::__unserializeで復元される | E-01 (L84-100) | ○ |
| C-33 | Route::serialize()でBadMethodCallException | E-01 (L81) | ○ |
| C-34 | RouteCollection::addでルートが追加される | E-02 (L85-94) | ○ |
| C-35 | RouteCollection::addで同名ルートが上書きされる | E-02 (L87) | ○ |
| C-36 | RouteCollection::addで優先度が設定される | E-02 (L91-93) | ○ |
| C-37 | RouteCollection::allで優先度順ソートされる | E-02 (L103-107) | ○ |
| C-38 | RouteCollection::allで同一優先度では挿入順維持 | E-02 (L106) | ○ |
| C-39 | RouteCollection::getでルートが取得できる | E-02 (L115-136) | ○ |
| C-40 | RouteCollection::getでエイリアス経由のルート取得 | E-02 (L118-133) | ○ |
| C-41 | RouteCollection::getで循環参照エイリアス例外 | E-02 (L119-122) | ○ |
| C-42 | RouteCollection::getで存在しないルートはnull | E-02 (L135) | ○ |
| C-43 | RouteCollection::removeでルートが削除される | E-02 (L143-163) | ○ |
| C-44 | RouteCollection::removeで配列指定の複数ルート削除 | E-02 (L146) | ○ |
| C-45 | RouteCollection::removeで関連エイリアスも削除される | E-02 (L158-162) | ○ |
| C-46 | RouteCollection::addCollectionでコレクション結合 | E-02 (L169-191) | ○ |
| C-47 | RouteCollection::addPrefixで全ルートにプレフィックス追加 | E-02 (L196-209) | ○ |
| C-48 | RouteCollection::addPrefixで空プレフィックスは変更なし | E-02 (L200-201) | ○ |
| C-49 | RouteCollection::addNamePrefixで全ルート名にプレフィックス | E-02 (L214-243) | ○ |
| C-50 | RouteCollection::addNamePrefixでエイリアスターゲットID更新 | E-02 (L230-238) | ○ |
| C-51 | RouteCollection::setHostで全ルートにホスト設定 | E-02 (L248-255) | ○ |
| C-52 | RouteCollection::setConditionで全ルートに条件設定 | E-02 (L262-267) | ○ |
| C-53 | RouteCollection::addAliasでエイリアス作成 | E-02 (L366-375) | ○ |
| C-54 | RouteCollection::addAliasで自己参照例外 | E-02 (L368-369) | ○ |
| C-55 | RouteCollection::countでルート数が返る | E-02 (L80-83) | ○ |
| C-56 | RouteCollection::countで空コレクションは0 | E-02 (L82) | ○ |
| C-57 | RouteCollection::getIteratorでイテレータ取得 | E-02 (L72-75) | ○ |
| C-58 | RouteCollection::__cloneでディープコピー | E-02 (L53-61) | ○ |
| C-59 | RouteCollection::addResourceでリソース追加 | E-02 (L349-356) | ○ |
| C-60 | RouteCollection::addResourceで重複排除 | E-02 (L353-355) | ○ |
| C-61 | RouteCompiler::compileで静的パスコンパイル | E-03 (L43-97) | ○ |
| C-62 | RouteCompiler::compileで変数パスコンパイル | E-03 (L43-97) | ○ |
| C-63 | RouteCompiler::compileでホストパターンコンパイル | E-03 (L50-58) | ○ |
| C-64 | RouteCompiler::compileで_fragment変数禁止 | E-03 (L77-79) | ○ |
| C-65 | RouteCompiler::compileで変数重複禁止 | E-03 (L141-142) | ○ |
| C-66 | RouteCompiler::compileで数字始まり変数名禁止 | E-03 (L138-139) | ○ |
| C-67 | RouteCompiler::compileで変数名32文字超禁止 | E-03 (L145-147) | ○ |
| C-68 | RouteCompiler::compileでUTF-8未設定時の例外 | E-03 (L109-111) | ○ |
| C-69 | RouteCompiler::compileでUTF-8サポート | E-03 (L227-234) | ○ |
| C-70 | RouteCompiler::compileでオプショナル変数 | E-03 (L206-217) | ○ |
| C-71 | CompiledRoute::__constructで全プロパティ設定 | E-04 (L31-41) | ○ |
| C-72 | CompiledRoute::getStaticPrefixで取得 | E-04 (L88-91) | ○ |
| C-73 | CompiledRoute::getRegexで取得 | E-04 (L96-99) | ○ |
| C-74 | CompiledRoute::getHostRegexでnull返却 | E-04 (L104-107) | ○ |
| C-75 | CompiledRoute::__serializeで全キー含む | E-04 (L43-55) | ○ |
| C-76 | CompiledRoute::__unserializeで復元 | E-04 (L65-75) | ○ |
| C-77 | CompiledRoute::serialize()でBadMethodCallException | E-04 (L62) | ○ |
| C-78 | RequestContext::__constructデフォルト値 | E-05 (L36-47) | ○ |
| C-79 | RequestContext::__constructカスタム値 | E-05 (L36-47) | ○ |
| C-80 | RequestContext::fromUriでURI解析 | E-05 (L49-71) | ○ |
| C-81 | RequestContext::fromUriでバックスラッシュURI処理 | E-05 (L51-53) | ○ |
| C-82 | RequestContext::fromUriで制御文字URI処理 | E-05 (L54-56) | ○ |
| C-83 | RequestContext::setMethodでメソッド正規化 | E-05 (L149) | ○ |
| C-84 | RequestContext::setHostでホスト正規化 | E-05 (L171) | ○ |
| C-85 | RequestContext::setSchemeでスキーム正規化 | E-05 (L191) | ○ |
| C-86 | RequestContext::setBaseUrlで末尾スラッシュ除去 | E-05 (L107) | ○ |
| C-87 | RequestContext::setQueryStringでnull安全 | E-05 (L252) | ○ |
| C-88 | RequestContext::isSecureでhttps判定 | E-05 (L309) | ○ |
| C-89 | RequestContext::isSecureでhttp判定 | E-05 (L309) | ○ |
| C-90 | RequestContext::setParameterで設定・取得 | E-05 (L300-305) | ○ |
| C-91 | RequestContext::hasParameterで存在確認true | E-05 (L292) | ○ |
| C-92 | RequestContext::hasParameterで不在確認false | E-05 (L292) | ○ |
| C-93 | RequestContext::fromRequestでRequest連携 | E-05 (L78-90) | △ |
| C-94 | UrlGenerator::generateで静的パスURL生成 | E-08 (L104-136) | ○ |
| C-95 | UrlGenerator::generateで変数パスURL生成 | E-08 (L104-136) | ○ |
| C-96 | UrlGenerator::generateで絶対URL生成 | E-08 (L252-264) | ○ |
| C-97 | UrlGenerator::generateでネットワークパス生成 | E-08 (L261) | ○ |
| C-98 | UrlGenerator::generateで相対パス生成 | E-08 (L266-267) | ○ |
| C-99 | UrlGenerator::generateでRouteNotFoundException | E-08 (L118) | ○ |
| C-100 | UrlGenerator::generateでMissingMandatoryParametersException | E-08 (L160-161) | ○ |
| C-101 | UrlGenerator::generateでInvalidParameterException | E-08 (L175-177) | ○ |
| C-102 | UrlGenerator::generateでstrictRequirements=false時空文字列 | E-08 (L180-182) | ○ |
| C-103 | UrlGenerator::generateで余剰パラメータがクエリ文字列 | E-08 (L273-296) | ○ |
| C-104 | UrlGenerator::generateで_queryパラメータ | E-08 (L147-154) | ○ |
| C-105 | UrlGenerator::generateで_queryが非配列時例外 | E-08 (L152) | ○ |
| C-106 | UrlGenerator::generateで_fragmentデフォルト | E-08 (L288-301) | ○ |
| C-107 | UrlGenerator::generateでスキーム切り替え | E-08 (L216-221) | ○ |
| C-108 | UrlGenerator::generateでロケールルート解決 | E-08 (L107-115) | ○ |
| C-109 | UrlGenerator::getRelativePathで同一パス | E-08 (L326-328) | ○ |
| C-110 | UrlGenerator::getRelativePathで親ディレクトリ | E-08 (L324-353) | ○ |
| C-111 | UrlGenerator::getRelativePathで異ブランチ | E-08 (L324-353) | ○ |
| C-112 | UrlGenerator::setStrictRequirements | E-08 (L94-97) | ○ |
| C-113 | CompiledUrlGenerator::generateでURL生成 | E-09 (L36-70) | ○ |
| C-114 | CompiledUrlGenerator::generateでRouteNotFoundException | E-09 (L51-53) | ○ |
| C-115 | CompiledUrlGenerator::generateで非推奨警告 | E-09 (L57-59) | ○ |
| C-116 | UrlMatcher::matchで静的パスマッチ | E-10 (L70-84) | ○ |
| C-117 | UrlMatcher::matchで変数パスマッチ | E-10 (L111-183) | ○ |
| C-118 | UrlMatcher::matchでResourceNotFoundException | E-10 (L83) | ○ |
| C-119 | UrlMatcher::matchでMethodNotAllowedException | E-10 (L83) | ○ |
| C-120 | UrlMatcher::matchでHEAD-GET等価 | E-10 (L114-116) | ○ |
| C-121 | UrlMatcher::matchでスキーム不一致 | E-10 (L169-172) | ○ |
| C-122 | UrlMatcher::matchでホストマッチ | E-10 (L149-152) | ○ |
| C-123 | UrlMatcher::matchでホスト不一致スキップ | E-10 (L150-152) | ○ |
| C-124 | UrlMatcher::matchでNoConfigurationException | E-10 (L79-81) | ○ |
| C-125 | UrlMatcher::matchでデフォルト値マージ | E-10 (L192-206) | ○ |
| C-126 | UrlMatcher::matchRequestでRequestマッチ | E-10 (L86-95) | ○ |
| C-127 | UrlMatcher::mergeDefaultsで数値キー無視 | E-10 (L233) | ○ |
| C-128 | UrlMatcher::mergeDefaultsでnull値無視 | E-10 (L233) | ○ |
| C-129 | TraceableUrlMatcher::getTracesでマッチトレース記録 | E-11 (L32-42, L149) | ○ |
| C-130 | TraceableUrlMatcher::getTracesで不一致トレース記録 | E-11 (L69, L83) | ○ |
| C-131 | TraceableUrlMatcher::getTracesで要件不一致トレース | E-11 (L93) | ○ |
| C-132 | TraceableUrlMatcher::getTracesForRequestでRequestトレース | E-11 (L44-51) | ○ |
| C-133 | CompiledUrlMatcher::__constructで初期化 | E-12 (L26-30) | ○ |
| C-134 | RedirectableUrlMatcher::matchでトレイリングスラッシュリダイレクト | E-13 (L44-57) | ○ |
| C-135 | RedirectableUrlMatcher::matchでスキームリダイレクト | E-13 (L31-43) | ○ |
| C-136 | RedirectableUrlMatcher::matchでPOSTリダイレクト禁止 | E-13 (L27-28) | ○ |
| C-137 | Router::setOptionsで有効オプション設定 | E-06 (L84-110) | ○ |
| C-138 | Router::setOptionsで無効オプション例外 | E-06 (L107-109) | ○ |
| C-139 | Router::setOptionで未サポートオプション例外 | E-06 (L119-121) | ○ |
| C-140 | Router::getOptionで未サポートオプション例外 | E-06 (L133-134) | ○ |
| C-141 | Router::setContextでコンテキスト設定 | E-06 (L145-155) | ○ |
| C-142 | Router::setContextでmatcher/generator伝播 | E-06 (L149-154) | △ |
| C-143 | Router::getRouteCollectionでロード | E-06 (L142) | ○ |
| C-144 | Router::matchRequestでRequestMatcherInterface使用 | E-06 (L182-189) | ○ |
| C-145 | Router::matchRequestでUrlMatcherInterfaceフォールバック | E-06 (L184-185) | ○ |
| C-146 | Alias::__constructでID設定 | E-07 (L20-23) | ○ |
| C-147 | Alias::withIdで不変クローン | E-07 (L25-31) | ○ |
| C-148 | Alias::setDeprecatedで非推奨設定 | E-07 (L55-74) | ○ |
| C-149 | Alias::setDeprecatedで改行含むメッセージ例外 | E-07 (L58-59) | ○ |
| C-150 | Alias::setDeprecatedでプレースホルダーなし例外 | E-07 (L62-63) | ○ |
| C-151 | Alias::getDeprecationでプレースホルダー置換 | E-07 (L84-91) | ○ |
| C-152 | Alias::isDeprecatedで未設定時false | E-07 (L78) | ○ |
| C-153 | EnumRequirement::__constructでBackedEnumクラス名 | E-19 (L26-33) | ○ |
| C-154 | EnumRequirement::__constructでBackedEnumインスタンス配列 | E-19 (L34-47) | ○ |
| C-155 | EnumRequirement::__constructで非BackedEnumクラス例外 | E-19 (L28-29) | ○ |
| C-156 | EnumRequirement::__constructで非Enumオブジェクト例外 | E-19 (L37-38) | ○ |
| C-157 | EnumRequirement::__constructで異なるEnumクラス混在例外 | E-19 (L43-44) | ○ |
| C-158 | EnumRequirement::__toStringでエスケープ文字列 | E-19 (L49) | ○ |
| C-159 | CompiledUrlMatcherDumper::dumpでPHPコード生成 | E-14 (L37-51) | ○ |
| C-160 | CompiledUrlMatcherDumper::getCompiledRoutesで配列返却 | E-14 (L61-127) | ○ |
| C-161 | CompiledUrlMatcherDumper静的ルートグループ化 | E-14 (L164-202) | ○ |
| C-162 | CompiledUrlMatcherDumper動的ルートコンパイル | E-14 (L252-368) | ○ |
| C-163 | CompiledUrlMatcherDumperホストマッチ有効化 | E-14 (L75-79) | ○ |
| C-164 | CompiledUrlMatcherDumper::exportでnull変換 | E-14 (L470-471) | ○ |
| C-165 | CompiledUrlMatcherDumper::exportで配列変換 | E-14 (L478-500) | ○ |
| C-166 | CompiledUrlMatcherDumper::exportでオブジェクト例外 | E-14 (L473-474) | ○ |
| C-167 | StaticPrefixCollection::addRouteでルート追加 | E-15 (L62-120) | ○ |
| C-168 | StaticPrefixCollection::addRouteでプレフィックスグループ化 | E-15 (L97-113) | ○ |
| C-169 | StaticPrefixCollection::populateCollectionで展開 | E-15 (L125-136) | ○ |
| C-170 | CompiledUrlGeneratorDumper::getCompiledRoutesで返却 | E-16 (L27-45) | ○ |
| C-171 | CompiledUrlGeneratorDumper::getCompiledAliasesで返却 | E-16 (L47-88) | ○ |
| C-172 | CompiledUrlGeneratorDumper::getCompiledAliasesで循環参照例外 | E-16 (L56-59) | ○ |
| C-173 | CompiledUrlGeneratorDumper::getCompiledAliasesでターゲット不在例外 | E-16 (L71-73) | ○ |
| C-174 | CompiledUrlGeneratorDumper::dumpでPHPコード生成 | E-16 (L91-102) | ○ |
| C-175 | Route属性::__constructで基本属性設定 | E-17 (L51-90) | ○ |
| C-176 | Route属性::__constructでlocale変換 | E-17 (L75-77) | ○ |
| C-177 | Route属性::__constructでformat変換 | E-17 (L79-81) | ○ |
| C-178 | Route属性::__constructでutf8オプション | E-17 (L83-85) | ○ |
| C-179 | Route属性::__constructでstateless変換 | E-17 (L87-89) | ○ |
| C-180 | Route属性::__constructでmethods文字列変換 | E-17 (L70) | ○ |
| C-181 | Route属性::__constructでenv変換 | E-17 (L72) | ○ |
| C-182 | Route属性::__constructでalias変換 | E-17 (L73) | ○ |
| C-183 | DeprecatedAlias::__constructで全プロパティ設定 | E-18 (L19-25) | ○ |
| C-184 | MethodNotAllowedException::__constructでメソッド正規化 | E-21 (L30) | ○ |
| C-185 | MethodNotAllowedException::getAllowedMethodsで返却 | E-21 (L40-43) | ○ |
| C-186 | MissingMandatoryParametersException::__constructで設定 | E-22 (L28-34) | ○ |
| C-187 | MissingMandatoryParametersException::getMissingParametersで返却 | E-22 (L40-43) | ○ |
| C-188 | MissingMandatoryParametersException::getRouteNameで返却 | E-22 (L45-48) | ○ |
| C-189 | ExpressionLanguageProvider::getFunctionsで取得 | E-23 (L31-43) | ○ |
| C-190 | ExpressionLanguageProvider::getで個別関数取得 | E-23 (L45-48) | ○ |
| C-191 | YamlFileLoader::loadでRouteCollectionロード | E-24 (L42-78) | △ |
| C-192 | YamlFileLoader::loadで無効YAMLエラー | E-24 (L58-59) | ○ |
| C-193 | YamlFileLoader::loadで空ファイル処理 | E-24 (L66-68) | ○ |
| C-194 | YamlFileLoader::supportsでyaml判定 | E-24 (L82) | ○ |
| C-195 | YamlFileLoader::supportsでyml判定 | E-24 (L82) | ○ |
| C-196 | YamlFileLoader::supportsで非YAML判定 | E-24 (L82) | ○ |
| C-197 | AttributeClassLoader::loadでRouteCollectionロード | E-25 (L77-140) | △ |
| C-198 | AttributeClassLoader::loadでクラス不在例外 | E-25 (L79-81) | ○ |
| C-199 | AttributeClassLoader::loadで抽象クラス例外 | E-25 (L84-86) | ○ |
| C-200 | AttributeClassLoader::supportsでクラス名判定 | E-25 (L243-245) | ○ |
| C-201 | RoutingConfigurator::importでインポート | E-26 (L37-52) | △ |
| C-202 | RoutingConfigurator::collectionでCollectionConfigurator返却 | E-26 (L54-57) | ○ |
| C-203 | RoutingConfigurator::envで環境名返却 | E-26 (L62-65) | ○ |
| C-204 | RoutingConfigurator::withPathでクローン返却 | E-26 (L67-73) | ○ |
| C-205 | RoutingResolverPass::processでタグ付きサービス追加 | E-27 (L28-38) | △ |
| C-206 | RoutingResolverPass::processで未定義時スキップ | E-27 (L30-31) | △ |

## 4) 不足情報（Unknown / Missing）
- C-93: RequestContext::fromRequestのテストはHttpFoundation Requestオブジェクトの実際の動作に依存するため、モックやスタブの構成詳細が不明
  - 候補：HttpFoundation Requestの仕様書 / テストフィクスチャ
- C-142: Router::setContextでmatcher/generatorが初期化済みかどうかの内部状態は外部から直接検証困難
  - 候補：RouterのgetMatcher()/getGenerator()後にsetContext()を呼ぶ統合テスト
- C-191, C-197: ファイルI/Oを伴うローダーのテストはファイルシステム依存、具体的なYAMLファイル内容やクラス構造が必要
  - 候補：テスト用フィクスチャファイル / テスト用コントローラクラス
- C-201: RoutingConfigurator::importはPhpFileLoaderとの連携が必要で、ローダー内部動作への依存あり
  - 候補：PhpFileLoaderのモック
- C-205, C-206: DI CompilerPassのテストはContainerBuilderのモックが必要
  - 候補：DependencyInjectionコンポーネントのテストユーティリティ

## 5) リスクフラグ（レビュー観点）
- 0: Route, RouteCollection, CompiledRoute, RequestContext, Alias, EnumRequirement - 単純なデータクラスでソースコードから直接テストケースを導出。低リスク。
- 0: RouteCompiler - コンパイルロジックは複雑だが、入出力が明確でソースコードから全バリデーション例外を特定済み。低リスク。
- 1: UrlGenerator, UrlMatcher - URL生成・マッチングロジックは多くの条件分岐を含み、エッジケースの網羅性確認が必要。中リスク。
- 1: CompiledUrlMatcherDumper, CompiledUrlGeneratorDumper - コード生成ロジックは複雑で、生成されたコードの正当性は実行して初めて確認可能。中リスク。
- 1: Loader系クラス（YamlFileLoader, AttributeClassLoader） - 外部I/O依存のため、テスト環境構築が必要。中リスク。
- 0: Exception系クラス - 単純なデータ保持クラス。低リスク。

## 6) レビュアーチェックリスト（最小）
- [ ] Route::setPath のインラインデフォルト・要件抽出パターン（正規表現）が全パターンを網羅しているか
- [ ] RouteCompiler のUTF-8関連テストケースが実際のマルチバイト文字で検証可能か
- [ ] UrlGenerator::doGenerate の「..」「.」パスセグメントのエンコード処理が全エッジケースをカバーしているか
- [ ] UrlMatcher の trailing slash 処理とRedirectableUrlMatcherとの連携が正しくテストされているか
- [ ] CompiledUrlMatcherDumper のregexp分割（chunkLimit）ロジックのエッジケースが十分か
- [ ] Loader系テストケースで、実際のファイルフィクスチャを用いたテスト環境が準備可能か
- [ ] DI CompilerPassテストでContainerBuilderのモック設定が適切か
- [ ] ロケールルート解決のテストケースでfallbackロジック（en_US -> en）が検証されているか
