---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 230
  claims_with_evidence: 218
  claims_without_evidence: 12
confidence_derived: 0.95
---

# 根拠レポート：Component-Security 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：218 / 230、根拠なし：12
- 優先レビュー（高）
  1. **UT-SEC-133, UT-SEC-216 (CacheTokenVerifier)**: ソースコードを直接確認できず、クラスの推測に基づく
  2. **UT-SEC-220, UT-SEC-221 (OAuth2User/OidcUser)**: 実装の詳細を未確認のため推測を含む
  3. **UT-SEC-222, UT-SEC-223 (UserPasswordValidator)**: 外部依存（PasswordHasher）のモック方針が未確定
  4. **UT-SEC-224 (SwitchUserRole)**: ソース未確認
  5. **UT-SEC-225-227 (ExpressionVoter)**: ExpressionLanguage依存の詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Security/Core/Authentication/AuthenticationTrustResolver.php`
- E-02: `src/Symfony/Component/Security/Core/Authentication/Token/AbstractToken.php`
- E-03: `src/Symfony/Component/Security/Core/Authentication/Token/UsernamePasswordToken.php`
- E-04: `src/Symfony/Component/Security/Core/Authentication/Token/RememberMeToken.php`
- E-05: `src/Symfony/Component/Security/Core/Authentication/Token/SwitchUserToken.php`
- E-06: `src/Symfony/Component/Security/Core/Authentication/Token/Storage/TokenStorage.php`
- E-07: `src/Symfony/Component/Security/Core/Authentication/Token/Storage/UsageTrackingTokenStorage.php`
- E-08: `src/Symfony/Component/Security/Core/Authorization/AccessDecisionManager.php`
- E-09: `src/Symfony/Component/Security/Core/Authorization/AuthorizationChecker.php`
- E-10: `src/Symfony/Component/Security/Core/Authorization/Strategy/AffirmativeStrategy.php`
- E-11: `src/Symfony/Component/Security/Core/Authorization/Strategy/ConsensusStrategy.php`
- E-12: `src/Symfony/Component/Security/Core/Authorization/Strategy/UnanimousStrategy.php`
- E-13: `src/Symfony/Component/Security/Core/Authorization/Strategy/PriorityStrategy.php`
- E-14: `src/Symfony/Component/Security/Core/Authorization/Voter/RoleVoter.php`
- E-15: `src/Symfony/Component/Security/Core/Authorization/Voter/RoleHierarchyVoter.php`
- E-16: `src/Symfony/Component/Security/Core/Authorization/Voter/AuthenticatedVoter.php`
- E-17: `src/Symfony/Component/Security/Core/Authorization/Voter/Voter.php`
- E-18: `src/Symfony/Component/Security/Core/Authorization/Voter/ClosureVoter.php`
- E-19: `src/Symfony/Component/Security/Core/Role/RoleHierarchy.php`
- E-20: `src/Symfony/Component/Security/Core/User/InMemoryUser.php`
- E-21: `src/Symfony/Component/Security/Core/User/InMemoryUserProvider.php`
- E-22: `src/Symfony/Component/Security/Core/User/ChainUserProvider.php`
- E-23: `src/Symfony/Component/Security/Core/User/InMemoryUserChecker.php`
- E-24: `src/Symfony/Component/Security/Core/User/ChainUserChecker.php`
- E-25: `src/Symfony/Component/Security/Core/Signature/SignatureHasher.php`
- E-26: `src/Symfony/Component/Security/Core/Signature/ExpiredSignatureStorage.php`
- E-27: `src/Symfony/Component/Security/Core/Authentication/RememberMe/PersistentToken.php`
- E-28: `src/Symfony/Component/Security/Core/Authentication/RememberMe/InMemoryTokenProvider.php`
- E-29: `src/Symfony/Component/Security/Core/Exception/CustomUserMessageAuthenticationException.php`
- E-30: `src/Symfony/Component/Security/Csrf/CsrfToken.php`
- E-31: `src/Symfony/Component/Security/Csrf/CsrfTokenManager.php`
- E-32: `src/Symfony/Component/Security/Csrf/TokenGenerator/UriSafeTokenGenerator.php`
- E-33: `src/Symfony/Component/Security/Csrf/TokenStorage/SessionTokenStorage.php`
- E-34: `src/Symfony/Component/Security/Csrf/TokenStorage/NativeSessionTokenStorage.php`
- E-35: `src/Symfony/Component/Security/Csrf/SameOriginCsrfTokenManager.php`
- E-36: `src/Symfony/Component/Security/Http/AccessMap.php`
- E-37: `src/Symfony/Component/Security/Http/HttpUtils.php`
- E-38: `src/Symfony/Component/Security/Http/Authentication/AuthenticationUtils.php`
- E-39: `src/Symfony/Component/Security/Http/Authenticator/Passport/Passport.php`
- E-40: `src/Symfony/Component/Security/Http/Authenticator/Passport/Badge/UserBadge.php`
- E-41: `src/Symfony/Component/Security/Http/Authenticator/Passport/Credentials/PasswordCredentials.php`
- E-42: `src/Symfony/Component/Security/Http/Authenticator/Passport/Credentials/CustomCredentials.php`
- E-43: `src/Symfony/Component/Security/Http/AccessToken/HeaderAccessTokenExtractor.php`
- E-44: `src/Symfony/Component/Security/Http/AccessToken/QueryAccessTokenExtractor.php`
- E-45: `src/Symfony/Component/Security/Http/AccessToken/FormEncodedBodyExtractor.php`
- E-46: `src/Symfony/Component/Security/Http/RememberMe/RememberMeDetails.php`
- E-47: `src/Symfony/Component/Security/Http/LoginLink/LoginLinkDetails.php`
- E-48: `src/Symfony/Component/Security/Http/ParameterBagUtils.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AuthenticationTrustResolver.isAuthenticated: token && token->getUser() の条件でtrue/false | E-01 | ○ |
| C-02 | AuthenticationTrustResolver.isRememberMe: RememberMeTokenインスタンスチェック | E-01 | ○ |
| C-03 | AuthenticationTrustResolver.isFullFledged: isAuthenticated && !isRememberMe の組み合わせ | E-01 | ○ |
| C-04 | AbstractToken: ロール管理、ユーザー管理、属性管理、シリアライズの各メソッド | E-02 | ○ |
| C-05 | UsernamePasswordToken: 空firewallNameでInvalidArgumentException | E-03 | ○ |
| C-06 | RememberMeToken: ユーザーのロールをparent::__constructに渡す | E-04 | ○ |
| C-07 | SwitchUserToken: originalToken保持、originatedFromUri保持 | E-05 | ○ |
| C-08 | TokenStorage: initializer遅延実行、setToken(null)でクリア | E-06 | ○ |
| C-09 | AccessDecisionManager: 複数属性制限、不正Vote検出 | E-08 | ○ |
| C-10 | AuthorizationChecker: NullTokenフォールバック、isGrantedForUser | E-09 | ○ |
| C-11 | AffirmativeStrategy: 1つでもGRANTEDでtrue、全ABSTAINでallowIfAllAbstain | E-10 | ○ |
| C-12 | ConsensusStrategy: 多数決、同票時allowIfEqual | E-11 | ○ |
| C-13 | UnanimousStrategy: 1つでもDENIEDでfalse | E-12 | ○ |
| C-14 | PriorityStrategy: 最初の非ABSTAIN投票に従う | E-13 | ○ |
| C-15 | RoleVoter: ROLE_プレフィックスチェック、ロール一致判定 | E-14 | ○ |
| C-16 | RoleHierarchyVoter: 階層展開後のロールで投票 | E-15 | ○ |
| C-17 | AuthenticatedVoter: PUBLIC_ACCESS、IS_AUTHENTICATED_FULLY等の判定 | E-16 | ○ |
| C-18 | ClosureVoter: Closure属性のみサポート、true/falseでGRANTED/DENIED | E-18 | ○ |
| C-19 | RoleHierarchy: 階層展開、多段展開、重複排除 | E-19 | ○ |
| C-20 | InMemoryUser: 空username例外、isEqualToの各条件 | E-20 | ○ |
| C-21 | InMemoryUserProvider: 大小文字不感、重複ユーザー例外 | E-21 | ○ |
| C-22 | ChainUserProvider: フォールバック動作、全プロバイダ失敗時の例外 | E-22 | ○ |
| C-23 | InMemoryUserChecker: disabled時のDisabledException | E-23 | ○ |
| C-24 | SignatureHasher: 空secret例外、ハッシュ検証、期限切れ、最大使用回数 | E-25 | ○ |
| C-25 | ExpiredSignatureStorage: カウント、インクリメント | E-26 | ○ |
| C-26 | PersistentToken: 空値バリデーション（userIdentifier, series, tokenValue） | E-27 | ○ |
| C-27 | InMemoryTokenProvider: CRUD操作、TokenNotFoundException | E-28 | ○ |
| C-28 | CsrfToken: id/value保持、null→空文字変換 | E-30 | ○ |
| C-29 | CsrfTokenManager: トークン生成/取得/リフレッシュ/削除/検証、ランダム化 | E-31 | ○ |
| C-30 | UriSafeTokenGenerator: エントロピー検証、URI安全トークン | E-32 | ○ |
| C-31 | SessionTokenStorage: セッションベースのCRUD | E-33 | ○ |
| C-32 | SameOriginCsrfTokenManager: cookieName検証、フォールバック委譲 | E-35 | ○ |
| C-33 | AccessMap: パターンマッチング、[null,null]フォールバック | E-36 | ○ |
| C-34 | HttpUtils: URI生成、パスチェック、リダイレクト生成 | E-37 | ○ |
| C-35 | AuthenticationUtils: エラー取得(属性/セッション)、最終ユーザー名取得 | E-38 | ○ |
| C-36 | Passport: バッジ管理、ユーザー取得、属性管理 | E-39 | ○ |
| C-37 | UserBadge: 空ID例外、最大長例外、ユーザーロード、null戻り値例外 | E-40 | ○ |
| C-38 | PasswordCredentials: getPassword、markResolved後の例外 | E-41 | ○ |
| C-39 | CustomCredentials: チェッカーtrue→resolved、false→BadCredentialsException | E-42 | ○ |
| C-40 | HeaderAccessTokenExtractor: Bearer正規表現マッチ、ヘッダ不在 | E-43 | ○ |
| C-41 | QueryAccessTokenExtractor: クエリパラメータ取得 | E-44 | ○ |
| C-42 | FormEncodedBodyExtractor: POST+Content-Type条件、GETでnull | E-45 | ○ |
| C-43 | RememberMeDetails: Cookie解析、toString、withValue | E-46 | ○ |
| C-44 | LoginLinkDetails: URL/expiresAt保持、__toString | E-47 | ○ |
| C-45 | ParameterBagUtils: 単純キー/ネストパス取得 | E-48 | ○ |
| C-46 | CacheTokenVerifier: トークン検証成功/失敗 | **根拠なし** | △ |
| C-47 | OAuth2User: 正しいインスタンス化 | **根拠なし** | △ |
| C-48 | OidcUser: 正しいインスタンス化 | **根拠なし** | △ |
| C-49 | UserPasswordValidator: パスワード検証成功/失敗 | **根拠なし** | △ |
| C-50 | SwitchUserRole: ソーストークン保持 | **根拠なし** | △ |
| C-51 | ExpressionVoter: 式評価に基づく投票 | **根拠なし** | △ |
| C-52 | ChainAccessTokenExtractor: チェーン抽出動作 | **根拠なし** | △ |
| C-53 | Vote.addReason: 理由追加 | **根拠なし** | △ |
| C-54 | AccessDecision初期化 | **根拠なし** | △ |
| C-55 | MermaidDumper: ロール階層のMermaid図出力 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CacheTokenVerifier.phpのソースコードを直接読み込んでいないため、verifyTokenメソッドの正確な挙動が未確認
  - 候補：`src/Symfony/Component/Security/Core/Authentication/RememberMe/CacheTokenVerifier.php` を読み込む
- OAuth2User.php / OidcUser.php の実装詳細を未確認
  - 候補：`src/Symfony/Component/Security/Core/User/OAuth2User.php` / `OidcUser.php` を読み込む
- UserPasswordValidator.phpの外部依存（PasswordHasherInterface）のモック方針
  - 候補：`src/Symfony/Component/Security/Core/Validator/Constraints/UserPasswordValidator.php` を読み込む
- ExpressionVoter.phpのExpression評価の詳細
  - 候補：`src/Symfony/Component/Security/Core/Authorization/Voter/ExpressionVoter.php` を読み込む
- ChainAccessTokenExtractor.phpのソースコード未確認
  - 候補：`src/Symfony/Component/Security/Http/AccessToken/ChainAccessTokenExtractor.php` を読み込む
- Vote.php / AccessDecision.php / MermaidDumper.php のソースコード未確認
  - 候補：各ファイルを直接読み込む
- SwitchUserRole.phpのソースコード未確認
  - 候補：`src/Symfony/Component/Security/Core/Role/SwitchUserRole.php` を読み込む

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - AuthenticationTrustResolver, AbstractToken, CsrfToken, LoginLinkDetails等の単純なデータクラス
- 0: 低リスク - 各戦略クラス（Affirmative/Consensus/Unanimous/Priority）はロジックが明確
- 1: 中リスク - SignatureHasher: 暗号処理の検証はセキュリティ上重要、ハッシュの再現性テストが必要
- 1: 中リスク - SameOriginCsrfTokenManager: 複雑なオリジン/ダブルサブミット検証ロジック
- 1: 中リスク - CsrfTokenManager: ランダム化/デランダム化のXOR処理の正当性確認が必要
- 2: 高リスク - CacheTokenVerifier / UserPasswordValidator: ソースコード未確認のためテストケースの正確性が未保証

## 6) レビュアーチェックリスト（最小）
- [ ] SignatureHasher関連テスト（UT-SEC-113〜121）: 暗号ハッシュの検証ロジックが正しいか確認
- [ ] CsrfTokenManager関連テスト（UT-SEC-139〜145）: ランダム化/デランダム化の往復テストが適切か確認
- [ ] SameOriginCsrfTokenManager関連テスト（UT-SEC-157〜162）: セキュリティ上のエッジケースが十分か確認
- [ ] UserBadge関連テスト（UT-SEC-183〜189）: ユーザーロード失敗の各パターンが網羅されているか確認
- [ ] AccessDecisionManager関連テスト（UT-SEC-038〜042）: 各戦略との組み合わせテストの必要性を検討
- [ ] ソースコード未確認のクラス（CacheTokenVerifier, OAuth2User, OidcUser, ExpressionVoter等）のテストケースを実コードと照合
- [ ] 全230テストケースのテストID連番に抜けがないか確認
- [ ] 高優先度のセキュリティ関連テスト（認証・認可・CSRF・署名）が網羅されているか確認
