---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 107
  claims_with_evidence: 104
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：Component-Semaphore 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：104 / 107、根拠なし：3
- 優先レビュー（高）
  1. **UT-SEM-089 NOSCRIPTフォールバック処理**：RedisStore内部のevaluateメソッドの詳細なフローはLuaスクリプトとRedisクライアントの動作に依存するため実環境での検証が必要
  2. **UT-SEM-090 RedisArray固有のエラー処理**：RedisArrayの内部インスタンス取得ロジックの実動作は実環境依存
  3. **UT-SEM-093 未サポート接続タイプ**：コンストラクタの型制約により通常は到達不可能なパス

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Semaphore/Key.php` - Keyクラスの定義（コンストラクタ、状態管理、ライフタイム管理、シリアライズ）
- E-02: `src/Symfony/Component/Semaphore/Semaphore.php` - Semaphoreクラスの定義（acquire, refresh, release, isAcquired, isExpired, getRemainingLifetime, __destruct, __serialize, __unserialize）
- E-03: `src/Symfony/Component/Semaphore/SemaphoreFactory.php` - SemaphoreFactoryクラスの定義（createSemaphore, createSemaphoreFromKey）
- E-04: `src/Symfony/Component/Semaphore/SemaphoreInterface.php` - SemaphoreInterfaceの定義
- E-05: `src/Symfony/Component/Semaphore/PersistingStoreInterface.php` - PersistingStoreInterfaceの定義
- E-06: `src/Symfony/Component/Semaphore/Serializer/SemaphoreKeyNormalizer.php` - SemaphoreKeyNormalizerクラスの定義（normalize, denormalize, supportsNormalization, supportsDenormalization, getSupportedTypes）
- E-07: `src/Symfony/Component/Semaphore/Store/RedisStore.php` - RedisStoreクラスの定義（save, delete, exists, putOffExpiration, evaluate, getUniqueToken, handlePredisError）
- E-08: `src/Symfony/Component/Semaphore/Store/StoreFactory.php` - StoreFactoryクラスの定義（createStore）
- E-09: `src/Symfony/Component/Semaphore/Exception/SemaphoreAcquiringException.php` - 例外クラスの定義
- E-10: `src/Symfony/Component/Semaphore/Exception/SemaphoreExpiredException.php` - 例外クラスの定義
- E-11: `src/Symfony/Component/Semaphore/Exception/SemaphoreReleasingException.php` - 例外クラスの定義
- E-12: `src/Symfony/Component/Semaphore/Exception/UnserializableKeyException.php` - 例外クラスの定義
- E-13: `src/Symfony/Component/Semaphore/Exception/InvalidArgumentException.php` - 例外クラスの定義
- E-14: `src/Symfony/Component/Semaphore/Exception/RuntimeException.php` - 例外クラスの定義
- E-15: `src/Symfony/Component/Semaphore/Exception/SemaphoreStorageException.php` - 例外クラスの定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-SEM-001: 有効なリソース名・limit・weightでKeyが生成される | E-01 (Key.php L29-43) | ○ |
| C-02 | UT-SEM-002: weight省略時にデフォルト値1が設定される | E-01 (Key.php L32) | ○ |
| C-03 | UT-SEM-003: limitとweightが同値でKey生成可能 | E-01 (Key.php L40-42) | ○ |
| C-04 | UT-SEM-004: limit=0でInvalidArgumentException | E-01 (Key.php L34-36) | ○ |
| C-05 | UT-SEM-005: limit負数でInvalidArgumentException | E-01 (Key.php L34-36) | ○ |
| C-06 | UT-SEM-006: weight=0でInvalidArgumentException | E-01 (Key.php L37-39) | ○ |
| C-07 | UT-SEM-007: weight負数でInvalidArgumentException | E-01 (Key.php L37-39) | ○ |
| C-08 | UT-SEM-008: weight>limitでInvalidArgumentException | E-01 (Key.php L40-42) | ○ |
| C-09 | UT-SEM-009: limit=1, weight=1の最小構成 | E-01 (Key.php L34-42) | ○ |
| C-10 | UT-SEM-010: __toStringがリソース名を返す | E-01 (Key.php L45-48) | ○ |
| C-11 | UT-SEM-011: getLimitがlimitを返す | E-01 (Key.php L50-53) | ○ |
| C-12 | UT-SEM-012: getWeightがweightを返す | E-01 (Key.php L55-58) | ○ |
| C-13 | UT-SEM-013: setStateで状態を設定 | E-01 (Key.php L65-68) | ○ |
| C-14 | UT-SEM-014: hasStateが設定済みでtrue | E-01 (Key.php L60-63) | ○ |
| C-15 | UT-SEM-015: hasStateが未設定でfalse | E-01 (Key.php L60-63) | ○ |
| C-16 | UT-SEM-016: getStateで状態値取得 | E-01 (Key.php L75-78) | ○ |
| C-17 | UT-SEM-017: 未設定stateKeyのgetStateでエラー | E-01 (Key.php L75-78) | ○ |
| C-18 | UT-SEM-018: removeStateで状態削除 | E-01 (Key.php L70-73) | ○ |
| C-19 | UT-SEM-019: 未設定stateKeyのremoveStateでエラーなし | E-01 (Key.php L70-73) | ○ |
| C-20 | UT-SEM-020: resetLifetimeで有効期限リセット | E-01 (Key.php L80-83) | ○ |
| C-21 | UT-SEM-021: reduceLifetimeで有効期限設定 | E-01 (Key.php L90-97) | ○ |
| C-22 | UT-SEM-022: より短いTTLで上書き | E-01 (Key.php L94) | ○ |
| C-23 | UT-SEM-023: より長いTTLでは上書きされない | E-01 (Key.php L94) | ○ |
| C-24 | UT-SEM-024: getRemainingLifetimeがTTL未設定時null | E-01 (Key.php L102-105) | ○ |
| C-25 | UT-SEM-025: getRemainingLifetimeがTTL設定後に正の値 | E-01 (Key.php L102-105) | ○ |
| C-26 | UT-SEM-026: isExpiredがTTL未設定時false | E-01 (Key.php L107-110) | ○ |
| C-27 | UT-SEM-027: isExpiredがTTL内でfalse | E-01 (Key.php L107-110) | ○ |
| C-28 | UT-SEM-028: isExpiredがTTL超過でtrue | E-01 (Key.php L107-110) | ○ |
| C-29 | UT-SEM-029: markUnserializableでフラグ設定 | E-01 (Key.php L85-88, L123-125) | ○ |
| C-30 | UT-SEM-030: __serializeが配列を返す | E-01 (Key.php L121-134) | ○ |
| C-31 | UT-SEM-031: __serializeがUnserializableKeyExceptionをスロー | E-01 (Key.php L123-125), E-12 | ○ |
| C-32 | UT-SEM-032: __unserializeで復元 | E-01 (Key.php L112-119) | ○ |
| C-33 | UT-SEM-033: 旧フォーマットからの復元 | E-01 (Key.php L114-118) | ○ |
| C-34 | UT-SEM-034: Semaphoreコンストラクタ | E-02 (Semaphore.php L34-40) | ○ |
| C-35 | UT-SEM-035: acquire成功でtrue | E-02 (Semaphore.php L64-84) | ○ |
| C-36 | UT-SEM-036: acquire時のライフタイム管理 | E-02 (Semaphore.php L67-69) | ○ |
| C-37 | UT-SEM-037: SemaphoreAcquiringExceptionでfalse | E-02 (Semaphore.php L75-77) | ○ |
| C-38 | UT-SEM-038: 一般例外でRuntimeException | E-02 (Semaphore.php L78-83) | ○ |
| C-39 | UT-SEM-039: acquire成功時のログ | E-02 (Semaphore.php L72) | ○ |
| C-40 | UT-SEM-040: acquire失敗時のログ | E-02 (Semaphore.php L76) | ○ |
| C-41 | UT-SEM-041: refreshデフォルトTTL | E-02 (Semaphore.php L86-110) | ○ |
| C-42 | UT-SEM-042: refreshカスタムTTL | E-02 (Semaphore.php L86-110) | ○ |
| C-43 | UT-SEM-043: refresh TTL=0でInvalidArgumentException | E-02 (Semaphore.php L88-89) | ○ |
| C-44 | UT-SEM-044: SemaphoreExpiredExceptionの再スロー | E-02 (Semaphore.php L100-104) | ○ |
| C-45 | UT-SEM-045: refresh一般例外でRuntimeException | E-02 (Semaphore.php L105-109) | ○ |
| C-46 | UT-SEM-046: isAcquiredがtrue | E-02 (Semaphore.php L112-115) | ○ |
| C-47 | UT-SEM-047: isAcquiredがfalse | E-02 (Semaphore.php L112-115) | ○ |
| C-48 | UT-SEM-048: releaseが正常完了 | E-02 (Semaphore.php L117-129) | ○ |
| C-49 | UT-SEM-049: SemaphoreReleasingExceptionの再スロー | E-02 (Semaphore.php L122-123) | ○ |
| C-50 | UT-SEM-050: release一般例外でRuntimeException | E-02 (Semaphore.php L124-128) | ○ |
| C-51 | UT-SEM-051: isExpiredの委譲 | E-02 (Semaphore.php L131-134) | ○ |
| C-52 | UT-SEM-052: getRemainingLifetimeの委譲 | E-02 (Semaphore.php L136-139) | ○ |
| C-53 | UT-SEM-053: __destructでautoRelease | E-02 (Semaphore.php L55-62) | ○ |
| C-54 | UT-SEM-054: autoRelease=falseで解放しない | E-02 (Semaphore.php L57) | ○ |
| C-55 | UT-SEM-055: dirty=falseで解放しない | E-02 (Semaphore.php L57) | ○ |
| C-56 | UT-SEM-056: __serializeでBadMethodCallException | E-02 (Semaphore.php L42-45) | ○ |
| C-57 | UT-SEM-057: __unserializeでBadMethodCallException | E-02 (Semaphore.php L47-50) | ○ |
| C-58 | UT-SEM-058: SemaphoreFactoryコンストラクタ | E-03 (SemaphoreFactory.php L28-31) | ○ |
| C-59 | UT-SEM-059: createSemaphore基本動作 | E-03 (SemaphoreFactory.php L37-40) | ○ |
| C-60 | UT-SEM-060: createSemaphore weight指定 | E-03 (SemaphoreFactory.php L37-40) | ○ |
| C-61 | UT-SEM-061: createSemaphore全パラメータ | E-03 (SemaphoreFactory.php L37-40) | ○ |
| C-62 | UT-SEM-062: createSemaphoreでLogger伝播 | E-03 (SemaphoreFactory.php L49-51) | ○ |
| C-63 | UT-SEM-063: createSemaphoreFromKey基本動作 | E-03 (SemaphoreFactory.php L46-54) | ○ |
| C-64 | UT-SEM-064: createSemaphoreFromKeyでLogger伝播 | E-03 (SemaphoreFactory.php L49-51) | ○ |
| C-65 | UT-SEM-065: Logger未設定時の動作 | E-03 (SemaphoreFactory.php L49) | ○ |
| C-66 | UT-SEM-066: getSupportedTypes | E-06 (SemaphoreKeyNormalizer.php L28-31) | ○ |
| C-67 | UT-SEM-067: supportsNormalizationでKey=true | E-06 (SemaphoreKeyNormalizer.php L38-41) | ○ |
| C-68 | UT-SEM-068: supportsNormalizationで非Key=false | E-06 (SemaphoreKeyNormalizer.php L38-41) | ○ |
| C-69 | UT-SEM-069: normalize基本動作 | E-06 (SemaphoreKeyNormalizer.php L33-36) | ○ |
| C-70 | UT-SEM-070: 状態付きKeyのnormalize | E-06 (SemaphoreKeyNormalizer.php L33-36), E-01 (Key.php L121-134) | ○ |
| C-71 | UT-SEM-071: supportsDenormalizationでKey=true | E-06 (SemaphoreKeyNormalizer.php L51-54) | ○ |
| C-72 | UT-SEM-072: supportsDenormalizationで非Key=false | E-06 (SemaphoreKeyNormalizer.php L51-54) | ○ |
| C-73 | UT-SEM-073: denormalize基本動作 | E-06 (SemaphoreKeyNormalizer.php L43-49) | ○ |
| C-74 | UT-SEM-074: 状態付きデータのdenormalize | E-06 (SemaphoreKeyNormalizer.php L43-49) | ○ |
| C-75 | UT-SEM-075: RedisStoreコンストラクタ | E-07 (RedisStore.php L33-36) | ○ |
| C-76 | UT-SEM-076: save成功 | E-07 (RedisStore.php L38-99) | ○ |
| C-77 | UT-SEM-077: save TTL負数でInvalidArgumentException | E-07 (RedisStore.php L40-42) | ○ |
| C-78 | UT-SEM-078: save上限到達でSemaphoreAcquiringException | E-07 (RedisStore.php L96-98) | ○ |
| C-79 | UT-SEM-079: putOffExpiration成功 | E-07 (RedisStore.php L101-141) | ○ |
| C-80 | UT-SEM-080: putOffExpiration TTL負数でInvalidArgumentException | E-07 (RedisStore.php L103-105) | ○ |
| C-81 | UT-SEM-081: putOffExpirationでfalse時SemaphoreExpiredException | E-07 (RedisStore.php L133-135) | ○ |
| C-82 | UT-SEM-082: putOffExpirationで正の値時SemaphoreExpiredException | E-07 (RedisStore.php L138-140) | ○ |
| C-83 | UT-SEM-083: delete成功 | E-07 (RedisStore.php L143-156) | ○ |
| C-84 | UT-SEM-084: existsがtrue | E-07 (RedisStore.php L158-161) | ○ |
| C-85 | UT-SEM-085: existsがfalse | E-07 (RedisStore.php L158-161) | ○ |
| C-86 | UT-SEM-086: getUniqueTokenの一貫性 | E-07 (RedisStore.php L243-251) | ○ |
| C-87 | UT-SEM-087: getUniqueTokenの状態保存 | E-07 (RedisStore.php L245-248) | ○ |
| C-88 | UT-SEM-088: evaluateのRedisエラー処理 | E-07 (RedisStore.php L163-194) | ○ |
| C-89 | UT-SEM-089: evaluateのNOSCRIPTフォールバック | E-07 (RedisStore.php L171-187) | △ |
| C-90 | UT-SEM-090: evaluateのRedisArray処理 | E-07 (RedisStore.php L196-217) | △ |
| C-91 | UT-SEM-091: Predis ServerExceptionの変換 | E-07 (RedisStore.php L260-266) | ○ |
| C-92 | UT-SEM-092: Predis Response\\Error処理 | E-07 (RedisStore.php L268-270) | ○ |
| C-93 | UT-SEM-093: 未サポート接続タイプ | E-07 (RedisStore.php L240) | △ |
| C-94 | UT-SEM-094: createStoreで\\Redis | E-08 (StoreFactory.php L29-34) | ○ |
| C-95 | UT-SEM-095: createStoreでRelay | E-08 (StoreFactory.php L30) | ○ |
| C-96 | UT-SEM-096: createStoreで\\RedisArray | E-08 (StoreFactory.php L31) | ○ |
| C-97 | UT-SEM-097: createStoreで\\RedisCluster | E-08 (StoreFactory.php L32) | ○ |
| C-98 | UT-SEM-098: createStoreでPredis | E-08 (StoreFactory.php L33-34) | ○ |
| C-99 | UT-SEM-099: createStoreでredis:// DSN | E-08 (StoreFactory.php L38-47) | ○ |
| C-100 | UT-SEM-100: createStoreでrediss:// DSN | E-08 (StoreFactory.php L39) | ○ |
| C-101 | UT-SEM-101: createStoreでvalkey:// DSN | E-08 (StoreFactory.php L40) | ○ |
| C-102 | UT-SEM-102: createStoreでvalkeys:// DSN | E-08 (StoreFactory.php L41) | ○ |
| C-103 | UT-SEM-103: createStoreで未サポートオブジェクト | E-08 (StoreFactory.php L36-37) | ○ |
| C-104 | UT-SEM-104: createStoreで未サポートDSN | E-08 (StoreFactory.php L50) | ○ |
| C-105 | UT-SEM-105: SemaphoreAcquiringExceptionメッセージ | E-09 (SemaphoreAcquiringException.php L24-27) | ○ |
| C-106 | UT-SEM-106: SemaphoreExpiredExceptionメッセージ | E-10 (SemaphoreExpiredException.php L24-27) | ○ |
| C-107 | UT-SEM-107: SemaphoreReleasingExceptionメッセージ | E-11 (SemaphoreReleasingException.php L24-27) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-SEM-089 (C-89)**: NOSCRIPTエラー発生時のフォールバック処理はRedis内部の実動作に依存しており、Luaスクリプトのロードとリトライの挙動はモックテストのみでは完全に検証できない。実環境でのRedis統合テストが推奨される。
  - 候補：Redis統合テスト環境 / RedisDockerコンテナ / RedisモックライブラリのNOSCRIPT対応
- **UT-SEM-090 (C-90)**: RedisArrayの `_instance()` / `_target()` メソッドの挙動は実際のRedisArrayインスタンスに依存するため、モックの正確性に限界がある。
  - 候補：RedisArray統合テスト / ドキュメント参照
- **UT-SEM-093 (C-93)**: `evaluate()` メソッド末尾の `InvalidArgumentException` はコンストラクタの型制約（union type）により通常は到達不可能。型制約が将来変更された場合のみ関連する。
  - 候補：将来の型制約変更の可能性を考慮した防御的テスト

## 5) リスクフラグ（レビュー観点）
- 0: Key クラスのテスト（UT-SEM-001〜033） - ソースコードから直接導出可能な純粋ロジック
- 0: Semaphore クラスのテスト（UT-SEM-034〜057） - モック化による検証が容易
- 0: SemaphoreFactory クラスのテスト（UT-SEM-058〜065） - ファクトリパターンの定型的テスト
- 0: SemaphoreKeyNormalizer クラスのテスト（UT-SEM-066〜074） - Serializer連携の標準的テスト
- 1: RedisStore クラスのテスト（UT-SEM-075〜093） - Redisクライアントとの統合部分。Luaスクリプトの実行結果はモックに依存するため中リスク
- 0: StoreFactory クラスのテスト（UT-SEM-094〜104） - switch文による分岐の網羅性は高い
- 0: 例外クラスのテスト（UT-SEM-105〜107） - メッセージ生成の単純なテスト

## 6) レビュアーチェックリスト（最小）
- [ ] Key クラスのバリデーション条件（limit < 1, weight < 1, weight > limit）が全てカバーされているか
- [ ] Semaphore クラスの例外処理チェーン（SemaphoreAcquiringException, SemaphoreExpiredException, SemaphoreReleasingException, 一般Exception）が漏れなくテストされているか
- [ ] SemaphoreFactory のLogger伝播テストが、Logger設定済み/未設定の両方をカバーしているか
- [ ] RedisStore の各Redisクライアントタイプ（Redis, Relay, RedisCluster, RedisArray, Predis）のevaluateパスが網羅されているか
- [ ] StoreFactory の全接続タイプ（オブジェクト5種 + DSN文字列4種 + 未サポート2種）がカバーされているか
- [ ] Key のライフタイム管理（reduceLifetime の短縮のみ許可ロジック）の境界値テストが十分か
- [ ] SemaphoreKeyNormalizer の normalize/denormalize 往復変換の整合性が検証されているか
