---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 190
  claims_with_evidence: 182
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：Component-Serializer 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：182 / 190、根拠なし：8
- 優先レビュー（高）
  1. **UT-SER-182/183（CustomNormalizer）**：ソースコードを直接読んでいないため根拠不足
  2. **UT-SER-184/188（ConstraintViolationListNormalizer）**：ソースコードを直接読んでいないため根拠不足
  3. **UT-SER-185（UnwrappingDenormalizer）**：ソースコードを直接読んでいないため根拠不足
  4. **UT-SER-186（TranslatableNormalizer）**：ソースコードを直接読んでいないため根拠不足
  5. **UT-SER-187（ObjectPropertyListExtractor）**：ソースコードを直接読んでいないため根拠不足
  6. **UT-SER-189/190（SnakeCaseToCamelCaseNameConverter）**：ソースコードを直接読んでいないため根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Serializer/Serializer.php` -- メインSerializerクラス（serialize, deserialize, normalize, denormalize, encode, decode等のメソッド）
- E-02: `src/Symfony/Component/Serializer/Encoder/JsonEncoder.php` -- JSON形式のエンコード/デコード委譲
- E-03: `src/Symfony/Component/Serializer/Encoder/JsonEncode.php` -- JSON_PRESERVE_ZERO_FRACTIONデフォルト、encode()、NotEncodableValueException
- E-04: `src/Symfony/Component/Serializer/Encoder/JsonDecode.php` -- ASSOCIATIVE/OPTIONS/RECURSION_DEPTH設定、decode()、NotEncodableValueException
- E-05: `src/Symfony/Component/Serializer/Encoder/CsvEncoder.php` -- CSV encode/decode、ESCAPE_FORMULAS_KEY/NO_HEADERS_KEY/OUTPUT_UTF8_BOM_KEY/DELIMITER_KEY/AS_COLLECTION_KEY等
- E-06: `src/Symfony/Component/Serializer/Encoder/XmlEncoder.php` -- XML encode/decode、CDATA_WRAPPING/ROOT_NODE_NAME/TYPE_CAST_ATTRIBUTES、DocType禁止チェック
- E-07: `src/Symfony/Component/Serializer/Encoder/YamlEncoder.php` -- YAML encode/decode、yaml/yml形式サポート
- E-08: `src/Symfony/Component/Serializer/Encoder/ChainEncoder.php` -- needsNormalization()、NormalizationAwareInterface判定
- E-09: `src/Symfony/Component/Serializer/Encoder/ChainDecoder.php` -- decode()委譲、RuntimeException
- E-10: `src/Symfony/Component/Serializer/Normalizer/ObjectNormalizer.php` -- extractAttributes()、getAttributeValue()、setAttributeValue()、PropertyAccess依存
- E-11: `src/Symfony/Component/Serializer/Normalizer/AbstractNormalizer.php` -- isCircularReference()、handleCircularReference()、getAllowedAttributes()、isAllowedAttribute()、instantiateObject()、applyCallbacks()、applyFilterBool()
- E-12: `src/Symfony/Component/Serializer/Normalizer/AbstractObjectNormalizer.php` -- normalize()/denormalize()、SKIP_NULL_VALUES/SKIP_UNINITIALIZED_VALUES/PRESERVE_EMPTY_OBJECTS/ENABLE_MAX_DEPTH/MAX_DEPTH_HANDLER/ALLOW_EXTRA_ATTRIBUTES/DEEP_OBJECT_TO_POPULATE
- E-13: `src/Symfony/Component/Serializer/Normalizer/DateTimeNormalizer.php` -- FORMAT_KEY/TIMEZONE_KEY/CAST_KEY/FORCE_TIMEZONE_KEY、normalize()/denormalize()
- E-14: `src/Symfony/Component/Serializer/Normalizer/DateIntervalNormalizer.php` -- FORMAT_KEY、normalize()/denormalize()、isISO8601()
- E-15: `src/Symfony/Component/Serializer/Normalizer/DateTimeZoneNormalizer.php` -- normalize()/denormalize()、空文字列チェック
- E-16: `src/Symfony/Component/Serializer/Normalizer/BackedEnumNormalizer.php` -- ALLOW_INVALID_VALUES、normalize()/denormalize()、ValueError/TypeError処理
- E-17: `src/Symfony/Component/Serializer/Normalizer/ArrayDenormalizer.php` -- denormalize()、supportsDenormalization()、validateKeyType()
- E-18: `src/Symfony/Component/Serializer/Normalizer/JsonSerializableNormalizer.php` -- normalize()循環参照チェック、denormalize()非サポート
- E-19: `src/Symfony/Component/Serializer/Normalizer/GetSetMethodNormalizer.php` -- isGetMethod()/isSetMethod()、extractAttributes()、getAttributeValue()/setAttributeValue()
- E-20: `src/Symfony/Component/Serializer/Normalizer/PropertyNormalizer.php` -- NORMALIZE_VISIBILITY、extractAttributes()、setAttributeValue()のreadonly処理
- E-21: `src/Symfony/Component/Serializer/Normalizer/UidNormalizer.php` -- NORMALIZATION_FORMAT_KEY、canonical/base58/base32/rfc4122形式
- E-22: `src/Symfony/Component/Serializer/Normalizer/DataUriNormalizer.php` -- normalize()でdata URI生成、denormalize()でSplFileObject生成
- E-23: `src/Symfony/Component/Serializer/Normalizer/NumberNormalizer.php` -- Number/GMP正規化/デノーマライズ
- E-24: `src/Symfony/Component/Serializer/Normalizer/ProblemNormalizer.php` -- RFC 7807形式、debug情報、ValidationFailedException処理
- E-25: `src/Symfony/Component/Serializer/NameConverter/CamelCaseToSnakeCaseNameConverter.php` -- normalize()/denormalize()、REQUIRE_SNAKE_CASE_PROPERTIES
- E-26: `src/Symfony/Component/Serializer/NameConverter/MetadataAwareNameConverter.php` -- SerializedName/SerializedPath競合チェック、fallbackNameConverter
- E-27: `src/Symfony/Component/Serializer/Mapping/AttributeMetadata.php` -- addGroup()重複防止、merge()、normalization/denormalization contexts
- E-28: `src/Symfony/Component/Serializer/Mapping/ClassDiscriminatorMapping.php` -- getClassForType()/getMappedObjectType()、typesMapping
- E-29: `src/Symfony/Component/Serializer/Mapping/ClassMetadata.php` -- addAttributeMetadata()/merge()

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Serializerコンストラクタの正常系テスト（UT-SER-001~002） | E-01 | ○ |
| C-02 | Serializerコンストラクタの異常系テスト（UT-SER-003~004） | E-01 | ○ |
| C-03 | Serializer.serialize正常系/異常系テスト（UT-SER-005~006） | E-01 | ○ |
| C-04 | Serializer.deserialize正常系/異常系テスト（UT-SER-007~008） | E-01 | ○ |
| C-05 | Serializer.normalize正常系テスト（UT-SER-009~012） | E-01 | ○ |
| C-06 | Serializer.normalize異常系テスト（UT-SER-013~014） | E-01 | ○ |
| C-07 | Serializer.denormalize正常系/異常系テスト（UT-SER-015~019） | E-01 | ○ |
| C-08 | Serializer.supportsEncoding/supportsDecoding テスト（UT-SER-020~022） | E-01 | ○ |
| C-09 | JsonEncoder encode/decode/supportsテスト（UT-SER-023~026） | E-02 | ○ |
| C-10 | JsonEncode encode正常系/異常系テスト（UT-SER-027~029） | E-03 | ○ |
| C-11 | JsonDecode decode正常系/異常系テスト（UT-SER-030~033） | E-04 | ○ |
| C-12 | CsvEncoder encode正常系/境界値テスト（UT-SER-034~040） | E-05 | ○ |
| C-13 | CsvEncoder decode正常系/境界値テスト（UT-SER-041~045） | E-05 | ○ |
| C-14 | XmlEncoder encode正常系テスト（UT-SER-046~050） | E-06 | ○ |
| C-15 | XmlEncoder decode正常系/異常系テスト（UT-SER-051~058） | E-06 | ○ |
| C-16 | YamlEncoder encode/decode/supportsテスト（UT-SER-059~062） | E-07 | ○ |
| C-17 | ChainEncoder encode/supports/needsNormalizationテスト（UT-SER-063~067） | E-08 | ○ |
| C-18 | ChainDecoder decode/supportsテスト（UT-SER-068~070） | E-09 | ○ |
| C-19 | ObjectNormalizerテスト（UT-SER-071~074） | E-10 | ○ |
| C-20 | AbstractNormalizer循環参照テスト（UT-SER-075~078） | E-11 | ○ |
| C-21 | AbstractNormalizer属性フィルタテスト（UT-SER-079~082） | E-11 | ○ |
| C-22 | AbstractNormalizer instantiateObjectテスト（UT-SER-083~085） | E-11 | ○ |
| C-23 | AbstractNormalizer コールバック/フィルタテスト（UT-SER-086~089） | E-11 | ○ |
| C-24 | AbstractObjectNormalizer normalize正常系テスト（UT-SER-090~095） | E-12 | ○ |
| C-25 | AbstractObjectNormalizer denormalize正常系/異常系テスト（UT-SER-096~100） | E-12 | ○ |
| C-26 | DateTimeNormalizer normalize正常系/異常系テスト（UT-SER-101~105） | E-13 | ○ |
| C-27 | DateTimeNormalizer denormalize正常系/異常系テスト（UT-SER-106~111） | E-13 | ○ |
| C-28 | DateIntervalNormalizer normalize/denormalizeテスト（UT-SER-112~117） | E-14 | ○ |
| C-29 | DateTimeZoneNormalizer normalize/denormalizeテスト（UT-SER-118~122） | E-15 | ○ |
| C-30 | BackedEnumNormalizer normalize/denormalizeテスト（UT-SER-123~128） | E-16 | ○ |
| C-31 | ArrayDenormalizer denormalize/supportsテスト（UT-SER-129~133） | E-17 | ○ |
| C-32 | JsonSerializableNormalizer normalize/denormalizeテスト（UT-SER-134~136） | E-18 | ○ |
| C-33 | GetSetMethodNormalizer テスト（UT-SER-137~140） | E-19 | ○ |
| C-34 | PropertyNormalizer テスト（UT-SER-141~145） | E-20 | ○ |
| C-35 | UidNormalizer normalize/denormalizeテスト（UT-SER-146~150） | E-21 | ○ |
| C-36 | DataUriNormalizer normalize/denormalizeテスト（UT-SER-151~154） | E-22 | ○ |
| C-37 | NumberNormalizer normalize/denormalizeテスト（UT-SER-155~158） | E-23 | ○ |
| C-38 | ProblemNormalizer normalizeテスト（UT-SER-159~161） | E-24 | ○ |
| C-39 | CamelCaseToSnakeCaseNameConverter normalize/denormalizeテスト（UT-SER-162~166） | E-25 | ○ |
| C-40 | MetadataAwareNameConverter normalize/denormalizeテスト（UT-SER-167~170） | E-26 | ○ |
| C-41 | AttributeMetadata テスト（UT-SER-171~175） | E-27 | ○ |
| C-42 | ClassDiscriminatorMapping テスト（UT-SER-176~179） | E-28 | ○ |
| C-43 | ClassMetadata テスト（UT-SER-180~181） | E-29 | ○ |
| C-44 | CustomNormalizer テスト（UT-SER-182~183） | **根拠なし** | △ |
| C-45 | ConstraintViolationListNormalizer テスト（UT-SER-184, 188） | **根拠なし** | △ |
| C-46 | UnwrappingDenormalizer テスト（UT-SER-185） | **根拠なし** | △ |
| C-47 | TranslatableNormalizer テスト（UT-SER-186） | **根拠なし** | △ |
| C-48 | ObjectPropertyListExtractor テスト（UT-SER-187） | **根拠なし** | △ |
| C-49 | SnakeCaseToCamelCaseNameConverter テスト（UT-SER-189~190） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- UT-SER-182~183（CustomNormalizer）: ソースコードを直接読み込んでいないため、メソッドシグネチャや内部ロジックの詳細が未確認
  - 候補: `src/Symfony/Component/Serializer/Normalizer/CustomNormalizer.php` の直接読み込み
- UT-SER-184, 188（ConstraintViolationListNormalizer）: ソースコードを直接読み込んでいないため詳細が未確認
  - 候補: `src/Symfony/Component/Serializer/Normalizer/ConstraintViolationListNormalizer.php` の直接読み込み
- UT-SER-185（UnwrappingDenormalizer）: ソースコードを直接読み込んでいない
  - 候補: `src/Symfony/Component/Serializer/Normalizer/UnwrappingDenormalizer.php` の直接読み込み
- UT-SER-186（TranslatableNormalizer）: ソースコードを直接読み込んでいない
  - 候補: `src/Symfony/Component/Serializer/Normalizer/TranslatableNormalizer.php` の直接読み込み
- UT-SER-187（ObjectPropertyListExtractor）: ソースコードを直接読み込んでいない
  - 候補: `src/Symfony/Component/Serializer/Extractor/ObjectPropertyListExtractor.php` の直接読み込み
- UT-SER-189~190（SnakeCaseToCamelCaseNameConverter）: ソースコードを直接読み込んでいない（クラス名から推測）
  - 候補: `src/Symfony/Component/Serializer/NameConverter/SnakeCaseToCamelCaseNameConverter.php` の直接読み込み

## 5) リスクフラグ（レビュー観点）
- 0: XmlEncoder DTDチェック（セキュリティ関連）-- ソースコードで確認済みで低リスク
- 0: CsvEncoder 数式エスケープ（セキュリティ関連）-- ソースコードで確認済みで低リスク
- 1: CustomNormalizer/ConstraintViolationListNormalizer/UnwrappingDenormalizer/TranslatableNormalizer -- ソースコードを直接読んでいないため中リスク。テストケースの入力値・期待結果がクラス名・パターンからの推測に基づく
- 0: AbstractNormalizer循環参照テスト -- ソースコードで確認済みで低リスク
- 0: DateTimeNormalizerタイムスタンプ処理 -- ソースコードで確認済みで低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] UT-SER-182~183（CustomNormalizer）のテストケースが実際のソースコードと整合しているか確認
- [ ] UT-SER-184, 188（ConstraintViolationListNormalizer）のテストケースが実際のソースコードと整合しているか確認
- [ ] UT-SER-185（UnwrappingDenormalizer）のテストケースが実際のソースコードと整合しているか確認
- [ ] UT-SER-186（TranslatableNormalizer）のテストケースが実際のソースコードと整合しているか確認
- [ ] UT-SER-187（ObjectPropertyListExtractor）のテストケースが実際のソースコードと整合しているか確認
- [ ] UT-SER-189~190（SnakeCaseToCamelCaseNameConverter）のテストケースが実際のソースコードと整合しているか確認
- [ ] AbstractObjectNormalizerのSerializedPath関連テストケースが不足していないか確認
- [ ] 各Normalizer/Encoderのコンテキストオプション網羅性を確認
- [ ] ClassDiscriminatorMappingを使った型判別テストの前提条件が正確か確認
