---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 282
  claims_with_evidence: 272
  claims_without_evidence: 10
confidence_derived: 0.96
---

# 根拠レポート：Component-String 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：272 / 282、根拠なし：10
- 優先レビュー（高）
  1. **LazyString::fromCallable の遅延評価キャッシュテスト（UT-STR-218）**：内部動作のキャッシュ機構は実装から推定しているが、直接的なテスト検証根拠がない
  2. **AsciiSlugger::withEmoji のテスト（UT-STR-278, 279）**：EmojiTransliterator依存のため、symfony/emojiパッケージがない環境での挙動確認が必要
  3. **ロケール依存テスト（UT-STR-211〜213）**：intl拡張の有無により挙動が異なる可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/String/AbstractString.php` - 抽象文字列クラス（全メソッド定義）
- E-02: `src/Symfony/Component/String/AbstractUnicodeString.php` - 抽象Unicode文字列クラス
- E-03: `src/Symfony/Component/String/ByteString.php` - バイト文字列クラス
- E-04: `src/Symfony/Component/String/CodePointString.php` - コードポイント文字列クラス
- E-05: `src/Symfony/Component/String/UnicodeString.php` - Unicode(グラフェムクラスタ)文字列クラス
- E-06: `src/Symfony/Component/String/LazyString.php` - 遅延評価文字列クラス
- E-07: `src/Symfony/Component/String/TruncateMode.php` - 切り詰めモードenum
- E-08: `src/Symfony/Component/String/Inflector/EnglishInflector.php` - 英語屈折変換
- E-09: `src/Symfony/Component/String/Inflector/FrenchInflector.php` - フランス語屈折変換
- E-10: `src/Symfony/Component/String/Inflector/SpanishInflector.php` - スペイン語屈折変換
- E-11: `src/Symfony/Component/String/Inflector/InflectorInterface.php` - 屈折変換インターフェース
- E-12: `src/Symfony/Component/String/Slugger/AsciiSlugger.php` - ASCIIスラッグ生成クラス
- E-13: `src/Symfony/Component/String/Slugger/SluggerInterface.php` - スラッグ生成インターフェース
- E-14: `src/Symfony/Component/String/Exception/InvalidArgumentException.php` - 例外クラス
- E-15: `src/Symfony/Component/String/Exception/RuntimeException.php` - 例外クラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ByteString::__construct は文字列をそのまま保持する | E-03 (L31-34) | ○ |
| C-02 | ByteString::fromRandom は指定長のランダム文字列を生成する | E-03 (L46-60) | ○ |
| C-03 | ByteString::fromRandom は length<=0 で InvalidArgumentException | E-03 (L48-49) | ○ |
| C-04 | ByteString::fromRandom はアルファベット長の範囲チェック | E-03 (L55-57) | ○ |
| C-05 | ByteString::bytesAt は指定オフセットのバイト値を返す | E-03 (L62-67) | ○ |
| C-06 | ByteString::chunk は文字列を指定長で分割する | E-03 (L88-107) | ○ |
| C-07 | ByteString::chunk は length<1 で InvalidArgumentException | E-03 (L90-91) | ○ |
| C-08 | ByteString::endsWith は ignoreCase 対応 | E-03 (L109-118) | ○ |
| C-09 | ByteString::equalsTo は ignoreCase 時に strcasecmp 使用 | E-03 (L120-133) | ○ |
| C-10 | ByteString::indexOf は空文字列で null を返す | E-03 (L151-152) | ○ |
| C-11 | ByteString::isUtf8 は空文字列で true を返す | E-03 (L178-179) | ○ |
| C-12 | ByteString::split は空デリミタで InvalidArgumentException | E-03 (L339-341) | ○ |
| C-13 | CodePointString::__construct は無効UTF-8で例外 | E-04 (L27-34) | ○ |
| C-14 | CodePointString::append は UTF-8 検証を行う | E-04 (L36-46) | ○ |
| C-15 | CodePointString::length は mb_strlen を使用 | E-04 (L151-154) | ○ |
| C-16 | UnicodeString::__construct は NFC 正規化を行う | E-05 (L35-46) | ○ |
| C-17 | UnicodeString::length は grapheme_strlen を使用 | E-05 (L200-203) | ○ |
| C-18 | UnicodeString::indexOf は grapheme_strpos を使用 | E-05 (L138-160) | ○ |
| C-19 | UnicodeString::normalize は不正な形式で例外 | E-05 (L205-219) | ○ |
| C-20 | UnicodeString::__unserialize は string 以外で BadMethodCallException | E-05 (L411-420) | ○ |
| C-21 | AbstractString::after は needle 後の文字列を返す | E-01 (L96-124) | ○ |
| C-22 | AbstractString::before は needle 前の文字列を返す | E-01 (L164-192) | ○ |
| C-23 | AbstractString::repeat は負の multiplier で例外 | E-01 (L414-424) | ○ |
| C-24 | AbstractString::truncate は TruncateMode 対応 | E-01 (L618-654), E-07 | ○ |
| C-25 | AbstractString::trimPrefix は配列対応 | E-01 (L555-582) | ○ |
| C-26 | AbstractUnicodeString::ascii は TRANSLIT テーブルを使用 | E-02 (L43-46, L77-159) | ○ |
| C-27 | AbstractUnicodeString::folded は Unicode case folding を行う | E-02 (L193-205) | ○ |
| C-28 | AbstractUnicodeString::padBoth は無効UTF-8で例外 | E-02 (L277-287) | ○ |
| C-29 | AbstractUnicodeString::width は wcswidth アルゴリズム使用 | E-02 (L504-534, L575-640) | ○ |
| C-30 | LazyString::fromCallable は Closure で遅延評価する | E-06 (L26-50) | ○ |
| C-31 | LazyString::isStringable はスカラー値/Stringable で true | E-06 (L67-70) | ○ |
| C-32 | LazyString::__toString は非文字列返却で TypeError | E-06 (L82-102) | ○ |
| C-33 | EnglishInflector::singularize は PLURAL_MAP に基づく | E-08 (L462-536) | ○ |
| C-34 | EnglishInflector::pluralize は SINGULAR_MAP に基づく | E-08 (L538-613) | ○ |
| C-35 | EnglishInflector は UNINFLECTED リストを持つ | E-08 (L407-460) | ○ |
| C-36 | FrenchInflector は正規表現ベースで変換する | E-09 (L26-105) | ○ |
| C-37 | SpanishInflector は正規表現ベースで変換する | E-10 (L24-73) | ○ |
| C-38 | AsciiSlugger::slug は ASCII 音訳と記号置換を行う | E-12 (L104-150) | ○ |
| C-39 | AsciiSlugger は LOCALE_TO_TRANSLITERATOR_ID マッピングを持つ | E-12 (L28-56) | ○ |
| C-40 | LazyString::fromCallable のキャッシュ動作 | E-06 (L33-47) 推定 | △ |
| C-41 | AsciiSlugger::withEmoji の emoji 有効化テスト | E-12 (L92-102) | △ |
| C-42 | ロケール依存の lower/upper/title 変換テスト | E-02 (L232-242, L489-502, L390-400) | △ |
| C-43 | AbstractUnicodeString::ascii の Closure ルール対応テスト | E-02 (L103-106) | △ |
| C-44 | UnicodeString::indexOfLast の負オフセット処理 | E-05 (L179-184) | △ |
| C-45 | ByteString::toCodePointString のエンコーディング変換 | E-03 (L384-419) | △ |
| C-46 | AbstractString::wordwrap の cut=true 挙動 | E-01 (L663-707) | △ |
| C-47 | EnglishInflector 複数候補返却ケースの正確な候補値 | E-08 推定 | △ |
| C-48 | FrenchInflector 敬称変換の正確な結果 | E-09 (L63-64) | △ |
| C-49 | AsciiSlugger::slug クロージャ symbolsMap の動作 | E-12 (L120-125) | △ |

## 4) 不足情報（Unknown / Missing）
- **EmojiTransliterator の可用性**: `withEmoji` 関連のテストは `symfony/emoji` パッケージの有無に依存する。パッケージ未インストール環境ではテストが正しく機能しない可能性がある
  - 候補：symfony/emoji パッケージの composer.json / パッケージインストール状況
- **intl 拡張の有無**: `localeLower`, `localeUpper`, `localeTitle`, `Transliterator` 関連テストは intl 拡張に依存する
  - 候補：phpinfo() / php -m での拡張確認
- **EnglishInflector の PLURAL_MAP/SINGULAR_MAP の網羅性**: テーブル駆動の変換ルールをすべて網羅するにはデータ駆動テストが必要
  - 候補：既存テストスイートのデータプロバイダ
- **LazyString の遅延評価キャッシュ**: 内部の static 変数によるキャッシュ機構を直接テストする根拠が不足
  - 候補：既存テストスイートの確認

## 5) リスクフラグ（レビュー観点）
- 1（中リスク）: EnglishInflector の複数候補返却テスト - 実際のPLURAL_MAP/SINGULAR_MAPから返却される候補の正確な値は、テーブルの順序と条件に依存するため実行確認が必要
- 1（中リスク）: AsciiSlugger のロケール対応テスト - intl 拡張がないと一部の音訳パスが異なる
- 0（低リスク）: TruncateMode enum テスト - PHPのenumは定義通りに動作するため

## 6) レビュアーチェックリスト（最小）
- [ ] 各クラスのpublicメソッドが漏れなくテストケースに含まれているか
- [ ] 正常系・異常系・境界値の3観点が主要メソッドに網羅されているか
- [ ] UTF-8検証を行うメソッド（CodePointString, UnicodeString）で無効UTF-8テストが含まれているか
- [ ] NFC正規化を行うUnicodeStringのメソッドで正規化テストが含まれているか
- [ ] Inflector（英語・フランス語・スペイン語）の変換テストで代表的なパターンが含まれているか
- [ ] AsciiSluggerのスラッグ生成テストでロケール対応・記号置換が含まれているか
- [ ] LazyStringの遅延評価・キャッシュ・型エラーの各テストが含まれているか
- [ ] テストID（UT-STR-NNN）が連番で重複がないか
- [ ] 優先度（高/中/低）が適切に設定されているか（セキュリティ・データ整合性は「高」）
