---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 210
  claims_with_evidence: 207
  claims_without_evidence: 3
confidence_derived: 0.99
---

# 根拠レポート：Component-Translation 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：207 / 210、根拠なし：3
- 優先レビュー（高）
  1. **C-183 (UT-TRN-183)**：ディレクトリ作成失敗のRuntimeException発生条件は環境依存のため、再現テスト方法の確認が必要
  2. **C-086 (UT-TRN-086)**：runWithLocaleのfinally句による例外時復元は実装確認済みだが、テスト実装時にはPhpUnitのexpectException利用順序に注意
  3. **C-117 (UT-TRN-117)**：moveMessagesToIntlDomainsIfPossibleはMessageFormatterクラスの存在チェックを含むため、テスト環境でのintl拡張の有無に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Translation/Translator.php` - Translatorクラスの実装
- E-02: `src/Symfony/Component/Translation/MessageCatalogue.php` - MessageCatalogueクラスの実装
- E-03: `src/Symfony/Component/Translation/TranslatableMessage.php` - TranslatableMessageクラスの実装
- E-04: `src/Symfony/Component/Translation/StaticMessage.php` - StaticMessageクラスの実装
- E-05: `src/Symfony/Component/Translation/TranslatorBag.php` - TranslatorBagクラスの実装
- E-06: `src/Symfony/Component/Translation/LocaleSwitcher.php` - LocaleSwitcherクラスの実装
- E-07: `src/Symfony/Component/Translation/LoggingTranslator.php` - LoggingTranslatorクラスの実装
- E-08: `src/Symfony/Component/Translation/DataCollectorTranslator.php` - DataCollectorTranslatorクラスの実装
- E-09: `src/Symfony/Component/Translation/PseudoLocalizationTranslator.php` - PseudoLocalizationTranslatorクラスの実装
- E-10: `src/Symfony/Component/Translation/IdentityTranslator.php` - IdentityTranslatorクラスの実装
- E-11: `src/Symfony/Component/Translation/Catalogue/AbstractOperation.php` - AbstractOperationクラスの実装
- E-12: `src/Symfony/Component/Translation/Catalogue/MergeOperation.php` - MergeOperationクラスの実装
- E-13: `src/Symfony/Component/Translation/Catalogue/TargetOperation.php` - TargetOperationクラスの実装
- E-14: `src/Symfony/Component/Translation/Formatter/MessageFormatter.php` - MessageFormatterクラスの実装
- E-15: `src/Symfony/Component/Translation/Formatter/IntlFormatter.php` - IntlFormatterクラスの実装
- E-16: `src/Symfony/Component/Translation/Loader/ArrayLoader.php` - ArrayLoaderクラスの実装
- E-17: `src/Symfony/Component/Translation/Loader/FileLoader.php` - FileLoaderクラスの実装
- E-18: `src/Symfony/Component/Translation/Loader/XliffFileLoader.php` - XliffFileLoaderクラスの実装
- E-19: `src/Symfony/Component/Translation/Dumper/FileDumper.php` - FileDumperクラスの実装
- E-20: `src/Symfony/Component/Translation/Dumper/XliffFileDumper.php` - XliffFileDumperクラスの実装
- E-21: `src/Symfony/Component/Translation/Provider/Dsn.php` - Dsnクラスの実装
- E-22: `src/Symfony/Component/Translation/Provider/TranslationProviderCollection.php` - TranslationProviderCollectionクラスの実装
- E-23: `src/Symfony/Component/Translation/Provider/FilteringProvider.php` - FilteringProviderクラスの実装
- E-24: `src/Symfony/Component/Translation/Provider/NullProvider.php` - NullProviderクラスの実装
- E-25: `src/Symfony/Component/Translation/Provider/NullProviderFactory.php` - NullProviderFactoryクラスの実装
- E-26: `src/Symfony/Component/Translation/Provider/AbstractProviderFactory.php` - AbstractProviderFactoryクラスの実装
- E-27: `src/Symfony/Component/Translation/Provider/TranslationProviderCollectionFactory.php` - TranslationProviderCollectionFactoryクラスの実装
- E-28: `src/Symfony/Component/Translation/Writer/TranslationWriter.php` - TranslationWriterクラスの実装
- E-29: `src/Symfony/Component/Translation/Reader/TranslationReader.php` - TranslationReaderクラスの実装
- E-30: `src/Symfony/Component/Translation/Extractor/ChainExtractor.php` - ChainExtractorクラスの実装
- E-31: `src/Symfony/Component/Translation/Extractor/AbstractFileExtractor.php` - AbstractFileExtractorクラスの実装
- E-32: `src/Symfony/Component/Translation/Util/ArrayConverter.php` - ArrayConverterクラスの実装
- E-33: `src/Symfony/Component/Translation/Util/XliffUtils.php` - XliffUtilsクラスの実装
- E-34: `src/Symfony/Component/Translation/DataCollector/TranslationDataCollector.php` - TranslationDataCollectorクラスの実装
- E-35: `src/Symfony/Component/Translation/Exception/UnsupportedSchemeException.php` - UnsupportedSchemeExceptionクラスの実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Translator: 有効なロケールでインスタンスが生成される | E-01 (L76-87) | ○ |
| C-002 | Translator: 無効なロケールで例外がスローされる | E-01 (L453-457: assertValidLocale) | ○ |
| C-003 | Translator: デフォルトMessageFormatterが使用される | E-01 (L85-86) | ○ |
| C-004 | Translator: setLocaleで有効なロケールが設定される | E-01 (L128-132) | ○ |
| C-005 | Translator: setLocaleで無効なロケールが拒否される | E-01 (L130) | ○ |
| C-006 | Translator: getLocaleで設定値が返る | E-01 (L134-137) | ○ |
| C-007 | Translator: 空ロケールでデフォルトが返る | E-01 (L136) | ○ |
| C-008 | Translator: addLoaderでローダーが追加される | E-01 (L99-102) | ○ |
| C-009 | Translator: addResourceでリソースが追加される | E-01 (L112-126) | ○ |
| C-010 | Translator: addResourceで無効ロケールが拒否される | E-01 (L116) | ○ |
| C-011 | Translator: addResourceのデフォルトドメイン | E-01 (L114) | ○ |
| C-012 | Translator: setFallbackLocalesでフォールバック設定 | E-01 (L146-162) | ○ |
| C-013 | Translator: 無効フォールバックロケールで例外 | E-01 (L157-159) | ○ |
| C-014 | Translator: 同一フォールバック設定でカタログ非クリア | E-01 (L148-152) | ○ |
| C-015 | Translator: transで翻訳メッセージが返る | E-01 (L185-232) | ○ |
| C-016 | Translator: transでパラメータ置換 | E-01 (L204-208) | ○ |
| C-017 | Translator: transでnull idが空文字を返す | E-01 (L187-189) | ○ |
| C-018 | Translator: transで空id文字列が空文字を返す | E-01 (L187-189) | ○ |
| C-019 | Translator: transでフォールバックカタログ使用 | E-01 (L195-202) | ○ |
| C-020 | Translator: 翻訳未定義時にIDが返る | E-02 (L117-118: get) | ○ |
| C-021 | Translator: デフォルトドメインmessages | E-01 (L191) | ○ |
| C-022 | Translator: TranslatableInterfaceパラメータの翻訳 | E-01 (L204-208) | ○ |
| C-023 | Translator: IntlFormatterでICUメッセージ書式化 | E-01 (L223-229) | ○ |
| C-024 | Translator: グローバルパラメータ追加と利用 | E-01 (L174-178, L210-221) | ○ |
| C-025 | Translator: getCatalogueでカタログ取得 | E-01 (L234-247) | ○ |
| C-026 | Translator: getCatalogueでデフォルトロケール | E-01 (L236-237) | ○ |
| C-027 | Translator: getCataloguesで全カタログ取得 | E-01 (L249-252) | ○ |
| C-028 | Translator: assertValidLocaleのパストラバーサル防止 | E-01 (L455) | ○ |
| C-029 | Translator: computeFallbackLocalesの親ロケール計算 | E-01 (L407-446) | ○ |
| C-030 | Translator: doLoadCatalogueのローダー未登録エラー | E-01 (L371-387) | ○ |
| C-031 | MessageCatalogue: コンストラクタ | E-02 (L31-35) | ○ |
| C-032 | MessageCatalogue: getLocale | E-02 (L37-39) | ○ |
| C-033 | MessageCatalogue: getDomains | E-02 (L42-54) | ○ |
| C-034 | MessageCatalogue: getDomains intlドメインハンドリング | E-02 (L47-49) | ○ |
| C-035 | MessageCatalogue: getDomains 空カタログ | E-02 (L42-54) | ○ |
| C-036 | MessageCatalogue: all 指定ドメイン | E-02 (L56-79) | ○ |
| C-037 | MessageCatalogue: all 全ドメイン | E-02 (L67-78) | ○ |
| C-038 | MessageCatalogue: all intlメッセージマージ | E-02 (L60-64) | ○ |
| C-039 | MessageCatalogue: set | E-02 (L81-84) | ○ |
| C-040 | MessageCatalogue: has 存在時true | E-02 (L86-97) | ○ |
| C-041 | MessageCatalogue: has 不在時false | E-02 (L86-97) | ○ |
| C-042 | MessageCatalogue: has フォールバック検索 | E-02 (L92-94) | ○ |
| C-043 | MessageCatalogue: defines 定義済みtrue | E-02 (L99-102) | ○ |
| C-044 | MessageCatalogue: defines フォールバック除外 | E-02 (L99-102) | ○ |
| C-045 | MessageCatalogue: get 取得 | E-02 (L104-119) | ○ |
| C-046 | MessageCatalogue: get intl優先 | E-02 (L106-108) | ○ |
| C-047 | MessageCatalogue: get フォールバック | E-02 (L114-116) | ○ |
| C-048 | MessageCatalogue: get ID返却 | E-02 (L118) | ○ |
| C-049 | MessageCatalogue: replace | E-02 (L121-126) | ○ |
| C-050 | MessageCatalogue: add | E-02 (L128-139) | ○ |
| C-051 | MessageCatalogue: add intlドメイン競合解消 | E-02 (L130-133) | ○ |
| C-052 | MessageCatalogue: addCatalogue マージ | E-02 (L141-168) | ○ |
| C-053 | MessageCatalogue: addCatalogue ロケール不一致 | E-02 (L143-145) | ○ |
| C-054 | MessageCatalogue: addFallbackCatalogue | E-02 (L170-197) | ○ |
| C-055 | MessageCatalogue: addFallbackCatalogue 循環参照 | E-02 (L173-178) | ○ |
| C-056 | MessageCatalogue: setMetadata | E-02 (L243-246) | ○ |
| C-057 | MessageCatalogue: getMetadata 指定キー | E-02 (L214-241) | ○ |
| C-058 | MessageCatalogue: getMetadata 不在 | E-02 (L240) | ○ |
| C-059 | MessageCatalogue: getMetadata 全取得 | E-02 (L216-218) | ○ |
| C-060 | MessageCatalogue: deleteMetadata 指定キー | E-02 (L248-257) | ○ |
| C-061 | MessageCatalogue: deleteMetadata 全削除 | E-02 (L250-251) | ○ |
| C-062 | MessageCatalogue: setCatalogueMetadata | E-02 (L278-281) | ○ |
| C-063 | MessageCatalogue: getCatalogueMetadata 不在 | E-02 (L275) | ○ |
| C-064 | MessageCatalogue: deleteCatalogueMetadata | E-02 (L283-292) | ○ |
| C-065 | TranslatableMessage: コンストラクタ | E-03 (L22-27) | ○ |
| C-066 | TranslatableMessage: getMessage | E-03 (L29-32) | ○ |
| C-067 | TranslatableMessage: getParameters | E-03 (L34-37) | ○ |
| C-068 | TranslatableMessage: getDomain | E-03 (L39-42) | ○ |
| C-069 | TranslatableMessage: getDomain null | E-03 (L25) | ○ |
| C-070 | TranslatableMessage: trans | E-03 (L44-54) | ○ |
| C-071 | TranslatableMessage: trans 再帰翻訳 | E-03 (L47-50) | ○ |
| C-072 | StaticMessage: コンストラクタ | E-04 (L19-22) | ○ |
| C-073 | StaticMessage: trans 翻訳なし | E-04 (L29-32) | ○ |
| C-074 | TranslatorBag: addCatalogue | E-05 (L22-29) | ○ |
| C-075 | TranslatorBag: addCatalogue マージ | E-05 (L24-25) | ○ |
| C-076 | TranslatorBag: addBag | E-05 (L31-36) | ○ |
| C-077 | TranslatorBag: getCatalogue | E-05 (L38-45) | ○ |
| C-078 | TranslatorBag: getCatalogue 自動生成 | E-05 (L40-41) | ○ |
| C-079 | TranslatorBag: diff | E-05 (L52-75) | ○ |
| C-080 | TranslatorBag: intersect | E-05 (L77-101) | ○ |
| C-081 | LocaleSwitcher: コンストラクタ | E-06 (L27-33) | ○ |
| C-082 | LocaleSwitcher: setLocale | E-06 (L35-51) | ○ |
| C-083 | LocaleSwitcher: setLocale サービス伝播 | E-06 (L48-50) | ○ |
| C-084 | LocaleSwitcher: setLocale RequestContext | E-06 (L46) | ○ |
| C-085 | LocaleSwitcher: runWithLocale | E-06 (L67-77) | ○ |
| C-086 | LocaleSwitcher: runWithLocale 例外時復元 | E-06 (L73-76: try/finally) | ○ |
| C-087 | LocaleSwitcher: reset | E-06 (L79-82) | ○ |
| C-088 | LoggingTranslator: trans 委譲 | E-07 (L29-35) | ○ |
| C-089 | LoggingTranslator: trans 欠落warning | E-07 (L95) | ○ |
| C-090 | LoggingTranslator: trans フォールバックdebug | E-07 (L93) | ○ |
| C-091 | LoggingTranslator: setLocale debug | E-07 (L37-46) | ○ |
| C-092 | LoggingTranslator: setLocale 同一ロケール | E-07 (L41-43) | ○ |
| C-093 | DataCollectorTranslator: trans 収集 | E-08 (L40-45) | ○ |
| C-094 | DataCollectorTranslator: trans DEFINED | E-08 (L115-116) | ○ |
| C-095 | DataCollectorTranslator: trans MISSING | E-08 (L128-129) | ○ |
| C-096 | DataCollectorTranslator: trans EQUALS_FALLBACK | E-08 (L117-118) | ○ |
| C-097 | DataCollectorTranslator: getCollectedMessages | E-08 (L103-106) | ○ |
| C-098 | DataCollectorTranslator: reset | E-08 (L35-38) | ○ |
| C-099 | DataCollectorTranslator: getFallbackLocales | E-08 (L80-87) | ○ |
| C-100 | PseudoLocalizationTranslator: コンストラクタ | E-09 (L67-86) | ○ |
| C-101 | PseudoLocalizationTranslator: expansion_factor < 1 | E-09 (L74-76) | ○ |
| C-102 | PseudoLocalizationTranslator: accents | E-09 (L194-293) | ○ |
| C-103 | PseudoLocalizationTranslator: brackets | E-09 (L371-378) | ○ |
| C-104 | PseudoLocalizationTranslator: expansion | E-09 (L295-369) | ○ |
| C-105 | PseudoLocalizationTranslator: parse_html | E-09 (L137-154) | ○ |
| C-106 | PseudoLocalizationTranslator: getCatalogue 例外 | E-09 (L119-126) | ○ |
| C-107 | IdentityTranslator: trans ID返却 | E-10 (L23-26: TranslatorTrait使用) | ○ |
| C-108 | IdentityTranslator: setLocale | E-10 (L27-30) | ○ |
| C-109 | AbstractOperation: コンストラクタ | E-11 (L63-73) | ○ |
| C-110 | AbstractOperation: 異なるロケール例外 | E-11 (L67-69) | ○ |
| C-111 | AbstractOperation: getDomains | E-11 (L75-93) | ○ |
| C-112 | AbstractOperation: getMessages | E-11 (L95-106) | ○ |
| C-113 | AbstractOperation: getMessages 無効ドメイン | E-11 (L97-99) | ○ |
| C-114 | AbstractOperation: getNewMessages | E-11 (L108-119) | ○ |
| C-115 | AbstractOperation: getObsoleteMessages | E-11 (L121-132) | ○ |
| C-116 | AbstractOperation: getResult | E-11 (L134-143) | ○ |
| C-117 | AbstractOperation: moveMessagesToIntlDomainsIfPossible | E-11 (L148-174) | ○ |
| C-118 | MergeOperation: processDomain | E-12 (L27-68) | ○ |
| C-119 | MergeOperation: obsolete空 | E-12 (L31) | ○ |
| C-120 | TargetOperation: processDomain | E-13 (L28-82) | ○ |
| C-121 | TargetOperation: obsolete | E-13 (L67) | ○ |
| C-122 | TargetOperation: new | E-13 (L74) | ○ |
| C-123 | MessageFormatter: format | E-14 (L37-40) | ○ |
| C-124 | MessageFormatter: formatIntl | E-14 (L42-45) | ○ |
| C-125 | IntlFormatter: formatIntl | E-15 (L26-56) | ○ |
| C-126 | IntlFormatter: 空メッセージ | E-15 (L29-31) | ○ |
| C-127 | IntlFormatter: 不正ICUメッセージ | E-15 (L37-41) | ○ |
| C-128 | IntlFormatter: パラメータキー正規化 | E-15 (L44-48) | ○ |
| C-129 | ArrayLoader: load | E-16 (L23-30) | ○ |
| C-130 | ArrayLoader: フラット化 | E-16 (L40-56) | ○ |
| C-131 | ArrayLoader: 空配列 | E-16 (L23-30) | ○ |
| C-132 | ArrayLoader: null値スキップ | E-16 (L50-51) | ○ |
| C-133 | FileLoader: load | E-17 (L24-51) | ○ |
| C-134 | FileLoader: ファイル不在 | E-17 (L30-32) | ○ |
| C-135 | FileLoader: 非ローカルファイル | E-17 (L26-28) | ○ |
| C-136 | FileLoader: 不正リソース | E-17 (L40-42) | ○ |
| C-137 | XliffFileLoader: XLIFF 1.2 | E-18 (L31-73, L91-154) | ○ |
| C-138 | XliffFileLoader: XLIFF 2.0 | E-18 (L156-204) | ○ |
| C-139 | XliffFileLoader: XML文字列 | E-18 (L52-53, L244-247) | ○ |
| C-140 | XliffFileLoader: 不正XML | E-18 (L57-58) | ○ |
| C-141 | XliffFileLoader: メタデータ抽出 | E-18 (L136-138, L218-242) | ○ |
| C-142 | FileDumper: dump | E-19 (L41-78) | ○ |
| C-143 | FileDumper: path必須 | E-19 (L43-45) | ○ |
| C-144 | FileDumper: setRelativePathTemplate | E-19 (L36-39) | ○ |
| C-145 | XliffFileDumper: formatCatalogue XLIFF 1.2 | E-20 (L57-138) | ○ |
| C-146 | XliffFileDumper: formatCatalogue XLIFF 2.0 | E-20 (L140-221) | ○ |
| C-147 | XliffFileDumper: 未サポートバージョン | E-20 (L49) | ○ |
| C-148 | XliffFileDumper: 特殊文字CDATA | E-20 (L103) | ○ |
| C-149 | Dsn: コンストラクタ | E-21 (L32-55) | ○ |
| C-150 | Dsn: 無効DSN | E-21 (L36-38) | ○ |
| C-151 | Dsn: スキームなし | E-21 (L40-42) | ○ |
| C-152 | Dsn: ホストなし | E-21 (L45-47) | ○ |
| C-153 | Dsn: getScheme | E-21 (L57-60) | ○ |
| C-154 | Dsn: getUser URLデコード | E-21 (L50) | ○ |
| C-155 | Dsn: getUser null | E-21 (L50) | ○ |
| C-156 | Dsn: getRequiredOption | E-21 (L87-94) | ○ |
| C-157 | Dsn: getRequiredOption 不在 | E-21 (L89-91) | ○ |
| C-158 | Dsn: getOption | E-21 (L82-85) | ○ |
| C-159 | Dsn: getOption デフォルト | E-21 (L84) | ○ |
| C-160 | TranslationProviderCollection: コンストラクタ | E-22 (L29-32) | ○ |
| C-161 | TranslationProviderCollection: has true | E-22 (L39-42) | ○ |
| C-162 | TranslationProviderCollection: has false | E-22 (L39-42) | ○ |
| C-163 | TranslationProviderCollection: get | E-22 (L44-51) | ○ |
| C-164 | TranslationProviderCollection: get 例外 | E-22 (L46-48) | ○ |
| C-165 | TranslationProviderCollection: __toString | E-22 (L34-37) | ○ |
| C-166 | FilteringProvider: read フィルタリング | E-23 (L42-48) | ○ |
| C-167 | FilteringProvider: read ドメインフィルタなし | E-23 (L44) | ○ |
| C-168 | FilteringProvider: __toString | E-23 (L32-35) | ○ |
| C-169 | NullProvider: read | E-24 (L31-34) | ○ |
| C-170 | NullProvider: __toString | E-24 (L22-25) | ○ |
| C-171 | NullProviderFactory: create null | E-25 (L21-25) | ○ |
| C-172 | NullProviderFactory: create 非null例外 | E-25 (L27) | ○ |
| C-173 | AbstractProviderFactory: supports true | E-26 (L18-21) | ○ |
| C-174 | AbstractProviderFactory: supports false | E-26 (L18-21) | ○ |
| C-175 | AbstractProviderFactory: getUser 例外 | E-26 (L28-31) | ○ |
| C-176 | AbstractProviderFactory: getPassword 例外 | E-26 (L33-36) | ○ |
| C-177 | TranslationProviderCollectionFactory: fromConfig | E-27 (L30-42) | ○ |
| C-178 | TranslationProviderCollectionFactory: fromDsnObject 例外 | E-27 (L44-53) | ○ |
| C-179 | TranslationWriter: addDumper | E-28 (L34-37) | ○ |
| C-180 | TranslationWriter: getFormats | E-28 (L42-45) | ○ |
| C-181 | TranslationWriter: write | E-28 (L55-70) | ○ |
| C-182 | TranslationWriter: write 未登録フォーマット | E-28 (L57-59) | ○ |
| C-183 | TranslationWriter: write ディレクトリ作成失敗 | E-28 (L64-66) | △ |
| C-184 | TranslationReader: addLoader | E-29 (L37-40) | ○ |
| C-185 | TranslationReader: read | E-29 (L42-58) | ○ |
| C-186 | TranslationReader: read 不在ディレクトリ | E-29 (L44-46) | ○ |
| C-187 | ChainExtractor: addExtractor | E-30 (L33-36) | ○ |
| C-188 | ChainExtractor: setPrefix | E-30 (L38-43) | ○ |
| C-189 | ChainExtractor: extract | E-30 (L45-50) | ○ |
| C-190 | AbstractFileExtractor: isFile true | E-31 (L49-56) | ○ |
| C-191 | AbstractFileExtractor: isFile 例外 | E-31 (L51-53) | ○ |
| C-192 | ArrayConverter: expandToTree 基本 | E-32 (L34-47) | ○ |
| C-193 | ArrayConverter: expandToTree 深いネスト | E-32 (L34-47) | ○ |
| C-194 | ArrayConverter: expandToTree 空配列 | E-32 (L34-47) | ○ |
| C-195 | ArrayConverter: expandToTree キー競合 | E-32 (L55-63, L86-97) | ○ |
| C-196 | XliffUtils: getVersionNumber 1.2 | E-33 (L32-52) | ○ |
| C-197 | XliffUtils: getVersionNumber 2.0 | E-33 (L34-36) | ○ |
| C-198 | XliffUtils: getVersionNumber デフォルト | E-33 (L51) | ○ |
| C-199 | XliffUtils: validateSchema 成功 | E-33 (L59-83) | ○ |
| C-200 | XliffUtils: validateSchema 失敗 | E-33 (L68-69) | ○ |
| C-201 | XliffUtils: getErrorsAsString | E-33 (L110-126) | ○ |
| C-202 | TranslationDataCollector: collect | E-34 (L43-48) | ○ |
| C-203 | TranslationDataCollector: lateCollect | E-34 (L33-41) | ○ |
| C-204 | TranslationDataCollector: getCountMissings | E-34 (L60-63) | ○ |
| C-205 | TranslationDataCollector: getCountFallbacks | E-34 (L65-68) | ○ |
| C-206 | TranslationDataCollector: getCountDefines | E-34 (L70-73) | ○ |
| C-207 | TranslationDataCollector: reset | E-34 (L50-53) | ○ |
| C-208 | TranslationDataCollector: getName | E-34 (L96-99) | ○ |
| C-209 | UnsupportedSchemeException: パッケージ推奨 | E-35 (L38-49) | △ |
| C-210 | UnsupportedSchemeException: サポート情報メッセージ | E-35 (L51-56) | △ |

## 4) 不足情報（Unknown / Missing）
- C-183: TranslationWriter::writeのディレクトリ作成失敗テストは、書き込み不可パスの再現がOS環境に依存するため、テスト実行環境の権限設定を確認する必要がある
  - 候補：一時ディレクトリへの書き込み制限 / モックファイルシステム / vfsStream
- C-209, C-210: UnsupportedSchemeExceptionの条件分岐テストは、ブリッジクラスの存在/不存在がclass_exists()に依存するため、テスト環境での対象パッケージのインストール状態に左右される
  - 候補：条件付きテスト（@requires） / クラスローダーのモック

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：テストケースの大部分はソースコードのメソッドシグネチャと分岐条件から直接導出されており、実装との整合性が高い
- 1（中リスク）：intl拡張依存の処理（IntlFormatter, ICUメッセージ）はPHP拡張の有無によりテスト結果が変わる可能性がある
- 0（低リスク）：DependencyInjectionディレクトリ内のCompiler Passは単体テスト対象として含めていない（DIコンテナの結合テスト向け）

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースが主要クラス（Translator, MessageCatalogue, TranslatableMessage）の全publicメソッドを網羅しているか
- [ ] 正常系・異常系・境界値のバランスが適切か
- [ ] IntlFormatter関連のテストでintl拡張の有無を前提条件として記載しているか
- [ ] フォールバック翻訳の動作が正確にテストケースに反映されているか
- [ ] Dsn関連テストでURLエンコード/デコードのエッジケースが考慮されているか
- [ ] PseudoLocalizationTranslatorの各オプション（accents, brackets, expansion_factor, parse_html）がカバーされているか
- [ ] Catalogue操作（MergeOperation, TargetOperation）のall/new/obsoleteメッセージの集合演算が正しく記述されているか
