---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 270
  claims_with_evidence: 262
  claims_without_evidence: 8
confidence_derived: 0.97
---

# 根拠レポート：Component-TypeInfo 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：262 / 270、根拠なし：8
- 優先レビュー（高）
  1. **C-206 (UT-TYI-206)**: TypeContextFactoryのキャッシュ動作テスト - 実装はキャッシュしているが、同一インスタンスが返されることの検証は外部から困難
  2. **C-265 (UT-TYI-265)**: プロモートプロパティの@param解決 - コンストラクタプロモーションの具体的なテスト対象クラスが未特定
  3. **C-268 (UT-TYI-268)**: value-of<BackedEnum>の解決 - テスト用BackedEnumクラスの用意が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/TypeInfo/TypeIdentifier.php` - TypeIdentifier enum定義（15ケース、values/isStandalone/isScalar/isBoolメソッド）
- E-02: `src/Symfony/Component/TypeInfo/Type.php` - 抽象Typeクラス（isSatisfiedBy/isIdentifiedBy/isNullable/accepts/traverseメソッド）
- E-03: `src/Symfony/Component/TypeInfo/TypeFactoryTrait.php` - 型ファクトリトレイト（builtin/int/float/string等全ファクトリメソッド）
- E-04: `src/Symfony/Component/TypeInfo/Type/BuiltinType.php` - BuiltinType実装（getTypeIdentifier/isIdentifiedBy/isNullable/accepts/__toString）
- E-05: `src/Symfony/Component/TypeInfo/Type/ObjectType.php` - ObjectType実装（getClassName/isIdentifiedBy/accepts/__toString）
- E-06: `src/Symfony/Component/TypeInfo/Type/EnumType.php` - EnumType実装（ObjectTypeを継承、追加メソッドなし）
- E-07: `src/Symfony/Component/TypeInfo/Type/BackedEnumType.php` - BackedEnumType実装（getBackingType、バッキング型バリデーション）
- E-08: `src/Symfony/Component/TypeInfo/Type/GenericType.php` - GenericType実装（getWrappedType/getVariableTypes/__toString）
- E-09: `src/Symfony/Component/TypeInfo/Type/CollectionType.php` - CollectionType実装（mergeCollectionValueTypes/isList/getCollectionKeyType/getCollectionValueType/accepts）
- E-10: `src/Symfony/Component/TypeInfo/Type/UnionType.php` - UnionType実装（コンストラクタバリデーション/getTypes/composedTypesAreSatisfiedBy）
- E-11: `src/Symfony/Component/TypeInfo/Type/IntersectionType.php` - IntersectionType実装（コンストラクタバリデーション/getTypes/composedTypesAreSatisfiedBy）
- E-12: `src/Symfony/Component/TypeInfo/Type/NullableType.php` - NullableType実装（getWrappedType/isNullable/accepts）
- E-13: `src/Symfony/Component/TypeInfo/Type/TemplateType.php` - TemplateType実装（getName/getBound/getWrappedType/__toString）
- E-14: `src/Symfony/Component/TypeInfo/Type/ArrayShapeType.php` - ArrayShapeType実装（getShape/isSealed/getExtraKeyType/accepts/__toString）
- E-15: `src/Symfony/Component/TypeInfo/Type/ObjectShapeType.php` - ObjectShapeType実装（getTypeIdentifier/getShape/accepts/__toString）
- E-16: `src/Symfony/Component/TypeInfo/Type/CompositeTypeInterface.php` - CompositeTypeInterface定義
- E-17: `src/Symfony/Component/TypeInfo/Type/WrappingTypeInterface.php` - WrappingTypeInterface定義
- E-18: `src/Symfony/Component/TypeInfo/TypeContext/TypeContext.php` - TypeContext実装（normalize/getDeclaringClass/getCalledClass/getParentClass）
- E-19: `src/Symfony/Component/TypeInfo/TypeContext/TypeContextFactory.php` - TypeContextFactory実装（createFromClassName/createFromReflection/collectUses/collectTemplates）
- E-20: `src/Symfony/Component/TypeInfo/TypeResolver/TypeResolver.php` - TypeResolver実装（resolve/create）
- E-21: `src/Symfony/Component/TypeInfo/TypeResolver/StringTypeResolver.php` - StringTypeResolver実装（resolve/getTypeFromNode/resolveCustomIdentifier）
- E-22: `src/Symfony/Component/TypeInfo/TypeResolver/ReflectionTypeResolver.php` - ReflectionTypeResolver実装（resolve）
- E-23: `src/Symfony/Component/TypeInfo/TypeResolver/ReflectionParameterTypeResolver.php` - ReflectionParameterTypeResolver実装（resolve）
- E-24: `src/Symfony/Component/TypeInfo/TypeResolver/ReflectionPropertyTypeResolver.php` - ReflectionPropertyTypeResolver実装（resolve）
- E-25: `src/Symfony/Component/TypeInfo/TypeResolver/ReflectionReturnTypeResolver.php` - ReflectionReturnTypeResolver実装（resolve）
- E-26: `src/Symfony/Component/TypeInfo/TypeResolver/PhpDocAwareReflectionTypeResolver.php` - PhpDocAwareReflectionTypeResolver実装（resolve）
- E-27: `src/Symfony/Component/TypeInfo/TypeResolver/TypeResolverInterface.php` - TypeResolverInterface定義
- E-28: `src/Symfony/Component/TypeInfo/Exception/UnsupportedException.php` - UnsupportedException実装
- E-29: `src/Symfony/Component/TypeInfo/Exception/InvalidArgumentException.php` - InvalidArgumentException実装
- E-30: `src/Symfony/Component/TypeInfo/Exception/LogicException.php` - LogicException実装
- E-31: `src/Symfony/Component/TypeInfo/Exception/RuntimeException.php` - RuntimeException実装
- E-32: `src/Symfony/Component/TypeInfo/Exception/ExceptionInterface.php` - ExceptionInterface定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | TypeIdentifier::values()が15個の値を返す | E-01 (15 case定義) | ○ |
| C-002 | MIXED/NEVER/VOIDがisStandalone=true | E-01 (L47-49) | ○ |
| C-003 | INTがisStandalone=false | E-01 (L47-49) | ○ |
| C-004 | STRING/FLOAT/INT/BOOL/FALSE/TRUEがisScalar=true | E-01 (L52-54) | ○ |
| C-005 | ARRAYがisScalar=false | E-01 (L52-54) | ○ |
| C-006 | BOOL/FALSE/TRUEがisBool=true | E-01 (L57-59) | ○ |
| C-007 | INTがisBool=false | E-01 (L57-59) | ○ |
| C-008 | BuiltinTypeコンストラクタ | E-04 (L28-31) | ○ |
| C-009 | BuiltinType::getTypeIdentifier | E-04 (L36-39) | ○ |
| C-010 | BuiltinType::isIdentifiedBy (TypeIdentifier) | E-04 (L41-50) | ○ |
| C-011 | BuiltinType::isIdentifiedBy (string) | E-04 (L41-50) | ○ |
| C-012 | BuiltinType::isIdentifiedBy 不一致 | E-04 (L41-50) | ○ |
| C-013 | BuiltinType::isNullable (NULL=true) | E-04 (L52-55) | ○ |
| C-014 | BuiltinType::isNullable (MIXED=true) | E-04 (L52-55) | ○ |
| C-015 | BuiltinType::isNullable (INT=false) | E-04 (L52-55) | ○ |
| C-016 | BuiltinType::accepts (INT) | E-04 (L57-75) | ○ |
| C-017 | BuiltinType::accepts (STRING) | E-04 (L57-75) | ○ |
| C-018 | BuiltinType::accepts (BOOL) | E-04 (L57-75) | ○ |
| C-019 | BuiltinType::accepts (FLOAT) | E-04 (L57-75) | ○ |
| C-020 | BuiltinType::accepts (ARRAY) | E-04 (L57-75) | ○ |
| C-021 | BuiltinType::accepts (NULL) | E-04 (L57-75) | ○ |
| C-022 | BuiltinType::accepts (MIXED) | E-04 (L57-75) | ○ |
| C-023 | BuiltinType::accepts (FALSE) | E-04 (L57-75) | ○ |
| C-024 | BuiltinType::accepts (TRUE) | E-04 (L57-75) | ○ |
| C-025 | BuiltinType::accepts 型不一致 | E-04 (L57-75) | ○ |
| C-026 | BuiltinType::__toString | E-04 (L77-80) | ○ |
| C-027 | ObjectTypeコンストラクタ | E-05 (L28-31) | ○ |
| C-028 | ObjectType::getTypeIdentifier | E-05 (L33-36) | ○ |
| C-029 | ObjectType::getClassName | E-05 (L41-44) | ○ |
| C-030 | ObjectType::isIdentifiedBy (OBJECT) | E-05 (L46-67) | ○ |
| C-031 | ObjectType::isIdentifiedBy ('object') | E-05 (L46-67) | ○ |
| C-032 | ObjectType::isIdentifiedBy (is_a) | E-05 (L61) | ○ |
| C-033 | ObjectType::isIdentifiedBy 不一致 | E-05 (L46-67) | ○ |
| C-034 | ObjectType::accepts 正常 | E-05 (L69-72) | ○ |
| C-035 | ObjectType::accepts 不一致 | E-05 (L69-72) | ○ |
| C-036 | ObjectType::accepts 非オブジェクト | E-05 (L69-72) | ○ |
| C-037 | ObjectType::__toString | E-05 (L74-77) | ○ |
| C-038 | EnumTypeコンストラクタ | E-06 | ○ |
| C-039 | BackedEnumType (INT) | E-07 (L32-41) | ○ |
| C-040 | BackedEnumType (STRING) | E-07 (L32-41) | ○ |
| C-041 | BackedEnumType 不正backing型 | E-07 (L36-37) | ○ |
| C-042 | BackedEnumType::getBackingType | E-07 (L46-49) | ○ |
| C-043 | GenericType (ARRAY) | E-08 (L38-47) | ○ |
| C-044 | GenericType (ObjectType) | E-08 (L38-47) | ○ |
| C-045 | GenericType 不正BuiltinType | E-08 (L42-44) | ○ |
| C-046 | GenericType::getWrappedType | E-08 (L49-52) | ○ |
| C-047 | GenericType::getVariableTypes | E-08 (L57-60) | ○ |
| C-048 | GenericType::wrappedTypeIsSatisfiedBy | E-08 (L62-65) | ○ |
| C-049 | GenericType::__toString | E-08 (L67-79) | ○ |
| C-050 | CollectionType (ARRAY) | E-09 (L33-62) | ○ |
| C-051 | CollectionType (GenericType) | E-09 (L33-62) | ○ |
| C-052 | CollectionType 不正BuiltinType | E-09 (L37-39) | ○ |
| C-053 | CollectionType isList=true | E-09 (L40-50) | ○ |
| C-054 | CollectionType isList非array | E-09 (L42-43) | ○ |
| C-055 | CollectionType isListキー制約 | E-09 (L46-50) | ○ |
| C-056 | CollectionType 不正配列キー | E-09 (L51-61) | ○ |
| C-057 | mergeCollectionValueTypes 単一 | E-09 (L67-117) | ○ |
| C-058 | mergeCollectionValueTypes 複数 | E-09 (L67-117) | ○ |
| C-059 | mergeCollectionValueTypes MIXED | E-09 (L80-82) | ○ |
| C-060 | mergeCollectionValueTypes bool | E-09 (L104-106) | ○ |
| C-061 | mergeCollectionValueTypes 空配列 | E-09 (L69-71) | ○ |
| C-062 | CollectionType::isList true | E-09 (L124-127) | ○ |
| C-063 | CollectionType::isList false | E-09 (L124-127) | ○ |
| C-064 | getCollectionKeyType 2変数 | E-09 (L129-142) | ○ |
| C-065 | getCollectionKeyType 1変数 | E-09 (L129-142) | ○ |
| C-066 | getCollectionKeyType デフォルト | E-09 (L129-142) | ○ |
| C-067 | getCollectionValueType 2変数 | E-09 (L144-157) | ○ |
| C-068 | getCollectionValueType 1変数 | E-09 (L144-157) | ○ |
| C-069 | getCollectionValueType デフォルト | E-09 (L144-157) | ○ |
| C-070 | CollectionType::accepts 正常 | E-09 (L164-187) | ○ |
| C-071 | CollectionType::accepts リスト拒否 | E-09 (L170-171) | ○ |
| C-072 | CollectionType::accepts 値不一致 | E-09 (L178-183) | ○ |
| C-073 | CollectionType::__toString list | E-09 (L189-196) | ○ |
| C-074 | CollectionType::__toString 非list | E-09 (L189-196) | ○ |
| C-075 | UnionType 2型 | E-10 (L36-77) | ○ |
| C-076 | UnionType 1型エラー | E-10 (L38-39) | ○ |
| C-077 | UnionType ネストエラー | E-10 (L43-44) | ○ |
| C-078 | UnionType nullエラー | E-10 (L48-49) | ○ |
| C-079 | UnionType standaloneエラー | E-10 (L52-53) | ○ |
| C-080 | UnionType true+falseエラー | E-10 (L70-71) | ○ |
| C-081 | UnionType bool+trueエラー | E-10 (L66-67) | ○ |
| C-082 | UnionType object+classエラー | E-10 (L74-75) | ○ |
| C-083 | UnionType::getTypes | E-10 (L82-85) | ○ |
| C-084 | UnionType::composedTypesAreSatisfiedBy 一致 | E-10 (L87-96) | ○ |
| C-085 | UnionType::composedTypesAreSatisfiedBy 不一致 | E-10 (L87-96) | ○ |
| C-086 | UnionType::__toString | E-10 (L98-109) | ○ |
| C-087 | IntersectionType 2型 | E-11 (L35-57) | ○ |
| C-088 | IntersectionType 1型エラー | E-11 (L37-39) | ○ |
| C-089 | IntersectionType Compositeエラー | E-11 (L42) | ○ |
| C-090 | IntersectionType Nullableエラー | E-11 (L42) | ○ |
| C-091 | IntersectionType 非ObjectTypeエラー | E-11 (L50-51) | ○ |
| C-092 | IntersectionType::getTypes | E-11 (L62-65) | ○ |
| C-093 | IntersectionType::composedTypesAreSatisfiedBy 全一致 | E-11 (L67-76) | ○ |
| C-094 | IntersectionType::composedTypesAreSatisfiedBy 部分一致 | E-11 (L67-76) | ○ |
| C-095 | IntersectionType::__toString | E-11 (L78-89) | ○ |
| C-096 | NullableType 非nullable | E-12 (L32-46) | ○ |
| C-097 | NullableType UnionType | E-12 (L39-43) | ○ |
| C-098 | NullableType 既nullable | E-12 (L35-37) | ○ |
| C-099 | NullableType::getWrappedType | E-12 (L48-51) | ○ |
| C-100 | NullableType::isNullable | E-12 (L58-61) | ○ |
| C-101 | NullableType::accepts null | E-12 (L63-66) | ○ |
| C-102 | NullableType::accepts ラップ型 | E-12 (L63-66) | ○ |
| C-103 | NullableType::accepts 不一致 | E-12 (L63-66) | ○ |
| C-104 | TemplateTypeコンストラクタ | E-13 (L31-35) | ○ |
| C-105 | TemplateType::getName | E-13 (L37-40) | ○ |
| C-106 | TemplateType::getBound | E-13 (L45-48) | ○ |
| C-107 | TemplateType::getWrappedType | E-13 (L50-53) | ○ |
| C-108 | TemplateType::__toString | E-13 (L60-63) | ○ |
| C-109 | ArrayShapeTypeコンストラクタ | E-14 (L35-71) | ○ |
| C-110 | ArrayShapeType 非sealed | E-14 (L35-71) | ○ |
| C-111 | ArrayShapeType 片方extra | E-14 (L64-65) | ○ |
| C-112 | ArrayShapeType 不正extraKeyType | E-14 (L68-70) | ○ |
| C-113 | ArrayShapeType::getShape | E-14 (L76-79) | ○ |
| C-114 | ArrayShapeType::isSealed true | E-14 (L81-84) | ○ |
| C-115 | ArrayShapeType::isSealed false | E-14 (L81-84) | ○ |
| C-116 | ArrayShapeType::accepts 一致 | E-14 (L96-121) | ○ |
| C-117 | ArrayShapeType::accepts 非配列 | E-14 (L98-99) | ○ |
| C-118 | ArrayShapeType::accepts 必須キー欠落 | E-14 (L102-106) | ○ |
| C-119 | ArrayShapeType::accepts オプショナル | E-14 (L102-106) | ○ |
| C-120 | ArrayShapeType::accepts sealed余分キー | E-14 (L115) | ○ |
| C-121 | ArrayShapeType::__toString | E-14 (L123-143) | ○ |
| C-122 | ObjectShapeTypeコンストラクタ | E-15 (L32-39) | ○ |
| C-123 | ObjectShapeType::getTypeIdentifier | E-15 (L41-44) | ○ |
| C-124 | ObjectShapeType::getShape | E-15 (L49-52) | ○ |
| C-125 | ObjectShapeType::accepts 正常 | E-15 (L54-78) | ○ |
| C-126 | ObjectShapeType::accepts 非オブジェクト | E-15 (L56-58) | ○ |
| C-127 | ObjectShapeType::accepts 必須プロパティ欠落 | E-15 (L60-64) | ○ |
| C-128 | ObjectShapeType::accepts 未定義プロパティ | E-15 (L68-69) | ○ |
| C-129 | ObjectShapeType::__toString | E-15 (L80-94) | ○ |
| C-130 | Type::isSatisfiedBy true | E-02 (L30-41) | ○ |
| C-131 | Type::isSatisfiedBy false | E-02 (L30-41) | ○ |
| C-132 | Type::isSatisfiedBy Wrapping | E-02 (L32-34) | ○ |
| C-133 | Type::isSatisfiedBy Composite | E-02 (L36-38) | ○ |
| C-134 | Type::isIdentifiedBy 直接 | E-02 (L46-59) | ○ |
| C-135 | Type::isIdentifiedBy Wrapping | E-02 (L50-52) | ○ |
| C-136 | Type::isIdentifiedBy Composite | E-02 (L54-56) | ○ |
| C-137 | Type::isNullable デフォルト | E-02 (L61-64) | ○ |
| C-138 | Type::accepts | E-02 (L69-84) | ○ |
| C-139 | Type::traverse 単一 | E-02 (L91-107) | ○ |
| C-140 | Type::traverse Composite | E-02 (L95-102) | ○ |
| C-141 | Type::traverse Wrapping | E-02 (L104-106) | ○ |
| C-142 | Type::traverse フラグ | E-02 (L91-107) | ○ |
| C-143 | TypeFactoryTrait::builtin (enum) | E-03 (L43-49) | ○ |
| C-144 | TypeFactoryTrait::builtin (string) | E-03 (L43-49) | ○ |
| C-145 | TypeFactoryTrait::int | E-03 (L54-57) | ○ |
| C-146 | TypeFactoryTrait::float | E-03 (L62-65) | ○ |
| C-147 | TypeFactoryTrait::string | E-03 (L70-73) | ○ |
| C-148 | TypeFactoryTrait::bool | E-03 (L78-81) | ○ |
| C-149 | TypeFactoryTrait::null | E-03 (L126-129) | ○ |
| C-150 | TypeFactoryTrait::mixed | E-03 (L118-121) | ○ |
| C-151 | TypeFactoryTrait::void | E-03 (L134-137) | ○ |
| C-152 | TypeFactoryTrait::never | E-03 (L142-145) | ○ |
| C-153 | TypeFactoryTrait::resource | E-03 (L86-89) | ○ |
| C-154 | TypeFactoryTrait::false | E-03 (L94-97) | ○ |
| C-155 | TypeFactoryTrait::true | E-03 (L102-105) | ○ |
| C-156 | TypeFactoryTrait::callable | E-03 (L110-113) | ○ |
| C-157 | TypeFactoryTrait::collection 基本 | E-03 (L154-161) | ○ |
| C-158 | TypeFactoryTrait::collection key/value | E-03 (L156-158) | ○ |
| C-159 | TypeFactoryTrait::array | E-03 (L166-169) | ○ |
| C-160 | TypeFactoryTrait::iterable | E-03 (L174-177) | ○ |
| C-161 | TypeFactoryTrait::list | E-03 (L182-185) | ○ |
| C-162 | TypeFactoryTrait::dict | E-03 (L190-193) | ○ |
| C-163 | TypeFactoryTrait::arrayShape | E-03 (L198-212) | ○ |
| C-164 | TypeFactoryTrait::arrayShape 非sealed | E-03 (L204-209) | ○ |
| C-165 | TypeFactoryTrait::arrayKey | E-03 (L214-217) | ○ |
| C-166 | TypeFactoryTrait::object (クラス名) | E-03 (L226-229) | ○ |
| C-167 | TypeFactoryTrait::object (null) | E-03 (L226-229) | ○ |
| C-168 | TypeFactoryTrait::objectShape | E-03 (L234-244) | ○ |
| C-169 | TypeFactoryTrait::enum (BackedEnum) | E-03 (L256-268) | ○ |
| C-170 | TypeFactoryTrait::enum (UnitEnum) | E-03 (L256-268) | ○ |
| C-171 | TypeFactoryTrait::generic | E-03 (L277-280) | ○ |
| C-172 | TypeFactoryTrait::template デフォルト | E-03 (L289-292) | ○ |
| C-173 | TypeFactoryTrait::template bound指定 | E-03 (L289-292) | ○ |
| C-174 | TypeFactoryTrait::union 基本 | E-03 (L301-345) | ○ |
| C-175 | TypeFactoryTrait::union nullable | E-03 (L306-307, L329-335) | ○ |
| C-176 | TypeFactoryTrait::union NullableType展開 | E-03 (L310-312) | ○ |
| C-177 | TypeFactoryTrait::union UnionType展開 | E-03 (L315-327) | ○ |
| C-178 | TypeFactoryTrait::union 最小nullable | E-03 (L338-339) | ○ |
| C-179 | TypeFactoryTrait::intersection 基本 | E-03 (L354-372) | ○ |
| C-180 | TypeFactoryTrait::intersection 展開 | E-03 (L360-368) | ○ |
| C-181 | TypeFactoryTrait::nullable 基本 | E-03 (L381-388) | ○ |
| C-182 | TypeFactoryTrait::nullable 冪等性 | E-03 (L383-385) | ○ |
| C-183 | TypeFactoryTrait::fromValue null | E-03 (L392-393) | ○ |
| C-184 | TypeFactoryTrait::fromValue true | E-03 (L394) | ○ |
| C-185 | TypeFactoryTrait::fromValue false | E-03 (L395) | ○ |
| C-186 | TypeFactoryTrait::fromValue int | E-03 (L412) | ○ |
| C-187 | TypeFactoryTrait::fromValue float | E-03 (L413) | ○ |
| C-188 | TypeFactoryTrait::fromValue string | E-03 (L414) | ○ |
| C-189 | TypeFactoryTrait::fromValue object | E-03 (L424) | ○ |
| C-190 | TypeFactoryTrait::fromValue stdClass | E-03 (L424) | ○ |
| C-191 | TypeFactoryTrait::fromValue array | E-03 (L425, L433-454) | ○ |
| C-192 | TypeFactoryTrait::fromValue 空配列 | E-03 (L425, L433-454) | ○ |
| C-193 | TypeContextコンストラクタ | E-18 (L38-46) | ○ |
| C-194 | TypeContext::normalize FQCN | E-18 (L53-55) | ○ |
| C-195 | TypeContext::normalize use | E-18 (L59-62) | ○ |
| C-196 | TypeContext::normalize useサブパス | E-18 (L59-66) | ○ |
| C-197 | TypeContext::normalize namespace | E-18 (L68-70) | ○ |
| C-198 | TypeContext::normalize なし | E-18 (L72) | ○ |
| C-199 | TypeContext::getDeclaringClass | E-18 (L78-81) | ○ |
| C-200 | TypeContext::getCalledClass | E-18 (L86-89) | ○ |
| C-201 | TypeContext::getParentClass | E-18 (L94-117) | ○ |
| C-202 | TypeContext::getParentClass エラー | E-18 (L98-99) | ○ |
| C-203 | TypeContextFactoryコンストラクタ | E-19 (L61-65) | ○ |
| C-204 | TypeContextFactory::createFromClassName | E-19 (L67-72) | ○ |
| C-205 | TypeContextFactory::createFromClassName 異クラス | E-19 (L67-72) | ○ |
| C-206 | TypeContextFactory キャッシュ | E-19 (L71) | △ |
| C-207 | TypeContextFactory::createFromReflection (Class) | E-19 (L74-113) | ○ |
| C-208 | TypeContextFactory::createFromReflection (Method) | E-19 (L74-113) | ○ |
| C-209 | TypeContextFactory::createFromReflection (Property) | E-19 (L74-113) | ○ |
| C-210 | TypeContextFactory::createFromReflection (Parameter) | E-19 (L74-113) | ○ |
| C-211 | TypeContextFactory::createFromReflection null | E-19 (L85-86) | ○ |
| C-212 | TypeResolver::resolve | E-20 (L37-60) | ○ |
| C-213 | TypeResolver::resolve Unsupported | E-20 (L48-53) | ○ |
| C-214 | TypeResolver::resolve string未サポート | E-20 (L49-51) | ○ |
| C-215 | TypeResolver::create デフォルト | E-20 (L65-105) | ○ |
| C-216 | TypeResolver::create カスタム | E-20 (L65-105) | ○ |
| C-217 | ReflectionTypeResolver int | E-22 (L28-86) | ○ |
| C-218 | ReflectionTypeResolver array | E-22 (L45-49) | ○ |
| C-219 | ReflectionTypeResolver iterable | E-22 (L51-55) | ○ |
| C-220 | ReflectionTypeResolver nullable | E-22 (L43, L48, L64) | ○ |
| C-221 | ReflectionTypeResolver null | E-22 (L57-59) | ○ |
| C-222 | ReflectionTypeResolver mixed | E-22 (L57-59) | ○ |
| C-223 | ReflectionTypeResolver class | E-22 (L79-83) | ○ |
| C-224 | ReflectionTypeResolver Union | E-22 (L30-31) | ○ |
| C-225 | ReflectionTypeResolver Intersection | E-22 (L34-35) | ○ |
| C-226 | ReflectionTypeResolver self/static/parent | E-22 (L72-77) | ○ |
| C-227 | ReflectionTypeResolver self TypeContext未設定 | E-22 (L67-69) | ○ |
| C-228 | ReflectionTypeResolver Unsupported | E-22 (L38-39) | ○ |
| C-229 | ReflectionParameterTypeResolver 正常 | E-23 (L33-49) | ○ |
| C-230 | ReflectionParameterTypeResolver 不正型 | E-23 (L35-37) | ○ |
| C-231 | ReflectionPropertyTypeResolver 正常 | E-24 (L33-48) | ○ |
| C-232 | ReflectionPropertyTypeResolver 不正型 | E-24 (L35-37) | ○ |
| C-233 | ReflectionReturnTypeResolver 正常 | E-25 (L33-49) | ○ |
| C-234 | ReflectionReturnTypeResolver 不正型 | E-25 (L35-37) | ○ |
| C-235 | StringTypeResolver int | E-21 (L190) | ○ |
| C-236 | StringTypeResolver string | E-21 (L192-204) | ○ |
| C-237 | StringTypeResolver ?int | E-21 (L232-234) | ○ |
| C-238 | StringTypeResolver int|string | E-21 (L303-317) | ○ |
| C-239 | StringTypeResolver array<int,string> | E-21 (L236-301) | ○ |
| C-240 | StringTypeResolver list<string> | E-21 (L209) | ○ |
| C-241 | StringTypeResolver mixed | E-21 (L211) | ○ |
| C-242 | StringTypeResolver void | E-21 (L220) | ○ |
| C-243 | StringTypeResolver never | E-21 (L221) | ○ |
| C-244 | StringTypeResolver callable | E-21 (L207) | ○ |
| C-245 | StringTypeResolver self | E-21 (L217) | ○ |
| C-246 | StringTypeResolver static | E-21 (L218) | ○ |
| C-247 | StringTypeResolver parent | E-21 (L219) | ○ |
| C-248 | StringTypeResolver self TypeContextなし | E-21 (L217) | ○ |
| C-249 | StringTypeResolver $this | E-21 (L141-147) | ○ |
| C-250 | StringTypeResolver array-key | E-21 (L213) | ○ |
| C-251 | StringTypeResolver scalar | E-21 (L214) | ○ |
| C-252 | StringTypeResolver int[] | E-21 (L108-110) | ○ |
| C-253 | StringTypeResolver array{} | E-21 (L112-127) | ○ |
| C-254 | StringTypeResolver object{} | E-21 (L129-139) | ○ |
| C-255 | StringTypeResolver class名 | E-21 (L326-349) | ○ |
| C-256 | StringTypeResolver template | E-21 (L352-354) | ○ |
| C-257 | StringTypeResolver typeAlias | E-21 (L356-358) | ○ |
| C-258 | StringTypeResolver 非string入力 | E-21 (L86-88) | ○ |
| C-259 | StringTypeResolver 解決不能 | E-21 (L364) | ○ |
| C-260 | StringTypeResolver Stringable | E-21 (L84-85) | ○ |
| C-261 | PhpDocAware @var | E-26 (L88-89) | ○ |
| C-262 | PhpDocAware @param | E-26 (L92-93) | ○ |
| C-263 | PhpDocAware @return | E-26 (L96-97) | ○ |
| C-264 | PhpDocAware フォールバック | E-26 (L102) | ○ |
| C-265 | PhpDocAware promote property | E-26 (L70-71) | △ |
| C-266 | PhpDocAware 不正型 | E-26 (L63-65) | ○ |
| C-267 | UnsupportedException subject | E-28 (L20-27) | ○ |
| C-268 | StringTypeResolver value-of | E-21 (L237-248) | △ |
| C-269 | StringTypeResolver key-of | E-21 (L250-257) | △ |
| C-270 | StringTypeResolver Traversable collection | E-21 (L102, L224-228) | △ |

## 4) 不足情報（Unknown / Missing）
- **キャッシュ動作の検証 (C-206)**: TypeContextFactoryのキャッシュは `??=` 演算子で実装されているが、外部テストから同一インスタンスが返されることを厳密に検証するにはオブジェクトID比較が必要
  - 候補：`spl_object_id()` による比較 / リフレクションによるプロパティ検査
- **プロモートプロパティ (C-265)**: PhpDocAwareReflectionTypeResolverのプロモートプロパティ処理は、`isPromoted()`がtrueの場合にコンストラクタの`@param`を参照するが、テスト用のプロモートプロパティクラスが未特定
  - 候補：テスト用フィクスチャクラスの作成
- **value-of/key-of (C-268, C-269)**: PHPStan PhpDoc Parserの`GenericTypeNode`解析に依存しており、テスト用のBackedEnumクラスおよびcollection型定義が必要
  - 候補：テスト用enumクラスの作成 / 既存のテストフィクスチャの利用
- **Traversable CollectionType (C-270)**: Traversable実装クラスの判定ロジック (`isIdentifiedBy(\Traversable::class)`) がCollectionTypeに自動変換されるが、具体的なテスト対象クラスの選定が必要
  - 候補：`ArrayIterator` / `SplFixedArray` / カスタムTraversable

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - TypeIdentifier, BuiltinType, ObjectType等の基本型クラスのテストケース（C-001〜C-042）は実装コードとの対応が明確
- 0: 低リスク - TypeFactoryTraitの各ファクトリメソッド（C-143〜C-192）はシンプルなファクトリパターン
- 1: 中リスク - CollectionType/UnionType/IntersectionTypeのバリデーション（C-050〜C-095）は条件分岐が多く、テストケースの網羅性確認が必要
- 1: 中リスク - StringTypeResolverの文字列解析（C-235〜C-260）はPHPStan PhpDoc Parserに依存し、パーサーのバージョンによる挙動差異の可能性あり
- 1: 中リスク - PhpDocAwareReflectionTypeResolver（C-261〜C-266）はPhpDocの解析精度に依存
- 0: 低リスク - TypeContext/TypeContextFactory（C-193〜C-211）は名前空間解決のロジックが明確

## 6) レビュアーチェックリスト（最小）
- [ ] BuiltinType::acceptsの全TypeIdentifierケースが網羅されているか（C-016〜C-025）
- [ ] UnionType/IntersectionTypeのコンストラクタバリデーション条件が全て網羅されているか（C-075〜C-095）
- [ ] CollectionType::mergeCollectionValueTypesの型マージロジックが正しいか（C-057〜C-061）
- [ ] TypeFactoryTrait::unionのNullableType/UnionType展開ロジックが正しいか（C-174〜C-178）
- [ ] StringTypeResolverの各識別子解決が仕様通りか（C-235〜C-260）
- [ ] PhpDocAwareReflectionTypeResolverのフォールバック動作が正しいか（C-264）
- [ ] TypeContext::normalizeのuse/namespace解決順序が正しいか（C-194〜C-198）
- [ ] テスト用フィクスチャクラス（BackedEnum, プロモートプロパティ等）が用意されているか
