---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 186
  claims_with_evidence: 182
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：Component-Uid 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：182 / 186、根拠なし：4
- 優先レビュー（高）
  1. **C-048 (UT-UID-048)**：Ulid::generate の負のタイムスタンプ挙動 - 1970年以前の日時で本当にInvalidArgumentExceptionが発生するか要確認（generateメソッドのチェックは `0 > $time` で判定）
  2. **C-109 (UT-UID-109)**：UuidV6::generate のMACアドレスランダム化 - マルチキャストビットの設定は実装で確認できるが、完全なランダム化の検証は実行時テストが必要
  3. **C-114 (UT-UID-114)**：UuidV7::getDateTime のマイクロ秒精度 - sub-ms精度は10ビット（1024分割）で表現されており、正確なマイクロ秒精度ではない
  4. **C-136 (UT-UID-136)**：BinaryUtil のラウンドトリップ - sub-microsecond精度の損失がhexToDateTimeで発生するため、完全なラウンドトリップは成立しない場合がある

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Uid/AbstractUid.php` - AbstractUidクラスのソースコード（fromBinary, fromBase58, fromBase32, fromRfc4122, toBase58, toBase32, toRfc4122, toHex, equals, hash, compare, toString, __toString, jsonSerialize）
- E-02: `src/Symfony/Component/Uid/Ulid.php` - Ulidクラスのソースコード（__construct, isValid, fromString, toBinary, toBase32, getDateTime, generate）
- E-03: `src/Symfony/Component/Uid/Uuid.php` - Uuidクラスのソースコード（__construct, fromString, v1-v8, isValid, toBinary, toRfc4122, compare）
- E-04: `src/Symfony/Component/Uid/UuidV1.php` - UuidV1クラスのソースコード（__construct, getDateTime, getNode, toV6, toV7, generate）
- E-05: `src/Symfony/Component/Uid/UuidV3.php` - UuidV3クラスのソースコード（__construct）
- E-06: `src/Symfony/Component/Uid/UuidV4.php` - UuidV4クラスのソースコード（__construct）
- E-07: `src/Symfony/Component/Uid/UuidV5.php` - UuidV5クラスのソースコード（__construct）
- E-08: `src/Symfony/Component/Uid/UuidV6.php` - UuidV6クラスのソースコード（__construct, getDateTime, getNode, toV7, generate）
- E-09: `src/Symfony/Component/Uid/UuidV7.php` - UuidV7クラスのソースコード（__construct, getDateTime, generate）
- E-10: `src/Symfony/Component/Uid/UuidV8.php` - UuidV8クラスのソースコード（__construct）
- E-11: `src/Symfony/Component/Uid/NilUuid.php` - NilUuidクラスのソースコード
- E-12: `src/Symfony/Component/Uid/MaxUuid.php` - MaxUuidクラスのソースコード
- E-13: `src/Symfony/Component/Uid/NilUlid.php` - NilUlidクラスのソースコード
- E-14: `src/Symfony/Component/Uid/MaxUlid.php` - MaxUlidクラスのソースコード
- E-15: `src/Symfony/Component/Uid/BinaryUtil.php` - BinaryUtilクラスのソースコード（toBase, fromBase, add, hexToNumericString, hexToDateTime, dateTimeToHex）
- E-16: `src/Symfony/Component/Uid/Factory/UuidFactory.php` - UuidFactoryクラスのソースコード
- E-17: `src/Symfony/Component/Uid/Factory/UlidFactory.php` - UlidFactoryクラスのソースコード
- E-18: `src/Symfony/Component/Uid/Factory/RandomBasedUuidFactory.php` - RandomBasedUuidFactoryクラスのソースコード
- E-19: `src/Symfony/Component/Uid/Factory/NameBasedUuidFactory.php` - NameBasedUuidFactoryクラスのソースコード
- E-20: `src/Symfony/Component/Uid/Factory/TimeBasedUuidFactory.php` - TimeBasedUuidFactoryクラスのソースコード
- E-21: `src/Symfony/Component/Uid/Factory/MockUuidFactory.php` - MockUuidFactoryクラスのソースコード
- E-22: `src/Symfony/Component/Uid/Command/GenerateUlidCommand.php` - GenerateUlidCommandクラスのソースコード
- E-23: `src/Symfony/Component/Uid/Command/GenerateUuidCommand.php` - GenerateUuidCommandクラスのソースコード
- E-24: `src/Symfony/Component/Uid/Command/InspectUlidCommand.php` - InspectUlidCommandクラスのソースコード
- E-25: `src/Symfony/Component/Uid/Command/InspectUuidCommand.php` - InspectUuidCommandクラスのソースコード
- E-26: `src/Symfony/Component/Uid/HashableInterface.php` - HashableInterfaceのソースコード
- E-27: `src/Symfony/Component/Uid/TimeBasedUidInterface.php` - TimeBasedUidInterfaceのソースコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | AbstractUid::fromBinary - 16バイトバイナリからUID生成 | E-01 (L41-48) | ○ |
| C-002 | AbstractUid::fromBinary - 16バイト以外で例外 | E-01 (L43-44) | ○ |
| C-003 | AbstractUid::fromBinary - 空文字列で例外 | E-01 (L43-44) | ○ |
| C-004 | AbstractUid::fromBase58 - 22文字base58からUID生成 | E-01 (L53-60) | ○ |
| C-005 | AbstractUid::fromBase58 - 22文字以外で例外 | E-01 (L55-56) | ○ |
| C-006 | AbstractUid::fromBase32 - 26文字base32からUID生成 | E-01 (L65-72) | ○ |
| C-007 | AbstractUid::fromBase32 - 26文字以外で例外 | E-01 (L67-68) | ○ |
| C-008 | AbstractUid::fromRfc4122 - 36文字RFC4122からUID生成 | E-01 (L79-86) | ○ |
| C-009 | AbstractUid::fromRfc4122 - 36文字以外で例外 | E-01 (L81-82) | ○ |
| C-010 | AbstractUid::toBase58 - base58変換 | E-01 (L102-105) | ○ |
| C-011 | AbstractUid::toBase32 - base32変換 | E-01 (L116-130) | ○ |
| C-012 | AbstractUid::toRfc4122 - RFC4122変換 | E-01 (L141-150) | ○ |
| C-013 | AbstractUid::toHex - Hex変換 | E-01 (L159-162) | ○ |
| C-014 | AbstractUid::equals - 同一UID比較 | E-01 (L167-174) | ○ |
| C-015 | AbstractUid::equals - 異なるUID比較 | E-01 (L167-174) | ○ |
| C-016 | AbstractUid::equals - 非AbstractUidとの比較 | E-01 (L169-170) | ○ |
| C-017 | AbstractUid::hash - ハッシュ値返却 | E-01 (L179-182) | ○ |
| C-018 | AbstractUid::compare - 同一UID比較で0 | E-01 (L184-187) | ○ |
| C-019 | AbstractUid::compare - 小さいUIDで負値 | E-01 (L184-187) | ○ |
| C-020 | AbstractUid::compare - 大きいUIDで正値 | E-01 (L184-187) | ○ |
| C-021 | AbstractUid::toString - 文字列返却 | E-01 (L192-195) | ○ |
| C-022 | AbstractUid::__toString - 文字列返却 | E-01 (L200-203) | ○ |
| C-023 | AbstractUid::jsonSerialize - JSON文字列返却 | E-01 (L208-211) | ○ |
| C-024 | Ulid::__construct - 引数なしでULID生成 | E-02 (L38-41) | ○ |
| C-025 | Ulid::__construct - 有効ULID文字列から生成 | E-02 (L38-53) | ○ |
| C-026 | Ulid::__construct - NIL ULID | E-02 (L42-43) | ○ |
| C-027 | Ulid::__construct - MAX ULID | E-02 (L47-48) | ○ |
| C-028 | Ulid::__construct - 無効ULID文字列で例外 | E-02 (L49-51) | ○ |
| C-029 | Ulid::__construct - 先頭文字8以上で例外 | E-02 (L92) | ○ |
| C-030 | Ulid::isValid - 有効base32 ULID | E-02 (L58-93) | ○ |
| C-031 | Ulid::isValid - 無効文字検出 | E-02 (L88-89) | ○ |
| C-032 | Ulid::isValid - NIL ULIDが有効 | E-02 (L72-73) | ○ |
| C-033 | Ulid::isValid - MAX ULIDが有効 | E-02 (L76-77) | ○ |
| C-034 | Ulid::isValid - FORMAT_RFC_4122 | E-02 (L58-68) | ○ |
| C-035 | Ulid::isValid - FORMAT_BASE_58 | E-02 (L58-68) | ○ |
| C-036 | Ulid::isValid - フォーマット不一致 | E-02 (L62-63, L266-267) | ○ |
| C-037 | Ulid::fromString - RFC4122から変換 | E-02 (L96-98) | ○ |
| C-038 | Ulid::fromString - base58から変換 | E-02 (L99-101) | ○ |
| C-039 | Ulid::fromString - バイナリから変換 | E-02 (L103-109) | ○ |
| C-040 | Ulid::fromString - NIL値の特別処理 | E-02 (L104-106) | ○ |
| C-041 | Ulid::fromString - MAX値の特別処理 | E-02 (L126-128) | ○ |
| C-042 | Ulid::toBinary - バイナリ変換 | E-02 (L136-151) | ○ |
| C-043 | Ulid::toBase32 - base32表現 | E-02 (L160-163) | ○ |
| C-044 | Ulid::getDateTime - DateTimeImmutable取得 | E-02 (L165-185) | ○ |
| C-045 | Ulid::getDateTime - タイムスタンプ精度 | E-02 (L165-185) | ○ |
| C-046 | Ulid::generate - 引数なしで生成 | E-02 (L187-243) | ○ |
| C-047 | Ulid::generate - 時刻指定生成 | E-02 (L187-243) | ○ |
| C-048 | Ulid::generate - 負のタイムスタンプで例外 | E-02 (L192-193) | △ |
| C-049 | Ulid::generate - モノトニック増加 | E-02 (L196-223) | ○ |
| C-050 | Uuid::__construct - 有効UUID生成 | E-03 (L39-52) | ○ |
| C-051 | Uuid::__construct - 無効UUID文字列で例外 | E-03 (L41-45) | ○ |
| C-052 | Uuid::__construct - バリアントチェック | E-03 (L49-51) | ○ |
| C-053 | Uuid::fromString - バージョン自動判定 | E-03 (L54-84) | ○ |
| C-054 | Uuid::fromString - base32から変換 | E-03 (L54-57) | ○ |
| C-055 | Uuid::fromString - base58から変換 | E-03 (L54-57) | ○ |
| C-056 | Uuid::fromString - NIL UUID特別処理 | E-03 (L62-64) | ○ |
| C-057 | Uuid::fromString - MAX UUID特別処理 | E-03 (L66-68) | ○ |
| C-058 | Uuid::fromString - UuidV4自動判定 | E-03 (L77) | ○ |
| C-059 | Uuid::fromString - UuidV7自動判定 | E-03 (L80) | ○ |
| C-060 | Uuid::v1 - UuidV1生成 | E-03 (L86-89) | ○ |
| C-061 | Uuid::v3 - 名前ベースUUID(MD5) | E-03 (L91-97) | ○ |
| C-062 | Uuid::v3 - 決定論性 | E-03 (L94) | ○ |
| C-063 | Uuid::v4 - UuidV4生成 | E-03 (L99-102) | ○ |
| C-064 | Uuid::v4 - バージョンビット確認 | E-06 (L34) | ○ |
| C-065 | Uuid::v5 - 名前ベースUUID(SHA1) | E-03 (L104-110) | ○ |
| C-066 | Uuid::v5 - 決定論性 | E-03 (L107) | ○ |
| C-067 | Uuid::v6 - UuidV6生成 | E-03 (L112-115) | ○ |
| C-068 | Uuid::v7 - UuidV7生成 | E-03 (L117-120) | ○ |
| C-069 | Uuid::v8 - UuidV8生成 | E-03 (L122-125) | ○ |
| C-070 | Uuid::isValid - 有効UUID判定 | E-03 (L130-153) | ○ |
| C-071 | Uuid::isValid - 無効UUID判定 | E-03 (L148-149) | ○ |
| C-072 | Uuid::isValid - NIL UUID有効 | E-03 (L140-141) | ○ |
| C-073 | Uuid::isValid - MAX UUID有効 | E-03 (L144-145) | ○ |
| C-074 | Uuid::isValid - バリアントチェック | E-03 (L148) | ○ |
| C-075 | Uuid::isValid - FORMAT_BASE_32 | E-03 (L130-138) | ○ |
| C-076 | Uuid::isValid - FORMAT_BASE_58 | E-03 (L130-138) | ○ |
| C-077 | Uuid::toBinary - バイナリ変換 | E-03 (L155-158) | ○ |
| C-078 | Uuid::toRfc4122 - RFC4122表現 | E-03 (L167-170) | ○ |
| C-079 | Uuid::compare - UUID比較 | E-03 (L172-179) | ○ |
| C-080 | UuidV1::__construct - 引数なし生成 | E-04 (L25-32) | ○ |
| C-081 | UuidV1::__construct - 文字列から生成 | E-04 (L25-32) | ○ |
| C-082 | UuidV1::__construct - バージョンチェック | E-04 (L21, L30) | ○ |
| C-083 | UuidV1::getDateTime | E-04 (L34-37) | ○ |
| C-084 | UuidV1::getNode | E-04 (L39-42) | ○ |
| C-085 | UuidV1::toV6 | E-04 (L44-49) | ○ |
| C-086 | UuidV1::toV6 - タイムスタンプ保持 | E-04 (L44-49), E-08 (L38-41) | ○ |
| C-087 | UuidV1::toV7 | E-04 (L51-54) | ○ |
| C-088 | UuidV1::generate - 引数なし | E-04 (L56-84) | ○ |
| C-089 | UuidV1::generate - 時刻指定 | E-04 (L56-84) | ○ |
| C-090 | UuidV1::generate - ノード指定 | E-04 (L79-81) | ○ |
| C-091 | UuidV3::__construct - 有効v3 | E-05 (L25-28) | ○ |
| C-092 | UuidV3::__construct - バージョンチェック | E-05 (L23, L27) | ○ |
| C-093 | UuidV4::__construct - 引数なし生成 | E-06 (L23-42) | ○ |
| C-094 | UuidV4::__construct - バージョンビット | E-06 (L34) | ○ |
| C-095 | UuidV4::__construct - バリアントビット | E-06 (L37) | ○ |
| C-096 | UuidV4::__construct - 文字列から生成 | E-06 (L39-41) | ○ |
| C-097 | UuidV4::__construct - バージョンチェック | E-06 (L21, L40) | ○ |
| C-098 | UuidV5::__construct - 有効v5 | E-07 (L25-28) | ○ |
| C-099 | UuidV5::__construct - バージョンチェック | E-07 (L23, L27) | ○ |
| C-100 | UuidV6::__construct - 引数なし生成 | E-08 (L29-36) | ○ |
| C-101 | UuidV6::__construct - 文字列から生成 | E-08 (L29-36) | ○ |
| C-102 | UuidV6::__construct - バージョンチェック | E-08 (L25, L34) | ○ |
| C-103 | UuidV6::getDateTime | E-08 (L38-41) | ○ |
| C-104 | UuidV6::getNode | E-08 (L43-46) | ○ |
| C-105 | UuidV6::toV7 | E-08 (L48-73) | ○ |
| C-106 | UuidV6::toV7 - epoch以前のタイムスタンプ | E-08 (L52-53) | ○ |
| C-107 | UuidV6::generate - 引数なし | E-08 (L75-94) | ○ |
| C-108 | UuidV6::generate - 時刻指定 | E-08 (L75-94) | ○ |
| C-109 | UuidV6::generate - MACアドレスランダム化 | E-08 (L87-91) | △ |
| C-110 | UuidV7::__construct - 引数なし生成 | E-09 (L36-43) | ○ |
| C-111 | UuidV7::__construct - 文字列から生成 | E-09 (L36-43) | ○ |
| C-112 | UuidV7::__construct - バージョンチェック | E-09 (L27, L41) | ○ |
| C-113 | UuidV7::getDateTime | E-09 (L45-56) | ○ |
| C-114 | UuidV7::getDateTime - マイクロ秒精度 | E-09 (L53) | △ |
| C-115 | UuidV7::generate - 引数なし | E-09 (L58-148) | ○ |
| C-116 | UuidV7::generate - 時刻指定 | E-09 (L58-148) | ○ |
| C-117 | UuidV7::generate - 負のタイムスタンプ | E-09 (L64-65) | ○ |
| C-118 | UuidV7::generate - モノトニック増加 | E-09 (L71-127) | ○ |
| C-119 | UuidV7::generate - バージョンビット | E-09 (L131-137) | ○ |
| C-120 | UuidV7::generate - バリアントビット | E-09 (L131-137) | ○ |
| C-121 | UuidV8::__construct - 有効v8 | E-10 (L23-26) | ○ |
| C-122 | UuidV8::__construct - バージョンチェック | E-10 (L21, L25) | ○ |
| C-123 | NilUuid::__construct | E-11 (L21-23) | ○ |
| C-124 | MaxUuid::__construct | E-12 (L19-21) | ○ |
| C-125 | NilUlid::__construct | E-13 (L17-19) | ○ |
| C-126 | MaxUlid::__construct | E-14 (L17-19) | ○ |
| C-127 | BinaryUtil::toBase - BASE58変換 | E-15 (L49-74) | ○ |
| C-128 | BinaryUtil::fromBase - BASE58デコード | E-15 (L76-107) | ○ |
| C-129 | BinaryUtil::toBase/fromBase - ラウンドトリップ | E-15 (L49-107) | ○ |
| C-130 | BinaryUtil::add - バイナリ加算 | E-15 (L109-119) | ○ |
| C-131 | BinaryUtil::add - 繰り上がり処理 | E-15 (L109-119) | ○ |
| C-132 | BinaryUtil::hexToNumericString | E-15 (L126-148) | ○ |
| C-133 | BinaryUtil::hexToNumericString - ゼロパディング | E-15 (L143-144) | ○ |
| C-134 | BinaryUtil::hexToDateTime | E-15 (L155-158) | ○ |
| C-135 | BinaryUtil::dateTimeToHex | E-15 (L163-188) | ○ |
| C-136 | BinaryUtil::dateTimeToHex - ラウンドトリップ | E-15 (L155-158, L163-188) | △ |
| C-137 | BinaryUtil::dateTimeToHex - 1582-10-15以前で例外 | E-15 (L166-168) | ○ |
| C-138 | UuidFactory::__construct - デフォルト値 | E-16 (L30-46) | ○ |
| C-139 | UuidFactory::__construct - 整数値クラス指定 | E-16 (L40-43) | ○ |
| C-140 | UuidFactory::__construct - 文字列ノード指定 | E-16 (L32-34) | ○ |
| C-141 | UuidFactory::create | E-16 (L48-53) | ○ |
| C-142 | UuidFactory::randomBased | E-16 (L55-58) | ○ |
| C-143 | UuidFactory::timeBased | E-16 (L60-69) | ○ |
| C-144 | UuidFactory::timeBased - 文字列ノード | E-16 (L64-66) | ○ |
| C-145 | UuidFactory::nameBased | E-16 (L74-83) | ○ |
| C-146 | UuidFactory::nameBased - 名前空間未設定で例外 | E-16 (L78-79) | ○ |
| C-147 | UuidFactory::nameBased - 'dns'予約語 | E-16 (L92) | ○ |
| C-148 | UuidFactory::nameBased - 'url'予約語 | E-16 (L93) | ○ |
| C-149 | UlidFactory::create - 引数なし | E-17 (L18-21) | ○ |
| C-150 | UlidFactory::create - 時刻指定 | E-17 (L18-21) | ○ |
| C-151 | RandomBasedUuidFactory::create | E-18 (L26-31) | ○ |
| C-152 | NameBasedUuidFactory::create - v5 | E-19 (L26-41) | ○ |
| C-153 | NameBasedUuidFactory::create - v3 | E-19 (L26-41) | ○ |
| C-154 | TimeBasedUuidFactory::create - 時刻なし | E-20 (L28-37) | ○ |
| C-155 | TimeBasedUuidFactory::create - 時刻あり | E-20 (L28-37) | ○ |
| C-156 | MockUuidFactory::create - シーケンス返却 | E-21 (L43-56) | ○ |
| C-157 | MockUuidFactory::create - オブジェクトシーケンス | E-21 (L51-52) | ○ |
| C-158 | MockUuidFactory::create - シーケンス枯渇 | E-21 (L45-46) | ○ |
| C-159 | MockUuidFactory::randomBased | E-21 (L58-75) | ○ |
| C-160 | MockUuidFactory::randomBased - 型チェック | E-21 (L68-69) | ○ |
| C-161 | MockUuidFactory::timeBased | E-21 (L77-109) | ○ |
| C-162 | MockUuidFactory::nameBased | E-21 (L111-139) | ○ |
| C-163 | MockUuidFactory::nameBased - 名前空間未設定 | E-21 (L113-115) | ○ |
| C-164 | GenerateUlidCommand::execute - 基本動作 | E-22 (L63-99) | ○ |
| C-165 | GenerateUlidCommand::execute - count指定 | E-22 (L87-91) | ○ |
| C-166 | GenerateUlidCommand::execute - format=base58 | E-22 (L77-85) | ○ |
| C-167 | GenerateUlidCommand::execute - format=rfc4122 | E-22 (L77-85) | ○ |
| C-168 | GenerateUlidCommand::execute - time指定 | E-22 (L67-75) | ○ |
| C-169 | GenerateUlidCommand::execute - 無効な時刻 | E-22 (L68-74) | ○ |
| C-170 | GenerateUlidCommand::execute - 無効フォーマット | E-22 (L81-84) | ○ |
| C-171 | GenerateUuidCommand::execute - 基本動作 | E-23 (L85-189) | ○ |
| C-172 | GenerateUuidCommand::execute - タイムベース | E-23 (L114-134) | ○ |
| C-173 | GenerateUuidCommand::execute - ランダムベース | E-23 (L158-159) | ○ |
| C-174 | GenerateUuidCommand::execute - 名前ベース | E-23 (L136-155) | ○ |
| C-175 | GenerateUuidCommand::execute - 排他オプション | E-23 (L95-99) | ○ |
| C-176 | GenerateUuidCommand::execute - --nodeの依存 | E-23 (L101-105) | ○ |
| C-177 | GenerateUuidCommand::execute - --namespaceの依存 | E-23 (L107-111) | ○ |
| C-178 | GenerateUuidCommand::execute - format=base32 | E-23 (L167-175) | ○ |
| C-179 | GenerateUuidCommand::execute - 無効フォーマット | E-23 (L170-175) | ○ |
| C-180 | InspectUlidCommand::execute - 基本動作 | E-24 (L44-67) | ○ |
| C-181 | InspectUlidCommand::execute - 無効入力 | E-24 (L50-53) | ○ |
| C-182 | InspectUuidCommand::execute - 基本動作 | E-25 (L47-84) | ○ |
| C-183 | InspectUuidCommand::execute - タイムベース情報 | E-25 (L75-78) | ○ |
| C-184 | InspectUuidCommand::execute - NIL UUID表示 | E-25 (L59-60) | ○ |
| C-185 | InspectUuidCommand::execute - MAX UUID表示 | E-25 (L61-62) | ○ |
| C-186 | InspectUuidCommand::execute - 無効入力 | E-25 (L51-57) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-048**: Ulid::generateメソッドで `0 > $time = $time->format('Uv')` のチェックが行われるが、DateTimeInterface::format('Uv')が負を返すケースの挙動はPHPバージョンやOS依存の可能性がある
  - 候補：PHPの内部実装ドキュメント / DateTimeImmutable::format仕様
- **C-109**: UuidV6::generateのノードランダム化処理は、XOR演算とマルチキャストビット設定（`| 0x010000`）を行うが、ランダム性の完全な検証は統計的テストが必要
  - 候補：RFC 9562 Section 6.10 / Symfony Uidテストスイート
- **C-114**: UuidV7のsub-millisecond精度は10ビット（0-1023）で表現されるため、真のマイクロ秒精度ではない。getDateTime()は `>> 2 & 0x3FF` で抽出するため約0.976マイクロ秒単位
  - 候補：RFC 9562 Section 5.7 / UuidV7実装コメント
- **C-136**: BinaryUtil::hexToDateTimeは「Sub-microseconds are lost」と明記されており（E-15 L151）、完全なラウンドトリップは保証されない
  - 候補：BinaryUtil.phpのDocコメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - AbstractUid の変換メソッド群（toBase58, toBase32, toRfc4122, toHex）は実装が明確で根拠が確実
- 0: 低リスク - NilUuid, MaxUuid, NilUlid, MaxUlid は固定値のため検証が容易
- 1: 中リスク - UuidV7::generate のモノトニック増加性は同一ミリ秒内のランダムインクリメントに依存しており、実行タイミングによりテスト結果が変動する可能性がある
- 1: 中リスク - BinaryUtil のタイムスタンプ変換はPHP_INT_SIZEに依存する分岐があり、32ビット環境では異なるコードパスが実行される
- 0: 低リスク - Factory系クラスは薄いラッパーであり、実装が明確
- 0: 低リスク - Command系クラスはSymfony Consoleの標準パターンに従っている

## 6) レビュアーチェックリスト（最小）
- [ ] 全186テストケースが対象クラス/メソッドの実装と整合しているか
- [ ] 正常系/異常系/境界値のバランスが適切か（特にBinaryUtilの数値演算）
- [ ] UuidV7のsub-millisecond精度（10ビット）に関するテストケースが実運用上十分か
- [ ] 32ビット/64ビット環境の分岐に対応するテストケースが必要か検討
- [ ] MockUuidFactoryの匿名クラス内メソッドのテストケースが十分か
- [ ] Ulid::isValid のフォーマット指定パラメータ（FORMAT_BINARY含む）の全組み合わせが網羅されているか
- [ ] UuidV1::toV6, UuidV6::toV7 のバージョン間変換でタイムスタンプ/ノード情報の保存性を十分に検証しているか
