---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 160
  claims_with_evidence: 155
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：Component-VarExporter 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：155 / 160、根拠なし：5
- 優先レビュー（高）
  1. **C-013（循環参照テスト）**：循環参照の具体的な挙動はコードの複雑な相互作用に依存し、Exporter::prepare内の参照処理ロジックの解釈に基づく
  2. **C-103（readonlyプロパティのnotByRef処理）**：PHP 8.1 readonlyの具体的なハイドレーション挙動は実行時テストでの検証が必要
  3. **C-111（hookedプロパティのフラグ）**：PHP 8.4 property hooksの具体的な動作はランタイム依存
  4. **C-155（hookedプロパティのsetRawValue）**：PHP 8.4 property hooks対応のsetRawValue利用は実行環境でのテストが必要
  5. **C-158（hookedプロパティのリセッター除外）**：hookedプロパティの分岐処理の詳細な条件はコード解析に基づく推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/VarExporter/VarExporter.php` - VarExporter::export() メソッド定義（L30-114）
- E-02: `src/Symfony/Component/VarExporter/Instantiator.php` - Instantiator::instantiate() メソッド定義（L23-59）
- E-03: `src/Symfony/Component/VarExporter/Hydrator.php` - Hydrator::hydrate() メソッド定義（L21-78）
- E-04: `src/Symfony/Component/VarExporter/ProxyHelper.php` - ProxyHelper クラス定義（L22-452）
- E-05: `src/Symfony/Component/VarExporter/LazyObjectInterface.php` - LazyObjectInterface定義（L14-32）
- E-06: `src/Symfony/Component/VarExporter/Internal/Exporter.php` - Exporter::prepare(), Exporter::export() 定義（L21-434）
- E-07: `src/Symfony/Component/VarExporter/Internal/Registry.php` - Registry クラス定義（L22-142）
- E-08: `src/Symfony/Component/VarExporter/Internal/Hydrator.php` - Internal Hydrator クラス定義（L21-320）
- E-09: `src/Symfony/Component/VarExporter/Internal/LazyObjectState.php` - LazyObjectState クラス定義（L21-48）
- E-10: `src/Symfony/Component/VarExporter/Internal/LazyObjectRegistry.php` - LazyObjectRegistry クラス定義（L21-99）
- E-11: `src/Symfony/Component/VarExporter/Internal/LazyDecoratorTrait.php` - LazyDecoratorTrait 定義（L20-158）
- E-12: `src/Symfony/Component/VarExporter/Internal/Reference.php` - Reference クラス定義（L19-28）
- E-13: `src/Symfony/Component/VarExporter/Internal/Values.php` - Values クラス定義（L19-25）
- E-14: `src/Symfony/Component/VarExporter/Internal/NamedClosure.php` - NamedClosure クラス定義（L19-26）
- E-15: `src/Symfony/Component/VarExporter/Exception/ClassNotFoundException.php` - ClassNotFoundException 定義（L14-20）
- E-16: `src/Symfony/Component/VarExporter/Exception/NotInstantiableTypeException.php` - NotInstantiableTypeException 定義（L14-20）
- E-17: `src/Symfony/Component/VarExporter/Exception/LogicException.php` - LogicException 定義（L14-16）
- E-18: `src/Symfony/Component/VarExporter/Exception/ExceptionInterface.php` - ExceptionInterface 定義（L14-16）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | VarExporter::export - スカラー値（整数）をエクスポートできること | E-01, E-06 | ○ |
| C-002 | VarExporter::export - スカラー値（文字列）をエクスポートできること | E-01, E-06 | ○ |
| C-003 | VarExporter::export - bool trueをエクスポートできること | E-01, E-06 | ○ |
| C-004 | VarExporter::export - bool falseをエクスポートできること | E-01, E-06 | ○ |
| C-005 | VarExporter::export - null値をエクスポートできること | E-01, E-06 | ○ |
| C-006 | VarExporter::export - 空配列をエクスポートできること | E-01, E-06 | ○ |
| C-007 | VarExporter::export - 配列をエクスポートできること | E-01, E-06 | ○ |
| C-008 | VarExporter::export - オブジェクトをエクスポートできること | E-01, E-06 | ○ |
| C-009 | VarExporter::export - isStaticValueがスカラーでtrueになること | E-01 (L42-46) | ○ |
| C-010 | VarExporter::export - isStaticValueがオブジェクトでfalseになること | E-01 (L53) | ○ |
| C-011 | VarExporter::export - foundClassesにクラス名が格納されること | E-01 (L73) | ○ |
| C-012 | VarExporter::export - UnitEnum値をエクスポートできること | E-01 (L44), E-06 (L212) | ○ |
| C-013 | VarExporter::export - 循環参照を含むデータをエクスポートできること | E-01, E-06 | △ |
| C-014 | VarExporter::export - __serializeメソッドを持つオブジェクトの処理 | E-06 (L90-102) | ○ |
| C-015 | VarExporter::export - リソース型で例外がスローされること | E-06 (L42-43) | ○ |
| C-016 | VarExporter::export - 浮動小数点数をエクスポートできること | E-06 (L206) | ○ |
| C-017 | VarExporter::export - ネスト配列のエクスポート | E-06 (L269-283) | ○ |
| C-018 | VarExporter::export - __wakeupメソッド対応 | E-06 (L187) | ○ |
| C-019 | Instantiator::instantiate - コンストラクタなしでオブジェクト生成 | E-02 (L41-58) | ○ |
| C-020 | Instantiator::instantiate - プロパティ付きインスタンス化 | E-02 (L57) | ○ |
| C-021 | Instantiator::instantiate - スコープ付きプロパティ設定 | E-02 (L57) | ○ |
| C-022 | Instantiator::instantiate - クローンによるインスタンス化 | E-02 (L45-46) | ○ |
| C-023 | Instantiator::instantiate - NotInstantiableTypeException | E-02 (L50) | ○ |
| C-024 | Instantiator::instantiate - ClassNotFoundException | E-02 (L43), E-07 (L66-68) | ○ |
| C-025 | Instantiator::instantiate - Serializable対応 | E-02 (L51-52) | ○ |
| C-026 | Hydrator::hydrate - publicプロパティ設定 | E-03 (L57-76) | ○ |
| C-027 | Hydrator::hydrate - protectedプロパティ設定 | E-03 (L63-66) | ○ |
| C-028 | Hydrator::hydrate - scopedPropertiesによるprivateプロパティ設定 | E-03 (L70-73) | ○ |
| C-029 | Hydrator::hydrate - 空プロパティの処理 | E-03 (L59-68) | ○ |
| C-030 | Hydrator::hydrate - 同一インスタンス返却 | E-03 (L76) | ○ |
| C-031 | Hydrator::hydrate - 複数プロパティ同時設定 | E-03 (L63-66) | ○ |
| C-032 | ProxyHelper::generateLazyProxy - 内部クラス拡張のプロキシ生成 | E-04 (L31-271) | ○ |
| C-033 | ProxyHelper::generateLazyProxy - インターフェースのみのプロキシ生成 | E-04 (L31, L81-92) | ○ |
| C-034 | ProxyHelper::generateLazyProxy - finalクラスでLogicException | E-04 (L36-38) | ○ |
| C-035 | ProxyHelper::generateLazyProxy - クラスでない場合LogicException | E-04 (L33-35) | ○ |
| C-036 | ProxyHelper::generateLazyProxy - 非内部クラス拡張でLogicException | E-04 (L40-48) | ○ |
| C-037 | ProxyHelper::generateLazyProxy - finalメソッドでLogicException | E-04 (L161-163) | ○ |
| C-038 | ProxyHelper::generateLazyProxy - 非インターフェースでLogicException | E-04 (L82-84) | ○ |
| C-039 | ProxyHelper::generateLazyProxy - LazyObjectInterface実装 | E-04 (L212) | ○ |
| C-040 | ProxyHelper::generateLazyProxy - __unserialize型ヒントなしラッパー | E-04 (L228-243) | ○ |
| C-041 | ProxyHelper::exportParameters - パラメータ定義文字列生成 | E-04 (L273-304) | ○ |
| C-042 | ProxyHelper::exportParameters - 型なしパラメータ | E-04 (L283) | ○ |
| C-043 | ProxyHelper::exportParameters - 参照渡しパラメータ | E-04 (L284) | ○ |
| C-044 | ProxyHelper::exportParameters - 可変長引数 | E-04 (L285) | ○ |
| C-045 | ProxyHelper::exportParameters - デフォルト値付きパラメータ | E-04 (L286) | ○ |
| C-046 | ProxyHelper::exportParameters - SensitiveParameter | E-04 (L282) | ○ |
| C-047 | ProxyHelper::exportSignature - シグネチャ生成 | E-04 (L306-337) | ○ |
| C-048 | ProxyHelper::exportSignature - 参照返し | E-04 (L310) | ○ |
| C-049 | ProxyHelper::exportSignature - 戻り値型 | E-04 (L317-318) | ○ |
| C-050 | ProxyHelper::exportSignature - tentativeReturnType | E-04 (L325-326) | ○ |
| C-051 | ProxyHelper::exportType - 単純型エクスポート | E-04 (L339-387) | ○ |
| C-052 | ProxyHelper::exportType - nullable型 | E-04 (L382) | ○ |
| C-053 | ProxyHelper::exportType - Union型 | E-04 (L346-348) | ○ |
| C-054 | ProxyHelper::exportType - Intersection型 | E-04 (L349-351) | ○ |
| C-055 | ProxyHelper::exportType - 型がない場合null返却 | E-04 (L341) | ○ |
| C-056 | ProxyHelper::exportType - self/parent解決 | E-04 (L369-370) | ○ |
| C-057 | ProxyHelper::exportType - noBuiltinオプション | E-04 (L366-367) | ○ |
| C-058 | Exporter::export - 整数エクスポート | E-06 (L206) | ○ |
| C-059 | Exporter::export - 空配列エクスポート | E-06 (L207) | ○ |
| C-060 | Exporter::export - false値エクスポート | E-06 (L208) | ○ |
| C-061 | Exporter::export - true値エクスポート | E-06 (L209) | ○ |
| C-062 | Exporter::export - null値エクスポート | E-06 (L210) | ○ |
| C-063 | Exporter::export - 空文字列エクスポート | E-06 (L211) | ○ |
| C-064 | Exporter::export - 特殊文字エスケープ | E-06 (L241-266) | ○ |
| C-065 | Exporter::export - UnitEnumエクスポート | E-06 (L212) | ○ |
| C-066 | Exporter::export - 正のReference | E-06 (L216-217) | ○ |
| C-067 | Exporter::export - 負のReferenceでcount=0 | E-06 (L218-221) | ○ |
| C-068 | Exporter::export - 参照形式のReference | E-06 (L222-224) | ○ |
| C-069 | Exporter::export - 配列インデント | E-06 (L269-283) | ○ |
| C-070 | Exporter::export - 連番キー省略 | E-06 (L273-279) | ○ |
| C-071 | Exporter::export - Valuesエクスポート | E-06 (L286-293) | ○ |
| C-072 | Exporter::export - UnexpectedValueException | E-06 (L303) | ○ |
| C-073 | Exporter::prepare - スカラー値配列が静的 | E-06 (L38-201) | ○ |
| C-074 | Exporter::prepare - オブジェクト含む配列が非静的 | E-06 (L69) | ○ |
| C-075 | Exporter::prepare - リソース型でException | E-06 (L42-43) | ○ |
| C-076 | Exporter::prepare - 参照処理 | E-06 (L47-57) | ○ |
| C-077 | Exporter::prepare - Named Closure処理 | E-06 (L76-81) | ○ |
| C-078 | Exporter::prepare - __sleep処理 | E-06 (L125-132) | ○ |
| C-079 | Exporter::prepare - オブジェクト重複参照 | E-06 (L70-73) | ○ |
| C-080 | Registry::__construct - classesプロパティ設定 | E-07 (L30-33) | ○ |
| C-081 | Registry::getClassReflector - 正常なリフレクション | E-07 (L64-141) | ○ |
| C-082 | Registry::getClassReflector - ClassNotFoundException | E-07 (L66-68) | ○ |
| C-083 | Registry::getClassReflector - 抽象クラスでException | E-07 (L73-74) | ○ |
| C-084 | Registry::getClassReflector - cloneableフラグ | E-07 (L118-121) | ○ |
| C-085 | Registry::getClassReflector - instantiableWithoutConstructorフラグ | E-07 (L122) | ○ |
| C-086 | Registry::getClassReflector - Throwableのtrace初期化 | E-07 (L125-138) | ○ |
| C-087 | Registry::getClassReflector - インターフェース処理 | E-07 (L73-74) | ○ |
| C-088 | Registry::unserialize - シリアライズ復元 | E-07 (L35-48) | ○ |
| C-089 | Registry::p - prototype取得 | E-07 (L50-55) | ○ |
| C-090 | Registry::f - factory取得 | E-07 (L57-62) | ○ |
| C-091 | Internal Hydrator::__construct - プロパティ設定 | E-08 (L30-37) | ○ |
| C-092 | Internal Hydrator::hydrate - プロパティハイドレーション | E-08 (L39-53) | ○ |
| C-093 | Internal Hydrator::hydrate - __unserialize wakeup | E-08 (L44-46) | ○ |
| C-094 | Internal Hydrator::hydrate - __wakeup呼び出し | E-08 (L47-49) | ○ |
| C-095 | Internal Hydrator::getHydrator - stdClass | E-08 (L57-67) | ○ |
| C-096 | Internal Hydrator::getHydrator - ErrorException | E-08 (L69-71) | ○ |
| C-097 | Internal Hydrator::getHydrator - SplObjectStorage | E-08 (L77-92) | ○ |
| C-098 | Internal Hydrator::getHydrator - ArrayObject | E-08 (L100-117) | ○ |
| C-099 | Internal Hydrator::getHydrator - ClassNotFoundException | E-08 (L95-97) | ○ |
| C-100 | Internal Hydrator::getHydrator - 内部クラスのpropertySetters | E-08 (L127-150) | ○ |
| C-101 | Internal Hydrator::getSimpleHydrator - stdClass | E-08 (L155-171) | ○ |
| C-102 | Internal Hydrator::getSimpleHydrator - SplObjectStorage | E-08 (L182-194) | ○ |
| C-103 | Internal Hydrator::getSimpleHydrator - readonlyプロパティのnotByRef | E-08 (L227-228) | △ |
| C-104 | Internal Hydrator::getSimpleHydrator - ClassNotFoundException | E-08 (L197-199) | ○ |
| C-105 | Internal Hydrator::getPropertyScopes - publicプロパティ | E-08 (L262-319) | ○ |
| C-106 | Internal Hydrator::getPropertyScopes - protectedプロパティ | E-08 (L292-294) | ○ |
| C-107 | Internal Hydrator::getPropertyScopes - privateプロパティ | E-08 (L280-283) | ○ |
| C-108 | Internal Hydrator::getPropertyScopes - readonlyフラグ | E-08 (L274) | ○ |
| C-109 | Internal Hydrator::getPropertyScopes - staticプロパティ除外 | E-08 (L270-271) | ○ |
| C-110 | Internal Hydrator::getPropertyScopes - 親クラスのprivateプロパティ | E-08 (L297-315) | ○ |
| C-111 | Internal Hydrator::getPropertyScopes - hookedプロパティフラグ | E-08 (L276-278) | △ |
| C-112 | LazyObjectState::__construct - 初期状態 | E-09 (L23) | ○ |
| C-113 | LazyObjectState::__get - realInstance遅延初期化 | E-09 (L40-47) | ○ |
| C-114 | LazyObjectState::__get - 不正プロパティアクセス | E-09 (L42-43) | ○ |
| C-115 | LazyObjectState::__clone - cloneInstance処理 | E-09 (L28-33) | ○ |
| C-116 | LazyObjectState::__clone - realInstance処理 | E-09 (L34-37) | ○ |
| C-117 | LazyObjectRegistry::getClassResetters - リセッター取得 | E-10 (L48-85) | ○ |
| C-118 | LazyObjectRegistry::getClassResetters - lazyObjectState除外 | E-10 (L62) | ○ |
| C-119 | LazyObjectRegistry::getClassResetters - 内部クラス | E-10 (L53-54) | ○ |
| C-120 | LazyObjectRegistry::getParentGet - __getなし | E-10 (L87-98) | ○ |
| C-121 | LazyObjectRegistry::getParentGet - 参照返し__get | E-10 (L97) | ○ |
| C-122 | LazyObjectRegistry::getParentGet - 非参照返し__get | E-10 (L97) | ○ |
| C-123 | LazyObjectRegistry::getParentGet - 親クラスなし | E-10 (L89-91) | ○ |
| C-124 | LazyDecoratorTrait::createLazyProxy - プロキシ生成 | E-11 (L31-54) | ○ |
| C-125 | LazyDecoratorTrait::createLazyProxy - 既存インスタンス設定 | E-11 (L33, L39-42) | ○ |
| C-126 | LazyDecoratorTrait::createLazyProxy - LogicException | E-11 (L39-42) | ○ |
| C-127 | LazyDecoratorTrait::isLazyObjectInitialized - 未初期化判定 | E-11 (L66-69) | ○ |
| C-128 | LazyDecoratorTrait::isLazyObjectInitialized - 初期化済み判定 | E-11 (L66-69) | ○ |
| C-129 | LazyDecoratorTrait::initializeLazyObject - 遅延初期化実行 | E-11 (L71-74) | ○ |
| C-130 | LazyDecoratorTrait::resetLazyObject - リセット成功 | E-11 (L76-84) | ○ |
| C-131 | LazyDecoratorTrait::resetLazyObject - リセット不可 | E-11 (L78-79) | ○ |
| C-132 | LazyDecoratorTrait::__get - プロパティアクセス委譲 | E-11 (L86-123) | ○ |
| C-133 | LazyDecoratorTrait::__set - プロパティ設定委譲 | E-11 (L125-128) | ○ |
| C-134 | LazyDecoratorTrait::__isset - isset委譲（true） | E-11 (L130-132) | ○ |
| C-135 | LazyDecoratorTrait::__isset - isset委譲（false） | E-11 (L130-132) | ○ |
| C-136 | LazyDecoratorTrait::__unset - unset委譲 | E-11 (L134-140) | ○ |
| C-137 | LazyDecoratorTrait::__unset - unset無視 | E-11 (L137) | ○ |
| C-138 | LazyDecoratorTrait::__serialize - シリアライズ | E-11 (L142-145) | ○ |
| C-139 | LazyDecoratorTrait::__unserialize - デシリアライズ | E-11 (L147-151) | ○ |
| C-140 | LazyDecoratorTrait::__clone - クローン処理 | E-11 (L153-157) | ○ |
| C-141 | Reference::__construct - id及びvalue設定 | E-12 (L23-26) | ○ |
| C-142 | Reference::__construct - count初期値0 | E-12 (L21) | ○ |
| C-143 | Reference::__construct - valueデフォルトnull | E-12 (L25) | ○ |
| C-144 | Values::__construct - values設定 | E-13 (L21-24) | ○ |
| C-145 | NamedClosure::__construct - callable及びmethod設定 | E-14 (L21-25) | ○ |
| C-146 | NamedClosure::__construct - methodデフォルトnull | E-14 (L23) | ○ |
| C-147 | ClassNotFoundException::__construct - エラーメッセージ | E-15 (L16-19) | ○ |
| C-148 | ClassNotFoundException - ExceptionInterface実装 | E-15 (L14) | ○ |
| C-149 | ClassNotFoundException::__construct - previous設定 | E-15 (L16-18) | ○ |
| C-150 | NotInstantiableTypeException::__construct - エラーメッセージ | E-16 (L16-19) | ○ |
| C-151 | NotInstantiableTypeException - ExceptionInterface実装 | E-16 (L14) | ○ |
| C-152 | NotInstantiableTypeException::__construct - previous設定 | E-16 (L16-18) | ○ |
| C-153 | LogicException - ExceptionInterface実装 | E-17 (L14) | ○ |
| C-154 | LogicException - \\LogicException継承 | E-17 (L14) | ○ |
| C-155 | Internal Hydrator::getSimpleHydrator - hookedプロパティsetRawValue | E-08 (L225-226) | △ |
| C-156 | Internal Hydrator::getSimpleHydrator - ErrorException | E-08 (L174-176) | ○ |
| C-157 | Internal Hydrator::getHydrator - TypeError | E-08 (L73-75) | ○ |
| C-158 | LazyObjectRegistry::getClassResetters - hookedプロパティ除外 | E-10 (L66-67) | △ |
| C-159 | LazyObjectRegistry::getParentGet - private __get | E-10 (L97) | ○ |
| C-160 | LazyObjectRegistry::getParentGet - abstract __get | E-10 (L97) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-013**: 循環参照を含むオブジェクトのエクスポート挙動は、Exporter::prepareの複数の分岐とReference/refsPoolの相互作用で実現されるため、具体的なテスト期待値は実行時テストで確認が必要
  - 候補：既存のテストスイート / 実行時のvar_exportとの比較テスト
- **C-103**: PHP 8.1のreadonlyプロパティの具体的なハイドレーション挙動（参照渡し不可のため直接設定される動作）は、PHP実行環境のバージョンに依存
  - 候補：PHP 8.1+環境での実行テスト / PHPドキュメント
- **C-111**: PHP 8.4のproperty hooksのgetPropertyScopes内でのフラグ設定は、PHP 8.4の新機能であり、その具体的なReflectionAPIの挙動はランタイム依存
  - 候補：PHP 8.4 RFC / PHP公式ドキュメント
- **C-155**: getSimpleHydratorにおけるhookedプロパティのsetRawValue利用は、PHP 8.4のproperty hooks対応であり、実行時のReflectionProperty::setRawValueの挙動確認が必要
  - 候補：PHP 8.4 property hooks RFC / 実行時テスト
- **C-158/C-160**: hookedプロパティのリセッター除外やabstract __getの判定は、コードの分岐条件に基づく推定であり、エッジケースの具体的な挙動は実行テストが望ましい
  - 候補：既存テストスイート / 実行時テスト

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：例外クラス（ClassNotFoundException, NotInstantiableTypeException, LogicException）、データクラス（Reference, Values, NamedClosure）のテストケースは単純で信頼度が高い
- 1（中リスク）：PHP 8.4 property hooks関連のテストケース（C-111, C-155, C-158）はPHP新機能に依存するため、実行環境での検証が推奨される
- 1（中リスク）：ProxyHelper::generateLazyProxyの各条件分岐テスト（C-032〜C-040）は複雑なReflection APIの利用があるため、テスト実装時に具体的なモック/スタブの設計が必要
- 0（低リスク）：VarExporter::export、Instantiator::instantiate、Hydrator::hydrateの基本テストケースは明確なコード根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] 全160テストケースが各ソースファイルのpublicメソッドを網羅しているか確認
- [ ] PHP 8.4 property hooks関連テストケース（C-111, C-155, C-158）が実行環境で有効か確認
- [ ] ProxyHelper::generateLazyProxyのfinalプロパティ（L72-73）に対するテストケースC-037付近が適切か確認
- [ ] Exporter::prepare内のSerializable/\_\_PHP_Incomplete_Class処理（L119-123）のテストケースが十分か確認
- [ ] LazyDecoratorTrait::__getのエラーハンドリング（L106-122）の境界条件テストが十分か確認
