---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 88
  claims_with_evidence: 85
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：Component-WebLink 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：85 / 88、根拠なし：3
- 優先レビュー（高）
  1. **C-59（UT-WLK-059）**：boolean false属性の非出力動作 - HttpHeaderSerializerのコード上 `if (true === $value)` の条件でfalseはスキップされるが、明示的な「出力されない」ことの確認が必要
  2. **C-63（UT-WLK-063）**：属性値のダブルクォートエスケープ - preg_replaceの正規表現 `(?<!\\)"` による負の後読みの挙動を実際のテストで確認すべき
  3. **C-80（UT-WLK-080）**：relが値なし（true）の場合のrelsの空配列化 - HttpHeaderParserのコード上 `true === $value ? []` の分岐が該当するが、実際のHTTPヘッダーとしての妥当性は要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/WebLink/Link.php` - Linkクラスの全実装（コンストラクタ、ゲッター、withXxx/withoutXxxメソッド、hrefIsTemplatedプライベートメソッド）
- E-02: `src/Symfony/Component/WebLink/GenericLinkProvider.php` - GenericLinkProviderクラスの全実装（コンストラクタ、getLinks、getLinksByRel、withLink、withoutLink）
- E-03: `src/Symfony/Component/WebLink/HttpHeaderSerializer.php` - HttpHeaderSerializerクラスのserializeメソッド実装
- E-04: `src/Symfony/Component/WebLink/HttpHeaderParser.php` - HttpHeaderParserクラスのparseメソッド実装（LINK_PATTERN、PARAM_PATTERNの正規表現定数含む）
- E-05: `src/Symfony/Component/WebLink/EventListener/AddLinkHeaderListener.php` - AddLinkHeaderListenerクラスの全実装（onKernelResponse、getSubscribedEvents）
- E-06: PSR-13 `Psr\Link\EvolvableLinkInterface` - Linkクラスが実装するインターフェース仕様
- E-07: PSR-13 `Psr\Link\EvolvableLinkProviderInterface` - GenericLinkProviderクラスが実装するインターフェース仕様
- E-08: RFC 5988 - Web Linking仕様（HTTP Linkヘッダーのフォーマット定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-WLK-001: rel指定ありでLinkオブジェクトが生成される | E-01 L160-167 | ○ |
| C-02 | UT-WLK-002: rel=nullでLinkオブジェクトが生成される | E-01 L160-167 | ○ |
| C-03 | UT-WLK-003: 引数なしでLinkオブジェクトが生成される | E-01 L160-167 | ○ |
| C-04 | UT-WLK-004: コンストラクタで設定したhrefが取得できる | E-01 L169-172 | ○ |
| C-05 | UT-WLK-005: 空文字列のhrefが取得できる | E-01 L162, L169-172 | ○ |
| C-06 | UT-WLK-006: テンプレート文字を含むhrefでtrueが返る | E-01 L174-177, L242-245 | ○ |
| C-07 | UT-WLK-007: テンプレート文字を含まないhrefでfalseが返る | E-01 L174-177, L242-245 | ○ |
| C-08 | UT-WLK-008: 開き波括弧のみのhrefでtrueが返る | E-01 L243-244 | ○ |
| C-09 | UT-WLK-009: 閉じ波括弧のみのhrefでtrueが返る | E-01 L243-244 | ○ |
| C-10 | UT-WLK-010: 空文字列hrefでfalseが返る | E-01 L242-245 | ○ |
| C-11 | UT-WLK-011: 設定されたrelが配列で取得できる | E-01 L179-182 | ○ |
| C-12 | UT-WLK-012: 複数relがすべて取得できる | E-01 L179-182, L202-208 | ○ |
| C-13 | UT-WLK-013: rel未設定で空配列が返る | E-01 L153, L179-182 | ○ |
| C-14 | UT-WLK-014: 設定された属性が連想配列で取得できる | E-01 L189-192 | ○ |
| C-15 | UT-WLK-015: 複数属性がすべて取得できる | E-01 L189-192, L226-232 | ○ |
| C-16 | UT-WLK-016: 属性未設定で空配列が返る | E-01 L158, L189-192 | ○ |
| C-17 | UT-WLK-017: withHrefで新しいインスタンスが返される | E-01 L194-200 | ○ |
| C-18 | UT-WLK-018: withHrefで元のインスタンスが変更されない | E-01 L196 (clone) | ○ |
| C-19 | UT-WLK-019: Stringableオブジェクトをhrefとして設定できる | E-01 L194 (型宣言 string\|\Stringable) | ○ |
| C-20 | UT-WLK-020: withRelで新しいインスタンスが返される | E-01 L202-208 | ○ |
| C-21 | UT-WLK-021: withRelで元のインスタンスが変更されない | E-01 L204 (clone) | ○ |
| C-22 | UT-WLK-022: 既存relに追加で新しいrelが設定できる | E-01 L202-208 | ○ |
| C-23 | UT-WLK-023: 同じrelを重複追加しても重複しない | E-01 L205 ($that->rel[$rel] = $rel) | ○ |
| C-24 | UT-WLK-024: withoutRelで指定relが除去される | E-01 L210-216 | ○ |
| C-25 | UT-WLK-025: withoutRelで元のインスタンスが変更されない | E-01 L212 (clone) | ○ |
| C-26 | UT-WLK-026: 存在しないrelを除去しても例外なし | E-01 L213 (unset) | ○ |
| C-27 | UT-WLK-027: withAttributeで新しいインスタンスが返される | E-01 L226-232 | ○ |
| C-28 | UT-WLK-028: withAttributeで元のインスタンスが変更されない | E-01 L228 (clone) | ○ |
| C-29 | UT-WLK-029: 既存属性が上書きされる | E-01 L229 | ○ |
| C-30 | UT-WLK-030: 整数値を属性値として設定できる | E-01 L226 (型宣言 int) | ○ |
| C-31 | UT-WLK-031: 浮動小数点値を属性値として設定できる | E-01 L226 (型宣言 float) | ○ |
| C-32 | UT-WLK-032: 真偽値を属性値として設定できる | E-01 L226 (型宣言 bool) | ○ |
| C-33 | UT-WLK-033: 配列を属性値として設定できる | E-01 L226 (型宣言 array) | ○ |
| C-34 | UT-WLK-034: Stringableオブジェクトを属性値として設定できる | E-01 L226 (型宣言 \Stringable) | ○ |
| C-35 | UT-WLK-035: withoutAttributeで指定属性が除去される | E-01 L234-240 | ○ |
| C-36 | UT-WLK-036: withoutAttributeで元のインスタンスが変更されない | E-01 L236 (clone) | ○ |
| C-37 | UT-WLK-037: 存在しない属性を除去しても例外なし | E-01 L237 (unset) | ○ |
| C-38 | UT-WLK-038: 空配列でGenericLinkProviderが生成される | E-02 L27-36 | ○ |
| C-39 | UT-WLK-039: Link配列を指定してGenericLinkProviderが生成される | E-02 L27-36 | ○ |
| C-40 | UT-WLK-040: 複数Link配列を指定して生成される | E-02 L27-36 | ○ |
| C-41 | UT-WLK-041: 引数なしでGenericLinkProviderが生成される | E-02 L27 | ○ |
| C-42 | UT-WLK-042: 登録されたリンクが配列で取得できる | E-02 L38-41 | ○ |
| C-43 | UT-WLK-043: 返却配列が0からの連番インデックスである | E-02 L40 (array_values) | ○ |
| C-44 | UT-WLK-044: リンク0件で空配列が返る | E-02 L38-41 | ○ |
| C-45 | UT-WLK-045: 指定relを持つリンクのみが取得できる | E-02 L43-54 | ○ |
| C-46 | UT-WLK-046: 該当リンクが複数ある場合すべて取得できる | E-02 L43-54 | ○ |
| C-47 | UT-WLK-047: 該当relのリンクがない場合空配列が返る | E-02 L43-54 | ○ |
| C-48 | UT-WLK-048: リンク0件でgetLinksByRelを呼ぶと空配列が返る | E-02 L43-54 | ○ |
| C-49 | UT-WLK-049: withLinkで新しいインスタンスが返される | E-02 L56-62 | ○ |
| C-50 | UT-WLK-050: withLinkで元のインスタンスが変更されない | E-02 L58 (clone) | ○ |
| C-51 | UT-WLK-051: 同じリンクオブジェクトを再度追加しても重複しない | E-02 L59 (spl_object_id) | ○ |
| C-52 | UT-WLK-052: withoutLinkで指定リンクが除去される | E-02 L64-70 | ○ |
| C-53 | UT-WLK-053: withoutLinkで元のインスタンスが変更されない | E-02 L66 (clone) | ○ |
| C-54 | UT-WLK-054: 登録されていないリンクを除去しても例外なし | E-02 L67 (unset) | ○ |
| C-55 | UT-WLK-055: 単一リンクがHTTP Linkヘッダー形式に変換される | E-03 L30-63 | ○ |
| C-56 | UT-WLK-056: 複数リンクがカンマ区切りで変換される | E-03 L62 (implode(',')) | ○ |
| C-57 | UT-WLK-057: 属性付きリンクが正しく変換される | E-03 L39-52 | ○ |
| C-58 | UT-WLK-058: 真偽値属性（true）がキーのみで出力される | E-03 L54-56 | ○ |
| C-59 | UT-WLK-059: 真偽値属性（false）が出力されない | E-03 L48-56 | △ |
| C-60 | UT-WLK-060: 配列属性が複数の同名パラメータとして出力される | E-03 L40-46 | ○ |
| C-61 | UT-WLK-061: テンプレートリンクがスキップされる | E-03 L34-36 | ○ |
| C-62 | UT-WLK-062: 空リンクリストでnullが返る | E-03 L62 | ○ |
| C-63 | UT-WLK-063: 属性値のダブルクォートエスケープ | E-03 L42, L49 | △ |
| C-64 | UT-WLK-064: 複数relのリンクがスペース区切りで変換される | E-03 L38 (implode(' ')) | ○ |
| C-65 | UT-WLK-065: すべてのリンクがテンプレートの場合nullが返る | E-03 L34-36, L62 | ○ |
| C-66 | UT-WLK-066: 単一のLink HTTPヘッダーがパースされる | E-04 L34-86 | ○ |
| C-67 | UT-WLK-067: 複数のLink HTTPヘッダーがパースされる | E-04 L34-86 | ○ |
| C-68 | UT-WLK-068: 配列形式のヘッダーがパースされる | E-04 L36-38 | ○ |
| C-69 | UT-WLK-069: 属性付きリンクヘッダーがパースされる | E-04 L49-72 | ○ |
| C-70 | UT-WLK-070: クォートなし属性値がパースされる | E-04 L57 (pm[3]) | ○ |
| C-71 | UT-WLK-071: 値なし属性がtrueとしてパースされる | E-04 L59 (default => true) | ○ |
| C-72 | UT-WLK-072: 複数relがスペース区切りでパースされる | E-04 L64 (preg_split) | ○ |
| C-73 | UT-WLK-073: エスケープされたクォートを含む属性値がパースされる | E-04 L56 (stripcslashes) | ○ |
| C-74 | UT-WLK-074: 同名属性が複数回出現した場合配列に変換される | E-04 L65-68 | ○ |
| C-75 | UT-WLK-075: relが複数回出現した場合最初のrelのみ使用される | E-04 L63-64 (??= 演算子) | ○ |
| C-76 | UT-WLK-076: 空文字列で空のLinkProviderが返る | E-04 L41-43 | ○ |
| C-77 | UT-WLK-077: 空配列で空のLinkProviderが返る | E-04 L36-38, L41-43 | ○ |
| C-78 | UT-WLK-078: 不正な形式のヘッダーで空のLinkProviderが返る | E-04 L41-43 | ○ |
| C-79 | UT-WLK-079: パース結果がEvolvableLinkProviderInterfaceを実装する | E-04 L34, E-02 L17 | ○ |
| C-80 | UT-WLK-080: relが値なしの場合relsが空配列になる | E-04 L59, L64 | △ |
| C-81 | UT-WLK-081: メインリクエストでLinkProviderがある場合Linkヘッダーが設定される | E-05 L37-48 | ○ |
| C-82 | UT-WLK-082: サブリクエストの場合Linkヘッダーが設定されない | E-05 L39-41 | ○ |
| C-83 | UT-WLK-083: _links属性がない場合Linkヘッダーが設定されない | E-05 L43-45 | ○ |
| C-84 | UT-WLK-084: _linksがLinkProviderInterfaceでない場合ヘッダー未設定 | E-05 L44 (instanceof) | ○ |
| C-85 | UT-WLK-085: LinkProviderのリンクが0件の場合ヘッダー未設定 | E-05 L44 (\|\| !$links) | ○ |
| C-86 | UT-WLK-086: KernelEvents::RESPONSEにonKernelResponseが登録される | E-05 L51-54 | ○ |
| C-87 | UT-WLK-087: デフォルトのHttpHeaderSerializerで生成される | E-05 L32-34 | ○ |
| C-88 | UT-WLK-088: カスタムHttpHeaderSerializerで生成される | E-05 L32-34 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-59: HttpHeaderSerializerのserializeメソッドで `if (true === $value)` の条件があるが、falseの場合は何も出力しないことは条件分岐の暗黙的な動作であり、明示的なテストコードやドキュメントによる確認がない
  - 候補：既存テストスイート / RFC 5988のboolean属性仕様 / Symfony公式ドキュメント
- C-63: preg_replaceのパターン `(?<!\\)"` による負の後読みでバックスラッシュの前のダブルクォートをエスケープしない挙動は、連続バックスラッシュ等のエッジケースで確認が必要
  - 候補：RFC 5988の属性値エスケープ仕様 / 既存テストスイート
- C-80: `rel` パラメータが値なし（`; rel`）でパースされた場合の実際のHTTPヘッダーとしての妥当性。コード上は `true === $value ? []` で空配列になるが、実際にこのようなヘッダーが送出されるかは不明
  - 候補：RFC 5988仕様 / 実際のWebサーバーの動作確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Link、GenericLinkProviderのイミュータブル操作はすべてcloneベースで明確（C-01〜C-54）
- 0: 低リスク - HttpHeaderSerializer/HttpHeaderParserの基本動作は正規表現ベースで検証可能（C-55〜C-58, C-60〜C-62, C-64〜C-79）
- 1: 中リスク - HttpHeaderSerializerの属性値エスケープ処理（C-63）- 正規表現の負の後読みによるエッジケース
- 0: 低リスク - AddLinkHeaderListenerのイベント処理は条件分岐が明確（C-81〜C-88）
- 1: 中リスク - HttpHeaderParserのrelが値なしの場合の挙動（C-80）- 実際のHTTP仕様との整合性

## 6) レビュアーチェックリスト（最小）
- [ ] Link.phpのイミュータブル性テスト（C-17〜C-37）が元インスタンスの不変性も確認しているか
- [ ] HttpHeaderSerializerでboolean false属性が出力されないこと（C-59）の動作を実際にテスト実行して確認
- [ ] HttpHeaderSerializerの属性値エスケープ（C-63）がバックスラッシュ連続を含むエッジケースに対応しているか
- [ ] HttpHeaderParserで同名属性の配列化（C-74）が3件以上の同名属性でも正しく動作するか
- [ ] HttpHeaderParserのrelが値なし（C-80）のケースが実際のHTTPヘッダー仕様として妥当か
- [ ] AddLinkHeaderListenerのonKernelResponse（C-81）でheaders->setの第3引数falseの挙動（ヘッダー追加モード）が期待通りか
- [ ] 全テストケースのテストIDが連番で一意であること
