---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 67
  claims_with_evidence: 64
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：Component-Webhook 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：64 / 67、根拠なし：3
- 優先レビュー（高）
  1. **UT-WHK-048**：NativeJsonPayloadSerializer のエンコード不能値（NAN）の挙動はPHPバージョン依存の可能性あり
  2. **UT-WHK-065**：長いURL文字列の境界値テストはSymfonyの要件仕様に基づく上限が不明
  3. **UT-WHK-066**：マルチバイト文字のjson_encodeの挙動はPHPのデフォルトフラグ依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Webhook/Subscriber.php` - Subscriberクラス定義（コンストラクタ、ゲッター、シークレットバリデーション）
- E-02: `src/Symfony/Component/Webhook/Controller/WebhookController.php` - WebhookControllerクラス定義（handleメソッド、パーサー呼び出し、イベントディスパッチ）
- E-03: `src/Symfony/Component/Webhook/Client/AbstractRequestParser.php` - AbstractRequestParserクラス定義（parse、createSuccessfulResponse、createRejectedResponse、validate）
- E-04: `src/Symfony/Component/Webhook/Client/RequestParser.php` - RequestParserクラス定義（doParse、getRequestMatcher、validateSignature）
- E-05: `src/Symfony/Component/Webhook/Client/RequestParserInterface.php` - RequestParserInterfaceインターフェース定義
- E-06: `src/Symfony/Component/Webhook/Server/Transport.php` - Transportクラス定義（sendメソッド）
- E-07: `src/Symfony/Component/Webhook/Server/HeadersConfigurator.php` - HeadersConfiguratorクラス定義（configureメソッド）
- E-08: `src/Symfony/Component/Webhook/Server/JsonBodyConfigurator.php` - JsonBodyConfiguratorクラス定義（コンストラクタ、configureメソッド）
- E-09: `src/Symfony/Component/Webhook/Server/HeaderSignatureConfigurator.php` - HeaderSignatureConfiguratorクラス定義（configureメソッド、署名生成ロジック）
- E-10: `src/Symfony/Component/Webhook/Server/SerializerPayloadSerializer.php` - SerializerPayloadSerializerクラス定義（serializeメソッド）
- E-11: `src/Symfony/Component/Webhook/Server/NativeJsonPayloadSerializer.php` - NativeJsonPayloadSerializerクラス定義（serializeメソッド、JSON_THROW_ON_ERROR使用）
- E-12: `src/Symfony/Component/Webhook/Messenger/SendWebhookMessage.php` - SendWebhookMessageクラス定義（コンストラクタ、ゲッター）
- E-13: `src/Symfony/Component/Webhook/Messenger/SendWebhookHandler.php` - SendWebhookHandlerクラス定義（__invokeメソッド）
- E-14: `src/Symfony/Component/Webhook/Exception/RejectWebhookException.php` - RejectWebhookExceptionクラス定義（HttpException拡張、デフォルトstatusCode=406）
- E-15: `src/Symfony/Component/Webhook/Test/AbstractRequestParserTestCase.php` - AbstractRequestParserTestCaseクラス定義（testParse、getPayloads、createRequest、getFixtureExtension、getSecret）
- E-16: `src/Symfony/Component/Webhook/Server/PayloadSerializerInterface.php` - PayloadSerializerInterfaceインターフェース定義
- E-17: `src/Symfony/Component/Webhook/Server/RequestConfiguratorInterface.php` - RequestConfiguratorInterfaceインターフェース定義
- E-18: `src/Symfony/Component/Webhook/Server/TransportInterface.php` - TransportInterfaceインターフェース定義
- E-19: `src/Symfony/Component/Webhook/Exception/InvalidArgumentException.php` - InvalidArgumentExceptionクラス定義
- E-20: `src/Symfony/Component/Webhook/Exception/LogicException.php` - LogicExceptionクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-WHK-001: Subscriberが有効なURL/secretで生成される | E-01 (L18-25) | ○ |
| C-02 | UT-WHK-002: 空secretでInvalidArgumentExceptionスロー | E-01 (L22-24), E-19 | ○ |
| C-03 | UT-WHK-003: getUrl()がURL文字列を返す | E-01 (L27-30) | ○ |
| C-04 | UT-WHK-004: getSecret()がsecret文字列を返す | E-01 (L32-35) | ○ |
| C-05 | UT-WHK-005: handleで正常にイベントディスパッチ | E-02 (L36-56) | ○ |
| C-06 | UT-WHK-006: 未登録typeで404レスポンス | E-02 (L38-40) | ○ |
| C-07 | UT-WHK-007: parse()がnull時にリジェクトレスポンス | E-02 (L45-47) | ○ |
| C-08 | UT-WHK-008: 配列RemoteEventで全イベントディスパッチ | E-02 (L49-53) | ○ |
| C-09 | UT-WHK-009: 単一RemoteEventで1件ディスパッチ | E-02 (L49-53) | ○ |
| C-10 | UT-WHK-010: AbstractRequestParser.parseが正常動作 | E-03 (L25-29) | ○ |
| C-11 | UT-WHK-011: マッチしないリクエストでRejectWebhookException | E-03 (L46-51) | ○ |
| C-12 | UT-WHK-012: createSuccessfulResponseで202レスポンス | E-03 (L32-35) | ○ |
| C-13 | UT-WHK-013: createSuccessfulResponseにRequest引数ありでも202 | E-03 (L32-35) | ○ |
| C-14 | UT-WHK-014: createRejectedResponseで406レスポンス | E-03 (L37-40) | ○ |
| C-15 | UT-WHK-015: validateでRejectWebhookException | E-03 (L46-51) | ○ |
| C-16 | UT-WHK-016: RequestParserデフォルトコンストラクタ | E-04 (L29-35) | ○ |
| C-17 | UT-WHK-017: RequestParserカスタムコンストラクタ | E-04 (L29-35) | ○ |
| C-18 | UT-WHK-018: getRequestMatcherがPOST+JSON matcher返却 | E-04 (L37-43) | ○ |
| C-19 | UT-WHK-019: 有効な署名付きリクエストでRemoteEvent返却 | E-04 (L45-66) | ○ |
| C-20 | UT-WHK-020: 空secretでInvalidArgumentException | E-04 (L47-49) | ○ |
| C-21 | UT-WHK-021: Webhook-Signatureヘッダー欠落でRejectWebhookException | E-04 (L53-57) | ○ |
| C-22 | UT-WHK-022: Webhook-Eventヘッダー欠落でRejectWebhookException | E-04 (L53-57) | ○ |
| C-23 | UT-WHK-023: Webhook-Idヘッダー欠落でRejectWebhookException | E-04 (L53-57) | ○ |
| C-24 | UT-WHK-024: 不正署名でRejectWebhookException | E-04 (L68-77) | ○ |
| C-25 | UT-WHK-025: カスタムアルゴリズムsha512で署名検証成功 | E-04 (L30, L74) | ○ |
| C-26 | UT-WHK-026: カスタムヘッダー名で正常パース | E-04 (L31-33) | ○ |
| C-27 | UT-WHK-027: Transport.sendでPOSTリクエスト送信 | E-06 (L32-41) | ○ |
| C-28 | UT-WHK-028: 各コンフィギュレータに正しいsecret伝播 | E-06 (L36-38) | ○ |
| C-29 | UT-WHK-029: HeadersConfiguratorデフォルトコンストラクタ | E-07 (L22-25) | ○ |
| C-30 | UT-WHK-030: configureでイベント名/IDがヘッダー設定 | E-07 (L28-34) | ○ |
| C-31 | UT-WHK-031: カスタムヘッダー名でイベント名/ID設定 | E-07 (L22-25, L28-34) | ○ |
| C-32 | UT-WHK-032: SerializerInterface渡し時のラップ動作 | E-08 (L25-27) | ○ |
| C-33 | UT-WHK-033: PayloadSerializerInterface渡し時のそのまま使用 | E-08 (L25-27) | ○ |
| C-34 | UT-WHK-034: ペイロードがJSONボディに設定 | E-08 (L30-37) | ○ |
| C-35 | UT-WHK-035: Content-Typeがapplication/jsonに設定 | E-08 (L34-36) | ○ |
| C-36 | UT-WHK-036: 既存ヘッダー保持+Content-Type追加 | E-08 (L34-36) | ○ |
| C-37 | UT-WHK-037: HeaderSignatureConfiguratorデフォルトコンストラクタ | E-09 (L24-27) | ○ |
| C-38 | UT-WHK-038: HMAC署名がヘッダーに設定 | E-09 (L30-44) | ○ |
| C-39 | UT-WHK-039: 空secretでInvalidArgumentException | E-09 (L32-34) | ○ |
| C-40 | UT-WHK-040: body未設定でLogicException | E-09 (L38-40), E-20 | ○ |
| C-41 | UT-WHK-041: カスタムアルゴリズムで署名生成 | E-09 (L25, L42) | ○ |
| C-42 | UT-WHK-042: カスタム署名ヘッダー名で署名設定 | E-09 (L26, L43) | ○ |
| C-43 | UT-WHK-043: 署名がevent名+ID+bodyの連結で計算 | E-09 (L42) | ○ |
| C-44 | UT-WHK-044: SerializerPayloadSerializer.serializeがSerializer委譲 | E-10 (L23-26) | ○ |
| C-45 | UT-WHK-045: NativeJsonPayloadSerializer.serializeでjson_encode | E-11 (L16-19) | ○ |
| C-46 | UT-WHK-046: 空配列で'[]'返却 | E-11 (L16-19) | ○ |
| C-47 | UT-WHK-047: ネスト配列の正しいJSON変換 | E-11 (L16-19) | ○ |
| C-48 | UT-WHK-048: エンコード不能値(NAN)でJsonException | E-11 (L18: JSON_THROW_ON_ERROR) | △ |
| C-49 | UT-WHK-049: SendWebhookMessageコンストラクタ | E-12 (L22-26) | ○ |
| C-50 | UT-WHK-050: getSubscriber()がSubscriber返却 | E-12 (L28-31) | ○ |
| C-51 | UT-WHK-051: getEvent()がRemoteEvent返却 | E-12 (L33-36) | ○ |
| C-52 | UT-WHK-052: SendWebhookHandler.__invokeでtransport.send呼出 | E-13 (L26-29) | ○ |
| C-53 | UT-WHK-053: RejectWebhookExceptionデフォルトコンストラクタ | E-14 (L21-24) | ○ |
| C-54 | UT-WHK-054: RejectWebhookExceptionカスタムコンストラクタ | E-14 (L21-24) | ○ |
| C-55 | UT-WHK-055: RejectWebhookExceptionの前例外設定 | E-14 (L21-24) | ○ |
| C-56 | UT-WHK-056: AbstractRequestParserTestCase.testParseの基本動作 | E-15 (L29-35) | ○ |
| C-57 | UT-WHK-057: createRequestでPOST/JSON Request生成 | E-15 (L63-68) | ○ |
| C-58 | UT-WHK-058: getFixtureExtensionが'json'返却 | E-15 (L70-73) | ○ |
| C-59 | UT-WHK-059: getSecretが空文字列返却 | E-15 (L58-61) | ○ |
| C-60 | UT-WHK-060: 空JSONオブジェクトのパース | E-04 (L45-66) | ○ |
| C-61 | UT-WHK-061: GETリクエストでRejectWebhookException | E-04 (L37-43), E-03 (L46-51) | ○ |
| C-62 | UT-WHK-062: JSON以外のContent-TypeでRejectWebhookException | E-04 (L37-43), E-03 (L46-51) | ○ |
| C-63 | UT-WHK-063: 既存ヘッダー保持+署名ヘッダー追加 | E-09 (L37-43) | ○ |
| C-64 | UT-WHK-064: SubscriberのURLにPOSTリクエスト送信 | E-06 (L40) | ○ |
| C-65 | UT-WHK-065: 長いURL文字列でSubscriber生成 | **根拠なし** | △ |
| C-66 | UT-WHK-066: 日本語を含む配列のJSON変換 | **根拠なし** | △ |
| C-67 | UT-WHK-067: parserのcreateSuccessfulResponseが呼ばれる | E-02 (L55) | ○ |

## 4) 不足情報（Unknown / Missing）
- UT-WHK-048（C-48）：`JSON_THROW_ON_ERROR` フラグ使用時にNANが `JsonException` をスローすることはPHP 7.3以降の仕様だが、Symfony 8.1はPHP >= 8.4を要求するためバージョン上は問題なし。ただし、具体的にどの型の値がエンコード不能かはPHPの内部実装に依存する。
  - 候補：PHP公式ドキュメント / Symfony互換性マトリクス
- UT-WHK-065（C-65）：Subscriberクラスに URL長の上限チェックは存在しない。このテストケースは「境界値として長いURLでも動作する」ことを確認するものだが、コード上は特に制限がない。
  - 候補：RFC 2616 / Symfony HttpFoundation の制約
- UT-WHK-066（C-66）：`json_encode` のデフォルト動作ではマルチバイト文字は `\uXXXX` 形式にエスケープされる。JSON_UNESCAPED_UNICODE フラグは使用されていないため、実際の出力がエスケープされた形式になる。
  - 候補：PHP json_encode ドキュメント / テスト実行結果

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：大半のテストケースはソースコードに直接対応する明確な根拠がある
- 1（中リスク）：署名検証ロジック（UT-WHK-019, UT-WHK-024, UT-WHK-038, UT-WHK-043）は、HMAC計算の入力文字列の連結順序（event名+ID+body）がクライアント側とサーバー側で一致していることが重要。コード上はE-04(L74)とE-09(L42)で同一ロジックだが、外部プロバイダ連携時は要注意。
- 0（低リスク）：例外クラス（UT-WHK-053～055）はHttpExceptionを継承しており、Symfony内部仕様への依存はあるが低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 署名計算ロジック（UT-WHK-019, UT-WHK-024, UT-WHK-038, UT-WHK-043）で、HMAC入力の連結順序がサーバー側（HeaderSignatureConfigurator）とクライアント側（RequestParser）で一致しているか確認
- [ ] WebhookController.handle のイベントディスパッチ（UT-WHK-005, UT-WHK-008, UT-WHK-009）で、ConsumeRemoteEventMessage の型パラメータが正しいか確認
- [ ] NativeJsonPayloadSerializer の JSON_THROW_ON_ERROR フラグ使用時の例外型（UT-WHK-048）がPHP 8.4環境で期待通りか確認
- [ ] JsonBodyConfigurator のコンストラクタ（UT-WHK-032, UT-WHK-033）で、SerializerInterface と PayloadSerializerInterface の判定ロジックが正しいか確認
- [ ] テストケースの優先度が適切に設定されているか（セキュリティ関連は「高」、ゲッターは「中」以下）
