---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 229
  claims_with_evidence: 224
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：Component-Workflow 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：224 / 229、根拠なし：5
- 優先レビュー（高）
  1. **UT-WKF-117（BackedEnum対応テスト）**：BackedEnumの具体的なテストsubjectクラスの構造は推測に基づく
  2. **UT-WKF-209（TraceableWorkflow disabled状態テスト）**：disabled Closureの動作検証はソースコードの読み取りに基づくが実動作確認が必要
  3. **UT-WKF-228（WorkflowDataCollector getCallsCount）**：DataCollectorの統合的な動作は外部依存を含むため要確認
  4. **UT-WKF-038（TransitionBlocker::createUnknown デフォルトメッセージ）**：debug_backtraceの動作は実行環境依存
  5. **UT-WKF-091（コンテキストによるイベント無効化）**：DISABLE_EVENTS_MAPPINGの動作はソース読み取りに基づくが結合テスト的な側面がある

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Workflow/Arc.php` - Arcクラス定義（place, weight検証ロジック）
- E-02: `src/Symfony/Component/Workflow/Marking.php` - Markingクラス定義（mark/unmark/has/getTokenCount/getPlaces/context）
- E-03: `src/Symfony/Component/Workflow/Transition.php` - Transitionクラス定義（name, fromArcs, toArcs, normalize）
- E-04: `src/Symfony/Component/Workflow/TransitionBlocker.php` - TransitionBlockerクラス定義（createBlockedByMarking等のファクトリメソッド）
- E-05: `src/Symfony/Component/Workflow/TransitionBlockerList.php` - TransitionBlockerListクラス定義（add/has/clear/isEmpty/count/getIterator）
- E-06: `src/Symfony/Component/Workflow/Definition.php` - Definitionクラス定義（places, transitions, initialPlaces, metadataStore）
- E-07: `src/Symfony/Component/Workflow/DefinitionBuilder.php` - DefinitionBuilderクラス定義（build/clear/addPlace/addTransition等）
- E-08: `src/Symfony/Component/Workflow/Workflow.php` - Workflowクラス定義（getMarking/can/apply/buildTransitionBlockerList/getEnabledTransitions等）
- E-09: `src/Symfony/Component/Workflow/StateMachine.php` - StateMachineクラス定義（MethodMarkingStore singleState=true）
- E-10: `src/Symfony/Component/Workflow/Registry.php` - Registryクラス定義（addWorkflow/has/get/all）
- E-11: `src/Symfony/Component/Workflow/MarkingStore/MethodMarkingStore.php` - MethodMarkingStoreクラス定義（getMarking/setMarking/getGetter/getSetter）
- E-12: `src/Symfony/Component/Workflow/SupportStrategy/InstanceOfSupportStrategy.php` - InstanceOfSupportStrategyクラス定義
- E-13: `src/Symfony/Component/Workflow/Metadata/InMemoryMetadataStore.php` - InMemoryMetadataStoreクラス定義
- E-14: `src/Symfony/Component/Workflow/Metadata/GetMetadataTrait.php` - GetMetadataTraitトレイト定義
- E-15: `src/Symfony/Component/Workflow/Event/Event.php` - 基底Eventクラス定義
- E-16: `src/Symfony/Component/Workflow/Event/GuardEvent.php` - GuardEventクラス定義（isBlocked/setBlocked/addTransitionBlocker）
- E-17: `src/Symfony/Component/Workflow/Event/TransitionEvent.php` - TransitionEventクラス定義（getContext/setContext）
- E-18: `src/Symfony/Component/Workflow/Event/EventNameTrait.php` - EventNameTraitトレイト定義（computeName）
- E-19: `src/Symfony/Component/Workflow/Event/HasContextTrait.php` - HasContextTraitトレイト定義
- E-20: `src/Symfony/Component/Workflow/Event/LeaveEvent.php` - LeaveEventクラス定義
- E-21: `src/Symfony/Component/Workflow/Event/EnterEvent.php` - EnterEventクラス定義
- E-22: `src/Symfony/Component/Workflow/Event/EnteredEvent.php` - EnteredEventクラス定義
- E-23: `src/Symfony/Component/Workflow/Event/CompletedEvent.php` - CompletedEventクラス定義
- E-24: `src/Symfony/Component/Workflow/Event/AnnounceEvent.php` - AnnounceEventクラス定義
- E-25: `src/Symfony/Component/Workflow/Validator/WorkflowValidator.php` - WorkflowValidatorクラス定義
- E-26: `src/Symfony/Component/Workflow/Validator/StateMachineValidator.php` - StateMachineValidatorクラス定義
- E-27: `src/Symfony/Component/Workflow/Dumper/GraphvizDumper.php` - GraphvizDumperクラス定義
- E-28: `src/Symfony/Component/Workflow/Dumper/StateMachineGraphvizDumper.php` - StateMachineGraphvizDumperクラス定義
- E-29: `src/Symfony/Component/Workflow/Dumper/MermaidDumper.php` - MermaidDumperクラス定義
- E-30: `src/Symfony/Component/Workflow/Dumper/PlantUmlDumper.php` - PlantUmlDumperクラス定義
- E-31: `src/Symfony/Component/Workflow/EventListener/GuardExpression.php` - GuardExpressionクラス定義
- E-32: `src/Symfony/Component/Workflow/EventListener/GuardListener.php` - GuardListenerクラス定義
- E-33: `src/Symfony/Component/Workflow/EventListener/AuditTrailListener.php` - AuditTrailListenerクラス定義
- E-34: `src/Symfony/Component/Workflow/Debug/TraceableWorkflow.php` - TraceableWorkflowクラス定義
- E-35: `src/Symfony/Component/Workflow/Attribute/BuildEventNameTrait.php` - BuildEventNameTraitトレイト定義
- E-36: `src/Symfony/Component/Workflow/Exception/TransitionException.php` - TransitionExceptionクラス定義
- E-37: `src/Symfony/Component/Workflow/Exception/NotEnabledTransitionException.php` - NotEnabledTransitionExceptionクラス定義
- E-38: `src/Symfony/Component/Workflow/Exception/UndefinedTransitionException.php` - UndefinedTransitionExceptionクラス定義
- E-39: `src/Symfony/Component/Workflow/DependencyInjection/WorkflowGuardListenerPass.php` - WorkflowGuardListenerPassクラス定義
- E-40: `src/Symfony/Component/Workflow/WorkflowEvents.php` - WorkflowEventsクラス定義
- E-41: `src/Symfony/Component/Workflow/DataCollector/WorkflowDataCollector.php` - WorkflowDataCollectorクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Arc: weight<1でInvalidArgumentException | E-01 (L23-25) | ○ |
| C-02 | Arc: 空place名でInvalidArgumentException | E-01 (L26-28) | ○ |
| C-03 | Marking: mark()でnbToken<1は例外 | E-02 (L43-45) | ○ |
| C-04 | Marking: unmark()で未マークplaceは例外 | E-02 (L60-62) | ○ |
| C-05 | Marking: unmark()でトークン不足は例外 | E-02 (L66-67) | ○ |
| C-06 | Marking: unmark()でトークン0になると削除 | E-02 (L70-71) | ○ |
| C-07 | Transition: normalize()で不正型はTypeError | E-03 (L83) | ○ |
| C-08 | Transition: getFroms(asArc=false)はplace名配列 | E-03 (L57) | ○ |
| C-09 | Transition: getFroms(asArc=true)はArc配列 | E-03 (L54) | ○ |
| C-10 | TransitionBlocker: createBlockedByMarkingのコード | E-04 (L19, L44-49) | ○ |
| C-11 | TransitionBlocker: createUnknown(null)でbacktrace使用 | E-04 (L72) | △ |
| C-12 | Definition: 最初のplaceがデフォルト初期プレイス | E-06 (L98-100) | ○ |
| C-13 | Definition: 存在しないinitialPlaceで例外 | E-06 (L88-90) | ○ |
| C-14 | Definition: Transitionで参照されるplaceが自動追加 | E-06 (L107-117) | ○ |
| C-15 | Workflow: markingが空でinitialPlacesなしはLogicException | E-08 (L79-81) | ○ |
| C-16 | Workflow: 未知のplaceでLogicException | E-08 (L99-106) | ○ |
| C-17 | Workflow: applyで未定義transitionはUndefinedTransitionException | E-08 (L201-203) | ○ |
| C-18 | Workflow: applyで無効transitionはNotEnabledTransitionException | E-08 (L205-207) | ○ |
| C-19 | Workflow: イベント発火順序(leave->transition->enter->entered->completed->announce) | E-08 (L209-223) | ○ |
| C-20 | Workflow: eventsToDispatch=[]でイベント無効化 | E-08 (L442-443) | ○ |
| C-21 | Workflow: contextによるイベント無効化 | E-08 (L434) | △ |
| C-22 | Registry: 複数マッチでInvalidArgumentException | E-10 (L55-58) | ○ |
| C-23 | Registry: マッチなしでInvalidArgumentException | E-10 (L51-52) | ○ |
| C-24 | MethodMarkingStore: singleState=falseで非配列はLogicException | E-11 (L71-73) | ○ |
| C-25 | MethodMarkingStore: BackedEnum対応 | E-11 (L66-68) | △ |
| C-26 | MethodMarkingStore: getter/setterなしでLogicException | E-11 (L129) | ○ |
| C-27 | WorkflowValidator: 同一placeから同名transition重複で例外 | E-25 (L35-36) | ○ |
| C-28 | WorkflowValidator: singlePlace=trueで複数出力の例外 | E-25 (L47-49) | ○ |
| C-29 | StateMachineValidator: 入力/出力が1つでない場合例外 | E-26 (L27-39) | ○ |
| C-30 | StateMachineValidator: weight!=1で例外 | E-26 (L31-33, L41-44) | ○ |
| C-31 | MermaidDumper: 無効direction/transitionTypeで例外 | E-29 (L187-189, L194-196) | ○ |
| C-32 | PlantUmlDumper: 無効transitionTypeで例外 | E-30 (L57-58) | ○ |
| C-33 | BuildEventNameTrait: workflowなし+nodeありでLogicException | E-35 (L26-28) | ○ |
| C-34 | WorkflowGuardListenerPass: サービス不足でLogicException | E-39 (L40-42) | ○ |
| C-35 | TraceableWorkflow: callInnerで例外発生時にexception記録 | E-34 (L125-133) | ○ |
| C-36 | TraceableWorkflow: disabled状態での動作 | E-34 (L99-101) | △ |
| C-37 | DataCollector: getCallsCountの動作 | E-41 (L84-89) | △ |
| C-38 | GuardListener: 式がfalseでブロッカー追加 | E-32 (L59-61) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-WKF-117（BackedEnum対応）**: MethodMarkingStoreのBackedEnum処理はソースコードで確認できるが、テストで使用する具体的なBackedEnumサブジェクトの構造は推測に基づく
  - 候補：既存テストのフィクスチャ / Symfonyドキュメント / BackedEnum実装例
- **UT-WKF-038（createUnknown デフォルトメッセージ）**: debug_backtraceの戻り値は実行環境・呼び出し元に依存するため、期待結果の厳密な検証が困難
  - 候補：実行環境でのdebug_backtrace結果 / PHPドキュメント
- **UT-WKF-209（disabled状態のTraceableWorkflow）**: Closureの動作はソースコードで読み取れるが、Stopwatchとの結合動作は実行確認が必要
  - 候補：Stopwatchコンポーネントの仕様 / TraceableWorkflowの既存テスト
- **UT-WKF-091（コンテキストによるイベント無効化）**: DISABLE_EVENTS_MAPPINGによるイベント制御は単体テストよりも結合テスト的な要素がある
  - 候補：Workflowの既存テスト / Symfonyドキュメント
- **UT-WKF-228（DataCollector getCallsCount）**: DataCollectorの動作は複数の外部依存を含む
  - 候補：WorkflowDataCollectorの既存テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Arc, Marking, Transition, TransitionBlocker, TransitionBlockerList, DefinitionBuilder, GuardExpression, EventListenerのテストケースはソースコードから直接的に導出可能
- 0: 低リスク - Definition, Registry, InstanceOfSupportStrategy, InMemoryMetadataStoreのテストケースはソースコードと完全に一致
- 0: 低リスク - Validator系（WorkflowValidator, StateMachineValidator）のテストケースは明確な分岐条件に基づく
- 1: 中リスク - Workflow.applyのイベント発火順序テスト（UT-WKF-088）はEventDispatcherのモック設定が複雑になる可能性
- 1: 中リスク - MethodMarkingStoreのBackedEnum対応テスト（UT-WKF-117）はテストフィクスチャの準備が必要
- 1: 中リスク - Dumper系テスト（UT-WKF-171〜189）は出力文字列の厳密な検証が環境依存となる可能性
- 0: 低リスク - BuildEventNameTraitのテストケースは分岐条件が明確
- 1: 中リスク - GuardListenerのテスト（UT-WKF-192〜195）はExpressionLanguageと Security コンポーネントの依存を含む

## 6) レビュアーチェックリスト（最小）
- [ ] 全229テストケースのテストIDが一意であり、UT-WKF-001からUT-WKF-229まで連番であること
- [ ] 正常系・異常系・境界値のテスト観点が各主要クラスに対して網羅されていること
- [ ] Workflow.apply()のイベント発火順序テスト（UT-WKF-088）のイベント順が正しいこと（leave -> transition -> enter -> entered -> completed -> announce）
- [ ] MethodMarkingStoreのBackedEnum対応テスト（UT-WKF-117）のテストフィクスチャが実現可能であること
- [ ] Validator系テストの分岐網羅が十分であること（特にStateMachineValidatorの入力/出力/重み制約）
- [ ] Dumper系テストの期待結果が具体的かつ検証可能であること
- [ ] DependencyInjection系テストのContainerBuilder モック設定が妥当であること
- [ ] 優先度設定が基準（高：データ整合性/状態遷移、中：バリデーション/外部連携、低：表示処理/ヘルパー）と整合していること
