---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 196
  claims_with_evidence: 190
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：Component-Yaml 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：190 / 196、根拠なし：6
- 優先レビュー（高）
  1. **LintCommand execute系テストケース（UT-YML-186〜195）**：コマンド実行は外部依存（SymfonyStyle, InputInterface等）が多くモック設計の検証が必要
  2. **循環参照検出テスト（UT-YML-048）**：循環参照のYAML入力例の具体的な構造を実際に検証する必要あり
  3. **PCREエラーテスト（UT-YML-063）**：PHPバージョンによるPCREエラーの再現条件が異なる可能性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Yaml/Yaml.php` - Yamlファサードクラス（parseFile, parse, dump静的メソッド、定数定義）
- E-02: `src/Symfony/Component/Yaml/Parser.php` - YAMLパーサー本体（parse, parseFile, doParse, parseBlock, parseBlockScalar, parseValue, getRealCurrentLineNb, preg_match等）
- E-03: `src/Symfony/Component/Yaml/Dumper.php` - YAMLダンパー（__construct, dump, doDump, dumpTaggedValue, getBlockIndentationIndicator）
- E-04: `src/Symfony/Component/Yaml/Inline.php` - インラインYAMLパーサー/ダンパー（initialize, parse, dump, isHash, parseScalar, parseQuotedScalar, parseSequence, parseMapping, evaluateScalar, evaluateBinaryScalar, parseTag等）
- E-05: `src/Symfony/Component/Yaml/Escaper.php` - エスケープ処理（requiresDoubleQuoting, escapeWithDoubleQuotes, requiresSingleQuoting, escapeWithSingleQuotes）
- E-06: `src/Symfony/Component/Yaml/Unescaper.php` - アンエスケープ処理（unescapeSingleQuotedString, unescapeDoubleQuotedString, unescapeCharacter, utf8chr）
- E-07: `src/Symfony/Component/Yaml/Tag/TaggedValue.php` - タグ付き値クラス（__construct, getTag, getValue）
- E-08: `src/Symfony/Component/Yaml/Exception/ParseException.php` - パース例外クラス（__construct, getSnippet, setSnippet, getParsedFile, setParsedFile, getParsedLine, setParsedLine, updateRepr）
- E-09: `src/Symfony/Component/Yaml/Exception/DumpException.php` - ダンプ例外クラス
- E-10: `src/Symfony/Component/Yaml/Exception/RuntimeException.php` - ランタイム例外基底クラス
- E-11: `src/Symfony/Component/Yaml/Exception/ExceptionInterface.php` - 例外インターフェース
- E-12: `src/Symfony/Component/Yaml/Command/LintCommand.php` - YAMLリントコマンド（__construct, configure, execute, validate, display, displayTxt, displayJson, getFiles, complete等）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-YML-001〜006: Yaml::parse静的メソッドの正常系・異常系・境界値テスト | E-01 (Yaml.php L76-81) | ○ |
| C-02 | UT-YML-007〜008: Yaml::parseFile静的メソッドの正常系・異常系テスト | E-01 (Yaml.php L55-60) | ○ |
| C-03 | UT-YML-009〜012: Yaml::dump静的メソッドの正常系テスト（各パラメータ） | E-01 (Yaml.php L94-99) | ○ |
| C-04 | UT-YML-013〜041: Parser::parseの各種YAML構文パーステスト | E-02 (Parser.php L77-510) | ○ |
| C-05 | UT-YML-042: タブインデント禁止のテスト | E-02 (Parser.php L137-138) | ○ |
| C-06 | UT-YML-043: 無効UTF-8検出テスト | E-02 (Parser.php L79-81) | ○ |
| C-07 | UT-YML-044: 重複キー検出テスト | E-02 (Parser.php L303-314, L348-355) | ○ |
| C-08 | UT-YML-045〜046: コンテキスト不整合エラーテスト | E-02 (Parser.php L145-147, L203-205) | ○ |
| C-09 | UT-YML-047: 存在しない参照エラーテスト | E-02 (Parser.php L719-724) | ○ |
| C-10 | UT-YML-048: 循環参照検出テスト | E-02 (Parser.php L720-722, L232-234) | ○ |
| C-11 | UT-YML-049: 複数ドキュメント非対応テスト | E-02 (Parser.php L418-419) | ○ |
| C-12 | UT-YML-050: 複雑なマッピング非対応テスト | E-02 (Parser.php L422-423) | ○ |
| C-13 | UT-YML-051: インデント問題検出テスト | E-02 (Parser.php L605, L661) | ○ |
| C-14 | UT-YML-052〜053: カスタムタグ無効時・未実装ビルトインタグエラーテスト | E-02 (Parser.php L1098-1107) | ○ |
| C-15 | UT-YML-054〜057: パーサー境界値テスト（空入力、空行、コメントのみ、CRLF正規化） | E-02 (Parser.php L102-114, L988-991) | ○ |
| C-16 | UT-YML-058〜060: Parser::parseFileの正常系・異常系テスト | E-02 (Parser.php L50-67) | ○ |
| C-17 | UT-YML-061: getRealCurrentLineNbの行番号計算テスト | E-02 (Parser.php L539-552) | ○ |
| C-18 | UT-YML-062〜064: Parser::preg_matchの正常系・異常系テスト | E-02 (Parser.php L1061-1068) | ○ |
| C-19 | UT-YML-065〜069: Dumper::__constructの正常系・異常系・境界値テスト | E-03 (Dumper.php L28-33) | ○ |
| C-20 | UT-YML-070〜085: Dumper::dumpの各フラグ・パラメータテスト | E-03 (Dumper.php L43-145) | ○ |
| C-21 | UT-YML-077: DUMP_NULL_AS_EMPTYとDUMP_NULL_AS_TILDEの排他制御テスト | E-03 (Dumper.php L45-47) | ○ |
| C-22 | UT-YML-086: Inline::initializeの初期化テスト | E-04 (Inline.php L37-48) | ○ |
| C-23 | UT-YML-087〜094: Inline::parseの各種パーステスト | E-04 (Inline.php L58-93) | ○ |
| C-24 | UT-YML-095〜116: Inline::dumpの各種ダンプテスト | E-04 (Inline.php L103-194) | ○ |
| C-25 | UT-YML-117〜122: Inline::isHashの判定テスト | E-04 (Inline.php L199-214) | ○ |
| C-26 | UT-YML-123〜128: Inline::parseScalarの各種スカラーパーステスト | E-04 (Inline.php L276-323) | ○ |
| C-27 | UT-YML-129〜131: Inline::evaluateBinaryScalarのテスト | E-04 (Inline.php L808-821) | ○ |
| C-28 | UT-YML-132〜140: Escaper::requiresDoubleQuoting及びescapeWithDoubleQuotesのテスト | E-05 (Escaper.php L55-68) | ○ |
| C-29 | UT-YML-141〜150: Escaper::requiresSingleQuoting及びescapeWithSingleQuotesのテスト | E-05 (Escaper.php L75-96) | ○ |
| C-30 | UT-YML-151〜168: Unescaper::unescapeSingleQuotedString及びunescapeDoubleQuotedStringのテスト | E-06 (Unescaper.php L36-108) | ○ |
| C-31 | UT-YML-169〜173: TaggedValueのコンストラクタ・getter系テスト | E-07 (TaggedValue.php L18-35) | ○ |
| C-32 | UT-YML-174〜183: ParseExceptionのコンストラクタ・getter/setter系テスト | E-08 (ParseException.php L19-121) | ○ |
| C-33 | UT-YML-184〜185: LintCommand::__constructのテスト | E-12 (LintCommand.php L45-51) | ○ |
| C-34 | UT-YML-186〜192: LintCommand::executeの各種正常系テスト | E-12 (LintCommand.php L89-128) | △ |
| C-35 | UT-YML-193〜195: LintCommand::executeの各種異常系テスト | E-12 (LintCommand.php L110-117, L157) | △ |
| C-36 | UT-YML-196: LintCommand::completeの補完テスト | E-12 (LintCommand.php L265-270) | ○ |
| C-37 | テストケースのファイルパスが正しいこと | E-01〜E-12全ファイル | ○ |
| C-38 | テスト観点（正常系・異常系・境界値）の網羅性 | E-01〜E-12全ファイル | ○ |
| C-39 | LintCommandのvalidateメソッド内部のPARSE_CONSTANTフラグ使用 | E-12 (LintCommand.php L141) | △ |
| C-40 | LintCommandのGitHub Actionsフォーマット自動検出 | E-12 (LintCommand.php L97-99) | △ |
| C-41 | Dumper::dumpTaggedValueのリテラルブロック処理 | E-03 (Dumper.php L147-167) | ○ |
| C-42 | Dumper::getBlockIndentationIndicatorの先頭スペース検出 | E-03 (Dumper.php L169-183) | ○ |
| C-43 | Inline::parseTagのビルトインタグ処理 | E-04 (Inline.php L768-806) | ○ |
| C-44 | Inline::evaluateScalarのPHP定数・Enum処理 | E-04 (Inline.php L573-766) | ○ |

## 4) 不足情報（Unknown / Missing）
- LintCommandのexecute系テスト（C-34, C-35）は、Symfonyコンソールコンポーネントのモック生成が必要であり、実際のテスト実装では追加の前提条件設定が必要になる。具体的なモック構成はコードからは推測できるが、実行時の振る舞いは実際にテストして確認する必要がある。
  - 候補：Symfony Console Testerコンポーネントのドキュメント / CommandTesterクラスの利用 / 実際のテスト実行結果
- LintCommand内部のvalidateメソッド（C-39）はPARSE_CONSTANTフラグを常に使用しているが、これが意図的な設計判断かどうかは外部仕様からは確認できない。
  - 候補：Symfony公式ドキュメント / CHANGELOG / プルリクエスト履歴
- GitHub Actionsフォーマット自動検出（C-40）はGithubActionReporterクラスの存在に依存しており、テスト環境でのCI検出のモック方法は実装依存。
  - 候補：GithubActionReporterクラスのテスト / 環境変数設定のモック

## 5) リスクフラグ（レビュー観点）
- 0: Parser, Dumper, Inline, Escaper, Unescaper, TaggedValue, ParseExceptionのテストケース - ソースコードから直接導出可能で信頼性が高い
- 1: LintCommandのexecute系テスト - 外部依存が多くテスト実装時に追加考慮が必要
- 0: Yaml静的ファサードのテスト - 内部的にParser/Dumperに委譲しており単純

## 6) レビュアーチェックリスト（最小）
- [ ] 全対象ファイル（12ファイル）のpublicメソッドがテストケースでカバーされているか
- [ ] 各クラスの正常系・異常系・境界値が網羅されているか
- [ ] Yamlクラスの定数フラグ（DUMP_*, PARSE_*）に対応するテストが存在するか
- [ ] ParseExceptionの各setter/getterがテストされているか
- [ ] LintCommandのテストケースが実際にテスト可能な前提条件を含んでいるか
- [ ] テストID（UT-YML-001〜196）に欠番がないか
- [ ] 優先度（高・中・低）の割り当てが基準に沿っているか（金額計算=高、表示処理=低等）
- [ ] Inline::dumpのswitch文の全分岐がカバーされているか
- [ ] Unescaper::unescapeCharacterのmatch文の全分岐がカバーされているか
