---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 60
  claims_with_evidence: 49
  claims_without_evidence: 11
confidence_derived: 0.82
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.82**
  - 根拠あり：49 / 60、根拠なし：11
- 優先レビュー（高）
  1. **UAT-028（パスワードハッシュ化）**：PasswordHasherInterfaceは存在するが、アプリケーション固有のユーザー登録フローの根拠なし
  2. **UAT-043〜044（メッセージング）**：Messengerコンポーネントは存在するが、アプリケーション固有のメッセージハンドラの根拠なし
  3. **UAT-045〜046（メール/通知）**：Mailer/Notifierコンポーネントは存在するが、アプリケーション固有の通知設定の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Security/Http/Authenticator/FormLoginAuthenticator.php`
- E-02: `src/Symfony/Component/Security/Http/Authenticator/JsonLoginAuthenticator.php`
- E-03: `src/Symfony/Component/Security/Http/Authenticator/HttpBasicAuthenticator.php`
- E-04: `src/Symfony/Component/Security/Http/Authenticator/AccessTokenAuthenticator.php`
- E-05: `src/Symfony/Component/Security/Http/Authenticator/RememberMeAuthenticator.php`
- E-06: `src/Symfony/Component/Security/Http/Firewall/LogoutListener.php`
- E-07: `src/Symfony/Component/Security/Http/EventListener/LoginThrottlingListener.php`
- E-08: `src/Symfony/Component/Security/Http/Firewall/AccessListener.php`
- E-09: `src/Symfony/Component/Security/Http/EventListener/IsGrantedAttributeListener.php`
- E-10: `src/Symfony/Component/Security/Http/Attribute/IsGranted.php`
- E-11: `src/Symfony/Component/Security/Http/Firewall/SwitchUserListener.php`
- E-12: `src/Symfony/Component/Security/Http/Firewall.php`
- E-13: `src/Symfony/Component/Security/Core/Authorization/Voter/RoleHierarchyVoter.php`
- E-14: `src/Symfony/Component/Security/Core/Authorization/Voter/AuthenticatedVoter.php`
- E-15: `src/Symfony/Component/Security/Csrf/CsrfTokenManager.php`
- E-16: `src/Symfony/Component/Security/Csrf/SameOriginCsrfListener.php`
- E-17: `src/Symfony/Component/Security/Http/EventListener/CsrfProtectionListener.php`
- E-18: `src/Symfony/Component/Security/Http/EventListener/SessionStrategyListener.php`
- E-19: `src/Symfony/Component/Security/Http/Firewall/ContextListener.php`
- E-20: `src/Symfony/Component/Routing/Attribute/Route.php`
- E-21: `src/Symfony/Component/Routing/Router.php`
- E-22: `src/Symfony/Component/HttpKernel/EventListener/ErrorListener.php`
- E-23: `src/Symfony/Component/HttpKernel/Controller/ErrorController.php`
- E-24: `src/Symfony/Component/HttpKernel/EventListener/CacheAttributeListener.php`
- E-25: `src/Symfony/Component/Validator/Constraints/` (ディレクトリ)
- E-26: `src/Symfony/Component/Form/Extension/Core/Type/` (ディレクトリ)
- E-27: `src/Symfony/Component/PasswordHasher/PasswordHasherInterface.php`
- E-28: `src/Symfony/Component/Security/Core/User/PasswordUpgraderInterface.php`
- E-29: `src/Symfony/Component/Messenger/MessageBus.php`
- E-30: `src/Symfony/Component/Mailer/Mailer.php`
- E-31: `src/Symfony/Component/Notifier/Notifier.php`
- E-32: `src/Symfony/Component/HttpFoundation/Session/Session.php`
- E-33: `src/Symfony/Component/Translation/` (ディレクトリ)
- E-34: `src/Symfony/Component/RateLimiter/` (ディレクトリ)
- E-35: `src/Symfony/Bundle/WebProfilerBundle/` (ディレクトリ)
- E-36: `src/Symfony/Bundle/FrameworkBundle/Command/CacheClearCommand.php`
- E-37: `src/Symfony/Component/AssetMapper/` (ディレクトリ)
- E-38: `src/Symfony/Component/Security/Http/LoginLink/LoginLinkHandler.php`
- E-39: `src/Symfony/Component/Security/Http/Authenticator/LoginLinkAuthenticator.php`
- E-40: `src/Symfony/Component/Scheduler/Scheduler.php`
- E-41: `src/Symfony/Component/Security/Http/EventListener/CheckCredentialsListener.php`
- E-42: `src/Symfony/Component/Security/Http/Authenticator/Passport/Badge/PasswordUpgradeBadge.php`
- E-43: `src/Symfony/Component/Security/Http/Authenticator/Passport/Badge/CsrfTokenBadge.php`
- E-44: `src/Symfony/Component/Security/Http/Authenticator/Passport/Badge/RememberMeBadge.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001: フォームログインで正常認証 | E-01 | ○ |
| C-02 | UAT-002: 不正パスワードで認証拒否 | E-01, E-41 | ○ |
| C-03 | UAT-003: 空ユーザー名で認証拒否 | E-01 | ○ |
| C-04 | UAT-004: 空パスワードで認証拒否 | E-01 | ○ |
| C-05 | UAT-005: CSRF保護有効時のトークンなし拒否 | E-01, E-43 | ○ |
| C-06 | UAT-006: JSONログイン正常認証 | E-02 | ○ |
| C-07 | UAT-007: 不正JSON形式拒否 | E-02 | ○ |
| C-08 | UAT-008: JSONにusernameキーなしエラー | E-02 | ○ |
| C-09 | UAT-009: HTTP Basic正常認証 | E-03 | ○ |
| C-10 | UAT-010: HTTP Basic認証なし401 | E-03 | ○ |
| C-11 | UAT-011: アクセストークン正常認証 | E-04 | ○ |
| C-12 | UAT-012: 無効トークン401 | E-04 | ○ |
| C-13 | UAT-013: トークンなしスキップ | E-04 | ○ |
| C-14 | UAT-014: RememberMe自動再認証 | E-05, E-44 | ○ |
| C-15 | UAT-015: 無効RememberMeクッキー拒否 | E-05 | ○ |
| C-16 | UAT-016: 正常ログアウト | E-06 | ○ |
| C-17 | UAT-017: ログアウトCSRF保護 | E-06 | ○ |
| C-18 | UAT-018: ログインスロットリング制限 | E-07 | ○ |
| C-19 | UAT-019: スロットリングカウンタリセット | E-07 | ○ |
| C-20 | UAT-020: ROLE_ADMINアクセス許可 | E-08 | ○ |
| C-21 | UAT-021: ROLE_USERアクセス拒否 | E-08 | ○ |
| C-22 | UAT-022: IsGranted権限あり許可 | E-09, E-10 | ○ |
| C-23 | UAT-023: IsGranted権限なし拒否 | E-09, E-10 | ○ |
| C-24 | UAT-024: IsGranted HTTPメソッド制限 | E-09, E-10 | ○ |
| C-25 | UAT-025: ユーザー切り替え | E-11 | ○ |
| C-26 | UAT-026: なりすまし解除 | E-11 | ○ |
| C-27 | UAT-027: 切り替え権限不足拒否 | E-11 | ○ |
| C-28 | UAT-028: パスワードハッシュ化保存 | E-27 | △ |
| C-29 | UAT-029: パスワードハッシュアップグレード | E-01, E-28, E-42 | ○ |
| C-30 | UAT-030: 複数Firewall適用 | E-12 | ○ |
| C-31 | UAT-031: セッション管理 | E-19, E-32 | ○ |
| C-32 | UAT-032: セッション固定攻撃防止 | E-18 | ○ |
| C-33 | UAT-033: 必須フィールドバリデーション | E-25 | ○ |
| C-34 | UAT-034: メールバリデーション | E-25 | ○ |
| C-35 | UAT-035: フォームCSRF保護 | E-15, E-17 | ○ |
| C-36 | UAT-036: SameOrigin CSRF | E-16 | ○ |
| C-37 | UAT-037: ルーティング正常マッチ | E-20, E-21 | ○ |
| C-38 | UAT-038: ルーティングHTTPメソッド制限 | E-20 | ○ |
| C-39 | UAT-039: ルートパラメータ検証 | E-20 | ○ |
| C-40 | UAT-040: 404エラーハンドリング | E-22, E-23 | ○ |
| C-41 | UAT-041: 500エラーハンドリング | E-22, E-23 | ○ |
| C-42 | UAT-042: HTTPキャッシュヘッダー | E-24 | ○ |
| C-43 | UAT-043: メッセージング非同期処理 | E-29 | △ |
| C-44 | UAT-044: メッセージングリトライ | **根拠なし** | △ |
| C-45 | UAT-045: メール送信 | E-30 | △ |
| C-46 | UAT-046: 通知機能 | E-31 | △ |
| C-47 | UAT-047: フラッシュメッセージ | E-32 | △ |
| C-48 | UAT-048: 多言語対応 | E-33 | △ |
| C-49 | UAT-049: ファイルアップロード | E-26 | △ |
| C-50 | UAT-050: ファイルアップロードバリデーション | E-25 | △ |
| C-51 | UAT-051: レートリミッティング | E-34 | ○ |
| C-52 | UAT-052: WebProfiler開発環境 | E-35 | ○ |
| C-53 | UAT-053: WebProfiler本番環境無効化 | E-35 | △ |
| C-54 | UAT-054: キャッシュクリア | E-36 | ○ |
| C-55 | UAT-055: アセット管理 | E-37 | ○ |
| C-56 | UAT-056: ログインリンク認証 | E-38, E-39 | ○ |
| C-57 | UAT-057: ログインリンク期限切れ | E-38 | ○ |
| C-58 | UAT-058: スケジューラー | E-40 | △ |
| C-59 | UAT-059: 公開アクセス | E-08, E-14 | ○ |
| C-60 | UAT-060: ロール階層 | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- **アプリケーション固有の設定ファイル（security.yaml等）が存在しない**: 本プロジェクトはSymfonyフレームワーク本体であり、アプリケーション固有のセキュリティ設定、ルーティング設定、フォーム定義等は含まれていない。テストケースはフレームワークが提供する機能をベースに作成している。
  - 候補：security.yaml / routes.yaml / services.yaml
- **メッセージングのリトライ設定ファイルが不明**: Messenger Retryコンポーネントは存在するが、具体的なリトライポリシー設定の根拠が不足している。
  - 候補：messenger.yaml / framework.yaml
- **アプリケーション固有の画面テンプレート（Twig）が存在しない**: フレームワークにはテンプレートエンジンは含まれるが、具体的なアプリケーション画面は定義されていない。テストケースの「対象画面」は想定される一般的な画面名称を使用している。
  - 候補：templates/ ディレクトリ内の.twigファイル

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - 本プロジェクトはSymfonyフレームワーク本体のため、アプリケーション固有の業務フローに基づくテストケースの妥当性はアプリケーション側で再確認が必要
- **0: 低リスク** - セキュリティ認証・認可関連のテストケース（UAT-001〜027）はソースコードと直接対応しており、高い信頼性がある
- **1: 中リスク** - メッセージング・メール・通知関連のテストケース（UAT-043〜046）はコンポーネントの存在は確認できるが、具体的な設定・使用パターンの根拠が不足している
- **1: 中リスク** - フォームバリデーション・ファイルアップロード関連テストケース（UAT-033〜034, UAT-049〜050）はバリデーション制約クラスの存在に基づくが、アプリケーション固有のフォーム定義の根拠がない

## 6) レビュアーチェックリスト（最小）
- [ ] 認証シナリオ（UAT-001〜015）がアプリケーションで使用している認証方式と一致しているか確認
- [ ] アクセス制御シナリオ（UAT-020〜027）がアプリケーションのロール設計と一致しているか確認
- [ ] フォームバリデーション（UAT-033〜034）がアプリケーション固有のフォーム要件を網羅しているか確認
- [ ] メッセージング・メール・通知テストケース（UAT-043〜046）がアプリケーションの実際の非同期処理要件と一致しているか確認
- [ ] 「対象画面」列に記載されている画面名がアプリケーション実装と一致しているか確認
- [ ] テストケースの優先度が業務要件に照らして適切か確認
- [ ] 不足しているE2Eシナリオ（複数画面をまたぐ業務フロー）がないか確認
