---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 34
  claims_with_evidence: 34
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：34 / 34、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全項目がソースコードから直接確認済み
  2. **カテゴリ分類の妥当性**：Symfonyフレームワークのコアライブラリであるため、「帳票」の定義を「データ出力・ダンプ・レンダリング機能」として広義に解釈している点はレビュー推奨
  3. **網羅性**：フレームワーク内のConsole Descriptor系（Text/JSON/XML/Markdown/ReStructuredText出力）は帳票一覧に含めていない。これらを含めるかはプロジェクト方針次第

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Translation/Dumper/XliffFileDumper.php`
- E-02: `src/Symfony/Component/Translation/Dumper/CsvFileDumper.php`
- E-03: `src/Symfony/Component/Translation/Dumper/PoFileDumper.php`
- E-04: `src/Symfony/Component/Translation/Dumper/MoFileDumper.php`
- E-05: `src/Symfony/Component/Translation/Dumper/YamlFileDumper.php`
- E-06: `src/Symfony/Component/Translation/Dumper/JsonFileDumper.php`
- E-07: `src/Symfony/Component/Translation/Dumper/PhpFileDumper.php`
- E-08: `src/Symfony/Component/Translation/Dumper/IniFileDumper.php`
- E-09: `src/Symfony/Component/Translation/Dumper/IcuResFileDumper.php`
- E-10: `src/Symfony/Component/Translation/Dumper/QtFileDumper.php`
- E-11: `src/Symfony/Component/Translation/Dumper/FileDumper.php`
- E-12: `src/Symfony/Component/DependencyInjection/Dumper/PhpDumper.php`
- E-13: `src/Symfony/Component/DependencyInjection/Dumper/XmlDumper.php`
- E-14: `src/Symfony/Component/DependencyInjection/Dumper/YamlDumper.php`
- E-15: `src/Symfony/Component/DependencyInjection/Dumper/GraphvizDumper.php`
- E-16: `src/Symfony/Component/Workflow/Dumper/GraphvizDumper.php`
- E-17: `src/Symfony/Component/Workflow/Dumper/StateMachineGraphvizDumper.php`
- E-18: `src/Symfony/Component/Workflow/Dumper/MermaidDumper.php`
- E-19: `src/Symfony/Component/Workflow/Dumper/PlantUmlDumper.php`
- E-20: `src/Symfony/Component/Security/Core/Dumper/MermaidDumper.php`
- E-21: `src/Symfony/Component/Config/Definition/Dumper/YamlReferenceDumper.php`
- E-22: `src/Symfony/Component/Config/Definition/Dumper/XmlReferenceDumper.php`
- E-23: `src/Symfony/Component/VarDumper/Dumper/HtmlDumper.php`
- E-24: `src/Symfony/Component/VarDumper/Dumper/CliDumper.php`
- E-25: `src/Symfony/Component/ErrorHandler/ErrorRenderer/HtmlErrorRenderer.php`
- E-26: `src/Symfony/Component/ErrorHandler/ErrorRenderer/CliErrorRenderer.php`
- E-27: `src/Symfony/Component/ErrorHandler/ErrorRenderer/SerializerErrorRenderer.php`
- E-28: `src/Symfony/Component/HttpFoundation/BinaryFileResponse.php`
- E-29: `src/Symfony/Component/HttpFoundation/StreamedJsonResponse.php`
- E-30: `src/Symfony/Component/Routing/Matcher/Dumper/CompiledUrlMatcherDumper.php`
- E-31: `src/Symfony/Component/Routing/Generator/Dumper/CompiledUrlGeneratorDumper.php`
- E-32: `src/Symfony/Component/Intl/Data/Bundle/Writer/JsonBundleWriter.php`
- E-33: `src/Symfony/Component/Intl/Data/Bundle/Writer/PhpBundleWriter.php`
- E-34: `src/Symfony/Component/Intl/Data/Bundle/Writer/TextBundleWriter.php`
- E-35: `src/Symfony/Component/JsonStreamer/JsonStreamWriter.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XLIFF翻訳ファイル：XLIFF 1.2/2.0形式でメッセージカタログを出力 | E-01 | ○ |
| C-02 | CSV翻訳ファイル：セミコロン区切りCSV形式でメッセージカタログを出力 | E-02 | ○ |
| C-03 | PO翻訳ファイル：Gettext PO形式でメッセージカタログを出力 | E-03 | ○ |
| C-04 | MO翻訳ファイル：Gettext MOバイナリ形式でメッセージカタログを出力 | E-04 | ○ |
| C-05 | YAML翻訳ファイル：YAML形式でメッセージカタログを出力 | E-05 | ○ |
| C-06 | JSON翻訳ファイル：JSON形式でメッセージカタログを出力 | E-06 | ○ |
| C-07 | PHP翻訳ファイル：PHP配列形式でメッセージカタログを出力 | E-07 | ○ |
| C-08 | INI翻訳ファイル：INI形式でメッセージカタログを出力 | E-08 | ○ |
| C-09 | ICU ResourceBundle翻訳ファイル：ICU ResBundle形式で出力 | E-09 | ○ |
| C-10 | Qt TS翻訳ファイル：Qt Linguist TS XML形式で出力 | E-10 | ○ |
| C-11 | PHP DIコンテナダンプ：コンパイル済みPHPクラスとして出力 | E-12 | ○ |
| C-12 | XML DIコンテナダンプ：サービス定義をXML形式で出力 | E-13 | ○ |
| C-13 | YAML DIコンテナダンプ：サービス定義をYAML形式で出力 | E-14 | ○ |
| C-14 | Graphviz DIコンテナダンプ：サービス依存関係をDOT形式で出力 | E-15 | ○ |
| C-15 | Graphvizワークフロー図：ワークフロー定義をDOT形式で出力 | E-16 | ○ |
| C-16 | StateMachine Graphviz図：ステートマシン型ワークフローをDOT形式で出力 | E-17 | ○ |
| C-17 | Mermaidワークフロー図：ワークフロー定義をMermaid記法で出力 | E-18 | ○ |
| C-18 | PlantUMLワークフロー図：ワークフロー定義をPlantUML形式で出力 | E-19 | ○ |
| C-19 | Mermaidロール階層図：ロール階層をMermaidフローチャート形式で出力 | E-20 | ○ |
| C-20 | YAML設定リファレンス：設定定義からYAMLリファレンスを出力 | E-21 | ○ |
| C-21 | XML設定リファレンス：設定定義からXMLリファレンスを出力 | E-22 | ○ |
| C-22 | HTML変数ダンプ：変数情報をHTML形式で出力 | E-23 | ○ |
| C-23 | CLI変数ダンプ：変数情報をANSIカラー付きCLI出力 | E-24 | ○ |
| C-24 | HTMLエラーページ：例外情報をHTMLエラーページとして出力 | E-25 | ○ |
| C-25 | CLIエラー出力：例外情報をCLI向けテキスト形式で出力 | E-26 | ○ |
| C-26 | Serializerエラー出力：例外情報をSerializer経由でJSON/XML等で出力 | E-27 | ○ |
| C-27 | バイナリファイルレスポンス：ファイルをHTTPレスポンスとして配信 | E-28 | ○ |
| C-28 | ストリーミングJSONレスポンス：大量データをJSONストリーミングで出力 | E-29 | ○ |
| C-29 | コンパイル済みURLマッチャーダンプ：ルーティング定義をPHP配列として出力 | E-30 | ○ |
| C-30 | コンパイル済みURLジェネレーターダンプ：ルーティング定義をPHP配列として出力 | E-31 | ○ |
| C-31 | JSON国際化バンドル：ICU国際化データをJSON形式で出力 | E-32 | ○ |
| C-32 | PHP国際化バンドル：ICU国際化データをPHP配列形式で出力 | E-33 | ○ |
| C-33 | テキスト国際化バンドル：ICU国際化データをテキスト形式で出力 | E-34 | ○ |
| C-34 | JSONストリームライター：オブジェクトをJSON形式でストリーミング出力 | E-35 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全項目がソースコードから直接確認済みのため、根拠なしの項目は存在しない
- ただし以下の点について補足情報が不足している：
  - Console Descriptor系（Text/JSON/XML/Markdown/ReStructuredText形式でのコンソール出力）は帳票一覧に含めていない
    - 候補: `src/Symfony/Component/Console/Descriptor/` / `src/Symfony/Bundle/FrameworkBundle/Console/Descriptor/` / `src/Symfony/Component/Form/Console/Descriptor/`
  - Twig ErrorRenderer（`src/Symfony/Bridge/Twig/ErrorRenderer/TwigErrorRenderer.php`）はHtmlErrorRendererのTwigラッパーのため個別項目としていない
  - VarExporter（`src/Symfony/Component/VarExporter/VarExporter.php`）はPHP変数のエクスポート機能だが、帳票というよりシリアライズユーティリティのため除外

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目がソースコードの実在するクラスに基づいており、クラス名・名前空間・説明はコードと整合している
- 1: 中リスク - 「帳票」の定義範囲について。本プロジェクトはSymfonyフレームワークのコアライブラリであり、業務帳票（PDF/Excel等）は存在しない。Dumper/Writer/Renderer等のデータ出力機能を「帳票」として広義に解釈しているため、プロジェクトの帳票定義方針との整合性確認が必要
- 0: 低リスク - CSV形式・エンコーディング（BOM付きUTF-8）は仕様通りに出力されている

## 6) レビュアーチェックリスト（最小）
- [ ] 「帳票」の定義範囲がプロジェクト方針と合致しているか確認（フレームワークのDumper/Writer/Rendererを帳票として扱う妥当性）
- [ ] Console Descriptor系の出力機能を帳票一覧に含めるべきか検討
- [ ] 各帳票のカテゴリ分類が適切か確認
- [ ] 出力クラスのFQCN（完全修飾クラス名）がソースコードと一致しているか確認
- [ ] Twig系のテンプレートレンダリング（BodyRenderer, NotificationEmail等）を帳票に含めるべきか検討
