# 帳票設計書 12-XML DIコンテナダンプ

## 概要

本ドキュメントは、Symfony DependencyInjectionコンポーネントにおけるXML DIコンテナダンプ機能（`XmlDumper`）の設計仕様を定義する。DIコンテナのサービス定義をXML形式で出力する。

### 本帳票の処理概要

XmlDumperは、Symfonyの依存性注入（DI）コンテナに登録されたサービス定義、パラメータ、エイリアスなどの情報をXML形式の文字列として出力する。

**業務上の目的・背景**：DIコンテナの構成をXML形式でエクスポートすることで、サービス定義の可読性を高め、他のツールやシステムとの相互運用性を確保する。XMLはSymfonyが標準的にサポートするサービス定義形式の一つであり、XSDスキーマによるバリデーションが可能なため、設定の正当性を機械的に検証できる。

**帳票の利用シーン**：コンテナのデバッグ時、サービス定義のエクスポート時、設定の確認・比較時に使用される。`debug:container --format=xml`コマンドの内部処理としても利用される。

**主要な出力内容**：
1. XMLヘッダーおよびSymfonyサービスコンテナXMLスキーマ宣言
2. パラメータ定義セクション（`<parameters>`要素）
3. サービス定義セクション（`<services>`要素）
4. エイリアス定義

**帳票の出力タイミング**：開発者がCLIコマンドで明示的に実行した場合、またはプログラム内でXmlDumperを直接呼び出した場合。

**帳票の利用者**：アプリケーション開発者、フレームワーク設定の管理者。

## 帳票種別

XML形式テキスト出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `bin/console debug:container --format=xml` | コマンド実行 |
| N/A | プログラム呼び出し | API呼び出し | XmlDumper::dump() |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | XML |
| 用紙サイズ | N/A（テキストデータ） |
| 向き | N/A |
| ファイル名 | 任意（呼び出し側で指定） |
| 出力方法 | 文字列として返却（ファイル保存は呼び出し側の責務） |
| 文字コード | UTF-8 |

### XML固有設定

| 項目 | 内容 |
|-----|------|
| XMLバージョン | 1.0 |
| スキーマ | `http://symfony.com/schema/dic/services/services-1.0.xsd` |
| 名前空間 | `http://symfony.com/schema/dic/services` |
| XSI名前空間 | `http://www.w3.org/2001/XMLSchema-instance` |

## 帳票レイアウト

### レイアウト概要

XML文書構造として、ルート要素`<container>`の配下にパラメータとサービスが配置される。

```
┌─────────────────────────────────────┐
│  <?xml version="1.0" encoding="utf-8"?>  │
│  <container ...>                    │
├─────────────────────────────────────┤
│    <parameters>                     │
│      <parameter key="...">...</parameter> │
│    </parameters>                    │
├─────────────────────────────────────┤
│    <services>                       │
│      <service id="..." class="..."> │
│        <tag .../>                   │
│        <argument .../>              │
│        <call method="..."/>         │
│      </service>                     │
│    </services>                      │
├─────────────────────────────────────┤
│  </container>                       │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | XML宣言 | XMLバージョンとエンコーディング | 固定値 | `<?xml version="1.0" encoding="utf-8"?>` |
| 2 | container要素 | ルート要素 | 固定値 | `<container xmlns="..." ...>` |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | parameter | パラメータ定義 | ParameterBag.all() | `<parameter>` 要素 | N/A |
| 2 | service | サービス定義 | ContainerBuilder.getDefinitions() | `<service>` 要素 | N/A |
| 3 | tag | サービスタグ | Definition.getTags() | `<tag>` 要素 | N/A |
| 4 | argument | コンストラクタ引数 | Definition.getArguments() | `<argument>` 要素 | N/A |
| 5 | call | メソッドコール | Definition.getMethodCalls() | `<call>` 要素 | N/A |
| 6 | factory | ファクトリ定義 | Definition.getFactory() | `<factory>` 要素 | N/A |
| 7 | alias | エイリアス定義 | ContainerBuilder.getAliases() | `<service alias="...">` | N/A |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | container閉じ | ルート要素の閉じタグ | 固定値 | `</container>` |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ContainerBuilderインスタンス | コンストラクタで渡されたコンテナ | Yes |
| optionsパラメータ | dump()メソッドのオプション配列 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | パラメータ | 登録順 |
| 2 | サービス定義 | 登録順 |
| 3 | エイリアス | 登録順 |

### 改ページ条件

N/A（テキスト出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを直接参照しない。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | N/A | N/A |

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| phpToXml変換 | null→"null", true→"true", false→"false", UnitEnum→"Class::Name" | N/A | PHP値をXML文字列に変換（行430-442） |
| HTMLエンコード | `htmlspecialchars($value, ENT_XML1 \| ENT_SUBSTITUTE \| $flags, 'UTF-8')` | N/A | XML安全なエスケープ（行406-409） |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[dump呼び出し] --> B[XMLヘッダー生成]
    B --> C[addParameters]
    C --> D{パラメータあり?}
    D -->|Yes| E[parameters要素生成]
    D -->|No| F[スキップ]
    E --> G[addServices]
    F --> G
    G --> H{サービス定義あり?}
    H -->|Yes| I[各サービスを変換]
    H -->|No| J[スキップ]
    I --> K[エイリアス追加]
    K --> L[container閉じタグ]
    J --> L
    L --> M[環境変数プレースホルダ解決]
    M --> N[XML文字列返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| RuntimeException | パラメータにオブジェクトまたはリソースが含まれる | "Unable to dump a service container if a parameter is an object or a resource" | パラメータからオブジェクトやリソースを除去する |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千サービス定義 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | 制限なし（ステートレスな処理） |

## セキュリティ考慮事項

- XMLインジェクション対策として、全ての値は`htmlspecialchars()`でエスケープされる（行406-409）
- パラメータ値がXMLに含まれるため、機密情報の取り扱いに注意が必要
- 環境変数プレースホルダは出力時に解決される

## 備考

- XmlDumperの出力はSymfonyのXMLローダーで再読み込み可能な形式
- `%`文字はコンパイル済みコンテナの場合`%%`にエスケープされる（行411-423）
- サービスのtype属性はservice, collection, iterator, service_locator, service_closure, expression, binary, constant, abstract, string等をサポート

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

XmlDumperが入力として受け取るContainerBuilderのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Dumper.php | `src/Symfony/Component/DependencyInjection/Dumper/Dumper.php` | 基底クラス。ContainerBuilderをprotectedプロパティとして保持（行23-26） |
| 1-2 | Definition.php | `src/Symfony/Component/DependencyInjection/Definition.php` | サービス定義。getClass(), getArguments(), getTags(), getFactory()等 |

**読解のコツ**: DefinitionクラスのgetterメソッドがそれぞれどのようにXML要素にマッピングされるかを対照する。

#### Step 2: エントリーポイントを理解する

XmlDumperのdump()メソッドが処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | XmlDumper.php | `src/Symfony/Component/DependencyInjection/Dumper/XmlDumper.php` | dump()メソッド（行39-56）がエントリーポイント |

**主要処理フロー**:
1. **行41-44**: XMLヘッダーおよびcontainerルート要素の生成
2. **行46-48**: addParameters()でパラメータセクション追加
3. **行49-51**: addServices()でサービスセクション追加
4. **行53**: container閉じタグ追加
5. **行55**: 環境変数プレースホルダ解決

#### Step 3: サービス変換処理を理解する

各サービス定義をXML要素に変換する処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | XmlDumper.php | `src/Symfony/Component/DependencyInjection/Dumper/XmlDumper.php` | addService()メソッド（行92-240）で各種属性・子要素を生成 |

**主要処理フロー**:
- **行94-132**: サービスのXML属性（id, class, shared, public, lazy, decorates等）
- **行136-162**: タグ要素の生成
- **行168-178**: 引数、プロパティ、メソッドコールの変換
- **行180-200**: ファクトリ要素の生成

#### Step 4: パラメータ型変換を理解する

convertParameters()メソッドが多様なPHP型をXML表現に変換する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | XmlDumper.php | `src/Symfony/Component/DependencyInjection/Dumper/XmlDumper.php` | convertParameters()（行296-404）で型ごとの変換処理 |

**主要処理フロー**:
- **行302-335**: TaggedIteratorArgument/ServiceLocatorArgumentの変換
- **行336-354**: 配列/イテレータ/サービスロケータの変換
- **行355-370**: Referenceの変換
- **行380-403**: スカラー値・式・バイナリ・列挙型の変換

### プログラム呼び出し階層図

```
XmlDumper::dump()
    |
    +-- addParameters()
    |       +-- convertParameters() [再帰]
    |
    +-- addServices()
    |       +-- addService() [各サービスごと]
    |       |       +-- addMethodCalls()
    |       |       +-- convertParameters() [引数]
    |       |       +-- convertParameters() [プロパティ]
    |       |       +-- addTagRecursiveAttributes() [再帰]
    |       |
    |       +-- addServiceAlias() [各エイリアスごと]
    |
    +-- resolveEnvPlaceholders()
```

### データフロー図

```
[入力]                      [処理]                       [出力]

ContainerBuilder ─────> XmlDumper::dump() ─────> XML文字列
  |-- Definitions            |                     |-- <?xml ...>
  |-- Aliases                |-- addParameters()   |-- <container>
  |-- ParameterBag           |-- addServices()     |--   <parameters>
                             |-- encode()          |--   <services>
                             +-- phpToXml()        |-- </container>
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| XmlDumper.php | `src/Symfony/Component/DependencyInjection/Dumper/XmlDumper.php` | ソース | メインのXMLダンプ処理クラス |
| Dumper.php | `src/Symfony/Component/DependencyInjection/Dumper/Dumper.php` | ソース | 基底クラス |
| Definition.php | `src/Symfony/Component/DependencyInjection/Definition.php` | ソース | サービス定義データ構造 |
| Alias.php | `src/Symfony/Component/DependencyInjection/Alias.php` | ソース | エイリアス定義 |
| Reference.php | `src/Symfony/Component/DependencyInjection/Reference.php` | ソース | サービス参照 |
| ContainerInterface.php | `src/Symfony/Component/DependencyInjection/ContainerInterface.php` | ソース | 無効参照動作の定数 |
