# 帳票設計書 13-YAML DIコンテナダンプ

## 概要

本ドキュメントは、Symfony DependencyInjectionコンポーネントにおけるYAML DIコンテナダンプ機能（`YamlDumper`）の設計仕様を定義する。DIコンテナのサービス定義をYAML形式で出力する。

### 本帳票の処理概要

YamlDumperは、Symfonyの依存性注入（DI）コンテナに登録されたサービス定義、パラメータ、エイリアスなどの情報をYAML形式の文字列として出力する。

**業務上の目的・背景**：YAMLはSymfonyで最も広く使用される設定記述形式であり、人間が読み書きしやすい特長を持つ。YamlDumperを使用してDIコンテナの状態をYAML形式でエクスポートすることで、設定のレビュー、バックアップ、他環境への移行が容易になる。

**帳票の利用シーン**：コンテナのデバッグ時にサービス定義をYAML形式で確認する場合や、設定のエクスポート・マイグレーション時に利用される。

**主要な出力内容**：
1. パラメータセクション（`parameters:` キー配下）
2. サービス定義セクション（`services:` キー配下）
3. エイリアス定義（`@サービスID` 記法）

**帳票の出力タイミング**：開発者がCLIコマンドで明示的に実行した場合、またはプログラム内でYamlDumperを直接呼び出した場合。

**帳票の利用者**：アプリケーション開発者、フレームワーク設定の管理者。

## 帳票種別

YAML形式テキスト出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `bin/console debug:container --format=yaml` | コマンド実行 |
| N/A | プログラム呼び出し | API呼び出し | YamlDumper::dump() |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | YAML |
| 用紙サイズ | N/A（テキストデータ） |
| 向き | N/A |
| ファイル名 | 任意（呼び出し側で指定） |
| 出力方法 | 文字列として返却 |
| 文字コード | UTF-8 |

### YAML固有設定

| 項目 | 内容 |
|-----|------|
| インデント | 4スペース |
| YAML Yamlコンポーネント依存 | `symfony/yaml` パッケージが必要 |
| カスタムタグ | `!tagged_iterator`, `!tagged_locator`, `!service_closure`, `!service`, `!iterator`, `!service_locator`, `!php/enum`, `!abstract` |

## 帳票レイアウト

### レイアウト概要

YAML文書として、トップレベルにparametersキーとservicesキーが配置される。

```
┌─────────────────────────────────────┐
│  parameters:                        │
│      param_name: value              │
├─────────────────────────────────────┤
│  services:                          │
│      service_id:                    │
│          class: ClassName           │
│          arguments: [...]           │
│          tags:                      │
│              - { name: tag_name }   │
├─────────────────────────────────────┤
│      alias_id: '@service_id'        │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | parameters | パラメータセクション | ParameterBag.all() | `parameters:` YAML |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | class | サービスクラス名 | Definition.getClass() | YAMLスカラー | N/A |
| 2 | public | 公開フラグ | Definition.isPublic() | `true`/`false` | N/A |
| 3 | tags | タグ定義 | Definition.getTags() | YAML配列 | N/A |
| 4 | synthetic | 合成フラグ | Definition.isSynthetic() | `true` | N/A |
| 5 | deprecated | 非推奨定義 | Definition.getDeprecation() | YAMLマップ | N/A |
| 6 | autowire | 自動ワイヤリング | Definition.isAutowired() | `true` | N/A |
| 7 | autoconfigure | 自動設定 | Definition.isAutoconfigured() | `true` | N/A |
| 8 | arguments | コンストラクタ引数 | Definition.getArguments() | YAML配列 | N/A |
| 9 | properties | プロパティインジェクション | Definition.getProperties() | YAMLマップ | N/A |
| 10 | calls | メソッドコール | Definition.getMethodCalls() | YAML配列 | N/A |
| 11 | factory | ファクトリ定義 | Definition.getFactory() | YAML配列/文字列 | N/A |
| 12 | configurator | コンフィグレータ | Definition.getConfigurator() | YAML配列/文字列 | N/A |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | エイリアス | サービスエイリアス定義 | ContainerBuilder.getAliases() | `alias_id: '@target_id'` |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ContainerBuilderインスタンス | コンストラクタで渡されたコンテナ | Yes |
| symfony/yamlパッケージ | YAMLコンポーネントがインストールされていること | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | パラメータ | 登録順 |
| 2 | サービス定義 | 登録順 |
| 3 | エイリアス | 登録順 |

### 改ページ条件

N/A（テキスト出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを直接参照しない。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | N/A | N/A |

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| サービス参照表記 | `@` + サービスID | N/A | 通常のサービス参照 |
| Nullable参照表記 | `@?` + サービスID | N/A | NULL許容参照 |
| 未初期化無視表記 | `@!` + サービスID | N/A | 未初期化時無視参照 |
| パラメータ参照表記 | `%` + パラメータ名 + `%` | N/A | パラメータ参照 |
| 式表記 | `@=` + 式 | N/A | ExpressionLanguage式 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[dump呼び出し] --> B{symfony/yaml存在?}
    B -->|No| C[LogicException]
    B -->|Yes| D[YmlDumperインスタンス生成]
    D --> E[addParameters]
    E --> F[addServices]
    F --> G[各サービスをYAML変換]
    G --> H[エイリアス追加]
    H --> I[YAML文字列結合]
    I --> J[結果返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| LogicException | symfony/yamlがインストールされていない | "Unable to dump the container as the Symfony Yaml Component is not installed." | `composer require symfony/yaml` を実行 |
| RuntimeException | パラメータにオブジェクトまたはリソースが含まれる | "Unable to dump a service container if a parameter is an object or a resource" | パラメータからオブジェクトやリソースを除去する |
| RuntimeException | 未知のArgumentInterface型 | "Unspecified Yaml tag for type \"{type}\"." | 対応するタグの実装を追加する |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千サービス定義 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | 制限なし（ステートレスな処理） |

## セキュリティ考慮事項

- YAML出力にはパラメータ値が含まれるため、出力結果の取り扱いに注意が必要
- `@`で始まるパラメータ値はYAMLのサービス参照と区別するために`@@`にエスケープされる（行355-357）
- 環境変数プレースホルダはランタイムで解決される

## 備考

- YamlDumperはsymfony/yamlコンポーネントへの依存があるため、インストールされていない場合はLogicExceptionが発生する（行47-49）
- TaggedValueを使用してYAMLカスタムタグ（!tagged_iterator等）を表現する
- Definitionのインライン定義は`!service`タグで出力される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

YamlDumperが入力として受け取るデータ構造と、YAML出力で使用するカスタムタグを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Dumper.php | `src/Symfony/Component/DependencyInjection/Dumper/Dumper.php` | 基底クラス（行21-27） |
| 1-2 | TaggedValue.php | `src/Symfony/Component/Yaml/Tag/TaggedValue.php` | YAMLカスタムタグの表現 |

**読解のコツ**: Symfony YAMLコンポーネントのTaggedValueがDIコンテナ特有の型（ServiceLocator, Iterator等）をどう表現するかに注目する。

#### Step 2: エントリーポイントを理解する

YamlDumperのdump()メソッドが処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | YamlDumper.php | `src/Symfony/Component/DependencyInjection/Dumper/YamlDumper.php` | dump()メソッド（行45-54）がエントリーポイント |

**主要処理フロー**:
1. **行47-49**: symfony/yamlの存在チェック
2. **行51**: YmlDumperインスタンスの遅延初期化
3. **行53**: addParameters()とaddServices()の結合

#### Step 3: サービス変換処理を理解する

各サービス定義をYAML表現に変換する処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | YamlDumper.php | `src/Symfony/Component/DependencyInjection/Dumper/YamlDumper.php` | addService()メソッド（行56-168）でサービスプロパティをYAML化 |

**主要処理フロー**:
- **行58-65**: サービスIDとクラス名の出力
- **行71-87**: タグの出力
- **行122-131**: 引数、プロパティ、メソッドコールの出力
- **行155-165**: ファクトリとコンフィグレータの出力

#### Step 4: 値のダンプ処理を理解する

dumpValue()メソッドがDI特有の型をYAML表現に変換する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | YamlDumper.php | `src/Symfony/Component/DependencyInjection/Dumper/YamlDumper.php` | dumpValue()メソッド（行249-323）で型別変換 |

**主要処理フロー**:
- **行251-255**: ServiceClosureArgumentの変換
- **行256-297**: ArgumentInterface（TaggedIterator, ServiceLocator等）の変換
- **行306-307**: Referenceのサービス参照記法変換
- **行312-313**: Definitionのインライン定義変換

### プログラム呼び出し階層図

```
YamlDumper::dump()
    |
    +-- addParameters()
    |       +-- prepareParameters()
    |       |       +-- escape()
    |       +-- YmlDumper::dump()
    |
    +-- addServices()
            +-- addService() [各サービスごと]
            |       +-- dumpValue() [再帰]
            |       |       +-- TaggedValue生成
            |       +-- dumpCallable()
            |
            +-- addServiceAlias() [各エイリアスごと]
```

### データフロー図

```
[入力]                      [処理]                       [出力]

ContainerBuilder ─────> YamlDumper::dump() ─────> YAML文字列
  |-- Definitions            |                     |-- parameters:
  |-- Aliases                |-- addParameters()   |--   param: value
  |-- ParameterBag           |-- addServices()     |-- services:
                             |-- dumpValue()       |--   service_id:
                             +-- dumpCallable()    |--     class: ...
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| YamlDumper.php | `src/Symfony/Component/DependencyInjection/Dumper/YamlDumper.php` | ソース | メインのYAMLダンプ処理クラス |
| Dumper.php | `src/Symfony/Component/DependencyInjection/Dumper/Dumper.php` | ソース | 基底クラス |
| YmlDumper (Yaml) | `src/Symfony/Component/Yaml/Dumper.php` | ソース | YAML出力ユーティリティ |
| TaggedValue.php | `src/Symfony/Component/Yaml/Tag/TaggedValue.php` | ソース | YAMLカスタムタグ表現 |
| Parser.php | `src/Symfony/Component/Yaml/Parser.php` | ソース | YAML解析（インライン定義の再解析用） |
| Definition.php | `src/Symfony/Component/DependencyInjection/Definition.php` | ソース | サービス定義データ構造 |
