# 帳票設計書 18-PlantUMLワークフロー図

## 概要

本ドキュメントは、Symfony Workflowコンポーネントにおけるワークフロー定義のPlantUML形式出力機能（`PlantUmlDumper`）の設計仕様を定義する。ワークフロー定義をPlantUML形式で出力し、plantuml.jarで画像に変換可能にする。

### 本帳票の処理概要

PlantUmlDumperは、Symfonyのワークフロー定義をPlantUML記法で出力する。PlantUMLは`@startuml`〜`@enduml`で囲まれた記法でUML図を記述するツールであり、状態遷移図の生成に適している。

**業務上の目的・背景**：PlantUMLは広く使われるUML図生成ツールであり、テキストベースの記述から高品質なUML図を生成できる。既存のPlantUMLツールチェーン（CI/CDパイプライン、ドキュメント生成ツール等）との統合が容易であり、ワークフローの状態遷移を標準的なUML表記で可視化できる。

**帳票の利用シーン**：UML図を用いた設計ドキュメント生成、PlantUMLサーバーを利用した動的な図の生成、CI/CDパイプラインでの自動ドキュメント生成、既存のPlantUML環境との連携に使用される。

**主要な出力内容**：
1. PlantUML開始/終了タグ（`@startuml`/`@enduml`）
2. skinparam設定（色、ボーダー等のスタイル設定）
3. state宣言（各プレースの状態定義）
4. agent宣言（workflowモード時のトランジション表現）
5. 状態遷移矢印（`--->` 記法）

**帳票の出力タイミング**：`workflow:dump --dump-format=puml`コマンド実行時、またはプログラム内でDumperを直接呼び出した場合。

**帳票の利用者**：アプリケーション開発者、UML図を使用する設計者。

## 帳票種別

PlantUML形式テキスト出力（状態遷移図）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `bin/console workflow:dump {name} --dump-format=puml` | コマンド実行 |
| N/A | プログラム呼び出し | API呼び出し | PlantUmlDumper::dump() |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PlantUML（テキスト） |
| 用紙サイズ | N/A（自動レイアウト） |
| 向き | PlantUMLエンジンによる自動レイアウト |
| ファイル名 | 任意（例: `workflow.puml`） |
| 出力方法 | 文字列として返却 |
| 文字コード | UTF-8 |

### PlantUML固有設定

| 項目 | 内容 |
|-----|------|
| トランジションタイプ | arrow（ステートマシン） / square（ワークフロー） |
| allow_mixing | 有効（state要素とagent要素の混在を許可） |
| titleBorderRoundCorner | 15 |
| titleBorderThickness | 2 |
| state BackgroundColor (initial) | #87b741 |
| state BackgroundColor (marked) | #3887C6 |
| state BorderColor | #3887C6 |
| agent BackgroundColor | #ffffff |
| agent BorderColor | #3887C6 |

## 帳票レイアウト

### レイアウト概要

PlantUML状態遷移図として、state要素とトランジション矢印で構成される。

```
┌─────────────────────────────────────┐
│  @startuml                          │
│  allow_mixing                       │
├─────────────────────────────────────┤
│  title {ワークフロー名}              │
│  skinparam state { ... }            │
│  skinparam agent { ... }            │
├─────────────────────────────────────┤
│  state "place1" <<initial>>         │
│  state "place2"                     │
│  agent "transition1"  [workflowのみ]│
├─────────────────────────────────────┤
│  "place1" --> "place2": "trans"     │
│  [or]                               │
│  "place1" --> "transition1"         │
│  "transition1" --> "place2"         │
├─────────────────────────────────────┤
│  @enduml                            │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | startuml | PlantUML開始タグ | 固定値 | `@startuml` |
| 2 | allow_mixing | 要素タイプの混在許可 | 固定値 | `allow_mixing` |
| 3 | title | ワークフロー名 | options['title'] or options['name'] | `title {name}` |
| 4 | skinparams | スタイル設定 | DEFAULT_OPTIONS + options | `skinparam state { ... }` |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | state | プレースの状態宣言 | Definition.getPlaces() | `state "name" <<initial>>` | N/A |
| 2 | agent | トランジションのエージェント宣言 | Definition.getTransitions() | `agent "name"` | N/A |
| 3 | 遷移矢印 | 状態間の遷移 | Transition.getFroms/getTos | `"from" --> "to": "label"` | N/A |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | enduml | PlantUML終了タグ | 固定値 | `@enduml` |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Definition | ワークフロー定義 | Yes |
| transitionType | arrow / square | Yes（コンストラクタ） |
| Marking | 現在のマーキング状態 | No |
| options | タイトル、skinparams等 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | プレース | 定義順 |
| 2 | トランジション | 定義順 |

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを直接参照しない。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | N/A | N/A |

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 初期プレースステレオタイプ | `<<initial>>` | N/A | 初期プレースに付加（行196） |
| マーキングステレオタイプ | `<<marked>>` | N/A | マーキング済みプレースに付加（行197） |
| 色ID | `ltrim($color, '#')` | N/A | 色コードからステレオタイプIDを生成（行248-252） |
| 矢印色 | `[#color]` 形式 | N/A | `#`プレフィクスの自動付加（行238-246） |
| フォント色 | `<font color=...>text</font>` | N/A | HTML風の色指定（行224-233） |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[dump呼び出し] --> B[オプションマージ]
    B --> C[initialize - skinparams生成]
    C --> D[各プレースのstate宣言]
    D --> E{workflowモード?}
    E -->|Yes| F[agent宣言生成]
    E -->|No| G[スキップ]
    F --> H[トランジション矢印生成]
    G --> H
    H --> I{重複チェック}
    I -->|新規| J[code配列に追加]
    I -->|重複| K[スキップ]
    J --> L[startPuml + getLines + endPuml]
    K --> L
    L --> M[PlantUML文字列返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| InvalidArgumentException | 不正なtransitionType | "Transition type '{type}' does not exist." | arrow または square を指定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十プレース、数十トランジション |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- ダブルクォートはエスケープではなく除去される（行186）
- ワークフロー名、プレース名、トランジション名が出力に含まれる

## 備考

- 画像変換コマンド例: `php bin/console workflow:dump pull_request --dump-format=puml | java -jar plantuml.jar -p > workflow.png`
- arrowモード（ステートマシン）: プレース間を直接矢印で接続
- squareモード（ワークフロー）: agent要素をトランジションとして表現し、プレースとの間を矢印で接続
- workflowモードでは重複行の追加を防止する（行107-109）
- bg_colorメタデータによるプレースの背景色カスタマイズに対応（行155-161）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

PlantUmlDumperの定数とデフォルトオプションを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PlantUmlDumper.php | `src/Symfony/Component/Workflow/Dumper/PlantUmlDumper.php` | TRANSITION_TYPES定数（行35）とDEFAULT_OPTIONS定数（行36-52） |
| 1-2 | PlantUmlDumper.php | `src/Symfony/Component/Workflow/Dumper/PlantUmlDumper.php` | コンストラクタ（行54-59）でトランジションタイプのバリデーション |

**読解のコツ**: DEFAULT_OPTIONSのskinparamsの構造を理解すると、PlantUMLの外観カスタマイズの仕組みがわかる。

#### Step 2: エントリーポイントを理解する

dump()メソッドが処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PlantUmlDumper.php | `src/Symfony/Component/Workflow/Dumper/PlantUmlDumper.php` | dump()メソッド（行62-119）がエントリーポイント |

**主要処理フロー**:
1. **行64**: オプションのディープマージ
2. **行68**: initialize()でskinparams等の初期化コード生成
3. **行70-72**: 各プレースのstate宣言生成
4. **行73-78**: workflowモード時のagent宣言生成
5. **行79-116**: トランジション矢印の生成
6. **行118**: startPuml + getLines + endPuml

#### Step 3: 状態宣言生成を理解する

getState()でプレースの状態表現を生成する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PlantUmlDumper.php | `src/Symfony/Component/Workflow/Dumper/PlantUmlDumper.php` | getState()（行189-212）で初期/マーキング/色/説明を含む状態宣言 |

#### Step 4: 矢印スタイルを理解する

getTransitionEscapedWithStyle()でトランジションラベルのスタイルを生成する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | PlantUmlDumper.php | `src/Symfony/Component/Workflow/Dumper/PlantUmlDumper.php` | getTransitionEscapedWithStyle()（行214-236）でHTMLフォント色等を適用 |

### プログラム呼び出し階層図

```
PlantUmlDumper::dump()
    |
    +-- initialize()
    |       +-- skinparams生成
    |       +-- bg_colorステレオタイプ生成
    |
    +-- getState() [各プレース]
    |       +-- escape()
    |       +-- getColorId()
    |
    +-- [workflowモード] agent宣言
    |
    +-- [トランジションループ]
    |       +-- getTransitionEscapedWithStyle()
    |       |       +-- MetadataStore::getMetadata()
    |       +-- getTransitionColor()
    |       +-- isWorkflowTransitionType()
    |
    +-- startPuml()
    +-- getLines()
    +-- endPuml()
```

### データフロー図

```
[入力]                        [処理]                         [出力]

Definition ──────────> PlantUmlDumper::dump() ──────> PlantUML文字列
  |-- Places                |                          |-- @startuml
  |-- Transitions           |-- initialize()           |-- allow_mixing
  |-- MetadataStore         |-- getState()             |-- skinparam state {...}
Marking (optional) ──> |-- transition arrows      |-- state "..." <<initial>>
transitionType ───────> +-- startPuml/endPuml      |-- "from" --> "to": "label"
options ─────────────>                             |-- @enduml
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PlantUmlDumper.php | `src/Symfony/Component/Workflow/Dumper/PlantUmlDumper.php` | ソース | メインのPlantUMLダンプ処理 |
| DumperInterface.php | `src/Symfony/Component/Workflow/Dumper/DumperInterface.php` | ソース | ダンパーインターフェース |
| Definition.php | `src/Symfony/Component/Workflow/Definition.php` | ソース | ワークフロー定義 |
| Marking.php | `src/Symfony/Component/Workflow/Marking.php` | ソース | マーキング状態 |
| Transition.php | `src/Symfony/Component/Workflow/Transition.php` | ソース | トランジション定義 |
| MetadataStoreInterface.php | `src/Symfony/Component/Workflow/Metadata/MetadataStoreInterface.php` | ソース | メタデータストア |
