# 帳票設計書 19-Mermaidロール階層図

## 概要

本ドキュメントは、Symfony Securityコンポーネントにおけるロール階層のMermaidフローチャート出力機能（`MermaidDumper`）の設計仕様を定義する。セキュリティのロール階層をMermaidフローチャート形式で出力する。

### 本帳票の処理概要

Security MermaidDumperは、Symfonyのセキュリティシステムで定義されたロール階層（RoleHierarchy）をMermaidフローチャート記法で出力する。親ロールから子ロールへの継承関係を有向グラフとして可視化する。

**業務上の目的・背景**：Symfonyアプリケーションでは、セキュリティロールの階層構造が複雑になることがある（例: ROLE_SUPER_ADMIN > ROLE_ADMIN > ROLE_USER）。この階層関係をMermaid記法で可視化することで、権限構造の把握、セキュリティレビュー、ドキュメント生成が容易になる。Mermaid記法はGitHub等のMarkdownレンダラーで直接表示できるため、追加ツールなしで利用可能。

**帳票の利用シーン**：セキュリティ設計のレビュー時、ロール構造のドキュメント化時、権限設計の確認・監査時に使用される。

**主要な出力内容**：
1. Mermaidグラフ宣言（`graph {direction}`）
2. ロールノード定義（各ロールをノードとして表示）
3. 階層関係のエッジ（親ロール→子ロールの矢印）
4. デフォルトスタイル定義

**帳票の出力タイミング**：プログラム内でMermaidDumperを直接呼び出した場合。

**帳票の利用者**：セキュリティエンジニア、アプリケーション開発者、監査担当者。

## 帳票種別

Mermaid記法テキスト出力（ロール階層フローチャート）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | プログラム呼び出し | API呼び出し | MermaidDumper::dump() |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Mermaid（テキスト） |
| 用紙サイズ | N/A |
| 向き | 設定可能（TB, TD, BT, RL, LR） |
| ファイル名 | 任意 |
| 出力方法 | 文字列として返却 |
| 文字コード | UTF-8 |

### Mermaid固有設定

| 項目 | 内容 |
|-----|------|
| チャートタイプ | graph（フローチャート） |
| デフォルト方向 | TB（上から下） |
| デフォルトスタイル | `fill:#e1f5fe`（空の階層の場合） |

## 帳票レイアウト

### レイアウト概要

ロール階層をMermaidフローチャートとして表現する。

```
┌─────────────────────────────────────┐
│  graph TB                           │
├─────────────────────────────────────┤
│    ROLE_SUPER_ADMIN                 │
│    ROLE_ADMIN                       │
│    ROLE_USER                        │
│    (ロールノード定義)                │
├─────────────────────────────────────┤
│    ROLE_SUPER_ADMIN --> ROLE_ADMIN   │
│    ROLE_ADMIN --> ROLE_USER          │
│    (階層関係のエッジ)                │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | graph宣言 | フローチャートの開始と方向 | MermaidDirection enum | `graph TB` |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ロールノード | 各ロールの定義 | RoleHierarchy.hierarchy | `ROLE_ADMIN` | N/A |
| 2 | 階層エッジ | 親ロール→子ロールの関係 | hierarchy配列 | `ROLE_ADMIN --> ROLE_USER` | N/A |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | N/A | Mermaid記法には明示的なフッターなし | N/A | N/A |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| RoleHierarchyInterface | ロール階層オブジェクト | Yes |
| MermaidDirection | グラフの方向 | No（デフォルト: TOP_TO_BOTTOM） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ロールノード | 階層の定義順（ユニーク化後） |
| 2 | エッジ | 親ロール順 |

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを直接参照しない。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | N/A | N/A |

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ロール名正規化 | `preg_replace('/[^a-zA-Z0-9_]/', '_', $role)` | N/A | Mermaid互換の識別子に変換（行84-87） |
| 全ロール抽出 | 親ロール + 子ロール の重複排除 | N/A | array_unique()で一意化（行67-79） |
| 階層抽出 | ReflectionClassでhierarchyプロパティ取得 | N/A | RoleHierarchyのprivateプロパティにリフレクションアクセス（行54-65） |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[dump呼び出し] --> B[extractHierarchy]
    B --> C{階層あり?}
    C -->|No| D[空のグラフ+デフォルトスタイル返却]
    C -->|Yes| E[getAllRoles - 全ロール抽出]
    E --> F[graph宣言出力]
    F --> G[各ロールのノード出力]
    G --> H[各親→子のエッジ出力]
    H --> I[改行で結合]
    I --> J[Mermaid文字列返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| N/A | RoleHierarchyInterface以外の実装 | エラーなし（空配列を返す） | RoleHierarchyクラスのインスタンスを使用する |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数個〜数十個のロール |
| 目標出力時間 | 即時（ミリ秒単位） |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- 出力にはアプリケーションのロール名が含まれるため、公開範囲に注意が必要
- extractHierarchy()メソッドはReflectionClassを使用してprivateプロパティにアクセスする（行60-64）
- RoleHierarchyInterfaceの実装がRoleHierarchyクラスでない場合、階層情報は取得できない（空配列が返る）

## 備考

- MermaidDirection enumで方向を指定: TB, TD, BT, RL, LR
- RoleHierarchyクラスのhierarchyプロパティにReflectionを使用してアクセスするため、RoleHierarchy以外のRoleHierarchyInterface実装では階層が取得できない
- normalizeRoleName()で非英数字をアンダースコアに変換し、Mermaid互換のノード名を生成
- 空の階層の場合、デフォルトスタイル（fill:#e1f5fe）のみを含む空グラフを返す

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ロール階層のデータ構造とMermaidDirection enumを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MermaidDirection.php | `src/Symfony/Component/Security/Core/Dumper/MermaidDirection.php` | 5方向のenum定義（行14-21）。TB, TD, BT, RL, LR |
| 1-2 | RoleHierarchy.php | `src/Symfony/Component/Security/Core/Role/RoleHierarchy.php` | hierarchyプロパティ（privateな配列） |
| 1-3 | RoleHierarchyInterface.php | `src/Symfony/Component/Security/Core/Role/RoleHierarchyInterface.php` | インターフェース定義 |

**読解のコツ**: RoleHierarchyはprivateプロパティにロール階層を保持するため、MermaidDumperはReflectionを使用してアクセスする。この設計上の制約を理解する。

#### Step 2: エントリーポイントを理解する

dump()メソッドが処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MermaidDumper.php | `src/Symfony/Component/Security/Core/Dumper/MermaidDumper.php` | dump()メソッド（行30-52）がエントリーポイント |

**主要処理フロー**:
1. **行32**: extractHierarchy()でロール階層を取得
2. **行34-36**: 空階層の場合のアーリーリターン
3. **行38**: graph宣言
4. **行39**: getAllRoles()で全ロール一覧取得
5. **行41-43**: 各ロールのノード出力
6. **行45-49**: 各親→子のエッジ出力
7. **行51**: 改行で結合して返却

#### Step 3: 階層抽出を理解する

extractHierarchy()でRoleHierarchyのprivateプロパティにアクセスする。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MermaidDumper.php | `src/Symfony/Component/Security/Core/Dumper/MermaidDumper.php` | extractHierarchy()（行54-65）でReflectionClassを使用 |

**主要処理フロー**:
- **行56-58**: RoleHierarchyインスタンスかチェック（それ以外は空配列）
- **行60-64**: ReflectionClassでhierarchyプロパティの値を取得

### プログラム呼び出し階層図

```
MermaidDumper::dump()
    |
    +-- extractHierarchy()
    |       +-- ReflectionClass(RoleHierarchy)
    |       +-- getProperty('hierarchy')
    |       +-- getValue($roleHierarchy)
    |
    +-- getAllRoles()
    |       +-- array_unique()
    |
    +-- normalizeRoleName() [各ロール]
    |       +-- preg_replace()
    |
    +-- implode("\n", $output)
```

### データフロー図

```
[入力]                            [処理]                         [出力]

RoleHierarchyInterface ──> MermaidDumper::dump() ──────> Mermaid文字列
  |-- hierarchy              |                            |-- graph TB
      (private property)     |-- extractHierarchy()       |--   ROLE_ADMIN
                             |-- getAllRoles()             |--   ROLE_USER
MermaidDirection ────────> |-- normalizeRoleName()     |--   ROLE_ADMIN --> ROLE_USER
                             +-- implode()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MermaidDumper.php | `src/Symfony/Component/Security/Core/Dumper/MermaidDumper.php` | ソース | メインのMermaidロール階層ダンプ処理 |
| MermaidDirection.php | `src/Symfony/Component/Security/Core/Dumper/MermaidDirection.php` | ソース | 方向指定のenum |
| RoleHierarchy.php | `src/Symfony/Component/Security/Core/Role/RoleHierarchy.php` | ソース | ロール階層の実装 |
| RoleHierarchyInterface.php | `src/Symfony/Component/Security/Core/Role/RoleHierarchyInterface.php` | ソース | ロール階層インターフェース |
