# 帳票設計書 20-YAML設定リファレンス

## 概要

本ドキュメントは、Symfony Configコンポーネントにおけるバンドル設定のYAMLリファレンス出力機能（`YamlReferenceDumper`）の設計仕様を定義する。Bundleの設定定義からYAML形式のリファレンス設定を出力する。

### 本帳票の処理概要

YamlReferenceDumperは、Symfonyバンドルの設定ツリー定義（ConfigurationInterface）からYAML形式のリファレンス設定を生成する。設定ノードの階層構造をYAML形式で出力し、デフォルト値、必須項目、列挙値、非推奨情報等をコメントとして付加する。

**業務上の目的・背景**：Symfonyバンドルは複雑な設定オプションを持つことがある。YamlReferenceDumperを使用して設定のリファレンスドキュメントを自動生成することで、開発者が利用可能な設定オプションとそのデフォルト値を迅速に把握できる。手作業によるドキュメント作成の手間を省き、コードと常に同期した設定リファレンスを提供する。

**帳票の利用シーン**：`config:dump-reference`コマンドでバンドルの設定リファレンスを確認する場合、ドキュメント生成時、設定ファイルのテンプレート作成時に使用される。

**主要な出力内容**：
1. 設定キーとデフォルト値の階層的なYAML表示
2. コメントによるメタ情報（Required, Deprecated, One of, Example等）
3. デフォルト値のインラインダンプ
4. プロトタイプノードの展開表示

**帳票の出力タイミング**：`config:dump-reference {bundle}`コマンド実行時、またはプログラム内でYamlReferenceDumperを直接呼び出した場合。

**帳票の利用者**：アプリケーション開発者、バンドル利用者。

## 帳票種別

YAML形式テキスト出力（設定リファレンス）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `bin/console config:dump-reference {bundle}` | コマンド実行 |
| N/A | プログラム呼び出し | API呼び出し | YamlReferenceDumper::dump() |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | YAML（コメント付きリファレンス） |
| 用紙サイズ | N/A（テキストデータ） |
| 向き | N/A |
| ファイル名 | 任意 |
| 出力方法 | 文字列として返却 |
| 文字コード | UTF-8 |

### YAML固有設定

| 項目 | 内容 |
|-----|------|
| インデント | 4スペース |
| コメント記法 | `#` プレフィクス |
| デフォルト値表示 | Inline::dump()によるYAMLインライン表現 |
| キー幅 | 21文字固定幅フォーマット |

## 帳票レイアウト

### レイアウト概要

YAML設定リファレンスとして、設定キーの階層とコメントで構成される。

```
┌─────────────────────────────────────┐
│  root_key:                          │
│                                     │
│      # 設定項目の説明               │
│      key1:             ~ # Required │
│                                     │
│      # 子設定の説明                 │
│      child:                         │
│          key2:          true        │
│          key3:          'default'   │
│                                     │
│      # One of debug; prod; test     │
│      env:              ~ # Required │
│                                     │
│      # Defaults:                    │
│      items:                         │
│          - value1                   │
│          - value2                   │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ルートキー | 設定のルートノード名 | ConfigurationInterface.getConfigTreeBuilder().buildTree().getName() | `root_key:` |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 設定キー | 各設定ノードのキー名 | NodeInterface.getName() | `key:` | 21文字固定 |
| 2 | デフォルト値 | 設定のデフォルト値 | Node.getDefaultValue() | Inline::dump() | 可変 |
| 3 | 情報コメント | ノードのinfo文字列 | BaseNode.getInfo() | `# info text` | 可変 |
| 4 | 制約コメント | 必須、列挙値、非推奨等 | Node属性 | `# Required`, `# One of ...` | 可変 |
| 5 | サンプルコメント | 使用例 | BaseNode.getExample() | `# Example: value` | 可変 |
| 6 | デフォルト配列 | 配列型のデフォルト値 | ArrayNode.getDefaultValue() | `# Defaults:` + YAML配列 | 可変 |
| 7 | プロトタイプ | プロトタイプノードの展開 | PrototypedArrayNode | `# Prototype: ...` | 可変 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | N/A | 特にフッターなし | N/A | N/A |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ConfigurationInterface | バンドル設定定義 | Yes（dump()メソッド） |
| NodeInterface | 設定ノード | Yes（dumpNode()メソッド） |
| path | 特定パスの設定を出力 | No（dumpAtPath()メソッド） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 設定キー | 定義順（ノードツリーのトラバーサル順） |

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを直接参照しない。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | N/A | N/A |

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| インデント幅 | `depth * 4` スペース | N/A | ノードの深さに応じたインデント（行178-183） |
| キー表示幅 | `sprintf('%-21s', $key)` | N/A | 21文字固定幅フォーマット（行135） |
| デフォルト値表現 | ArrayNode: `[]` or `~`, ScalarNode: `Inline::dump()` | N/A | ノード種別に応じたデフォルト値のYAML表現（行85-113） |
| コメント結合 | `'# ' + implode(', ', $comments)` | N/A | 複数コメントをカンマ区切り（行132） |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[dump呼び出し] --> B[getConfigTreeBuilder]
    B --> C[buildTree]
    C --> D[dumpNode]
    D --> E[writeNode - 再帰処理]
    E --> F{ノード種別?}
    F -->|ArrayNode| G[子ノードを再帰処理]
    F -->|PrototypedArrayNode| H[プロトタイプ子ノード展開]
    F -->|EnumNode| I[許容値コメント追加]
    F -->|ScalarNode| J[デフォルト値出力]
    G --> K[writeLine]
    H --> K
    I --> K
    J --> K
    K --> L[reference文字列に追記]
    L --> M[YAML文字列返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| UnexpectedValueException | dumpAtPath()で指定パスが見つからない | "Unable to find node at path \"{root}.{path}\"." | 正しいパスを指定する |
| UnexpectedValueException | dumpAtPath()で非ArrayNodeにパスを辿ろうとした | "Unable to find node at path \"{root}.{path}\"." | ArrayNode以外のノードにはサブパスを指定しない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数百の設定ノード |
| 目標出力時間 | 即時（ミリ秒単位） |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- 出力にはバンドルの設定構造とデフォルト値が含まれるが、実際の設定値は含まれない
- デフォルト値にクレデンシャル等が含まれる場合は注意が必要

## 備考

- dump()メソッドはConfigurationInterfaceを受け取り、内部でConfigTreeBuilderを構築する（行32-35）
- dumpNode()メソッドはNodeInterfaceを直接受け取る（行63-71）
- dumpAtPath()メソッドは`.`区切りのパスで特定のサブツリーを出力可能（行37-61）
- PrototypedArrayNodeの場合、プロトタイプの子ノードを展開して表示する（行88-90, 210-243）
- EnumNodeの場合、許容値を`One of`コメントとして表示する（行95-97）
- 非推奨ノードの場合、`Deprecated`コメントを表示する（行122-124）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定ノードツリーのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ConfigurationInterface.php | `src/Symfony/Component/Config/Definition/ConfigurationInterface.php` | getConfigTreeBuilder()でツリー構築 |
| 1-2 | NodeInterface.php | `src/Symfony/Component/Config/Definition/NodeInterface.php` | getName(), hasDefaultValue(), getDefaultValue()等 |
| 1-3 | ArrayNode.php | `src/Symfony/Component/Config/Definition/ArrayNode.php` | getChildren()で子ノード取得 |
| 1-4 | PrototypedArrayNode.php | `src/Symfony/Component/Config/Definition/PrototypedArrayNode.php` | getPrototype(), getKeyAttribute() |
| 1-5 | EnumNode.php | `src/Symfony/Component/Config/Definition/EnumNode.php` | getPermissibleValues()で許容値取得 |

**読解のコツ**: 設定ツリーはArrayNode→子ノード（Scalar/Enum/Array）の再帰的な階層構造。PrototypedArrayNodeはプロトタイプパターンで可変数の子を持つ。

#### Step 2: エントリーポイントを理解する

dump(), dumpNode(), dumpAtPath()の3つのエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | YamlReferenceDumper.php | `src/Symfony/Component/Config/Definition/Dumper/YamlReferenceDumper.php` | dump()（行32-35）、dumpAtPath()（行37-61）、dumpNode()（行63-71） |

**主要処理フロー**:
1. **行32-35**: dump()でConfigurationからツリー構築→dumpNode()呼び出し
2. **行63-71**: dumpNode()でreference文字列を初期化しwriteNode()を呼び出し
3. **行37-61**: dumpAtPath()でパス指定のサブツリーに移動してdumpNode()

#### Step 3: ノード書き込み処理を理解する

writeNode()が再帰的にノードツリーをYAMLテキストに変換する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | YamlReferenceDumper.php | `src/Symfony/Component/Config/Definition/Dumper/YamlReferenceDumper.php` | writeNode()（行73-172）でノード種別ごとのデフォルト値・コメント生成 |

**主要処理フロー**:
- **行85-94**: ArrayNode/PrototypedArrayNodeのデフォルト値処理
- **行95-97**: EnumNodeの許容値コメント生成
- **行98-114**: ScalarNodeのデフォルト値処理
- **行117-124**: 必須/非推奨/例のコメント生成
- **行134-135**: 21文字固定幅のキー+デフォルト値+コメントの行生成
- **行137-142**: info文字列のコメント出力
- **行147-155**: 配列デフォルト値の出力
- **行167-171**: 子ノードの再帰処理

#### Step 4: プロトタイプノードの展開を理解する

getPrototypeChildren()でPrototypedArrayNodeの子ノードを展開する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | YamlReferenceDumper.php | `src/Symfony/Component/Config/Definition/Dumper/YamlReferenceDumper.php` | getPrototypeChildren()（行210-243）でプロトタイプの展開ロジック |

**主要処理フロー**:
- **行212-213**: プロトタイプとキー属性の取得
- **行216-218**: キーなし&非ArrayNodeの場合はそのまま子ノード返却
- **行220-231**: ArrayNodeの場合はキーノードを作成して子を追加
- **行236-241**: info文字列に"Prototype"プレフィクスを付加

### プログラム呼び出し階層図

```
YamlReferenceDumper::dump()
    |
    +-- ConfigurationInterface::getConfigTreeBuilder()
    +-- TreeBuilder::buildTree()
    +-- dumpNode()
            |
            +-- writeNode() [再帰]
                    |
                    +-- BaseNode::getExample()
                    +-- BaseNode::getInfo()
                    +-- NodeInterface::hasDefaultValue()
                    +-- NodeInterface::getDefaultValue()
                    +-- EnumNode::getPermissibleValues()
                    +-- BaseNode::isDeprecated()
                    +-- NodeInterface::isRequired()
                    +-- ArrayNode::getChildren()
                    +-- PrototypedArrayNode::getPrototype()
                    +-- getPrototypeChildren()
                    +-- writeLine()
                    +-- writeArray() [再帰]
                    +-- writeNode() [再帰 for children]
```

### データフロー図

```
[入力]                           [処理]                         [出力]

ConfigurationInterface ──> YamlReferenceDumper::dump() ──> YAML文字列
  |                             |                          |-- root_key:
  +-- getConfigTreeBuilder()    |-- buildTree()            |--   # info
      +-- buildTree()           |-- writeNode() [再帰]     |--   key: default # comment
          |-- ArrayNode         |-- writeLine()            |--   child:
          |   +-- children      |-- writeArray()           |--     subkey: value
          |-- EnumNode          +-- Inline::dump()
          |-- ScalarNode
          +-- PrototypedArrayNode
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| YamlReferenceDumper.php | `src/Symfony/Component/Config/Definition/Dumper/YamlReferenceDumper.php` | ソース | メインのYAML設定リファレンスダンプ処理 |
| ConfigurationInterface.php | `src/Symfony/Component/Config/Definition/ConfigurationInterface.php` | ソース | バンドル設定インターフェース |
| NodeInterface.php | `src/Symfony/Component/Config/Definition/NodeInterface.php` | ソース | ノードインターフェース |
| BaseNode.php | `src/Symfony/Component/Config/Definition/BaseNode.php` | ソース | ノード基底クラス |
| ArrayNode.php | `src/Symfony/Component/Config/Definition/ArrayNode.php` | ソース | 配列ノード |
| PrototypedArrayNode.php | `src/Symfony/Component/Config/Definition/PrototypedArrayNode.php` | ソース | プロトタイプ配列ノード |
| EnumNode.php | `src/Symfony/Component/Config/Definition/EnumNode.php` | ソース | 列挙ノード |
| ScalarNode.php | `src/Symfony/Component/Config/Definition/ScalarNode.php` | ソース | スカラーノード |
| Inline.php | `src/Symfony/Component/Yaml/Inline.php` | ソース | YAMLインラインダンプユーティリティ |
