# 帳票設計書 21-XML設定リファレンス

## 概要

本ドキュメントは、Symfony Configコンポーネントにおける `XmlReferenceDumper` クラスの帳票設計書である。Bundleの設定定義（ConfigurationInterface実装クラス）からXML形式のリファレンス設定を自動生成する機能について、出力仕様・処理フロー・データ構造を定義する。

### 本帳票の処理概要

`XmlReferenceDumper` は、Symfonyの設定ツリー（ConfigurationInterface）をXML形式のリファレンス文書として出力するクラスである。Bundleが定義する設定項目をXML形式で整形し、開発者が正しい設定記述を行うための参考情報を提供する。

**業務上の目的・背景**：Symfonyアプリケーションでは、各Bundleが独自の設定項目を持つ。これらの設定項目は設定ツリー（TreeBuilder）で定義されるが、開発者がどのようなXML設定が可能かを把握するのは困難である。XmlReferenceDumperは、設定ツリーから自動的にXMLリファレンスを生成し、開発者の設定作業を効率化する。

**帳票の利用シーン**：コマンドラインから `config:dump-reference` コマンドをXMLフォーマット指定で実行した際に利用される。また、ドキュメント自動生成やIDE補完情報の生成にも活用される。

**主要な出力内容**：
1. XML要素名（設定ノード名をケバブケースに変換したもの）
2. XML属性（スカラーノードの名前・デフォルト値）
3. XMLコメント（各ノードのinfo、example、required、deprecated、enum等のメタ情報）
4. XMLネームスペース（ルートノードのネームスペースURI）
5. プロトタイプノードのXMLマッピング情報

**帳票の出力タイミング**：開発者がCLIコマンド `php bin/console config:dump-reference <bundle> xml` を実行した際、または `dumpNode()` / `dump()` メソッドがプログラム的に呼び出された際に出力される。

**帳票の利用者**：アプリケーション開発者、Bundle開発者、DevOpsエンジニア

## 帳票種別

設定リファレンスドキュメント（テキスト出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIコマンド | `php bin/console config:dump-reference` | `--format=xml` オプション指定 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | XML（テキスト） |
| 用紙サイズ | N/A（テキスト出力） |
| 向き | N/A |
| ファイル名 | 標準出力またはリダイレクト先ファイル |
| 出力方法 | 標準出力（CLI）/ 文字列返却 |
| 文字コード | UTF-8（PHP_EOLに依存する改行コード） |

### PDF固有設定

該当なし

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

XML形式のリファレンス設定が、インデント付きで出力される。ルート要素にはネームスペースが付与され、子要素・属性・コメントが階層的に配置される。

```
┌─────────────────────────────────────┐
│   <!-- コメント（info/namespace） -->  │
│   <!-- 属性コメント（info/example） --> │
├─────────────────────────────────────┤
│   <config                            │
│       attribute1="default_value"     │
│       attribute2=""                   │
│   >                                  │
│                                      │
│       <!-- 子ノードコメント -->        │
│       <child-node attr="value" />    │
│                                      │
│   </config>                          │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ルートノードコメント | ノードのinfo情報 | `ArrayNode::getInfo()` | `<!-- {info} -->` |
| 2 | ネームスペースコメント | XMLネームスペースURI | 引数`$namespace`またはデフォルトURI | `<!-- Namespace: {uri} -->` |
| 3 | 属性コメント | 各属性のinfo/example/required/deprecated/enum情報 | `BaseNode::getInfo()`, `getExample()`, `isRequired()`, `isDeprecated()`, `EnumNode::getPermissibleValues()` | `<!-- {attrName}: {comment} -->` |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 開始タグ | XML要素の開始タグ | `NodeInterface::getName()` | `<{element-name}` | 可変 |
| 2 | 属性 | スカラーノードの属性値 | `NodeInterface::getDefaultValue()` | `{name}="{value}"` | 可変 |
| 3 | 子要素 | ArrayNodeの子要素 | 再帰処理 | ネストされたXML要素 | 可変 |
| 4 | プロトタイプ値 | PrototypedArrayNodeのテキスト内容 | プロトタイプノードの型に応じた値 | テキストノード | 可変 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 終了タグ | XML要素の終了タグ | ルートノード名 | `</{element-name}>` |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ConfigurationInterface実装 | 設定ツリーを定義するConfigurationオブジェクト | Yes（`dump()`メソッド使用時） |
| NodeInterface実装 | ノードツリーのルートノード | Yes（`dumpNode()`メソッド使用時） |
| namespace | XMLネームスペースURI | No（省略時は`http://example.org/schema/dic/{nodeName}`） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ノード定義順 | 定義順（設定ツリーの定義順序に従う） |

### 改ページ条件

該当なし（テキスト出力のため改ページ概念なし）

## データベース参照仕様

### 参照テーブル一覧

該当なし（データベースを参照しない。設定ツリーオブジェクトからデータを取得する）

### テーブル別参照項目詳細

該当なし

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| インデント | `depth * 4`（スペース数） | なし | ネスト階層に応じたインデント |
| ノード名変換 | `str_replace('_', '-', $nodeName)` | なし | アンダースコアをハイフンに変換（XML命名規約） |
| ネームスペースURI | `'http://example.org/schema/dic/' . $nodeName` | なし | デフォルトネームスペースの自動生成 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[dump/dumpNode呼び出し] --> B[referenceフィールド初期化]
    B --> C[writeNode再帰処理開始]
    C --> D{ノードタイプ判定}
    D -->|ArrayNode| E[子ノード走査]
    D -->|PrototypedArrayNode| F[プロトタイプ処理]
    D -->|スカラーノード| G[属性として出力]
    E --> H[コメント出力]
    F --> H
    H --> I[開始タグ+属性出力]
    I --> J{子要素あり?}
    J -->|Yes| K[子要素を再帰処理]
    J -->|No| L[自己閉じタグ]
    K --> M[終了タグ出力]
    L --> N[完了]
    M --> N
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 型エラー | ConfigurationInterface未実装オブジェクトの渡し | PHP TypeError | 正しいConfigurationInterface実装を渡す |
| ノードエラー | 不正なNodeInterface実装 | PHP Error | 正しいNodeInterface実装を渡す |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数百ノード（Bundle設定項目数） |
| 目標出力時間 | 100ms以内 |
| 同時出力数上限 | 制限なし（メモリ依存） |

## セキュリティ考慮事項

本帳票は設定リファレンスの出力であり、機密情報を含まない。ただし、設定項目のデフォルト値にパスワードやAPIキーが含まれる場合は注意が必要。通常、開発環境でのみ使用される。

## 備考

- YamlReferenceDumperと対になるクラスであり、出力形式のみ異なる
- XML Remote Mapping（`getXmlRemappings()`）に対応し、複数形/単数形のマッピングを処理する
- `writeValue()` メソッドで、bool/null/array等のPHP型をXML属性値文字列に変換する

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、設定ツリーを構成するNodeクラス群を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ConfigurationInterface.php | `src/Symfony/Component/Config/Definition/ConfigurationInterface.php` | 設定ツリーのルートインターフェース。`getConfigTreeBuilder()`で設定ツリーを構築 |
| 1-2 | NodeInterface.php | `src/Symfony/Component/Config/Definition/NodeInterface.php` | ノードの基本インターフェース。getName(), getDefaultValue(), isRequired()等 |
| 1-3 | ArrayNode.php | `src/Symfony/Component/Config/Definition/ArrayNode.php` | 複合ノード。子ノードを持ちXML要素にマッピングされる |
| 1-4 | PrototypedArrayNode.php | `src/Symfony/Component/Config/Definition/PrototypedArrayNode.php` | プロトタイプパターンの配列ノード。動的な設定項目に対応 |

**読解のコツ**: Symfonyの設定ツリーはCompositeパターンで構成されている。ArrayNodeが枝ノード、ScalarNode/BooleanNode等が葉ノードに相当する。

#### Step 2: エントリーポイントを理解する

処理の起点となるXmlReferenceDumperクラスのpublicメソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | XmlReferenceDumper.php | `src/Symfony/Component/Config/Definition/Dumper/XmlReferenceDumper.php` | メインクラス。dump()とdumpNode()が公開API |

**主要処理フロー**:
1. **34行目**: `dump()` - ConfigurationInterfaceから設定ツリーを取得し`dumpNode()`に委譲
2. **39行目**: `dumpNode()` - referenceフィールドを初期化し`writeNode()`を呼び出し
3. **49行目**: `writeNode()` - 再帰的にノードツリーを走査しXML出力を構築

#### Step 3: XML出力ロジックを理解する

writeNode()の内部処理を詳しく読む。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | XmlReferenceDumper.php | `src/Symfony/Component/Config/Definition/Dumper/XmlReferenceDumper.php` | writeNode()メソッド（49-244行目） |

**主要処理フロー**:
- **51-52行目**: ルートノード名とネームスペースの決定
- **55-62行目**: XML Remappingの処理（親ノードのXmlRemappingsから単数形名を取得）
- **63行目**: アンダースコアをハイフンに変換
- **70-115行目**: ArrayNode/PrototypedArrayNodeの子ノード分類（属性 vs 子要素）
- **118-165行目**: 子ノードの走査、コメント情報の収集、属性値の取得
- **170-193行目**: コメントの出力（ルートコメント、属性コメント）
- **196-229行目**: 開始タグと属性の出力（単一属性/複数属性で形式が変わる）
- **232-235行目**: 子要素の再帰出力
- **238-243行目**: 終了タグの出力

### プログラム呼び出し階層図

```
XmlReferenceDumper::dump(ConfigurationInterface, ?string)
    |
    +-- ConfigurationInterface::getConfigTreeBuilder()
    |       +-- TreeBuilder::buildTree() -> NodeInterface
    |
    +-- XmlReferenceDumper::dumpNode(NodeInterface, ?string)
            |
            +-- XmlReferenceDumper::writeNode(NodeInterface, int, bool, ?string)  [再帰]
                    |
                    +-- ArrayNode::getChildren()
                    +-- BaseNode::getInfo()
                    +-- BaseNode::getExample()
                    +-- NodeInterface::isRequired()
                    +-- BaseNode::isDeprecated()
                    +-- EnumNode::getPermissibleValues()
                    +-- NodeInterface::hasDefaultValue()
                    +-- NodeInterface::getDefaultValue()
                    +-- PrototypedArrayNode::getPrototype()
                    +-- PrototypedArrayNode::getKeyAttribute()
                    +-- ArrayNode::getXmlRemappings()
                    +-- XmlReferenceDumper::writeLine(string, int)
                    +-- XmlReferenceDumper::writeValue(mixed)
                    +-- XmlReferenceDumper::writeNode()  [再帰呼び出し]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ConfigurationInterface -----> getConfigTreeBuilder() ----+
                              buildTree()                |
                                                         v
NodeInterface (root) -------> writeNode() [再帰処理]
                                |
                                +-- getChildren() -------> 子ノード分類
                                +-- getInfo() -----------> コメント生成
                                +-- getDefaultValue() ---> 属性値生成
                                +-- writeLine() ---------> reference文字列
                                                                |
                                                                v
                                                    XML Reference String ---> 標準出力/文字列返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| XmlReferenceDumper.php | `src/Symfony/Component/Config/Definition/Dumper/XmlReferenceDumper.php` | ソース | メインDumperクラス（292行） |
| YamlReferenceDumper.php | `src/Symfony/Component/Config/Definition/Dumper/YamlReferenceDumper.php` | ソース | 対となるYAML形式Dumper |
| ConfigurationInterface.php | `src/Symfony/Component/Config/Definition/ConfigurationInterface.php` | ソース | 設定ツリー定義インターフェース |
| NodeInterface.php | `src/Symfony/Component/Config/Definition/NodeInterface.php` | ソース | ノードインターフェース |
| ArrayNode.php | `src/Symfony/Component/Config/Definition/ArrayNode.php` | ソース | 複合ノードクラス |
| PrototypedArrayNode.php | `src/Symfony/Component/Config/Definition/PrototypedArrayNode.php` | ソース | プロトタイプ配列ノードクラス |
| BaseNode.php | `src/Symfony/Component/Config/Definition/BaseNode.php` | ソース | ノード基底クラス（info, example, deprecated等） |
| ScalarNode.php | `src/Symfony/Component/Config/Definition/ScalarNode.php` | ソース | スカラー値ノード |
| BooleanNode.php | `src/Symfony/Component/Config/Definition/BooleanNode.php` | ソース | 真偽値ノード |
| EnumNode.php | `src/Symfony/Component/Config/Definition/EnumNode.php` | ソース | 列挙値ノード |
| IntegerNode.php | `src/Symfony/Component/Config/Definition/IntegerNode.php` | ソース | 整数ノード |
| FloatNode.php | `src/Symfony/Component/Config/Definition/FloatNode.php` | ソース | 浮動小数点ノード |
