# 帳票設計書 23-CLI変数ダンプ

## 概要

本ドキュメントは、Symfony VarDumperコンポーネントにおける `CliDumper` クラスの帳票設計書である。PHPの変数情報をCLI（ターミナル）向けにANSIカラーコード付きテキストで出力する機能について、出力仕様・処理フロー・データ構造を定義する。

### 本帳票の処理概要

`CliDumper` は、VarDumperコンポーネントのCloner（VarCloner）で取得されたDataオブジェクトを、ターミナル上で閲覧しやすいANSIカラー付きテキスト形式に変換するクラスである。AbstractDumperを継承し、変数の型に応じた色分け・インデント・省略表示機能を備えた、CLI環境向けの変数表示を提供する。

**業務上の目的・背景**：CLIで実行されるSymfonyコマンドやバッチ処理のデバッグにおいて、複雑なオブジェクト構造や配列の内容をターミナル上で効率的に把握する必要がある。CliDumperは、ANSIエスケープシーケンスによる色分け表示で、型情報・アクセス修飾子・参照情報を視覚的に区別可能にし、CLIデバッグの効率を大幅に向上させる。

**帳票の利用シーン**：CLIコマンド実行中に `dump()` 関数が呼ばれた際、`var_dump()` の代替として、テスト実行時のデバッグ出力として使用される。

**主要な出力内容**：
1. ANSIカラーコード付きのテキスト変数ダンプ
2. 型に応じた色分け（数値=青、文字列=緑、参照=灰色等）
3. インデント付きの階層構造表示
4. オブジェクトプロパティのアクセス修飾子表示（+public, #protected, -private）
5. 制御文字・Unicode不可視文字の可視化表示

**帳票の出力タイミング**：CLIモードで `dump()` ヘルパー関数が呼び出された際、またはCliDumperが明示的にインスタンス化されて使用された際に出力される。

**帳票の利用者**：バックエンド開発者、DevOpsエンジニア、テストエンジニア

## 帳票種別

デバッグ情報ダンプ（CLIテキスト出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIコマンド | N/A（ターミナル） | `dump()` 関数呼び出し |
| - | PHPUnit等テスト | N/A | `dump()` 関数呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（ANSIカラーコード付き） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力 php://stdout） |
| 出力方法 | 標準出力 / 文字列返却 |
| 文字コード | UTF-8 |

### PDF固有設定

該当なし

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

ANSIカラー付きテキストで、インデントにより階層構造を表現する。

```
┌─────────────────────────────────────┐
│  ClassName {#refId                   │
│    +publicProp: "value"              │
│    #protectedProp: 123               │
│    -privateProp: true                │
│    +arrayProp: [                     │
│      0 => "item1"                    │
│      1 => "item2"                    │
│    ]                                 │
│  }                                   │
└─────────────────────────────────────┘
```

### ヘッダー部

該当なし（行ヘッダーなし。各ダンプ出力は直接オブジェクト/値から開始する）

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | クラス名/型情報 | オブジェクトクラス名、配列サイズ | `Cursor` の `class` パラメータ | ANSIカラー `note` スタイル | 可変 |
| 2 | プロパティキー | プロパティ名またはインデックス | `Cursor::hashKey` | `+`(public) / `#`(protected) / `-`(private) 接頭辞 | 可変 |
| 3 | スカラー値 | 整数/浮動小数点/ブール/null | `dumpScalar()` パラメータ | ANSIカラー `num`/`const` スタイル | 可変 |
| 4 | 文字列値 | 文字列内容 | `dumpString()` パラメータ | ANSIカラー `str` スタイル、ダブルクォート囲み | 可変 |
| 5 | 参照情報 | オブジェクト/リソース参照ID | `Cursor::softRefHandle` | `#id` / `@id` / `&id` 形式 | 可変 |

### フッター部

該当なし

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Dataオブジェクト | VarClonerで取得された変数データ | Yes |
| 出力先 | callable/resource/string/null | No（デフォルト: php://stdout） |
| カラー有効化 | ターミナルがANSIカラーをサポートするか自動検出 | No（自動検出） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | プロパティ定義順 | 定義順（Cloner取得順） |

### 改ページ条件

該当なし

## データベース参照仕様

### 参照テーブル一覧

該当なし

### テーブル別参照項目詳細

該当なし

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| カラーサポート判定 | `supportsColors()` の多段チェック | なし | NO_COLOR/FORCE_COLOR環境変数、stream_isatty()、TERM変数等 |
| 文字列長表示 | `mb_strlen($str, 'UTF-8') + $cut` | なし | DUMP_STRING_LENGTHフラグ有効時に表示 |
| Windows True Color判定 | `ANSICON_VER >= 183` or `ConEmuANSI=ON` or `TERM=xterm` | なし | Windows環境のカラーサポート判定 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[dump Data呼び出し] --> B[AbstractDumper::dump]
    B --> C[Data::dump DumperInterface]
    C --> D{要素タイプ}
    D -->|Scalar| E[dumpScalar]
    D -->|String| F[dumpString]
    D -->|Hash開始| G[enterHash]
    D -->|Hash終了| H[leaveHash]
    E --> I[dumpKey: キー出力]
    F --> I
    G --> I
    I --> J[style: ANSIカラー装飾]
    J --> K[dumpLine: 行出力]
    K --> L{カラーサポート?}
    L -->|Yes| M[ANSIエスケープ付加]
    L -->|No| N[プレーンテキスト]
    M --> O[lineDumper callback]
    N --> O
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 出力ストリームエラー | 無効なストリームリソースへの書き込み | PHP Warning | 有効なストリームを指定 |
| 文字コード変換エラー | 非UTF-8文字列の変換失敗 | なし（フォールバック処理あり） | utf8Encode()で自動変換 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千プロパティ |
| 目標出力時間 | 30ms以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- CLI出力のため、XSSリスクはないが、ダンプ内容に機密情報が含まれる可能性がある
- 本番環境ではdump()呼び出しを残さないこと
- fileLinkFormatによりローカルファイルパスがOSCハイパーリンクとして出力される場合がある

## 備考

- HtmlDumperの親クラスとして機能し、ANSIカラーコードによる装飾を担当
- Windows環境ではANSICON/ConEmu/Windows 10 VT100対応を自動検出
- `NO_COLOR` 環境変数（https://no-color.org/）および `FORCE_COLOR` 環境変数（https://force-color.org/）に対応
- `maxStringWidth` で文字列の1行あたりの最大表示幅を制限可能
- 制御文字は `\t`, `\n`, `\r` 等のエスケープ記法で可視化される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Data.php | `src/Symfony/Component/VarDumper/Cloner/Data.php` | ダンプ対象のデータ構造 |
| 1-2 | Cursor.php | `src/Symfony/Component/VarDumper/Cloner/Cursor.php` | hashKey, hashType, attr, softRefHandle等の走査状態 |
| 1-3 | Stub.php | `src/Symfony/Component/VarDumper/Cloner/Stub.php` | ARRAY_INDEXED, ARRAY_ASSOC等の定数定義 |

**読解のコツ**: `Cursor::hashType` がHASH_OBJECT/HASH_RESOURCE/HASH_INDEXED/HASH_ASSOCのいずれかで、出力形式が変わる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractDumper.php | `src/Symfony/Component/VarDumper/Dumper/AbstractDumper.php` | dump()メソッド（123-155行目）が全体制御 |

**主要処理フロー**:
1. **123行目**: `dump()` - 出力先切替、ロケール設定
2. **136行目**: `$data->dump($this)` - Visitorパターンで各要素を走査
3. **137行目**: `$this->dumpLine(-1)` - ダンプ終了通知

#### Step 3: CliDumper固有の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CliDumper.php | `src/Symfony/Component/VarDumper/Dumper/CliDumper.php` | dumpScalar(126行目), dumpString(187行目), enterHash(276行目), leaveHash(313行目), style(434行目) |

**主要処理フロー**:
- **68-88行目**: コンストラクタ - Windows環境での基本16色フォールバック、fileLinkFormat設定
- **126-185行目**: `dumpScalar()` - 型判定（integer/double/NULL/boolean等）と適切なスタイル適用
- **187-274行目**: `dumpString()` - 複数行文字列の三連クォート表示、バイナリ文字列対応
- **276-311行目**: `enterHash()` - オブジェクト/配列/リソースの開始括弧と参照情報出力
- **313-321行目**: `leaveHash()` - 閉じ括弧出力
- **345-425行目**: `dumpKey()` - プロパティキーの装飾（public/protected/private/meta）
- **434-518行目**: `style()` - ANSIエスケープシーケンスの付加、制御文字可視化、OSCハイパーリンク
- **520-557行目**: `supportsColors()` - カラーサポート自動検出

### プログラム呼び出し階層図

```
CliDumper::dump(Data, $output)
    |
    +-- AbstractDumper::dump(Data, $output)
            |
            +-- Data::dump(CliDumper)
            |       |
            |       +-- CliDumper::dumpScalar(Cursor, type, value)
            |       |       +-- dumpKey(Cursor)
            |       |       +-- style(style, value, attr)
            |       |       +-- endValue(Cursor)
            |       |
            |       +-- CliDumper::dumpString(Cursor, str, bin, cut)
            |       |       +-- dumpKey(Cursor)
            |       |       +-- style('str', str, attr)
            |       |       +-- dumpLine(depth)
            |       |
            |       +-- CliDumper::enterHash(Cursor, type, class, hasChild)
            |       |       +-- dumpKey(Cursor)
            |       |       +-- style('note', class, attr)
            |       |       +-- style('ref', refInfo, attr)
            |       |
            |       +-- CliDumper::leaveHash(Cursor, type, class, hasChild, cut)
            |               +-- dumpEllipsis(Cursor, hasChild, cut)
            |               +-- endValue(Cursor)
            |
            +-- CliDumper::dumpLine(depth)
                    +-- supportsColors() [遅延初期化]
                    +-- ANSI装飾付加
                    +-- AbstractDumper::dumpLine(depth)
                            +-- lineDumper callback
```

### データフロー図

```
[入力]                    [処理]                           [出力]

PHP変数 -----> VarCloner::cloneVar() -----> Data
                                              |
                                              v
Data -----> CliDumper::dump()
                |
                +-- Data::dump(this)
                |       |
                |       +-- dumpScalar() --> style() --> ANSI colored text
                |       +-- dumpString() --> style() --> ANSI colored text
                |       +-- enterHash()  --> style() --> ANSI colored text
                |       +-- leaveHash()  --> endValue()
                |
                +-- dumpLine(depth)
                        |
                        +-- supportsColors() --> ANSI escape sequences
                        +-- echoLine() --------> php://stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CliDumper.php | `src/Symfony/Component/VarDumper/Dumper/CliDumper.php` | ソース | メインクラス（667行） |
| AbstractDumper.php | `src/Symfony/Component/VarDumper/Dumper/AbstractDumper.php` | ソース | 基底クラス（232行） |
| HtmlDumper.php | `src/Symfony/Component/VarDumper/Dumper/HtmlDumper.php` | ソース | 子クラス（HTML版） |
| Data.php | `src/Symfony/Component/VarDumper/Cloner/Data.php` | ソース | ダンプ対象データ構造 |
| Cursor.php | `src/Symfony/Component/VarDumper/Cloner/Cursor.php` | ソース | 走査状態カーソル |
| Stub.php | `src/Symfony/Component/VarDumper/Cloner/Stub.php` | ソース | 定数定義 |
| FileLinkFormatter.php | `src/Symfony/Component/ErrorHandler/ErrorRenderer/FileLinkFormatter.php` | ソース | ファイルリンク生成 |
