# 帳票設計書 30-コンパイル済みURLジェネレーターダンプ

## 概要

本ドキュメントは、Symfony Routingコンポーネントにおける `CompiledUrlGeneratorDumper` クラスの帳票設計書である。ルーティング定義をコンパイル済みPHP配列として出力し、URL生成の高速化に使用される機能について、出力仕様・処理フロー・データ構造を定義する。

### 本帳票の処理概要

`CompiledUrlGeneratorDumper` は、RouteCollectionに登録されたルーティング定義を、CompiledUrlGeneratorが使用可能な最適化されたPHP配列としてダンプするクラスである。各ルートのコンパイル済み情報（変数、デフォルト値、要件、トークン、ホストトークン、スキーム）をPHP配列としてエクスポートし、ルートエイリアスの解決と非推奨警告の処理も行う。

**業務上の目的・背景**：Symfonyアプリケーションでは、テンプレートやコントローラーから頻繁にURLを生成する。リクエストごとにルーティング定義ファイルを解析してURL生成用情報を構築するのは非効率である。CompiledUrlGeneratorDumperは、ルーティング定義を事前にコンパイルしてPHPファイルとして出力し、本番環境でのURL生成を高速化する。

**帳票の利用シーン**：キャッシュのウォームアップ時（`cache:warmup`コマンド）、ルーティングキャッシュの再構築時に自動的に実行される。

**主要な出力内容**：
1. ルート名をキーとしたコンパイル済みルート情報配列
2. 各ルートの変数リスト、デフォルト値、要件、トークン、ホストトークン、スキーム
3. ルートエイリアスの解決結果（非推奨情報を含む）

**帳票の出力タイミング**：`cache:warmup` コマンド実行時、ルーティングキャッシュが無効な状態での初回リクエスト時にダンプが生成される。

**帳票の利用者**：Symfony Router（内部利用）、URL生成処理

## 帳票種別

コンパイル済み設定ファイル（PHP配列出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIコマンド | `php bin/console cache:warmup` | 自動生成 |
| - | 初回リクエスト | 任意のURL | 自動生成（キャッシュミス時） |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PHP（配列を返すPHPファイル） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | `var/cache/{env}/url_generating_routes.php`（環境依存） |
| 出力方法 | ファイル書き込み |
| 文字コード | UTF-8 |

### PDF固有設定

該当なし

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

PHPファイルとしてreturn文で連想配列を返す形式。ルート名をキー、コンパイル結果を値とする。

```
┌─────────────────────────────────────┐
│  <?php                               │
│                                      │
│  // Auto-generated by Symfony        │
│  // Routing Component                │
│                                      │
│  return [                            │
│    'route_name' => [                 │
│      [variables],                    │
│      {defaults},                     │
│      {requirements},                 │
│      [[tokens]],                     │
│      [[hostTokens]],                 │
│      [schemes],                      │
│      [],                             │
│    ],                                │
│    'alias_name' => [                 │
│      ...                             │
│      [{deprecation_info}],           │
│    ],                                │
│  ];                                  │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | PHPタグ | PHPファイル開始 | 固定 | `<?php` |
| 2 | 自動生成コメント | 生成元情報 | 固定テンプレート | PHPコメント |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ルート名 | ルーティング名称 | `RouteCollection::all()` のキー | PHP文字列キー | 可変 |
| 2 | variables | ルートのパス変数リスト | `CompiledRoute::getVariables()` | PHP配列 | 可変 |
| 3 | defaults | ルートのデフォルト値 | `Route::getDefaults()` | PHP連想配列 | 可変 |
| 4 | requirements | ルートの要件（正規表現制約） | `Route::getRequirements()` | PHP連想配列 | 可変 |
| 5 | tokens | パストークン配列 | `CompiledRoute::getTokens()` | PHP配列 | 可変 |
| 6 | hostTokens | ホストトークン配列 | `CompiledRoute::getHostTokens()` | PHP配列 | 可変 |
| 7 | schemes | 許可されるスキーム | `Route::getSchemes()` | PHP配列 | 可変 |
| 8 | deprecations | エイリアスの非推奨情報 | `RouteAlias::getDeprecation()` | PHP配列（空または非推奨情報） | 可変 |

### フッター部

該当なし

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| RouteCollection | ルーティング定義コレクション | Yes（コンストラクタ注入） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ルート定義順 | RouteCollectionの登録順 |
| 2 | エイリアス | ルートの後にエイリアスが追加される |

### 改ページ条件

該当なし

## データベース参照仕様

### 参照テーブル一覧

該当なし

### テーブル別参照項目詳細

該当なし

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| エイリアス解決 | エイリアスチェーンを辿りターゲットルートを特定 | なし | 循環参照チェック付き |
| 非推奨情報収集 | エイリアスチェーン中の全deprecationを収集 | なし | package, version, messageを含む |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[dump呼び出し] --> B[getCompiledRoutes]
    B --> C[RouteCollection::all 走査]
    C --> D[各ルートをcompile]
    D --> E[7要素配列生成]
    E --> F[getCompiledAliases]
    F --> G[エイリアス走査]
    G --> H{循環参照チェック}
    H -->|循環あり| I[RouteCircularReferenceException]
    H -->|循環なし| J[ターゲットルート解決]
    J --> K{ターゲット存在?}
    K -->|No| L[RouteNotFoundException]
    K -->|Yes| M[エイリアス用配列生成]
    M --> N[generateDeclaredRoutes]
    N --> O[CompiledUrlMatcherDumper::export で値エクスポート]
    O --> P[PHPファイルテンプレートに埋め込み]
    P --> Q[PHP文字列返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 循環参照 | エイリアスが循環している | `RouteCircularReferenceException` | エイリアス定義の循環を修正 |
| ルート未発見 | エイリアスのターゲットルートが存在しない | `Target route "%s" for alias "%s" does not exist.` (RouteNotFoundException) | ターゲットルートを定義 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千ルート + エイリアス |
| 目標出力時間 | 数秒以内（キャッシュウォームアップ時の1回実行） |
| 同時出力数上限 | 1（キャッシュ生成は排他的） |

## セキュリティ考慮事項

- 生成されるPHPファイルはincludeで実行されるため、キャッシュディレクトリの書き込み権限を適切に管理すること
- キャッシュファイルにルーティング定義のデフォルト値が含まれる
- 非推奨エイリアスの情報にはpackage名・バージョンが含まれる

## 備考

- `CompiledUrlMatcherDumper::export()` を再利用して値のPHPエクスポートを行う
- エイリアスチェーンの途中にdeprecationがある場合、全てのdeprecationを収集して配列に含める
- エイリアスチェーン走査中に `trigger_deprecation()` が呼ばれ、非推奨警告がダンプ時に発行される
- URLマッチャーダンプ（No.29）と対になるクラスであり、URL生成用の情報をダンプする

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RouteCollection.php | `src/Symfony/Component/Routing/RouteCollection.php` | ルーティング定義。all(), getAliases(), getAlias(), get() |
| 1-2 | Route.php | `src/Symfony/Component/Routing/Route.php` | ルート定義。compile(), getDefaults(), getRequirements(), getSchemes() |
| 1-3 | CompiledRoute.php | `src/Symfony/Component/Routing/CompiledRoute.php` | コンパイル結果。getVariables(), getTokens(), getHostTokens() |
| 1-4 | RouteAlias.php | `src/Symfony/Component/Routing/Alias.php` | ルートエイリアス。getId(), isDeprecated(), getDeprecation() |

**読解のコツ**: CompiledUrlGeneratorDumperの出力は、CompiledUrlGeneratorが読み込んで使用する。URL生成に必要な情報（トークン、変数、デフォルト値等）を事前計算してキャッシュする仕組み。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CompiledUrlGeneratorDumper.php | `src/Symfony/Component/Routing/Generator/Dumper/CompiledUrlGeneratorDumper.php` | dump()（91-102行目）がエントリーポイント |
| 2-2 | GeneratorDumper.php | `src/Symfony/Component/Routing/Generator/Dumper/GeneratorDumper.php` | 基底クラス。RouteCollectionの保持 |

**主要処理フロー**:
1. **91行目**: `dump()` - PHPファイルテンプレートに `generateDeclaredRoutes()` の結果を埋め込み
2. **27-45行目**: `getCompiledRoutes()` - 全ルートを走査しcompile、7要素配列を生成
3. **47-89行目**: `getCompiledAliases()` - エイリアスを走査、循環参照チェック、ターゲット解決、非推奨情報収集

#### Step 3: エイリアス解決ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CompiledUrlGeneratorDumper.php | `src/Symfony/Component/Routing/Generator/Dumper/CompiledUrlGeneratorDumper.php` | getCompiledAliases()（47-89行目）の詳細 |

**主要処理フロー**:
- **51行目**: エイリアスごとにループ開始
- **52行目**: 非推奨情報の収集
- **53-68行目**: エイリアスチェーンの辿り。whileループでalias→alias→...→実ルートを解決
- **56-59行目**: 循環参照チェック（visitedリストで検出、RouteCircularReferenceException）
- **62-64行目**: チェーン途中のdeprecationも収集、`trigger_deprecation()`発行
- **71-73行目**: ターゲットルートの存在チェック（RouteNotFoundException）
- **75-86行目**: ターゲットルートのコンパイル結果を使用してエイリアス用配列を生成

### プログラム呼び出し階層図

```
CompiledUrlGeneratorDumper::dump()
    |
    +-- generateDeclaredRoutes()
            |
            +-- getCompiledRoutes()
            |       |
            |       +-- RouteCollection::all()
            |       +-- foreach: Route::compile()
            |       |       +-- CompiledRoute::getVariables()
            |       |       +-- CompiledRoute::getTokens()
            |       |       +-- CompiledRoute::getHostTokens()
            |       +-- [name => [vars, defaults, requirements, tokens, hostTokens, schemes, []]]
            |
            +-- getCompiledAliases()
            |       |
            |       +-- RouteCollection::getAliases()
            |       +-- foreach: Alias解決
            |       |       +-- 循環参照チェック (visited配列)
            |       |       +-- RouteCollection::getAlias()
            |       |       +-- Alias::isDeprecated() → getDeprecation()
            |       |       +-- trigger_deprecation()
            |       |       +-- RouteCollection::get() → Route
            |       |       +-- Route::compile() → CompiledRoute
            |       +-- [alias => [vars, defaults, requirements, tokens, hostTokens, schemes, deprecations]]
            |
            +-- CompiledUrlMatcherDumper::export()  [値のPHPエクスポート]
```

### データフロー図

```
[入力]                          [処理]                          [出力]

RouteCollection -----> getCompiledRoutes()
                          |
                          +-- Route::compile()
                          |       |
                          |       v
                          |   CompiledRoute
                          |       |
                          v       v
                    [name => 7要素配列]
                          |
RouteCollection -----> getCompiledAliases()
(aliases)                 |
                          +-- エイリアスチェーン解決
                          +-- 循環参照チェック
                          +-- 非推奨情報収集
                          |
                          v
                    [alias => 7要素配列(+deprecations)]
                          |
                          v
               generateDeclaredRoutes()
                          |
                          +-- export() [PHPエクスポート]
                          |
                          v
               PHP配列文字列 -----> var/cache/{env}/url_generating_routes.php
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CompiledUrlGeneratorDumper.php | `src/Symfony/Component/Routing/Generator/Dumper/CompiledUrlGeneratorDumper.php` | ソース | メインクラス（121行） |
| GeneratorDumper.php | `src/Symfony/Component/Routing/Generator/Dumper/GeneratorDumper.php` | ソース | 基底クラス（32行） |
| GeneratorDumperInterface.php | `src/Symfony/Component/Routing/Generator/Dumper/GeneratorDumperInterface.php` | ソース | インターフェース |
| CompiledUrlGenerator.php | `src/Symfony/Component/Routing/Generator/CompiledUrlGenerator.php` | ソース | ダンプ結果の利用クラス |
| CompiledUrlMatcherDumper.php | `src/Symfony/Component/Routing/Matcher/Dumper/CompiledUrlMatcherDumper.php` | ソース | export()メソッドの提供元 |
| RouteCollection.php | `src/Symfony/Component/Routing/RouteCollection.php` | ソース | ルーティング定義コレクション |
| Route.php | `src/Symfony/Component/Routing/Route.php` | ソース | 個別ルート定義 |
| CompiledRoute.php | `src/Symfony/Component/Routing/CompiledRoute.php` | ソース | コンパイル済みルート |
| RouteCircularReferenceException.php | `src/Symfony/Component/Routing/Exception/RouteCircularReferenceException.php` | ソース | 循環参照例外 |
| RouteNotFoundException.php | `src/Symfony/Component/Routing/Exception/RouteNotFoundException.php` | ソース | ルート未発見例外 |
