# 帳票設計書 6-JSON翻訳ファイル

## 概要

Symfonyの翻訳コンポーネントにおけるJSON形式の翻訳ファイル出力機能の設計書である。メッセージカタログをJSON形式のテキストファイルとして出力する。

### 本帳票の処理概要

本帳票は、Symfonyアプリケーション内部のメッセージカタログ（MessageCatalogue）に格納された翻訳メッセージを、JSON形式のテキストファイルとして出力する機能を提供する。

**業務上の目的・背景**：JSON（JavaScript Object Notation）は、Web技術の標準的なデータ交換フォーマットであり、フロントエンドのJavaScript/TypeScriptアプリケーションとの翻訳データ共有に最適である。i18next、react-intl等のフロントエンド国際化ライブラリがJSON形式の翻訳ファイルを標準サポートしており、本帳票によりSymfonyバックエンドとフロントエンドの間で翻訳リソースを共有できる。

**帳票の利用シーン**：フロントエンド国際化ライブラリとの翻訳データ共有時、API経由での翻訳データ提供時、翻訳管理サービスとのJSON形式でのデータ交換時、軽量な翻訳リソース管理が必要な場合に利用される。

**主要な出力内容**：
1. JSON形式のkey-valueオブジェクト
2. Pretty Print形式での出力（デフォルト）
3. json_encodingオプションによるエンコーディング制御

**帳票の出力タイミング**：`translation:update`コマンド実行時（format指定）、またはプログラム内から`JsonFileDumper::dump()`メソッドを呼び出した時に出力される。

**帳票の利用者**：アプリケーション開発者、フロントエンドエンジニア、翻訳者

## 帳票種別

翻訳データファイル（JSONテキスト）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `php bin/console translation:update` | コマンド実行（--output-format=json） |
| N/A | プログラムAPI | `JsonFileDumper::dump()` | メソッド呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | `%domain%.%locale%.json`（デフォルト） |
| 出力方法 | ファイルシステムへの書き込み（file_put_contents） |
| 文字コード | UTF-8（json_encodeデフォルト） |

### JSON固有設定

| 項目 | 内容 |
|-----|------|
| デフォルトエンコーディングフラグ | JSON_PRETTY_PRINT |
| カスタムフラグ | options['json_encoding']で指定可能 |

## 帳票レイアウト

### レイアウト概要

JSONオブジェクトとしてキーと値のペアが出力される。

```
┌─────────────────────────────────────┐
│ {                                    │
│     "key1": "value1",                │
│     "key2": "value2",                │
│     "key3": "value3"                 │
│ }                                    │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | なし | JSONファイルにヘッダーは存在しない | - | - |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | key | 翻訳キー | MessageCatalogue::all($domain)のキー | JSON文字列キー | 可変 |
| 2 | value | 翻訳値 | MessageCatalogue::all($domain)の値 | JSON文字列値 | 可変 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | なし | JSONファイルにフッターは存在しない | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| path | 出力先ディレクトリパス | Yes |
| json_encoding | json_encodeフラグ（デフォルト: JSON_PRETTY_PRINT） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | メッセージカタログの格納順 | 格納順（挿入順） |

### 改ページ条件

N/A（データファイルのため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | 本帳票はデータベースを直接参照しない | - |

### テーブル別参照項目詳細

#### MessageCatalogue（入力データ構造）

| 参照項目（プロパティ） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| messages[$domain] | JSONオブジェクト | all($domain) | ドメイン別メッセージ配列 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| N/A | json_encode($data, $flags)のみ | N/A | PHPのjson_encode関数がすべてのフォーマット処理を行う |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[dump呼び出し] --> B{pathオプション存在?}
    B -->|No| C[InvalidArgumentException]
    B -->|Yes| D[ドメインループ開始]
    D --> E[formatCatalogue呼び出し]
    E --> F[json_encodingオプション取得]
    F --> G[json_encode実行]
    G --> H[file_put_contentsで書き込み]
    H --> D
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| InvalidArgumentException | pathオプションが未指定 | "The file dumper needs a path option." | pathオプションを指定する |
| RuntimeException | 出力先ディレクトリの作成失敗 | 'Unable to create directory "%s".' | ディレクトリの書き込み権限を確認する |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千メッセージ/ドメイン |
| 目標出力時間 | 特に規定なし |
| 同時出力数上限 | 特に規定なし |

## セキュリティ考慮事項

- PHPのjson_encode関数がUnicodeエスケープとJSON文字列エスケープを適切に行う
- 出力先ディレクトリのパーミッションは0o777で作成される（umaskにより制限される）

## 備考

- 最もシンプルなDumper実装の一つ。formatCatalogue()はjson_encode()を呼び出すだけの4行実装
- json_encodingオプションでJSON_UNESCAPED_UNICODE等のフラグを指定し、日本語等のマルチバイト文字をエスケープなしで出力可能
- メタデータは出力に含まれない

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MessageCatalogue.php | `src/Symfony/Component/Translation/MessageCatalogue.php` | all($domain)の戻り値（key-value配列）を確認 |

**読解のコツ**: JsonFileDumperは極めてシンプルな実装のため、MessageCatalogueのall()メソッドが返す配列がそのままjson_encodeに渡される点を理解すればよい。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FileDumper.php | `src/Symfony/Component/Translation/Dumper/FileDumper.php` | dump()メソッドの共通処理フロー（41-77行目） |

#### Step 3: JSON固有のフォーマット処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | JsonFileDumper.php | `src/Symfony/Component/Translation/Dumper/JsonFileDumper.php` | formatCatalogue()の実装（23-28行目）を確認する |

**主要処理フロー**:
- **25行目**: json_encodingオプションの取得（デフォルト: JSON_PRETTY_PRINT）
- **27行目**: json_encode()による変換と返却

### プログラム呼び出し階層図

```
DumperInterface::dump()
    │
    └─ FileDumper::dump()                          [FileDumper.php:41]
           │
           ├─ MessageCatalogue::getDomains()        [MessageCatalogue.php:42]
           ├─ FileDumper::getRelativePath()          [FileDumper.php:93]
           │      └─ JsonFileDumper::getExtension()  [JsonFileDumper.php:30]
           └─ JsonFileDumper::formatCatalogue()      [JsonFileDumper.php:23]
                  │
                  ├─ MessageCatalogue::all($domain)   [MessageCatalogue.php:56]
                  └─ json_encode()                    [PHP組み込み関数]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

MessageCatalogue ───────▶ FileDumper::dump()
  └─ messages[domain]           │
                                ├─ ドメインループ
                options ────────▶     │
                  ├─ path              ├─ formatCatalogue()
                  └─ json_encoding     │     │
                                      │     └─ json_encode() ─────▶ {domain}.{locale}.json
                                      │                              （JSONオブジェクト）
                                      └─ file_put_contents()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DumperInterface.php | `src/Symfony/Component/Translation/Dumper/DumperInterface.php` | ソース | Dumperインターフェース定義 |
| FileDumper.php | `src/Symfony/Component/Translation/Dumper/FileDumper.php` | ソース | ファイル出力共通基底クラス |
| JsonFileDumper.php | `src/Symfony/Component/Translation/Dumper/JsonFileDumper.php` | ソース | JSON形式固有のフォーマット処理 |
| MessageCatalogue.php | `src/Symfony/Component/Translation/MessageCatalogue.php` | ソース | メッセージカタログデータ構造 |
| MessageCatalogueInterface.php | `src/Symfony/Component/Translation/MessageCatalogueInterface.php` | ソース | メッセージカタログインターフェース |
