# 帳票設計書 7-PHP翻訳ファイル

## 概要

Symfonyの翻訳コンポーネントにおけるPHP配列形式の翻訳ファイル出力機能の設計書である。メッセージカタログをPHPの配列を返すファイルとして出力する。

### 本帳票の処理概要

本帳票は、Symfonyアプリケーション内部のメッセージカタログ（MessageCatalogue）に格納された翻訳メッセージを、`return array(...)`形式のPHPファイルとして出力する機能を提供する。

**業務上の目的・背景**：PHP配列形式の翻訳ファイルは、PHPのOPcacheによるキャッシュが効くため、本番環境での高速な翻訳データ読み込みが可能である。XMLやYAMLのパース処理が不要であり、require/includeで直接読み込めるため、パフォーマンスに優れる。Laravel等の他のPHPフレームワークでも広く採用されている形式であり、PHPエコシステム内での互換性が高い。

**帳票の利用シーン**：本番環境での高速翻訳データ読み込みが必要な場合、PHPネイティブフォーマットでの翻訳データ管理時、OPcacheによるキャッシュを活用したい場合、他のPHPフレームワーク（Laravel等）との翻訳データ共有時に利用される。

**主要な出力内容**：
1. `<?php`タグで始まるPHPファイル
2. `return array(...);`形式で翻訳データを配列として返す
3. var_export()によるPHP表現への変換

**帳票の出力タイミング**：`translation:update`コマンド実行時（format指定）、またはプログラム内から`PhpFileDumper::dump()`メソッドを呼び出した時に出力される。

**帳票の利用者**：アプリケーション開発者、DevOpsエンジニア

## 帳票種別

翻訳データファイル（PHPソースコード）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `php bin/console translation:update` | コマンド実行（--output-format=php） |
| N/A | プログラムAPI | `PhpFileDumper::dump()` | メソッド呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PHP |
| 用紙サイズ | N/A（ソースコードファイル） |
| 向き | N/A |
| ファイル名 | `%domain%.%locale%.php`（デフォルト） |
| 出力方法 | ファイルシステムへの書き込み（file_put_contents） |
| 文字コード | PHP実行環境に依存 |

### PHP固有設定

| 項目 | 内容 |
|-----|------|
| 開始タグ | `<?php` |
| 戻り値 | `return array(...);` |
| 配列表現 | var_export()による出力（array()形式） |

## 帳票レイアウト

### レイアウト概要

PHP配列形式で翻訳データが出力される。

```
┌─────────────────────────────────────┐
│ <?php                                │
│                                      │
│ return array (                       │
│   'key1' => 'value1',                │
│   'key2' => 'value2',                │
│   'key3' => 'value3',                │
│ );                                   │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | PHPタグ | PHP開始タグ | 固定値 | `<?php` |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | key | 翻訳キー | MessageCatalogue::all($domain)のキー | PHP文字列（シングルクォート） | 可変 |
| 2 | value | 翻訳値 | MessageCatalogue::all($domain)の値 | PHP文字列（シングルクォート） | 可変 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | なし | return文の閉じ括弧とセミコロンで終了 | - | `);` |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| path | 出力先ディレクトリパス | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | メッセージカタログの格納順 | 格納順（挿入順） |

### 改ページ条件

N/A（ソースコードファイルのため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | 本帳票はデータベースを直接参照しない | - |

### テーブル別参照項目詳細

#### MessageCatalogue（入力データ構造）

| 参照項目（プロパティ） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| messages[$domain] | PHP配列 | all($domain) | ドメイン別メッセージ配列 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| N/A | var_export($data, true)のみ | N/A | PHPのvar_export関数がすべての変換を行う |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[dump呼び出し] --> B{pathオプション存在?}
    B -->|No| C[InvalidArgumentException]
    B -->|Yes| D[ドメインループ開始]
    D --> E[formatCatalogue呼び出し]
    E --> F[var_exportで配列をPHP文字列に変換]
    F --> G[PHPタグとreturn文で囲む]
    G --> H[file_put_contentsで書き込み]
    H --> D
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| InvalidArgumentException | pathオプションが未指定 | "The file dumper needs a path option." | pathオプションを指定する |
| RuntimeException | 出力先ディレクトリの作成失敗 | 'Unable to create directory "%s".' | ディレクトリの書き込み権限を確認する |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千メッセージ/ドメイン |
| 目標出力時間 | 特に規定なし |
| 同時出力数上限 | 特に規定なし |

## セキュリティ考慮事項

- var_export()はPHPの配列・文字列表現を安全に生成するが、出力されたPHPファイルは実行可能コードであるため、出力先ディレクトリのアクセス制御に注意が必要
- 出力先ディレクトリのパーミッションは0o777で作成される（umaskにより制限される）
- 翻訳値に悪意のあるPHPコードが含まれていても、var_export()により文字列リテラルとしてエスケープされるため、コードインジェクションのリスクは低い

## 備考

- 最もシンプルなDumper実装。formatCatalogue()は1行の式で完結する
- var_export()は`array()`形式で出力するため、短縮配列記法`[]`は使用されない
- メタデータは出力に含まれない

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MessageCatalogue.php | `src/Symfony/Component/Translation/MessageCatalogue.php` | all($domain)の戻り値を確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FileDumper.php | `src/Symfony/Component/Translation/Dumper/FileDumper.php` | dump()メソッドの共通処理フロー（41-77行目） |

#### Step 3: PHP固有のフォーマット処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PhpFileDumper.php | `src/Symfony/Component/Translation/Dumper/PhpFileDumper.php` | formatCatalogue()の実装（23-26行目）を確認する |

**主要処理フロー**:
- **25行目**: `"<?php\n\nreturn " . var_export($messages->all($domain), true) . ";\n"` - PHPタグ + return文 + var_exportされた配列 + セミコロンで文字列を構築

### プログラム呼び出し階層図

```
DumperInterface::dump()
    │
    └─ FileDumper::dump()                          [FileDumper.php:41]
           │
           ├─ MessageCatalogue::getDomains()        [MessageCatalogue.php:42]
           ├─ FileDumper::getRelativePath()          [FileDumper.php:93]
           │      └─ PhpFileDumper::getExtension()   [PhpFileDumper.php:28]
           └─ PhpFileDumper::formatCatalogue()       [PhpFileDumper.php:23]
                  │
                  ├─ MessageCatalogue::all($domain)   [MessageCatalogue.php:56]
                  └─ var_export()                     [PHP組み込み関数]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

MessageCatalogue ───────▶ FileDumper::dump()
  └─ messages[domain]           │
                                ├─ ドメインループ
                options ────────▶     │
                  └─ path              ├─ formatCatalogue()
                                      │     │
                                      │     └─ var_export() ──────▶ {domain}.{locale}.php
                                      │                              （PHP配列ファイル）
                                      └─ file_put_contents()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DumperInterface.php | `src/Symfony/Component/Translation/Dumper/DumperInterface.php` | ソース | Dumperインターフェース定義 |
| FileDumper.php | `src/Symfony/Component/Translation/Dumper/FileDumper.php` | ソース | ファイル出力共通基底クラス |
| PhpFileDumper.php | `src/Symfony/Component/Translation/Dumper/PhpFileDumper.php` | ソース | PHP形式固有のフォーマット処理 |
| MessageCatalogue.php | `src/Symfony/Component/Translation/MessageCatalogue.php` | ソース | メッセージカタログデータ構造 |
| MessageCatalogueInterface.php | `src/Symfony/Component/Translation/MessageCatalogueInterface.php` | ソース | メッセージカタログインターフェース |
