# 帳票設計書 8-INI翻訳ファイル

## 概要

Symfonyの翻訳コンポーネントにおけるINI形式の翻訳ファイル出力機能の設計書である。メッセージカタログをINI形式のテキストファイルとして出力する。

### 本帳票の処理概要

本帳票は、Symfonyアプリケーション内部のメッセージカタログ（MessageCatalogue）に格納された翻訳メッセージを、INI形式のテキストファイルとして出力する機能を提供する。

**業務上の目的・背景**：INI（Initialization）ファイル形式は、設定ファイルとして古くから広く使われているシンプルなkey=value形式のフォーマットである。PHPのparse_ini_file()関数で直接読み込めるため、軽量な翻訳データ管理に適している。Windows環境で馴染みのある形式であり、テキストエディタでの直接編集が容易である。

**帳票の利用シーン**：シンプルな翻訳データのエクスポート時、レガシーシステムとのINI形式での翻訳データ交換時、テキストエディタでの手軽な翻訳データ編集が必要な場合に利用される。

**主要な出力内容**：
1. `key="value"`形式のINIエントリ
2. ダブルクォートで囲まれた翻訳値
3. 各エントリが改行で区切られたテキストファイル

**帳票の出力タイミング**：プログラム内から`IniFileDumper::dump()`メソッドを呼び出した時に出力される。

**帳票の利用者**：アプリケーション開発者

## 帳票種別

翻訳データファイル（INIテキスト）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | プログラムAPI | `IniFileDumper::dump()` | メソッド呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | INI |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | `%domain%.%locale%.ini`（デフォルト） |
| 出力方法 | ファイルシステムへの書き込み（file_put_contents） |
| 文字コード | PHP実行環境に依存 |

### INI固有設定

| 項目 | 内容 |
|-----|------|
| キー形式 | エスケープなしのそのままの文字列 |
| 値形式 | ダブルクォートで囲まれた文字列 |
| エスケープ | 値内のダブルクォートのみ`\"`にエスケープ |
| セクション | なし（フラットなkey=value形式） |

## 帳票レイアウト

### レイアウト概要

INI形式でキーと値のペアが1行ずつ出力される。

```
┌─────────────────────────────────────┐
│ key1="value1"                        │
│ key2="value2"                        │
│ key3="value with \"quotes\""         │
│ ...                                  │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | なし | INIファイルにヘッダーは出力されない | - | - |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | key | 翻訳キー | MessageCatalogue::all($domain)のキー | そのまま出力 | 可変 |
| 2 | value | 翻訳値 | MessageCatalogue::all($domain)の値 | ダブルクォート囲み（`"`エスケープ済み） | 可変 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | なし | INIファイルにフッターは存在しない | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| path | 出力先ディレクトリパス | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | メッセージカタログの格納順 | 格納順（挿入順） |

### 改ページ条件

N/A（データファイルのため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | 本帳票はデータベースを直接参照しない | - |

### テーブル別参照項目詳細

#### MessageCatalogue（入力データ構造）

| 参照項目（プロパティ） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| messages[$domain] | key="value"行 | all($domain) | ドメイン別メッセージ配列 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| エスケープ処理 | `str_replace('"', '\"', $target)` | N/A | 値内のダブルクォートをエスケープ |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[dump呼び出し] --> B{pathオプション存在?}
    B -->|No| C[InvalidArgumentException]
    B -->|Yes| D[ドメインループ開始]
    D --> E[formatCatalogue呼び出し]
    E --> F[メッセージループ]
    F --> G[ダブルクォートエスケープ]
    G --> H[key=value形式で文字列連結]
    H --> F
    F -->|ループ完了| I[file_put_contentsで書き込み]
    I --> D
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| InvalidArgumentException | pathオプションが未指定 | "The file dumper needs a path option." | pathオプションを指定する |
| RuntimeException | 出力先ディレクトリの作成失敗 | 'Unable to create directory "%s".' | ディレクトリの書き込み権限を確認する |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千メッセージ/ドメイン |
| 目標出力時間 | 特に規定なし |
| 同時出力数上限 | 特に規定なし |

## セキュリティ考慮事項

- ダブルクォートのエスケープのみ行われる。INIファイルとしての完全なエスケープ（改行、セミコロン等）は行われないため、特殊文字を含む翻訳値がある場合は注意が必要
- 出力先ディレクトリのパーミッションは0o777で作成される（umaskにより制限される）

## 備考

- 非常にシンプルな実装。str_replace()でダブルクォートをエスケープし、`key="value"\n`形式で文字列連結するのみ
- INIファイルのセクション（`[section]`）は使用されない
- キーにスペースや特殊文字が含まれる場合のエスケープは行われない点に注意
- メタデータは出力に含まれない

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MessageCatalogue.php | `src/Symfony/Component/Translation/MessageCatalogue.php` | all($domain)の戻り値を確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FileDumper.php | `src/Symfony/Component/Translation/Dumper/FileDumper.php` | dump()メソッドの共通処理フロー（41-77行目） |

#### Step 3: INI固有のフォーマット処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IniFileDumper.php | `src/Symfony/Component/Translation/Dumper/IniFileDumper.php` | formatCatalogue()の実装（23-33行目）を確認する |

**主要処理フロー**:
- **25行目**: 出力用空文字列初期化
- **27行目**: all($domain)でメッセージ配列を取得してループ
- **28行目**: `str_replace('"', '\"', $target)` - ダブルクォートエスケープ
- **29行目**: `$source . '="' . $escapeTarget . "\"\n"` - key="value"形式の行を連結

### プログラム呼び出し階層図

```
DumperInterface::dump()
    │
    └─ FileDumper::dump()                          [FileDumper.php:41]
           │
           ├─ MessageCatalogue::getDomains()        [MessageCatalogue.php:42]
           ├─ FileDumper::getRelativePath()          [FileDumper.php:93]
           │      └─ IniFileDumper::getExtension()   [IniFileDumper.php:35]
           └─ IniFileDumper::formatCatalogue()       [IniFileDumper.php:23]
                  │
                  └─ MessageCatalogue::all($domain)   [MessageCatalogue.php:56]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

MessageCatalogue ───────▶ FileDumper::dump()
  └─ messages[domain]           │
                                ├─ ドメインループ
                options ────────▶     │
                  └─ path              ├─ formatCatalogue()
                                      │     │
                                      │     ├─ ダブルクォートエスケープ
                                      │     └─ key="value"連結 ───▶ {domain}.{locale}.ini
                                      │                              （INIテキスト）
                                      └─ file_put_contents()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DumperInterface.php | `src/Symfony/Component/Translation/Dumper/DumperInterface.php` | ソース | Dumperインターフェース定義 |
| FileDumper.php | `src/Symfony/Component/Translation/Dumper/FileDumper.php` | ソース | ファイル出力共通基底クラス |
| IniFileDumper.php | `src/Symfony/Component/Translation/Dumper/IniFileDumper.php` | ソース | INI形式固有のフォーマット処理 |
| MessageCatalogue.php | `src/Symfony/Component/Translation/MessageCatalogue.php` | ソース | メッセージカタログデータ構造 |
| MessageCatalogueInterface.php | `src/Symfony/Component/Translation/MessageCatalogueInterface.php` | ソース | メッセージカタログインターフェース |
