---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-XLIFF翻訳ファイル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **translation:updateコマンドとの連携**：コマンド側のコードは未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Translation/Dumper/XliffFileDumper.php`（1-227行目）
- E-02: `src/Symfony/Component/Translation/Dumper/FileDumper.php`（1-101行目）
- E-03: `src/Symfony/Component/Translation/Dumper/DumperInterface.php`（1-30行目）
- E-04: `src/Symfony/Component/Translation/MessageCatalogue.php`（1-316行目）
- E-05: `src/Symfony/Component/Translation/MessageCatalogueInterface.php`（1-122行目）
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（2行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XliffFileDumperはFileDumperを継承する | E-01 22行目 `class XliffFileDumper extends FileDumper` | ○ |
| C-02 | XLIFF 1.2と2.0に対応 | E-01 31-49行目 xliff_versionの分岐処理 | ○ |
| C-03 | デフォルト拡張子は"xlf" | E-01 25行目 `private string $extension = 'xlf'` | ○ |
| C-04 | pathオプションは必須 | E-02 43-45行目 pathキーの存在チェック | ○ |
| C-05 | ドメインごとにファイルを出力 | E-02 48行目 `foreach ($messages->getDomains() as $domain)` | ○ |
| C-06 | INTL-ICUドメインは別ファイルで出力 | E-02 57-74行目 intlDomain分離処理 | ○ |
| C-07 | relativePathTemplateのデフォルトは`%domain%.%locale%.%extension%` | E-02 31行目 | ○ |
| C-08 | XLIFF 1.2のXML名前空間は`urn:oasis:names:tc:xliff:document:1.2` | E-01 69行目 `$xliff->setAttribute('xmlns', 'urn:oasis:names:tc:xliff:document:1.2')` | ○ |
| C-09 | source-languageはoptions['default_locale']またはLocale::getDefault()から取得 | E-01 36-39行目 | ○ |
| C-10 | target-languageはMessageCatalogue::getLocale()から取得 | E-01 73行目 `$messages->getLocale()` | ○ |
| C-11 | ロケールの`_`は`-`に変換される | E-01 72-73行目 `str_replace('_', '-', ...)` | ○ |
| C-12 | trans-unit IDはxxh128ハッシュのBase64先頭7文字 | E-01 96行目 `strtr(substr(base64_encode(hash('xxh128', $source, true)), 0, 7), '/+', '._')` | ○ |
| C-13 | CDATA判定は`&`, `<`, `>`の存在で行う | E-01 103行目 `preg_match('/[&<>]/', $target)` | ○ |
| C-14 | target-attributes メタデータに対応 | E-01 107-111行目 metadata['target-attributes']の処理 | ○ |
| C-15 | notes メタデータに対応（content, priority, from属性） | E-01 115-132行目 metadata['notes']の処理 | ○ |
| C-16 | カタログメタデータをprop-group/propとして出力 | E-01 83-90行目 getCatalogueMetadata処理 | ○ |
| C-17 | XLIFF 2.0ではunit/segment構造を使用 | E-01 169-194行目 | ○ |
| C-18 | XLIFF 2.0ではname属性は80文字以下の場合のみ設定 | E-01 172-174行目 `if (\strlen($source) <= 80)` | ○ |
| C-19 | XLIFF 2.0ではsegment-attributesメタデータに対応 | E-01 196-200行目 | ○ |
| C-20 | hasMetadataArrayInfo()はis_iterable()で判定 | E-01 223-226行目 | ○ |
| C-21 | ディレクトリ作成時のパーミッションは0o777 | E-02 52行目 `@mkdir($directory, 0o777, true)` | ○ |
| C-22 | ツール情報のデフォルトはtool-id:symfony, tool-name:Symfony | E-01 59行目 | ○ |
| C-23 | サポートされていないバージョンでInvalidArgumentException | E-01 49行目 | ○ |
| C-24 | ディレクトリ作成失敗でRuntimeException | E-02 53行目 | ○ |
| C-25 | translation:updateコマンドから呼び出される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: translation:updateコマンドのソースコードを確認していないため、コマンドからの呼び出しフローは推測に基づく
  - 候補：`src/Symfony/Bundle/FrameworkBundle/Command/TranslationUpdateCommand.php` / Symfony公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる主張がほとんどであり、信頼度は高い
- 1: 中リスク - translation:updateコマンドとの連携部分は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] XLIFF 1.2のXML構造がOASIS標準に準拠しているか確認
- [ ] XLIFF 2.0のXML構造がOASIS標準に準拠しているか確認
- [ ] translation:updateコマンドからのXliffFileDumperの呼び出しフローを確認
- [ ] xxh128ハッシュのBase64エンコーディングの一意性に問題がないか確認
