---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：11-PHP DIコンテナダンプ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足（定量的なベンチマークデータなし）
  2. **OPcacheプリロードの詳細動作**：根拠不足（Preloader.phpの詳細読解が必要）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/DependencyInjection/Dumper/PhpDumper.php` 行1-400
- E-02: `src/Symfony/Component/DependencyInjection/Dumper/Dumper.php` 行1-27
- E-03: `src/Symfony/Component/DependencyInjection/Dumper/PhpDumper.php` 行99-106（コンストラクタ）
- E-04: `src/Symfony/Component/DependencyInjection/Dumper/PhpDumper.php` 行131-151（dump()オプション）
- E-05: `src/Symfony/Component/DependencyInjection/Dumper/PhpDumper.php` 行241-386（as_filesモード）
- E-06: `src/Symfony/Component/DependencyInjection/Dumper/PhpDumper.php` 行54-97（クラスプロパティ）
- E-07: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行12（帳票No.11定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PhpDumperはContainerBuilderを入力として受け取る | E-02（行23-26） | ○ |
| C-02 | コンパイル済みのContainerBuilderが必須 | E-03（行101-103） | ○ |
| C-03 | デフォルトクラス名はProjectServiceContainer | E-04（行139） | ○ |
| C-04 | デフォルト基底クラスはContainer | E-04（行140） | ○ |
| C-05 | as_filesオプションで複数ファイル分割 | E-05（行241-386） | ○ |
| C-06 | OPcacheプリロード用ファイルを生成 | E-05（行313-354） | ○ |
| C-07 | プロキシクラスを生成する | E-01（行216, 230） | ○ |
| C-08 | 環境変数プレースホルダはランタイム解決 | E-01（行396-399） | ○ |
| C-09 | debugオプションでDocBlock制御 | E-06（行76: docStar）, E-04（行189） | ○ |
| C-10 | EnvParameterExceptionがスロー可能 | E-01（行130: throws宣言） | ○ |
| C-11 | LogicExceptionが未コンパイル時にスロー | E-03（行102） | ○ |
| C-12 | コンテナハッシュはContainerBuilder::hash()で計算 | E-05（行298） | ○ |
| C-13 | ビルドIDはCRC32で計算 | E-05（行310） | ○ |
| C-14 | inline_factoriesオプション対応 | E-04（行160-162） | ○ |
| C-15 | inline_class_loaderオプション対応 | E-04（行165-167） | ○ |
| C-16 | サービスIDからメソッド名へのマッピング | E-06（行77: serviceIdToMethodNameMap） | ○ |
| C-17 | removed-ids.phpファイルの生成 | E-05（行264-271） | ○ |
| C-18 | hot_path_tagによる最適化制御 | E-04（行145） | ○ |
| C-19 | パフォーマンス要件として数秒以内の出力 | **根拠なし** | △ |
| C-20 | 約2000行超のコードで構成 | **根拠なし**（ファイルサイズ計測が必要） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の「数秒以内」は経験的な推測であり、ベンチマークデータが存在しない
  - 候補：Symfonyの公式ドキュメント / パフォーマンスベンチマーク / CI結果
- PhpDumperのコード行数は推定値であり、正確な計測が必要
  - 候補：`wc -l`コマンドの実行結果

## 5) リスクフラグ（レビュー観点）
- 0: PhpDumperの基本的な処理フロー記述 -- 低リスク
- 0: エラー処理の記述 -- 低リスク（ソースコードから直接確認可能）
- 1: パフォーマンス要件 -- 中リスク（定量的根拠なし）

## 6) レビュアーチェックリスト（最小）
- [ ] PhpDumperのdump()メソッドのオプション一覧が最新のソースコードと一致しているか
- [ ] as_filesモードの出力ファイル構成が正確か
- [ ] エラーケースの網羅性を確認（ソースコード全体を通読して追加の例外がないか）
- [ ] プロキシクラス生成の詳細がLazyServiceDumperの実装と整合しているか
